from model_utils import Choices

from django.utils.translation import gettext_lazy as _

from .country import COUNTRIES


__all__ = [
    "OTHER_CURRENCIES",
    "MARKETPLACE_CURRENCIES",
    "CURRENCIES",
    "USER_CURRENCIES",
    "INTERNAL_CURRENCIES",
    "CURRENCY_CODE_TO_NAME",
    "CURRENCY_NAME_TO_CODE",
    "CURRENCIES_BY_COUNTRY_CODE",
]


OTHER_CURRENCIES = Choices(
    ("AED", _("Дирхам (Оаэ)")),
    ("AFN", _("Афгани")),
    ("ALL", _("Лек")),
    ("AMD", _("Армянский Драм")),
    ("ANG", _("Нидерландский Антильский Гульден")),
    ("AOA", _("Кванза")),
    ("ARS", _("Аргентинское Песо")),
    ("AWG", _("Арубанский Флорин")),
    ("AZN", _("Азербайджанский Манат")),
    ("BAM", _("Конвертируемая Марка")),
    ("BBD", _("Барбадосский Доллар")),
    ("BDT", _("Така")),
    ("BGN", _("Болгарский Лев")),
    ("BHD", _("Бахрейнский Динар")),
    ("BIF", _("Бурундийский Франк")),
    ("BMD", _("Бермудский Доллар")),
    ("BND", _("Брунейский Доллар")),
    ("BOB", _("Боливиано")),
    ("BRL", _("Бразильский Реал")),
    ("BSD", _("Багамский Доллар")),
    ("BTN", _("Нгултрум")),
    ("BWP", _("Пула")),
    ("BYR", _("Белорусский Рубль")),
    ("BZD", _("Белизский Доллар")),
    ("CDF", _("Конголезский Франк")),
    ("CLP", _("Чилийское Песо")),
    ("COP", _("Колумбийское Песо")),
    ("CRC", _("Костариканский Колон")),
    ("CUP", _("Кубинское Песо")),
    ("CVE", _("Эскудо Кабо-Верде")),
    ("DJF", _("Франк Джибути")),
    ("DOP", _("Доминиканское Песо")),
    ("DZD", _("Алжирский Динар")),
    ("EGP", _("Египетский Фунт")),
    ("ERN", _("Накфа")),
    ("ETB", _("Эфиопский Быр")),
    ("FJD", _("Доллар Фиджи")),
    ("FKP", _("Фунт Фолклендских Островов")),
    ("GEL", _("Ларистанский")),
    ("GHS", _("Седи")),
    ("GIP", _("Гибралтарский Фунт")),
    ("GMD", _("Даласи")),
    ("GNF", _("Гвинейский Франк")),
    ("GTQ", _("Кетсаль")),
    ("GYD", _("Гайанский Доллар")),
    ("HNL", _("Лемпира")),
    ("HRK", _("Куна")),
    ("HTG", _("Гурд")),
    ("IQD", _("Иракский Динар")),
    ("IRR", _("Иранский Риал")),
    ("ISK", _("Исландская Крона")),
    ("JMD", _("Ямайский Доллар")),
    ("JOD", _("Иорданский Динар")),
    ("KES", _("Кенийский Шиллинг")),
    ("KGS", _("Сом")),
    ("KHR", _("Риель")),
    ("KMF", _("Франк Комор")),
    ("KPW", _("Северокорейская Вона")),
    ("KRW", _("Вона")),
    ("KWD", _("Кувейтский Динар")),
    ("KYD", _("Доллар Островов Кайман")),
    ("KZT", _("Тенге")),
    ("LAK", _("Кип")),
    ("LBP", _("Ливанский Фунт")),
    ("LKR", _("Шри-Ланкийская Рупия")),
    ("LRD", _("Либерийский Доллар")),
    ("LSL", _("Лоти")),
    ("LTL", _("Литовский Лит")),
    ("LYD", _("Ливийский Динар")),
    ("MAD", _("Марокканский Дирхам")),
    ("MDL", _("Молдавский Лей")),
    ("MGA", _("Малагасийский Ариари")),
    ("MKD", _("Македонский Денар")),
    ("MMK", _("Кьят")),
    ("MNT", _("Тугрик")),
    ("MOP", _("Патака")),
    ("MRO", _("Угия")),
    ("MUR", _("Маврикийская Рупия")),
    ("MVR", _("Руфия")),
    ("MWK", _("Малавийская Квача")),
    ("MXN", _("Мексиканское Песо")),
    ("MZN", _("Мозамбикский Метикал")),
    ("NAD", _("Доллар Намибии")),
    ("NGN", _("Найра")),
    ("NIO", _("Золотая Кордоба")),
    ("NPR", _("Непальская Рупия")),
    ("OMR", _("Оманский Риал")),
    ("PAB", _("Бальбоа")),
    ("PGK", _("Кина")),
    ("PKR", _("Пакистанская Рупия")),
    ("PYG", _("Гуарани")),
    ("QAR", _("Катарский Риал")),
    ("RON", _("Румынский Лей")),
    ("RSD", _("Сербский Динар")),
    ("RUR", _("Российский Рубль")),
    ("RWF", _("Франк Руанды")),
    ("SAR", _("Саудовский Риял")),
    ("SBD", _("Доллар Соломоновых Островов")),
    ("SCR", _("Сейшельская Рупия")),
    ("SDG", _("Суданский Фунт")),
    ("SHP", _("Фунт Святой Елены")),
    ("SLL", _("Леоне")),
    ("SOS", _("Сомалийский Шиллинг")),
    ("SRD", _("Суринамский Доллар")),
    ("STD", _("Добра")),
    ("SYP", _("Сирийский Фунт")),
    ("SZL", _("Лилангени")),
    ("TJS", _("Сомони")),
    ("TMT", _("Туркменский Новый Манат")),
    ("TND", _("Тунисский Динар")),
    ("TOP", _("Паанга")),
    ("TRY", _("Турецкая Лира")),
    ("TTD", _("Доллар Тринидада И Тобаго")),
    ("TZS", _("Танзанийский Шиллинг")),
    ("UAH", _("Гривна")),
    ("UGX", _("Угандийский Шиллинг")),
    ("UYU", _("Уругвайское Песо")),
    ("UZS", _("Узбекский Сум")),
    ("VEF", _("Боливар")),
    ("VUV", _("Вату")),
    ("WST", _("Тала")),
    ("XAF", _("Франк Кфа Веас")),
    ("XCD", _("Восточно-Карибский Доллар")),
    ("XOF", _("Франк Кфа Всеао")),
    ("XPF", _("Франк Кфп")),
    ("YER", _("Йеменский Риал")),
    ("ZMW", _("Замбийская Квача")),
    ("ZWL", _("Доллар Зимбабве")),
)

MARKETPLACE_CURRENCIES = Choices(
    ("USD", _("Доллар США")),
    ("RUB", _("Российский Рубль")),
    ("EUR", _("Евро")),
    ("GBP", _("Фунт Стерлингов")),
    ("AUD", _("Австралийский Доллар")),
    ("CNY", _("Китайский Юань")),
    ("PLN", _("Злотый")),
    ("CHF", _("Швейцарский Франк")),
    ("JPY", _("Иена")),
    ("IDR", _("Рупия")),
    ("VND", _("Донг")),
    ("NOK", _("Норвежская Крона")),
    ("SGD", _("Сингапурский Доллар")),
    ("SEK", _("Шведская Крона")),
    ("MYR", _("Малайзийский Ринггит")),
    ("THB", _("Бат")),
    ("NZD", _("Новозеландский Доллар")),
    ("HUF", _("Форинт")),
    ("HKD", _("Гонконгский Доллар")),
    ("INR", _("Индийская Рупия")),
    ("PHP", _("Филиппинское Песо")),
    ("DKK", _("Датская Крона")),
    ("TWD", _("Новый Тайваньский Доллар")),
    ("PEN", _("Соль")),
    ("ZAR", _("Рэнд")),
    ("CAD", _("Канадский Доллар")),
    ("CZK", _("Чешская Крона")),
    ("ILS", _("Новый Израильский Шекель")),
)

CURRENCIES = MARKETPLACE_CURRENCIES + OTHER_CURRENCIES

CURRENCY_CODE_TO_NAME = dict(CURRENCIES)

CURRENCY_NAME_TO_CODE = dict((v, k) for k, v in CURRENCY_CODE_TO_NAME.items())

USER_CURRENCIES = CURRENCIES.subset("RUB", "USD")

INTERNAL_CURRENCIES = CURRENCIES.subset("USD", "EUR")

CURRENCIES_BY_COUNTRY_CODE = {
    COUNTRIES.BD: ("BDT",),
    COUNTRIES.BE: ("EUR",),
    COUNTRIES.BF: ("XOF",),
    COUNTRIES.BG: ("BGN",),
    COUNTRIES.BA: ("BAM",),
    COUNTRIES.BB: ("BBD",),
    COUNTRIES.WF: ("XPF",),
    COUNTRIES.BL: ("EUR",),
    COUNTRIES.BM: ("BMD",),
    COUNTRIES.BN: ("BND",),
    COUNTRIES.BO: ("BOB",),
    COUNTRIES.BH: ("BHD",),
    COUNTRIES.BI: ("BIF",),
    COUNTRIES.BJ: ("XOF",),
    COUNTRIES.BT: ("BTN", "INR"),
    COUNTRIES.JM: ("JMD",),
    COUNTRIES.BV: ("NOK",),
    COUNTRIES.BW: ("BWP",),
    COUNTRIES.WS: ("WST",),
    COUNTRIES.BQ: ("USD",),
    COUNTRIES.BR: ("BRL",),
    COUNTRIES.BS: ("BSD",),
    COUNTRIES.JE: ("GBP",),
    COUNTRIES.BY: ("BYR",),
    COUNTRIES.BZ: ("BZD",),
    COUNTRIES.RU: ("RUB",),
    COUNTRIES.RW: ("RWF",),
    COUNTRIES.RS: ("RSD",),
    COUNTRIES.TL: ("USD",),
    COUNTRIES.RE: ("EUR",),
    COUNTRIES.TM: ("TMT",),
    COUNTRIES.TJ: ("TJS",),
    COUNTRIES.RO: ("RON",),
    COUNTRIES.TK: ("NZD",),
    COUNTRIES.GW: ("XOF",),
    COUNTRIES.GU: ("USD",),
    COUNTRIES.GT: ("GTQ",),
    COUNTRIES.GS: ("GBP",),
    COUNTRIES.GR: ("EUR",),
    COUNTRIES.GQ: ("XAF",),
    COUNTRIES.GP: ("EUR",),
    COUNTRIES.JP: ("JPY",),
    COUNTRIES.GY: ("GYD",),
    COUNTRIES.GG: ("GBP",),
    COUNTRIES.GF: ("EUR",),
    COUNTRIES.GE: ("GEL",),
    COUNTRIES.GD: ("XCD",),
    COUNTRIES.GB: ("GBP",),
    COUNTRIES.GA: ("XAF",),
    COUNTRIES.SV: ("USD",),
    COUNTRIES.GN: ("GNF",),
    COUNTRIES.GM: ("GMD",),
    COUNTRIES.GL: ("DKK",),
    COUNTRIES.GI: ("GIP",),
    COUNTRIES.GH: ("GHS",),
    COUNTRIES.OM: ("OMR",),
    COUNTRIES.TN: ("TND",),
    COUNTRIES.IL: ("ILS",),
    COUNTRIES.JO: ("JOD",),
    COUNTRIES.HR: ("HRK",),
    COUNTRIES.HT: ("HTG", "USD"),
    COUNTRIES.HU: ("HUF",),
    COUNTRIES.HK: ("HKD",),
    COUNTRIES.HN: ("HNL",),
    COUNTRIES.HM: ("AUD",),
    COUNTRIES.VE: ("VEF",),
    COUNTRIES.PR: ("USD",),
    COUNTRIES.PS: (),
    COUNTRIES.PW: ("USD",),
    COUNTRIES.PT: ("EUR",),
    COUNTRIES.SJ: ("NOK",),
    COUNTRIES.PY: ("PYG",),
    COUNTRIES.IQ: ("IQD",),
    COUNTRIES.PA: ("PAB", "USD"),
    COUNTRIES.PF: ("XPF",),
    COUNTRIES.PG: ("PGK",),
    COUNTRIES.PE: ("PEN",),
    COUNTRIES.PK: ("PKR",),
    COUNTRIES.PH: ("PHP",),
    COUNTRIES.PN: ("NZD",),
    COUNTRIES.PL: ("PLN",),
    COUNTRIES.PM: ("EUR",),
    COUNTRIES.ZM: ("ZMW",),
    COUNTRIES.EH: ("MAD",),
    COUNTRIES.EE: ("EUR",),
    COUNTRIES.EG: ("EGP",),
    COUNTRIES.ZA: ("ZAR",),
    COUNTRIES.EC: ("USD",),
    COUNTRIES.IT: ("EUR",),
    COUNTRIES.VN: ("VND",),
    COUNTRIES.SB: ("SBD",),
    COUNTRIES.ET: ("ETB",),
    COUNTRIES.SO: ("SOS",),
    COUNTRIES.ZW: ("USD", "ZAR", "BWP", "GBP", "EUR"),
    COUNTRIES.SA: ("SAR",),
    COUNTRIES.ES: ("EUR",),
    COUNTRIES.ER: ("ETB", "ERN"),
    COUNTRIES.ME: ("EUR",),
    COUNTRIES.MD: ("MDL",),
    COUNTRIES.MG: ("MGA",),
    COUNTRIES.MF: ("EUR",),
    COUNTRIES.MA: ("MAD",),
    COUNTRIES.MC: ("EUR",),
    COUNTRIES.UZ: ("UZS",),
    COUNTRIES.MM: ("MMK",),
    COUNTRIES.ML: ("XOF",),
    COUNTRIES.MO: ("MOP",),
    COUNTRIES.MN: ("MNT",),
    COUNTRIES.MH: ("USD",),
    COUNTRIES.MK: ("MKD",),
    COUNTRIES.MU: ("MUR",),
    COUNTRIES.MT: ("EUR",),
    COUNTRIES.MW: ("MWK",),
    COUNTRIES.MV: ("MVR",),
    COUNTRIES.MQ: ("EUR",),
    COUNTRIES.MP: ("USD",),
    COUNTRIES.MS: ("XCD",),
    COUNTRIES.MR: ("MRO",),
    COUNTRIES.IM: ("GBP",),
    COUNTRIES.UG: ("UGX",),
    COUNTRIES.MY: ("MYR",),
    COUNTRIES.MX: ("MXN",),
    COUNTRIES.AT: ("EUR",),
    COUNTRIES.FR: ("EUR",),
    COUNTRIES.IO: ("USD",),
    COUNTRIES.SH: ("SHP",),
    COUNTRIES.FI: ("EUR",),
    COUNTRIES.FJ: ("FJD",),
    COUNTRIES.FK: ("FKP",),
    COUNTRIES.FM: ("USD",),
    COUNTRIES.FO: ("DKK",),
    COUNTRIES.NI: ("NIO",),
    COUNTRIES.NL: ("EUR",),
    COUNTRIES.NO: ("NOK",),
    COUNTRIES.NA: ("NAD", "ZAR"),
    COUNTRIES.NC: ("XPF",),
    COUNTRIES.NE: ("XOF",),
    COUNTRIES.NF: ("AUD",),
    COUNTRIES.NG: ("NGN",),
    COUNTRIES.NZ: ("NZD",),
    COUNTRIES.NP: ("NPR",),
    COUNTRIES.NR: ("AUD",),
    COUNTRIES.NU: ("NZD",),
    COUNTRIES.CK: ("NZD",),
    COUNTRIES.CI: ("XOF",),
    COUNTRIES.CH: ("CHF",),
    COUNTRIES.CO: ("COP",),
    COUNTRIES.CN: ("CNY",),
    COUNTRIES.CM: ("XAF",),
    COUNTRIES.CL: ("CLP",),
    COUNTRIES.CC: ("AUD",),
    COUNTRIES.CA: ("CAD",),
    COUNTRIES.LB: ("LBP",),
    COUNTRIES.CG: ("XAF",),
    COUNTRIES.CF: ("XAF",),
    COUNTRIES.CD: ("CDF",),
    COUNTRIES.CZ: ("CZK",),
    COUNTRIES.CY: ("EUR",),
    COUNTRIES.CX: ("AUD",),
    COUNTRIES.CR: ("CRC",),
    COUNTRIES.CW: ("ANG",),
    COUNTRIES.CV: ("CVE",),
    COUNTRIES.CU: ("CUP", "CUC"),
    COUNTRIES.SZ: ("SZL",),
    COUNTRIES.SY: ("SYP",),
    COUNTRIES.SX: ("ANG",),
    COUNTRIES.KG: ("KGS",),
    COUNTRIES.KE: ("KES",),
    COUNTRIES.SR: ("SRD",),
    COUNTRIES.KI: ("AUD",),
    COUNTRIES.KH: ("KHR",),
    COUNTRIES.KN: ("XCD",),
    COUNTRIES.KM: ("KMF",),
    COUNTRIES.ST: ("STD",),
    COUNTRIES.SK: ("EUR",),
    COUNTRIES.KR: ("KRW",),
    COUNTRIES.SI: ("EUR",),
    COUNTRIES.KP: ("KPW",),
    COUNTRIES.KW: ("KWD",),
    COUNTRIES.SN: ("XOF",),
    COUNTRIES.SM: ("EUR",),
    COUNTRIES.SL: ("SLL",),
    COUNTRIES.SC: ("SCR",),
    COUNTRIES.KZ: ("KZT",),
    COUNTRIES.KY: ("KYD",),
    COUNTRIES.SG: ("SGD",),
    COUNTRIES.SE: ("SEK",),
    COUNTRIES.SD: ("SDG",),
    COUNTRIES.DO: ("DOP",),
    COUNTRIES.DM: ("XCD",),
    COUNTRIES.DJ: ("DJF",),
    COUNTRIES.DK: ("DKK",),
    COUNTRIES.VG: ("USD",),
    COUNTRIES.DE: ("EUR",),
    COUNTRIES.YE: ("YER",),
    COUNTRIES.DZ: ("DZD",),
    COUNTRIES.US: ("USD",),
    COUNTRIES.UY: ("UYU",),
    COUNTRIES.YT: ("EUR",),
    COUNTRIES.UM: ("USD",),
    COUNTRIES.TZ: ("TZS",),
    COUNTRIES.LC: ("XCD",),
    COUNTRIES.LA: ("LAK",),
    COUNTRIES.TV: ("TVD", "AUD"),
    COUNTRIES.TW: ("TWD",),
    COUNTRIES.TT: ("TTD",),
    COUNTRIES.TR: ("TRY",),
    COUNTRIES.LK: ("LKR",),
    COUNTRIES.LI: ("CHF",),
    COUNTRIES.LV: ("EUR",),
    COUNTRIES.TO: ("TOP",),
    COUNTRIES.LT: ("LTL",),
    COUNTRIES.LU: ("EUR",),
    COUNTRIES.LR: ("LRD",),
    COUNTRIES.LS: ("LSL", "ZAR"),
    COUNTRIES.TH: ("THB",),
    COUNTRIES.TF: ("EUR",),
    COUNTRIES.TG: ("XOF",),
    COUNTRIES.TD: ("XAF",),
    COUNTRIES.TC: ("USD",),
    COUNTRIES.LY: ("LYD",),
    COUNTRIES.VA: ("EUR",),
    COUNTRIES.VC: ("XCD",),
    COUNTRIES.AE: ("AED",),
    COUNTRIES.AD: ("EUR",),
    COUNTRIES.AG: ("XCD",),
    COUNTRIES.AF: ("AFN",),
    COUNTRIES.AI: ("XCD",),
    COUNTRIES.VI: ("USD",),
    COUNTRIES.IS: ("ISK",),
    COUNTRIES.IR: ("IRR",),
    COUNTRIES.AM: ("AMD",),
    COUNTRIES.AL: ("ALL",),
    COUNTRIES.AO: ("AOA",),
    COUNTRIES.AN: ("ANG",),
    COUNTRIES.AQ: (),
    COUNTRIES.AS: ("USD",),
    COUNTRIES.AR: ("ARS",),
    COUNTRIES.AU: ("AUD",),
    COUNTRIES.VU: ("VUV",),
    COUNTRIES.AW: ("AWG",),
    COUNTRIES.IN: ("INR",),
    COUNTRIES.AX: ("EUR",),
    COUNTRIES.AZ: ("AZN",),
    COUNTRIES.IE: ("EUR",),
    COUNTRIES.ID: ("IDR",),
    COUNTRIES.UA: ("UAH",),
    COUNTRIES.QA: ("QAR",),
    COUNTRIES.MZ: ("MZN",),
}
