from model_utils import Choices

from django.utils.translation import gettext_lazy as _


__all__ = [
    "USER_LANGUAGES",
    "MARKETPLACE_LANGUAGES",
    "OTHER_LANGUAGES",
    "LANGUAGES",
]


USER_LANGUAGES = Choices(
    ("ru", _("Русский")),
    ("en", _("Английский")),
)


MARKETPLACE_LANGUAGES = Choices(
    ("en", _("Английский")),
    ("ru", _("Русский")),
    ("de", _("Немецкий")),
    ("zh", _("Китайский")),
    ("pl", _("Польский")),
    ("fr", _("Французский")),
    ("it", _("Итальянский")),
    ("pt", _("Португальский")),
    ("es", _("Испанский")),
    ("ja", _("Японский")),
    ("th", _("Тайский")),
    ("nl", _("Голландский")),
)


OTHER_LANGUAGES = Choices(
    ("ab", _("Абхазский")),
    ("aa", _("Афар")),
    ("af", _("Африкаанс")),
    ("ak", _("Акан")),
    ("sq", _("Албанский")),
    ("am", _("Амхарский")),
    ("ar", _("Арабский")),
    ("an", _("Арагонский")),
    ("hy", _("Армянский")),
    ("as", _("Ассамский")),
    ("av", _("Аварский")),
    ("ae", _("Авестийский")),
    ("ay", _("Аймара")),
    ("az", _("Азербайджанский")),
    ("bm", _("Бамбара")),
    ("ba", _("Башкирский")),
    ("eu", _("Баскский")),
    ("be", _("Белорусский")),
    ("bn", _("Бенгальский")),
    ("bh", _("Бихари")),
    ("bi", _("Бислама")),
    ("bs", _("Боснийский")),
    ("br", _("Бретонский")),
    ("bg", _("Болгарский")),
    ("my", _("Бирманский")),
    ("ca", _("Каталанский")),
    ("ch", _("Чаморро")),
    ("ce", _("Чеченский")),
    ("ny", _("Ньянджа")),
    ("cv", _("Чувашский")),
    ("kw", _("Корнский")),
    ("co", _("Корсиканский")),
    ("cr", _("Кри")),
    ("hr", _("Хорватский")),
    ("cs", _("Чешский")),
    ("da", _("Датский")),
    ("dv", _("Дивехи")),
    ("dz", _("Дзонг-Кэ")),
    ("eo", _("Эсперанто")),
    ("et", _("Эстонский")),
    ("ee", _("Эве")),
    ("fo", _("Фарерский")),
    ("fj", _("Фиджи")),
    ("fi", _("Финский")),
    ("ff", _("Фулах")),
    ("gl", _("Галисийский")),
    ("ka", _("Грузинский")),
    ("el", _("Новогреческий (1453-)")),
    ("gn", _("Гуарани")),
    ("gu", _("Гуджарати")),
    ("ht", _("Гаитянский")),
    ("ha", _("Хауса")),
    ("he", _("Иврит")),
    ("hz", _("Гереро")),
    ("hi", _("Хинди")),
    ("ho", _("Хири Моту")),
    ("hu", _("Венгерский")),
    ("ia", _("Интерлингва (Ассоциация Международного Вспомогательного Языка)")),
    ("id", _("Индонезийский")),
    ("ie", _("Интерлингве")),
    ("ga", _("Ирландский")),
    ("ig", _("Игбо")),
    ("ik", _("Инулиак")),
    ("io", _("Идо")),
    ("is", _("Исландский")),
    ("iu", _("Инуктитут")),
    ("jv", _("Яванский")),
    ("kl", _("Калааллисут")),
    ("kn", _("Каннада")),
    ("kr", _("Канури")),
    ("ks", _("Кашмири")),
    ("kk", _("Казахский")),
    ("km", _("Кхмерский Центральный")),
    ("ki", _("Кикуйю")),
    ("rw", _("Киньяруанда")),
    ("ky", _("Киргизский")),
    ("kv", _("Коми")),
    ("kg", _("Конго")),
    ("ko", _("Корейский")),
    ("ku", _("Курдский")),
    ("kj", _("Киньяма")),
    ("la", _("Латынь")),
    ("lb", _("Люксембургский")),
    ("lg", _("Ганда")),
    ("li", _("Лимбурган")),
    ("ln", _("Лингала")),
    ("lo", _("Лаосский")),
    ("lt", _("Литовский")),
    ("lu", _("Луба-Катанга")),
    ("lv", _("Латышский")),
    ("gv", _("Мэнкский")),
    ("mk", _("Македонский")),
    ("mg", _("Малагасийский")),
    ("ms", _("Малайский (Макроязык)")),
    ("ml", _("Малаялам")),
    ("mt", _("Мальтийский")),
    ("mi", _("Маори")),
    ("mr", _("Маратхи")),
    ("mh", _("Маршалльский")),
    ("mn", _("Монгольский")),
    ("na", _("Науру")),
    ("nv", _("Навахо")),
    ("nb", _("Норвежский Букмол")),
    ("nd", _("Северный Ндебеле")),
    ("ne", _("Непальский (макроязык)")),
    ("ng", _("Ндунга")),
    ("nn", _("Норвежский Нюнорск")),
    ("no", _("Норвежский")),
    ("ii", _("Сычуань Йи")),
    ("nr", _("Южный Ндебеле")),
    ("oc", _("Окситанский (пост 1500)")),
    ("oj", _("Оджибва")),
    ("cu", _("Церковнославянский")),
    ("om", _("Оромо")),
    ("or", _("Ория (макроязык)")),
    ("os", _("Осетинский")),
    ("pa", _("Панджаби")),
    ("pi", _("Пали")),
    ("fa", _("Персидский")),
    ("ps", _("Пушту")),
    ("qu", _("Кечуа")),
    ("rm", _("Ретороманский")),
    ("rn", _("Рунди")),
    ("ro", _("Румынский")),
    ("sa", _("Санскрит")),
    ("sc", _("Сардинский")),
    ("sd", _("Синдхи")),
    ("se", _("Северные Саамы")),
    ("sm", _("Самоанский")),
    ("sg", _("Санго")),
    ("sr", _("Сербский")),
    ("gd", _("Шотландский Гэльский")),
    ("sn", _("Шона")),
    ("si", _("Сингальский")),
    ("sk", _("Словацкий")),
    ("sl", _("Словенский")),
    ("so", _("Сомали")),
    ("st", _("Южный Сото")),
    ("su", _("Сунданский")),
    ("sw", _("Суахили (Макроязык)")),
    ("ss", _("Свати")),
    ("sv", _("Шведский")),
    ("ta", _("Тамильский")),
    ("te", _("Телугу")),
    ("tg", _("Таджикский")),
    ("ti", _("Тигринья")),
    ("bo", _("Тибетский")),
    ("tk", _("Туркменский")),
    ("tl", _("Тагальский")),
    ("tn", _("Тсвана")),
    ("to", _("Тонга (Острова Тонга)")),
    ("tr", _("Турецкий")),
    ("ts", _("Тсонга")),
    ("tt", _("Татарский")),
    ("tw", _("Тви")),
    ("ty", _("Таитянский")),
    ("ug", _("Уйгурский")),
    ("uk", _("Украинский")),
    ("ur", _("Урду")),
    ("uz", _("Узбекский")),
    ("ve", _("Венда")),
    ("vi", _("Вьетнамский")),
    ("vo", _("Волапюк")),
    ("wa", _("Валлун")),
    ("cy", _("Валлийский")),
    ("wo", _("Волоф")),
    ("fy", _("Западно-фризский")),
    ("xh", _("Коса")),
    ("yi", _("Идиш")),
    ("yo", _("Йоруба")),
    ("za", _("Чжуан")),
    ("zu", _("Зулусский")),
)

LANGUAGES = MARKETPLACE_LANGUAGES + OTHER_LANGUAGES
