# TODO: обрабатывать случаи окончаний:  "ий" -> "y", "ей" -> "ey" и другие
def transliterate(name: str, space_to_underscore: bool = False):
    mapping = {
        "а": "a",
        "б": "b",
        "в": "v",
        "г": "g",
        "д": "d",
        "е": "e",
        "ё": "e",
        "ж": "zh",
        "з": "z",
        "и": "i",
        "й": "i",
        "к": "k",
        "л": "l",
        "м": "m",
        "н": "n",
        "о": "o",
        "п": "p",
        "р": "r",
        "с": "s",
        "т": "t",
        "у": "u",
        "ф": "f",
        "х": "h",
        "ц": "c",
        "ч": "ch",
        "ш": "sh",
        "щ": "sch",
        "ь": "",
        "ъ": "",
        "ы": "y",
        "э": "e",
        "ю": "u",
        "я": "ya",
        "А": "A",
        "Б": "B",
        "В": "V",
        "Г": "G",
        "Д": "D",
        "Е": "E",
        "Ё": "E",
        "Ж": "Zh",
        "З": "Z",
        "И": "I",
        "Й": "I",
        "К": "K",
        "Л": "L",
        "М": "M",
        "Н": "N",
        "О": "O",
        "П": "P",
        "Р": "R",
        "С": "S",
        "Т": "T",
        "У": "U",
        "Ф": "F",
        "Х": "H",
        "Ц": "C",
        "Ч": "Ch",
        "Ш": "Sh",
        "Щ": "Sch",
        "Ъ": "",
        "Ы": "Y",
        "Ь": "",
        "Э": "E",
        "Ю": "U",
        "Я": "Ya",
        ",": ",",
        "?": "?",
        "~": "~",
        "!": "!",
        "@": "@",
        "#": "#",
        "$": "$",
        "%": "%",
        "^": "^",
        "&": "&",
        "*": "*",
        "(": "(",
        ")": ")",
        "-": "-",
        "=": "=",
        "+": "+",
        ":": ":",
        ";": ";",
        "<": "<",
        ">": ">",
        '"': '"',
        '"': '"',
        "\\": "\\",
        "/": "/",
        "№": "#",
        "[": "[",
        "]": "]",
        "{": "{",
        "}": "}",
        "ґ": "r",
        "ї": "r",
        "є": "e",
        "Ґ": "g",
        "Ї": "i",
        "Є": "e",
        "—": "-",
    }
    if space_to_underscore:
        mapping[" "] = "_"
    if name:
        for key in mapping:
            name = name.replace(key, mapping[key])
    return name
