#!/usr/bin/env python
"""
Color palettes from IPCC WG1

IPCC License
------------
All corresponding colours are from the IPCC WGI github repository:
https://github.com/IPCC-WG1/colormaps

They are taken from Fabio Crameri or Cynthia Brewer.

Copyright (c) 2019, Fabio Crameri. All rights reserved.

Copyright (c) 2002 Cynthia Brewer, Mark Harrower and the Pennsylvania
State University

.. moduleauthor:: Matthias Cuntz

History
    * Written Feb 2024, Matthias Cuntz
    * Copy gree-blue_cat to green-blue_cat, Feb 2024, Matthias Cuntz

"""


__all__ = ['ipcc_categorical', 'ipcc_diverging', 'ipcc_sequential']


# qualitative color maps
# sed 's/^\(.*\) \(.*\) \(.*\)$/                 (\1, \2, \3),/' temp_seq.txt | pbcopy
ipcc_categorical = {
    'bright_cat': [(242, 83, 197),
                   (137, 88, 232),
                   (247, 242, 79),
                   (78, 188, 249),
                   (244, 127, 81),
                   (93, 237, 86)],
    'chem_cat': [(127, 0, 137),
                 (173, 94, 0),
                 (0, 142, 131),
                 (0, 112, 192),
                 (102, 102, 95),
                 (229, 218, 71)],
    'cmip_cat': [(204, 35, 35),
                 (37, 81, 204)],
    'contrast_cat': [(124, 130, 130),
                     (159, 0, 159),
                     (0, 159, 0),
                     (0, 159, 159)],
    'dark_cat': [(221, 84, 46),
                 (33, 52, 219),
                 (53, 165, 197),
                 (170, 24, 24),
                 (8, 46, 114),
                 (236, 156, 46),
                 (50, 127, 81),
                 (128, 54, 168)],
    'gree-blue_cat': [(51, 34, 136),
                      (17, 119, 51),
                      (136, 204, 238),
                      (153, 153, 51),
                      (68, 170, 153),
                      (102, 153, 204)],
    'green-blue_cat': [(51, 34, 136),
                       (17, 119, 51),
                       (136, 204, 238),
                       (153, 153, 51),
                       (68, 170, 153),
                       (102, 153, 204)],
    'rcp_cat': [(153, 0, 2),
                (196, 121, 0),
                (112, 160, 205),
                (0, 52, 102)],
    'red-yellow_cat': [(196, 42, 51),
                       (241, 197, 53),
                       (131, 60, 11),
                       (221, 79, 97),
                       (245, 119, 42)],
    'spectrum_cat': [(127, 68, 170),
                     (48, 79, 191),
                     (54, 156, 232),
                     (36, 147, 126),
                     (236, 209, 81),
                     (237, 128, 55),
                     (204, 64, 74)],
    'ssp_cat_1': [(30, 150, 132),
                  (69, 118, 191),
                  (242, 17, 17),
                  (232, 136, 49),
                  (128, 54, 168)],
    'ssp_cat_2': [(0, 173, 207),
                  (23, 60, 102),
                  (247, 148, 32),
                  (231, 29, 37),
                  (231, 29, 37),
                  (149, 27, 30)]
}


# diverging color maps
# sed -e '/[ ]/s/^\(.*\) \(.*\) \(.*\)$/                    (\1, \2, \3),/' -e "s/^\([^ ]\{2,99\}\)/],    '\1': [/" temp_div_disc.txt | pbcopy
ipcc_diverging = {
    'temp_div': [(5, 48, 97),
                 (6, 49, 98),
                 (7, 51, 100),
                 (8, 53, 102),
                 (9, 55, 104),
                 (11, 57, 106),
                 (12, 59, 108),
                 (13, 61, 110),
                 (14, 63, 112),
                 (15, 65, 114),
                 (17, 67, 116),
                 (18, 69, 118),
                 (19, 71, 120),
                 (20, 73, 121),
                 (22, 75, 123),
                 (23, 77, 125),
                 (24, 79, 127),
                 (25, 81, 129),
                 (26, 82, 131),
                 (28, 84, 133),
                 (29, 86, 135),
                 (30, 88, 137),
                 (31, 90, 139),
                 (32, 92, 141),
                 (34, 94, 143),
                 (35, 96, 145),
                 (36, 98, 146),
                 (37, 100, 148),
                 (39, 102, 150),
                 (40, 104, 152),
                 (41, 106, 154),
                 (42, 108, 156),
                 (43, 110, 158),
                 (45, 112, 160),
                 (46, 113, 162),
                 (47, 115, 164),
                 (48, 117, 166),
                 (49, 119, 168),
                 (51, 121, 170),
                 (52, 123, 171),
                 (53, 125, 173),
                 (54, 127, 175),
                 (56, 129, 177),
                 (57, 131, 179),
                 (58, 133, 181),
                 (59, 135, 183),
                 (60, 137, 185),
                 (62, 139, 187),
                 (63, 141, 189),
                 (64, 143, 191),
                 (65, 145, 193),
                 (67, 147, 195),
                 (69, 148, 195),
                 (71, 149, 196),
                 (74, 150, 197),
                 (76, 152, 197),
                 (78, 153, 198),
                 (81, 155, 199),
                 (83, 156, 199),
                 (86, 157, 200),
                 (88, 159, 201),
                 (90, 160, 202),
                 (93, 161, 202),
                 (95, 163, 203),
                 (97, 164, 204),
                 (100, 165, 204),
                 (102, 166, 205),
                 (105, 168, 206),
                 (107, 169, 207),
                 (109, 171, 207),
                 (112, 172, 208),
                 (114, 173, 209),
                 (116, 175, 209),
                 (119, 176, 210),
                 (121, 177, 211),
                 (124, 179, 211),
                 (126, 180, 212),
                 (128, 181, 213),
                 (131, 183, 214),
                 (133, 184, 214),
                 (135, 185, 215),
                 (138, 187, 216),
                 (140, 188, 216),
                 (143, 189, 217),
                 (145, 191, 218),
                 (147, 192, 219),
                 (150, 193, 219),
                 (152, 195, 220),
                 (155, 196, 221),
                 (157, 197, 221),
                 (159, 198, 222),
                 (162, 200, 223),
                 (164, 201, 223),
                 (166, 203, 224),
                 (169, 204, 225),
                 (171, 205, 226),
                 (174, 207, 226),
                 (176, 208, 227),
                 (178, 209, 228),
                 (181, 211, 228),
                 (183, 212, 229),
                 (185, 213, 230),
                 (188, 214, 230),
                 (190, 216, 231),
                 (193, 217, 232),
                 (195, 219, 233),
                 (197, 220, 233),
                 (200, 221, 234),
                 (202, 223, 235),
                 (204, 224, 235),
                 (207, 225, 236),
                 (209, 227, 237),
                 (212, 228, 238),
                 (214, 229, 238),
                 (216, 230, 239),
                 (219, 232, 240),
                 (221, 233, 240),
                 (224, 235, 241),
                 (226, 236, 242),
                 (228, 237, 243),
                 (231, 239, 243),
                 (233, 240, 244),
                 (235, 241, 245),
                 (238, 243, 245),
                 (240, 244, 246),
                 (243, 245, 247),
                 (245, 246, 247),
                 (247, 248, 248),
                 (248, 248, 247),
                 (248, 246, 245),
                 (247, 243, 243),
                 (247, 242, 241),
                 (246, 240, 238),
                 (246, 238, 236),
                 (246, 235, 234),
                 (245, 234, 232),
                 (245, 232, 229),
                 (244, 230, 227),
                 (244, 227, 225),
                 (243, 226, 223),
                 (243, 224, 220),
                 (242, 222, 218),
                 (242, 220, 216),
                 (241, 218, 214),
                 (241, 216, 211),
                 (240, 214, 209),
                 (240, 211, 207),
                 (240, 210, 205),
                 (239, 208, 202),
                 (239, 206, 200),
                 (238, 203, 198),
                 (238, 202, 196),
                 (237, 200, 193),
                 (237, 198, 191),
                 (236, 195, 189),
                 (236, 194, 187),
                 (235, 192, 184),
                 (235, 190, 182),
                 (235, 187, 180),
                 (234, 186, 178),
                 (234, 184, 175),
                 (233, 181, 173),
                 (233, 179, 171),
                 (232, 178, 169),
                 (232, 176, 166),
                 (231, 174, 164),
                 (231, 172, 162),
                 (230, 170, 160),
                 (230, 168, 157),
                 (230, 166, 155),
                 (229, 163, 153),
                 (229, 162, 151),
                 (228, 160, 148),
                 (228, 158, 146),
                 (227, 156, 144),
                 (227, 154, 142),
                 (226, 152, 139),
                 (226, 149, 137),
                 (225, 147, 135),
                 (225, 146, 133),
                 (224, 144, 130),
                 (224, 142, 128),
                 (224, 140, 126),
                 (223, 138, 124),
                 (223, 135, 121),
                 (222, 134, 119),
                 (222, 132, 117),
                 (221, 130, 115),
                 (221, 128, 112),
                 (220, 125, 110),
                 (220, 124, 108),
                 (219, 121, 106),
                 (219, 120, 103),
                 (219, 118, 101),
                 (218, 115, 99),
                 (218, 113, 97),
                 (217, 112, 94),
                 (217, 110, 92),
                 (216, 108, 90),
                 (216, 105, 88),
                 (215, 104, 85),
                 (215, 102, 83),
                 (214, 100, 81),
                 (214, 97, 79),
                 (214, 96, 76),
                 (211, 94, 76),
                 (209, 92, 75),
                 (207, 90, 74),
                 (205, 88, 73),
                 (203, 86, 72),
                 (200, 84, 71),
                 (198, 82, 70),
                 (196, 80, 69),
                 (194, 79, 68),
                 (192, 77, 67),
                 (190, 75, 67),
                 (187, 73, 66),
                 (185, 71, 65),
                 (183, 69, 64),
                 (181, 67, 63),
                 (179, 65, 62),
                 (177, 64, 61),
                 (174, 62, 60),
                 (172, 60, 59),
                 (170, 58, 58),
                 (168, 56, 58),
                 (166, 54, 57),
                 (163, 52, 56),
                 (161, 50, 55),
                 (159, 48, 54),
                 (157, 47, 53),
                 (155, 45, 52),
                 (153, 43, 51),
                 (150, 41, 50),
                 (148, 39, 49),
                 (146, 37, 49),
                 (144, 35, 48),
                 (142, 33, 47),
                 (140, 32, 46),
                 (137, 30, 45),
                 (135, 28, 44),
                 (133, 26, 43),
                 (131, 24, 42),
                 (129, 22, 41),
                 (126, 20, 40),
                 (124, 18, 40),
                 (122, 16, 39),
                 (120, 15, 38),
                 (118, 13, 37),
                 (116, 11, 36),
                 (113, 9, 35),
                 (111, 7, 34),
                 (109, 5, 33),
                 (107, 3, 32),
                 (105, 1, 31),
                 (103, 0, 31)],
    'prec_div': [(84, 48, 5),
                 (86, 49, 5),
                 (88, 51, 6),
                 (90, 52, 7),
                 (92, 54, 8),
                 (94, 55, 8),
                 (96, 57, 9),
                 (98, 59, 10),
                 (100, 60, 11),
                 (102, 62, 12),
                 (104, 63, 12),
                 (107, 65, 13),
                 (109, 67, 14),
                 (111, 68, 15),
                 (113, 70, 15),
                 (115, 71, 16),
                 (117, 73, 17),
                 (119, 74, 18),
                 (121, 76, 19),
                 (123, 78, 19),
                 (125, 79, 20),
                 (128, 81, 21),
                 (130, 82, 22),
                 (132, 84, 23),
                 (134, 86, 23),
                 (136, 87, 24),
                 (138, 89, 25),
                 (140, 90, 26),
                 (142, 92, 26),
                 (144, 94, 27),
                 (146, 95, 28),
                 (149, 97, 29),
                 (151, 98, 30),
                 (153, 100, 30),
                 (155, 101, 31),
                 (157, 103, 32),
                 (159, 105, 33),
                 (161, 106, 34),
                 (163, 108, 34),
                 (165, 109, 35),
                 (167, 111, 36),
                 (170, 113, 37),
                 (172, 114, 37),
                 (174, 116, 38),
                 (176, 117, 39),
                 (178, 119, 40),
                 (180, 121, 41),
                 (182, 122, 41),
                 (184, 124, 42),
                 (186, 125, 43),
                 (188, 127, 44),
                 (191, 129, 44),
                 (191, 130, 47),
                 (192, 132, 50),
                 (193, 133, 53),
                 (194, 135, 55),
                 (194, 136, 58),
                 (195, 138, 60),
                 (196, 139, 63),
                 (197, 141, 66),
                 (197, 143, 69),
                 (198, 144, 71),
                 (199, 146, 74),
                 (200, 147, 77),
                 (200, 149, 79),
                 (201, 150, 82),
                 (202, 152, 84),
                 (203, 154, 87),
                 (203, 155, 90),
                 (204, 157, 93),
                 (205, 158, 95),
                 (206, 160, 98),
                 (206, 161, 101),
                 (207, 163, 103),
                 (208, 165, 106),
                 (209, 166, 109),
                 (209, 168, 111),
                 (210, 169, 114),
                 (211, 171, 117),
                 (212, 172, 119),
                 (212, 174, 122),
                 (213, 176, 125),
                 (214, 177, 127),
                 (215, 179, 130),
                 (216, 180, 133),
                 (216, 182, 135),
                 (217, 183, 138),
                 (218, 185, 140),
                 (219, 187, 143),
                 (219, 188, 146),
                 (220, 190, 148),
                 (221, 191, 151),
                 (222, 193, 154),
                 (222, 194, 157),
                 (223, 196, 159),
                 (224, 198, 162),
                 (225, 199, 165),
                 (225, 201, 167),
                 (226, 202, 170),
                 (227, 204, 173),
                 (228, 205, 175),
                 (228, 207, 178),
                 (229, 209, 180),
                 (230, 210, 183),
                 (231, 212, 186),
                 (231, 213, 189),
                 (232, 215, 191),
                 (233, 216, 194),
                 (234, 218, 197),
                 (234, 219, 199),
                 (235, 221, 202),
                 (236, 223, 205),
                 (237, 224, 207),
                 (238, 226, 210),
                 (238, 227, 212),
                 (239, 229, 215),
                 (240, 230, 218),
                 (241, 232, 221),
                 (241, 234, 223),
                 (242, 235, 226),
                 (243, 237, 229),
                 (244, 238, 231),
                 (244, 240, 234),
                 (245, 241, 236),
                 (246, 243, 239),
                 (247, 245, 242),
                 (247, 246, 244),
                 (248, 248, 247),
                 (247, 248, 248),
                 (245, 247, 246),
                 (242, 245, 245),
                 (240, 244, 244),
                 (237, 243, 242),
                 (234, 241, 241),
                 (232, 240, 239),
                 (229, 239, 238),
                 (227, 238, 237),
                 (224, 236, 235),
                 (222, 235, 234),
                 (219, 234, 233),
                 (216, 232, 231),
                 (214, 231, 230),
                 (211, 230, 228),
                 (209, 229, 227),
                 (206, 227, 226),
                 (204, 226, 224),
                 (201, 225, 223),
                 (199, 224, 221),
                 (196, 222, 220),
                 (193, 221, 219),
                 (191, 220, 217),
                 (188, 218, 216),
                 (186, 217, 215),
                 (183, 216, 213),
                 (181, 215, 212),
                 (178, 213, 210),
                 (175, 212, 209),
                 (173, 211, 208),
                 (170, 209, 206),
                 (168, 208, 205),
                 (165, 207, 203),
                 (163, 206, 202),
                 (160, 204, 201),
                 (158, 203, 199),
                 (155, 202, 198),
                 (152, 200, 197),
                 (150, 199, 195),
                 (147, 198, 194),
                 (145, 197, 192),
                 (142, 195, 191),
                 (140, 194, 190),
                 (137, 193, 188),
                 (134, 191, 187),
                 (132, 190, 185),
                 (129, 189, 184),
                 (127, 188, 183),
                 (124, 186, 181),
                 (122, 185, 180),
                 (119, 184, 179),
                 (117, 183, 177),
                 (114, 181, 176),
                 (111, 180, 174),
                 (109, 179, 173),
                 (106, 177, 172),
                 (104, 176, 170),
                 (101, 175, 169),
                 (99, 174, 167),
                 (96, 172, 166),
                 (93, 171, 165),
                 (91, 170, 163),
                 (88, 168, 162),
                 (86, 167, 161),
                 (83, 166, 159),
                 (81, 165, 158),
                 (78, 163, 156),
                 (76, 162, 155),
                 (73, 161, 154),
                 (70, 159, 152),
                 (68, 158, 151),
                 (65, 157, 149),
                 (63, 156, 148),
                 (60, 154, 147),
                 (58, 153, 145),
                 (55, 152, 144),
                 (53, 151, 143),
                 (51, 149, 141),
                 (50, 147, 139),
                 (49, 145, 137),
                 (48, 143, 135),
                 (47, 142, 133),
                 (46, 140, 131),
                 (45, 138, 129),
                 (44, 136, 128),
                 (43, 134, 126),
                 (42, 133, 124),
                 (41, 131, 122),
                 (40, 129, 120),
                 (39, 127, 118),
                 (38, 126, 116),
                 (37, 124, 115),
                 (36, 122, 113),
                 (35, 120, 111),
                 (34, 118, 109),
                 (33, 117, 107),
                 (32, 115, 105),
                 (31, 113, 103),
                 (30, 111, 102),
                 (29, 109, 100),
                 (28, 108, 98),
                 (27, 106, 96),
                 (25, 104, 94),
                 (24, 102, 92),
                 (23, 101, 90),
                 (22, 99, 88),
                 (21, 97, 87),
                 (20, 95, 85),
                 (19, 93, 83),
                 (18, 92, 81),
                 (17, 90, 79),
                 (16, 88, 77),
                 (15, 86, 75),
                 (14, 84, 74),
                 (13, 83, 72),
                 (12, 81, 70),
                 (11, 79, 68),
                 (10, 77, 66),
                 (9, 76, 64),
                 (8, 74, 62),
                 (7, 72, 61),
                 (6, 70, 59),
                 (5, 68, 57),
                 (4, 67, 55),
                 (3, 65, 53),
                 (2, 63, 51),
                 (1, 61, 49),
                 (0, 60, 48)],
    'wind_div': [(43, 25, 76),
                 (43, 27, 77),
                 (43, 28, 79),
                 (43, 29, 80),
                 (43, 31, 82),
                 (43, 32, 83),
                 (43, 34, 84),
                 (43, 35, 86),
                 (43, 37, 87),
                 (43, 38, 89),
                 (43, 40, 90),
                 (43, 41, 92),
                 (42, 42, 93),
                 (42, 44, 94),
                 (42, 45, 96),
                 (42, 47, 97),
                 (42, 48, 99),
                 (42, 50, 100),
                 (42, 51, 102),
                 (42, 53, 103),
                 (42, 54, 105),
                 (41, 55, 106),
                 (41, 57, 108),
                 (41, 58, 109),
                 (41, 60, 111),
                 (41, 61, 112),
                 (41, 63, 114),
                 (41, 64, 115),
                 (41, 66, 117),
                 (41, 68, 118),
                 (41, 69, 120),
                 (42, 71, 121),
                 (42, 72, 123),
                 (42, 74, 124),
                 (43, 75, 126),
                 (43, 77, 127),
                 (43, 79, 129),
                 (44, 80, 130),
                 (45, 82, 131),
                 (46, 84, 133),
                 (46, 85, 134),
                 (47, 87, 136),
                 (48, 89, 137),
                 (49, 90, 139),
                 (51, 92, 140),
                 (52, 94, 141),
                 (53, 95, 143),
                 (55, 97, 144),
                 (56, 99, 146),
                 (58, 100, 147),
                 (59, 102, 148),
                 (61, 104, 149),
                 (63, 105, 151),
                 (64, 107, 152),
                 (66, 109, 153),
                 (68, 111, 155),
                 (70, 112, 156),
                 (72, 114, 157),
                 (74, 116, 158),
                 (76, 117, 159),
                 (78, 119, 161),
                 (80, 121, 162),
                 (82, 122, 163),
                 (84, 124, 164),
                 (86, 126, 165),
                 (88, 127, 167),
                 (90, 129, 168),
                 (92, 131, 169),
                 (94, 132, 170),
                 (97, 134, 171),
                 (99, 136, 172),
                 (101, 137, 174),
                 (103, 139, 175),
                 (105, 141, 176),
                 (107, 142, 177),
                 (109, 144, 178),
                 (112, 146, 179),
                 (114, 147, 181),
                 (116, 149, 182),
                 (118, 151, 183),
                 (120, 153, 184),
                 (123, 154, 185),
                 (125, 156, 186),
                 (127, 158, 188),
                 (129, 159, 189),
                 (131, 161, 190),
                 (134, 163, 191),
                 (136, 164, 192),
                 (138, 166, 193),
                 (140, 168, 195),
                 (143, 170, 196),
                 (145, 171, 197),
                 (147, 173, 198),
                 (149, 175, 199),
                 (152, 176, 201),
                 (154, 178, 202),
                 (156, 180, 203),
                 (158, 182, 204),
                 (161, 183, 205),
                 (163, 185, 206),
                 (165, 187, 208),
                 (167, 188, 209),
                 (170, 190, 210),
                 (172, 192, 211),
                 (174, 194, 212),
                 (177, 195, 214),
                 (179, 197, 215),
                 (181, 199, 216),
                 (183, 201, 217),
                 (186, 202, 218),
                 (188, 204, 219),
                 (190, 206, 220),
                 (192, 207, 222),
                 (195, 209, 223),
                 (197, 211, 224),
                 (199, 213, 225),
                 (201, 214, 225),
                 (203, 216, 226),
                 (205, 217, 227),
                 (207, 219, 228),
                 (209, 221, 228),
                 (210, 222, 229),
                 (212, 223, 229),
                 (214, 225, 230),
                 (215, 226, 230),
                 (216, 227, 230),
                 (217, 228, 229),
                 (218, 229, 229),
                 (218, 230, 228),
                 (218, 230, 228),
                 (218, 231, 227),
                 (218, 231, 226),
                 (218, 231, 224),
                 (217, 231, 223),
                 (216, 231, 221),
                 (215, 230, 220),
                 (214, 230, 218),
                 (213, 229, 216),
                 (211, 228, 215),
                 (210, 228, 213),
                 (208, 227, 211),
                 (206, 226, 209),
                 (204, 225, 207),
                 (202, 224, 205),
                 (201, 223, 203),
                 (199, 222, 201),
                 (197, 221, 199),
                 (195, 219, 197),
                 (193, 218, 195),
                 (191, 217, 193),
                 (189, 216, 191),
                 (187, 215, 189),
                 (185, 214, 187),
                 (183, 212, 185),
                 (181, 211, 183),
                 (179, 210, 181),
                 (177, 209, 179),
                 (174, 208, 177),
                 (172, 207, 175),
                 (170, 205, 173),
                 (168, 204, 171),
                 (166, 203, 170),
                 (164, 202, 168),
                 (162, 201, 166),
                 (160, 199, 164),
                 (158, 198, 162),
                 (156, 197, 160),
                 (154, 196, 158),
                 (152, 195, 156),
                 (150, 193, 154),
                 (148, 192, 152),
                 (146, 191, 150),
                 (144, 190, 148),
                 (142, 189, 146),
                 (140, 188, 144),
                 (138, 186, 142),
                 (136, 185, 140),
                 (134, 184, 138),
                 (132, 183, 137),
                 (130, 182, 135),
                 (128, 181, 133),
                 (126, 179, 131),
                 (124, 178, 129),
                 (122, 177, 127),
                 (120, 176, 125),
                 (118, 175, 123),
                 (116, 173, 121),
                 (114, 172, 119),
                 (112, 171, 117),
                 (111, 170, 115),
                 (109, 169, 113),
                 (107, 167, 111),
                 (105, 166, 109),
                 (103, 165, 107),
                 (101, 164, 105),
                 (99, 162, 103),
                 (97, 161, 101),
                 (95, 160, 99),
                 (93, 158, 97),
                 (91, 157, 95),
                 (89, 155, 93),
                 (88, 154, 91),
                 (86, 153, 89),
                 (84, 151, 87),
                 (82, 150, 84),
                 (81, 148, 82),
                 (79, 146, 80),
                 (78, 145, 78),
                 (76, 143, 76),
                 (75, 141, 73),
                 (73, 140, 71),
                 (72, 138, 69),
                 (71, 136, 67),
                 (70, 135, 65),
                 (69, 133, 62),
                 (68, 131, 60),
                 (68, 129, 58),
                 (67, 128, 56),
                 (66, 126, 54),
                 (66, 124, 52),
                 (65, 123, 51),
                 (65, 121, 49),
                 (65, 119, 47),
                 (64, 118, 45),
                 (64, 116, 44),
                 (64, 115, 42),
                 (64, 113, 40),
                 (64, 112, 39),
                 (64, 110, 37),
                 (64, 109, 36),
                 (64, 107, 34),
                 (64, 106, 33),
                 (64, 105, 32),
                 (64, 103, 30),
                 (64, 102, 29),
                 (64, 101, 28),
                 (64, 99, 26),
                 (65, 98, 25),
                 (65, 97, 24),
                 (65, 95, 22),
                 (65, 94, 21),
                 (65, 93, 20),
                 (65, 92, 18),
                 (65, 90, 17),
                 (65, 89, 16),
                 (65, 88, 15),
                 (65, 87, 13),
                 (66, 86, 12),
                 (66, 84, 11),
                 (66, 83, 9),
                 (66, 82, 8),
                 (66, 81, 7),
                 (66, 80, 5),
                 (66, 78, 4),
                 (66, 77, 3),
                 (66, 76, 2)],
    'cryo_div': [(38, 38, 0),
                 (39, 39, 2),
                 (41, 41, 3),
                 (42, 42, 5),
                 (44, 44, 6),
                 (45, 46, 8),
                 (47, 47, 9),
                 (48, 49, 11),
                 (50, 50, 12),
                 (52, 52, 13),
                 (53, 54, 14),
                 (55, 55, 16),
                 (57, 57, 17),
                 (58, 58, 18),
                 (60, 60, 19),
                 (62, 62, 20),
                 (63, 64, 22),
                 (65, 65, 23),
                 (67, 67, 24),
                 (69, 69, 26),
                 (70, 70, 27),
                 (72, 72, 29),
                 (74, 74, 30),
                 (76, 76, 31),
                 (78, 78, 33),
                 (79, 79, 34),
                 (81, 81, 36),
                 (83, 83, 37),
                 (85, 85, 39),
                 (87, 87, 40),
                 (89, 89, 42),
                 (90, 90, 43),
                 (92, 92, 45),
                 (94, 94, 46),
                 (96, 96, 48),
                 (98, 98, 50),
                 (100, 100, 51),
                 (102, 102, 53),
                 (104, 104, 54),
                 (105, 105, 56),
                 (107, 107, 57),
                 (109, 109, 59),
                 (111, 111, 61),
                 (113, 113, 62),
                 (115, 115, 64),
                 (117, 117, 65),
                 (119, 119, 67),
                 (121, 121, 69),
                 (123, 123, 70),
                 (125, 125, 72),
                 (127, 127, 74),
                 (129, 129, 75),
                 (131, 131, 77),
                 (133, 133, 79),
                 (135, 135, 80),
                 (137, 137, 82),
                 (139, 139, 84),
                 (141, 141, 85),
                 (143, 143, 87),
                 (145, 145, 89),
                 (147, 147, 90),
                 (149, 149, 92),
                 (151, 151, 94),
                 (153, 153, 95),
                 (155, 155, 97),
                 (157, 157, 99),
                 (159, 159, 101),
                 (161, 161, 103),
                 (163, 163, 105),
                 (165, 165, 106),
                 (167, 167, 108),
                 (169, 169, 110),
                 (171, 171, 112),
                 (173, 173, 114),
                 (175, 175, 117),
                 (177, 177, 119),
                 (179, 179, 121),
                 (181, 181, 123),
                 (183, 183, 125),
                 (185, 185, 128),
                 (187, 187, 130),
                 (189, 189, 133),
                 (191, 191, 135),
                 (193, 193, 137),
                 (195, 194, 140),
                 (196, 196, 142),
                 (198, 198, 145),
                 (199, 199, 147),
                 (201, 201, 150),
                 (202, 202, 152),
                 (204, 204, 155),
                 (205, 205, 157),
                 (207, 206, 159),
                 (208, 208, 162),
                 (209, 209, 164),
                 (210, 210, 167),
                 (212, 212, 169),
                 (213, 213, 171),
                 (214, 214, 174),
                 (215, 215, 176),
                 (217, 216, 179),
                 (218, 218, 181),
                 (219, 219, 183),
                 (220, 220, 186),
                 (221, 221, 188),
                 (223, 222, 190),
                 (224, 224, 193),
                 (225, 225, 195),
                 (226, 226, 198),
                 (227, 227, 200),
                 (228, 228, 202),
                 (229, 229, 205),
                 (231, 230, 207),
                 (232, 232, 209),
                 (233, 233, 212),
                 (234, 234, 214),
                 (234, 235, 216),
                 (235, 235, 218),
                 (236, 236, 221),
                 (236, 237, 223),
                 (237, 238, 225),
                 (237, 238, 227),
                 (237, 239, 228),
                 (237, 239, 230),
                 (237, 239, 232),
                 (237, 239, 233),
                 (236, 238, 234),
                 (235, 238, 235),
                 (234, 237, 236),
                 (232, 237, 236),
                 (231, 236, 236),
                 (229, 234, 237),
                 (227, 233, 236),
                 (225, 232, 236),
                 (223, 230, 236),
                 (221, 229, 235),
                 (219, 227, 234),
                 (217, 226, 233),
                 (214, 224, 233),
                 (212, 222, 232),
                 (210, 220, 231),
                 (207, 219, 229),
                 (205, 217, 228),
                 (203, 215, 227),
                 (200, 213, 226),
                 (198, 212, 225),
                 (195, 210, 223),
                 (193, 208, 222),
                 (191, 206, 221),
                 (188, 204, 220),
                 (186, 202, 218),
                 (183, 201, 217),
                 (181, 199, 216),
                 (179, 197, 215),
                 (176, 195, 213),
                 (174, 193, 212),
                 (171, 192, 211),
                 (169, 190, 210),
                 (167, 188, 208),
                 (164, 186, 207),
                 (162, 184, 206),
                 (160, 183, 205),
                 (157, 181, 203),
                 (155, 179, 202),
                 (152, 177, 201),
                 (150, 175, 200),
                 (148, 174, 199),
                 (145, 172, 197),
                 (143, 170, 196),
                 (141, 168, 195),
                 (138, 166, 194),
                 (136, 165, 192),
                 (134, 163, 191),
                 (131, 161, 190),
                 (129, 159, 189),
                 (127, 158, 187),
                 (124, 156, 186),
                 (122, 154, 185),
                 (120, 152, 184),
                 (117, 150, 183),
                 (115, 149, 181),
                 (113, 147, 180),
                 (111, 145, 179),
                 (108, 143, 178),
                 (106, 142, 177),
                 (104, 140, 175),
                 (101, 138, 174),
                 (99, 136, 173),
                 (97, 135, 172),
                 (95, 133, 170),
                 (92, 131, 169),
                 (90, 130, 168),
                 (88, 128, 167),
                 (86, 126, 166),
                 (84, 124, 164),
                 (81, 123, 163),
                 (79, 121, 162),
                 (77, 119, 161),
                 (75, 117, 160),
                 (73, 116, 158),
                 (71, 114, 157),
                 (68, 112, 156),
                 (66, 110, 155),
                 (64, 109, 153),
                 (62, 107, 152),
                 (60, 105, 151),
                 (58, 104, 150),
                 (57, 102, 148),
                 (55, 100, 147),
                 (53, 98, 146),
                 (52, 97, 144),
                 (50, 95, 143),
                 (49, 93, 141),
                 (47, 91, 140),
                 (46, 90, 138),
                 (45, 88, 137),
                 (44, 86, 135),
                 (43, 84, 134),
                 (42, 83, 132),
                 (42, 81, 131),
                 (41, 79, 129),
                 (41, 78, 128),
                 (40, 76, 126),
                 (40, 74, 125),
                 (40, 73, 123),
                 (40, 71, 122),
                 (40, 69, 120),
                 (40, 68, 118),
                 (40, 66, 117),
                 (40, 64, 115),
                 (40, 63, 114),
                 (40, 61, 112),
                 (40, 60, 111),
                 (40, 58, 109),
                 (40, 57, 107),
                 (41, 55, 106),
                 (41, 54, 104),
                 (41, 52, 103),
                 (41, 50, 101),
                 (41, 49, 100),
                 (41, 47, 98),
                 (42, 46, 97),
                 (42, 44, 95),
                 (42, 43, 94),
                 (42, 42, 92),
                 (42, 40, 91),
                 (42, 39, 89),
                 (42, 37, 88),
                 (43, 36, 86),
                 (43, 34, 85),
                 (43, 33, 83),
                 (43, 31, 82),
                 (43, 30, 80),
                 (43, 28, 79),
                 (43, 27, 77),
                 (43, 25, 76)],
    'chem_div': [(0, 68, 57),
                 (1, 70, 57),
                 (3, 72, 58),
                 (5, 74, 59),
                 (7, 76, 60),
                 (8, 78, 60),
                 (10, 80, 61),
                 (12, 82, 62),
                 (14, 84, 63),
                 (15, 86, 64),
                 (17, 88, 64),
                 (19, 90, 65),
                 (21, 92, 66),
                 (22, 95, 67),
                 (24, 97, 67),
                 (26, 99, 68),
                 (28, 101, 69),
                 (30, 103, 70),
                 (31, 105, 71),
                 (33, 107, 71),
                 (35, 109, 72),
                 (37, 111, 73),
                 (38, 113, 74),
                 (40, 115, 75),
                 (42, 117, 75),
                 (44, 119, 76),
                 (45, 122, 77),
                 (47, 124, 78),
                 (49, 126, 78),
                 (51, 128, 79),
                 (52, 130, 80),
                 (54, 132, 81),
                 (56, 134, 82),
                 (58, 136, 82),
                 (60, 138, 83),
                 (61, 140, 84),
                 (63, 142, 85),
                 (65, 144, 86),
                 (67, 146, 86),
                 (68, 149, 87),
                 (70, 151, 88),
                 (72, 153, 89),
                 (74, 155, 89),
                 (75, 157, 90),
                 (77, 159, 91),
                 (79, 161, 92),
                 (81, 163, 93),
                 (82, 165, 93),
                 (84, 167, 94),
                 (86, 169, 95),
                 (88, 171, 96),
                 (90, 174, 97),
                 (92, 174, 98),
                 (94, 175, 100),
                 (96, 176, 102),
                 (98, 177, 104),
                 (100, 178, 106),
                 (102, 179, 108),
                 (104, 180, 110),
                 (106, 181, 112),
                 (108, 182, 114),
                 (110, 183, 116),
                 (112, 184, 118),
                 (114, 185, 120),
                 (117, 186, 122),
                 (119, 187, 124),
                 (121, 188, 126),
                 (123, 189, 128),
                 (125, 190, 130),
                 (127, 191, 132),
                 (129, 192, 134),
                 (131, 193, 136),
                 (133, 194, 138),
                 (135, 195, 140),
                 (137, 196, 142),
                 (139, 197, 144),
                 (141, 198, 146),
                 (144, 199, 148),
                 (146, 200, 150),
                 (148, 201, 152),
                 (150, 202, 154),
                 (152, 203, 156),
                 (154, 204, 158),
                 (156, 205, 160),
                 (158, 206, 162),
                 (160, 207, 164),
                 (162, 208, 166),
                 (164, 209, 168),
                 (166, 210, 170),
                 (168, 211, 172),
                 (171, 212, 174),
                 (173, 213, 176),
                 (175, 214, 178),
                 (177, 215, 180),
                 (179, 216, 182),
                 (181, 217, 184),
                 (183, 218, 186),
                 (185, 219, 188),
                 (187, 220, 190),
                 (189, 221, 192),
                 (191, 222, 194),
                 (193, 223, 196),
                 (195, 224, 198),
                 (198, 224, 200),
                 (200, 225, 202),
                 (202, 226, 204),
                 (204, 227, 206),
                 (206, 228, 208),
                 (208, 229, 210),
                 (210, 230, 212),
                 (212, 231, 214),
                 (214, 232, 216),
                 (216, 233, 218),
                 (218, 234, 220),
                 (220, 235, 222),
                 (223, 236, 224),
                 (225, 237, 226),
                 (227, 238, 228),
                 (229, 239, 230),
                 (231, 240, 232),
                 (233, 241, 234),
                 (235, 242, 236),
                 (237, 243, 238),
                 (239, 244, 240),
                 (241, 245, 242),
                 (243, 246, 244),
                 (245, 247, 246),
                 (247, 248, 248),
                 (248, 248, 248),
                 (247, 246, 247),
                 (245, 244, 246),
                 (244, 242, 245),
                 (243, 240, 244),
                 (242, 239, 243),
                 (240, 237, 242),
                 (239, 235, 241),
                 (238, 233, 240),
                 (237, 231, 239),
                 (235, 230, 238),
                 (234, 228, 237),
                 (233, 226, 236),
                 (232, 224, 235),
                 (230, 223, 234),
                 (229, 221, 233),
                 (228, 219, 232),
                 (227, 217, 231),
                 (225, 215, 230),
                 (224, 214, 229),
                 (223, 212, 228),
                 (222, 210, 227),
                 (220, 208, 226),
                 (219, 206, 225),
                 (218, 205, 224),
                 (217, 203, 223),
                 (215, 201, 221),
                 (214, 199, 220),
                 (213, 197, 219),
                 (211, 196, 218),
                 (210, 194, 217),
                 (209, 192, 216),
                 (208, 190, 215),
                 (206, 189, 214),
                 (205, 187, 213),
                 (204, 185, 212),
                 (203, 183, 211),
                 (201, 181, 210),
                 (200, 180, 209),
                 (199, 178, 208),
                 (198, 176, 207),
                 (196, 174, 206),
                 (195, 172, 205),
                 (194, 171, 204),
                 (193, 169, 203),
                 (191, 167, 202),
                 (190, 165, 201),
                 (189, 163, 200),
                 (188, 162, 199),
                 (186, 160, 198),
                 (185, 158, 197),
                 (184, 156, 196),
                 (183, 154, 195),
                 (181, 153, 194),
                 (180, 151, 193),
                 (179, 149, 192),
                 (178, 147, 191),
                 (176, 146, 190),
                 (175, 144, 189),
                 (174, 142, 188),
                 (173, 140, 187),
                 (171, 138, 186),
                 (170, 137, 185),
                 (169, 135, 184),
                 (168, 133, 183),
                 (166, 131, 182),
                 (165, 129, 181),
                 (164, 128, 180),
                 (163, 126, 179),
                 (161, 124, 178),
                 (160, 122, 177),
                 (159, 120, 176),
                 (158, 119, 175),
                 (156, 117, 174),
                 (155, 115, 173),
                 (154, 113, 172),
                 (153, 112, 171),
                 (151, 109, 169),
                 (149, 107, 167),
                 (147, 105, 165),
                 (146, 103, 163),
                 (144, 101, 161),
                 (142, 98, 159),
                 (140, 96, 157),
                 (139, 94, 155),
                 (137, 92, 154),
                 (135, 90, 152),
                 (133, 87, 150),
                 (132, 85, 148),
                 (130, 83, 146),
                 (128, 81, 144),
                 (126, 79, 142),
                 (125, 76, 140),
                 (123, 74, 139),
                 (121, 72, 137),
                 (119, 70, 135),
                 (118, 68, 133),
                 (116, 65, 131),
                 (114, 63, 129),
                 (112, 61, 127),
                 (111, 59, 125),
                 (109, 57, 123),
                 (107, 54, 122),
                 (105, 52, 120),
                 (104, 50, 118),
                 (102, 48, 116),
                 (100, 46, 114),
                 (98, 43, 112),
                 (97, 41, 110),
                 (95, 39, 108),
                 (93, 37, 107),
                 (91, 35, 105),
                 (90, 32, 103),
                 (88, 30, 101),
                 (86, 28, 99),
                 (84, 26, 97),
                 (83, 24, 95),
                 (81, 21, 93),
                 (79, 19, 91),
                 (77, 17, 90),
                 (76, 15, 88),
                 (74, 13, 86),
                 (72, 10, 84),
                 (70, 8, 82),
                 (69, 6, 80),
                 (67, 4, 78),
                 (65, 2, 76),
                 (64, 0, 75)],
    'slev_div': [(2, 71, 104),
                 (3, 72, 105),
                 (4, 74, 107),
                 (6, 76, 109),
                 (7, 78, 111),
                 (8, 79, 113),
                 (10, 81, 115),
                 (11, 83, 117),
                 (12, 85, 119),
                 (14, 86, 121),
                 (15, 88, 123),
                 (17, 90, 125),
                 (18, 92, 127),
                 (19, 94, 129),
                 (21, 95, 131),
                 (22, 97, 133),
                 (23, 99, 135),
                 (25, 101, 137),
                 (26, 102, 139),
                 (27, 104, 141),
                 (29, 106, 143),
                 (30, 108, 145),
                 (32, 109, 147),
                 (33, 111, 149),
                 (34, 113, 151),
                 (36, 115, 153),
                 (37, 117, 154),
                 (38, 118, 156),
                 (40, 120, 158),
                 (41, 122, 160),
                 (42, 124, 162),
                 (44, 125, 164),
                 (45, 127, 166),
                 (47, 129, 168),
                 (48, 131, 170),
                 (49, 133, 172),
                 (51, 134, 174),
                 (52, 136, 176),
                 (53, 138, 178),
                 (55, 140, 180),
                 (56, 141, 182),
                 (57, 143, 184),
                 (59, 145, 186),
                 (60, 147, 188),
                 (62, 148, 190),
                 (63, 150, 192),
                 (64, 152, 194),
                 (66, 154, 196),
                 (67, 156, 198),
                 (68, 157, 200),
                 (70, 159, 202),
                 (71, 161, 204),
                 (72, 163, 205),
                 (74, 164, 207),
                 (75, 166, 209),
                 (77, 168, 211),
                 (78, 170, 213),
                 (79, 172, 215),
                 (81, 173, 217),
                 (82, 175, 219),
                 (83, 177, 221),
                 (85, 179, 223),
                 (86, 180, 225),
                 (87, 182, 227),
                 (89, 184, 229),
                 (92, 185, 229),
                 (94, 186, 229),
                 (97, 187, 230),
                 (99, 188, 230),
                 (102, 189, 230),
                 (104, 190, 230),
                 (107, 191, 231),
                 (109, 192, 231),
                 (112, 193, 231),
                 (114, 194, 232),
                 (117, 195, 232),
                 (119, 196, 232),
                 (122, 197, 233),
                 (124, 198, 233),
                 (127, 199, 233),
                 (129, 200, 234),
                 (132, 201, 234),
                 (134, 202, 234),
                 (137, 203, 235),
                 (139, 204, 235),
                 (142, 205, 235),
                 (144, 206, 235),
                 (147, 207, 236),
                 (149, 208, 236),
                 (152, 209, 236),
                 (154, 210, 237),
                 (157, 211, 237),
                 (159, 212, 237),
                 (162, 213, 238),
                 (164, 214, 238),
                 (167, 215, 238),
                 (169, 216, 239),
                 (172, 217, 239),
                 (174, 218, 239),
                 (177, 219, 240),
                 (179, 220, 240),
                 (182, 221, 240),
                 (185, 223, 241),
                 (187, 224, 241),
                 (190, 225, 241),
                 (192, 226, 241),
                 (195, 227, 242),
                 (197, 228, 242),
                 (200, 229, 242),
                 (202, 230, 243),
                 (205, 231, 243),
                 (207, 232, 243),
                 (210, 233, 244),
                 (212, 234, 244),
                 (215, 235, 244),
                 (217, 236, 245),
                 (220, 237, 245),
                 (222, 238, 245),
                 (225, 239, 246),
                 (227, 240, 246),
                 (230, 241, 246),
                 (232, 242, 246),
                 (235, 243, 247),
                 (237, 244, 247),
                 (240, 245, 247),
                 (242, 246, 248),
                 (245, 247, 248),
                 (247, 248, 248),
                 (248, 248, 247),
                 (248, 246, 244),
                 (248, 245, 240),
                 (248, 244, 237),
                 (248, 242, 234),
                 (247, 241, 231),
                 (247, 239, 227),
                 (247, 238, 224),
                 (247, 237, 221),
                 (247, 235, 218),
                 (246, 234, 214),
                 (246, 232, 211),
                 (246, 231, 208),
                 (246, 229, 205),
                 (246, 228, 201),
                 (245, 227, 198),
                 (245, 225, 195),
                 (245, 224, 192),
                 (245, 222, 188),
                 (245, 221, 185),
                 (244, 220, 182),
                 (244, 218, 179),
                 (244, 217, 175),
                 (244, 215, 172),
                 (244, 214, 169),
                 (243, 212, 166),
                 (243, 211, 162),
                 (243, 210, 159),
                 (243, 208, 156),
                 (242, 207, 153),
                 (242, 205, 149),
                 (242, 204, 146),
                 (242, 203, 143),
                 (242, 201, 140),
                 (241, 200, 136),
                 (241, 198, 133),
                 (241, 197, 130),
                 (241, 196, 127),
                 (241, 194, 123),
                 (240, 193, 120),
                 (240, 191, 117),
                 (240, 190, 114),
                 (240, 189, 111),
                 (240, 187, 107),
                 (239, 186, 104),
                 (239, 184, 101),
                 (239, 183, 98),
                 (239, 181, 94),
                 (239, 180, 91),
                 (238, 179, 88),
                 (238, 177, 85),
                 (238, 176, 81),
                 (238, 174, 78),
                 (238, 173, 75),
                 (237, 172, 72),
                 (237, 170, 68),
                 (237, 169, 65),
                 (237, 167, 62),
                 (237, 166, 59),
                 (236, 164, 55),
                 (236, 163, 52),
                 (236, 162, 49),
                 (236, 160, 46),
                 (236, 159, 42),
                 (234, 157, 41),
                 (231, 156, 41),
                 (229, 154, 41),
                 (226, 152, 41),
                 (224, 151, 41),
                 (221, 149, 41),
                 (219, 148, 41),
                 (217, 146, 40),
                 (214, 144, 40),
                 (212, 143, 40),
                 (209, 141, 40),
                 (207, 140, 40),
                 (204, 138, 40),
                 (202, 136, 40),
                 (199, 135, 39),
                 (197, 133, 39),
                 (195, 131, 39),
                 (192, 130, 39),
                 (190, 128, 39),
                 (187, 127, 39),
                 (185, 125, 39),
                 (182, 123, 38),
                 (180, 122, 38),
                 (177, 120, 38),
                 (175, 119, 38),
                 (172, 117, 38),
                 (170, 115, 38),
                 (168, 114, 38),
                 (165, 112, 37),
                 (163, 110, 37),
                 (160, 109, 37),
                 (158, 107, 37),
                 (155, 106, 37),
                 (153, 104, 37),
                 (150, 102, 37),
                 (148, 101, 36),
                 (146, 99, 36),
                 (143, 98, 36),
                 (141, 96, 36),
                 (138, 94, 36),
                 (136, 93, 36),
                 (133, 91, 36),
                 (131, 89, 35),
                 (128, 88, 35),
                 (126, 86, 35),
                 (124, 85, 35),
                 (121, 83, 35),
                 (119, 81, 35),
                 (116, 80, 35),
                 (114, 78, 34),
                 (111, 77, 34),
                 (109, 75, 34),
                 (106, 73, 34),
                 (104, 72, 34),
                 (102, 70, 34),
                 (99, 68, 34),
                 (97, 67, 33),
                 (94, 65, 33),
                 (92, 64, 33),
                 (89, 62, 33),
                 (87, 60, 33),
                 (84, 59, 33),
                 (82, 57, 33),
                 (80, 56, 33)],
    'misc_div': [(8, 29, 88),
                 (9, 30, 91),
                 (11, 31, 95),
                 (13, 33, 99),
                 (15, 34, 103),
                 (17, 36, 106),
                 (18, 37, 110),
                 (20, 39, 114),
                 (22, 40, 118),
                 (24, 42, 121),
                 (26, 43, 125),
                 (28, 44, 129),
                 (29, 46, 133),
                 (31, 47, 137),
                 (33, 49, 140),
                 (35, 50, 144),
                 (36, 52, 148),
                 (36, 54, 149),
                 (36, 57, 150),
                 (36, 60, 151),
                 (36, 62, 153),
                 (36, 65, 154),
                 (35, 68, 155),
                 (35, 70, 156),
                 (35, 73, 158),
                 (35, 76, 159),
                 (35, 78, 160),
                 (34, 81, 161),
                 (34, 83, 163),
                 (34, 86, 164),
                 (34, 89, 165),
                 (34, 91, 166),
                 (33, 94, 168),
                 (33, 97, 169),
                 (33, 101, 171),
                 (32, 104, 172),
                 (32, 107, 174),
                 (32, 110, 175),
                 (32, 113, 177),
                 (31, 117, 178),
                 (31, 120, 180),
                 (31, 123, 181),
                 (30, 126, 183),
                 (30, 129, 184),
                 (30, 133, 186),
                 (29, 136, 187),
                 (29, 139, 189),
                 (29, 142, 190),
                 (29, 145, 192),
                 (31, 147, 192),
                 (34, 150, 192),
                 (36, 152, 192),
                 (38, 154, 193),
                 (40, 157, 193),
                 (43, 159, 193),
                 (45, 161, 193),
                 (47, 164, 194),
                 (50, 166, 194),
                 (52, 168, 194),
                 (54, 171, 194),
                 (56, 173, 195),
                 (59, 175, 195),
                 (61, 178, 195),
                 (63, 180, 195),
                 (66, 182, 195),
                 (70, 183, 195),
                 (74, 185, 194),
                 (78, 186, 194),
                 (82, 188, 193),
                 (85, 189, 192),
                 (89, 191, 192),
                 (93, 192, 191),
                 (97, 194, 191),
                 (101, 195, 190),
                 (105, 197, 190),
                 (109, 198, 189),
                 (113, 199, 188),
                 (117, 201, 188),
                 (121, 202, 187),
                 (124, 204, 187),
                 (129, 205, 186),
                 (133, 207, 186),
                 (138, 209, 185),
                 (142, 211, 185),
                 (147, 212, 185),
                 (151, 214, 184),
                 (156, 216, 184),
                 (160, 218, 183),
                 (165, 219, 183),
                 (169, 221, 182),
                 (174, 223, 182),
                 (178, 225, 181),
                 (183, 226, 181),
                 (187, 228, 181),
                 (192, 230, 180),
                 (197, 232, 180),
                 (200, 233, 179),
                 (202, 234, 179),
                 (205, 235, 179),
                 (207, 236, 179),
                 (209, 237, 179),
                 (212, 238, 178),
                 (214, 239, 178),
                 (217, 240, 178),
                 (219, 241, 178),
                 (221, 242, 178),
                 (224, 242, 178),
                 (226, 243, 177),
                 (229, 244, 177),
                 (231, 245, 177),
                 (233, 246, 177),
                 (236, 247, 177),
                 (237, 248, 178),
                 (238, 248, 181),
                 (240, 249, 183),
                 (241, 249, 186),
                 (242, 250, 188),
                 (243, 250, 191),
                 (244, 250, 193),
                 (245, 251, 196),
                 (246, 251, 198),
                 (247, 252, 201),
                 (249, 252, 203),
                 (250, 253, 206),
                 (251, 253, 208),
                 (252, 254, 211),
                 (253, 254, 213),
                 (254, 254, 216),
                 (255, 254, 203),
                 (255, 253, 200),
                 (255, 252, 197),
                 (255, 251, 195),
                 (255, 250, 192),
                 (255, 249, 189),
                 (255, 247, 186),
                 (255, 246, 183),
                 (255, 245, 181),
                 (255, 244, 178),
                 (255, 243, 175),
                 (255, 242, 172),
                 (255, 241, 170),
                 (255, 240, 167),
                 (255, 238, 164),
                 (255, 237, 161),
                 (254, 236, 159),
                 (254, 235, 156),
                 (254, 234, 153),
                 (254, 232, 151),
                 (254, 231, 148),
                 (254, 230, 145),
                 (254, 229, 143),
                 (254, 227, 140),
                 (254, 226, 137),
                 (254, 225, 135),
                 (254, 223, 132),
                 (254, 222, 130),
                 (254, 221, 127),
                 (254, 220, 124),
                 (254, 218, 122),
                 (254, 217, 119),
                 (254, 215, 116),
                 (254, 213, 114),
                 (254, 211, 111),
                 (254, 208, 108),
                 (254, 206, 106),
                 (254, 203, 103),
                 (254, 201, 101),
                 (254, 198, 98),
                 (254, 196, 95),
                 (254, 193, 93),
                 (254, 191, 90),
                 (254, 188, 87),
                 (254, 186, 85),
                 (254, 184, 82),
                 (254, 181, 79),
                 (254, 179, 77),
                 (253, 176, 75),
                 (253, 174, 74),
                 (253, 172, 73),
                 (253, 169, 72),
                 (253, 167, 71),
                 (253, 165, 70),
                 (253, 162, 69),
                 (253, 160, 68),
                 (253, 158, 67),
                 (253, 155, 66),
                 (253, 153, 65),
                 (253, 151, 64),
                 (253, 148, 63),
                 (253, 146, 62),
                 (253, 144, 61),
                 (253, 141, 60),
                 (252, 138, 59),
                 (252, 134, 58),
                 (252, 130, 57),
                 (252, 126, 55),
                 (252, 122, 54),
                 (252, 118, 53),
                 (252, 114, 52),
                 (252, 110, 51),
                 (252, 106, 50),
                 (252, 102, 49),
                 (252, 98, 47),
                 (252, 94, 46),
                 (252, 90, 45),
                 (252, 87, 44),
                 (252, 83, 43),
                 (252, 79, 42),
                 (250, 75, 41),
                 (249, 72, 40),
                 (247, 69, 39),
                 (246, 65, 38),
                 (244, 62, 37),
                 (243, 59, 36),
                 (241, 56, 36),
                 (239, 52, 35),
                 (238, 49, 34),
                 (236, 46, 33),
                 (235, 42, 32),
                 (233, 39, 31),
                 (232, 36, 30),
                 (230, 33, 29),
                 (228, 29, 29),
                 (227, 26, 28),
                 (225, 24, 28),
                 (222, 23, 29),
                 (220, 21, 29),
                 (217, 19, 30),
                 (215, 18, 31),
                 (213, 16, 31),
                 (210, 14, 32),
                 (208, 13, 32),
                 (205, 11, 33),
                 (203, 9, 34),
                 (201, 8, 34),
                 (198, 6, 35),
                 (196, 5, 36),
                 (194, 3, 36),
                 (191, 1, 37),
                 (189, 0, 37),
                 (185, 0, 38),
                 (181, 0, 38),
                 (177, 0, 38),
                 (174, 0, 38),
                 (170, 0, 38),
                 (166, 0, 38),
                 (162, 0, 38),
                 (158, 0, 38),
                 (154, 0, 38),
                 (151, 0, 38),
                 (147, 0, 38),
                 (143, 0, 38),
                 (139, 0, 38),
                 (135, 0, 38),
                 (131, 0, 38),
                 (128, 0, 38)],
    'temp_div_5': [(5, 48, 97),
                   (97, 163, 203),
                   (248, 248, 248),
                   (219, 121, 105),
                   (103, 0, 31)],
    'temp_div_6': [(5, 48, 97),
                   (67, 147, 195),
                   (188, 214, 230),
                   (237, 197, 191),
                   (214, 96, 76),
                   (103, 0, 31)],
    'temp_div_7': [(5, 48, 97),
                   (56, 130, 178),
                   (147, 192, 219),
                   (248, 248, 248),
                   (229, 163, 153),
                   (195, 80, 69),
                   (103, 0, 31)],
    'temp_div_8': [(5, 48, 97),
                   (49, 118, 166),
                   (118, 176, 210),
                   (205, 224, 236),
                   (240, 212, 208),
                   (224, 139, 126),
                   (182, 68, 63),
                   (103, 0, 31)],
    'temp_div_9': [(5, 48, 97),
                   (43, 109, 158),
                   (97, 163, 203),
                   (173, 206, 226),
                   (248, 248, 248),
                   (234, 185, 177),
                   (219, 121, 105),
                   (172, 60, 59),
                   (103, 0, 31)],
    'temp_div_10': [(5, 48, 97),
                    (39, 102, 151),
                    (80, 154, 199),
                    (147, 192, 219),
                    (215, 230, 238),
                    (242, 220, 217),
                    (229, 163, 153),
                    (216, 107, 89),
                    (164, 53, 56),
                    (103, 0, 31)],
    'temp_div_11': [(5, 48, 97),
                    (36, 97, 146),
                    (67, 147, 195),
                    (127, 181, 212),
                    (188, 214, 230),
                    (248, 248, 248),
                    (237, 197, 191),
                    (225, 146, 134),
                    (214, 96, 76),
                    (158, 48, 54),
                    (103, 0, 31)],
    'temp_div_12': [(5, 48, 97),
                    (33, 93, 141),
                    (61, 138, 186),
                    (111, 171, 208),
                    (166, 202, 224),
                    (221, 233, 240),
                    (243, 225, 222),
                    (233, 179, 170),
                    (222, 133, 118),
                    (203, 87, 72),
                    (153, 43, 51),
                    (103, 0, 31)],
    'temp_div_13': [(5, 48, 97),
                    (30, 89, 137),
                    (56, 130, 178),
                    (97, 163, 203),
                    (147, 192, 219),
                    (198, 220, 234),
                    (248, 248, 248),
                    (239, 206, 201),
                    (229, 163, 153),
                    (219, 121, 105),
                    (195, 80, 69),
                    (149, 40, 50),
                    (103, 0, 31)],
    'temp_div_14': [(5, 48, 97),
                    (28, 86, 134),
                    (52, 124, 172),
                    (85, 157, 200),
                    (132, 183, 214),
                    (178, 209, 228),
                    (225, 235, 242),
                    (244, 229, 226),
                    (235, 190, 182),
                    (226, 150, 138),
                    (217, 111, 94),
                    (188, 73, 66),
                    (145, 36, 48),
                    (103, 0, 31)],
    'temp_div_15': [(5, 48, 97),
                    (27, 83, 131),
                    (49, 118, 166),
                    (75, 151, 197),
                    (118, 176, 210),
                    (162, 200, 223),
                    (205, 224, 236),
                    (248, 248, 248),
                    (240, 212, 208),
                    (232, 176, 167),
                    (224, 139, 126),
                    (215, 103, 85),
                    (182, 68, 63),
                    (142, 34, 47),
                    (103, 0, 31)],
    'temp_div_16': [(5, 48, 97),
                    (25, 81, 129),
                    (46, 113, 162),
                    (67, 147, 195),
                    (107, 169, 207),
                    (147, 192, 219),
                    (188, 214, 230),
                    (228, 237, 243),
                    (245, 232, 229),
                    (237, 198, 191),
                    (229, 163, 153),
                    (221, 130, 115),
                    (214, 96, 76),
                    (177, 64, 61),
                    (140, 32, 46),
                    (103, 0, 31)],
    'temp_div_17': [(5, 48, 97),
                    (24, 78, 127),
                    (43, 109, 158),
                    (63, 140, 188),
                    (97, 163, 203),
                    (135, 185, 215),
                    (173, 206, 226),
                    (211, 227, 237),
                    (248, 248, 248),
                    (241, 217, 213),
                    (234, 185, 177),
                    (227, 153, 141),
                    (219, 121, 105),
                    (207, 89, 74),
                    (172, 60, 59),
                    (137, 30, 45),
                    (103, 0, 31)],
    'temp_div_18': [(5, 48, 97),
                    (23, 77, 125),
                    (41, 106, 154),
                    (59, 135, 183),
                    (88, 159, 201),
                    (124, 179, 211),
                    (159, 198, 222),
                    (195, 219, 233),
                    (231, 239, 243),
                    (245, 234, 232),
                    (238, 203, 198),
                    (231, 174, 164),
                    (224, 144, 130),
                    (218, 113, 97),
                    (200, 84, 71),
                    (168, 56, 58),
                    (135, 28, 44),
                    (103, 0, 31)],
    'temp_div_19': [(5, 48, 97),
                    (22, 75, 124),
                    (39, 102, 151),
                    (56, 130, 178),
                    (80, 154, 199),
                    (114, 173, 209),
                    (147, 192, 219),
                    (181, 211, 228),
                    (215, 230, 238),
                    (248, 248, 248),
                    (242, 220, 217),
                    (236, 192, 185),
                    (229, 163, 153),
                    (223, 135, 121),
                    (216, 107, 89),
                    (195, 80, 69),
                    (164, 53, 56),
                    (133, 26, 43),
                    (103, 0, 31)],
    'temp_div_20': [(5, 48, 97),
                    (21, 74, 122),
                    (37, 100, 148),
                    (53, 126, 174),
                    (73, 150, 196),
                    (105, 168, 206),
                    (137, 186, 215),
                    (169, 204, 225),
                    (201, 222, 234),
                    (233, 240, 244),
                    (245, 235, 233),
                    (239, 208, 203),
                    (233, 181, 173),
                    (227, 155, 143),
                    (221, 128, 113),
                    (215, 101, 83),
                    (190, 75, 67),
                    (161, 50, 55),
                    (132, 25, 43),
                    (103, 0, 31)],
    'temp_div_21': [(5, 48, 97),
                    (20, 72, 121),
                    (36, 97, 146),
                    (51, 122, 170),
                    (67, 147, 195),
                    (97, 163, 203),
                    (127, 181, 212),
                    (158, 198, 222),
                    (188, 214, 230),
                    (218, 232, 240),
                    (248, 248, 248),
                    (243, 223, 220),
                    (237, 197, 191),
                    (231, 172, 163),
                    (225, 146, 134),
                    (219, 121, 105),
                    (214, 96, 76),
                    (186, 72, 65),
                    (158, 48, 54),
                    (130, 24, 42),
                    (103, 0, 31)],
    'prec_div_5': [(84, 48, 5),
                   (200, 148, 79),
                   (248, 248, 247),
                   (85, 167, 160),
                   (0, 60, 48)],
    'prec_div_6': [(84, 48, 5),
                   (191, 129, 44),
                   (229, 209, 180),
                   (183, 216, 213),
                   (53, 151, 143),
                   (0, 60, 48)],
    'prec_div_7': [(84, 48, 5),
                   (173, 115, 38),
                   (216, 182, 135),
                   (248, 248, 247),
                   (140, 194, 190),
                   (44, 135, 127),
                   (0, 60, 48)],
    'prec_div_8': [(84, 48, 5),
                   (160, 105, 33),
                   (207, 163, 103),
                   (235, 220, 200),
                   (202, 225, 223),
                   (109, 179, 173),
                   (37, 125, 115),
                   (0, 60, 48)],
    'prec_div_9': [(84, 48, 5),
                   (150, 98, 30),
                   (200, 148, 79),
                   (224, 199, 164),
                   (248, 248, 247),
                   (167, 208, 204),
                   (85, 167, 160),
                   (33, 116, 107),
                   (0, 60, 48)],
    'prec_div_10': [(84, 48, 5),
                    (143, 93, 27),
                    (195, 137, 60),
                    (216, 182, 135),
                    (238, 226, 211),
                    (212, 230, 229),
                    (140, 194, 190),
                    (67, 158, 150),
                    (29, 110, 100),
                    (0, 60, 48)],
    'prec_div_11': [(84, 48, 5),
                    (137, 88, 25),
                    (191, 129, 44),
                    (210, 169, 113),
                    (229, 209, 180),
                    (248, 248, 247),
                    (183, 216, 213),
                    (118, 183, 178),
                    (53, 151, 143),
                    (26, 105, 95),
                    (0, 60, 48)],
    'prec_div_12': [(84, 48, 5),
                    (132, 84, 23),
                    (181, 121, 41),
                    (205, 158, 94),
                    (222, 194, 156),
                    (240, 230, 218),
                    (219, 234, 232),
                    (159, 204, 200),
                    (100, 174, 168),
                    (48, 142, 134),
                    (24, 101, 91),
                    (0, 60, 48)],
    'prec_div_13': [(84, 48, 5),
                    (128, 81, 21),
                    (173, 115, 38),
                    (200, 148, 79),
                    (216, 182, 135),
                    (232, 215, 192),
                    (248, 248, 247),
                    (194, 221, 219),
                    (140, 194, 190),
                    (85, 167, 160),
                    (44, 135, 127),
                    (22, 97, 87),
                    (0, 60, 48)],
    'prec_div_14': [(84, 48, 5),
                    (125, 79, 20),
                    (166, 110, 35),
                    (196, 141, 65),
                    (211, 172, 118),
                    (226, 202, 170),
                    (241, 233, 222),
                    (223, 236, 235),
                    (173, 211, 208),
                    (123, 186, 181),
                    (73, 161, 153),
                    (40, 129, 121),
                    (20, 95, 84),
                    (0, 60, 48)],
    'prec_div_15': [(84, 48, 5),
                    (122, 76, 19),
                    (160, 105, 33),
                    (193, 134, 54),
                    (207, 163, 103),
                    (221, 191, 151),
                    (235, 220, 200),
                    (248, 248, 247),
                    (202, 225, 223),
                    (155, 202, 198),
                    (109, 179, 173),
                    (62, 155, 148),
                    (37, 125, 115),
                    (18, 92, 81),
                    (0, 60, 48)],
    'prec_div_16': [(84, 48, 5),
                    (119, 74, 18),
                    (155, 101, 31),
                    (191, 129, 44),
                    (203, 155, 90),
                    (216, 182, 135),
                    (229, 209, 180),
                    (242, 235, 226),
                    (227, 238, 237),
                    (183, 216, 213),
                    (140, 194, 190),
                    (96, 172, 166),
                    (53, 151, 143),
                    (35, 120, 111),
                    (17, 90, 79),
                    (0, 60, 48)],
    'prec_div_17': [(84, 48, 5),
                    (117, 73, 17),
                    (150, 98, 30),
                    (184, 123, 42),
                    (200, 148, 79),
                    (212, 174, 121),
                    (224, 199, 164),
                    (236, 224, 206),
                    (248, 248, 247),
                    (208, 228, 226),
                    (167, 208, 204),
                    (126, 187, 182),
                    (85, 167, 160),
                    (49, 145, 137),
                    (33, 116, 107),
                    (16, 88, 77),
                    (0, 60, 48)],
    'prec_div_18': [(84, 48, 5),
                    (115, 71, 16),
                    (146, 95, 28),
                    (178, 119, 40),
                    (197, 143, 69),
                    (209, 166, 109),
                    (220, 190, 148),
                    (231, 213, 189),
                    (243, 237, 229),
                    (229, 239, 238),
                    (191, 220, 217),
                    (152, 200, 197),
                    (114, 181, 176),
                    (76, 162, 155),
                    (46, 140, 131),
                    (31, 113, 103),
                    (15, 86, 75),
                    (0, 60, 48)],
    'prec_div_19': [(84, 48, 5),
                    (113, 70, 16),
                    (143, 93, 27),
                    (173, 115, 38),
                    (195, 137, 60),
                    (206, 160, 97),
                    (216, 182, 135),
                    (227, 204, 173),
                    (238, 226, 211),
                    (248, 248, 247),
                    (212, 230, 229),
                    (176, 212, 209),
                    (140, 194, 190),
                    (103, 176, 170),
                    (67, 158, 150),
                    (44, 135, 127),
                    (29, 110, 100),
                    (14, 85, 74),
                    (0, 60, 48)],
    'prec_div_20': [(84, 48, 5),
                    (112, 69, 15),
                    (140, 90, 26),
                    (168, 111, 36),
                    (193, 133, 52),
                    (203, 154, 87),
                    (213, 175, 123),
                    (223, 196, 159),
                    (233, 217, 195),
                    (243, 238, 231),
                    (231, 240, 239),
                    (197, 223, 221),
                    (163, 206, 202),
                    (128, 188, 183),
                    (94, 171, 165),
                    (59, 154, 146),
                    (41, 131, 122),
                    (27, 107, 98),
                    (13, 83, 73),
                    (0, 60, 48)],
    'prec_div_21': [(84, 48, 5),
                    (110, 68, 15),
                    (137, 88, 25),
                    (164, 108, 35),
                    (191, 129, 44),
                    (200, 148, 79),
                    (210, 169, 113),
                    (220, 189, 147),
                    (229, 209, 180),
                    (239, 228, 215),
                    (248, 248, 247),
                    (216, 232, 231),
                    (183, 216, 213),
                    (151, 200, 195),
                    (118, 183, 178),
                    (85, 167, 160),
                    (53, 151, 143),
                    (39, 128, 119),
                    (26, 105, 95),
                    (13, 82, 71),
                    (0, 60, 48)],
    'wind_div_5': [(43, 25, 76),
                   (85, 125, 165),
                   (218, 229, 229),
                   (106, 167, 111),
                   (66, 76, 2)],
    'wind_div_6': [(43, 25, 76),
                   (61, 104, 149),
                   (170, 190, 210),
                   (183, 212, 185),
                   (82, 150, 84),
                   (66, 76, 2)],
    'wind_div_7': [(43, 25, 76),
                   (49, 89, 138),
                   (131, 161, 190),
                   (218, 229, 229),
                   (148, 192, 152),
                   (71, 135, 66),
                   (66, 76, 2)],
    'wind_div_8': [(43, 25, 76),
                   (44, 79, 129),
                   (105, 140, 176),
                   (186, 203, 219),
                   (197, 221, 200),
                   (124, 178, 129),
                   (66, 125, 53),
                   (66, 76, 2)],
    'wind_div_9': [(43, 25, 76),
                   (42, 72, 122),
                   (85, 125, 165),
                   (155, 179, 202),
                   (218, 229, 229),
                   (170, 205, 173),
                   (106, 167, 111),
                   (64, 118, 45),
                   (66, 76, 2)],
    'wind_div_10': [(43, 25, 76),
                    (41, 67, 117),
                    (71, 113, 157),
                    (131, 161, 190),
                    (195, 210, 223),
                    (205, 225, 208),
                    (148, 192, 152),
                    (93, 158, 96),
                    (64, 112, 39),
                    (66, 76, 2)],
    'wind_div_11': [(43, 25, 76),
                    (41, 62, 113),
                    (61, 104, 149),
                    (113, 147, 180),
                    (170, 190, 210),
                    (218, 229, 229),
                    (183, 212, 185),
                    (131, 182, 136),
                    (82, 150, 84),
                    (64, 108, 35),
                    (66, 76, 2)],
    'wind_div_12': [(43, 25, 76),
                    (41, 59, 109),
                    (54, 96, 143),
                    (98, 135, 172),
                    (149, 174, 199),
                    (201, 214, 225),
                    (209, 228, 213),
                    (164, 201, 167),
                    (118, 174, 122),
                    (75, 142, 74),
                    (64, 105, 32),
                    (66, 76, 2)],
    'wind_div_13': [(43, 25, 76),
                    (41, 56, 107),
                    (49, 89, 138),
                    (85, 125, 165),
                    (131, 161, 190),
                    (179, 198, 215),
                    (218, 229, 229),
                    (191, 217, 194),
                    (148, 192, 152),
                    (106, 167, 111),
                    (71, 135, 66),
                    (64, 102, 29),
                    (66, 76, 2)],
    'wind_div_14': [(43, 25, 76),
                    (42, 53, 104),
                    (46, 84, 133),
                    (75, 117, 159),
                    (117, 150, 182),
                    (161, 183, 205),
                    (204, 217, 227),
                    (212, 229, 216),
                    (175, 208, 178),
                    (135, 185, 139),
                    (97, 161, 101),
                    (68, 130, 59),
                    (64, 100, 27),
                    (66, 76, 2)],
    'wind_div_15': [(43, 25, 76),
                    (42, 51, 102),
                    (44, 79, 129),
                    (67, 110, 154),
                    (105, 140, 176),
                    (145, 171, 197),
                    (186, 203, 219),
                    (218, 229, 229),
                    (197, 221, 200),
                    (160, 199, 164),
                    (124, 178, 129),
                    (89, 155, 92),
                    (66, 125, 53),
                    (65, 98, 25),
                    (66, 76, 2)],
    'wind_div_16': [(43, 25, 76),
                    (42, 50, 100),
                    (43, 75, 126),
                    (61, 104, 149),
                    (94, 132, 170),
                    (131, 161, 190),
                    (170, 190, 210),
                    (207, 219, 228),
                    (214, 230, 218),
                    (183, 212, 185),
                    (148, 192, 152),
                    (114, 172, 119),
                    (82, 150, 84),
                    (65, 121, 49),
                    (65, 97, 24),
                    (66, 76, 2)],
    'wind_div_17': [(43, 25, 76),
                    (42, 48, 99),
                    (42, 72, 122),
                    (56, 98, 145),
                    (85, 125, 165),
                    (120, 152, 184),
                    (155, 179, 202),
                    (191, 207, 221),
                    (218, 229, 229),
                    (202, 223, 204),
                    (170, 205, 173),
                    (138, 186, 142),
                    (106, 167, 111),
                    (77, 144, 77),
                    (64, 118, 45),
                    (65, 95, 22),
                    (66, 76, 2)],
    'wind_div_18': [(43, 25, 76),
                    (42, 47, 97),
                    (41, 69, 120),
                    (52, 94, 141),
                    (78, 119, 161),
                    (109, 144, 178),
                    (143, 170, 196),
                    (177, 195, 214),
                    (209, 221, 228),
                    (215, 230, 220),
                    (189, 216, 191),
                    (158, 198, 162),
                    (128, 181, 133),
                    (99, 162, 103),
                    (73, 140, 71),
                    (64, 115, 42),
                    (65, 94, 21),
                    (66, 76, 2)],
    'wind_div_19': [(43, 25, 76),
                    (42, 46, 96),
                    (41, 67, 117),
                    (49, 89, 138),
                    (71, 113, 157),
                    (100, 137, 173),
                    (131, 161, 190),
                    (163, 185, 207),
                    (195, 210, 223),
                    (218, 229, 229),
                    (205, 225, 208),
                    (177, 209, 180),
                    (148, 192, 152),
                    (120, 176, 125),
                    (93, 158, 96),
                    (71, 135, 66),
                    (64, 112, 39),
                    (65, 93, 20),
                    (66, 76, 2)],
    'wind_div_20': [(43, 25, 76),
                    (42, 44, 95),
                    (41, 64, 115),
                    (47, 86, 135),
                    (66, 108, 153),
                    (93, 131, 169),
                    (122, 153, 185),
                    (152, 176, 200),
                    (182, 199, 216),
                    (210, 222, 229),
                    (216, 230, 221),
                    (193, 219, 196),
                    (166, 203, 169),
                    (139, 187, 143),
                    (113, 171, 117),
                    (87, 154, 90),
                    (69, 132, 61),
                    (64, 110, 37),
                    (65, 92, 19),
                    (66, 76, 2)],
    'wind_div_21': [(43, 25, 76),
                    (42, 43, 94),
                    (41, 62, 113),
                    (45, 82, 132),
                    (61, 104, 149),
                    (85, 125, 165),
                    (113, 147, 180),
                    (141, 168, 195),
                    (170, 190, 210),
                    (198, 212, 224),
                    (218, 229, 229),
                    (207, 226, 210),
                    (183, 212, 185),
                    (157, 197, 160),
                    (131, 182, 136),
                    (106, 167, 111),
                    (82, 150, 84),
                    (67, 128, 57),
                    (64, 108, 35),
                    (65, 91, 18),
                    (66, 76, 2)],
    'cryo_div_5': [(38, 38, 0),
                   (154, 154, 97),
                   (234, 238, 235),
                   (90, 129, 168),
                   (43, 25, 76)],
    'cryo_div_6': [(38, 38, 0),
                   (129, 129, 75),
                   (219, 219, 183),
                   (179, 197, 215),
                   (62, 107, 152),
                   (43, 25, 76)],
    'cryo_div_7': [(38, 38, 0),
                   (112, 112, 61),
                   (196, 196, 142),
                   (234, 238, 235),
                   (138, 166, 194),
                   (48, 92, 141),
                   (43, 25, 76)],
    'cryo_div_8': [(38, 38, 0),
                   (101, 101, 52),
                   (173, 173, 114),
                   (228, 227, 201),
                   (196, 210, 224),
                   (110, 145, 179),
                   (42, 82, 132),
                   (43, 25, 76)],
    'cryo_div_9': [(38, 38, 0),
                   (92, 92, 45),
                   (154, 154, 97),
                   (211, 211, 168),
                   (234, 238, 235),
                   (163, 185, 207),
                   (90, 129, 168),
                   (40, 74, 124),
                   (43, 25, 76)],
    'cryo_div_10': [(38, 38, 0),
                    (86, 85, 39),
                    (140, 140, 85),
                    (196, 196, 142),
                    (232, 232, 210),
                    (206, 218, 229),
                    (138, 166, 194),
                    (74, 117, 159),
                    (40, 68, 119),
                    (43, 25, 76)],
    'cryo_div_11': [(38, 38, 0),
                    (80, 80, 35),
                    (129, 129, 75),
                    (180, 180, 122),
                    (219, 219, 183),
                    (234, 238, 235),
                    (179, 197, 215),
                    (119, 151, 183),
                    (62, 107, 152),
                    (40, 64, 114),
                    (43, 25, 76)],
    'cryo_div_12': [(38, 38, 0),
                    (76, 76, 32),
                    (120, 120, 68),
                    (166, 166, 107),
                    (208, 207, 161),
                    (234, 235, 216),
                    (212, 222, 231),
                    (157, 180, 203),
                    (103, 139, 175),
                    (54, 99, 146),
                    (40, 60, 111),
                    (43, 25, 76)],
    'cryo_div_13': [(38, 38, 0),
                    (73, 73, 29),
                    (112, 112, 61),
                    (154, 154, 97),
                    (196, 196, 142),
                    (224, 224, 193),
                    (234, 238, 235),
                    (189, 205, 220),
                    (138, 166, 194),
                    (90, 129, 168),
                    (48, 92, 141),
                    (40, 57, 108),
                    (43, 25, 76)],
    'cryo_div_14': [(38, 38, 0),
                    (70, 70, 27),
                    (106, 106, 56),
                    (144, 144, 88),
                    (184, 184, 127),
                    (214, 214, 174),
                    (236, 236, 220),
                    (216, 225, 233),
                    (169, 190, 210),
                    (123, 155, 186),
                    (79, 121, 162),
                    (44, 86, 136),
                    (41, 54, 105),
                    (43, 25, 76)],
    'cryo_div_15': [(38, 38, 0),
                    (67, 67, 25),
                    (101, 101, 52),
                    (136, 136, 81),
                    (173, 173, 114),
                    (205, 205, 157),
                    (228, 227, 201),
                    (234, 238, 235),
                    (196, 210, 224),
                    (153, 177, 201),
                    (110, 145, 179),
                    (70, 113, 157),
                    (42, 82, 132),
                    (41, 52, 103),
                    (43, 25, 76)],
    'cryo_div_16': [(38, 38, 0),
                    (65, 65, 23),
                    (96, 96, 48),
                    (129, 129, 75),
                    (163, 163, 105),
                    (196, 196, 142),
                    (219, 219, 183),
                    (236, 237, 223),
                    (219, 227, 234),
                    (179, 197, 215),
                    (138, 166, 194),
                    (99, 136, 173),
                    (62, 107, 152),
                    (41, 78, 128),
                    (41, 50, 101),
                    (43, 25, 76)],
    'cryo_div_17': [(38, 38, 0),
                    (63, 63, 22),
                    (92, 92, 45),
                    (122, 122, 70),
                    (154, 154, 97),
                    (187, 187, 129),
                    (211, 211, 168),
                    (230, 230, 206),
                    (234, 238, 235),
                    (202, 214, 227),
                    (163, 185, 207),
                    (126, 157, 187),
                    (90, 129, 168),
                    (56, 101, 148),
                    (40, 74, 124),
                    (41, 49, 100),
                    (43, 25, 76)],
    'cryo_div_18': [(38, 38, 0),
                    (62, 62, 20),
                    (89, 89, 42),
                    (117, 117, 65),
                    (147, 147, 90),
                    (177, 177, 119),
                    (204, 204, 155),
                    (223, 222, 190),
                    (237, 238, 225),
                    (221, 229, 235),
                    (186, 202, 218),
                    (150, 175, 200),
                    (115, 149, 181),
                    (81, 123, 163),
                    (52, 97, 144),
                    (40, 71, 122),
                    (41, 47, 98),
                    (43, 25, 76)],
    'cryo_div_19': [(38, 38, 0),
                    (60, 60, 19),
                    (86, 85, 39),
                    (112, 112, 61),
                    (140, 140, 85),
                    (169, 169, 110),
                    (196, 196, 142),
                    (216, 215, 177),
                    (232, 232, 210),
                    (234, 238, 235),
                    (206, 218, 229),
                    (172, 192, 211),
                    (138, 166, 194),
                    (106, 141, 176),
                    (74, 117, 159),
                    (48, 92, 141),
                    (40, 68, 119),
                    (42, 46, 97),
                    (43, 25, 76)],
    'cryo_div_20': [(38, 38, 0),
                    (59, 59, 18),
                    (83, 83, 37),
                    (108, 108, 58),
                    (134, 134, 80),
                    (161, 161, 103),
                    (188, 188, 131),
                    (209, 209, 164),
                    (225, 225, 196),
                    (237, 238, 226),
                    (223, 230, 236),
                    (191, 207, 221),
                    (159, 182, 205),
                    (128, 158, 188),
                    (97, 135, 172),
                    (68, 112, 156),
                    (45, 88, 137),
                    (40, 66, 117),
                    (42, 45, 96),
                    (43, 25, 76)],
    'cryo_div_21': [(38, 38, 0),
                    (58, 58, 18),
                    (80, 80, 35),
                    (104, 104, 55),
                    (129, 129, 75),
                    (154, 154, 97),
                    (180, 180, 122),
                    (203, 203, 153),
                    (219, 219, 183),
                    (233, 233, 213),
                    (234, 238, 235),
                    (209, 220, 230),
                    (179, 197, 215),
                    (148, 174, 199),
                    (119, 151, 183),
                    (90, 129, 168),
                    (62, 107, 152),
                    (43, 85, 134),
                    (40, 64, 114),
                    (42, 44, 95),
                    (43, 25, 76)],
    'chem_div_5': [(0, 68, 57),
                   (116, 186, 122),
                   (248, 248, 248),
                   (169, 134, 184),
                   (64, 0, 75)],
    'chem_div_6': [(0, 68, 57),
                   (90, 174, 97),
                   (195, 224, 198),
                   (216, 203, 222),
                   (153, 112, 171),
                   (64, 0, 75)],
    'chem_div_7': [(0, 68, 57),
                   (75, 156, 90),
                   (160, 207, 164),
                   (248, 248, 248),
                   (195, 172, 205),
                   (138, 93, 155),
                   (64, 0, 75)],
    'chem_div_8': [(0, 68, 57),
                   (64, 143, 85),
                   (135, 195, 140),
                   (211, 231, 212),
                   (226, 216, 230),
                   (180, 151, 193),
                   (127, 80, 143),
                   (64, 0, 75)],
    'chem_div_9': [(0, 68, 57),
                   (56, 134, 81),
                   (116, 186, 122),
                   (182, 217, 185),
                   (248, 248, 248),
                   (209, 191, 216),
                   (169, 134, 184),
                   (119, 70, 135),
                   (64, 0, 75)],
    'chem_div_10': [(0, 68, 57),
                    (50, 126, 79),
                    (101, 179, 108),
                    (160, 207, 164),
                    (219, 235, 220),
                    (231, 223, 234),
                    (195, 172, 205),
                    (160, 122, 176),
                    (113, 62, 128),
                    (64, 0, 75)],
    'chem_div_11': [(0, 68, 57),
                    (45, 121, 77),
                    (90, 174, 97),
                    (143, 199, 147),
                    (195, 224, 198),
                    (248, 248, 248),
                    (216, 203, 222),
                    (184, 157, 196),
                    (153, 112, 171),
                    (108, 56, 122),
                    (64, 0, 75)],
    'chem_div_12': [(0, 68, 57),
                    (40, 116, 75),
                    (81, 164, 93),
                    (128, 192, 133),
                    (176, 214, 179),
                    (224, 237, 225),
                    (234, 228, 237),
                    (205, 186, 213),
                    (176, 145, 189),
                    (144, 101, 162),
                    (104, 50, 118),
                    (64, 0, 75)],
    'chem_div_13': [(0, 68, 57),
                    (37, 112, 73),
                    (75, 156, 90),
                    (116, 186, 122),
                    (160, 207, 164),
                    (204, 228, 206),
                    (248, 248, 248),
                    (222, 210, 227),
                    (195, 172, 205),
                    (169, 134, 184),
                    (138, 93, 155),
                    (101, 46, 115),
                    (64, 0, 75)],
    'chem_div_14': [(0, 68, 57),
                    (34, 108, 72),
                    (69, 149, 87),
                    (106, 181, 112),
                    (147, 200, 151),
                    (187, 220, 190),
                    (228, 239, 229),
                    (236, 231, 238),
                    (212, 196, 219),
                    (187, 161, 198),
                    (162, 126, 179),
                    (132, 86, 148),
                    (98, 43, 111),
                    (64, 0, 75)],
    'chem_div_15': [(0, 68, 57),
                    (32, 105, 71),
                    (64, 143, 85),
                    (97, 177, 104),
                    (135, 195, 140),
                    (173, 213, 176),
                    (211, 231, 212),
                    (248, 248, 248),
                    (226, 216, 230),
                    (203, 183, 211),
                    (180, 151, 193),
                    (157, 118, 174),
                    (127, 80, 143),
                    (95, 40, 109),
                    (64, 0, 75)],
    'chem_div_16': [(0, 68, 57),
                    (30, 103, 70),
                    (60, 138, 83),
                    (90, 174, 97),
                    (125, 190, 130),
                    (160, 207, 164),
                    (195, 224, 198),
                    (231, 240, 232),
                    (238, 233, 240),
                    (217, 203, 223),
                    (195, 172, 205),
                    (174, 142, 188),
                    (153, 112, 171),
                    (123, 74, 139),
                    (93, 37, 107),
                    (64, 0, 75)],
    'chem_div_17': [(0, 68, 57),
                    (28, 101, 69),
                    (56, 134, 81),
                    (84, 167, 94),
                    (116, 186, 122),
                    (149, 202, 154),
                    (182, 217, 185),
                    (215, 233, 217),
                    (248, 248, 248),
                    (229, 220, 232),
                    (209, 191, 216),
                    (189, 163, 200),
                    (169, 134, 184),
                    (147, 105, 164),
                    (119, 70, 135),
                    (91, 34, 105),
                    (64, 0, 75)],
    'chem_div_18': [(0, 68, 57),
                    (26, 99, 68),
                    (52, 130, 80),
                    (79, 161, 92),
                    (108, 182, 114),
                    (139, 197, 144),
                    (171, 212, 174),
                    (202, 226, 204),
                    (233, 241, 234),
                    (239, 235, 241),
                    (220, 208, 226),
                    (201, 181, 210),
                    (183, 154, 195),
                    (164, 128, 180),
                    (142, 98, 159),
                    (116, 65, 131),
                    (90, 32, 103),
                    (64, 0, 75)],
    'chem_div_19': [(0, 68, 57),
                    (25, 97, 68),
                    (50, 126, 79),
                    (75, 156, 90),
                    (101, 179, 108),
                    (131, 193, 136),
                    (160, 207, 164),
                    (190, 221, 192),
                    (219, 235, 220),
                    (248, 248, 248),
                    (231, 223, 234),
                    (213, 198, 220),
                    (195, 172, 205),
                    (177, 147, 191),
                    (160, 122, 176),
                    (138, 93, 155),
                    (113, 62, 128),
                    (88, 31, 101),
                    (64, 0, 75)],
    'chem_div_20': [(0, 68, 57),
                    (23, 95, 67),
                    (47, 123, 78),
                    (71, 151, 88),
                    (95, 176, 102),
                    (123, 189, 129),
                    (151, 202, 155),
                    (179, 216, 182),
                    (207, 229, 209),
                    (235, 242, 235),
                    (240, 236, 242),
                    (223, 212, 228),
                    (206, 188, 214),
                    (190, 164, 201),
                    (173, 140, 187),
                    (156, 116, 173),
                    (134, 88, 150),
                    (110, 58, 125),
                    (87, 29, 100),
                    (64, 0, 75)],
    'chem_div_21': [(0, 68, 57),
                    (22, 94, 67),
                    (45, 121, 77),
                    (67, 147, 87),
                    (90, 174, 97),
                    (116, 186, 122),
                    (143, 199, 147),
                    (169, 211, 173),
                    (195, 224, 198),
                    (222, 236, 223),
                    (248, 248, 248),
                    (233, 226, 235),
                    (216, 203, 222),
                    (201, 180, 210),
                    (184, 157, 196),
                    (169, 134, 184),
                    (153, 112, 171),
                    (130, 84, 147),
                    (108, 56, 122),
                    (86, 28, 98),
                    (64, 0, 75)],
    'slev_div_5': [(2, 71, 104),
                   (89, 183, 228),
                   (248, 248, 248),
                   (235, 158, 42),
                   (80, 56, 33)],
    'slev_div_6': [(2, 71, 104),
                   (71, 161, 204),
                   (185, 223, 241),
                   (243, 212, 166),
                   (204, 138, 40),
                   (80, 56, 33)],
    'slev_div_7': [(2, 71, 104),
                   (60, 146, 187),
                   (142, 205, 235),
                   (248, 248, 248),
                   (240, 189, 111),
                   (184, 124, 39),
                   (80, 56, 33)],
    'slev_div_8': [(2, 71, 104),
                   (51, 135, 175),
                   (111, 193, 231),
                   (203, 230, 243),
                   (245, 223, 189),
                   (237, 171, 71),
                   (169, 114, 38),
                   (80, 56, 33)],
    'slev_div_9': [(2, 71, 104),
                   (45, 127, 166),
                   (89, 183, 228),
                   (169, 216, 239),
                   (248, 248, 248),
                   (242, 203, 145),
                   (235, 158, 42),
                   (157, 107, 37),
                   (80, 56, 33)],
    'slev_div_10': [(2, 71, 104),
                    (40, 121, 159),
                    (79, 171, 215),
                    (142, 205, 235),
                    (213, 234, 244),
                    (246, 228, 203),
                    (240, 189, 111),
                    (218, 147, 41),
                    (149, 101, 37),
                    (80, 56, 33)],
    'slev_div_11': [(2, 71, 104),
                    (36, 116, 154),
                    (71, 161, 204),
                    (121, 197, 233),
                    (185, 223, 241),
                    (248, 248, 248),
                    (243, 212, 166),
                    (238, 176, 83),
                    (204, 138, 40),
                    (142, 97, 36),
                    (80, 56, 33)],
    'slev_div_12': [(2, 71, 104),
                    (33, 112, 149),
                    (65, 153, 194),
                    (103, 189, 230),
                    (161, 213, 238),
                    (219, 237, 245),
                    (246, 232, 211),
                    (241, 199, 136),
                    (237, 167, 60),
                    (193, 130, 39),
                    (136, 93, 36),
                    (80, 56, 33)],
    'slev_div_13': [(2, 71, 104),
                    (31, 108, 145),
                    (60, 146, 187),
                    (89, 183, 228),
                    (142, 205, 235),
                    (195, 227, 242),
                    (248, 248, 248),
                    (244, 219, 180),
                    (240, 189, 111),
                    (235, 158, 42),
                    (184, 124, 39),
                    (132, 90, 36),
                    (80, 56, 33)],
    'slev_div_14': [(2, 71, 104),
                    (28, 105, 142),
                    (55, 140, 180),
                    (82, 175, 219),
                    (125, 198, 233),
                    (175, 219, 239),
                    (224, 239, 245),
                    (247, 235, 217),
                    (243, 207, 153),
                    (239, 179, 89),
                    (224, 151, 41),
                    (175, 119, 38),
                    (128, 87, 35),
                    (80, 56, 33)],
    'slev_div_15': [(2, 71, 104),
                    (26, 103, 139),
                    (51, 135, 175),
                    (76, 167, 211),
                    (111, 193, 231),
                    (157, 211, 237),
                    (203, 230, 243),
                    (248, 248, 248),
                    (245, 223, 189),
                    (241, 197, 130),
                    (237, 171, 71),
                    (213, 144, 40),
                    (169, 114, 38),
                    (124, 85, 35),
                    (80, 56, 33)],
    'slev_div_16': [(2, 71, 104),
                    (25, 101, 137),
                    (48, 131, 170),
                    (71, 161, 204),
                    (99, 188, 230),
                    (142, 205, 235),
                    (185, 223, 241),
                    (227, 240, 246),
                    (247, 237, 221),
                    (243, 212, 166),
                    (240, 189, 111),
                    (236, 164, 55),
                    (204, 138, 40),
                    (163, 110, 37),
                    (121, 83, 35),
                    (80, 56, 33)],
    'slev_div_17': [(2, 71, 104),
                    (23, 99, 135),
                    (45, 127, 166),
                    (67, 155, 197),
                    (89, 183, 228),
                    (129, 200, 234),
                    (169, 216, 239),
                    (209, 232, 244),
                    (248, 248, 248),
                    (245, 226, 197),
                    (242, 203, 145),
                    (239, 181, 93),
                    (235, 158, 42),
                    (197, 133, 39),
                    (157, 107, 37),
                    (119, 81, 35),
                    (80, 56, 33)],
    'slev_div_18': [(2, 71, 104),
                    (22, 97, 133),
                    (42, 124, 162),
                    (63, 150, 192),
                    (83, 177, 221),
                    (117, 195, 232),
                    (154, 210, 237),
                    (192, 226, 241),
                    (230, 241, 246),
                    (247, 238, 224),
                    (244, 217, 175),
                    (241, 196, 127),
                    (238, 174, 78),
                    (226, 152, 41),
                    (190, 128, 39),
                    (153, 104, 37),
                    (116, 80, 35),
                    (80, 56, 33)],
    'slev_div_19': [(2, 71, 104),
                    (21, 96, 131),
                    (40, 121, 159),
                    (60, 146, 187),
                    (79, 171, 215),
                    (106, 191, 231),
                    (142, 205, 235),
                    (177, 220, 240),
                    (213, 234, 244),
                    (248, 248, 248),
                    (246, 228, 203),
                    (243, 209, 157),
                    (240, 189, 111),
                    (237, 169, 65),
                    (218, 147, 41),
                    (184, 124, 39),
                    (149, 101, 37),
                    (114, 78, 35),
                    (80, 56, 33)],
    'slev_div_20': [(2, 71, 104),
                    (20, 94, 130),
                    (38, 118, 156),
                    (56, 142, 182),
                    (75, 166, 209),
                    (97, 187, 230),
                    (131, 201, 234),
                    (164, 214, 238),
                    (198, 228, 242),
                    (232, 242, 246),
                    (247, 239, 227),
                    (244, 220, 183),
                    (242, 201, 140),
                    (239, 182, 96),
                    (236, 163, 52),
                    (211, 142, 40),
                    (178, 121, 38),
                    (145, 99, 36),
                    (112, 77, 34),
                    (80, 56, 33)],
    'slev_div_21': [(2, 71, 104),
                    (19, 93, 129),
                    (36, 116, 154),
                    (54, 138, 179),
                    (71, 161, 204),
                    (89, 183, 228),
                    (121, 197, 233),
                    (153, 210, 237),
                    (185, 223, 241),
                    (217, 235, 245),
                    (248, 248, 248),
                    (246, 231, 207),
                    (243, 212, 166),
                    (241, 195, 124),
                    (238, 176, 83),
                    (235, 158, 42),
                    (204, 138, 40),
                    (173, 117, 38),
                    (142, 97, 36),
                    (111, 76, 34),
                    (80, 56, 33)],
    'misc_div_5': [(8, 29, 88),
                   (65, 182, 195),
                   (254, 254, 209),
                   (253, 141, 60),
                   (128, 0, 38)],
    'misc_div_6': [(8, 29, 88),
                   (36, 152, 192),
                   (214, 239, 178),
                   (254, 225, 135),
                   (252, 90, 45),
                   (128, 0, 38)],
    'misc_div_7': [(8, 29, 88),
                   (30, 128, 184),
                   (151, 214, 184),
                   (254, 254, 209),
                   (254, 191, 90),
                   (243, 60, 37),
                   (128, 0, 38)],
    'misc_div_8': [(8, 29, 88),
                   (32, 108, 174),
                   (100, 195, 190),
                   (232, 246, 177),
                   (254, 234, 154),
                   (253, 162, 69),
                   (234, 41, 32),
                   (128, 0, 38)],
    'misc_div_9': [(8, 29, 88),
                   (33, 94, 168),
                   (65, 182, 195),
                   (199, 233, 180),
                   (254, 254, 209),
                   (254, 217, 118),
                   (253, 141, 60),
                   (227, 26, 28),
                   (128, 0, 38)],
    'misc_div_10': [(8, 29, 88),
                    (34, 84, 163),
                    (49, 165, 194),
                    (151, 214, 184),
                    (239, 248, 182),
                    (255, 239, 165),
                    (254, 191, 90),
                    (252, 113, 52),
                    (218, 20, 30),
                    (128, 0, 38)],
    'misc_div_11': [(8, 29, 88),
                    (35, 77, 160),
                    (36, 152, 192),
                    (115, 200, 188),
                    (214, 239, 178),
                    (254, 254, 209),
                    (254, 225, 135),
                    (253, 170, 72),
                    (252, 90, 45),
                    (211, 15, 31),
                    (128, 0, 38)],
    'misc_div_12': [(8, 29, 88),
                    (35, 71, 157),
                    (29, 140, 189),
                    (88, 190, 192),
                    (186, 228, 181),
                    (242, 250, 188),
                    (255, 242, 172),
                    (254, 210, 110),
                    (253, 154, 65),
                    (249, 73, 40),
                    (206, 11, 33),
                    (128, 0, 38)],
    'misc_div_13': [(8, 29, 88),
                    (35, 66, 154),
                    (30, 128, 184),
                    (65, 182, 195),
                    (151, 214, 184),
                    (224, 243, 177),
                    (254, 254, 209),
                    (254, 230, 146),
                    (254, 191, 90),
                    (253, 141, 60),
                    (243, 60, 37),
                    (201, 8, 34),
                    (128, 0, 38)],
    'misc_div_14': [(8, 29, 88),
                    (36, 61, 152),
                    (31, 117, 179),
                    (54, 170, 194),
                    (122, 203, 187),
                    (205, 235, 179),
                    (244, 250, 192),
                    (255, 244, 177),
                    (254, 220, 124),
                    (253, 175, 74),
                    (252, 122, 54),
                    (238, 50, 34),
                    (197, 6, 35),
                    (128, 0, 38)],
    'misc_div_15': [(8, 29, 88),
                    (36, 58, 150),
                    (32, 108, 174),
                    (44, 161, 193),
                    (100, 195, 190),
                    (179, 225, 181),
                    (232, 246, 177),
                    (254, 254, 209),
                    (254, 234, 154),
                    (254, 206, 106),
                    (253, 162, 69),
                    (252, 105, 49),
                    (234, 41, 32),
                    (194, 3, 36),
                    (128, 0, 38)],
    'misc_div_16': [(8, 29, 88),
                    (36, 54, 149),
                    (33, 101, 171),
                    (36, 152, 192),
                    (82, 188, 193),
                    (151, 214, 184),
                    (214, 239, 178),
                    (245, 251, 196),
                    (255, 245, 181),
                    (254, 225, 135),
                    (254, 191, 90),
                    (253, 151, 64),
                    (252, 90, 45),
                    (230, 33, 29),
                    (191, 1, 37),
                    (128, 0, 38)],
    'misc_div_17': [(8, 29, 88),
                    (36, 52, 147),
                    (33, 94, 168),
                    (29, 145, 191),
                    (65, 182, 195),
                    (127, 205, 186),
                    (199, 233, 180),
                    (237, 248, 177),
                    (254, 254, 209),
                    (254, 237, 160),
                    (254, 217, 118),
                    (253, 178, 76),
                    (253, 141, 60),
                    (251, 78, 42),
                    (227, 26, 28),
                    (188, 0, 37),
                    (128, 0, 38)],
    'misc_div_18': [(8, 29, 88),
                    (35, 50, 144),
                    (34, 89, 165),
                    (29, 136, 187),
                    (56, 173, 195),
                    (109, 198, 189),
                    (174, 223, 182),
                    (221, 242, 178),
                    (246, 251, 198),
                    (255, 246, 183),
                    (254, 229, 143),
                    (254, 203, 103),
                    (253, 167, 71),
                    (252, 126, 55),
                    (247, 69, 39),
                    (222, 23, 29),
                    (185, 0, 38),
                    (128, 0, 38)],
    'misc_div_19': [(8, 29, 88),
                    (33, 49, 141),
                    (34, 84, 163),
                    (30, 128, 184),
                    (49, 165, 194),
                    (93, 192, 191),
                    (151, 214, 184),
                    (207, 236, 179),
                    (239, 248, 182),
                    (254, 254, 209),
                    (255, 239, 165),
                    (254, 221, 127),
                    (254, 191, 90),
                    (253, 157, 67),
                    (252, 113, 52),
                    (243, 60, 37),
                    (218, 20, 30),
                    (182, 0, 38),
                    (128, 0, 38)],
    'misc_div_20': [(8, 29, 88),
                    (32, 48, 138),
                    (34, 80, 161),
                    (31, 121, 180),
                    (42, 158, 193),
                    (78, 187, 194),
                    (131, 206, 186),
                    (192, 230, 180),
                    (227, 244, 177),
                    (247, 252, 200),
                    (255, 247, 186),
                    (254, 232, 149),
                    (254, 213, 114),
                    (254, 180, 78),
                    (253, 149, 63),
                    (252, 101, 48),
                    (240, 53, 35),
                    (215, 17, 31),
                    (179, 0, 38),
                    (128, 0, 38)],
    'misc_div_21': [(8, 29, 88),
                    (31, 47, 136),
                    (35, 77, 160),
                    (31, 114, 177),
                    (36, 152, 192),
                    (65, 182, 195),
                    (115, 200, 188),
                    (170, 222, 182),
                    (214, 239, 178),
                    (240, 249, 185),
                    (254, 254, 209),
                    (255, 240, 169),
                    (254, 225, 135),
                    (254, 201, 101),
                    (253, 170, 72),
                    (253, 141, 60),
                    (252, 90, 45),
                    (237, 47, 33),
                    (211, 15, 31),
                    (176, 0, 38),
                    (128, 0, 38)]
}


# sequential color maps
ipcc_sequential = {
    'temp_seq': [(254, 254, 203),
                 (254, 254, 202),
                 (254, 253, 200),
                 (254, 253, 198),
                 (254, 252, 196),
                 (254, 251, 195),
                 (254, 251, 193),
                 (254, 250, 191),
                 (254, 249, 189),
                 (254, 249, 187),
                 (253, 248, 186),
                 (253, 247, 184),
                 (253, 247, 182),
                 (253, 246, 180),
                 (253, 245, 178),
                 (253, 245, 177),
                 (253, 244, 175),
                 (253, 243, 173),
                 (252, 243, 171),
                 (252, 242, 170),
                 (252, 241, 168),
                 (252, 241, 166),
                 (252, 240, 164),
                 (252, 239, 162),
                 (252, 239, 160),
                 (251, 238, 159),
                 (251, 237, 157),
                 (251, 236, 155),
                 (251, 235, 153),
                 (251, 235, 151),
                 (250, 234, 150),
                 (250, 233, 148),
                 (250, 232, 146),
                 (250, 231, 144),
                 (250, 230, 142),
                 (249, 230, 140),
                 (249, 229, 138),
                 (249, 228, 137),
                 (249, 227, 135),
                 (249, 226, 133),
                 (248, 225, 131),
                 (248, 224, 129),
                 (248, 223, 127),
                 (248, 221, 126),
                 (247, 220, 124),
                 (247, 219, 122),
                 (247, 218, 120),
                 (247, 217, 119),
                 (246, 216, 117),
                 (246, 214, 115),
                 (246, 213, 114),
                 (245, 212, 112),
                 (245, 211, 110),
                 (245, 209, 109),
                 (244, 208, 107),
                 (244, 207, 106),
                 (244, 205, 105),
                 (243, 204, 103),
                 (243, 202, 102),
                 (243, 201, 101),
                 (243, 200, 99),
                 (242, 198, 98),
                 (242, 197, 97),
                 (242, 196, 96),
                 (241, 194, 95),
                 (241, 193, 94),
                 (241, 191, 93),
                 (240, 190, 92),
                 (240, 189, 92),
                 (240, 187, 91),
                 (239, 186, 90),
                 (239, 185, 90),
                 (239, 183, 89),
                 (239, 182, 88),
                 (238, 181, 88),
                 (238, 180, 87),
                 (238, 178, 87),
                 (237, 177, 87),
                 (237, 176, 86),
                 (237, 175, 86),
                 (237, 173, 85),
                 (236, 172, 85),
                 (236, 171, 85),
                 (236, 170, 85),
                 (236, 168, 84),
                 (235, 167, 84),
                 (235, 166, 84),
                 (235, 165, 84),
                 (235, 164, 83),
                 (234, 162, 83),
                 (234, 161, 83),
                 (234, 160, 83),
                 (234, 159, 83),
                 (233, 158, 83),
                 (233, 157, 82),
                 (233, 155, 82),
                 (233, 154, 82),
                 (232, 153, 82),
                 (232, 152, 82),
                 (232, 151, 82),
                 (232, 150, 82),
                 (231, 148, 82),
                 (231, 147, 82),
                 (231, 146, 81),
                 (230, 145, 81),
                 (230, 144, 81),
                 (230, 143, 81),
                 (230, 141, 81),
                 (229, 140, 81),
                 (229, 139, 81),
                 (229, 138, 81),
                 (228, 137, 81),
                 (228, 135, 81),
                 (228, 134, 80),
                 (228, 133, 80),
                 (227, 132, 80),
                 (227, 131, 80),
                 (226, 129, 80),
                 (226, 128, 80),
                 (226, 127, 80),
                 (225, 126, 80),
                 (225, 125, 80),
                 (224, 123, 79),
                 (224, 122, 79),
                 (223, 121, 79),
                 (223, 120, 79),
                 (222, 118, 79),
                 (222, 117, 79),
                 (221, 116, 79),
                 (221, 114, 79),
                 (220, 113, 78),
                 (219, 112, 78),
                 (219, 111, 78),
                 (218, 109, 78),
                 (217, 108, 78),
                 (216, 107, 78),
                 (215, 105, 77),
                 (214, 104, 77),
                 (213, 103, 77),
                 (212, 101, 77),
                 (211, 100, 77),
                 (210, 99, 76),
                 (209, 98, 76),
                 (208, 96, 76),
                 (207, 95, 76),
                 (205, 94, 75),
                 (204, 92, 75),
                 (203, 91, 75),
                 (201, 90, 75),
                 (200, 89, 74),
                 (198, 88, 74),
                 (197, 87, 74),
                 (195, 85, 73),
                 (194, 84, 73),
                 (192, 83, 73),
                 (190, 82, 72),
                 (189, 81, 72),
                 (187, 80, 72),
                 (185, 79, 71),
                 (184, 79, 71),
                 (182, 78, 70),
                 (180, 77, 70),
                 (178, 76, 70),
                 (177, 75, 69),
                 (175, 74, 69),
                 (173, 74, 68),
                 (171, 73, 68),
                 (170, 72, 67),
                 (168, 72, 67),
                 (166, 71, 66),
                 (164, 70, 66),
                 (162, 70, 65),
                 (161, 69, 65),
                 (159, 69, 64),
                 (157, 68, 63),
                 (155, 67, 63),
                 (153, 67, 62),
                 (152, 66, 62),
                 (150, 66, 61),
                 (148, 65, 60),
                 (146, 65, 60),
                 (144, 64, 59),
                 (143, 64, 58),
                 (141, 63, 58),
                 (139, 63, 57),
                 (137, 62, 56),
                 (135, 62, 56),
                 (134, 61, 55),
                 (132, 61, 54),
                 (130, 60, 53),
                 (128, 59, 53),
                 (127, 59, 52),
                 (125, 58, 51),
                 (123, 58, 50),
                 (121, 57, 50),
                 (119, 57, 49),
                 (118, 56, 48),
                 (116, 56, 47),
                 (114, 55, 46),
                 (112, 55, 46),
                 (111, 54, 45),
                 (109, 54, 44),
                 (107, 53, 43),
                 (106, 53, 42),
                 (104, 52, 42),
                 (102, 52, 41),
                 (100, 51, 40),
                 (99, 50, 39),
                 (97, 50, 38),
                 (95, 49, 38),
                 (94, 49, 37),
                 (92, 48, 36),
                 (90, 48, 35),
                 (89, 47, 34),
                 (87, 47, 33),
                 (85, 46, 33),
                 (84, 46, 32),
                 (82, 45, 31),
                 (80, 45, 30),
                 (79, 44, 30),
                 (77, 43, 29),
                 (75, 43, 28),
                 (74, 42, 27),
                 (72, 42, 27),
                 (71, 41, 26),
                 (69, 41, 25),
                 (67, 40, 24),
                 (66, 40, 24),
                 (64, 39, 23),
                 (63, 39, 22),
                 (61, 38, 22),
                 (59, 38, 21),
                 (58, 37, 20),
                 (56, 37, 20),
                 (55, 36, 19),
                 (53, 36, 18),
                 (52, 35, 18),
                 (50, 35, 17),
                 (49, 34, 16),
                 (47, 34, 15),
                 (46, 33, 15),
                 (44, 33, 14),
                 (43, 32, 13),
                 (41, 31, 12),
                 (40, 31, 11),
                 (39, 30, 10),
                 (37, 30, 9),
                 (36, 29, 8),
                 (34, 29, 7),
                 (33, 28, 6),
                 (32, 28, 5),
                 (30, 27, 4),
                 (29, 27, 3),
                 (28, 26, 2),
                 (26, 26, 1),
                 (25, 25, 0)],
    'prec_seq': [(255, 255, 229),
                 (253, 254, 228),
                 (252, 253, 227),
                 (251, 252, 227),
                 (249, 252, 226),
                 (248, 251, 226),
                 (247, 250, 225),
                 (245, 250, 225),
                 (244, 249, 224),
                 (243, 248, 223),
                 (241, 248, 223),
                 (240, 247, 222),
                 (239, 246, 222),
                 (237, 246, 221),
                 (236, 245, 221),
                 (235, 244, 220),
                 (233, 244, 220),
                 (232, 243, 219),
                 (231, 242, 218),
                 (229, 242, 218),
                 (228, 241, 217),
                 (227, 240, 217),
                 (225, 240, 216),
                 (224, 239, 216),
                 (223, 238, 215),
                 (221, 238, 214),
                 (220, 237, 214),
                 (219, 236, 213),
                 (218, 235, 213),
                 (216, 235, 212),
                 (215, 234, 212),
                 (214, 233, 211),
                 (212, 233, 211),
                 (211, 232, 210),
                 (210, 231, 209),
                 (208, 231, 209),
                 (207, 230, 208),
                 (206, 229, 208),
                 (204, 229, 207),
                 (203, 228, 207),
                 (202, 227, 206),
                 (200, 227, 205),
                 (199, 226, 205),
                 (198, 225, 204),
                 (196, 225, 204),
                 (195, 224, 203),
                 (194, 223, 203),
                 (192, 223, 202),
                 (191, 222, 202),
                 (190, 221, 201),
                 (188, 221, 200),
                 (187, 220, 200),
                 (186, 219, 199),
                 (185, 218, 199),
                 (183, 218, 198),
                 (182, 217, 198),
                 (181, 216, 197),
                 (179, 216, 196),
                 (178, 215, 196),
                 (177, 214, 195),
                 (175, 214, 195),
                 (174, 213, 194),
                 (173, 212, 194),
                 (171, 212, 193),
                 (170, 211, 193),
                 (169, 210, 192),
                 (167, 210, 191),
                 (166, 209, 191),
                 (165, 208, 190),
                 (163, 208, 190),
                 (162, 207, 189),
                 (161, 206, 189),
                 (159, 206, 188),
                 (158, 205, 187),
                 (157, 204, 187),
                 (155, 204, 186),
                 (154, 203, 186),
                 (153, 202, 185),
                 (152, 201, 185),
                 (150, 201, 184),
                 (149, 200, 184),
                 (148, 199, 183),
                 (146, 199, 182),
                 (145, 198, 182),
                 (144, 197, 181),
                 (142, 197, 181),
                 (141, 196, 180),
                 (140, 195, 180),
                 (138, 195, 179),
                 (137, 194, 178),
                 (136, 193, 178),
                 (134, 193, 177),
                 (133, 192, 177),
                 (132, 191, 176),
                 (130, 191, 176),
                 (129, 190, 175),
                 (128, 189, 175),
                 (126, 189, 174),
                 (125, 188, 173),
                 (124, 187, 173),
                 (122, 187, 172),
                 (121, 186, 172),
                 (120, 185, 171),
                 (119, 184, 171),
                 (117, 184, 170),
                 (116, 183, 169),
                 (115, 182, 169),
                 (113, 182, 168),
                 (112, 181, 168),
                 (111, 180, 167),
                 (109, 180, 167),
                 (108, 179, 166),
                 (107, 178, 166),
                 (105, 178, 165),
                 (104, 177, 164),
                 (103, 176, 164),
                 (101, 176, 163),
                 (100, 175, 163),
                 (99, 174, 162),
                 (97, 174, 162),
                 (96, 173, 161),
                 (95, 172, 160),
                 (93, 172, 160),
                 (92, 171, 159),
                 (91, 170, 159),
                 (89, 170, 158),
                 (88, 169, 158),
                 (87, 168, 157),
                 (86, 167, 157),
                 (84, 167, 156),
                 (83, 166, 155),
                 (82, 165, 155),
                 (80, 165, 154),
                 (79, 164, 154),
                 (78, 163, 153),
                 (76, 163, 153),
                 (75, 162, 152),
                 (74, 161, 151),
                 (72, 161, 151),
                 (71, 160, 150),
                 (70, 159, 150),
                 (68, 159, 149),
                 (67, 158, 149),
                 (66, 157, 148),
                 (64, 157, 148),
                 (63, 156, 147),
                 (62, 155, 146),
                 (60, 155, 146),
                 (59, 154, 145),
                 (58, 153, 145),
                 (56, 153, 144),
                 (55, 152, 144),
                 (54, 151, 143),
                 (53, 151, 143),
                 (52, 150, 142),
                 (51, 149, 141),
                 (51, 148, 140),
                 (50, 147, 139),
                 (50, 146, 138),
                 (49, 145, 137),
                 (49, 144, 136),
                 (48, 143, 135),
                 (48, 142, 134),
                 (47, 142, 133),
                 (47, 141, 132),
                 (46, 140, 131),
                 (46, 139, 130),
                 (45, 138, 129),
                 (45, 137, 129),
                 (44, 136, 128),
                 (44, 135, 127),
                 (43, 134, 126),
                 (43, 134, 125),
                 (42, 133, 124),
                 (42, 132, 123),
                 (41, 131, 122),
                 (41, 130, 121),
                 (40, 129, 120),
                 (40, 128, 119),
                 (39, 127, 118),
                 (38, 126, 117),
                 (38, 126, 116),
                 (37, 125, 115),
                 (37, 124, 115),
                 (36, 123, 114),
                 (36, 122, 113),
                 (35, 121, 112),
                 (35, 120, 111),
                 (34, 119, 110),
                 (34, 118, 109),
                 (33, 117, 108),
                 (33, 117, 107),
                 (32, 116, 106),
                 (32, 115, 105),
                 (31, 114, 104),
                 (31, 113, 103),
                 (30, 112, 102),
                 (30, 111, 102),
                 (29, 110, 101),
                 (29, 109, 100),
                 (28, 109, 99),
                 (28, 108, 98),
                 (27, 107, 97),
                 (27, 106, 96),
                 (26, 105, 95),
                 (25, 104, 94),
                 (25, 103, 93),
                 (24, 102, 92),
                 (24, 101, 91),
                 (23, 101, 90),
                 (23, 100, 89),
                 (22, 99, 88),
                 (22, 98, 88),
                 (21, 97, 87),
                 (21, 96, 86),
                 (20, 95, 85),
                 (20, 94, 84),
                 (19, 93, 83),
                 (19, 93, 82),
                 (18, 92, 81),
                 (18, 91, 80),
                 (17, 90, 79),
                 (17, 89, 78),
                 (16, 88, 77),
                 (16, 87, 76),
                 (15, 86, 75),
                 (15, 85, 75),
                 (14, 84, 74),
                 (14, 84, 73),
                 (13, 83, 72),
                 (12, 82, 71),
                 (12, 81, 70),
                 (11, 80, 69),
                 (11, 79, 68),
                 (10, 78, 67),
                 (10, 77, 66),
                 (9, 76, 65),
                 (9, 76, 64),
                 (8, 75, 63),
                 (8, 74, 62),
                 (7, 73, 61),
                 (7, 72, 61),
                 (6, 71, 60),
                 (6, 70, 59),
                 (5, 69, 58),
                 (5, 68, 57),
                 (4, 68, 56),
                 (4, 67, 55),
                 (3, 66, 54),
                 (3, 65, 53),
                 (2, 64, 52),
                 (2, 63, 51),
                 (1, 62, 50),
                 (1, 61, 49),
                 (0, 60, 48),
                 (0, 60, 48)],
    'wind_seq': [(254, 252, 205),
                 (254, 251, 202),
                 (253, 250, 200),
                 (252, 249, 198),
                 (252, 247, 196),
                 (251, 246, 194),
                 (250, 245, 192),
                 (250, 244, 190),
                 (249, 243, 188),
                 (248, 241, 185),
                 (248, 240, 183),
                 (247, 239, 181),
                 (246, 238, 179),
                 (246, 237, 177),
                 (245, 236, 175),
                 (244, 234, 173),
                 (244, 233, 171),
                 (243, 232, 168),
                 (242, 231, 166),
                 (242, 230, 164),
                 (241, 229, 162),
                 (240, 227, 160),
                 (240, 226, 158),
                 (239, 225, 156),
                 (238, 224, 153),
                 (238, 223, 151),
                 (237, 222, 149),
                 (236, 221, 147),
                 (235, 220, 145),
                 (235, 219, 143),
                 (234, 217, 140),
                 (233, 216, 138),
                 (232, 215, 136),
                 (232, 214, 134),
                 (231, 213, 132),
                 (230, 212, 129),
                 (229, 211, 127),
                 (229, 210, 125),
                 (228, 209, 123),
                 (227, 208, 121),
                 (226, 207, 119),
                 (225, 206, 116),
                 (224, 205, 114),
                 (223, 204, 112),
                 (223, 203, 110),
                 (222, 202, 108),
                 (221, 201, 106),
                 (220, 200, 103),
                 (219, 199, 101),
                 (218, 198, 99),
                 (217, 197, 97),
                 (216, 196, 95),
                 (215, 196, 93),
                 (214, 195, 91),
                 (213, 194, 88),
                 (212, 193, 86),
                 (211, 192, 84),
                 (209, 191, 82),
                 (208, 190, 80),
                 (207, 190, 78),
                 (206, 189, 76),
                 (205, 188, 74),
                 (203, 187, 72),
                 (202, 186, 70),
                 (201, 186, 68),
                 (200, 185, 66),
                 (198, 184, 64),
                 (197, 183, 62),
                 (195, 183, 60),
                 (194, 182, 59),
                 (193, 181, 57),
                 (191, 181, 55),
                 (190, 180, 53),
                 (188, 179, 51),
                 (187, 179, 50),
                 (185, 178, 48),
                 (184, 177, 46),
                 (182, 177, 44),
                 (181, 176, 43),
                 (179, 175, 41),
                 (178, 175, 40),
                 (176, 174, 38),
                 (175, 173, 36),
                 (173, 173, 35),
                 (171, 172, 33),
                 (170, 171, 32),
                 (168, 171, 30),
                 (167, 170, 29),
                 (165, 170, 28),
                 (163, 169, 26),
                 (162, 168, 25),
                 (160, 168, 23),
                 (158, 167, 22),
                 (157, 167, 21),
                 (155, 166, 20),
                 (153, 165, 18),
                 (151, 165, 17),
                 (150, 164, 16),
                 (148, 164, 15),
                 (146, 163, 14),
                 (145, 162, 13),
                 (143, 162, 12),
                 (141, 161, 11),
                 (139, 161, 10),
                 (138, 160, 9),
                 (136, 159, 8),
                 (134, 159, 7),
                 (132, 158, 7),
                 (131, 158, 6),
                 (129, 157, 6),
                 (127, 156, 6),
                 (125, 156, 5),
                 (124, 155, 5),
                 (122, 155, 5),
                 (120, 154, 5),
                 (118, 153, 5),
                 (116, 153, 5),
                 (115, 152, 5),
                 (113, 151, 6),
                 (111, 151, 6),
                 (109, 150, 7),
                 (107, 150, 7),
                 (106, 149, 8),
                 (104, 148, 8),
                 (102, 148, 9),
                 (100, 147, 9),
                 (98, 146, 10),
                 (97, 146, 11),
                 (95, 145, 12),
                 (93, 145, 12),
                 (91, 144, 13),
                 (89, 143, 14),
                 (87, 143, 15),
                 (86, 142, 16),
                 (84, 141, 16),
                 (82, 141, 17),
                 (80, 140, 18),
                 (78, 139, 19),
                 (76, 139, 20),
                 (75, 138, 20),
                 (73, 137, 21),
                 (71, 137, 22),
                 (69, 136, 23),
                 (67, 135, 23),
                 (66, 134, 24),
                 (64, 134, 25),
                 (62, 133, 26),
                 (60, 132, 26),
                 (59, 131, 27),
                 (57, 131, 28),
                 (55, 130, 28),
                 (53, 129, 29),
                 (52, 129, 30),
                 (50, 128, 30),
                 (48, 127, 31),
                 (46, 126, 32),
                 (45, 125, 32),
                 (43, 125, 33),
                 (42, 124, 33),
                 (40, 123, 34),
                 (38, 122, 35),
                 (37, 121, 35),
                 (35, 121, 36),
                 (34, 120, 36),
                 (32, 119, 37),
                 (31, 118, 37),
                 (29, 117, 38),
                 (28, 117, 38),
                 (26, 116, 39),
                 (25, 115, 39),
                 (24, 114, 39),
                 (22, 113, 40),
                 (21, 112, 40),
                 (20, 111, 40),
                 (19, 111, 41),
                 (18, 110, 41),
                 (17, 109, 41),
                 (16, 108, 42),
                 (15, 107, 42),
                 (14, 106, 42),
                 (13, 105, 43),
                 (13, 104, 43),
                 (12, 103, 43),
                 (12, 103, 43),
                 (11, 102, 43),
                 (11, 101, 44),
                 (11, 100, 44),
                 (10, 99, 44),
                 (10, 98, 44),
                 (10, 97, 44),
                 (10, 96, 44),
                 (11, 95, 44),
                 (11, 94, 44),
                 (11, 93, 44),
                 (11, 92, 44),
                 (12, 92, 44),
                 (12, 91, 44),
                 (12, 90, 44),
                 (13, 89, 44),
                 (13, 88, 44),
                 (14, 87, 44),
                 (14, 86, 44),
                 (15, 85, 44),
                 (15, 84, 44),
                 (15, 83, 44),
                 (16, 82, 43),
                 (16, 81, 43),
                 (17, 80, 43),
                 (17, 79, 43),
                 (18, 78, 43),
                 (18, 77, 42),
                 (19, 76, 42),
                 (19, 75, 42),
                 (20, 74, 42),
                 (20, 74, 41),
                 (20, 73, 41),
                 (21, 72, 41),
                 (21, 71, 40),
                 (21, 70, 40),
                 (22, 69, 40),
                 (22, 68, 39),
                 (22, 67, 39),
                 (23, 66, 39),
                 (23, 65, 38),
                 (23, 64, 38),
                 (23, 63, 37),
                 (24, 62, 37),
                 (24, 61, 36),
                 (24, 60, 36),
                 (24, 59, 35),
                 (24, 58, 35),
                 (24, 57, 34),
                 (25, 56, 34),
                 (25, 55, 33),
                 (25, 54, 33),
                 (25, 53, 32),
                 (25, 52, 31),
                 (25, 52, 31),
                 (25, 51, 30),
                 (25, 50, 30),
                 (25, 49, 29),
                 (25, 48, 28),
                 (25, 47, 28),
                 (25, 46, 27),
                 (25, 45, 26),
                 (24, 44, 26),
                 (24, 43, 25),
                 (24, 42, 24),
                 (24, 41, 24),
                 (24, 40, 23),
                 (24, 39, 22),
                 (23, 38, 21),
                 (23, 37, 21),
                 (23, 36, 20),
                 (23, 35, 19),
                 (23, 35, 18)],
    'cryo_seq': [(0, 1, 0),
                 (1, 2, 2),
                 (1, 3, 4),
                 (2, 4, 6),
                 (3, 5, 9),
                 (3, 6, 11),
                 (4, 7, 13),
                 (4, 9, 14),
                 (5, 10, 16),
                 (5, 11, 17),
                 (6, 12, 19),
                 (6, 13, 20),
                 (7, 14, 21),
                 (8, 15, 23),
                 (8, 16, 24),
                 (9, 16, 25),
                 (10, 17, 26),
                 (10, 18, 27),
                 (11, 19, 28),
                 (11, 20, 30),
                 (11, 20, 31),
                 (12, 21, 32),
                 (12, 22, 33),
                 (12, 23, 34),
                 (12, 23, 36),
                 (13, 24, 37),
                 (13, 25, 38),
                 (13, 25, 39),
                 (13, 26, 41),
                 (13, 27, 42),
                 (13, 28, 43),
                 (13, 28, 44),
                 (13, 29, 46),
                 (14, 30, 47),
                 (14, 31, 48),
                 (14, 31, 50),
                 (14, 32, 51),
                 (14, 33, 52),
                 (14, 34, 54),
                 (15, 35, 55),
                 (15, 35, 56),
                 (15, 36, 58),
                 (15, 37, 59),
                 (15, 38, 60),
                 (15, 39, 62),
                 (16, 40, 63),
                 (16, 40, 65),
                 (16, 41, 66),
                 (16, 42, 67),
                 (17, 43, 69),
                 (17, 44, 70),
                 (17, 45, 72),
                 (17, 45, 73),
                 (18, 46, 75),
                 (18, 47, 76),
                 (18, 48, 77),
                 (18, 49, 79),
                 (19, 50, 80),
                 (19, 51, 82),
                 (19, 52, 83),
                 (20, 53, 85),
                 (20, 54, 86),
                 (20, 54, 88),
                 (21, 55, 89),
                 (21, 56, 91),
                 (21, 57, 92),
                 (22, 58, 94),
                 (22, 59, 95),
                 (22, 60, 97),
                 (23, 61, 98),
                 (23, 62, 100),
                 (24, 63, 101),
                 (24, 64, 103),
                 (24, 65, 104),
                 (25, 65, 106),
                 (25, 66, 107),
                 (26, 67, 109),
                 (26, 68, 110),
                 (27, 69, 112),
                 (27, 70, 113),
                 (28, 71, 115),
                 (28, 72, 116),
                 (29, 73, 118),
                 (29, 74, 120),
                 (30, 75, 121),
                 (30, 76, 123),
                 (31, 77, 124),
                 (32, 78, 126),
                 (32, 79, 127),
                 (33, 80, 129),
                 (34, 80, 130),
                 (34, 81, 132),
                 (35, 82, 134),
                 (36, 83, 135),
                 (36, 84, 137),
                 (37, 85, 138),
                 (38, 86, 140),
                 (39, 87, 141),
                 (40, 88, 143),
                 (40, 89, 145),
                 (41, 90, 146),
                 (42, 91, 148),
                 (43, 92, 149),
                 (44, 93, 151),
                 (45, 94, 153),
                 (46, 95, 154),
                 (47, 96, 156),
                 (48, 97, 157),
                 (50, 99, 159),
                 (51, 100, 161),
                 (52, 101, 162),
                 (53, 102, 164),
                 (55, 103, 165),
                 (56, 104, 167),
                 (57, 105, 169),
                 (59, 106, 170),
                 (60, 108, 172),
                 (62, 109, 173),
                 (63, 110, 175),
                 (65, 111, 176),
                 (66, 112, 178),
                 (68, 114, 179),
                 (69, 115, 180),
                 (71, 116, 182),
                 (72, 117, 183),
                 (74, 119, 184),
                 (76, 120, 185),
                 (77, 121, 187),
                 (79, 122, 188),
                 (81, 123, 189),
                 (82, 125, 190),
                 (84, 126, 191),
                 (86, 127, 192),
                 (87, 128, 193),
                 (89, 129, 193),
                 (90, 130, 194),
                 (92, 131, 195),
                 (94, 133, 196),
                 (95, 134, 196),
                 (97, 135, 197),
                 (98, 136, 197),
                 (99, 137, 198),
                 (101, 138, 198),
                 (102, 139, 199),
                 (104, 139, 199),
                 (105, 140, 199),
                 (106, 141, 200),
                 (108, 142, 200),
                 (109, 143, 200),
                 (110, 144, 200),
                 (112, 145, 200),
                 (113, 146, 201),
                 (114, 146, 201),
                 (116, 147, 201),
                 (117, 148, 201),
                 (118, 149, 201),
                 (119, 150, 201),
                 (121, 150, 201),
                 (122, 151, 201),
                 (123, 152, 201),
                 (124, 153, 201),
                 (125, 153, 201),
                 (127, 154, 201),
                 (128, 155, 201),
                 (129, 156, 201),
                 (130, 156, 201),
                 (131, 157, 201),
                 (132, 158, 201),
                 (134, 159, 201),
                 (135, 159, 201),
                 (136, 160, 201),
                 (137, 161, 201),
                 (138, 161, 201),
                 (140, 162, 201),
                 (141, 163, 201),
                 (142, 164, 201),
                 (143, 164, 201),
                 (144, 165, 201),
                 (145, 166, 201),
                 (147, 167, 201),
                 (148, 167, 201),
                 (149, 168, 201),
                 (150, 169, 201),
                 (151, 170, 201),
                 (153, 170, 201),
                 (154, 171, 201),
                 (155, 172, 201),
                 (156, 173, 201),
                 (157, 173, 201),
                 (159, 174, 201),
                 (160, 175, 201),
                 (161, 176, 201),
                 (162, 177, 201),
                 (164, 177, 201),
                 (165, 178, 201),
                 (166, 179, 201),
                 (167, 180, 202),
                 (169, 181, 202),
                 (170, 182, 202),
                 (171, 182, 202),
                 (172, 183, 202),
                 (174, 184, 202),
                 (175, 185, 203),
                 (176, 186, 203),
                 (178, 187, 203),
                 (179, 188, 203),
                 (180, 189, 204),
                 (182, 190, 204),
                 (183, 191, 205),
                 (185, 192, 205),
                 (186, 193, 205),
                 (187, 194, 206),
                 (189, 195, 206),
                 (190, 196, 207),
                 (192, 197, 208),
                 (193, 199, 208),
                 (195, 200, 209),
                 (196, 201, 209),
                 (198, 202, 210),
                 (199, 203, 211),
                 (200, 205, 212),
                 (202, 206, 213),
                 (203, 207, 213),
                 (205, 208, 214),
                 (207, 210, 215),
                 (208, 211, 216),
                 (210, 212, 217),
                 (211, 214, 218),
                 (213, 215, 219),
                 (214, 216, 220),
                 (216, 218, 221),
                 (217, 219, 222),
                 (219, 221, 224),
                 (220, 222, 225),
                 (222, 223, 226),
                 (223, 225, 227),
                 (225, 226, 228),
                 (227, 228, 230),
                 (228, 229, 231),
                 (230, 231, 232),
                 (231, 232, 233),
                 (233, 234, 235),
                 (234, 235, 236),
                 (236, 236, 238),
                 (237, 238, 239),
                 (239, 239, 240),
                 (241, 241, 242),
                 (242, 242, 243),
                 (244, 244, 244),
                 (245, 245, 246),
                 (247, 247, 247),
                 (248, 248, 249),
                 (250, 250, 250),
                 (251, 251, 252),
                 (253, 253, 253),
                 (254, 255, 254)],
    'chem_seq': [(254, 254, 216),
                 (253, 254, 215),
                 (251, 253, 214),
                 (250, 253, 213),
                 (249, 253, 212),
                 (247, 253, 211),
                 (246, 253, 211),
                 (245, 252, 210),
                 (244, 252, 209),
                 (242, 252, 208),
                 (241, 251, 207),
                 (240, 251, 206),
                 (238, 251, 205),
                 (237, 250, 204),
                 (235, 250, 203),
                 (234, 250, 202),
                 (232, 249, 201),
                 (231, 249, 200),
                 (229, 248, 199),
                 (228, 248, 198),
                 (226, 247, 197),
                 (225, 246, 195),
                 (223, 246, 194),
                 (221, 245, 193),
                 (220, 244, 192),
                 (218, 244, 191),
                 (216, 243, 190),
                 (215, 242, 189),
                 (213, 241, 187),
                 (211, 240, 186),
                 (209, 239, 185),
                 (207, 238, 184),
                 (206, 237, 183),
                 (204, 236, 181),
                 (202, 235, 180),
                 (200, 234, 179),
                 (198, 233, 178),
                 (196, 232, 177),
                 (195, 231, 175),
                 (193, 229, 174),
                 (191, 228, 173),
                 (189, 227, 172),
                 (188, 226, 171),
                 (186, 224, 170),
                 (184, 223, 169),
                 (183, 221, 168),
                 (181, 220, 166),
                 (179, 219, 165),
                 (178, 217, 164),
                 (176, 216, 163),
                 (175, 215, 163),
                 (174, 213, 162),
                 (172, 212, 161),
                 (171, 210, 160),
                 (170, 209, 159),
                 (169, 208, 158),
                 (168, 206, 157),
                 (166, 205, 157),
                 (165, 204, 156),
                 (164, 203, 155),
                 (163, 201, 155),
                 (163, 200, 154),
                 (162, 199, 153),
                 (161, 198, 153),
                 (160, 196, 152),
                 (159, 195, 152),
                 (159, 194, 151),
                 (158, 193, 151),
                 (157, 192, 150),
                 (157, 190, 150),
                 (156, 189, 149),
                 (156, 188, 149),
                 (155, 187, 149),
                 (155, 186, 148),
                 (154, 185, 148),
                 (154, 184, 147),
                 (154, 183, 147),
                 (153, 182, 147),
                 (153, 181, 146),
                 (152, 180, 146),
                 (152, 179, 146),
                 (152, 178, 145),
                 (151, 177, 145),
                 (151, 176, 145),
                 (151, 175, 144),
                 (151, 174, 144),
                 (150, 173, 144),
                 (150, 172, 144),
                 (150, 171, 143),
                 (150, 170, 143),
                 (149, 169, 143),
                 (149, 168, 143),
                 (149, 167, 142),
                 (149, 166, 142),
                 (148, 165, 142),
                 (148, 164, 142),
                 (148, 163, 141),
                 (148, 162, 141),
                 (148, 161, 141),
                 (148, 160, 140),
                 (147, 159, 140),
                 (147, 158, 140),
                 (147, 157, 140),
                 (147, 157, 139),
                 (147, 156, 139),
                 (147, 155, 139),
                 (146, 154, 139),
                 (146, 153, 138),
                 (146, 152, 138),
                 (146, 151, 138),
                 (146, 150, 138),
                 (146, 149, 137),
                 (145, 148, 137),
                 (145, 147, 137),
                 (145, 146, 137),
                 (145, 146, 136),
                 (145, 145, 136),
                 (145, 144, 136),
                 (144, 143, 136),
                 (144, 142, 135),
                 (144, 141, 135),
                 (144, 140, 135),
                 (144, 139, 135),
                 (144, 138, 134),
                 (144, 137, 134),
                 (143, 136, 134),
                 (143, 135, 134),
                 (143, 135, 133),
                 (143, 134, 133),
                 (143, 133, 133),
                 (143, 132, 133),
                 (142, 131, 132),
                 (142, 130, 132),
                 (142, 129, 132),
                 (142, 128, 132),
                 (142, 127, 131),
                 (142, 126, 131),
                 (141, 125, 131),
                 (141, 125, 130),
                 (141, 124, 130),
                 (141, 123, 130),
                 (141, 122, 130),
                 (140, 121, 129),
                 (140, 120, 129),
                 (140, 119, 129),
                 (140, 118, 129),
                 (140, 117, 128),
                 (139, 116, 128),
                 (139, 115, 128),
                 (139, 114, 127),
                 (139, 113, 127),
                 (139, 112, 127),
                 (138, 111, 126),
                 (138, 111, 126),
                 (138, 110, 126),
                 (138, 109, 125),
                 (137, 108, 125),
                 (137, 107, 125),
                 (137, 106, 124),
                 (136, 105, 124),
                 (136, 104, 124),
                 (136, 103, 123),
                 (135, 102, 123),
                 (135, 101, 123),
                 (135, 100, 122),
                 (134, 99, 122),
                 (134, 98, 121),
                 (133, 97, 121),
                 (133, 96, 121),
                 (133, 95, 120),
                 (132, 94, 120),
                 (132, 93, 119),
                 (131, 91, 119),
                 (131, 90, 118),
                 (130, 89, 118),
                 (130, 88, 117),
                 (129, 87, 117),
                 (128, 86, 116),
                 (128, 85, 116),
                 (127, 84, 115),
                 (126, 83, 115),
                 (126, 82, 114),
                 (125, 80, 114),
                 (124, 79, 113),
                 (124, 78, 112),
                 (123, 77, 112),
                 (122, 76, 111),
                 (121, 75, 111),
                 (120, 73, 110),
                 (119, 72, 109),
                 (118, 71, 108),
                 (117, 70, 108),
                 (116, 69, 107),
                 (115, 68, 106),
                 (114, 66, 106),
                 (113, 65, 105),
                 (112, 64, 104),
                 (111, 63, 103),
                 (110, 62, 102),
                 (109, 60, 102),
                 (107, 59, 101),
                 (106, 58, 100),
                 (105, 57, 99),
                 (104, 56, 98),
                 (102, 54, 97),
                 (101, 53, 96),
                 (100, 52, 95),
                 (98, 51, 95),
                 (97, 50, 94),
                 (96, 49, 93),
                 (94, 48, 92),
                 (93, 46, 91),
                 (91, 45, 90),
                 (90, 44, 89),
                 (88, 43, 88),
                 (87, 42, 87),
                 (85, 41, 86),
                 (84, 40, 85),
                 (82, 39, 84),
                 (81, 38, 83),
                 (79, 37, 82),
                 (78, 36, 81),
                 (76, 35, 80),
                 (75, 34, 79),
                 (73, 34, 78),
                 (72, 33, 78),
                 (70, 32, 77),
                 (68, 31, 76),
                 (67, 30, 75),
                 (65, 29, 74),
                 (64, 29, 73),
                 (62, 28, 72),
                 (61, 27, 71),
                 (59, 27, 70),
                 (58, 26, 69),
                 (56, 25, 68),
                 (55, 24, 67),
                 (53, 24, 66),
                 (52, 23, 66),
                 (50, 23, 65),
                 (49, 22, 64),
                 (47, 21, 63),
                 (46, 21, 62),
                 (44, 20, 61),
                 (43, 20, 60),
                 (41, 19, 59),
                 (40, 19, 59),
                 (38, 18, 58),
                 (37, 18, 57),
                 (35, 17, 56),
                 (34, 17, 55),
                 (32, 16, 54),
                 (31, 16, 54),
                 (29, 15, 53),
                 (27, 15, 52),
                 (26, 14, 51)],
    'slev_seq': [(254, 254, 254),
                 (254, 254, 253),
                 (253, 253, 251),
                 (253, 253, 250),
                 (253, 253, 248),
                 (253, 253, 247),
                 (253, 252, 245),
                 (252, 252, 244),
                 (252, 252, 242),
                 (252, 251, 241),
                 (251, 251, 239),
                 (251, 251, 238),
                 (251, 250, 236),
                 (250, 250, 234),
                 (250, 250, 233),
                 (250, 249, 231),
                 (249, 249, 230),
                 (249, 249, 228),
                 (248, 248, 227),
                 (248, 248, 225),
                 (247, 247, 223),
                 (247, 247, 222),
                 (246, 246, 220),
                 (246, 246, 218),
                 (245, 245, 217),
                 (244, 245, 215),
                 (244, 244, 213),
                 (243, 243, 211),
                 (242, 243, 210),
                 (241, 242, 208),
                 (240, 241, 206),
                 (239, 241, 204),
                 (239, 240, 203),
                 (238, 239, 201),
                 (236, 238, 199),
                 (235, 237, 197),
                 (234, 236, 195),
                 (233, 235, 193),
                 (232, 234, 191),
                 (231, 233, 190),
                 (229, 232, 188),
                 (228, 231, 186),
                 (226, 230, 184),
                 (225, 229, 182),
                 (223, 228, 180),
                 (222, 226, 178),
                 (220, 225, 176),
                 (219, 224, 174),
                 (217, 222, 173),
                 (215, 221, 171),
                 (213, 220, 169),
                 (212, 218, 167),
                 (210, 217, 165),
                 (208, 215, 164),
                 (206, 214, 162),
                 (204, 212, 160),
                 (202, 211, 159),
                 (200, 209, 157),
                 (198, 208, 156),
                 (197, 206, 154),
                 (195, 205, 153),
                 (193, 203, 151),
                 (191, 202, 150),
                 (189, 200, 149),
                 (187, 199, 147),
                 (185, 197, 146),
                 (183, 196, 145),
                 (181, 194, 144),
                 (179, 193, 143),
                 (178, 192, 142),
                 (176, 190, 142),
                 (174, 189, 141),
                 (172, 187, 140),
                 (171, 186, 139),
                 (169, 185, 139),
                 (167, 184, 138),
                 (166, 182, 138),
                 (164, 181, 137),
                 (162, 180, 137),
                 (161, 179, 136),
                 (159, 178, 136),
                 (158, 176, 136),
                 (156, 175, 135),
                 (155, 174, 135),
                 (154, 173, 135),
                 (152, 172, 135),
                 (151, 171, 135),
                 (150, 170, 135),
                 (148, 169, 135),
                 (147, 168, 135),
                 (146, 167, 135),
                 (144, 166, 135),
                 (143, 166, 135),
                 (142, 165, 135),
                 (141, 164, 135),
                 (140, 163, 135),
                 (139, 162, 136),
                 (137, 161, 136),
                 (136, 161, 136),
                 (135, 160, 136),
                 (134, 159, 136),
                 (133, 158, 137),
                 (132, 158, 137),
                 (131, 157, 137),
                 (130, 156, 137),
                 (129, 155, 138),
                 (128, 155, 138),
                 (127, 154, 138),
                 (126, 153, 139),
                 (125, 153, 139),
                 (124, 152, 139),
                 (123, 151, 140),
                 (122, 151, 140),
                 (121, 150, 141),
                 (120, 149, 141),
                 (119, 149, 141),
                 (118, 148, 142),
                 (117, 147, 142),
                 (116, 147, 143),
                 (115, 146, 143),
                 (114, 146, 143),
                 (113, 145, 144),
                 (112, 144, 144),
                 (111, 144, 145),
                 (110, 143, 145),
                 (109, 142, 145),
                 (108, 142, 146),
                 (108, 141, 146),
                 (107, 141, 147),
                 (106, 140, 147),
                 (105, 139, 147),
                 (104, 139, 148),
                 (103, 138, 148),
                 (102, 138, 149),
                 (101, 137, 149),
                 (100, 136, 149),
                 (99, 136, 150),
                 (98, 135, 150),
                 (97, 135, 150),
                 (96, 134, 151),
                 (95, 133, 151),
                 (94, 133, 152),
                 (94, 132, 152),
                 (93, 131, 152),
                 (92, 131, 153),
                 (91, 130, 153),
                 (90, 129, 153),
                 (89, 129, 153),
                 (88, 128, 154),
                 (87, 127, 154),
                 (86, 127, 154),
                 (85, 126, 155),
                 (84, 125, 155),
                 (83, 125, 155),
                 (82, 124, 155),
                 (81, 123, 155),
                 (80, 122, 156),
                 (79, 122, 156),
                 (78, 121, 156),
                 (77, 120, 156),
                 (76, 119, 156),
                 (75, 119, 156),
                 (74, 118, 156),
                 (74, 117, 157),
                 (73, 116, 157),
                 (72, 115, 157),
                 (71, 115, 157),
                 (70, 114, 157),
                 (69, 113, 157),
                 (68, 112, 157),
                 (67, 111, 157),
                 (66, 110, 156),
                 (65, 109, 156),
                 (64, 108, 156),
                 (63, 107, 156),
                 (62, 107, 156),
                 (61, 106, 156),
                 (60, 105, 155),
                 (59, 104, 155),
                 (58, 103, 155),
                 (57, 102, 155),
                 (56, 101, 154),
                 (55, 100, 154),
                 (54, 98, 154),
                 (53, 97, 153),
                 (52, 96, 153),
                 (51, 95, 152),
                 (50, 94, 152),
                 (49, 93, 151),
                 (48, 92, 151),
                 (47, 91, 150),
                 (47, 90, 150),
                 (46, 89, 149),
                 (45, 87, 148),
                 (44, 86, 148),
                 (43, 85, 147),
                 (42, 84, 146),
                 (41, 83, 145),
                 (40, 81, 145),
                 (39, 80, 144),
                 (38, 79, 143),
                 (37, 78, 142),
                 (37, 76, 141),
                 (36, 75, 140),
                 (35, 74, 139),
                 (34, 73, 139),
                 (33, 71, 138),
                 (32, 70, 137),
                 (31, 69, 136),
                 (31, 68, 135),
                 (30, 66, 133),
                 (29, 65, 132),
                 (28, 64, 131),
                 (27, 62, 130),
                 (27, 61, 129),
                 (26, 60, 128),
                 (25, 58, 127),
                 (24, 57, 126),
                 (24, 56, 124),
                 (23, 54, 123),
                 (22, 53, 122),
                 (21, 52, 121),
                 (21, 50, 119),
                 (20, 49, 118),
                 (19, 48, 117),
                 (18, 46, 116),
                 (18, 45, 114),
                 (17, 44, 113),
                 (16, 43, 112),
                 (15, 41, 110),
                 (15, 40, 109),
                 (14, 39, 108),
                 (13, 37, 106),
                 (12, 36, 105),
                 (12, 35, 103),
                 (11, 33, 102),
                 (10, 32, 101),
                 (9, 31, 99),
                 (8, 29, 98),
                 (8, 28, 97),
                 (7, 27, 95),
                 (6, 25, 94),
                 (6, 24, 92),
                 (5, 23, 91),
                 (4, 21, 89),
                 (4, 20, 88),
                 (3, 19, 87),
                 (2, 17, 85),
                 (2, 16, 84),
                 (1, 14, 82),
                 (1, 13, 81),
                 (0, 12, 80),
                 (0, 10, 78),
                 (0, 8, 77),
                 (0, 6, 75),
                 (0, 5, 74)],
    'misc_seq_1': [(25, 51, 178),
                   (26, 51, 178),
                   (26, 52, 177),
                   (27, 53, 177),
                   (27, 53, 177),
                   (28, 54, 176),
                   (28, 55, 176),
                   (28, 56, 176),
                   (29, 56, 175),
                   (29, 57, 175),
                   (29, 58, 175),
                   (30, 58, 174),
                   (30, 59, 174),
                   (31, 60, 174),
                   (31, 60, 173),
                   (31, 61, 173),
                   (32, 62, 172),
                   (32, 62, 172),
                   (32, 63, 172),
                   (33, 64, 171),
                   (33, 65, 171),
                   (33, 65, 171),
                   (34, 66, 170),
                   (34, 67, 170),
                   (34, 67, 170),
                   (35, 68, 169),
                   (35, 69, 169),
                   (35, 69, 169),
                   (36, 70, 168),
                   (36, 71, 168),
                   (36, 71, 168),
                   (37, 72, 167),
                   (37, 72, 167),
                   (37, 73, 167),
                   (38, 74, 166),
                   (38, 74, 166),
                   (38, 75, 166),
                   (39, 76, 165),
                   (39, 76, 165),
                   (39, 77, 165),
                   (40, 78, 164),
                   (40, 78, 164),
                   (40, 79, 164),
                   (40, 80, 163),
                   (41, 80, 163),
                   (41, 81, 163),
                   (41, 82, 162),
                   (42, 82, 162),
                   (42, 83, 162),
                   (42, 84, 161),
                   (43, 84, 161),
                   (43, 85, 161),
                   (43, 86, 160),
                   (44, 86, 160),
                   (44, 87, 160),
                   (44, 88, 159),
                   (45, 88, 159),
                   (45, 89, 159),
                   (45, 90, 158),
                   (46, 90, 158),
                   (46, 91, 158),
                   (46, 91, 157),
                   (47, 92, 157),
                   (47, 93, 157),
                   (48, 93, 156),
                   (48, 94, 156),
                   (48, 95, 156),
                   (49, 95, 155),
                   (49, 96, 155),
                   (49, 97, 154),
                   (50, 97, 154),
                   (50, 98, 154),
                   (51, 98, 153),
                   (51, 99, 153),
                   (52, 100, 152),
                   (52, 100, 152),
                   (52, 101, 152),
                   (53, 101, 151),
                   (53, 102, 151),
                   (54, 103, 150),
                   (54, 103, 150),
                   (55, 104, 149),
                   (55, 104, 149),
                   (56, 105, 148),
                   (56, 106, 148),
                   (57, 106, 147),
                   (57, 107, 147),
                   (58, 107, 146),
                   (58, 108, 146),
                   (59, 109, 145),
                   (59, 109, 145),
                   (60, 110, 144),
                   (60, 110, 144),
                   (61, 111, 143),
                   (61, 111, 143),
                   (62, 112, 142),
                   (63, 112, 141),
                   (63, 113, 141),
                   (64, 114, 140),
                   (64, 114, 140),
                   (65, 115, 139),
                   (65, 115, 139),
                   (66, 116, 138),
                   (66, 117, 138),
                   (67, 117, 137),
                   (68, 118, 137),
                   (68, 118, 136),
                   (69, 119, 136),
                   (69, 120, 135),
                   (70, 120, 135),
                   (71, 121, 134),
                   (71, 121, 134),
                   (72, 122, 133),
                   (72, 123, 133),
                   (73, 123, 132),
                   (74, 124, 132),
                   (74, 125, 131),
                   (75, 125, 131),
                   (76, 126, 130),
                   (77, 127, 130),
                   (77, 128, 129),
                   (78, 128, 129),
                   (79, 129, 129),
                   (79, 130, 128),
                   (80, 131, 128),
                   (81, 131, 127),
                   (82, 132, 127),
                   (83, 133, 127),
                   (83, 134, 126),
                   (84, 135, 126),
                   (85, 135, 126),
                   (86, 136, 125),
                   (87, 137, 125),
                   (88, 138, 125),
                   (88, 139, 125),
                   (89, 140, 124),
                   (90, 141, 124),
                   (91, 141, 124),
                   (92, 142, 123),
                   (93, 143, 123),
                   (94, 144, 123),
                   (95, 145, 123),
                   (96, 146, 122),
                   (96, 147, 122),
                   (97, 148, 122),
                   (98, 149, 122),
                   (99, 150, 121),
                   (100, 151, 121),
                   (101, 152, 121),
                   (102, 153, 121),
                   (103, 153, 121),
                   (104, 154, 120),
                   (105, 155, 120),
                   (106, 156, 120),
                   (107, 157, 120),
                   (108, 158, 119),
                   (109, 159, 119),
                   (110, 160, 119),
                   (111, 161, 119),
                   (112, 162, 118),
                   (113, 163, 118),
                   (114, 164, 118),
                   (115, 165, 118),
                   (115, 166, 117),
                   (116, 167, 117),
                   (117, 168, 117),
                   (118, 169, 117),
                   (119, 170, 116),
                   (120, 171, 116),
                   (121, 172, 116),
                   (122, 173, 116),
                   (123, 174, 115),
                   (124, 175, 115),
                   (125, 176, 115),
                   (126, 177, 115),
                   (127, 178, 114),
                   (128, 179, 114),
                   (130, 180, 114),
                   (131, 181, 114),
                   (132, 182, 113),
                   (133, 183, 113),
                   (134, 184, 113),
                   (135, 185, 113),
                   (136, 186, 112),
                   (137, 187, 112),
                   (138, 189, 112),
                   (139, 190, 112),
                   (140, 191, 111),
                   (141, 192, 111),
                   (142, 193, 111),
                   (143, 194, 111),
                   (144, 195, 110),
                   (145, 196, 110),
                   (146, 197, 110),
                   (147, 198, 109),
                   (148, 199, 109),
                   (150, 200, 109),
                   (151, 201, 109),
                   (152, 202, 108),
                   (153, 204, 108),
                   (154, 205, 108),
                   (155, 206, 108),
                   (156, 207, 107),
                   (158, 208, 107),
                   (159, 209, 107),
                   (160, 210, 107),
                   (161, 211, 106),
                   (163, 212, 106),
                   (164, 213, 106),
                   (165, 215, 106),
                   (167, 216, 105),
                   (168, 217, 105),
                   (170, 218, 105),
                   (171, 219, 105),
                   (173, 220, 104),
                   (174, 221, 104),
                   (176, 222, 104),
                   (177, 223, 104),
                   (179, 224, 104),
                   (181, 225, 103),
                   (183, 226, 103),
                   (184, 227, 103),
                   (186, 228, 103),
                   (188, 229, 103),
                   (190, 230, 103),
                   (192, 231, 103),
                   (194, 232, 102),
                   (196, 233, 102),
                   (198, 234, 102),
                   (200, 235, 102),
                   (202, 236, 102),
                   (204, 237, 102),
                   (206, 237, 102),
                   (208, 238, 102),
                   (210, 239, 102),
                   (212, 240, 102),
                   (214, 241, 102),
                   (217, 241, 102),
                   (219, 242, 102),
                   (221, 243, 102),
                   (223, 244, 102),
                   (225, 245, 102),
                   (227, 245, 102),
                   (229, 246, 102),
                   (231, 247, 102),
                   (233, 247, 102),
                   (236, 248, 102),
                   (238, 249, 102),
                   (240, 250, 102),
                   (242, 250, 102),
                   (244, 251, 102),
                   (246, 252, 102),
                   (248, 252, 102),
                   (250, 253, 102),
                   (252, 254, 102),
                   (255, 254, 102)],
    'misc_seq_2': [(230, 240, 240),
                   (228, 239, 239),
                   (226, 239, 239),
                   (224, 238, 238),
                   (223, 237, 238),
                   (221, 236, 237),
                   (219, 235, 236),
                   (218, 235, 236),
                   (216, 234, 235),
                   (214, 233, 235),
                   (212, 232, 234),
                   (211, 231, 234),
                   (209, 230, 233),
                   (207, 230, 233),
                   (206, 229, 232),
                   (204, 228, 232),
                   (202, 227, 231),
                   (201, 226, 231),
                   (199, 225, 231),
                   (197, 225, 230),
                   (196, 224, 230),
                   (194, 223, 230),
                   (192, 222, 229),
                   (191, 221, 229),
                   (189, 220, 229),
                   (187, 220, 228),
                   (186, 219, 228),
                   (184, 218, 228),
                   (183, 217, 228),
                   (181, 216, 228),
                   (179, 215, 227),
                   (178, 215, 227),
                   (176, 214, 227),
                   (175, 213, 227),
                   (173, 212, 227),
                   (172, 211, 227),
                   (170, 210, 226),
                   (169, 209, 226),
                   (167, 209, 226),
                   (166, 208, 226),
                   (164, 207, 226),
                   (163, 206, 226),
                   (161, 205, 226),
                   (160, 204, 226),
                   (159, 203, 226),
                   (157, 202, 226),
                   (156, 201, 226),
                   (154, 201, 226),
                   (153, 200, 226),
                   (152, 199, 226),
                   (150, 198, 226),
                   (149, 197, 226),
                   (148, 196, 226),
                   (146, 195, 226),
                   (145, 194, 226),
                   (144, 193, 226),
                   (143, 192, 226),
                   (141, 191, 226),
                   (140, 190, 226),
                   (139, 190, 226),
                   (138, 189, 226),
                   (137, 188, 226),
                   (136, 187, 226),
                   (135, 186, 226),
                   (134, 185, 226),
                   (133, 184, 226),
                   (132, 183, 227),
                   (131, 182, 227),
                   (130, 181, 227),
                   (129, 180, 227),
                   (128, 179, 227),
                   (127, 178, 227),
                   (126, 177, 227),
                   (125, 176, 227),
                   (124, 175, 227),
                   (124, 174, 227),
                   (123, 173, 227),
                   (122, 172, 228),
                   (122, 171, 228),
                   (121, 170, 228),
                   (120, 169, 228),
                   (120, 167, 228),
                   (119, 166, 228),
                   (119, 165, 228),
                   (118, 164, 228),
                   (118, 163, 228),
                   (117, 162, 228),
                   (117, 161, 228),
                   (117, 160, 228),
                   (116, 159, 228),
                   (116, 158, 228),
                   (116, 156, 228),
                   (116, 155, 228),
                   (115, 154, 228),
                   (115, 153, 228),
                   (115, 152, 228),
                   (115, 151, 228),
                   (115, 150, 227),
                   (115, 148, 227),
                   (115, 147, 227),
                   (115, 146, 227),
                   (115, 145, 227),
                   (115, 144, 227),
                   (115, 143, 226),
                   (115, 141, 226),
                   (115, 140, 226),
                   (115, 139, 225),
                   (115, 138, 225),
                   (115, 137, 225),
                   (116, 135, 224),
                   (116, 134, 224),
                   (116, 133, 223),
                   (116, 132, 223),
                   (116, 131, 223),
                   (116, 129, 222),
                   (117, 128, 221),
                   (117, 127, 221),
                   (117, 126, 220),
                   (117, 125, 220),
                   (117, 123, 219),
                   (118, 122, 218),
                   (118, 121, 218),
                   (118, 120, 217),
                   (118, 119, 216),
                   (118, 117, 216),
                   (118, 116, 215),
                   (119, 115, 214),
                   (119, 114, 213),
                   (119, 113, 213),
                   (119, 111, 212),
                   (119, 110, 211),
                   (119, 109, 210),
                   (120, 108, 209),
                   (120, 107, 208),
                   (120, 105, 207),
                   (120, 104, 206),
                   (120, 103, 205),
                   (120, 102, 204),
                   (120, 101, 203),
                   (120, 100, 202),
                   (120, 99, 201),
                   (121, 97, 200),
                   (121, 96, 199),
                   (121, 95, 198),
                   (121, 94, 197),
                   (121, 93, 196),
                   (121, 92, 195),
                   (121, 91, 194),
                   (121, 89, 192),
                   (121, 88, 191),
                   (121, 87, 190),
                   (121, 86, 189),
                   (121, 85, 188),
                   (120, 84, 186),
                   (120, 83, 185),
                   (120, 82, 184),
                   (120, 81, 183),
                   (120, 80, 181),
                   (120, 79, 180),
                   (120, 77, 179),
                   (120, 76, 178),
                   (120, 75, 176),
                   (119, 74, 175),
                   (119, 73, 174),
                   (119, 72, 172),
                   (119, 71, 171),
                   (119, 70, 170),
                   (119, 69, 168),
                   (118, 68, 167),
                   (118, 67, 165),
                   (118, 66, 164),
                   (118, 65, 163),
                   (117, 64, 161),
                   (117, 63, 160),
                   (117, 62, 158),
                   (116, 61, 157),
                   (116, 60, 155),
                   (116, 59, 154),
                   (116, 58, 153),
                   (115, 57, 151),
                   (115, 56, 150),
                   (115, 55, 148),
                   (114, 54, 147),
                   (114, 53, 145),
                   (113, 52, 144),
                   (113, 51, 142),
                   (113, 50, 141),
                   (112, 49, 139),
                   (112, 49, 138),
                   (111, 48, 136),
                   (111, 47, 134),
                   (110, 46, 133),
                   (110, 45, 131),
                   (109, 44, 130),
                   (109, 43, 128),
                   (108, 42, 127),
                   (108, 42, 125),
                   (107, 41, 123),
                   (107, 40, 122),
                   (106, 39, 120),
                   (106, 38, 119),
                   (105, 37, 117),
                   (105, 37, 115),
                   (104, 36, 114),
                   (103, 35, 112),
                   (103, 34, 110),
                   (102, 34, 109),
                   (101, 33, 107),
                   (101, 32, 106),
                   (100, 31, 104),
                   (99, 31, 102),
                   (99, 30, 101),
                   (98, 29, 99),
                   (97, 29, 97),
                   (96, 28, 96),
                   (96, 28, 94),
                   (95, 27, 92),
                   (94, 26, 91),
                   (93, 26, 89),
                   (92, 25, 87),
                   (92, 25, 86),
                   (91, 24, 84),
                   (90, 24, 82),
                   (89, 23, 81),
                   (88, 23, 79),
                   (87, 22, 77),
                   (86, 22, 76),
                   (85, 22, 74),
                   (84, 21, 73),
                   (83, 21, 71),
                   (82, 20, 69),
                   (81, 20, 68),
                   (80, 20, 66),
                   (79, 19, 65),
                   (78, 19, 63),
                   (77, 19, 62),
                   (76, 19, 60),
                   (75, 18, 59),
                   (74, 18, 57),
                   (73, 18, 56),
                   (72, 18, 55),
                   (71, 17, 53),
                   (69, 17, 52),
                   (68, 17, 50),
                   (67, 17, 49),
                   (66, 16, 48),
                   (65, 16, 47),
                   (64, 16, 45),
                   (62, 16, 44),
                   (61, 15, 43),
                   (60, 15, 42),
                   (59, 15, 40),
                   (57, 15, 39),
                   (56, 14, 38),
                   (55, 14, 37),
                   (54, 14, 36)],
    'misc_seq_3': [(0, 25, 89),
                   (1, 26, 89),
                   (2, 27, 89),
                   (2, 28, 89),
                   (3, 29, 89),
                   (3, 30, 90),
                   (4, 31, 90),
                   (4, 32, 90),
                   (5, 33, 90),
                   (5, 34, 90),
                   (6, 35, 91),
                   (6, 36, 91),
                   (7, 37, 91),
                   (7, 38, 91),
                   (8, 39, 91),
                   (8, 40, 91),
                   (9, 41, 92),
                   (9, 43, 92),
                   (10, 44, 92),
                   (10, 45, 92),
                   (10, 46, 92),
                   (11, 47, 92),
                   (11, 48, 93),
                   (12, 49, 93),
                   (12, 50, 93),
                   (12, 51, 93),
                   (13, 52, 93),
                   (13, 53, 94),
                   (13, 54, 94),
                   (14, 55, 94),
                   (14, 56, 94),
                   (15, 57, 94),
                   (15, 58, 94),
                   (15, 59, 95),
                   (16, 60, 95),
                   (16, 61, 95),
                   (16, 62, 95),
                   (17, 63, 95),
                   (17, 64, 95),
                   (18, 66, 95),
                   (18, 67, 96),
                   (19, 68, 96),
                   (19, 69, 96),
                   (19, 70, 96),
                   (20, 71, 96),
                   (20, 72, 96),
                   (21, 73, 96),
                   (21, 74, 96),
                   (22, 75, 96),
                   (23, 76, 96),
                   (23, 77, 97),
                   (24, 78, 97),
                   (24, 79, 97),
                   (25, 80, 97),
                   (26, 81, 97),
                   (27, 83, 97),
                   (27, 84, 96),
                   (28, 85, 96),
                   (29, 86, 96),
                   (30, 87, 96),
                   (31, 88, 96),
                   (32, 89, 96),
                   (33, 90, 96),
                   (34, 91, 95),
                   (35, 92, 95),
                   (36, 92, 95),
                   (37, 93, 95),
                   (38, 94, 94),
                   (39, 95, 94),
                   (40, 96, 94),
                   (41, 97, 93),
                   (43, 98, 93),
                   (44, 99, 92),
                   (45, 99, 92),
                   (46, 100, 91),
                   (48, 101, 91),
                   (49, 102, 90),
                   (50, 103, 90),
                   (52, 103, 89),
                   (53, 104, 89),
                   (55, 105, 88),
                   (56, 105, 87),
                   (57, 106, 87),
                   (59, 107, 86),
                   (60, 107, 85),
                   (62, 108, 84),
                   (63, 109, 84),
                   (65, 109, 83),
                   (66, 110, 82),
                   (67, 110, 81),
                   (69, 111, 81),
                   (70, 112, 80),
                   (72, 112, 79),
                   (73, 113, 78),
                   (75, 113, 77),
                   (76, 114, 77),
                   (78, 114, 76),
                   (79, 115, 75),
                   (81, 115, 74),
                   (82, 116, 73),
                   (84, 116, 72),
                   (85, 117, 72),
                   (87, 117, 71),
                   (88, 118, 70),
                   (90, 118, 69),
                   (91, 119, 68),
                   (93, 119, 67),
                   (94, 120, 67),
                   (96, 120, 66),
                   (97, 120, 65),
                   (99, 121, 64),
                   (100, 121, 63),
                   (102, 122, 62),
                   (104, 122, 62),
                   (105, 123, 61),
                   (107, 123, 60),
                   (108, 124, 59),
                   (110, 124, 58),
                   (111, 125, 58),
                   (113, 125, 57),
                   (115, 125, 56),
                   (116, 126, 55),
                   (118, 126, 54),
                   (120, 127, 54),
                   (121, 127, 53),
                   (123, 128, 52),
                   (125, 128, 52),
                   (126, 129, 51),
                   (128, 129, 50),
                   (130, 130, 50),
                   (132, 130, 49),
                   (133, 131, 48),
                   (135, 131, 48),
                   (137, 132, 47),
                   (139, 132, 47),
                   (141, 133, 47),
                   (143, 133, 46),
                   (145, 134, 46),
                   (147, 134, 46),
                   (148, 134, 45),
                   (150, 135, 45),
                   (152, 135, 45),
                   (155, 136, 45),
                   (157, 136, 45),
                   (159, 137, 45),
                   (161, 137, 45),
                   (163, 138, 46),
                   (165, 138, 46),
                   (167, 139, 46),
                   (169, 139, 47),
                   (171, 140, 47),
                   (173, 140, 48),
                   (176, 140, 49),
                   (178, 141, 50),
                   (180, 141, 50),
                   (182, 142, 51),
                   (184, 142, 52),
                   (186, 143, 53),
                   (188, 143, 54),
                   (191, 143, 56),
                   (193, 144, 57),
                   (195, 144, 58),
                   (197, 145, 59),
                   (199, 145, 61),
                   (201, 145, 62),
                   (203, 146, 64),
                   (205, 146, 65),
                   (207, 147, 67),
                   (209, 147, 68),
                   (211, 147, 70),
                   (212, 148, 71),
                   (214, 148, 73),
                   (216, 148, 75),
                   (218, 149, 77),
                   (220, 149, 78),
                   (221, 150, 80),
                   (223, 150, 82),
                   (225, 151, 84),
                   (226, 151, 86),
                   (228, 152, 88),
                   (230, 152, 90),
                   (231, 152, 92),
                   (232, 153, 94),
                   (234, 153, 96),
                   (235, 154, 98),
                   (237, 155, 100),
                   (238, 155, 102),
                   (239, 156, 104),
                   (240, 156, 106),
                   (241, 157, 109),
                   (242, 157, 111),
                   (243, 158, 113),
                   (244, 159, 115),
                   (245, 159, 117),
                   (246, 160, 119),
                   (246, 160, 121),
                   (247, 161, 124),
                   (248, 162, 126),
                   (248, 162, 128),
                   (249, 163, 130),
                   (249, 164, 132),
                   (250, 164, 134),
                   (250, 165, 137),
                   (251, 166, 139),
                   (251, 166, 141),
                   (251, 167, 143),
                   (252, 168, 145),
                   (252, 168, 147),
                   (252, 169, 149),
                   (252, 170, 151),
                   (252, 171, 153),
                   (253, 171, 155),
                   (253, 172, 158),
                   (253, 173, 160),
                   (253, 173, 162),
                   (253, 174, 164),
                   (253, 175, 166),
                   (253, 175, 168),
                   (253, 176, 170),
                   (253, 177, 172),
                   (253, 178, 174),
                   (253, 178, 176),
                   (253, 179, 178),
                   (253, 180, 180),
                   (253, 180, 183),
                   (253, 181, 185),
                   (253, 182, 187),
                   (253, 183, 189),
                   (253, 183, 191),
                   (253, 184, 193),
                   (253, 185, 195),
                   (252, 186, 197),
                   (252, 186, 199),
                   (252, 187, 202),
                   (252, 188, 204),
                   (252, 188, 206),
                   (252, 189, 208),
                   (252, 190, 210),
                   (252, 191, 212),
                   (252, 191, 214),
                   (252, 192, 217),
                   (252, 193, 219),
                   (252, 194, 221),
                   (251, 194, 223),
                   (251, 195, 225),
                   (251, 196, 227),
                   (251, 197, 230),
                   (251, 197, 232),
                   (251, 198, 234),
                   (251, 199, 236),
                   (251, 200, 238),
                   (250, 200, 241),
                   (250, 201, 243),
                   (250, 202, 245),
                   (250, 203, 247),
                   (250, 204, 250)],
    'temp_seq_5': [(254, 254, 203),
                   (241, 195, 95),
                   (222, 116, 79),
                   (126, 59, 52),
                   (25, 25, 0)],
    'temp_seq_6': [(254, 254, 203),
                   (245, 212, 112),
                   (231, 147, 82),
                   (194, 84, 73),
                   (104, 52, 42),
                   (25, 25, 0)],
    'temp_seq_7': [(254, 254, 203),
                   (248, 222, 127),
                   (235, 167, 84),
                   (222, 116, 79),
                   (164, 70, 66),
                   (89, 47, 35),
                   (25, 25, 0)],
    'temp_seq_8': [(254, 254, 203),
                   (249, 228, 138),
                   (239, 182, 89),
                   (229, 139, 81),
                   (204, 93, 75),
                   (142, 64, 58),
                   (79, 44, 30),
                   (25, 25, 0)],
    'temp_seq_9': [(254, 254, 203),
                   (250, 232, 146),
                   (241, 195, 95),
                   (233, 155, 82),
                   (222, 116, 79),
                   (183, 78, 71),
                   (126, 59, 52),
                   (72, 42, 26),
                   (25, 25, 0)],
    'temp_seq_10': [(254, 254, 203),
                    (251, 235, 153),
                    (244, 204, 104),
                    (235, 167, 84),
                    (228, 134, 80),
                    (209, 98, 76),
                    (164, 70, 66),
                    (114, 55, 46),
                    (66, 40, 24),
                    (25, 25, 0)],
    'temp_seq_11': [(254, 254, 203),
                    (251, 237, 158),
                    (245, 212, 112),
                    (238, 178, 87),
                    (231, 147, 82),
                    (222, 116, 79),
                    (194, 84, 73),
                    (149, 65, 61),
                    (104, 52, 42),
                    (62, 38, 22),
                    (25, 25, 0)],
    'temp_seq_12': [(254, 254, 203),
                    (252, 239, 162),
                    (247, 218, 120),
                    (240, 187, 91),
                    (233, 158, 83),
                    (227, 131, 80),
                    (212, 101, 77),
                    (178, 76, 69),
                    (136, 62, 56),
                    (96, 50, 38),
                    (58, 37, 20),
                    (25, 25, 0)],
    'temp_seq_13': [(254, 254, 203),
                    (252, 240, 165),
                    (248, 222, 127),
                    (241, 195, 95),
                    (235, 167, 84),
                    (230, 142, 81),
                    (222, 116, 79),
                    (200, 89, 74),
                    (164, 70, 66),
                    (126, 59, 52),
                    (89, 47, 35),
                    (55, 36, 19),
                    (25, 25, 0)],
    'temp_seq_14': [(254, 254, 203),
                    (252, 242, 168),
                    (249, 225, 132),
                    (243, 201, 101),
                    (237, 175, 86),
                    (232, 152, 82),
                    (226, 129, 80),
                    (214, 104, 77),
                    (187, 80, 72),
                    (152, 67, 62),
                    (117, 56, 48),
                    (84, 46, 32),
                    (53, 35, 18),
                    (25, 25, 0)],
    'temp_seq_15': [(254, 254, 203),
                    (252, 243, 171),
                    (249, 228, 138),
                    (244, 207, 106),
                    (239, 182, 89),
                    (234, 160, 83),
                    (229, 139, 81),
                    (222, 116, 79),
                    (204, 93, 75),
                    (175, 75, 69),
                    (142, 64, 58),
                    (110, 54, 45),
                    (79, 44, 30),
                    (51, 35, 17),
                    (25, 25, 0)],
    'temp_seq_16': [(254, 254, 203),
                    (253, 243, 173),
                    (250, 230, 142),
                    (245, 212, 112),
                    (240, 189, 92),
                    (235, 167, 84),
                    (231, 147, 82),
                    (226, 127, 80),
                    (215, 105, 77),
                    (194, 84, 73),
                    (164, 70, 66),
                    (134, 61, 55),
                    (104, 52, 42),
                    (75, 43, 28),
                    (49, 34, 16),
                    (25, 25, 0)],
    'temp_seq_17': [(254, 254, 203),
                    (253, 244, 175),
                    (250, 232, 146),
                    (246, 216, 117),
                    (241, 195, 95),
                    (237, 174, 86),
                    (233, 155, 82),
                    (228, 136, 81),
                    (222, 116, 79),
                    (207, 96, 76),
                    (183, 78, 71),
                    (155, 67, 63),
                    (126, 59, 52),
                    (98, 50, 39),
                    (72, 42, 26),
                    (47, 34, 15),
                    (25, 25, 0)],
    'temp_seq_18': [(254, 254, 203),
                    (253, 245, 177),
                    (250, 234, 150),
                    (247, 219, 122),
                    (243, 200, 99),
                    (238, 180, 87),
                    (234, 161, 83),
                    (230, 144, 81),
                    (225, 126, 80),
                    (216, 107, 78),
                    (198, 88, 74),
                    (173, 74, 68),
                    (146, 65, 60),
                    (119, 57, 49),
                    (94, 49, 37),
                    (69, 41, 25),
                    (46, 33, 15),
                    (25, 25, 0)],
    'temp_seq_19': [(254, 254, 203),
                    (253, 245, 178),
                    (251, 235, 153),
                    (248, 222, 127),
                    (244, 204, 104),
                    (239, 185, 90),
                    (235, 167, 84),
                    (232, 151, 82),
                    (228, 134, 80),
                    (222, 116, 79),
                    (209, 98, 76),
                    (189, 82, 72),
                    (164, 70, 66),
                    (139, 63, 57),
                    (114, 55, 46),
                    (89, 47, 35),
                    (66, 40, 24),
                    (45, 33, 14),
                    (25, 25, 0)],
    'temp_seq_20': [(254, 254, 203),
                    (253, 246, 180),
                    (251, 236, 155),
                    (248, 224, 131),
                    (245, 208, 108),
                    (240, 190, 92),
                    (236, 173, 85),
                    (233, 157, 82),
                    (230, 141, 81),
                    (225, 125, 80),
                    (217, 108, 78),
                    (202, 90, 75),
                    (180, 77, 70),
                    (156, 68, 63),
                    (132, 61, 54),
                    (108, 53, 44),
                    (86, 46, 33),
                    (64, 39, 23),
                    (43, 32, 13),
                    (25, 25, 0)],
    'temp_seq_21': [(254, 254, 203),
                    (253, 246, 181),
                    (251, 237, 158),
                    (249, 226, 134),
                    (245, 212, 112),
                    (241, 195, 95),
                    (238, 178, 87),
                    (234, 162, 83),
                    (231, 147, 82),
                    (227, 132, 80),
                    (222, 116, 79),
                    (211, 100, 77),
                    (194, 84, 73),
                    (172, 73, 68),
                    (149, 65, 61),
                    (126, 59, 52),
                    (104, 52, 42),
                    (82, 45, 31),
                    (62, 38, 22),
                    (43, 32, 13),
                    (25, 25, 0)],
    'prec_seq_5': [(255, 255, 229),
                   (170, 211, 193),
                   (86, 168, 157),
                   (33, 116, 107),
                   (0, 60, 48)],
    'prec_seq_6': [(255, 255, 229),
                   (187, 220, 200),
                   (120, 185, 171),
                   (52, 150, 142),
                   (26, 105, 95),
                   (0, 60, 48)],
    'prec_seq_7': [(255, 255, 229),
                   (198, 226, 205),
                   (142, 197, 181),
                   (86, 168, 157),
                   (44, 135, 127),
                   (22, 97, 87),
                   (0, 60, 48)],
    'prec_seq_8': [(255, 255, 229),
                   (206, 230, 208),
                   (158, 205, 188),
                   (110, 180, 167),
                   (62, 155, 147),
                   (37, 125, 115),
                   (18, 92, 81),
                   (0, 60, 48)],
    'prec_seq_9': [(255, 255, 229),
                   (212, 233, 211),
                   (170, 211, 193),
                   (128, 190, 175),
                   (86, 168, 157),
                   (49, 145, 137),
                   (33, 116, 107),
                   (16, 88, 77),
                   (0, 60, 48)],
    'prec_seq_10': [(255, 255, 229),
                    (217, 235, 213),
                    (180, 216, 197),
                    (142, 197, 181),
                    (105, 177, 165),
                    (67, 158, 149),
                    (44, 135, 127),
                    (29, 110, 100),
                    (14, 85, 74),
                    (0, 60, 48)],
    'prec_seq_11': [(255, 255, 229),
                    (221, 237, 214),
                    (187, 220, 200),
                    (154, 203, 186),
                    (120, 185, 171),
                    (86, 168, 157),
                    (52, 150, 142),
                    (39, 128, 119),
                    (26, 105, 95),
                    (13, 82, 71),
                    (0, 60, 48)],
    'prec_seq_12': [(255, 255, 229),
                    (224, 239, 215),
                    (193, 223, 202),
                    (163, 207, 189),
                    (132, 191, 176),
                    (101, 176, 163),
                    (71, 160, 150),
                    (48, 142, 134),
                    (36, 122, 112),
                    (24, 101, 91),
                    (12, 80, 69),
                    (0, 60, 48)],
    'prec_seq_13': [(255, 255, 229),
                    (226, 240, 217),
                    (198, 226, 205),
                    (170, 211, 193),
                    (142, 197, 181),
                    (114, 182, 169),
                    (86, 168, 157),
                    (58, 153, 145),
                    (44, 135, 127),
                    (33, 116, 107),
                    (22, 97, 87),
                    (11, 78, 67),
                    (0, 60, 48)],
    'prec_seq_14': [(255, 255, 229),
                    (229, 241, 217),
                    (203, 228, 206),
                    (177, 215, 195),
                    (151, 201, 184),
                    (125, 188, 173),
                    (99, 175, 162),
                    (73, 161, 151),
                    (50, 147, 139),
                    (40, 130, 121),
                    (30, 112, 102),
                    (20, 94, 84),
                    (10, 77, 66),
                    (0, 60, 48)],
    'prec_seq_15': [(255, 255, 229),
                    (230, 242, 218),
                    (206, 230, 208),
                    (182, 217, 198),
                    (158, 205, 188),
                    (134, 193, 177),
                    (110, 180, 167),
                    (86, 168, 157),
                    (62, 155, 147),
                    (47, 141, 132),
                    (37, 125, 115),
                    (28, 108, 98),
                    (18, 92, 81),
                    (9, 76, 64),
                    (0, 60, 48)],
    'prec_seq_16': [(255, 255, 229),
                    (232, 243, 219),
                    (210, 231, 209),
                    (187, 220, 200),
                    (165, 208, 190),
                    (142, 197, 181),
                    (120, 185, 171),
                    (97, 174, 162),
                    (75, 162, 152),
                    (53, 151, 143),
                    (44, 135, 127),
                    (35, 120, 111),
                    (26, 105, 95),
                    (17, 90, 79),
                    (8, 75, 63),
                    (0, 60, 48)],
    'prec_seq_17': [(255, 255, 229),
                    (233, 244, 220),
                    (212, 233, 211),
                    (191, 222, 202),
                    (170, 211, 193),
                    (149, 200, 184),
                    (128, 190, 175),
                    (107, 179, 166),
                    (86, 168, 157),
                    (65, 157, 148),
                    (49, 145, 137),
                    (41, 131, 122),
                    (33, 116, 107),
                    (24, 102, 92),
                    (16, 88, 77),
                    (8, 74, 62),
                    (0, 60, 48)],
    'prec_seq_18': [(255, 255, 229),
                    (235, 244, 220),
                    (215, 234, 212),
                    (195, 224, 203),
                    (175, 214, 195),
                    (155, 204, 186),
                    (136, 193, 178),
                    (116, 183, 169),
                    (96, 173, 161),
                    (76, 163, 153),
                    (56, 153, 144),
                    (46, 140, 131),
                    (38, 126, 117),
                    (31, 113, 103),
                    (23, 100, 89),
                    (15, 86, 75),
                    (7, 73, 61),
                    (0, 60, 48)],
    'prec_seq_19': [(255, 255, 229),
                    (236, 245, 221),
                    (217, 235, 213),
                    (198, 226, 205),
                    (180, 216, 197),
                    (161, 206, 189),
                    (142, 197, 181),
                    (124, 187, 173),
                    (105, 177, 165),
                    (86, 168, 157),
                    (67, 158, 149),
                    (51, 148, 140),
                    (44, 135, 127),
                    (36, 123, 113),
                    (29, 110, 100),
                    (22, 97, 87),
                    (14, 85, 74),
                    (7, 72, 61),
                    (0, 60, 48)],
    'prec_seq_20': [(255, 255, 229),
                    (237, 245, 221),
                    (219, 236, 213),
                    (201, 227, 206),
                    (184, 218, 198),
                    (166, 209, 191),
                    (148, 200, 183),
                    (130, 191, 176),
                    (113, 182, 168),
                    (95, 172, 161),
                    (77, 163, 153),
                    (60, 154, 146),
                    (48, 143, 135),
                    (41, 131, 123),
                    (34, 119, 110),
                    (27, 107, 98),
                    (20, 95, 85),
                    (13, 83, 73),
                    (6, 71, 60),
                    (0, 60, 48)],
    'prec_seq_21': [(255, 255, 229),
                    (238, 246, 221),
                    (221, 237, 214),
                    (204, 228, 207),
                    (187, 220, 200),
                    (170, 211, 193),
                    (154, 203, 186),
                    (137, 194, 178),
                    (120, 185, 171),
                    (103, 177, 164),
                    (86, 168, 157),
                    (69, 159, 150),
                    (52, 150, 142),
                    (46, 139, 131),
                    (39, 128, 119),
                    (33, 116, 107),
                    (26, 105, 95),
                    (19, 94, 83),
                    (13, 82, 71),
                    (6, 71, 59),
                    (0, 60, 48)],
    'wind_seq_5': [(254, 252, 205),
                   (201, 186, 69),
                   (96, 146, 11),
                   (11, 95, 44),
                   (23, 35, 18)],
    'wind_seq_6': [(254, 252, 205),
                   (216, 196, 95),
                   (141, 161, 11),
                   (50, 128, 30),
                   (15, 83, 44),
                   (23, 35, 18)],
    'wind_seq_7': [(254, 252, 205),
                   (224, 204, 113),
                   (170, 171, 32),
                   (96, 146, 11),
                   (24, 114, 39),
                   (19, 75, 42),
                   (23, 35, 18)],
    'wind_seq_8': [(254, 252, 205),
                   (229, 211, 126),
                   (189, 179, 52),
                   (128, 157, 6),
                   (63, 133, 25),
                   (12, 103, 43),
                   (22, 69, 40),
                   (23, 35, 18)],
    'wind_seq_9': [(254, 252, 205),
                   (233, 215, 136),
                   (201, 186, 69),
                   (152, 165, 18),
                   (96, 146, 11),
                   (39, 123, 34),
                   (11, 95, 44),
                   (23, 65, 38),
                   (23, 35, 18)],
    'wind_seq_10': [(254, 252, 205),
                    (235, 219, 144),
                    (210, 192, 83),
                    (170, 171, 32),
                    (121, 154, 5),
                    (70, 136, 22),
                    (24, 114, 39),
                    (13, 88, 44),
                    (24, 61, 36),
                    (23, 35, 18)],
    'wind_seq_11': [(254, 252, 205),
                    (237, 222, 150),
                    (216, 196, 95),
                    (183, 177, 45),
                    (141, 161, 11),
                    (96, 146, 11),
                    (50, 128, 30),
                    (15, 107, 42),
                    (15, 83, 44),
                    (24, 59, 35),
                    (23, 35, 18)],
    'wind_seq_12': [(254, 252, 205),
                    (239, 225, 155),
                    (220, 201, 105),
                    (193, 182, 58),
                    (157, 167, 21),
                    (117, 153, 5),
                    (75, 138, 20),
                    (35, 120, 36),
                    (11, 100, 44),
                    (18, 79, 43),
                    (25, 56, 34),
                    (23, 35, 18)],
    'wind_seq_13': [(254, 252, 205),
                    (240, 227, 159),
                    (224, 204, 113),
                    (201, 186, 69),
                    (170, 171, 32),
                    (134, 159, 7),
                    (96, 146, 11),
                    (57, 131, 28),
                    (24, 114, 39),
                    (11, 95, 44),
                    (19, 75, 42),
                    (25, 55, 33),
                    (23, 35, 18)],
    'wind_seq_14': [(254, 252, 205),
                    (241, 229, 163),
                    (227, 208, 120),
                    (207, 190, 78),
                    (180, 176, 42),
                    (148, 163, 15),
                    (113, 152, 6),
                    (78, 139, 19),
                    (43, 125, 33),
                    (16, 108, 42),
                    (12, 90, 44),
                    (21, 72, 41),
                    (25, 53, 32),
                    (23, 35, 18)],
    'wind_seq_15': [(254, 252, 205),
                    (242, 231, 166),
                    (229, 211, 126),
                    (212, 193, 87),
                    (189, 179, 52),
                    (160, 168, 23),
                    (128, 157, 6),
                    (96, 146, 11),
                    (63, 133, 25),
                    (32, 119, 37),
                    (12, 103, 43),
                    (14, 86, 44),
                    (22, 69, 40),
                    (25, 52, 31),
                    (23, 35, 18)],
    'wind_seq_16': [(254, 252, 205),
                    (243, 232, 168),
                    (231, 213, 132),
                    (216, 196, 95),
                    (195, 183, 60),
                    (170, 171, 32),
                    (141, 161, 11),
                    (111, 151, 6),
                    (80, 140, 18),
                    (50, 128, 30),
                    (24, 114, 39),
                    (10, 99, 44),
                    (15, 83, 44),
                    (22, 67, 39),
                    (25, 51, 30),
                    (23, 35, 18)],
    'wind_seq_17': [(254, 252, 205),
                    (244, 233, 171),
                    (233, 215, 136),
                    (219, 199, 102),
                    (201, 186, 69),
                    (178, 175, 40),
                    (152, 165, 18),
                    (124, 155, 5),
                    (96, 146, 11),
                    (67, 135, 24),
                    (39, 123, 34),
                    (18, 109, 41),
                    (11, 95, 44),
                    (17, 80, 43),
                    (23, 65, 38),
                    (25, 50, 30),
                    (23, 35, 18)],
    'wind_seq_18': [(254, 252, 205),
                    (244, 234, 173),
                    (234, 217, 140),
                    (222, 202, 108),
                    (206, 189, 76),
                    (185, 178, 48),
                    (162, 168, 25),
                    (136, 159, 8),
                    (109, 150, 7),
                    (82, 141, 17),
                    (55, 130, 28),
                    (31, 118, 37),
                    (13, 105, 43),
                    (12, 92, 44),
                    (18, 77, 42),
                    (23, 63, 37),
                    (25, 49, 29),
                    (23, 35, 18)],
    'wind_seq_19': [(254, 252, 205),
                    (245, 235, 174),
                    (235, 219, 144),
                    (224, 204, 113),
                    (210, 192, 83),
                    (191, 181, 55),
                    (170, 171, 32),
                    (146, 163, 13),
                    (121, 154, 5),
                    (96, 146, 11),
                    (70, 136, 22),
                    (45, 126, 32),
                    (24, 114, 39),
                    (11, 102, 43),
                    (13, 88, 44),
                    (19, 75, 42),
                    (24, 61, 36),
                    (25, 48, 28),
                    (23, 35, 18)],
    'wind_seq_20': [(254, 252, 205),
                    (245, 236, 176),
                    (236, 221, 147),
                    (226, 207, 118),
                    (213, 194, 89),
                    (197, 183, 62),
                    (177, 174, 39),
                    (155, 166, 20),
                    (132, 158, 7),
                    (108, 150, 7),
                    (83, 141, 17),
                    (59, 132, 27),
                    (37, 121, 35),
                    (18, 110, 41),
                    (10, 98, 44),
                    (14, 86, 44),
                    (20, 73, 41),
                    (24, 60, 36),
                    (25, 47, 28),
                    (23, 35, 18)],
    'wind_seq_21': [(254, 252, 205),
                    (246, 237, 177),
                    (237, 222, 150),
                    (228, 209, 122),
                    (216, 196, 95),
                    (201, 186, 69),
                    (183, 177, 45),
                    (163, 169, 26),
                    (141, 161, 11),
                    (119, 153, 5),
                    (96, 146, 11),
                    (72, 137, 21),
                    (50, 128, 30),
                    (30, 118, 38),
                    (15, 107, 42),
                    (11, 95, 44),
                    (15, 83, 44),
                    (21, 71, 41),
                    (24, 59, 35),
                    (25, 47, 28),
                    (23, 35, 18)],
    'cryo_seq_5': [(0, 1, 0),
                   (21, 56, 90),
                   (78, 122, 187),
                   (161, 176, 201),
                   (254, 255, 254)],
    'cryo_seq_6': [(0, 1, 0),
                   (17, 45, 72),
                   (43, 92, 149),
                   (116, 147, 201),
                   (178, 187, 203),
                   (254, 255, 254)],
    'cryo_seq_7': [(0, 1, 0),
                   (15, 37, 60),
                   (30, 76, 123),
                   (78, 122, 187),
                   (136, 160, 201),
                   (190, 196, 207),
                   (254, 255, 254)],
    'cryo_seq_8': [(0, 1, 0),
                   (14, 33, 52),
                   (24, 64, 104),
                   (51, 100, 161),
                   (106, 141, 199),
                   (150, 169, 201),
                   (198, 203, 211),
                   (254, 255, 254)],
    'cryo_seq_9': [(0, 1, 0),
                   (13, 29, 46),
                   (21, 56, 90),
                   (38, 86, 139),
                   (78, 122, 187),
                   (123, 152, 201),
                   (161, 176, 201),
                   (205, 209, 214),
                   (254, 255, 254)],
    'cryo_seq_10': [(0, 1, 0),
                    (13, 26, 41),
                    (19, 50, 80),
                    (30, 76, 123),
                    (56, 104, 168),
                    (100, 137, 198),
                    (136, 160, 201),
                    (170, 182, 202),
                    (211, 213, 218),
                    (254, 255, 254)],
    'cryo_seq_11': [(0, 1, 0),
                    (13, 24, 37),
                    (17, 45, 72),
                    (26, 68, 109),
                    (43, 92, 149),
                    (78, 122, 187),
                    (116, 147, 201),
                    (146, 166, 201),
                    (178, 187, 203),
                    (215, 217, 221),
                    (254, 255, 254)],
    'cryo_seq_12': [(0, 1, 0),
                    (12, 23, 35),
                    (16, 41, 65),
                    (23, 61, 99),
                    (35, 83, 135),
                    (60, 107, 172),
                    (97, 135, 197),
                    (127, 154, 201),
                    (154, 171, 201),
                    (184, 192, 205),
                    (219, 220, 223),
                    (254, 255, 254)],
    'cryo_seq_13': [(0, 1, 0),
                    (12, 21, 32),
                    (15, 37, 60),
                    (21, 56, 90),
                    (30, 76, 123),
                    (48, 97, 156),
                    (78, 122, 187),
                    (110, 144, 200),
                    (136, 160, 201),
                    (161, 176, 201),
                    (190, 196, 207),
                    (222, 223, 226),
                    (254, 255, 254)],
    'cryo_seq_14': [(0, 1, 0),
                    (11, 20, 30),
                    (15, 35, 55),
                    (19, 52, 83),
                    (27, 70, 113),
                    (40, 88, 143),
                    (63, 110, 174),
                    (94, 133, 196),
                    (120, 150, 201),
                    (144, 165, 201),
                    (168, 180, 202),
                    (194, 199, 209),
                    (224, 225, 228),
                    (254, 255, 254)],
    'cryo_seq_15': [(0, 1, 0),
                    (11, 19, 29),
                    (14, 33, 52),
                    (18, 48, 77),
                    (24, 64, 104),
                    (34, 82, 132),
                    (51, 100, 161),
                    (78, 122, 187),
                    (106, 141, 199),
                    (129, 156, 201),
                    (150, 169, 201),
                    (173, 184, 202),
                    (198, 203, 211),
                    (226, 227, 229),
                    (254, 255, 254)],
    'cryo_seq_16': [(0, 1, 0),
                    (10, 18, 27),
                    (14, 31, 48),
                    (17, 45, 72),
                    (22, 60, 97),
                    (30, 76, 123),
                    (43, 92, 149),
                    (65, 111, 176),
                    (92, 131, 195),
                    (116, 147, 201),
                    (136, 160, 201),
                    (156, 173, 201),
                    (178, 187, 203),
                    (202, 206, 213),
                    (228, 229, 231),
                    (254, 255, 254)],
    'cryo_seq_17': [(0, 1, 0),
                    (9, 17, 26),
                    (13, 29, 46),
                    (16, 42, 67),
                    (21, 56, 90),
                    (28, 71, 114),
                    (38, 86, 139),
                    (54, 102, 165),
                    (78, 122, 187),
                    (103, 139, 199),
                    (123, 152, 201),
                    (142, 164, 201),
                    (161, 176, 201),
                    (182, 190, 204),
                    (205, 209, 214),
                    (230, 231, 232),
                    (254, 255, 254)],
    'cryo_seq_18': [(0, 1, 0),
                    (9, 16, 25),
                    (13, 28, 43),
                    (16, 40, 63),
                    (20, 53, 85),
                    (25, 66, 107),
                    (34, 80, 130),
                    (46, 95, 154),
                    (66, 112, 178),
                    (90, 130, 194),
                    (112, 145, 200),
                    (130, 156, 201),
                    (148, 167, 201),
                    (166, 179, 201),
                    (186, 193, 205),
                    (208, 211, 216),
                    (231, 232, 233),
                    (254, 255, 254)],
    'cryo_seq_19': [(0, 1, 0),
                    (8, 16, 24),
                    (13, 26, 41),
                    (15, 37, 60),
                    (19, 50, 80),
                    (24, 63, 101),
                    (30, 76, 123),
                    (41, 89, 145),
                    (56, 104, 168),
                    (78, 122, 187),
                    (100, 137, 198),
                    (119, 149, 201),
                    (136, 160, 201),
                    (153, 170, 201),
                    (170, 182, 202),
                    (190, 196, 207),
                    (211, 213, 218),
                    (233, 233, 235),
                    (254, 255, 254)],
    'cryo_seq_20': [(0, 1, 0),
                    (8, 15, 23),
                    (13, 25, 39),
                    (15, 36, 57),
                    (18, 47, 76),
                    (22, 59, 95),
                    (28, 72, 116),
                    (36, 84, 137),
                    (49, 98, 158),
                    (67, 113, 179),
                    (89, 129, 194),
                    (109, 143, 200),
                    (125, 153, 201),
                    (141, 163, 201),
                    (157, 173, 201),
                    (174, 185, 202),
                    (193, 198, 208),
                    (213, 215, 219),
                    (234, 234, 236),
                    (254, 255, 254)],
    'cryo_seq_21': [(0, 1, 0),
                    (8, 15, 22),
                    (13, 24, 37),
                    (14, 34, 54),
                    (17, 45, 72),
                    (21, 56, 90),
                    (26, 68, 109),
                    (33, 80, 129),
                    (43, 92, 149),
                    (58, 106, 170),
                    (78, 122, 187),
                    (98, 136, 197),
                    (116, 147, 201),
                    (131, 157, 201),
                    (146, 166, 201),
                    (161, 176, 201),
                    (178, 187, 203),
                    (196, 201, 209),
                    (215, 217, 221),
                    (235, 235, 236),
                    (254, 255, 254)],
    'chem_seq_5': [(254, 254, 216),
                   (160, 197, 152),
                   (143, 134, 133),
                   (117, 70, 108),
                   (26, 14, 51)],
    'chem_seq_6': [(254, 254, 216),
                   (174, 213, 162),
                   (147, 157, 140),
                   (138, 111, 126),
                   (102, 54, 97),
                   (26, 14, 51)],
    'chem_seq_7': [(254, 254, 216),
                   (187, 225, 170),
                   (151, 174, 144),
                   (143, 134, 133),
                   (132, 94, 120),
                   (90, 45, 89),
                   (26, 14, 51)],
    'chem_seq_8': [(254, 254, 216),
                   (198, 233, 177),
                   (155, 186, 148),
                   (146, 151, 138),
                   (140, 117, 128),
                   (125, 80, 114),
                   (81, 39, 84),
                   (26, 14, 51)],
    'chem_seq_9': [(254, 254, 216),
                   (206, 238, 183),
                   (160, 197, 152),
                   (148, 163, 141),
                   (143, 134, 133),
                   (136, 104, 124),
                   (117, 70, 108),
                   (74, 34, 79),
                   (26, 14, 51)],
    'chem_seq_10': [(254, 254, 216),
                    (212, 241, 187),
                    (167, 206, 157),
                    (151, 174, 144),
                    (145, 147, 137),
                    (141, 121, 129),
                    (132, 94, 120),
                    (109, 61, 102),
                    (69, 31, 76),
                    (26, 14, 51)],
    'chem_seq_11': [(254, 254, 216),
                    (217, 243, 190),
                    (174, 213, 162),
                    (153, 182, 147),
                    (147, 157, 140),
                    (143, 134, 133),
                    (138, 111, 126),
                    (127, 84, 116),
                    (102, 54, 97),
                    (65, 29, 73),
                    (26, 14, 51)],
    'chem_seq_12': [(254, 254, 216),
                    (221, 245, 193),
                    (180, 220, 166),
                    (157, 190, 150),
                    (149, 166, 142),
                    (145, 145, 136),
                    (141, 124, 130),
                    (135, 102, 123),
                    (122, 76, 112),
                    (96, 49, 93),
                    (61, 27, 71),
                    (26, 14, 51)],
    'chem_seq_13': [(254, 254, 216),
                    (224, 246, 195),
                    (187, 225, 170),
                    (160, 197, 152),
                    (151, 174, 144),
                    (146, 154, 139),
                    (143, 134, 133),
                    (139, 115, 127),
                    (132, 94, 120),
                    (117, 70, 108),
                    (90, 45, 89),
                    (58, 26, 69),
                    (26, 14, 51)],
    'chem_seq_14': [(254, 254, 216),
                    (227, 247, 197),
                    (192, 229, 174),
                    (165, 203, 155),
                    (153, 180, 146),
                    (148, 161, 141),
                    (145, 143, 136),
                    (141, 125, 131),
                    (137, 107, 125),
                    (129, 87, 117),
                    (112, 64, 104),
                    (86, 41, 86),
                    (56, 25, 68),
                    (26, 14, 51)],
    'chem_seq_15': [(254, 254, 216),
                    (229, 248, 198),
                    (198, 233, 177),
                    (169, 208, 159),
                    (155, 186, 148),
                    (149, 168, 143),
                    (146, 151, 138),
                    (143, 134, 133),
                    (140, 117, 128),
                    (135, 100, 122),
                    (125, 80, 114),
                    (107, 59, 100),
                    (81, 39, 84),
                    (53, 24, 67),
                    (26, 14, 51)],
    'chem_seq_16': [(254, 254, 216),
                    (231, 249, 200),
                    (202, 235, 180),
                    (174, 213, 162),
                    (157, 192, 150),
                    (151, 174, 144),
                    (147, 157, 140),
                    (144, 142, 135),
                    (142, 126, 131),
                    (138, 111, 126),
                    (132, 94, 120),
                    (121, 75, 111),
                    (102, 54, 97),
                    (78, 36, 81),
                    (52, 23, 66),
                    (26, 14, 51)],
    'chem_seq_17': [(254, 254, 216),
                    (232, 249, 201),
                    (206, 238, 183),
                    (178, 218, 165),
                    (160, 197, 152),
                    (152, 179, 146),
                    (148, 163, 141),
                    (145, 149, 137),
                    (143, 134, 133),
                    (140, 120, 129),
                    (136, 104, 124),
                    (129, 88, 117),
                    (117, 70, 108),
                    (98, 51, 94),
                    (74, 34, 79),
                    (50, 23, 65),
                    (26, 14, 51)],
    'chem_seq_18': [(254, 254, 216),
                    (234, 250, 202),
                    (209, 239, 185),
                    (183, 221, 168),
                    (163, 201, 155),
                    (154, 184, 147),
                    (149, 169, 143),
                    (147, 155, 139),
                    (144, 141, 135),
                    (142, 127, 131),
                    (139, 113, 127),
                    (134, 99, 122),
                    (126, 83, 115),
                    (113, 65, 105),
                    (94, 48, 92),
                    (72, 33, 78),
                    (49, 22, 64),
                    (26, 14, 51)],
    'chem_seq_19': [(254, 254, 216),
                    (235, 250, 203),
                    (212, 241, 187),
                    (187, 225, 170),
                    (167, 206, 157),
                    (156, 188, 149),
                    (151, 174, 144),
                    (148, 160, 140),
                    (145, 147, 137),
                    (143, 134, 133),
                    (141, 121, 129),
                    (137, 108, 125),
                    (132, 94, 120),
                    (123, 78, 112),
                    (109, 61, 102),
                    (90, 45, 89),
                    (69, 31, 76),
                    (47, 21, 63),
                    (26, 14, 51)],
    'chem_seq_20': [(254, 254, 216),
                    (236, 250, 203),
                    (215, 242, 189),
                    (191, 228, 173),
                    (170, 210, 159),
                    (158, 193, 151),
                    (152, 178, 146),
                    (149, 165, 142),
                    (146, 153, 138),
                    (144, 140, 135),
                    (142, 128, 132),
                    (139, 116, 128),
                    (136, 103, 123),
                    (130, 89, 118),
                    (120, 74, 110),
                    (106, 58, 100),
                    (87, 42, 87),
                    (67, 30, 75),
                    (46, 21, 62),
                    (26, 14, 51)],
    'chem_seq_21': [(254, 254, 216),
                    (237, 250, 204),
                    (217, 243, 190),
                    (194, 230, 175),
                    (174, 213, 162),
                    (160, 197, 152),
                    (153, 182, 147),
                    (150, 170, 143),
                    (147, 157, 140),
                    (145, 146, 137),
                    (143, 134, 133),
                    (141, 122, 130),
                    (138, 111, 126),
                    (134, 98, 122),
                    (127, 84, 116),
                    (117, 70, 108),
                    (102, 54, 97),
                    (84, 40, 85),
                    (65, 29, 73),
                    (45, 21, 62),
                    (26, 14, 51)],
    'slev_seq_5': [(254, 254, 254),
                   (187, 199, 148),
                   (107, 141, 146),
                   (46, 89, 149),
                   (0, 5, 74)],
    'slev_seq_6': [(254, 254, 254),
                   (212, 218, 167),
                   (132, 158, 137),
                   (83, 125, 155),
                   (35, 74, 139),
                   (0, 5, 74)],
    'slev_seq_7': [(254, 254, 254),
                   (226, 229, 183),
                   (152, 172, 135),
                   (107, 141, 146),
                   (67, 111, 157),
                   (28, 63, 131),
                   (0, 5, 74)],
    'slev_seq_8': [(254, 254, 254),
                   (234, 236, 194),
                   (171, 186, 139),
                   (124, 152, 139),
                   (90, 130, 153),
                   (55, 99, 154),
                   (23, 55, 124),
                   (0, 5, 74)],
    'slev_seq_9': [(254, 254, 254),
                   (239, 240, 203),
                   (187, 199, 148),
                   (139, 162, 135),
                   (107, 141, 146),
                   (77, 120, 156),
                   (46, 89, 149),
                   (20, 49, 118),
                   (0, 5, 74)],
    'slev_seq_10': [(254, 254, 254),
                    (242, 242, 209),
                    (201, 210, 158),
                    (152, 172, 135),
                    (120, 150, 141),
                    (94, 132, 152),
                    (67, 111, 157),
                    (40, 81, 144),
                    (17, 44, 113),
                    (0, 5, 74)],
    'slev_seq_11': [(254, 254, 254),
                    (244, 244, 214),
                    (212, 218, 167),
                    (165, 182, 137),
                    (132, 158, 137),
                    (107, 141, 146),
                    (83, 125, 155),
                    (58, 103, 155),
                    (35, 74, 139),
                    (15, 41, 110),
                    (0, 5, 74)],
    'slev_seq_12': [(254, 254, 254),
                    (245, 246, 218),
                    (220, 225, 176),
                    (177, 191, 142),
                    (142, 165, 135),
                    (118, 148, 142),
                    (96, 134, 151),
                    (74, 118, 157),
                    (52, 96, 152),
                    (31, 68, 135),
                    (13, 37, 106),
                    (0, 5, 74)],
    'slev_seq_13': [(254, 254, 254),
                    (247, 247, 221),
                    (226, 229, 183),
                    (187, 199, 148),
                    (152, 172, 135),
                    (128, 154, 138),
                    (107, 141, 146),
                    (87, 128, 154),
                    (67, 111, 157),
                    (46, 89, 149),
                    (28, 63, 131),
                    (12, 35, 104),
                    (0, 5, 74)],
    'slev_seq_14': [(254, 254, 254),
                    (248, 247, 224),
                    (230, 233, 189),
                    (197, 207, 154),
                    (162, 179, 137),
                    (136, 160, 136),
                    (116, 147, 142),
                    (98, 135, 150),
                    (79, 122, 156),
                    (60, 105, 156),
                    (42, 84, 146),
                    (25, 59, 127),
                    (11, 33, 102),
                    (0, 5, 74)],
    'slev_seq_15': [(254, 254, 254),
                    (248, 248, 226),
                    (234, 236, 194),
                    (205, 213, 161),
                    (171, 186, 139),
                    (144, 166, 135),
                    (124, 152, 139),
                    (107, 141, 146),
                    (90, 130, 153),
                    (73, 116, 157),
                    (55, 99, 154),
                    (38, 79, 143),
                    (23, 55, 124),
                    (9, 31, 100),
                    (0, 5, 74)],
    'slev_seq_16': [(254, 254, 254),
                    (249, 249, 228),
                    (236, 238, 199),
                    (212, 218, 167),
                    (179, 193, 143),
                    (152, 172, 135),
                    (132, 158, 137),
                    (115, 146, 143),
                    (99, 136, 150),
                    (83, 125, 155),
                    (67, 111, 157),
                    (50, 94, 152),
                    (35, 74, 139),
                    (21, 52, 121),
                    (8, 29, 98),
                    (0, 5, 74)],
    'slev_seq_17': [(254, 254, 254),
                    (249, 249, 230),
                    (239, 240, 203),
                    (217, 223, 173),
                    (187, 199, 148),
                    (160, 178, 136),
                    (139, 162, 135),
                    (122, 151, 140),
                    (107, 141, 146),
                    (92, 131, 152),
                    (77, 120, 156),
                    (62, 106, 156),
                    (46, 89, 149),
                    (32, 70, 136),
                    (20, 49, 118),
                    (8, 28, 96),
                    (0, 5, 74)],
    'slev_seq_18': [(254, 254, 254),
                    (250, 249, 231),
                    (240, 241, 206),
                    (222, 226, 178),
                    (195, 205, 153),
                    (167, 184, 138),
                    (146, 167, 135),
                    (129, 155, 138),
                    (114, 146, 143),
                    (100, 136, 149),
                    (86, 127, 154),
                    (72, 115, 157),
                    (57, 102, 155),
                    (43, 85, 147),
                    (30, 66, 133),
                    (18, 46, 116),
                    (7, 27, 95),
                    (0, 5, 74)],
    'slev_seq_19': [(254, 254, 254),
                    (250, 250, 233),
                    (242, 242, 209),
                    (226, 229, 183),
                    (201, 210, 158),
                    (174, 189, 141),
                    (152, 172, 135),
                    (135, 160, 136),
                    (120, 150, 141),
                    (107, 141, 146),
                    (94, 132, 152),
                    (80, 123, 156),
                    (67, 111, 157),
                    (53, 97, 153),
                    (40, 81, 144),
                    (28, 63, 131),
                    (17, 44, 113),
                    (6, 25, 94),
                    (0, 5, 74)],
    'slev_seq_20': [(254, 254, 254),
                    (250, 250, 234),
                    (243, 243, 212),
                    (229, 232, 187),
                    (207, 214, 162),
                    (181, 194, 144),
                    (159, 177, 136),
                    (141, 164, 135),
                    (126, 154, 139),
                    (113, 145, 144),
                    (101, 137, 149),
                    (88, 128, 154),
                    (75, 119, 156),
                    (62, 107, 156),
                    (49, 93, 151),
                    (37, 77, 142),
                    (26, 60, 128),
                    (16, 42, 111),
                    (6, 24, 93),
                    (0, 5, 74)],
    'slev_seq_21': [(254, 254, 254),
                    (250, 250, 235),
                    (244, 244, 214),
                    (232, 234, 191),
                    (212, 218, 167),
                    (187, 199, 148),
                    (165, 182, 137),
                    (147, 168, 135),
                    (132, 158, 137),
                    (119, 149, 141),
                    (107, 141, 146),
                    (95, 133, 151),
                    (83, 125, 155),
                    (71, 115, 157),
                    (58, 103, 155),
                    (46, 89, 149),
                    (35, 74, 139),
                    (24, 57, 126),
                    (15, 41, 110),
                    (5, 24, 92),
                    (0, 5, 74)],
    'misc_seq_1_5': [(25, 51, 178),
                     (47, 93, 156),
                     (83, 133, 127),
                     (144, 195, 110),
                     (255, 254, 102)],
    'misc_seq_1_6': [(25, 51, 178),
                     (43, 85, 161),
                     (66, 116, 138),
                     (106, 156, 120),
                     (159, 209, 107),
                     (255, 254, 102)],
    'misc_seq_1_7': [(25, 51, 178),
                     (40, 79, 164),
                     (57, 106, 147),
                     (83, 133, 127),
                     (122, 173, 116),
                     (170, 218, 105),
                     (255, 254, 102)],
    'misc_seq_1_8': [(25, 51, 178),
                     (38, 75, 166),
                     (51, 99, 153),
                     (70, 120, 134),
                     (99, 149, 122),
                     (135, 186, 113),
                     (180, 225, 103),
                     (255, 254, 102)],
    'misc_seq_1_9': [(25, 51, 178),
                     (37, 72, 167),
                     (47, 93, 156),
                     (62, 112, 142),
                     (83, 133, 127),
                     (112, 163, 118),
                     (144, 195, 110),
                     (188, 229, 103),
                     (255, 254, 102)],
    'misc_seq_1_10': [(25, 51, 178),
                      (36, 70, 168),
                      (45, 89, 159),
                      (57, 106, 147),
                      (73, 123, 132),
                      (95, 146, 123),
                      (122, 173, 116),
                      (152, 203, 108),
                      (195, 233, 102),
                      (255, 254, 102)],
    'misc_seq_1_11': [(25, 51, 178),
                      (35, 68, 169),
                      (43, 85, 161),
                      (53, 101, 151),
                      (66, 116, 138),
                      (83, 133, 127),
                      (106, 156, 120),
                      (131, 182, 113),
                      (159, 209, 107),
                      (201, 235, 102),
                      (255, 254, 102)],
    'misc_seq_1_12': [(25, 51, 178),
                      (34, 67, 170),
                      (42, 82, 162),
                      (50, 97, 154),
                      (61, 111, 143),
                      (74, 125, 131),
                      (93, 143, 123),
                      (115, 165, 118),
                      (138, 189, 112),
                      (165, 214, 106),
                      (206, 237, 102),
                      (255, 254, 102)],
    'misc_seq_1_13': [(25, 51, 178),
                      (33, 65, 171),
                      (40, 79, 164),
                      (47, 93, 156),
                      (57, 106, 147),
                      (68, 118, 136),
                      (83, 133, 127),
                      (102, 152, 121),
                      (122, 173, 116),
                      (144, 195, 110),
                      (170, 218, 105),
                      (210, 239, 102),
                      (255, 254, 102)],
    'misc_seq_1_14': [(25, 51, 178),
                      (33, 64, 171),
                      (39, 77, 165),
                      (46, 90, 158),
                      (54, 102, 150),
                      (64, 114, 140),
                      (76, 126, 130),
                      (91, 142, 124),
                      (110, 160, 119),
                      (129, 180, 114),
                      (150, 200, 109),
                      (175, 222, 104),
                      (213, 240, 102),
                      (255, 254, 102)],
    'misc_seq_1_15': [(25, 51, 178),
                      (32, 63, 172),
                      (38, 75, 166),
                      (44, 87, 160),
                      (51, 99, 153),
                      (60, 110, 144),
                      (70, 120, 134),
                      (83, 133, 127),
                      (99, 149, 122),
                      (116, 167, 117),
                      (135, 186, 113),
                      (155, 205, 108),
                      (180, 225, 103),
                      (216, 241, 102),
                      (255, 254, 102)],
    'misc_seq_1_16': [(25, 51, 178),
                      (32, 62, 172),
                      (38, 74, 166),
                      (43, 85, 161),
                      (49, 96, 155),
                      (57, 106, 147),
                      (66, 116, 138),
                      (77, 127, 130),
                      (90, 141, 124),
                      (106, 156, 120),
                      (122, 173, 116),
                      (140, 191, 111),
                      (159, 209, 107),
                      (184, 227, 103),
                      (219, 242, 102),
                      (255, 254, 102)],
    'misc_seq_1_17': [(25, 51, 178),
                      (32, 62, 172),
                      (37, 72, 167),
                      (42, 83, 162),
                      (47, 93, 156),
                      (54, 103, 150),
                      (62, 112, 142),
                      (72, 122, 133),
                      (83, 133, 127),
                      (97, 147, 122),
                      (112, 163, 118),
                      (128, 179, 114),
                      (144, 195, 110),
                      (163, 213, 106),
                      (188, 229, 103),
                      (221, 243, 102),
                      (255, 254, 102)],
    'misc_seq_1_18': [(25, 51, 178),
                      (31, 61, 173),
                      (36, 71, 168),
                      (41, 81, 163),
                      (46, 91, 158),
                      (52, 100, 152),
                      (59, 109, 145),
                      (68, 118, 137),
                      (77, 128, 129),
                      (89, 140, 124),
                      (103, 153, 121),
                      (117, 168, 117),
                      (133, 183, 113),
                      (148, 199, 109),
                      (167, 216, 105),
                      (192, 231, 103),
                      (223, 244, 102),
                      (255, 254, 102)],
    'misc_seq_1_19': [(25, 51, 178),
                      (31, 61, 173),
                      (36, 70, 168),
                      (40, 79, 164),
                      (45, 89, 159),
                      (50, 98, 154),
                      (57, 106, 147),
                      (64, 114, 140),
                      (73, 123, 132),
                      (83, 133, 127),
                      (95, 146, 123),
                      (109, 159, 119),
                      (122, 173, 116),
                      (137, 188, 112),
                      (152, 203, 108),
                      (170, 218, 105),
                      (195, 233, 102),
                      (225, 244, 102),
                      (255, 254, 102)],
    'misc_seq_1_20': [(25, 51, 178),
                      (31, 60, 173),
                      (35, 69, 169),
                      (40, 78, 164),
                      (44, 87, 160),
                      (49, 95, 155),
                      (55, 104, 149),
                      (61, 111, 143),
                      (69, 119, 135),
                      (78, 128, 129),
                      (89, 139, 125),
                      (101, 151, 121),
                      (114, 164, 118),
                      (127, 178, 115),
                      (141, 192, 111),
                      (156, 206, 108),
                      (174, 221, 104),
                      (198, 234, 102),
                      (226, 245, 102),
                      (255, 254, 102)],
    'misc_seq_1_21': [(25, 51, 178),
                      (30, 60, 174),
                      (35, 68, 169),
                      (39, 77, 165),
                      (43, 85, 161),
                      (47, 93, 156),
                      (53, 101, 151),
                      (59, 109, 145),
                      (66, 116, 138),
                      (74, 124, 132),
                      (83, 133, 127),
                      (94, 144, 123),
                      (106, 156, 120),
                      (118, 169, 117),
                      (131, 182, 113),
                      (144, 195, 110),
                      (159, 209, 107),
                      (177, 223, 104),
                      (201, 235, 102),
                      (228, 245, 102),
                      (255, 254, 102)],
    'misc_seq_2_5': [(230, 240, 240),
                     (134, 185, 226),
                     (119, 113, 213),
                     (110, 46, 132),
                     (54, 14, 36)],
    'misc_seq_2_6': [(230, 240, 240),
                     (149, 197, 226),
                     (115, 144, 227),
                     (120, 84, 186),
                     (103, 35, 112),
                     (54, 14, 36)],
    'misc_seq_2_7': [(230, 240, 240),
                     (161, 205, 226),
                     (118, 163, 228),
                     (119, 113, 213),
                     (118, 66, 164),
                     (98, 29, 98),
                     (54, 14, 36)],
    'misc_seq_2_8': [(230, 240, 240),
                     (170, 210, 226),
                     (125, 176, 227),
                     (116, 135, 224),
                     (121, 92, 195),
                     (114, 54, 146),
                     (93, 25, 88),
                     (54, 14, 36)],
    'misc_seq_2_9': [(230, 240, 240),
                     (177, 214, 227),
                     (134, 185, 226),
                     (115, 151, 228),
                     (119, 113, 213),
                     (120, 77, 178),
                     (110, 46, 132),
                     (89, 23, 80),
                     (54, 14, 36)],
    'misc_seq_2_10': [(230, 240, 240),
                      (182, 217, 228),
                      (142, 192, 226),
                      (118, 163, 228),
                      (116, 130, 222),
                      (121, 97, 199),
                      (118, 66, 164),
                      (107, 40, 121),
                      (86, 22, 75),
                      (54, 14, 36)],
    'misc_seq_2_11': [(230, 240, 240),
                      (187, 219, 228),
                      (149, 197, 226),
                      (123, 172, 227),
                      (115, 144, 227),
                      (119, 113, 213),
                      (120, 84, 186),
                      (115, 58, 152),
                      (103, 35, 112),
                      (83, 21, 70),
                      (54, 14, 36)],
    'misc_seq_2_12': [(230, 240, 240),
                      (190, 221, 229),
                      (155, 201, 226),
                      (128, 179, 227),
                      (115, 154, 228),
                      (117, 127, 221),
                      (120, 100, 202),
                      (119, 74, 175),
                      (113, 51, 141),
                      (100, 32, 104),
                      (81, 20, 67),
                      (54, 14, 36)],
    'misc_seq_2_13': [(230, 240, 240),
                      (194, 223, 230),
                      (161, 205, 226),
                      (134, 185, 226),
                      (118, 163, 228),
                      (115, 139, 225),
                      (119, 113, 213),
                      (121, 89, 192),
                      (118, 66, 164),
                      (110, 46, 132),
                      (98, 29, 98),
                      (78, 19, 64),
                      (54, 14, 36)],
    'misc_seq_2_14': [(230, 240, 240),
                      (196, 224, 230),
                      (165, 207, 226),
                      (139, 190, 226),
                      (121, 170, 228),
                      (115, 148, 227),
                      (117, 125, 220),
                      (120, 102, 204),
                      (120, 80, 182),
                      (116, 59, 155),
                      (108, 41, 125),
                      (95, 27, 93),
                      (77, 19, 61),
                      (54, 14, 36)],
    'misc_seq_2_15': [(230, 240, 240),
                      (199, 225, 231),
                      (170, 210, 226),
                      (144, 194, 226),
                      (125, 176, 227),
                      (116, 156, 228),
                      (116, 135, 224),
                      (119, 113, 213),
                      (121, 92, 195),
                      (119, 72, 172),
                      (114, 54, 146),
                      (106, 38, 118),
                      (93, 25, 88),
                      (75, 18, 59),
                      (54, 14, 36)],
    'misc_seq_2_16': [(230, 240, 240),
                      (201, 226, 231),
                      (173, 212, 227),
                      (149, 197, 226),
                      (130, 181, 227),
                      (118, 163, 228),
                      (115, 144, 227),
                      (117, 123, 219),
                      (120, 103, 205),
                      (120, 84, 186),
                      (118, 66, 164),
                      (112, 49, 139),
                      (103, 35, 112),
                      (91, 24, 84),
                      (74, 18, 57),
                      (54, 14, 36)],
    'misc_seq_2_17': [(230, 240, 240),
                      (202, 227, 231),
                      (177, 214, 227),
                      (153, 200, 226),
                      (134, 185, 226),
                      (120, 169, 228),
                      (115, 151, 228),
                      (116, 132, 223),
                      (119, 113, 213),
                      (121, 95, 198),
                      (120, 77, 178),
                      (116, 61, 156),
                      (110, 46, 132),
                      (101, 33, 107),
                      (89, 23, 80),
                      (73, 18, 56),
                      (54, 14, 36)],
    'misc_seq_2_18': [(230, 240, 240),
                      (204, 228, 232),
                      (179, 215, 227),
                      (157, 202, 226),
                      (138, 189, 226),
                      (124, 174, 227),
                      (116, 158, 228),
                      (115, 140, 226),
                      (118, 122, 218),
                      (120, 104, 206),
                      (121, 87, 190),
                      (119, 71, 171),
                      (115, 56, 150),
                      (108, 42, 127),
                      (99, 31, 102),
                      (87, 22, 77),
                      (72, 18, 55),
                      (54, 14, 36)],
    'misc_seq_2_19': [(230, 240, 240),
                      (205, 229, 232),
                      (182, 217, 228),
                      (161, 205, 226),
                      (142, 192, 226),
                      (127, 178, 227),
                      (118, 163, 228),
                      (115, 147, 227),
                      (116, 130, 222),
                      (119, 113, 213),
                      (121, 97, 199),
                      (120, 81, 183),
                      (118, 66, 164),
                      (113, 52, 143),
                      (107, 40, 121),
                      (98, 29, 98),
                      (86, 22, 75),
                      (71, 17, 53),
                      (54, 14, 36)],
    'misc_seq_2_20': [(230, 240, 240),
                      (207, 229, 232),
                      (184, 218, 228),
                      (164, 207, 226),
                      (146, 194, 226),
                      (130, 182, 227),
                      (120, 168, 228),
                      (115, 153, 228),
                      (115, 137, 225),
                      (118, 121, 218),
                      (120, 105, 207),
                      (121, 90, 193),
                      (120, 75, 176),
                      (117, 61, 158),
                      (112, 49, 138),
                      (105, 37, 116),
                      (96, 28, 94),
                      (84, 21, 72),
                      (70, 17, 52),
                      (54, 14, 36)],
    'misc_seq_2_21': [(230, 240, 240),
                      (208, 230, 233),
                      (187, 219, 228),
                      (167, 208, 226),
                      (149, 197, 226),
                      (134, 185, 226),
                      (123, 172, 227),
                      (116, 158, 228),
                      (115, 144, 227),
                      (117, 128, 222),
                      (119, 113, 213),
                      (120, 98, 201),
                      (120, 84, 186),
                      (119, 70, 170),
                      (115, 58, 152),
                      (110, 46, 132),
                      (103, 35, 112),
                      (94, 26, 91),
                      (83, 21, 70),
                      (69, 17, 51),
                      (54, 14, 36)],
    'misc_seq_3_5': [(0, 25, 89),
                     (34, 91, 95),
                     (127, 129, 51),
                     (243, 158, 113),
                     (250, 204, 250)],
    'misc_seq_3_6': [(0, 25, 89),
                     (24, 78, 97),
                     (87, 117, 71),
                     (178, 141, 50),
                     (251, 166, 141),
                     (250, 204, 250)],
    'misc_seq_3_7': [(0, 25, 89),
                     (19, 69, 96),
                     (62, 108, 84),
                     (127, 129, 51),
                     (212, 148, 71),
                     (253, 172, 159),
                     (250, 204, 250)],
    'misc_seq_3_8': [(0, 25, 89),
                     (17, 63, 95),
                     (45, 99, 92),
                     (98, 121, 65),
                     (162, 138, 46),
                     (233, 153, 94),
                     (253, 177, 171),
                     (250, 204, 250)],
    'misc_seq_3_9': [(0, 25, 89),
                     (15, 58, 94),
                     (34, 91, 95),
                     (77, 114, 76),
                     (127, 129, 51),
                     (191, 144, 56),
                     (243, 158, 113),
                     (253, 180, 181),
                     (250, 204, 250)],
    'misc_seq_3_10': [(0, 25, 89),
                      (14, 54, 94),
                      (28, 84, 96),
                      (62, 108, 84),
                      (104, 122, 61),
                      (154, 136, 45),
                      (212, 148, 71),
                      (249, 163, 129),
                      (253, 182, 188),
                      (250, 204, 250)],
    'misc_seq_3_11': [(0, 25, 89),
                      (13, 51, 93),
                      (24, 78, 97),
                      (50, 102, 90),
                      (87, 117, 71),
                      (127, 129, 51),
                      (178, 141, 50),
                      (227, 151, 87),
                      (251, 166, 141),
                      (253, 184, 194),
                      (250, 204, 250)],
    'misc_seq_3_12': [(0, 25, 89),
                      (12, 49, 93),
                      (21, 73, 96),
                      (41, 97, 93),
                      (73, 112, 78),
                      (108, 124, 59),
                      (149, 135, 45),
                      (197, 145, 60),
                      (237, 155, 101),
                      (252, 170, 151),
                      (252, 186, 199),
                      (250, 204, 250)],
    'misc_seq_3_13': [(0, 25, 89),
                      (11, 47, 93),
                      (19, 69, 96),
                      (34, 91, 95),
                      (62, 108, 84),
                      (93, 119, 67),
                      (127, 129, 51),
                      (169, 139, 47),
                      (212, 148, 71),
                      (243, 158, 113),
                      (253, 172, 159),
                      (252, 188, 203),
                      (250, 204, 250)],
    'misc_seq_3_14': [(0, 25, 89),
                      (10, 45, 92),
                      (18, 66, 95),
                      (30, 86, 96),
                      (52, 104, 89),
                      (81, 115, 74),
                      (111, 124, 58),
                      (145, 134, 46),
                      (186, 143, 53),
                      (224, 150, 83),
                      (247, 161, 124),
                      (253, 175, 165),
                      (252, 189, 207),
                      (250, 204, 250)],
    'misc_seq_3_15': [(0, 25, 89),
                      (10, 44, 92),
                      (17, 63, 95),
                      (26, 82, 97),
                      (45, 99, 92),
                      (70, 112, 80),
                      (98, 121, 65),
                      (127, 129, 51),
                      (162, 138, 46),
                      (201, 145, 62),
                      (233, 153, 94),
                      (250, 164, 133),
                      (253, 177, 171),
                      (252, 190, 210),
                      (250, 204, 250)],
    'misc_seq_3_16': [(0, 25, 89),
                      (9, 43, 92),
                      (16, 60, 95),
                      (24, 78, 97),
                      (39, 95, 94),
                      (62, 108, 84),
                      (87, 117, 71),
                      (113, 125, 57),
                      (143, 133, 46),
                      (178, 141, 50),
                      (212, 148, 71),
                      (239, 156, 104),
                      (251, 166, 141),
                      (253, 178, 176),
                      (252, 191, 212),
                      (250, 204, 250)],
    'misc_seq_3_17': [(0, 25, 89),
                      (9, 41, 92),
                      (15, 58, 94),
                      (22, 75, 96),
                      (34, 91, 95),
                      (54, 104, 88),
                      (77, 114, 76),
                      (101, 122, 63),
                      (127, 129, 51),
                      (157, 137, 45),
                      (191, 144, 56),
                      (222, 150, 81),
                      (243, 158, 113),
                      (252, 169, 148),
                      (253, 180, 181),
                      (252, 191, 215),
                      (250, 204, 250)],
    'misc_seq_3_18': [(0, 25, 89),
                      (8, 40, 91),
                      (14, 56, 94),
                      (20, 72, 96),
                      (31, 88, 96),
                      (48, 101, 91),
                      (69, 111, 81),
                      (91, 119, 68),
                      (115, 125, 56),
                      (141, 133, 47),
                      (171, 140, 47),
                      (203, 146, 64),
                      (230, 152, 90),
                      (246, 160, 121),
                      (252, 171, 153),
                      (253, 181, 185),
                      (252, 192, 217),
                      (250, 204, 250)],
    'misc_seq_3_19': [(0, 25, 89),
                      (8, 40, 91),
                      (14, 54, 94),
                      (19, 69, 96),
                      (28, 84, 96),
                      (42, 98, 93),
                      (62, 108, 84),
                      (82, 116, 73),
                      (104, 122, 61),
                      (127, 129, 51),
                      (154, 136, 45),
                      (184, 142, 52),
                      (212, 148, 71),
                      (235, 154, 98),
                      (249, 163, 129),
                      (253, 172, 159),
                      (253, 182, 188),
                      (252, 193, 218),
                      (250, 204, 250)],
    'misc_seq_3_20': [(0, 25, 89),
                      (7, 39, 91),
                      (13, 53, 93),
                      (18, 67, 96),
                      (26, 81, 97),
                      (38, 94, 94),
                      (55, 105, 88),
                      (75, 113, 77),
                      (95, 120, 66),
                      (116, 126, 55),
                      (139, 132, 47),
                      (166, 139, 46),
                      (195, 144, 58),
                      (221, 150, 79),
                      (240, 156, 106),
                      (250, 165, 135),
                      (253, 174, 163),
                      (253, 183, 191),
                      (252, 193, 220),
                      (250, 204, 250)],
    'misc_seq_3_21': [(0, 25, 89),
                      (7, 38, 91),
                      (13, 51, 93),
                      (17, 65, 95),
                      (24, 78, 97),
                      (34, 91, 95),
                      (50, 102, 90),
                      (68, 111, 81),
                      (87, 117, 71),
                      (106, 123, 60),
                      (127, 129, 51),
                      (151, 135, 45),
                      (178, 141, 50),
                      (204, 146, 65),
                      (227, 151, 87),
                      (243, 158, 113),
                      (251, 166, 141),
                      (253, 175, 167),
                      (253, 184, 194),
                      (252, 194, 221),
                      (250, 204, 250)]
}


if __name__ == '__main__':
    import doctest
    doctest.testmod(optionflags=doctest.NORMALIZE_WHITESPACE)
