#!/usr/bin/env python
"""
Color palettes from the University of Oregon

Colormaps from Geography, University of Oregon
A. Light and P. J. Bartlein (2004) The End of the Rainbow? Color Schemes for
Improved Data Graphics, EOS 85(40), 385-391

Old weblink does not work anymore:
    http://geography.uoregon.edu/datagraphics/color_scales.htm

.. moduleauthor:: Matthias Cuntz

History
    * Written Jun 2013, Matthias Cuntz
    * Made dictionaries with color palettes,
      Mar 2015, Matthias Cuntz
    * Ported to pyjams, Nov 2021, Matthias Cuntz
    * flake8 compatible, Nov 2021, Matthias Cuntz
    * Prepend osu to all palette names, Nov 2021, Matthias Cuntz

"""

__all__ = ['oregon_sequential', 'oregon_diverging', 'oregon_qualitative']


# Oregon State University

# sequential
oregon_sequential = {
    'osu_bu7': [(255, 255, 255), (204, 253, 255), (153, 248, 255),
                (102, 240, 255), (51, 228, 255), (0, 170, 204),
                (0, 122, 153)],
    'osu_bu10': [(229, 255, 255), (204, 250, 255), (178, 242, 255),
                 (153, 229, 255), (127, 212, 255), (101, 191, 255),
                 (76, 165, 255), (50, 136, 255), (25, 101, 255),
                 (0, 63, 255)],
    'osu_step5': [(153, 15, 15), (178, 44, 44), (204, 81, 81),
                  (229, 126, 126), (255, 178, 178), (153, 84, 15),
                  (178, 111, 44), (204, 142, 81), (229, 177, 126),
                  (255, 216, 178), (107, 153, 15), (133, 178, 44),
                  (163, 204, 81), (195, 229, 126), (229, 255, 178),
                  (15, 107, 153), (44, 133, 178), (81, 163, 204),
                  (126, 195, 229), (178, 229, 255), (38, 15, 153),
                  (66, 44, 178), (101, 81, 204), (143, 126, 229),
                  (191, 178, 255)],
}


# diverging
oregon_diverging = {
    'osu_brbu10': [(102, 47, 0), (153, 96, 53), (204, 155, 122),
                   (216, 175, 151), (242, 218, 205), (204, 253, 255),
                   (153, 248, 255), (101, 239, 255), (50, 227, 255),
                   (0, 169, 204)],
    'osu_brbu12': [(51, 25, 0), (102, 47, 0), (153, 96, 53),
                   (204, 155, 122), (216, 175, 151), (242, 218, 205),
                   (204, 253, 255), (153, 248, 255), (101, 239, 255),
                   (50, 227, 255), (0, 169, 204), (0, 122, 153)],
    'osu_budor12': [(30, 142, 153), (81, 195, 204), (153, 249, 255),
                    (178, 252, 255), (204, 254, 255), (229, 255, 255),
                    (255, 229, 204), (255, 202, 153), (255, 173, 101),
                    (255, 142, 50), (204, 88, 0), (153, 63, 0)],
    'osu_budor18': [(0, 102, 102), (0, 153, 153), (0, 204, 204),
                    (0, 255, 255), (51, 255, 255), (101, 255, 255),
                    (153, 255, 255), (178, 255, 255), (203, 255, 255),
                    (229, 255, 255), (255, 229, 203), (255, 202, 153),
                    (255, 173, 101), (255, 142, 51), (255, 110, 0),
                    (204, 85, 0), (153, 61, 0), (102, 39, 0)],
    'osu_drdbu12': [(41, 10, 216), (38, 77, 255), (63, 160, 255),
                    (114, 217, 255), (170, 247, 255), (224, 255, 255),
                    (255, 255, 191), (255, 224, 153), (255, 173, 114),
                    (247, 109, 94), (216, 38, 50), (165, 0, 33)],
    'osu_drdbu18': [(36, 0, 216), (24, 28, 247), (40, 87, 255),
                    (61, 135, 255), (86, 176, 255), (117, 211, 255),
                    (153, 234, 255), (188, 249, 255), (234, 255, 255),
                    (255, 255, 234), (255, 241, 188), (255, 214, 153),
                    (255, 172, 117), (255, 120, 86), (255, 61, 61),
                    (247, 39, 53), (216, 21, 47), (165, 0, 33)],
    'osu_bugn14': [(0, 0, 255), (51, 51, 255), (101, 101, 255),
                   (153, 153, 255), (178, 178, 255), (203, 203, 255),
                   (229, 229, 255), (229, 255, 229), (203, 255, 203),
                   (178, 255, 178), (153, 255, 153), (101, 255, 101),
                   (51, 255, 51), (0, 255, 0)],
    'osu_bugr8': [(0, 153, 204), (102, 229, 255), (153, 255, 255),
                  (204, 255, 255), (229, 229, 229), (153, 153, 153),
                  (102, 102, 102), (51, 51, 51)],
    'osu_buor8': [(0, 127, 255), (76, 195, 255), (153, 237, 255),
                  (204, 255, 255), (255, 255, 204), (255, 238, 153),
                  (255, 195, 76), (255, 127, 0)],
    'osu_buor10': [(0, 84, 255), (50, 153, 255), (101, 204, 255),
                   (153, 237, 255), (204, 255, 255), (255, 255, 204),
                   (255, 238, 153), (255, 204, 101), (255, 153, 50),
                   (255, 85, 0)],
    'osu_buor12': [(0, 42, 255), (25, 101, 255), (50, 153, 255),
                   (101, 204, 255), (153, 237, 255), (204, 255, 255),
                   (255, 255, 204), (255, 238, 153), (255, 204, 101),
                   (255, 153, 50), (255, 102, 25), (255, 42, 0)],
    'osu_buor14': [(7, 90, 255), (50, 118, 255), (89, 144, 255),
                   (140, 178, 255), (191, 212, 255), (229, 238, 255),
                   (247, 249, 255), (255, 255, 204), (255, 255, 153),
                   (255, 255, 0), (255, 204, 0), (255, 153, 0),
                   (255, 102, 0), (255, 0, 0)],
    'osu_rdylbu11b': [(165, 0, 33), (216, 38, 50), (247, 109, 94),
                      (255, 173, 114), (255, 224, 153), (255, 255, 191),
                      (224, 255, 255), (170, 247, 255), (114, 216, 255),
                      (63, 160, 255), (38, 76, 255)],
    'osu_gnmg16': [(0, 80, 0), (0, 134, 0), (0, 187, 0),
                   (0, 241, 0), (80, 255, 80), (134, 255, 134),
                   (187, 255, 187), (255, 255, 255), (255, 241, 255),
                   (255, 187, 255), (255, 134, 255), (255, 80, 255),
                   (241, 0, 241), (187, 0, 187), (134, 0, 134),
                   (80, 0, 80)],
}


# qualitative
oregon_qualitative = {
    'osu_cat12': [(255, 191, 127), (255, 127, 0), (255, 255, 153),
                  (255, 255, 50), (178, 255, 140), (50, 255, 0),
                  (165, 237, 255), (25, 178, 255), (204, 191, 255),
                  (101, 76, 255), (255, 153, 191), (229, 25, 50)],
}


if __name__ == '__main__':
    import doctest
    doctest.testmod(optionflags=doctest.NORMALIZE_WHITESPACE)
