# Changelog

All notable changes to this project will be documented in this file.

## [0.6.6] - 2025-03-27

### Bug Fixes

- Two bugs in `BinaryAdder`
- Don't attempt scraping examples that rely on cyclic dependencies

### Features

- Optimize `DbGte` building code

### Miscellaneous Tasks

- Fix warnings in benches

### Testing

- Extend pb-enc benchmarks

<!-- generated by git-cliff -->
## [0.6.5] - 2025-03-25

### Features

- SIS MaxSAT algorithm
- Add examples from `rustsat-tools`
- Main branch documentation available [here](https://christophjabs.info/rustsat/main/rustsat)
- Expose literal parsing functions as internals

### Bug Fixes

- Use var count from DIMACS header as minimum

### Documentation

- Document MSRV policy

### Testing

- Basic tests for am1 encodings

### Miscellaneous Tasks

- Cargo fmt
- Cargo clippy
- Update rust crate syn to v2.0.100 (#298)
- Update patch updates (#288)
- Update patch updates (#291)
- Update patch updates (#304)
- Update PyO3 to 0.24.0
- Force synced versions via workspace
- Bump MSRV to 1.74.0
- Temporarily disable semver-checks lint
- Remove deprecated CI badges

<!-- generated by git-cliff -->
## [0.6.4] - 2025-02-18

### Features

- Optional serde support behind `serde` feature

### Bug Fixes

- Dpw reserve don't build unnecessary structure

### Dependencies

- Update patch updates (#219)
- Update rust crate quote to v1.0.38 (#222)
- Update patch updates (#241)
- Update rust crate syn to v2.0.98 (#259)

<!-- generated by git-cliff -->
## [0.6.3] - 2024-12-20

### Miscellaneous Tasks

- Exclude unnecessary files from release

<!-- generated by git-cliff -->
## [0.6.2] - 2024-12-13

### Features

- Check variable addition overflow in debug
- `Var` and `Lit` constructors in `const` context
- Implement `kani::Arbitrary` for `TernaryVal`
- `BinaryAdder` PB encoding
- Initialize encodings when calling `reserve`
- Include rustsat version in header
- Include C sources for newest version

### Bug Fixes

- Unnecessary `mut` warning in `clause![]`

### Documentation

- Spelling

### Testing

- Switch to nextest for running tests

### Miscellaneous Tasks

- Bump a bunch of dependencies
- Cleanup file endings and trailing whitespace
- Set up pre-commit hooks
- Group dependabot PRs
- Clippy
- Do not run nextest if no tests

<!-- generated by git-cliff -->
## [0.6.1] - 2024-10-16

### Documentation

- Fix docsrs build

<!-- generated by git-cliff -->
## [0.6.0] - 2024-10-16

### Features

- External solver interface
- Batsat solver interface
- Generalize batsat interface
- `lit` method for `Var`
- Implement `Default` for `TernaryVal`
- `iter` method for `Assignment`
- `is_sat` for `Cnf` and `Assignment` ergonomics
- `Propagate` trait
- `Cl` as light-weight DST for clauses
- [**breaking**] Add `evaluate`, replacing `is_sat`
- Add generalized totalizer to capi
- `Cnf::clear`
- Ladder at-most-one encoding
- Bitwise at-most-one encoding
- Commander at-most-one encoding
- Bimander at-most-one encoding

### Documentation

- Fix ambiguous links
- Mark `internals` properly
- Fix typos

### Miscellaneous Tasks

- Move main crate to project root
- Pedantic clippy
- [**breaking**] Breaking clippy suggestions
- [**breaking**] Rename constraint types
- Update dependencies
- Run clippy nightly on prs
- Update dependencies
- Clippy with most-recent nightly
- Set up nix dev shell and tools package

### Refactor

- [**breaking**] Make reading functions take reader by reference
- Use bindgen to generate solver bindings

### Testing

- Paths relative to manifest
- Basic kani harnesses for `Var` and `Lit`

### Api

- [**breaking**] Mark unchecked functions as unsafe

<!-- generated by git-cliff -->
## [0.5.1] - 2024-06-12

### Features

- Incremental precision in DPW
- Format vars and lits nicely with debug

### Bug Fixes

- Make `Node` type (of `dbtotalizer`) opaque. This is technically a breaking
  change, but since the `Node` type was never intended to be transparent, we are
  _not_ treating it as one. If you are relying on having access to the `Node`
  type, use the feature `internal` instead, but note that the internal API is
  unstable.

### Testing

- Fix warnings

<!-- generated by git-cliff -->
## [0.5.0] - 2024-04-30

This release contains breaking changes. For detailed instructions on how to
handle migration, please refer to the [migration
guide](https://github.com/chrjabs/rustsat/blob/main/docs/0-5-0-migration-guide.md).

### Bug Fixes

- Incorrect coarse_ub in dpw when unweighted
- Dynamic polynomial watchdog edge cases with < 2 inputs

### Documentation

- Clarify lit rep and relation to IPASIR/DIMACS
- Add missing documentation
- Fix broken links

### Features

- Migrate error handling to `anyhow` create
- Move IPASIR bindings to separate crate
- Instance ergonomics for member variables
- Ergonomics for opb writing
- Ergonomics for dimacs writing
- Add `add_clause_ref` method to `Solve` trait
- Add `add_nary` function
- Have file parsers take `BufRead` types
- `Extend<&Clause>` for solvers
- Catch memory out in solvers
- Catch memory outs in clause collector
- Parse external solver output
- `ipasir-display` feature

### Miscellaneous Tasks

- Update to `pyo3` 0.21
- Specify minimum rust version

### Performance

- Add `BufWriter` when writing to file
- Avoid unnecessary cloning

### Refactor

- Clean up control flow in solver methods
- Clean up control flow in dimacs parsing
- Factor out C-API
- Factor out Python API

<!-- generated by git-cliff -->
## [0.4.3] - 2024-02-22

### Features

- Internal `from_raw` methods for db totalizers
- Thorough merge strategy for `NodeById`
- Make opb defaults more like pbo competition specs
- Output opbs with `#variable` line

### Bug Fixes

- Remove `weight_sum` field from `DbGte`

### Documentation

- Disable cbindgen on docs.rs

<!-- generated by git-cliff -->
<!-- generated by git-cliff -->
## [0.4.2] - 2024-01-11

### Documentation

- Mark required features in documentation on [docs.rs](https://docs.rs/rustsat)

## [0.4.1] - 2024-01-11

### Documentation

- Improve doc examples
- Add shields to READMEs

### Features

- Helpful shortcuts in instances and solver
- Index assignments by var and negate ternary vals

<!-- generated by git-cliff -->
## [0.4.0] - 2023-12-18

### Bug Fixes

- Set var manager in SatInstance::from_iter
- Set vm correctly in SatInstance::from(Cnf)
- Coarse convergence bounds
- Link capi tests to archive libs
- Typo in capi
- Parse empty instances correctly
- Limited connections in node db
- Next value in db-referencing gtes

### Documentation

- (limited) python api documentation

### Features

- Python api expose lit, clause, cnf
- Python len and indexing support for clause and cnf
- Feature switch for python api
- Python iterators
- Totalizer and comparison operators in pyapi
- Expose all encodings in python api
- Extend internal node api
- Limited connections in node db
- Constant method for objective
- Allow cloning totalizer db

## [0.3.0]

### Refactor

- Allow encodings to output straight to solvers

### Features

- Alternative totalizer implementation based on a totalizer database
- Dynamic polynomial watchdog encoing
- Changes to public API: changed some vectores to slices
- Changed internal variable/literal representation from `usize` to `u32`

## [0.2.x]

Solver interfaces factored out into seperate crates.
See detailed changes in [GitHub Releases](https://github.com/chrjabs/rustsat/releases).

## [0.1.2]

Updated initial version with working dependencies.

## [0.1.0] and [0.1.1]

Yanked because of dependencies that don't exist anymore
