# Changelog

All notable changes to this project will be documented in this file.

## [0.4.6] - 2025-03-27

### Miscellaneous Tasks

- Updated the following local packages: rustsat

<!-- generated by git-cliff -->
## [0.4.5] - 2025-03-25

### Bug Fixes

- Fix all warnings

### Miscellaneous Tasks

- Include source as subtree
- Fix trailing whitespace
- Remove deprecated CI badges

<!-- generated by git-cliff -->
## [0.4.4] - 2025-02-18

### Miscellaneous Tasks

- Update Cargo.toml dependencies

<!-- generated by git-cliff -->
## [0.4.3] - 2024-12-20

### Miscellaneous Tasks

- Exclude unnecessary files from release

<!-- generated by git-cliff -->
## [0.4.2] - 2024-12-13

### Documentation

- Spellchecking

<!-- generated by git-cliff -->
## [0.4.1] - 2024-10-16

### Documentation

- Fix docsrs build

<!-- generated by git-cliff -->
## [0.4.0] - 2024-10-16

### Features

- `Propagate` trait

### Miscellaneous Tasks

- Pedantic clippy

### Refactor

- [**breaking**] Make reading functions take reader by reference
- Use bindgen to generate solver bindings

<!-- generated by git-cliff -->
## [0.3.1] - 2024-06-12

### Miscellaneous Tasks

- Updated the following local packages: rustsat

<!-- generated by git-cliff -->
## [0.3.0] - 2024-04-30

The corresponding RustSAT release contains breaking changes. For detailed
instructions on how to handle migration, please refer to the [migration
guide](https://github.com/chrjabs/rustsat/blob/main/docs/0-5-0-migration-guide.md).

### Bug Fixes

- Variable freezing and return value for `var_eliminated`
- Segfault in minisat

### Documentation

- Add missing documentation

### Features

- `quiet` feature to disable stdout printing
- Migrate error handling to `anyhow` create
- `FreezeVar` trait
- Return error when assumption is eliminated
- Add `add_clause_ref` method to `Solve` trait
- `Extend<&Clause>` for solvers
- Catch memory out in solvers
- Catch memory outs in clause collector

### Refactor

- Clean up control flow in solver methods
- Factor out solver integration tests
- Factor out solver unit tests
- Solver build system

### Testing

- Minisat segfault tests

### Example

- `minisat-cli` tool

<!-- generated by git-cliff -->
## [0.2.4] - 2024-02-22

### Bug Fixes

- Remove zlib dependency from minisat and glucose

<!-- generated by git-cliff -->
<!-- generated by git-cliff -->
## [0.2.3] - 2024-01-11

### Documentation

- Fix [docs.rs](https://docs.rs/rustsat-minisat) build

## [0.2.2] - 2024-01-11

### Bug Fixes

- Build on non-linux

### Documentation

- Add shields to READMEs

### Features

- Debug feature

<!-- generated by git-cliff -->
## [0.2.1] - 2023-12-18

### Miscellaneous Tasks

- Updated the following local packages: rustsat

<!-- generated by git-cliff -->
