from typing import List, final

from rustsat import encodings

__all__ = ["Lit", "Clause", "Cnf", "VarManager", "encodings"]

@final
class Lit:
    def __new__(cls, ipasir: int) -> "Lit": ...
    def to_ipasir(self) -> int: ...

@final
class Clause:
    def __new__(cls, lits: List[Lit]) -> "Clause": ...
    def is_unit(self) -> bool: ...
    def is_binary(self) -> bool: ...
    def add(self, lit: Lit) -> None: ...
    def remove(self, lit: Lit) -> None: ...
    def remove_thorough(self, lit: Lit) -> None: ...
    def extend(self, lits: List[Lit]) -> None: ...

@final
class Cnf:
    def __new__(cls, clauses: List[Clause]) -> "Cnf": ...
    def add_clause(self, clause: Clause) -> None: ...
    def add_unit(self, unit: Lit) -> None: ...
    def add_binary(self, lit1: Lit, lit2: Lit) -> None: ...
    def add_ternary(self, lit1: Lit, lit2: Lit, lit3: Lit) -> None: ...
    def add_lit_impl_lit(self, a: Lit, b: Lit) -> None: ...
    def add_lit_impl_clause(self, a: Lit, b: List[Lit]) -> None: ...
    def add_lit_impl_cube(self, a: Lit, b: List[Lit]) -> None: ...
    def add_clause_impl_lit(self, a: List[Lit], b: Lit) -> None: ...
    def add_cube_impl_lit(self, a: List[Lit], b: Lit) -> None: ...
    def add_clause_impl_clause(self, a: List[Lit], b: List[Lit]) -> None: ...
    def add_clause_impl_cube(self, a: List[Lit], b: List[Lit]) -> None: ...
    def add_cube_impl_clause(self, a: List[Lit], b: List[Lit]) -> None: ...
    def add_cube_impl_cube(self, a: List[Lit], b: List[Lit]) -> None: ...

@final
class VarManager:
    def __new__(cls, n_used: int = 0) -> "VarManager": ...
    def increase_used(self, n_used: int) -> None: ...
    def new_var(self) -> int: ...
    def n_used(self) -> int: ...
