from rustsat import Lit, Cnf, VarManager
from typing import List, final

__all__ = ["GeneralizedTotalizer", "DynamicPolyWatchdog", "BinaryAdder"]

@final
class GeneralizedTotalizer:
    def __new__(cls, wlits: List[tuple[int, Lit]]) -> "GeneralizedTotalizer": ...
    def extend(self, lits: List[Lit]) -> None: ...
    def weight_sum(self) -> int: ...
    def n_clauses(self) -> int: ...
    def n_vars(self) -> int: ...
    def encode_ub(self, min_ub: int, max_ub: int, var_manager: VarManager) -> Cnf: ...
    def enforce_ub(self, ub) -> List[Lit]: ...

@final
class DynamicPolyWatchdog:
    def __new__(cls, wlits: List[tuple[int, Lit]]) -> "DynamicPolyWatchdog": ...
    def weight_sum(self) -> int: ...
    def n_clauses(self) -> int: ...
    def n_vars(self) -> int: ...
    def encode_ub(self, min_ub: int, max_ub: int, var_manager: VarManager) -> Cnf: ...
    def enforce_ub(self, ub) -> List[Lit]: ...

@final
class BinaryAdder:
    def __new__(cls, wlits: List[tuple[int, Lit]]) -> "BinaryAdder": ...
    def extend(self, lits: List[Lit]) -> None: ...
    def weight_sum(self) -> int: ...
    def n_clauses(self) -> int: ...
    def n_vars(self) -> int: ...
    def encode_ub(self, min_ub: int, max_ub: int, var_manager: VarManager) -> Cnf: ...
    def enforce_ub(self, ub) -> List[Lit]: ...
    def encode_lb(self, min_lb: int, max_lb: int, var_manager: VarManager) -> Cnf: ...
    def enforce_lb(self, lb) -> List[Lit]: ...
    def encode_both(
        self, min_bound: int, max_bound: int, var_manager: VarManager
    ) -> Cnf: ...
    def enforce_eq(self, val) -> List[Lit]: ...
