from .agent import BackupAgent as BackupAgent, LocalBackupAgent as LocalBackupAgent
from .const import DOMAIN as DOMAIN, LOGGER as LOGGER
from .models import AgentBackup as AgentBackup, BackupNotFound as BackupNotFound
from .util import read_backup as read_backup, suggested_filename as suggested_filename
from _typeshed import Incomplete
from collections.abc import AsyncIterator, Callable as Callable, Coroutine
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.hassio import is_hassio as is_hassio
from pathlib import Path
from typing import Any

async def async_get_backup_agents(hass: HomeAssistant, **kwargs: Any) -> list[BackupAgent]: ...

class CoreLocalBackupAgent(LocalBackupAgent):
    domain = DOMAIN
    name: str
    unique_id: str
    _hass: Incomplete
    _backup_dir: Incomplete
    _backups: dict[str, tuple[AgentBackup, Path]]
    _loaded_backups: bool
    def __init__(self, hass: HomeAssistant) -> None: ...
    async def _load_backups(self) -> None: ...
    def _read_backups(self) -> dict[str, tuple[AgentBackup, Path]]: ...
    async def async_download_backup(self, backup_id: str, **kwargs: Any) -> AsyncIterator[bytes]: ...
    async def async_upload_backup(self, *, open_stream: Callable[[], Coroutine[Any, Any, AsyncIterator[bytes]]], backup: AgentBackup, **kwargs: Any) -> None: ...
    async def async_list_backups(self, **kwargs: Any) -> list[AgentBackup]: ...
    async def async_get_backup(self, backup_id: str, **kwargs: Any) -> AgentBackup: ...
    def get_backup_path(self, backup_id: str) -> Path: ...
    def get_new_backup_path(self, backup: AgentBackup) -> Path: ...
    async def async_delete_backup(self, backup_id: str, **kwargs: Any) -> None: ...
