from . import BangOlufsenConfigEntry as BangOlufsenConfigEntry
from .const import BANG_OLUFSEN_REPEAT_FROM_HA as BANG_OLUFSEN_REPEAT_FROM_HA, BANG_OLUFSEN_REPEAT_TO_HA as BANG_OLUFSEN_REPEAT_TO_HA, BANG_OLUFSEN_STATES as BANG_OLUFSEN_STATES, BEOLINK_JOIN_SOURCES as BEOLINK_JOIN_SOURCES, BEOLINK_JOIN_SOURCES_TO_UPPER as BEOLINK_JOIN_SOURCES_TO_UPPER, BangOlufsenMediaType as BangOlufsenMediaType, BangOlufsenSource as BangOlufsenSource, CONF_BEOLINK_JID as CONF_BEOLINK_JID, CONNECTION_STATUS as CONNECTION_STATUS, DOMAIN as DOMAIN, FALLBACK_SOURCES as FALLBACK_SOURCES, VALID_MEDIA_TYPES as VALID_MEDIA_TYPES, WebsocketNotification as WebsocketNotification
from .entity import BangOlufsenEntity as BangOlufsenEntity
from .util import get_serial_number_from_jid as get_serial_number_from_jid
from _typeshed import Incomplete
from collections.abc import Callable as Callable
from homeassistant.components import media_source as media_source
from homeassistant.components.media_player import ATTR_MEDIA_EXTRA as ATTR_MEDIA_EXTRA, BrowseMedia as BrowseMedia, MediaPlayerDeviceClass as MediaPlayerDeviceClass, MediaPlayerEntity as MediaPlayerEntity, MediaPlayerEntityFeature as MediaPlayerEntityFeature, MediaPlayerState as MediaPlayerState, MediaType as MediaType, RepeatMode as RepeatMode, async_process_play_media_url as async_process_play_media_url
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import CONF_MODEL as CONF_MODEL, Platform as Platform
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError, ServiceValidationError as ServiceValidationError
from homeassistant.helpers.device_registry import DeviceInfo as DeviceInfo
from homeassistant.helpers.dispatcher import async_dispatcher_connect as async_dispatcher_connect
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback, async_get_current_platform as async_get_current_platform
from homeassistant.util.dt import utcnow as utcnow
from mozart_api.models import Art, BeolinkLeader as BeolinkLeader, ListeningModeProps as ListeningModeProps, ListeningModeRef as ListeningModeRef, PlaybackContentMetadata as PlaybackContentMetadata, PlaybackError as PlaybackError, PlaybackProgress, RenderingState as RenderingState, SoftwareUpdateStatus, Source, VolumeState as VolumeState
from mozart_api.mozart_client import MozartClient as MozartClient
from typing import Any

PARALLEL_UPDATES: int
SCAN_INTERVAL: Incomplete
_LOGGER: Incomplete
BANG_OLUFSEN_FEATURES: Incomplete

async def async_setup_entry(hass: HomeAssistant, config_entry: BangOlufsenConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...

class BangOlufsenMediaPlayer(BangOlufsenEntity, MediaPlayerEntity):
    _attr_name: Incomplete
    _attr_device_class: Incomplete
    _beolink_jid: str
    _model: str
    _attr_device_info: Incomplete
    _attr_unique_id: Incomplete
    _attr_should_poll: bool
    _audio_sources: dict[str, str]
    _media_image: Art
    _software_status: SoftwareUpdateStatus
    _sources: dict[str, str]
    _state: str
    _video_sources: dict[str, str]
    _sound_modes: dict[str, int]
    _beolink_sources: dict[str, bool]
    _remote_leader: BeolinkLeader | None
    _beolink_attributes: dict[str, dict[str, dict[str, str]]]
    def __init__(self, entry: ConfigEntry, client: MozartClient) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    _volume: Incomplete
    _playback_metadata: Incomplete
    _playback_progress: Incomplete
    _source_change: Incomplete
    _playback_state: Incomplete
    _attr_media_position_updated_at: Incomplete
    async def _initialize(self) -> None: ...
    _attr_repeat: Incomplete
    _attr_shuffle: Incomplete
    async def async_update(self) -> None: ...
    _attr_source_list: Incomplete
    async def _async_update_sources(self, _: Source | None = None) -> None: ...
    async def _async_update_playback_metadata_and_beolink(self, data: PlaybackContentMetadata) -> None: ...
    @callback
    def _async_update_playback_error(self, data: PlaybackError) -> None: ...
    @callback
    def _async_update_playback_progress(self, data: PlaybackProgress) -> None: ...
    @callback
    def _async_update_playback_state(self, data: RenderingState) -> None: ...
    @callback
    def _async_update_source_change(self, data: Source) -> None: ...
    @callback
    def _async_update_volume(self, data: VolumeState) -> None: ...
    async def _async_update_name_and_beolink(self) -> None: ...
    _attr_group_members: Incomplete
    async def _async_update_beolink(self) -> None: ...
    def _get_entity_id_from_jid(self, jid: str) -> str | None: ...
    def _get_beolink_jid(self, entity_id: str) -> str: ...
    _attr_sound_mode: Incomplete
    _attr_sound_mode_list: Incomplete
    async def _async_update_sound_modes(self, active_sound_mode: ListeningModeProps | ListeningModeRef | None = None) -> None: ...
    @property
    def supported_features(self) -> MediaPlayerEntityFeature: ...
    @property
    def state(self) -> MediaPlayerState: ...
    @property
    def volume_level(self) -> float | None: ...
    @property
    def is_volume_muted(self) -> bool | None: ...
    @property
    def media_content_type(self) -> str: ...
    @property
    def media_duration(self) -> int | None: ...
    @property
    def media_position(self) -> int | None: ...
    @property
    def media_image_url(self) -> str | None: ...
    @property
    def media_image_remotely_accessible(self) -> bool: ...
    @property
    def media_title(self) -> str | None: ...
    @property
    def media_album_name(self) -> str | None: ...
    @property
    def media_album_artist(self) -> str | None: ...
    @property
    def media_track(self) -> int | None: ...
    @property
    def media_channel(self) -> str | None: ...
    @property
    def source(self) -> str | None: ...
    @property
    def extra_state_attributes(self) -> dict[str, Any] | None: ...
    async def async_turn_off(self) -> None: ...
    async def async_set_volume_level(self, volume: float) -> None: ...
    async def async_mute_volume(self, mute: bool) -> None: ...
    async def async_media_play_pause(self) -> None: ...
    async def async_media_pause(self) -> None: ...
    async def async_media_play(self) -> None: ...
    async def async_media_stop(self) -> None: ...
    async def async_media_next_track(self) -> None: ...
    async def async_media_seek(self, position: float) -> None: ...
    async def async_media_previous_track(self) -> None: ...
    async def async_clear_playlist(self) -> None: ...
    async def async_set_repeat(self, repeat: RepeatMode) -> None: ...
    async def async_set_shuffle(self, shuffle: bool) -> None: ...
    async def async_select_source(self, source: str) -> None: ...
    async def async_select_sound_mode(self, sound_mode: str) -> None: ...
    async def async_play_media(self, media_type: MediaType | str, media_id: str, announce: bool | None = None, **kwargs: Any) -> None: ...
    async def async_browse_media(self, media_content_type: MediaType | str | None = None, media_content_id: str | None = None) -> BrowseMedia: ...
    async def async_join_players(self, group_members: list[str]) -> None: ...
    async def async_unjoin_player(self) -> None: ...
    async def async_beolink_join(self, beolink_jid: str | None = None, source_id: str | None = None) -> None: ...
    async def async_beolink_expand(self, beolink_jids: list[str] | None = None, all_discovered: bool = False) -> None: ...
    async def async_beolink_unexpand(self, beolink_jids: list[str]) -> None: ...
    async def async_beolink_leave(self) -> None: ...
    async def async_beolink_allstandby(self) -> None: ...
