from habluetooth import DiscoveredDeviceAdvertisementData as DiscoveredDeviceAdvertisementData, DiscoveredDeviceAdvertisementDataDict as DiscoveredDeviceAdvertisementDataDict, DiscoveryStorageType as DiscoveryStorageType
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.storage import Store as Store

REMOTE_SCANNER_STORAGE_VERSION: int
REMOTE_SCANNER_STORAGE_KEY: str
SCANNER_SAVE_DELAY: int

class BluetoothStorage:
    _store: Store[DiscoveryStorageType]
    _data: DiscoveryStorageType
    def __init__(self, hass: HomeAssistant) -> None: ...
    async def async_setup(self) -> None: ...
    def scanners(self) -> list[str]: ...
    @callback
    def async_remove_advertisement_history(self, scanner: str) -> None: ...
    @callback
    def async_get_advertisement_history(self, scanner: str) -> DiscoveredDeviceAdvertisementData | None: ...
    @callback
    def async_get_advertisement_history_as_dict(self, scanner: str) -> DiscoveredDeviceAdvertisementDataDict | None: ...
    @callback
    def _async_get_data(self) -> DiscoveryStorageType: ...
    @callback
    def async_set_advertisement_history(self, scanner: str, data: DiscoveredDeviceAdvertisementData) -> None: ...
