from .const import CONF_BROWSE_UNFILTERED as CONF_BROWSE_UNFILTERED, CONF_CALLBACK_URL_OVERRIDE as CONF_CALLBACK_URL_OVERRIDE, CONF_LISTEN_PORT as CONF_LISTEN_PORT, CONF_POLL_AVAILABILITY as CONF_POLL_AVAILABILITY, DEFAULT_NAME as DEFAULT_NAME, DOMAIN as DOMAIN
from .data import get_domain_data as get_domain_data
from _typeshed import Incomplete
from collections.abc import Callable as Callable, Mapping
from homeassistant.components import ssdp as ssdp
from homeassistant.config_entries import ConfigEntry as ConfigEntry, ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, OptionsFlow as OptionsFlow
from homeassistant.const import CONF_DEVICE_ID as CONF_DEVICE_ID, CONF_HOST as CONF_HOST, CONF_MAC as CONF_MAC, CONF_TYPE as CONF_TYPE, CONF_URL as CONF_URL
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import IntegrationError as IntegrationError
from homeassistant.helpers.service_info.ssdp import ATTR_UPNP_DEVICE_TYPE as ATTR_UPNP_DEVICE_TYPE, ATTR_UPNP_FRIENDLY_NAME as ATTR_UPNP_FRIENDLY_NAME, ATTR_UPNP_MANUFACTURER as ATTR_UPNP_MANUFACTURER, ATTR_UPNP_MODEL_NAME as ATTR_UPNP_MODEL_NAME, ATTR_UPNP_SERVICE_LIST as ATTR_UPNP_SERVICE_LIST, SsdpServiceInfo as SsdpServiceInfo
from homeassistant.helpers.typing import VolDictType as VolDictType
from typing import Any

LOGGER: Incomplete
type FlowInput = Mapping[str, Any] | None

class ConnectError(IntegrationError): ...

class DlnaDmrFlowHandler(ConfigFlow, domain=DOMAIN):
    VERSION: int
    _discoveries: dict[str, SsdpServiceInfo]
    _location: str | None
    _udn: str | None
    _device_type: str | None
    _name: str | None
    _mac: str | None
    _options: dict[str, Any]
    def __init__(self) -> None: ...
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: ConfigEntry) -> OptionsFlow: ...
    async def async_step_user(self, user_input: FlowInput = None) -> ConfigFlowResult: ...
    async def async_step_manual(self, user_input: FlowInput = None) -> ConfigFlowResult: ...
    async def async_step_ssdp(self, discovery_info: SsdpServiceInfo) -> ConfigFlowResult: ...
    async def async_step_ignore(self, user_input: Mapping[str, Any]) -> ConfigFlowResult: ...
    async def async_step_confirm(self, user_input: FlowInput = None) -> ConfigFlowResult: ...
    async def _async_connect(self) -> None: ...
    def _create_entry(self) -> ConfigFlowResult: ...
    async def _async_set_info_from_discovery(self, discovery_info: SsdpServiceInfo, abort_if_configured: bool = True) -> None: ...
    async def _async_get_discoveries(self) -> list[SsdpServiceInfo]: ...

class DlnaDmrOptionsFlowHandler(OptionsFlow):
    async def async_step_init(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...

def _is_ignored_device(discovery_info: SsdpServiceInfo) -> bool: ...
def _is_dmr_device(discovery_info: SsdpServiceInfo) -> bool: ...
async def _async_get_mac_address(hass: HomeAssistant, host: str) -> str | None: ...
