from .bluetooth import async_connect_scanner as async_connect_scanner
from .const import CONF_ALLOW_SERVICE_CALLS as CONF_ALLOW_SERVICE_CALLS, CONF_BLUETOOTH_MAC_ADDRESS as CONF_BLUETOOTH_MAC_ADDRESS, CONF_DEVICE_NAME as CONF_DEVICE_NAME, CONF_NOISE_PSK as CONF_NOISE_PSK, CONF_SUBSCRIBE_LOGS as CONF_SUBSCRIBE_LOGS, DEFAULT_ALLOW_SERVICE_CALLS as DEFAULT_ALLOW_SERVICE_CALLS, DEFAULT_URL as DEFAULT_URL, DOMAIN as DOMAIN, PROJECT_URLS as PROJECT_URLS, STABLE_BLE_VERSION as STABLE_BLE_VERSION, STABLE_BLE_VERSION_STR as STABLE_BLE_VERSION_STR
from .dashboard import async_get_dashboard as async_get_dashboard
from .domain_data import DomainData as DomainData
from .encryption_key_storage import async_get_encryption_key_storage as async_get_encryption_key_storage
from .entry_data import ESPHomeConfigEntry as ESPHomeConfigEntry, RuntimeEntryData as RuntimeEntryData
from _typeshed import Incomplete
from aioesphomeapi import APIClient as APIClient, APIVersion as APIVersion, DeviceInfo as EsphomeDeviceInfo, HomeassistantServiceCall as HomeassistantServiceCall, LogLevel, ReconnectLogic, UserService as UserService
from aioesphomeapi.api_pb2 import SubscribeLogsResponse as SubscribeLogsResponse
from homeassistant.components import bluetooth as bluetooth, tag as tag, zeroconf as zeroconf
from homeassistant.const import ATTR_DEVICE_ID as ATTR_DEVICE_ID, CONF_MODE as CONF_MODE, EVENT_HOMEASSISTANT_CLOSE as EVENT_HOMEASSISTANT_CLOSE, EVENT_LOGGING_CHANGED as EVENT_LOGGING_CHANGED, Platform as Platform
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, Event as Event, EventStateChangedData as EventStateChangedData, HomeAssistant as HomeAssistant, ServiceCall as ServiceCall, State as State, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError, TemplateError as TemplateError
from homeassistant.helpers import template as template
from homeassistant.helpers.device_registry import format_mac as format_mac
from homeassistant.helpers.event import async_track_state_change_event as async_track_state_change_event
from homeassistant.helpers.issue_registry import IssueSeverity as IssueSeverity, async_create_issue as async_create_issue, async_delete_issue as async_delete_issue
from homeassistant.helpers.service import async_set_service_schema as async_set_service_schema
from homeassistant.helpers.template import Template as Template
from typing import Any, NamedTuple

DEVICE_CONFLICT_ISSUE_FORMAT: str
_LOGGER: Incomplete
LOG_LEVEL_TO_LOGGER: Incomplete
LOGGER_TO_LOG_LEVEL: Incomplete

@callback
def _async_check_firmware_version(hass: HomeAssistant, device_info: EsphomeDeviceInfo, api_version: APIVersion) -> None: ...
@callback
def _async_check_using_api_password(hass: HomeAssistant, device_info: EsphomeDeviceInfo, has_password: bool) -> None: ...

class ESPHomeManager:
    __slots__: Incomplete
    hass: Incomplete
    host: Incomplete
    password: Incomplete
    entry: Incomplete
    cli: Incomplete
    device_id: str | None
    domain_data: Incomplete
    reconnect_logic: ReconnectLogic | None
    zeroconf_instance: Incomplete
    entry_data: Incomplete
    _cancel_subscribe_logs: CALLBACK_TYPE | None
    _log_level: Incomplete
    def __init__(self, hass: HomeAssistant, entry: ESPHomeConfigEntry, host: str, password: str | None, cli: APIClient, zeroconf_instance: zeroconf.HaZeroconf, domain_data: DomainData) -> None: ...
    async def on_stop(self, event: Event) -> None: ...
    @property
    def services_issue(self) -> str: ...
    @callback
    def async_on_service_call(self, service: HomeassistantServiceCall) -> None: ...
    @callback
    def _send_home_assistant_state(self, entity_id: str, attribute: str | None, state: State | None) -> None: ...
    @callback
    def _send_home_assistant_state_event(self, attribute: str | None, event: Event[EventStateChangedData]) -> None: ...
    @callback
    def async_on_state_subscription(self, entity_id: str, attribute: str | None = None) -> None: ...
    @callback
    def async_on_state_request(self, entity_id: str, attribute: str | None = None) -> None: ...
    async def on_connect(self) -> None: ...
    def _async_on_log(self, msg: SubscribeLogsResponse) -> None: ...
    @callback
    def _async_get_equivalent_log_level(self) -> LogLevel: ...
    @callback
    def _async_subscribe_logs(self, log_level: LogLevel) -> None: ...
    async def _on_connect(self) -> None: ...
    async def on_disconnect(self, expected_disconnect: bool) -> None: ...
    async def on_connect_error(self, err: Exception) -> None: ...
    async def _handle_dynamic_encryption_key(self, device_info: EsphomeDeviceInfo) -> None: ...
    @callback
    def _async_handle_logging_changed(self, _event: Event) -> None: ...
    @callback
    def _async_cleanup(self) -> None: ...
    async def async_start(self) -> None: ...

@callback
def _async_setup_device_registry(hass: HomeAssistant, entry: ESPHomeConfigEntry, entry_data: RuntimeEntryData) -> str: ...

class ServiceMetadata(NamedTuple):
    validator: Any
    example: str
    selector: dict[str, Any]
    description: str | None = ...

ARG_TYPE_METADATA: Incomplete

@callback
def execute_service(entry_data: RuntimeEntryData, service: UserService, call: ServiceCall) -> None: ...
def build_service_name(device_info: EsphomeDeviceInfo, service: UserService) -> str: ...
@callback
def _async_register_service(hass: HomeAssistant, entry_data: RuntimeEntryData, device_info: EsphomeDeviceInfo, service: UserService) -> None: ...
@callback
def _setup_services(hass: HomeAssistant, entry_data: RuntimeEntryData, services: list[UserService]) -> None: ...
async def cleanup_instance(entry: ESPHomeConfigEntry) -> RuntimeEntryData: ...
async def async_replace_device(hass: HomeAssistant, entry_id: str, old_mac: str, new_mac: str) -> None: ...
