from . import async_wifi_bulb_for_host as async_wifi_bulb_for_host
from .const import CONF_CUSTOM_EFFECT_COLORS as CONF_CUSTOM_EFFECT_COLORS, CONF_CUSTOM_EFFECT_SPEED_PCT as CONF_CUSTOM_EFFECT_SPEED_PCT, CONF_CUSTOM_EFFECT_TRANSITION as CONF_CUSTOM_EFFECT_TRANSITION, DEFAULT_EFFECT_SPEED as DEFAULT_EFFECT_SPEED, DISCOVER_SCAN_TIMEOUT as DISCOVER_SCAN_TIMEOUT, DOMAIN as DOMAIN, FLUX_LED_DISCOVERY_SIGNAL as FLUX_LED_DISCOVERY_SIGNAL, FLUX_LED_EXCEPTIONS as FLUX_LED_EXCEPTIONS, TRANSITION_GRADUAL as TRANSITION_GRADUAL, TRANSITION_JUMP as TRANSITION_JUMP, TRANSITION_STROBE as TRANSITION_STROBE
from .coordinator import FluxLedConfigEntry as FluxLedConfigEntry
from .discovery import async_discover_device as async_discover_device, async_discover_devices as async_discover_devices, async_name_from_discovery as async_name_from_discovery, async_populate_data_from_discovery as async_populate_data_from_discovery, async_update_entry_from_discovery as async_update_entry_from_discovery
from .util import format_as_flux_mac as format_as_flux_mac, mac_matches_by_one as mac_matches_by_one
from flux_led.scanner import FluxLEDDiscovery
from homeassistant.config_entries import ConfigEntryState as ConfigEntryState, ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, OptionsFlow as OptionsFlow, SOURCE_IGNORE as SOURCE_IGNORE
from homeassistant.const import CONF_DEVICE as CONF_DEVICE, CONF_HOST as CONF_HOST
from homeassistant.core import callback as callback
from homeassistant.data_entry_flow import AbortFlow as AbortFlow
from homeassistant.helpers.dispatcher import async_dispatcher_send as async_dispatcher_send
from homeassistant.helpers.service_info.dhcp import DhcpServiceInfo as DhcpServiceInfo
from homeassistant.helpers.typing import DiscoveryInfoType as DiscoveryInfoType
from typing import Any, Self

class FluxLedConfigFlow(ConfigFlow, domain=DOMAIN):
    VERSION: int
    host: str | None
    _discovered_devices: dict[str, FluxLEDDiscovery]
    _discovered_device: FluxLEDDiscovery | None
    _allow_update_mac: bool
    def __init__(self) -> None: ...
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: FluxLedConfigEntry) -> FluxLedOptionsFlow: ...
    async def async_step_dhcp(self, discovery_info: DhcpServiceInfo) -> ConfigFlowResult: ...
    async def async_step_integration_discovery(self, discovery_info: DiscoveryInfoType) -> ConfigFlowResult: ...
    async def _async_set_discovered_mac(self, device: FluxLEDDiscovery, allow_update_mac: bool) -> None: ...
    async def _async_handle_discovery(self) -> ConfigFlowResult: ...
    def is_matching(self, other_flow: Self) -> bool: ...
    async def async_step_discovery_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    @callback
    def _async_create_entry_from_device(self, device: FluxLEDDiscovery) -> ConfigFlowResult: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_pick_device(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_try_connect(self, host: str, discovery: FluxLEDDiscovery | None) -> FluxLEDDiscovery: ...

class FluxLedOptionsFlow(OptionsFlow):
    async def async_step_init(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
