from .const import CONF_OLD_DISCOVERY as CONF_OLD_DISCOVERY, DEFAULT_CONF_FEATURE_DEVICE_TRACKING as DEFAULT_CONF_FEATURE_DEVICE_TRACKING, DEFAULT_CONF_OLD_DISCOVERY as DEFAULT_CONF_OLD_DISCOVERY, DEFAULT_HOST as DEFAULT_HOST, DEFAULT_SSL as DEFAULT_SSL, DEFAULT_USERNAME as DEFAULT_USERNAME, DOMAIN as DOMAIN, FRITZ_EXCEPTIONS as FRITZ_EXCEPTIONS, MeshRoles as MeshRoles
from .helpers import _ha_is_stopping as _ha_is_stopping
from .models import ConnectionInfo as ConnectionInfo, Device as Device, FritzDevice as FritzDevice, HostAttributes as HostAttributes, HostInfo as HostInfo, Interface as Interface
from _typeshed import Incomplete
from collections.abc import Callable as Callable, Mapping
from dataclasses import dataclass, field
from datetime import datetime
from fritzconnection import FritzConnection
from fritzconnection.lib.fritzhosts import FritzHosts
from fritzconnection.lib.fritzstatus import FritzStatus
from fritzconnection.lib.fritzwlan import FritzGuestWLAN
from homeassistant.components.device_tracker import CONF_CONSIDER_HOME as CONF_CONSIDER_HOME, DEFAULT_CONSIDER_HOME as DEFAULT_CONSIDER_HOME
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.device_registry import CONNECTION_NETWORK_MAC as CONNECTION_NETWORK_MAC
from homeassistant.helpers.dispatcher import async_dispatcher_send as async_dispatcher_send
from homeassistant.helpers.typing import StateType as StateType
from homeassistant.helpers.update_coordinator import DataUpdateCoordinator as DataUpdateCoordinator, UpdateFailed as UpdateFailed
from homeassistant.util.hass_dict import HassKey as HassKey
from typing import Any, TypedDict

_LOGGER: Incomplete
FRITZ_DATA_KEY: HassKey[FritzData]
type FritzConfigEntry = ConfigEntry[AvmWrapper]

@dataclass
class FritzData:
    tracked: dict[str, set[str]] = field(default_factory=dict)
    profile_switches: dict[str, set[str]] = field(default_factory=dict)
    wol_buttons: dict[str, set[str]] = field(default_factory=dict)

class ClassSetupMissing(Exception):
    def __init__(self) -> None: ...

class UpdateCoordinatorDataType(TypedDict):
    call_deflections: dict[int, dict]
    entity_states: dict[str, StateType | bool]

class FritzBoxTools(DataUpdateCoordinator[UpdateCoordinatorDataType]):
    config_entry: FritzConfigEntry
    _devices: dict[str, FritzDevice]
    _options: Mapping[str, Any] | None
    _unique_id: str | None
    connection: FritzConnection
    fritz_guest_wifi: FritzGuestWLAN
    fritz_hosts: FritzHosts
    fritz_status: FritzStatus
    host: Incomplete
    mesh_role: Incomplete
    mesh_wifi_uplink: bool
    device_conn_type: str | None
    device_is_router: bool
    password: Incomplete
    port: Incomplete
    username: Incomplete
    use_tls: Incomplete
    device_discovery_enabled: Incomplete
    has_call_deflections: bool
    _model: str | None
    _current_firmware: str | None
    _latest_firmware: str | None
    _update_available: bool
    _release_url: str | None
    _entity_update_functions: dict[str, Callable[[FritzStatus, StateType], Any]]
    def __init__(self, hass: HomeAssistant, config_entry: FritzConfigEntry, password: str, port: int, username: str = ..., host: str = ..., use_tls: bool = ..., device_discovery_enabled: bool = ...) -> None: ...
    async def async_setup(self, options: Mapping[str, Any] | None = None) -> None: ...
    def setup(self) -> None: ...
    async def async_register_entity_updates(self, key: str, update_fn: Callable[[FritzStatus, StateType], Any]) -> Callable[[], None]: ...
    def _entity_states_update(self) -> dict: ...
    async def _async_update_data(self) -> UpdateCoordinatorDataType: ...
    @property
    def unique_id(self) -> str: ...
    @property
    def model(self) -> str: ...
    @property
    def current_firmware(self) -> str: ...
    @property
    def latest_firmware(self) -> str | None: ...
    @property
    def update_available(self) -> bool: ...
    @property
    def release_url(self) -> str | None: ...
    @property
    def mac(self) -> str: ...
    @property
    def devices(self) -> dict[str, FritzDevice]: ...
    @property
    def signal_device_new(self) -> str: ...
    @property
    def signal_device_update(self) -> str: ...
    async def _async_get_wan_access(self, ip_address: str) -> bool | None: ...
    async def _async_update_hosts_info(self) -> dict[str, Device]: ...
    def _update_device_info(self) -> tuple[bool, str | None, str | None]: ...
    async def _async_update_device_info(self) -> tuple[bool, str | None, str | None]: ...
    async def async_update_call_deflections(self) -> dict[int, dict[str, Any]]: ...
    def manage_device_info(self, dev_info: Device, dev_mac: str, consider_home: float) -> bool: ...
    async def async_send_signal_device_update(self, new_device: bool) -> None: ...
    async def async_update_device_info(self, now: datetime | None = None) -> None: ...
    async def async_scan_devices(self, now: datetime | None = None) -> None: ...
    async def async_trigger_firmware_update(self) -> bool: ...
    async def async_trigger_reboot(self) -> None: ...
    async def async_trigger_reconnect(self) -> None: ...
    async def async_trigger_set_guest_password(self, password: str | None, length: int) -> None: ...
    async def async_trigger_cleanup(self) -> None: ...

class AvmWrapper(FritzBoxTools):
    async def _async_service_call(self, service_name: str, service_suffix: str, action_name: str, **kwargs: Any) -> dict: ...
    async def async_get_upnp_configuration(self) -> dict[str, Any]: ...
    async def async_get_wan_link_properties(self) -> dict[str, Any]: ...
    async def async_ipv6_active(self) -> bool: ...
    async def async_get_connection_info(self) -> ConnectionInfo: ...
    async def async_get_num_port_mapping(self, con_type: str) -> dict[str, Any]: ...
    async def async_get_port_mapping(self, con_type: str, index: int) -> dict[str, Any]: ...
    async def async_get_wlan_configuration(self, index: int) -> dict[str, Any]: ...
    async def async_set_wlan_configuration(self, index: int, turn_on: bool) -> dict[str, Any]: ...
    async def async_set_deflection_enable(self, index: int, turn_on: bool) -> dict[str, Any]: ...
    async def async_add_port_mapping(self, con_type: str, port_mapping: Any) -> dict[str, Any]: ...
    async def async_set_allow_wan_access(self, ip_address: str, turn_on: bool) -> dict[str, Any]: ...
    async def async_wake_on_lan(self, mac_address: str) -> dict[str, Any]: ...
