from .const import DSL_CONNECTION as DSL_CONNECTION, UPTIME_DEVIATION as UPTIME_DEVIATION
from .coordinator import FritzConfigEntry as FritzConfigEntry
from .entity import FritzBoxBaseCoordinatorEntity as FritzBoxBaseCoordinatorEntity, FritzEntityDescription as FritzEntityDescription
from .models import ConnectionInfo as ConnectionInfo
from _typeshed import Incomplete
from collections.abc import Callable as Callable
from dataclasses import dataclass
from datetime import datetime
from fritzconnection.lib.fritzstatus import FritzStatus as FritzStatus
from homeassistant.components.sensor import SensorDeviceClass as SensorDeviceClass, SensorEntity as SensorEntity, SensorEntityDescription as SensorEntityDescription, SensorStateClass as SensorStateClass
from homeassistant.const import EntityCategory as EntityCategory, SIGNAL_STRENGTH_DECIBELS as SIGNAL_STRENGTH_DECIBELS, UnitOfDataRate as UnitOfDataRate, UnitOfInformation as UnitOfInformation
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from homeassistant.helpers.typing import StateType as StateType
from homeassistant.util.dt import utcnow as utcnow

_LOGGER: Incomplete
PARALLEL_UPDATES: int

def _uptime_calculation(seconds_uptime: float, last_value: datetime | None) -> datetime: ...
def _retrieve_device_uptime_state(status: FritzStatus, last_value: datetime) -> datetime: ...
def _retrieve_connection_uptime_state(status: FritzStatus, last_value: datetime | None) -> datetime: ...
def _retrieve_external_ip_state(status: FritzStatus, last_value: str) -> str: ...
def _retrieve_external_ipv6_state(status: FritzStatus, last_value: str) -> str: ...
def _retrieve_kb_s_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_kb_s_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_max_kb_s_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_max_kb_s_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_gb_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_gb_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_kb_s_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_kb_s_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_noise_margin_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_noise_margin_received_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_attenuation_sent_state(status: FritzStatus, last_value: str) -> float: ...
def _retrieve_link_attenuation_received_state(status: FritzStatus, last_value: str) -> float: ...

@dataclass(frozen=True, kw_only=True)
class FritzSensorEntityDescription(SensorEntityDescription, FritzEntityDescription):
    is_suitable: Callable[[ConnectionInfo], bool] = ...

SENSOR_TYPES: tuple[FritzSensorEntityDescription, ...]

async def async_setup_entry(hass: HomeAssistant, entry: FritzConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...

class FritzBoxSensor(FritzBoxBaseCoordinatorEntity, SensorEntity):
    entity_description: FritzSensorEntityDescription
    @property
    def native_value(self) -> StateType: ...
