from .const import DOMAIN as DOMAIN, ENTRY_TITLE as ENTRY_TITLE
from .coordinator import HeosConfigEntry as HeosConfigEntry
from _typeshed import Incomplete
from collections.abc import Mapping
from homeassistant.config_entries import ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, OptionsFlow as OptionsFlow, SOURCE_IGNORE as SOURCE_IGNORE
from homeassistant.const import CONF_HOST as CONF_HOST, CONF_PASSWORD as CONF_PASSWORD, CONF_USERNAME as CONF_USERNAME
from homeassistant.core import callback as callback
from homeassistant.helpers import selector as selector
from homeassistant.helpers.service_info.ssdp import SsdpServiceInfo as SsdpServiceInfo
from homeassistant.helpers.service_info.zeroconf import ZeroconfServiceInfo as ZeroconfServiceInfo
from typing import Any

_LOGGER: Incomplete
AUTH_SCHEMA: Incomplete

async def _validate_host(host: str, errors: dict[str, str]) -> bool: ...
async def _validate_auth(user_input: dict[str, str], entry: HeosConfigEntry, errors: dict[str, str]) -> bool: ...
def _get_current_hosts(entry: HeosConfigEntry) -> set[str]: ...

class HeosFlowHandler(ConfigFlow, domain=DOMAIN):
    VERSION: int
    _discovered_host: str | None
    def __init__(self) -> None: ...
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: HeosConfigEntry) -> OptionsFlow: ...
    async def async_step_ssdp(self, discovery_info: SsdpServiceInfo) -> ConfigFlowResult: ...
    async def async_step_zeroconf(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    async def async_step_confirm_discovery(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_reconfigure(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_reauth(self, entry_data: Mapping[str, Any]) -> ConfigFlowResult: ...
    async def async_step_reauth_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_handle_discovered(self, hostname: str) -> ConfigFlowResult: ...

class HeosOptionsFlowHandler(OptionsFlow):
    async def async_step_init(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
