from . import services as services
from .const import DOMAIN as DOMAIN
from .coordinator import HeosConfigEntry as HeosConfigEntry, HeosCoordinator as HeosCoordinator
from _typeshed import Incomplete
from collections.abc import Awaitable, Callable, Coroutine
from datetime import datetime
from homeassistant.components import media_source as media_source
from homeassistant.components.media_player import ATTR_MEDIA_ENQUEUE as ATTR_MEDIA_ENQUEUE, BrowseError as BrowseError, BrowseMedia as BrowseMedia, MediaClass as MediaClass, MediaPlayerEnqueue as MediaPlayerEnqueue, MediaPlayerEntity as MediaPlayerEntity, MediaPlayerEntityFeature as MediaPlayerEntityFeature, MediaPlayerState as MediaPlayerState, MediaType as MediaType, RepeatMode as RepeatMode, async_process_play_media_url as async_process_play_media_url
from homeassistant.components.media_source import BrowseMediaSource as BrowseMediaSource
from homeassistant.const import Platform as Platform
from homeassistant.core import HomeAssistant as HomeAssistant, ServiceResponse as ServiceResponse, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError, ServiceValidationError as ServiceValidationError
from homeassistant.helpers.device_registry import DeviceInfo as DeviceInfo
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from homeassistant.helpers.update_coordinator import CoordinatorEntity as CoordinatorEntity
from homeassistant.util.dt import utcnow as utcnow
from pyheos import HeosPlayer as HeosPlayer, MediaItem, MediaMusicSource
from typing import Any, Final

PARALLEL_UPDATES: int
BROWSE_ROOT: Final[str]
BASE_SUPPORTED_FEATURES: Incomplete
PLAY_STATE_TO_STATE: Incomplete
CONTROL_TO_SUPPORT: Incomplete
HA_HEOS_ENQUEUE_MAP: Incomplete
HEOS_HA_REPEAT_TYPE_MAP: Incomplete
HA_HEOS_REPEAT_TYPE_MAP: Incomplete
HEOS_MEDIA_TYPE_TO_MEDIA_CLASS: Incomplete
_LOGGER: Incomplete

async def async_setup_entry(hass: HomeAssistant, entry: HeosConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...
type _FuncType[**_P, _R] = Callable[_P, Awaitable[_R]]
type _ReturnFuncType[**_P, _R] = Callable[_P, Coroutine[Any, Any, _R]]
def catch_action_error[**_P, _R](action: str) -> Callable[[_FuncType[_P, _R]], _ReturnFuncType[_P, _R]]: ...

class HeosMediaPlayer(CoordinatorEntity[HeosCoordinator], MediaPlayerEntity):
    _attr_media_content_type: Incomplete
    _attr_supported_features = BASE_SUPPORTED_FEATURES
    _attr_media_image_remotely_accessible: bool
    _attr_has_entity_name: bool
    _attr_name: Incomplete
    _media_position_updated_at: datetime | None
    _player: HeosPlayer
    _attr_unique_id: Incomplete
    _attr_device_info: Incomplete
    def __init__(self, coordinator: HeosCoordinator, player: HeosPlayer) -> None: ...
    async def _player_update(self, event: str) -> None: ...
    @callback
    def _handle_coordinator_update(self) -> None: ...
    @callback
    def _get_group_members(self) -> list[str] | None: ...
    _attr_group_members: Incomplete
    _attr_source_list: Incomplete
    _attr_source: Incomplete
    _attr_repeat: Incomplete
    @callback
    def _update_attributes(self) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    async def async_get_queue(self) -> ServiceResponse: ...
    async def async_clear_playlist(self) -> None: ...
    async def async_media_pause(self) -> None: ...
    async def async_media_play(self) -> None: ...
    async def async_media_previous_track(self) -> None: ...
    async def async_media_next_track(self) -> None: ...
    async def async_media_stop(self) -> None: ...
    async def async_mute_volume(self, mute: bool) -> None: ...
    async def async_play_media(self, media_type: MediaType | str, media_id: str, **kwargs: Any) -> None: ...
    async def async_select_source(self, source: str) -> None: ...
    async def async_set_repeat(self, repeat: RepeatMode) -> None: ...
    async def async_set_shuffle(self, shuffle: bool) -> None: ...
    async def async_set_volume_level(self, volume: float) -> None: ...
    async def async_set_group_volume_level(self, volume_level: float) -> None: ...
    async def async_group_volume_down(self) -> None: ...
    async def async_group_volume_up(self) -> None: ...
    async def async_join_players(self, group_members: list[str]) -> None: ...
    async def async_unjoin_player(self) -> None: ...
    async def async_remove_from_queue(self, queue_ids: list[int]) -> None: ...
    async def async_move_queue_item(self, queue_ids: list[int], destination_position: int) -> None: ...
    @property
    def available(self) -> bool: ...
    @property
    def extra_state_attributes(self) -> dict[str, Any]: ...
    @property
    def is_volume_muted(self) -> bool: ...
    @property
    def media_album_name(self) -> str | None: ...
    @property
    def media_artist(self) -> str | None: ...
    @property
    def media_content_id(self) -> str | None: ...
    @property
    def media_duration(self) -> int | None: ...
    @property
    def media_position(self) -> int | None: ...
    @property
    def media_position_updated_at(self) -> datetime | None: ...
    @property
    def media_image_url(self) -> str | None: ...
    @property
    def media_title(self) -> str | None: ...
    @property
    def shuffle(self) -> bool: ...
    @property
    def state(self) -> MediaPlayerState: ...
    @property
    def volume_level(self) -> float: ...
    async def _async_browse_media_root(self) -> BrowseMedia: ...
    async def _async_browse_heos_media(self, media_content_id: str) -> BrowseMedia: ...
    async def _async_browse_media_source(self, media_content_id: str | None = None) -> BrowseMediaSource: ...
    async def async_browse_media(self, media_content_type: MediaType | str | None = None, media_content_id: str | None = None) -> BrowseMedia: ...

def _media_to_browse_media(media: MediaItem | MediaMusicSource) -> BrowseMedia: ...
