import asyncio
from . import create_hyperion_client as create_hyperion_client
from .const import CONF_AUTH_ID as CONF_AUTH_ID, CONF_CREATE_TOKEN as CONF_CREATE_TOKEN, CONF_EFFECT_HIDE_LIST as CONF_EFFECT_HIDE_LIST, CONF_EFFECT_SHOW_LIST as CONF_EFFECT_SHOW_LIST, CONF_PRIORITY as CONF_PRIORITY, DEFAULT_ORIGIN as DEFAULT_ORIGIN, DEFAULT_PRIORITY as DEFAULT_PRIORITY, DOMAIN as DOMAIN
from _typeshed import Incomplete
from collections.abc import Mapping
from homeassistant.config_entries import ConfigEntry as ConfigEntry, ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, OptionsFlowWithReload as OptionsFlowWithReload, SOURCE_REAUTH as SOURCE_REAUTH
from homeassistant.const import CONF_BASE as CONF_BASE, CONF_HOST as CONF_HOST, CONF_ID as CONF_ID, CONF_PORT as CONF_PORT, CONF_SOURCE as CONF_SOURCE, CONF_TOKEN as CONF_TOKEN
from homeassistant.core import callback as callback
from homeassistant.helpers.service_info.ssdp import ATTR_UPNP_SERIAL as ATTR_UPNP_SERIAL, SsdpServiceInfo as SsdpServiceInfo
from hyperion import client
from typing import Any

_LOGGER: Incomplete

class HyperionConfigFlow(ConfigFlow, domain=DOMAIN):
    VERSION: int
    unique_id: str
    _data: dict[str, Any]
    _request_token_task: asyncio.Task | None
    _auth_id: str | None
    _require_confirm: bool
    _port_ui: int
    def __init__(self) -> None: ...
    def _create_client(self, raw_connection: bool = False) -> client.HyperionClient: ...
    async def _advance_to_auth_step_if_necessary(self, hyperion_client: client.HyperionClient) -> ConfigFlowResult: ...
    async def async_step_reauth(self, entry_data: Mapping[str, Any]) -> ConfigFlowResult: ...
    async def async_step_ssdp(self, discovery_info: SsdpServiceInfo) -> ConfigFlowResult: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _cancel_request_token_task(self) -> None: ...
    async def _request_token_task_func(self, auth_id: str) -> None: ...
    def _get_hyperion_url(self) -> str: ...
    async def _can_login(self) -> bool | None: ...
    async def async_step_auth(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_create_token(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_create_token_external(self, auth_resp: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_create_token_success(self, _: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_create_token_fail(self, _: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: ConfigEntry) -> HyperionOptionsFlow: ...

class HyperionOptionsFlow(OptionsFlowWithReload):
    def _create_client(self) -> client.HyperionClient: ...
    async def async_step_init(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
