import asyncio
from . import ImapConfigEntry as ImapConfigEntry
from .const import CONF_CHARSET as CONF_CHARSET, CONF_CUSTOM_EVENT_DATA_TEMPLATE as CONF_CUSTOM_EVENT_DATA_TEMPLATE, CONF_EVENT_MESSAGE_DATA as CONF_EVENT_MESSAGE_DATA, CONF_FOLDER as CONF_FOLDER, CONF_MAX_MESSAGE_SIZE as CONF_MAX_MESSAGE_SIZE, CONF_SEARCH as CONF_SEARCH, CONF_SERVER as CONF_SERVER, CONF_SSL_CIPHER_LIST as CONF_SSL_CIPHER_LIST, DEFAULT_MAX_MESSAGE_SIZE as DEFAULT_MAX_MESSAGE_SIZE, DOMAIN as DOMAIN, MESSAGE_DATA_OPTIONS as MESSAGE_DATA_OPTIONS
from .errors import InvalidAuth as InvalidAuth, InvalidFolder as InvalidFolder
from _typeshed import Incomplete
from aioimaplib import IMAP4_SSL
from collections.abc import Mapping
from datetime import datetime, timedelta
from email.message import Message
from homeassistant.const import CONF_PASSWORD as CONF_PASSWORD, CONF_PORT as CONF_PORT, CONF_USERNAME as CONF_USERNAME, CONF_VERIFY_SSL as CONF_VERIFY_SSL, CONTENT_TYPE_TEXT_PLAIN as CONTENT_TYPE_TEXT_PLAIN
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.exceptions import ConfigEntryAuthFailed as ConfigEntryAuthFailed, ConfigEntryError as ConfigEntryError, TemplateError as TemplateError
from homeassistant.helpers.json import json_bytes as json_bytes
from homeassistant.helpers.template import Template as Template
from homeassistant.helpers.update_coordinator import DataUpdateCoordinator as DataUpdateCoordinator, UpdateFailed as UpdateFailed
from homeassistant.util.ssl import SSLCipherList as SSLCipherList, client_context as client_context, create_no_verify_ssl_context as create_no_verify_ssl_context
from typing import Any

_LOGGER: Incomplete
BACKOFF_TIME: int
EVENT_IMAP: str
MAX_ERRORS: int
MAX_EVENT_DATA_BYTES: int
DIAGNOSTICS_ATTRIBUTES: Incomplete

async def connect_to_server(data: Mapping[str, Any]) -> IMAP4_SSL: ...

class ImapMessage:
    email_message: Incomplete
    def __init__(self, raw_message: bytes) -> None: ...
    @staticmethod
    def _decode_payload(part: Message) -> str: ...
    @property
    def headers(self) -> dict[str, tuple[str, ...]]: ...
    @property
    def message_id(self) -> str | None: ...
    @property
    def date(self) -> datetime | None: ...
    @property
    def sender(self) -> str: ...
    @property
    def subject(self) -> str: ...
    @property
    def text(self) -> str: ...

class ImapDataUpdateCoordinator(DataUpdateCoordinator[int | None]):
    config_entry: ImapConfigEntry
    custom_event_template: Template | None
    imap_client: Incomplete
    auth_errors: int
    _last_message_uid: str | None
    _last_message_id: str | None
    _diagnostics_data: dict[str, Any]
    _event_data_keys: list[str]
    _max_event_size: int
    def __init__(self, hass: HomeAssistant, imap_client: IMAP4_SSL, entry: ImapConfigEntry, update_interval: timedelta | None) -> None: ...
    async def async_start(self) -> None: ...
    async def _async_reconnect_if_needed(self) -> None: ...
    async def _async_process_event(self, last_message_uid: str) -> None: ...
    async def _async_fetch_number_of_messages(self) -> int | None: ...
    async def _cleanup(self, log_error: bool = False) -> None: ...
    async def shutdown(self, *_: Any) -> None: ...
    def _update_diagnostics(self, data: dict[str, Any]) -> None: ...
    @property
    def diagnostics_data(self) -> dict[str, Any]: ...

class ImapPollingDataUpdateCoordinator(ImapDataUpdateCoordinator):
    def __init__(self, hass: HomeAssistant, imap_client: IMAP4_SSL, entry: ImapConfigEntry) -> None: ...
    auth_errors: int
    async def _async_update_data(self) -> int | None: ...

class ImapPushDataUpdateCoordinator(ImapDataUpdateCoordinator):
    _push_wait_task: asyncio.Task[None] | None
    number_of_messages: int | None
    def __init__(self, hass: HomeAssistant, imap_client: IMAP4_SSL, entry: ImapConfigEntry) -> None: ...
    async def _async_update_data(self) -> int | None: ...
    async def async_start(self) -> None: ...
    auth_errors: int
    async def _async_wait_push_loop(self) -> None: ...
    async def shutdown(self, *_: Any) -> None: ...
