from .const import BINARY_SENSOR_DEVICE_TYPES_ISY as BINARY_SENSOR_DEVICE_TYPES_ISY, BINARY_SENSOR_DEVICE_TYPES_ZWAVE as BINARY_SENSOR_DEVICE_TYPES_ZWAVE, SUBNODE_CLIMATE_COOL as SUBNODE_CLIMATE_COOL, SUBNODE_CLIMATE_HEAT as SUBNODE_CLIMATE_HEAT, SUBNODE_DUSK_DAWN as SUBNODE_DUSK_DAWN, SUBNODE_HEARTBEAT as SUBNODE_HEARTBEAT, SUBNODE_LOW_BATTERY as SUBNODE_LOW_BATTERY, SUBNODE_MOTION_DISABLED as SUBNODE_MOTION_DISABLED, SUBNODE_NEGATIVE as SUBNODE_NEGATIVE, SUBNODE_TAMPER as SUBNODE_TAMPER, TYPE_CATEGORY_CLIMATE as TYPE_CATEGORY_CLIMATE, TYPE_INSTEON_MOTION as TYPE_INSTEON_MOTION, _LOGGER as _LOGGER
from .entity import ISYNodeEntity as ISYNodeEntity, ISYProgramEntity as ISYProgramEntity
from .models import IsyConfigEntry as IsyConfigEntry
from _typeshed import Incomplete
from homeassistant.components.binary_sensor import BinarySensorDeviceClass as BinarySensorDeviceClass, BinarySensorEntity as BinarySensorEntity
from homeassistant.const import Platform as Platform, STATE_ON as STATE_ON
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.device_registry import DeviceInfo as DeviceInfo
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from homeassistant.helpers.event import async_call_later as async_call_later
from homeassistant.helpers.restore_state import RestoreEntity as RestoreEntity
from pyisy.helpers import NodeProperty as NodeProperty
from pyisy.nodes import Group as Group, Node
from typing import Any

DEVICE_PARENT_REQUIRED: Incomplete

async def async_setup_entry(hass: HomeAssistant, entry: IsyConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...
def _detect_device_type_and_class(node: Group | Node) -> tuple[BinarySensorDeviceClass | None, str | None]: ...

class ISYBinarySensorEntity(ISYNodeEntity, BinarySensorEntity):
    _attr_device_class: Incomplete
    def __init__(self, node: Node, force_device_class: BinarySensorDeviceClass | None = None, unknown_state: bool | None = None, device_info: DeviceInfo | None = None) -> None: ...
    @property
    def is_on(self) -> bool | None: ...

class ISYInsteonBinarySensorEntity(ISYBinarySensorEntity):
    _negative_node: Node | None
    _heartbeat_device: ISYBinarySensorHeartbeat | None
    _computed_state: Incomplete
    _status_was_unknown: bool
    def __init__(self, node: Node, force_device_class: BinarySensorDeviceClass | None = None, unknown_state: bool | None = None, device_info: DeviceInfo | None = None) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    def add_heartbeat_device(self, entity: ISYBinarySensorHeartbeat | None) -> None: ...
    def _async_heartbeat(self) -> None: ...
    def add_negative_node(self, child: Node) -> None: ...
    @callback
    def _async_negative_node_control_handler(self, event: NodeProperty) -> None: ...
    @callback
    def _async_positive_node_control_handler(self, event: NodeProperty) -> None: ...
    @callback
    def async_on_update(self, event: NodeProperty) -> None: ...
    @property
    def is_on(self) -> bool | None: ...

class ISYBinarySensorHeartbeat(ISYNodeEntity, BinarySensorEntity, RestoreEntity):
    _attr_device_class: Incomplete
    _parent_device: Incomplete
    _heartbeat_timer: CALLBACK_TYPE | None
    _computed_state: bool | None
    def __init__(self, node: Node, parent_device: ISYInsteonBinarySensorEntity | ISYBinarySensorEntity | ISYBinarySensorHeartbeat | ISYBinarySensorProgramEntity, device_info: DeviceInfo | None = None) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    def _heartbeat_node_control_handler(self, event: NodeProperty) -> None: ...
    @callback
    def async_heartbeat(self) -> None: ...
    def _restart_timer(self) -> None: ...
    @callback
    def async_on_update(self, event: object) -> None: ...
    @property
    def is_on(self) -> bool: ...
    @property
    def extra_state_attributes(self) -> dict[str, Any]: ...

class ISYBinarySensorProgramEntity(ISYProgramEntity, BinarySensorEntity):
    @property
    def is_on(self) -> bool: ...
