from .entity import ISYNodeEntity as ISYNodeEntity, ISYProgramEntity as ISYProgramEntity
from .models import IsyConfigEntry as IsyConfigEntry
from .services import SERVICE_DELETE_USER_CODE_SCHEMA as SERVICE_DELETE_USER_CODE_SCHEMA, SERVICE_DELETE_ZWAVE_LOCK_USER_CODE as SERVICE_DELETE_ZWAVE_LOCK_USER_CODE, SERVICE_SET_USER_CODE_SCHEMA as SERVICE_SET_USER_CODE_SCHEMA, SERVICE_SET_ZWAVE_LOCK_USER_CODE as SERVICE_SET_ZWAVE_LOCK_USER_CODE
from _typeshed import Incomplete
from homeassistant.components.lock import LockEntity as LockEntity
from homeassistant.const import Platform as Platform
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback, async_get_current_platform as async_get_current_platform
from typing import Any

VALUE_TO_STATE: Incomplete

@callback
def async_setup_lock_services(hass: HomeAssistant) -> None: ...
async def async_setup_entry(hass: HomeAssistant, entry: IsyConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...

class ISYLockEntity(ISYNodeEntity, LockEntity):
    @property
    def is_locked(self) -> bool | None: ...
    async def async_lock(self, **kwargs: Any) -> None: ...
    async def async_unlock(self, **kwargs: Any) -> None: ...
    async def async_set_zwave_lock_user_code(self, user_num: int, code: int) -> None: ...
    async def async_delete_zwave_lock_user_code(self, user_num: int) -> None: ...

class ISYLockProgramEntity(ISYProgramEntity, LockEntity):
    @property
    def is_locked(self) -> bool: ...
    async def async_lock(self, **kwargs: Any) -> None: ...
    async def async_unlock(self, **kwargs: Any) -> None: ...
