from .const import DEFAULT_HOST as DEFAULT_HOST, DEFAULT_PORT as DEFAULT_PORT, DEVICE_SUPPORT_OPTIONS as DEVICE_SUPPORT_OPTIONS, DOMAIN as DOMAIN, INPUT_ENTRY_CLEAR_OPTIONS as INPUT_ENTRY_CLEAR_OPTIONS, INPUT_ENTRY_DEVICE_SELECTION as INPUT_ENTRY_DEVICE_SELECTION, OPTION_ENTRY_DEVICE_OPTIONS as OPTION_ENTRY_DEVICE_OPTIONS, OPTION_ENTRY_SENSOR_PRECISION as OPTION_ENTRY_SENSOR_PRECISION, PRECISION_MAPPING_FAMILY_28 as PRECISION_MAPPING_FAMILY_28
from .onewirehub import OneWireConfigEntry as OneWireConfigEntry
from _typeshed import Incomplete
from homeassistant.config_entries import ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, OptionsFlowWithReload as OptionsFlowWithReload
from homeassistant.const import CONF_HOST as CONF_HOST, CONF_PORT as CONF_PORT
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.device_registry import DeviceEntry as DeviceEntry
from homeassistant.helpers.service_info.hassio import HassioServiceInfo as HassioServiceInfo
from homeassistant.helpers.service_info.zeroconf import ZeroconfServiceInfo as ZeroconfServiceInfo
from typing import Any

DATA_SCHEMA: Incomplete

async def validate_input(hass: HomeAssistant, data: dict[str, Any], errors: dict[str, str]) -> None: ...

class OneWireFlowHandler(ConfigFlow, domain=DOMAIN):
    VERSION: int
    _discovery_data: dict[str, Any]
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_reconfigure(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_hassio(self, discovery_info: HassioServiceInfo) -> ConfigFlowResult: ...
    async def async_step_zeroconf(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    async def async_step_discovery_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    @staticmethod
    @callback
    def async_get_options_flow(config_entry: OneWireConfigEntry) -> OnewireOptionsFlowHandler: ...

class OnewireOptionsFlowHandler(OptionsFlowWithReload):
    configurable_devices: dict[str, str]
    devices_to_configure: dict[str, str]
    current_device: str
    options: Incomplete
    def __init__(self, config_entry: OneWireConfigEntry) -> None: ...
    async def async_step_init(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_device_selection(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_configure_device(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    @staticmethod
    def _get_device_friendly_name(entry: DeviceEntry, onewire_id: str) -> str: ...
    def _get_current_configured_sensors(self) -> list[str]: ...
    def _get_current_setting(self, device_id: str, setting: str, default: Any) -> Any: ...
    def _update_device_options(self, user_input: dict[str, Any]) -> None: ...
