from . import OverkizDataConfigEntry as OverkizDataConfigEntry
from .coordinator import OverkizDataUpdateCoordinator as OverkizDataUpdateCoordinator
from .entity import OverkizDescriptiveEntity as OverkizDescriptiveEntity
from _typeshed import Incomplete
from collections.abc import Callable as Callable
from dataclasses import dataclass
from homeassistant.components.alarm_control_panel import AlarmControlPanelEntity as AlarmControlPanelEntity, AlarmControlPanelEntityDescription as AlarmControlPanelEntityDescription, AlarmControlPanelEntityFeature as AlarmControlPanelEntityFeature, AlarmControlPanelState as AlarmControlPanelState
from homeassistant.const import Platform as Platform
from homeassistant.core import HomeAssistant as HomeAssistant
from homeassistant.helpers.entity import EntityDescription as EntityDescription
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from pyoverkiz.types import StateType as OverkizStateType
from typing import Any

@dataclass(frozen=True, kw_only=True)
class OverkizAlarmDescription(AlarmControlPanelEntityDescription):
    supported_features: AlarmControlPanelEntityFeature
    fn_state: Callable[[Callable[[str], OverkizStateType]], AlarmControlPanelState]
    alarm_disarm: str | None = ...
    alarm_disarm_args: OverkizStateType | list[OverkizStateType] = ...
    alarm_arm_home: str | None = ...
    alarm_arm_home_args: OverkizStateType | list[OverkizStateType] = ...
    alarm_arm_night: str | None = ...
    alarm_arm_night_args: OverkizStateType | list[OverkizStateType] = ...
    alarm_arm_away: str | None = ...
    alarm_arm_away_args: OverkizStateType | list[OverkizStateType] = ...
    alarm_trigger: str | None = ...
    alarm_trigger_args: OverkizStateType | list[OverkizStateType] = ...

MAP_INTERNAL_STATUS_STATE: dict[str, AlarmControlPanelState]

def _state_tsk_alarm_controller(select_state: Callable[[str], OverkizStateType]) -> AlarmControlPanelState: ...

MAP_CORE_ACTIVE_ZONES: dict[str, AlarmControlPanelState]

def _state_stateful_alarm_controller(select_state: Callable[[str], OverkizStateType]) -> AlarmControlPanelState: ...

MAP_MYFOX_STATUS_STATE: dict[str, AlarmControlPanelState]

def _state_myfox_alarm_controller(select_state: Callable[[str], OverkizStateType]) -> AlarmControlPanelState: ...

MAP_ARM_TYPE: dict[str, AlarmControlPanelState]

def _state_alarm_panel_controller(select_state: Callable[[str], OverkizStateType]) -> AlarmControlPanelState: ...

ALARM_DESCRIPTIONS: list[OverkizAlarmDescription]
SUPPORTED_DEVICES: Incomplete

async def async_setup_entry(hass: HomeAssistant, entry: OverkizDataConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...

class OverkizAlarmControlPanel(OverkizDescriptiveEntity, AlarmControlPanelEntity):
    entity_description: OverkizAlarmDescription
    _attr_code_arm_required: bool
    _attr_supported_features: Incomplete
    def __init__(self, device_url: str, coordinator: OverkizDataUpdateCoordinator, description: EntityDescription) -> None: ...
    @property
    def alarm_state(self) -> AlarmControlPanelState: ...
    async def async_alarm_disarm(self, code: str | None = None) -> None: ...
    async def async_alarm_arm_home(self, code: str | None = None) -> None: ...
    async def async_alarm_arm_night(self, code: str | None = None) -> None: ...
    async def async_alarm_arm_away(self, code: str | None = None) -> None: ...
    async def async_alarm_trigger(self, code: str | None = None) -> None: ...
    async def async_execute_command(self, command_name: str, args: Any) -> None: ...
