import abc
from .const import DOMAIN as DOMAIN
from _typeshed import Incomplete
from abc import ABC, abstractmethod
from datetime import timedelta
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.update_coordinator import DataUpdateCoordinator as DataUpdateCoordinator, UpdateFailed as UpdateFailed
from pyprusalink import JobInfo, LegacyPrinterStatus, PrinterInfo, PrinterStatus, PrusaLink as PrusaLink
from typing import TypeVar

_LOGGER: Incomplete
T = TypeVar('T', PrinterStatus, LegacyPrinterStatus, JobInfo)

class PrusaLinkUpdateCoordinator(DataUpdateCoordinator[T], ABC, metaclass=abc.ABCMeta):
    config_entry: ConfigEntry
    expect_change_until: float
    api: Incomplete
    def __init__(self, hass: HomeAssistant, config_entry: ConfigEntry, api: PrusaLink) -> None: ...
    update_interval: Incomplete
    async def _async_update_data(self) -> T: ...
    @abstractmethod
    async def _fetch_data(self) -> T: ...
    @callback
    def expect_change(self) -> None: ...
    def _get_update_interval(self, data: T) -> timedelta: ...

class StatusCoordinator(PrusaLinkUpdateCoordinator[PrinterStatus]):
    async def _fetch_data(self) -> PrinterStatus: ...

class LegacyStatusCoordinator(PrusaLinkUpdateCoordinator[LegacyPrinterStatus]):
    async def _fetch_data(self) -> LegacyPrinterStatus: ...

class JobUpdateCoordinator(PrusaLinkUpdateCoordinator[JobInfo]):
    async def _fetch_data(self) -> JobInfo: ...

class InfoUpdateCoordinator(PrusaLinkUpdateCoordinator[PrinterInfo]):
    async def _fetch_data(self) -> PrinterInfo: ...
