from . import Recorder as Recorder
from .db_schema import Events as Events, States as States, StatesMeta as StatesMeta
from .models import DatabaseEngine as DatabaseEngine
from .queries import attributes_ids_exist_in_states as attributes_ids_exist_in_states, attributes_ids_exist_in_states_with_fast_in_distinct as attributes_ids_exist_in_states_with_fast_in_distinct, data_ids_exist_in_events as data_ids_exist_in_events, data_ids_exist_in_events_with_fast_in_distinct as data_ids_exist_in_events_with_fast_in_distinct, delete_event_data_rows as delete_event_data_rows, delete_event_rows as delete_event_rows, delete_event_types_rows as delete_event_types_rows, delete_recorder_runs_rows as delete_recorder_runs_rows, delete_states_attributes_rows as delete_states_attributes_rows, delete_states_meta_rows as delete_states_meta_rows, delete_states_rows as delete_states_rows, delete_statistics_runs_rows as delete_statistics_runs_rows, delete_statistics_short_term_rows as delete_statistics_short_term_rows, disconnect_states_rows as disconnect_states_rows, find_entity_ids_to_purge as find_entity_ids_to_purge, find_event_types_to_purge as find_event_types_to_purge, find_events_to_purge as find_events_to_purge, find_latest_statistics_runs_run_id as find_latest_statistics_runs_run_id, find_legacy_detached_states_and_attributes_to_purge as find_legacy_detached_states_and_attributes_to_purge, find_legacy_event_state_and_attributes_and_data_ids_to_purge as find_legacy_event_state_and_attributes_and_data_ids_to_purge, find_legacy_row as find_legacy_row, find_short_term_statistics_to_purge as find_short_term_statistics_to_purge, find_states_to_purge as find_states_to_purge, find_statistics_runs_to_purge as find_statistics_runs_to_purge
from .repack import repack_database as repack_database
from .util import retryable_database_job as retryable_database_job, session_scope as session_scope
from _typeshed import Incomplete
from collections.abc import Callable as Callable
from datetime import datetime
from homeassistant.util.collection import chunked_or_all as chunked_or_all
from sqlalchemy.orm.session import Session as Session

_LOGGER: Incomplete
DEFAULT_STATES_BATCHES_PER_PURGE: int
DEFAULT_EVENTS_BATCHES_PER_PURGE: int

def purge_old_data(instance: Recorder, purge_before: datetime, repack: bool, apply_filter: bool = False, events_batch_size: int = ..., states_batch_size: int = ...) -> bool: ...
def _purging_legacy_format(session: Session) -> bool: ...
def _purge_legacy_format(instance: Recorder, session: Session, purge_before: datetime) -> bool: ...
def _purge_states_and_attributes_ids(instance: Recorder, session: Session, states_batch_size: int, purge_before: datetime) -> bool: ...
def _purge_events_and_data_ids(instance: Recorder, session: Session, events_batch_size: int, purge_before: datetime) -> bool: ...
def _select_state_attributes_ids_to_purge(session: Session, purge_before: datetime, max_bind_vars: int) -> tuple[set[int], set[int]]: ...
def _select_event_data_ids_to_purge(session: Session, purge_before: datetime, max_bind_vars: int) -> tuple[set[int], set[int]]: ...
def _select_unused_attributes_ids(instance: Recorder, session: Session, attributes_ids: set[int], database_engine: DatabaseEngine) -> set[int]: ...
def _purge_unused_attributes_ids(instance: Recorder, session: Session, attributes_ids_batch: set[int]) -> None: ...
def _select_unused_event_data_ids(instance: Recorder, session: Session, data_ids: set[int], database_engine: DatabaseEngine) -> set[int]: ...
def _purge_unused_data_ids(instance: Recorder, session: Session, data_ids_batch: set[int]) -> None: ...
def _select_statistics_runs_to_purge(session: Session, purge_before: datetime, max_bind_vars: int) -> list[int]: ...
def _select_short_term_statistics_to_purge(session: Session, purge_before: datetime, max_bind_vars: int) -> list[int]: ...
def _select_legacy_detached_state_and_attributes_and_data_ids_to_purge(session: Session, purge_before: datetime, max_bind_vars: int) -> tuple[set[int], set[int]]: ...
def _select_legacy_event_state_and_attributes_and_data_ids_to_purge(session: Session, purge_before: datetime, max_bind_vars: int) -> tuple[set[int], set[int], set[int], set[int]]: ...
def _purge_state_ids(instance: Recorder, session: Session, state_ids: set[int]) -> None: ...
def _purge_batch_attributes_ids(instance: Recorder, session: Session, attributes_ids: set[int]) -> None: ...
def _purge_batch_data_ids(instance: Recorder, session: Session, data_ids: set[int]) -> None: ...
def _purge_statistics_runs(session: Session, statistics_runs: list[int]) -> None: ...
def _purge_short_term_statistics(session: Session, short_term_statistics: list[int]) -> None: ...
def _purge_event_ids(session: Session, event_ids: set[int]) -> None: ...
def _purge_old_recorder_runs(instance: Recorder, session: Session, purge_before: datetime) -> None: ...
def _purge_old_event_types(instance: Recorder, session: Session) -> None: ...
def _purge_old_entity_ids(instance: Recorder, session: Session) -> None: ...
def _purge_filtered_data(instance: Recorder, session: Session) -> bool: ...
def _purge_filtered_states(instance: Recorder, session: Session, metadata_ids_to_purge: list[str], database_engine: DatabaseEngine, purge_before_timestamp: float) -> bool: ...
def _purge_filtered_events(instance: Recorder, session: Session, excluded_event_type_ids: list[int], purge_before_timestamp: float) -> bool: ...
def purge_entity_data(instance: Recorder, entity_filter: Callable[[str], bool] | None, purge_before: datetime) -> bool: ...
