from .db_schema import EventData as EventData, EventTypes as EventTypes, Events as Events, MigrationChanges as MigrationChanges, RecorderRuns as RecorderRuns, StateAttributes as StateAttributes, States as States, StatesMeta as StatesMeta, Statistics as Statistics, StatisticsRuns as StatisticsRuns, StatisticsShortTerm as StatisticsShortTerm
from collections.abc import Iterable
from datetime import datetime
from sqlalchemy.sql.lambdas import StatementLambdaElement as StatementLambdaElement
from sqlalchemy.sql.selectable import Select as Select

def select_event_type_ids(event_types: tuple[str, ...]) -> Select: ...
def get_shared_attributes(hashes: list[int]) -> StatementLambdaElement: ...
def get_shared_event_datas(hashes: list[int]) -> StatementLambdaElement: ...
def find_event_type_ids(event_types: Iterable[str]) -> StatementLambdaElement: ...
def find_all_states_metadata_ids() -> StatementLambdaElement: ...
def find_states_metadata_ids(entity_ids: Iterable[str]) -> StatementLambdaElement: ...
def attributes_ids_exist_in_states_with_fast_in_distinct(attributes_ids: Iterable[int]) -> StatementLambdaElement: ...
def attributes_ids_exist_in_states(attributes_ids: Iterable[int]) -> StatementLambdaElement: ...
def data_ids_exist_in_events_with_fast_in_distinct(data_ids: Iterable[int]) -> StatementLambdaElement: ...
def data_ids_exist_in_events(data_ids: Iterable[int]) -> StatementLambdaElement: ...
def disconnect_states_rows(state_ids: Iterable[int]) -> StatementLambdaElement: ...
def delete_states_rows(state_ids: Iterable[int]) -> StatementLambdaElement: ...
def delete_event_data_rows(data_ids: Iterable[int]) -> StatementLambdaElement: ...
def delete_states_attributes_rows(attributes_ids: Iterable[int]) -> StatementLambdaElement: ...
def delete_statistics_runs_rows(statistics_runs: Iterable[int]) -> StatementLambdaElement: ...
def delete_statistics_short_term_rows(short_term_statistics: Iterable[int]) -> StatementLambdaElement: ...
def delete_event_rows(event_ids: Iterable[int]) -> StatementLambdaElement: ...
def delete_recorder_runs_rows(purge_before: datetime, current_run_id: int) -> StatementLambdaElement: ...
def find_events_to_purge(purge_before: float, max_bind_vars: int) -> StatementLambdaElement: ...
def find_states_to_purge(purge_before: float, max_bind_vars: int) -> StatementLambdaElement: ...
def find_oldest_state() -> StatementLambdaElement: ...
def find_short_term_statistics_to_purge(purge_before: datetime, max_bind_vars: int) -> StatementLambdaElement: ...
def find_statistics_runs_to_purge(purge_before: datetime, max_bind_vars: int) -> StatementLambdaElement: ...
def find_latest_statistics_runs_run_id() -> StatementLambdaElement: ...
def find_legacy_event_state_and_attributes_and_data_ids_to_purge(purge_before: float, max_bind_vars: int) -> StatementLambdaElement: ...
def find_legacy_detached_states_and_attributes_to_purge(purge_before: float, max_bind_vars: int) -> StatementLambdaElement: ...
def find_legacy_row() -> StatementLambdaElement: ...
def find_events_context_ids_to_migrate(max_bind_vars: int) -> StatementLambdaElement: ...
def find_event_type_to_migrate(max_bind_vars: int) -> StatementLambdaElement: ...
def find_entity_ids_to_migrate(max_bind_vars: int) -> StatementLambdaElement: ...
def batch_cleanup_entity_ids() -> StatementLambdaElement: ...
def has_used_states_entity_ids() -> StatementLambdaElement: ...
def has_used_states_event_ids() -> StatementLambdaElement: ...
def has_events_context_ids_to_migrate() -> StatementLambdaElement: ...
def has_states_context_ids_to_migrate() -> StatementLambdaElement: ...
def has_event_type_to_migrate() -> StatementLambdaElement: ...
def has_entity_ids_to_migrate() -> StatementLambdaElement: ...
def find_states_context_ids_to_migrate(max_bind_vars: int) -> StatementLambdaElement: ...
def get_migration_changes() -> StatementLambdaElement: ...
def find_event_types_to_purge() -> StatementLambdaElement: ...
def find_entity_ids_to_purge() -> StatementLambdaElement: ...
def delete_event_types_rows(event_type_ids: Iterable[int]) -> StatementLambdaElement: ...
def delete_states_meta_rows(metadata_ids: Iterable[int]) -> StatementLambdaElement: ...
def find_unmigrated_short_term_statistics_rows(max_bind_vars: int) -> StatementLambdaElement: ...
def find_unmigrated_statistics_rows(max_bind_vars: int) -> StatementLambdaElement: ...
def migrate_single_short_term_statistics_row_to_timestamp(statistic_id: int, start_ts: float | None, created_ts: float | None, last_reset_ts: float | None) -> StatementLambdaElement: ...
def migrate_single_statistics_row_to_timestamp(statistic_id: int, start_ts: float | None, created_ts: float | None, last_reset_ts: float | None) -> StatementLambdaElement: ...
def delete_duplicate_short_term_statistics_row(statistic_id: int) -> StatementLambdaElement: ...
def delete_duplicate_statistics_row(statistic_id: int) -> StatementLambdaElement: ...
