import datetime as dt
from .browse_media import async_browse_media_internal as async_browse_media_internal
from .const import MEDIA_PLAYER_PREFIX as MEDIA_PLAYER_PREFIX, PLAYABLE_MEDIA_TYPES as PLAYABLE_MEDIA_TYPES
from .coordinator import SpotifyConfigEntry as SpotifyConfigEntry, SpotifyCoordinator as SpotifyCoordinator
from .entity import SpotifyEntity as SpotifyEntity
from _typeshed import Incomplete
from collections.abc import Awaitable, Callable as Callable, Coroutine
from homeassistant.components.media_player import ATTR_MEDIA_ENQUEUE as ATTR_MEDIA_ENQUEUE, BrowseMedia as BrowseMedia, MediaPlayerEnqueue as MediaPlayerEnqueue, MediaPlayerEntity as MediaPlayerEntity, MediaPlayerEntityFeature as MediaPlayerEntityFeature, MediaPlayerState as MediaPlayerState, MediaType as MediaType, RepeatMode as RepeatMode
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback
from homeassistant.helpers.update_coordinator import DataUpdateCoordinator as DataUpdateCoordinator
from spotifyaio import Device as Device, Item as Item, PlaybackState as PlaybackState
from typing import Any, Concatenate

_LOGGER: Incomplete
SUPPORT_SPOTIFY: Incomplete
REPEAT_MODE_MAPPING_TO_HA: Incomplete
REPEAT_MODE_MAPPING_TO_SPOTIFY: Incomplete
AFTER_REQUEST_SLEEP: int

async def async_setup_entry(hass: HomeAssistant, entry: SpotifyConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...
def ensure_item[_R](func: Callable[[SpotifyMediaPlayer, Item], _R]) -> Callable[[SpotifyMediaPlayer], _R | None]: ...
def async_refresh_after[_T: SpotifyEntity, **_P](func: Callable[Concatenate[_T, _P], Awaitable[None]]) -> Callable[Concatenate[_T, _P], Coroutine[Any, Any, None]]: ...

class SpotifyMediaPlayer(SpotifyEntity, MediaPlayerEntity):
    _attr_media_image_remotely_accessible: bool
    _attr_name: Incomplete
    _attr_translation_key: str
    devices: Incomplete
    _attr_unique_id: Incomplete
    def __init__(self, coordinator: SpotifyCoordinator, device_coordinator: DataUpdateCoordinator[list[Device]]) -> None: ...
    @property
    def currently_playing(self) -> PlaybackState | None: ...
    @property
    def supported_features(self) -> MediaPlayerEntityFeature: ...
    @property
    def state(self) -> MediaPlayerState: ...
    @property
    def volume_level(self) -> float | None: ...
    @property
    @ensure_item
    def media_content_id(self, item: Item) -> str: ...
    @property
    @ensure_item
    def media_content_type(self, item: Item) -> str: ...
    @property
    @ensure_item
    def media_duration(self, item: Item) -> int: ...
    @property
    def media_position(self) -> int | None: ...
    @property
    def media_position_updated_at(self) -> dt.datetime | None: ...
    @property
    @ensure_item
    def media_image_url(self, item: Item) -> str | None: ...
    @property
    @ensure_item
    def media_title(self, item: Item) -> str: ...
    @property
    @ensure_item
    def media_artist(self, item: Item) -> str: ...
    @property
    @ensure_item
    def media_album_name(self, item: Item) -> str: ...
    @property
    @ensure_item
    def media_track(self, item: Item) -> int | None: ...
    @property
    def media_playlist(self) -> str | None: ...
    @property
    def source(self) -> str | None: ...
    @property
    def source_list(self) -> list[str] | None: ...
    @property
    def shuffle(self) -> bool | None: ...
    @property
    def repeat(self) -> RepeatMode | None: ...
    @async_refresh_after
    async def async_set_volume_level(self, volume: float) -> None: ...
    @async_refresh_after
    async def async_media_play(self) -> None: ...
    @async_refresh_after
    async def async_media_pause(self) -> None: ...
    @async_refresh_after
    async def async_media_previous_track(self) -> None: ...
    @async_refresh_after
    async def async_media_next_track(self) -> None: ...
    @async_refresh_after
    async def async_media_seek(self, position: float) -> None: ...
    @async_refresh_after
    async def async_play_media(self, media_type: MediaType | str, media_id: str, **kwargs: Any) -> None: ...
    @async_refresh_after
    async def async_select_source(self, source: str) -> None: ...
    @async_refresh_after
    async def async_set_shuffle(self, shuffle: bool) -> None: ...
    @async_refresh_after
    async def async_set_repeat(self, repeat: RepeatMode) -> None: ...
    async def async_browse_media(self, media_content_type: MediaType | str | None = None, media_content_id: str | None = None) -> BrowseMedia: ...
    @callback
    def _handle_devices_update(self) -> None: ...
    async def async_added_to_hass(self) -> None: ...
