from . import DOMAIN as DOMAIN, PLATFORMS as PLATFORMS
from _typeshed import Incomplete
from collections import deque
from collections.abc import Callable, Mapping
from datetime import datetime, timedelta
from homeassistant.components.recorder import get_instance as get_instance, history as history
from homeassistant.components.sensor import DEVICE_CLASS_STATE_CLASSES as DEVICE_CLASS_STATE_CLASSES, DEVICE_CLASS_UNITS as DEVICE_CLASS_UNITS, SensorDeviceClass as SensorDeviceClass, SensorEntity as SensorEntity, SensorStateClass as SensorStateClass
from homeassistant.config_entries import ConfigEntry as ConfigEntry
from homeassistant.const import ATTR_DEVICE_CLASS as ATTR_DEVICE_CLASS, ATTR_UNIT_OF_MEASUREMENT as ATTR_UNIT_OF_MEASUREMENT, CONF_ENTITY_ID as CONF_ENTITY_ID, CONF_NAME as CONF_NAME, CONF_UNIQUE_ID as CONF_UNIQUE_ID, PERCENTAGE as PERCENTAGE, STATE_UNAVAILABLE as STATE_UNAVAILABLE, STATE_UNKNOWN as STATE_UNKNOWN
from homeassistant.core import CALLBACK_TYPE as CALLBACK_TYPE, Event as Event, EventStateChangedData as EventStateChangedData, EventStateReportedData as EventStateReportedData, HomeAssistant as HomeAssistant, State as State, callback as callback, split_entity_id as split_entity_id
from homeassistant.helpers.device import async_entity_id_to_device as async_entity_id_to_device
from homeassistant.helpers.entity_platform import AddConfigEntryEntitiesCallback as AddConfigEntryEntitiesCallback, AddEntitiesCallback as AddEntitiesCallback
from homeassistant.helpers.event import async_track_point_in_utc_time as async_track_point_in_utc_time, async_track_state_change_event as async_track_state_change_event, async_track_state_report_event as async_track_state_report_event
from homeassistant.helpers.reload import async_setup_reload_service as async_setup_reload_service
from homeassistant.helpers.typing import ConfigType as ConfigType, DiscoveryInfoType as DiscoveryInfoType
from homeassistant.util.enum import try_parse_enum as try_parse_enum
from typing import Any

_LOGGER: Incomplete
STAT_AGE_COVERAGE_RATIO: str
STAT_BUFFER_USAGE_RATIO: str
STAT_SOURCE_VALUE_VALID: str
STAT_AVERAGE_LINEAR: str
STAT_AVERAGE_STEP: str
STAT_AVERAGE_TIMELESS: str
STAT_CHANGE: str
STAT_CHANGE_SAMPLE: str
STAT_CHANGE_SECOND: str
STAT_COUNT: str
STAT_COUNT_BINARY_ON: str
STAT_COUNT_BINARY_OFF: str
STAT_DATETIME_NEWEST: str
STAT_DATETIME_OLDEST: str
STAT_DATETIME_VALUE_MAX: str
STAT_DATETIME_VALUE_MIN: str
STAT_DISTANCE_95P: str
STAT_DISTANCE_99P: str
STAT_DISTANCE_ABSOLUTE: str
STAT_MEAN: str
STAT_MEAN_CIRCULAR: str
STAT_MEDIAN: str
STAT_NOISINESS: str
STAT_PERCENTILE: str
STAT_STANDARD_DEVIATION: str
STAT_SUM: str
STAT_SUM_DIFFERENCES: str
STAT_SUM_DIFFERENCES_NONNEGATIVE: str
STAT_TOTAL: str
STAT_VALUE_MAX: str
STAT_VALUE_MIN: str
STAT_VARIANCE: str

def _callable_characteristic_fn(characteristic: str, binary: bool) -> Callable[[deque[bool | float], deque[float], int], float | int | datetime | None]: ...
def _stat_average_linear(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_average_step(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_average_timeless(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_change(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_change_sample(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_change_second(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_count(states: deque[bool | float], ages: deque[float], percentile: int) -> int | None: ...
def _stat_datetime_newest(states: deque[bool | float], ages: deque[float], percentile: int) -> datetime | None: ...
def _stat_datetime_oldest(states: deque[bool | float], ages: deque[float], percentile: int) -> datetime | None: ...
def _stat_datetime_value_max(states: deque[bool | float], ages: deque[float], percentile: int) -> datetime | None: ...
def _stat_datetime_value_min(states: deque[bool | float], ages: deque[float], percentile: int) -> datetime | None: ...
def _stat_distance_95_percent_of_values(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_distance_99_percent_of_values(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_distance_absolute(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_mean(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_mean_circular(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_median(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_noisiness(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_percentile(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_standard_deviation(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_sum(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_sum_differences(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_sum_differences_nonnegative(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_total(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_value_max(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_value_min(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_variance(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_binary_average_step(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_binary_average_timeless(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...
def _stat_binary_count(states: deque[bool | float], ages: deque[float], percentile: int) -> int | None: ...
def _stat_binary_count_on(states: deque[bool | float], ages: deque[float], percentile: int) -> int | None: ...
def _stat_binary_count_off(states: deque[bool | float], ages: deque[float], percentile: int) -> int | None: ...
def _stat_binary_datetime_newest(states: deque[bool | float], ages: deque[float], percentile: int) -> datetime | None: ...
def _stat_binary_datetime_oldest(states: deque[bool | float], ages: deque[float], percentile: int) -> datetime | None: ...
def _stat_binary_mean(states: deque[bool | float], ages: deque[float], percentile: int) -> float | None: ...

STATS_NUMERIC_SUPPORT: Incomplete
STATS_BINARY_SUPPORT: Incomplete
STATS_NOT_A_NUMBER: Incomplete
STATS_DATETIME: Incomplete
STATS_NUMERIC_RETAIN_UNIT: Incomplete
STATS_BINARY_PERCENTAGE: Incomplete
CONF_STATE_CHARACTERISTIC: str
CONF_SAMPLES_MAX_BUFFER_SIZE: str
CONF_MAX_AGE: str
CONF_KEEP_LAST_SAMPLE: str
CONF_PRECISION: str
CONF_PERCENTILE: str
DEFAULT_NAME: str
DEFAULT_PRECISION: int
ICON: str

def valid_state_characteristic_configuration(config: dict[str, Any]) -> dict[str, Any]: ...
def valid_boundary_configuration(config: dict[str, Any]) -> dict[str, Any]: ...
def valid_keep_last_sample(config: dict[str, Any]) -> dict[str, Any]: ...

_PLATFORM_SCHEMA_BASE: Incomplete
PLATFORM_SCHEMA: Incomplete

async def async_setup_platform(hass: HomeAssistant, config: ConfigType, async_add_entities: AddEntitiesCallback, discovery_info: DiscoveryInfoType | None = None) -> None: ...
async def async_setup_entry(hass: HomeAssistant, entry: ConfigEntry, async_add_entities: AddConfigEntryEntitiesCallback) -> None: ...

class StatisticsSensor(SensorEntity):
    _attr_should_poll: bool
    _attr_icon = ICON
    _attr_name: str
    _attr_unique_id: str | None
    _source_entity_id: str
    device_entry: Incomplete
    is_binary: bool
    _state_characteristic: str
    _samples_max_buffer_size: int | None
    _samples_max_age: float | None
    samples_keep_last: bool
    _precision: int
    _percentile: int
    _attr_available: bool
    states: deque[float | bool]
    ages: deque[float]
    _attr_extra_state_attributes: Incomplete
    _state_characteristic_fn: Callable[[deque[bool | float], deque[float], int], float | int | datetime | None]
    _update_listener: CALLBACK_TYPE | None
    _preview_callback: Callable[[str, Mapping[str, Any]], None] | None
    def __init__(self, hass: HomeAssistant, *, source_entity_id: str, name: str, unique_id: str | None, state_characteristic: str, samples_max_buffer_size: int | None, samples_max_age: timedelta | None, samples_keep_last: bool, precision: int, percentile: int) -> None: ...
    async def async_start_preview(self, preview_callback: Callable[[str, Mapping[str, Any]], None]) -> CALLBACK_TYPE: ...
    def _async_handle_new_state(self, reported_state: State, timestamp: float) -> None: ...
    @callback
    def _async_stats_sensor_state_change_listener(self, event: Event[EventStateChangedData]) -> None: ...
    @callback
    def _async_stats_sensor_state_report_listener(self, event: Event[EventStateReportedData]) -> None: ...
    async def _async_stats_sensor_startup(self) -> None: ...
    async def async_added_to_hass(self) -> None: ...
    def _add_state_to_queue(self, new_state: State, last_reported_timestamp: float) -> None: ...
    _attr_native_unit_of_measurement: Incomplete
    _attr_device_class: Incomplete
    _attr_state_class: Incomplete
    def _calculate_state_attributes(self, new_state: State) -> None: ...
    def _calculate_unit_of_measurement(self, new_state: State) -> str | None: ...
    def _calculate_device_class(self, new_state: State, unit: str | None) -> SensorDeviceClass | None: ...
    def _calculate_state_class(self, new_state: State) -> SensorStateClass | None: ...
    def _purge_old_states(self, max_age: float) -> None: ...
    @callback
    def _async_next_to_purge_timestamp(self) -> float | None: ...
    async def async_update(self) -> None: ...
    def _async_purge_update_and_schedule(self) -> None: ...
    @callback
    def _async_cancel_update_listener(self) -> None: ...
    @callback
    def _async_scheduled_update(self, now: datetime) -> None: ...
    def _fetch_states_from_database(self) -> list[State]: ...
    async def _initialize_from_database(self) -> None: ...
    def _update_extra_state_attributes(self) -> None: ...
    _attr_native_value: Incomplete
    def _update_value(self) -> None: ...
