import threading
from .const import ATTR_SETTINGS as ATTR_SETTINGS, CONF_EXTRA_PART_WAIT_TIME as CONF_EXTRA_PART_WAIT_TIME, CONF_RTSP_TRANSPORT as CONF_RTSP_TRANSPORT, CONF_USE_WALLCLOCK_AS_TIMESTAMPS as CONF_USE_WALLCLOCK_AS_TIMESTAMPS, DOMAIN as DOMAIN, FORMAT_CONTENT_TYPE as FORMAT_CONTENT_TYPE, HLS_PROVIDER as HLS_PROVIDER, OUTPUT_FORMATS as OUTPUT_FORMATS, RTSP_TRANSPORTS as RTSP_TRANSPORTS, SOURCE_TIMEOUT as SOURCE_TIMEOUT, StreamClientError as StreamClientError
from .core import Orientation as Orientation, StreamOutput, StreamSettings
from .exceptions import StreamOpenClientError as StreamOpenClientError
from _typeshed import Incomplete
from collections.abc import Callable, Mapping
from homeassistant.components.camera import DynamicStreamSettings
from homeassistant.core import HomeAssistant, callback
from typing import Any

__all__ = ['ATTR_SETTINGS', 'CONF_EXTRA_PART_WAIT_TIME', 'CONF_RTSP_TRANSPORT', 'CONF_USE_WALLCLOCK_AS_TIMESTAMPS', 'DOMAIN', 'FORMAT_CONTENT_TYPE', 'HLS_PROVIDER', 'OUTPUT_FORMATS', 'RTSP_TRANSPORTS', 'SOURCE_TIMEOUT', 'Orientation', 'Stream', 'StreamClientError', 'StreamOpenClientError', 'create_stream']

def create_stream(hass: HomeAssistant, stream_source: str, options: Mapping[str, str | bool | float], dynamic_stream_settings: DynamicStreamSettings, stream_label: str | None = None) -> Stream: ...

class Stream:
    hass: Incomplete
    source: Incomplete
    pyav_options: Incomplete
    _stream_settings: Incomplete
    _stream_label: Incomplete
    dynamic_stream_settings: Incomplete
    access_token: str | None
    _start_stop_lock: Incomplete
    _thread: threading.Thread | None
    _thread_quit: Incomplete
    _outputs: dict[str, StreamOutput]
    _fast_restart_once: bool
    _keyframe_converter: Incomplete
    _available: bool
    _update_callback: Callable[[], None] | None
    _logger: Incomplete
    _diagnostics: Incomplete
    def __init__(self, hass: HomeAssistant, source: str, pyav_options: dict[str, str], stream_settings: StreamSettings, dynamic_stream_settings: DynamicStreamSettings, stream_label: str | None = None) -> None: ...
    def endpoint_url(self, fmt: str) -> str: ...
    def outputs(self) -> Mapping[str, StreamOutput]: ...
    def add_provider(self, fmt: str, timeout: int | None = None) -> StreamOutput: ...
    async def remove_provider(self, provider: StreamOutput) -> None: ...
    def check_idle(self) -> None: ...
    @property
    def available(self) -> bool: ...
    def set_update_callback(self, update_callback: Callable[[], None]) -> None: ...
    @callback
    def _async_update_state(self, available: bool) -> None: ...
    async def start(self) -> None: ...
    def update_source(self, new_source: str) -> None: ...
    def _set_state(self, available: bool) -> None: ...
    def _run_worker(self) -> None: ...
    async def stop(self) -> None: ...
    async def _stop(self) -> None: ...
    async def async_record(self, video_path: str, duration: int = 30, lookback: int = 5) -> None: ...
    async def async_get_image(self, width: int | None = None, height: int | None = None, wait_for_next_keyframe: bool = False) -> bytes | None: ...
    def get_diagnostics(self) -> dict[str, Any]: ...
