import asyncio
import voluptuous as vol
from .addon import get_addon_manager as get_addon_manager
from .const import ADDON_SLUG as ADDON_SLUG, CONF_ADDON_DEVICE as CONF_ADDON_DEVICE, CONF_ADDON_LR_S2_ACCESS_CONTROL_KEY as CONF_ADDON_LR_S2_ACCESS_CONTROL_KEY, CONF_ADDON_LR_S2_AUTHENTICATED_KEY as CONF_ADDON_LR_S2_AUTHENTICATED_KEY, CONF_ADDON_NETWORK_KEY as CONF_ADDON_NETWORK_KEY, CONF_ADDON_S0_LEGACY_KEY as CONF_ADDON_S0_LEGACY_KEY, CONF_ADDON_S2_ACCESS_CONTROL_KEY as CONF_ADDON_S2_ACCESS_CONTROL_KEY, CONF_ADDON_S2_AUTHENTICATED_KEY as CONF_ADDON_S2_AUTHENTICATED_KEY, CONF_ADDON_S2_UNAUTHENTICATED_KEY as CONF_ADDON_S2_UNAUTHENTICATED_KEY, CONF_INTEGRATION_CREATED_ADDON as CONF_INTEGRATION_CREATED_ADDON, CONF_KEEP_OLD_DEVICES as CONF_KEEP_OLD_DEVICES, CONF_LR_S2_ACCESS_CONTROL_KEY as CONF_LR_S2_ACCESS_CONTROL_KEY, CONF_LR_S2_AUTHENTICATED_KEY as CONF_LR_S2_AUTHENTICATED_KEY, CONF_S0_LEGACY_KEY as CONF_S0_LEGACY_KEY, CONF_S2_ACCESS_CONTROL_KEY as CONF_S2_ACCESS_CONTROL_KEY, CONF_S2_AUTHENTICATED_KEY as CONF_S2_AUTHENTICATED_KEY, CONF_S2_UNAUTHENTICATED_KEY as CONF_S2_UNAUTHENTICATED_KEY, CONF_USB_PATH as CONF_USB_PATH, CONF_USE_ADDON as CONF_USE_ADDON, DOMAIN as DOMAIN
from .helpers import CannotConnect as CannotConnect, async_get_version_info as async_get_version_info, async_wait_for_driver_ready_event as async_wait_for_driver_ready_event
from .models import ZwaveJSConfigEntry as ZwaveJSConfigEntry
from _typeshed import Incomplete
from homeassistant.components import usb as usb
from homeassistant.components.hassio import AddonError as AddonError, AddonInfo as AddonInfo, AddonManager as AddonManager, AddonState as AddonState
from homeassistant.config_entries import ConfigEntryState as ConfigEntryState, ConfigFlow as ConfigFlow, ConfigFlowResult as ConfigFlowResult, SOURCE_USB as SOURCE_USB
from homeassistant.const import CONF_NAME as CONF_NAME, CONF_URL as CONF_URL
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.data_entry_flow import AbortFlow as AbortFlow
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers import selector as selector
from homeassistant.helpers.hassio import is_hassio as is_hassio
from homeassistant.helpers.service_info.hassio import HassioServiceInfo as HassioServiceInfo
from homeassistant.helpers.service_info.usb import UsbServiceInfo as UsbServiceInfo
from homeassistant.helpers.service_info.zeroconf import ZeroconfServiceInfo as ZeroconfServiceInfo
from pathlib import Path
from typing import Any
from zwave_js_server.client import Client as Client
from zwave_js_server.model.driver import Driver as Driver
from zwave_js_server.version import VersionInfo as VersionInfo

_LOGGER: Incomplete
DEFAULT_URL: str
TITLE: str
ADDON_SETUP_TIMEOUT: int
ADDON_SETUP_TIMEOUT_ROUNDS: int
ADDON_USER_INPUT_MAP: Incomplete
CONF_ADDON_RF_REGION: str
EXAMPLE_SERVER_URL: str
ON_SUPERVISOR_SCHEMA: Incomplete
MIN_MIGRATION_SDK_VERSION: Incomplete
NETWORK_TYPE_NEW: str
NETWORK_TYPE_EXISTING: str
ZWAVE_JS_SERVER_INSTRUCTIONS: str
ZWAVE_JS_UI_MIGRATION_INSTRUCTIONS: str
RF_REGIONS: Incomplete

def get_manual_schema(user_input: dict[str, Any]) -> vol.Schema: ...
def get_on_supervisor_schema(user_input: dict[str, Any]) -> vol.Schema: ...
async def validate_input(hass: HomeAssistant, user_input: dict) -> VersionInfo: ...
def get_usb_ports() -> dict[str, str]: ...
async def async_get_usb_ports(hass: HomeAssistant) -> dict[str, str]: ...

class ZWaveJSConfigFlow(ConfigFlow, domain=DOMAIN):
    VERSION: int
    s0_legacy_key: str | None
    s2_access_control_key: str | None
    s2_authenticated_key: str | None
    s2_unauthenticated_key: str | None
    lr_s2_access_control_key: str | None
    lr_s2_authenticated_key: str | None
    usb_path: str | None
    ws_address: str | None
    restart_addon: bool
    integration_created_addon: bool
    install_task: asyncio.Task | None
    start_task: asyncio.Task | None
    version_info: VersionInfo | None
    original_addon_config: dict[str, Any] | None
    revert_reason: str | None
    backup_task: asyncio.Task | None
    restore_backup_task: asyncio.Task | None
    backup_data: bytes | None
    backup_filepath: Path | None
    use_addon: bool
    _addon_config_updates: dict[str, Any]
    _migrating: bool
    _reconfigure_config_entry: ZwaveJSConfigEntry | None
    _usb_discovery: bool
    _recommended_install: bool
    _rf_region: str | None
    def __init__(self) -> None: ...
    async def async_step_install_addon(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_install_failed(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_start_addon(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_start_failed(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_start_addon(self) -> None: ...
    async def async_step_configure_addon(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_finish_addon_setup(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def _async_get_addon_info(self) -> AddonInfo: ...
    async def _async_set_addon_config(self, config_updates: dict) -> None: ...
    async def _async_install_addon(self) -> None: ...
    async def _async_get_addon_discovery_info(self) -> dict: ...
    async def async_step_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_installation_type(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_reconfigure(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_zeroconf(self, discovery_info: ZeroconfServiceInfo) -> ConfigFlowResult: ...
    async def async_step_zeroconf_confirm(self, user_input: dict | None = None) -> ConfigFlowResult: ...
    async def async_step_usb(self, discovery_info: UsbServiceInfo) -> ConfigFlowResult: ...
    async def async_step_confirm_usb_migration(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_manual(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_hassio(self, discovery_info: HassioServiceInfo) -> ConfigFlowResult: ...
    async def async_step_hassio_confirm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_intent_recommended(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_intent_custom(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_rf_region(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_on_supervisor(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_configure_addon_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_network_type(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_configure_security_keys(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_finish_addon_setup_user(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    @callback
    def _async_create_entry_from_vars(self) -> ConfigFlowResult: ...
    @callback
    def _async_update_entry(self, updates: dict[str, Any]) -> None: ...
    async def async_step_intent_reconfigure(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_intent_migrate(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_backup_nvm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_restore_nvm(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_instruct_unplug(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_manual_reconfigure(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_on_supervisor_reconfigure(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_configure_addon_reconfigure(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_choose_serial_port(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_backup_failed(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_restore_failed(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_migration_done(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_finish_addon_setup_migrate(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_step_finish_addon_setup_reconfigure(self, user_input: dict[str, Any] | None = None) -> ConfigFlowResult: ...
    async def async_revert_addon_config(self, reason: str) -> ConfigFlowResult: ...
    async def _async_backup_network(self) -> None: ...
    async def _async_restore_network_backup(self) -> None: ...
    def _get_driver(self) -> Driver: ...

class InvalidInput(HomeAssistantError):
    error: Incomplete
    def __init__(self, error: str) -> None: ...
