import logging
import voluptuous as vol
from .const import ATTR_COMMAND_CLASS as ATTR_COMMAND_CLASS, ATTR_ENDPOINT as ATTR_ENDPOINT, ATTR_PROPERTY as ATTR_PROPERTY, ATTR_PROPERTY_KEY as ATTR_PROPERTY_KEY, DOMAIN as DOMAIN, LIB_LOGGER as LIB_LOGGER, LOGGER as LOGGER
from .models import ZwaveJSConfigEntry as ZwaveJSConfigEntry
from collections.abc import Callable as Callable, Coroutine
from dataclasses import dataclass
from homeassistant.config_entries import ConfigEntryState as ConfigEntryState
from homeassistant.const import ATTR_AREA_ID as ATTR_AREA_ID, ATTR_DEVICE_ID as ATTR_DEVICE_ID, ATTR_ENTITY_ID as ATTR_ENTITY_ID, CONF_TYPE as CONF_TYPE
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from homeassistant.exceptions import HomeAssistantError as HomeAssistantError
from homeassistant.helpers import device_registry as dr, entity_registry as er
from homeassistant.helpers.aiohttp_client import async_get_clientsession as async_get_clientsession
from homeassistant.helpers.device_registry import DeviceInfo as DeviceInfo
from homeassistant.helpers.group import expand_entity_ids as expand_entity_ids
from homeassistant.helpers.typing import ConfigType as ConfigType, VolSchemaType as VolSchemaType
from typing import Any
from zwave_js_server.model.controller import Controller as Controller, ProvisioningEntry as ProvisioningEntry
from zwave_js_server.model.driver import Driver as Driver
from zwave_js_server.model.node import Node as ZwaveNode
from zwave_js_server.model.value import Value as ZwaveValue, ValueDataType as ValueDataType
from zwave_js_server.version import VersionInfo as VersionInfo

DRIVER_READY_EVENT_TIMEOUT: int
SERVER_VERSION_TIMEOUT: int

@dataclass
class ZwaveValueMatcher:
    property_: str | int | None = ...
    command_class: int | None = ...
    endpoint: int | None = ...
    property_key: str | int | None = ...
    def __post_init__(self) -> None: ...

def value_matches_matcher(matcher: ZwaveValueMatcher, value_data: ValueDataType) -> bool: ...
def get_value_id_from_unique_id(unique_id: str) -> str | None: ...
def get_state_key_from_unique_id(unique_id: str) -> int | None: ...
def get_value_of_zwave_value(value: ZwaveValue | None) -> Any | None: ...
async def async_enable_statistics(driver: Driver) -> None: ...
async def async_enable_server_logging_if_needed(hass: HomeAssistant, entry: ZwaveJSConfigEntry, driver: Driver) -> None: ...
async def async_disable_server_logging_if_needed(hass: HomeAssistant, entry: ZwaveJSConfigEntry, driver: Driver) -> None: ...
def get_valueless_base_unique_id(driver: Driver, node: ZwaveNode) -> str: ...
def get_unique_id(driver: Driver, value_id: str) -> str: ...
def get_device_id(driver: Driver, node: ZwaveNode) -> tuple[str, str]: ...
def get_device_id_ext(driver: Driver, node: ZwaveNode) -> tuple[str, str] | None: ...
def get_home_and_node_id_from_device_entry(device_entry: dr.DeviceEntry) -> tuple[str, int] | None: ...
@callback
def async_get_node_from_device_id(hass: HomeAssistant, device_id: str, dev_reg: dr.DeviceRegistry | None = None) -> ZwaveNode: ...
async def async_get_provisioning_entry_from_device_id(hass: HomeAssistant, device_id: str) -> ProvisioningEntry | None: ...
@callback
def async_get_node_from_entity_id(hass: HomeAssistant, entity_id: str, ent_reg: er.EntityRegistry | None = None, dev_reg: dr.DeviceRegistry | None = None) -> ZwaveNode: ...
@callback
def async_get_nodes_from_area_id(hass: HomeAssistant, area_id: str, ent_reg: er.EntityRegistry | None = None, dev_reg: dr.DeviceRegistry | None = None) -> set[ZwaveNode]: ...
@callback
def async_get_nodes_from_targets(hass: HomeAssistant, val: dict[str, Any], ent_reg: er.EntityRegistry | None = None, dev_reg: dr.DeviceRegistry | None = None, logger: logging.Logger = ...) -> set[ZwaveNode]: ...
def get_zwave_value_from_config(node: ZwaveNode, config: ConfigType) -> ZwaveValue: ...
def _zwave_js_config_entry(hass: HomeAssistant, device: dr.DeviceEntry) -> str | None: ...
@callback
def async_get_node_status_sensor_entity_id(hass: HomeAssistant, device_id: str, ent_reg: er.EntityRegistry | None = None, dev_reg: dr.DeviceRegistry | None = None) -> str | None: ...
def remove_keys_with_empty_values(config: ConfigType) -> ConfigType: ...
def check_type_schema_map(schema_map: dict[str, vol.Schema]) -> Callable[[ConfigType], ConfigType]: ...
def copy_available_params(input_dict: dict[str, Any], output_dict: dict[str, Any], params: list[str]) -> None: ...
def get_value_state_schema(value: ZwaveValue) -> VolSchemaType | vol.Coerce | vol.In | None: ...
def get_device_info(driver: Driver, node: ZwaveNode) -> DeviceInfo: ...
def get_network_identifier_for_notification(hass: HomeAssistant, config_entry: ZwaveJSConfigEntry, controller: Controller) -> str: ...
async def async_get_version_info(hass: HomeAssistant, ws_address: str) -> VersionInfo: ...
@callback
def async_wait_for_driver_ready_event(config_entry: ZwaveJSConfigEntry, driver: Driver) -> Callable[[], Coroutine[Any, Any, None]]: ...

class CannotConnect(HomeAssistantError): ...
