from . import template as template
from _typeshed import Incomplete
from collections import ChainMap, UserDict
from collections.abc import Mapping
from dataclasses import dataclass, field
from homeassistant.core import HomeAssistant as HomeAssistant, callback as callback
from typing import Any

class ScriptVariables:
    variables: Incomplete
    _has_template: bool | None
    def __init__(self, variables: dict[str, Any]) -> None: ...
    @callback
    def async_render(self, hass: HomeAssistant, run_variables: Mapping[str, Any] | None, *, limited: bool = False) -> dict[str, Any]: ...
    @callback
    def async_simple_render(self, run_variables: Mapping[str, Any]) -> dict[str, Any]: ...
    def as_dict(self) -> dict[str, Any]: ...

@dataclass
class _ParallelData:
    protected: dict[str, Any] = field(default_factory=dict)
    outer_scope_writes: dict[str, Any] = field(default_factory=dict)

@dataclass(kw_only=True)
class ScriptRunVariables(UserDict[str, Any]):
    _previous: ScriptRunVariables | None = ...
    _parent: ScriptRunVariables | None = ...
    _local_data: dict[str, Any] | None = ...
    _parallel_data: _ParallelData | None = ...
    _non_parallel_scope: ChainMap[str, Any]
    _full_scope: ChainMap[str, Any]
    @classmethod
    def create_top_level(cls, initial_data: Mapping[str, Any] | None = None) -> ScriptRunVariables: ...
    def enter_scope(self, *, parallel: bool = False) -> ScriptRunVariables: ...
    def exit_scope(self) -> ScriptRunVariables: ...
    def __delitem__(self, key: str) -> None: ...
    def __setitem__(self, key: str, value: Any) -> None: ...
    def assign_parallel_protected(self, key: str, value: Any) -> None: ...
    def _assign(self, key: str, value: Any, *, parallel_protected: bool) -> None: ...
    def define_local(self, key: str, value: Any) -> None: ...
    @property
    def data(self) -> Mapping[str, Any]: ...
    @property
    def non_parallel_scope(self) -> Mapping[str, Any]: ...
    @property
    def local_scope(self) -> Mapping[str, Any]: ...
