import asyncio
from .core import HomeAssistant as HomeAssistant, callback as callback
from .exceptions import HomeAssistantError as HomeAssistantError
from .helpers import singleton as singleton
from .loader import Integration as Integration, IntegrationNotFound as IntegrationNotFound, async_get_integration as async_get_integration
from _typeshed import Incomplete
from collections.abc import Iterable
from typing import Any

PIP_TIMEOUT: int
MAX_INSTALL_FAILURES: int
DATA_REQUIREMENTS_MANAGER: str
CONSTRAINT_FILE: str
DISCOVERY_INTEGRATIONS: dict[str, Iterable[str]]
_LOGGER: Incomplete

class RequirementsNotFound(HomeAssistantError):
    domain: Incomplete
    requirements: Incomplete
    def __init__(self, domain: str, requirements: list[str]) -> None: ...

async def async_get_integration_with_requirements(hass: HomeAssistant, domain: str) -> Integration: ...
async def async_process_requirements(hass: HomeAssistant, name: str, requirements: list[str]) -> None: ...
async def async_load_installed_versions(hass: HomeAssistant, requirements: set[str]) -> None: ...
@callback
def _async_get_manager(hass: HomeAssistant) -> RequirementsManager: ...
@callback
def async_clear_install_history(hass: HomeAssistant) -> None: ...
def pip_kwargs(config_dir: str | None) -> dict[str, Any]: ...
def _install_with_retry(requirement: str, kwargs: dict[str, Any]) -> bool: ...
def _install_requirements_if_missing(requirements: list[str], kwargs: dict[str, Any]) -> tuple[set[str], set[str]]: ...

class RequirementsManager:
    hass: Incomplete
    pip_lock: Incomplete
    integrations_with_reqs: dict[str, Integration | asyncio.Future[Integration]]
    install_failure_history: set[str]
    is_installed_cache: set[str]
    def __init__(self, hass: HomeAssistant) -> None: ...
    async def async_get_integration_with_requirements(self, domain: str, done: set[str] | None = None) -> Integration: ...
    async def _async_process_integration(self, integration: Integration, done: set[str]) -> None: ...
    async def async_process_requirements(self, name: str, requirements: list[str]) -> None: ...
    def _find_missing_requirements(self, requirements: list[str]) -> list[str]: ...
    def _raise_for_failed_requirements(self, integration: str, missing: list[str]) -> None: ...
    async def _async_process_requirements(self, name: str, requirements: list[str]) -> None: ...
    async def async_load_installed_versions(self, requirements: set[str]) -> None: ...
