import logging
import logging.handlers
from _typeshed import Incomplete
from collections.abc import Callable, Coroutine
from homeassistant.core import HassJobType as HassJobType, HomeAssistant as HomeAssistant, callback as callback, get_hassjob_callable_job_type as get_hassjob_callable_job_type
from queue import SimpleQueue
from typing import Any, overload, override

_LOGGER: Incomplete

class HomeAssistantQueueListener(logging.handlers.QueueListener):
    LOG_COUNTS_RESET_INTERVAL: int
    MAX_LOGS_COUNT: int
    EXCLUDED_LOG_COUNT_MODULES: Incomplete
    _last_reset: float
    _log_counts: dict[str, int]
    _module_log_count_skip_flags: dict[str, bool]
    def __init__(self, queue: SimpleQueue[logging.Handler], *handlers: logging.Handler) -> None: ...
    @override
    def handle(self, record: logging.LogRecord) -> None: ...
    def _reset_counters(self, time_sec: float) -> None: ...
    def _update_skip_flags(self, module_name: str) -> bool: ...

class HomeAssistantQueueHandler(logging.handlers.QueueHandler):
    listener: logging.handlers.QueueListener | None
    def handle(self, record: logging.LogRecord) -> Any: ...
    def close(self) -> None: ...

@callback
def async_activate_log_queue_handler(hass: HomeAssistant) -> None: ...
def log_exception[*_Ts](format_err: Callable[[*_Ts], Any], *args: *_Ts) -> None: ...
async def _async_wrapper[*_Ts](async_func: Callable[[*_Ts], Coroutine[Any, Any, None]], format_err: Callable[[*_Ts], Any], *args: *_Ts) -> None: ...
def _sync_wrapper[*_Ts](func: Callable[[*_Ts], Any], format_err: Callable[[*_Ts], Any], *args: *_Ts) -> None: ...
@callback
def _callback_wrapper[*_Ts](func: Callable[[*_Ts], Any], format_err: Callable[[*_Ts], Any], *args: *_Ts) -> None: ...
@overload
def catch_log_exception[*_Ts](func: Callable[[*_Ts], Coroutine[Any, Any, Any]], format_err: Callable[[*_Ts], Any], job_type: HassJobType | None = None) -> Callable[[*_Ts], Coroutine[Any, Any, None]]: ...
@overload
def catch_log_exception[*_Ts](func: Callable[[*_Ts], Any], format_err: Callable[[*_Ts], Any], job_type: HassJobType | None = None) -> Callable[[*_Ts], None] | Callable[[*_Ts], Coroutine[Any, Any, None]]: ...
def catch_log_coro_exception[_T, *_Ts](target: Coroutine[Any, Any, _T], format_err: Callable[[*_Ts], Any], *args: *_Ts) -> Coroutine[Any, Any, _T | None]: ...
def async_create_catching_coro[_T](target: Coroutine[Any, Any, _T]) -> Coroutine[Any, Any, _T | None]: ...
