import asyncio
import enum
from .async_ import run_callback_threadsafe as run_callback_threadsafe
from _typeshed import Incomplete
from types import TracebackType
from typing import Any, Self

ZONE_GLOBAL: str

class _State(enum.Enum):
    INIT = 'INIT'
    ACTIVE = 'ACTIVE'
    TIMEOUT = 'TIMEOUT'
    EXIT = 'EXIT'

class _GlobalFreezeContext:
    _loop: asyncio.AbstractEventLoop
    _manager: TimeoutManager
    def __init__(self, manager: TimeoutManager) -> None: ...
    async def __aenter__(self) -> Self: ...
    async def __aexit__(self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None) -> bool | None: ...
    def __enter__(self) -> Self: ...
    def __exit__(self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None) -> bool | None: ...
    def _enter(self) -> None: ...
    def _exit(self) -> None: ...

class _ZoneFreezeContext:
    _loop: asyncio.AbstractEventLoop
    _zone: _ZoneTimeoutManager
    def __init__(self, zone: _ZoneTimeoutManager) -> None: ...
    async def __aenter__(self) -> Self: ...
    async def __aexit__(self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None) -> bool | None: ...
    def __enter__(self) -> Self: ...
    def __exit__(self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None) -> bool | None: ...
    def _enter(self) -> None: ...
    def _exit(self) -> None: ...

class _GlobalTaskContext:
    _loop: asyncio.AbstractEventLoop
    _manager: TimeoutManager
    _task: asyncio.Task[Any]
    _time_left: float
    _expiration_time: float | None
    _timeout_handler: asyncio.Handle | None
    _on_wait_task: asyncio.Task | None
    _wait_zone: asyncio.Event
    _state: _State
    _cool_down: float
    _cancelling: int
    _cancel_message: Incomplete
    def __init__(self, manager: TimeoutManager, task: asyncio.Task[Any], timeout: float, cool_down: float, cancel_message: str | None) -> None: ...
    async def __aenter__(self) -> Self: ...
    async def __aexit__(self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None) -> bool | None: ...
    @property
    def state(self) -> _State: ...
    def zones_done_signal(self) -> None: ...
    def _start_timer(self) -> None: ...
    def _stop_timer(self) -> None: ...
    def _on_timeout(self) -> None: ...
    def _cancel_task(self) -> None: ...
    def pause(self) -> None: ...
    def reset(self) -> None: ...
    async def _on_wait(self) -> None: ...

class _ZoneTaskContext:
    _loop: asyncio.AbstractEventLoop
    _zone: _ZoneTimeoutManager
    _task: asyncio.Task[Any]
    _state: _State
    _time_left: float
    _expiration_time: float | None
    _timeout_handler: asyncio.Handle | None
    _cancelling: int
    _cancel_message: Incomplete
    def __init__(self, zone: _ZoneTimeoutManager, task: asyncio.Task[Any], timeout: float, cancel_message: str | None) -> None: ...
    @property
    def state(self) -> _State: ...
    async def __aenter__(self) -> Self: ...
    async def __aexit__(self, exc_type: type[BaseException] | None, exc_val: BaseException | None, exc_tb: TracebackType | None) -> bool | None: ...
    def _start_timer(self) -> None: ...
    def _stop_timer(self) -> None: ...
    def _on_timeout(self) -> None: ...
    def pause(self) -> None: ...
    def reset(self) -> None: ...

class _ZoneTimeoutManager:
    _manager: TimeoutManager
    _zone: str
    _tasks: list[_ZoneTaskContext]
    _freezes: list[_ZoneFreezeContext]
    def __init__(self, manager: TimeoutManager, zone: str) -> None: ...
    def __repr__(self) -> str: ...
    @property
    def name(self) -> str: ...
    @property
    def active(self) -> bool: ...
    @property
    def freezes_done(self) -> bool: ...
    def enter_task(self, task: _ZoneTaskContext) -> None: ...
    def exit_task(self, task: _ZoneTaskContext) -> None: ...
    def enter_freeze(self, freeze: _ZoneFreezeContext) -> None: ...
    def exit_freeze(self, freeze: _ZoneFreezeContext) -> None: ...
    def pause(self) -> None: ...
    def reset(self) -> None: ...

class TimeoutManager:
    _loop: asyncio.AbstractEventLoop
    _zones: dict[str, _ZoneTimeoutManager]
    _globals: list[_GlobalTaskContext]
    _freezes: list[_GlobalFreezeContext]
    def __init__(self) -> None: ...
    @property
    def zones_done(self) -> bool: ...
    @property
    def freezes_done(self) -> bool: ...
    @property
    def zones(self) -> dict[str, _ZoneTimeoutManager]: ...
    @property
    def global_tasks(self) -> list[_GlobalTaskContext]: ...
    @property
    def global_freezes(self) -> list[_GlobalFreezeContext]: ...
    def drop_zone(self, zone_name: str) -> None: ...
    def async_timeout(self, timeout: float, zone_name: str = ..., cool_down: float = 0, cancel_message: str | None = None) -> _ZoneTaskContext | _GlobalTaskContext: ...
    def async_freeze(self, zone_name: str = ...) -> _ZoneFreezeContext | _GlobalFreezeContext: ...
    def freeze(self, zone_name: str = ...) -> _ZoneFreezeContext | _GlobalFreezeContext: ...
