// Code generated by templ - DO NOT EDIT.

// templ: version: v0.3.960
package app

//lint:file-ignore SA4006 This context is only used if a nested component is present.

import "github.com/a-h/templ"
import templruntime "github.com/a-h/templ/runtime"

import (
	"fmt"
	"github.com/seaweedfs/seaweedfs/weed/admin/dash"
)

func ObjectStoreUsers(data dash.ObjectStoreUsersData) templ.Component {
	return templruntime.GeneratedTemplate(func(templ_7745c5c3_Input templruntime.GeneratedComponentInput) (templ_7745c5c3_Err error) {
		templ_7745c5c3_W, ctx := templ_7745c5c3_Input.Writer, templ_7745c5c3_Input.Context
		if templ_7745c5c3_CtxErr := ctx.Err(); templ_7745c5c3_CtxErr != nil {
			return templ_7745c5c3_CtxErr
		}
		templ_7745c5c3_Buffer, templ_7745c5c3_IsBuffer := templruntime.GetBuffer(templ_7745c5c3_W)
		if !templ_7745c5c3_IsBuffer {
			defer func() {
				templ_7745c5c3_BufErr := templruntime.ReleaseBuffer(templ_7745c5c3_Buffer)
				if templ_7745c5c3_Err == nil {
					templ_7745c5c3_Err = templ_7745c5c3_BufErr
				}
			}()
		}
		ctx = templ.InitializeContext(ctx)
		templ_7745c5c3_Var1 := templ.GetChildren(ctx)
		if templ_7745c5c3_Var1 == nil {
			templ_7745c5c3_Var1 = templ.NopComponent
		}
		ctx = templ.ClearChildren(ctx)
		templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 1, "<div class=\"container-fluid\"><!-- Page Header --><div class=\"d-sm-flex align-items-center justify-content-between mb-4\"><div><h1 class=\"h3 mb-0 text-gray-800\"><i class=\"fas fa-users me-2\"></i>Object Store Users</h1><p class=\"mb-0 text-muted\">Manage S3 API users and their access credentials</p></div><div class=\"d-flex gap-2\"><button type=\"button\" class=\"btn btn-primary\" data-bs-toggle=\"modal\" data-bs-target=\"#createUserModal\"><i class=\"fas fa-plus me-1\"></i>Create User</button></div></div><!-- Summary Cards --><div class=\"row mb-4\"><div class=\"col-xl-3 col-md-6 mb-4\"><div class=\"card border-left-primary shadow h-100 py-2\"><div class=\"card-body\"><div class=\"row no-gutters align-items-center\"><div class=\"col mr-2\"><div class=\"text-xs font-weight-bold text-primary text-uppercase mb-1\">Total Users</div><div class=\"h5 mb-0 font-weight-bold text-gray-800\">")
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		var templ_7745c5c3_Var2 string
		templ_7745c5c3_Var2, templ_7745c5c3_Err = templ.JoinStringErrs(fmt.Sprintf("%d", data.TotalUsers))
		if templ_7745c5c3_Err != nil {
			return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 38, Col: 71}
		}
		_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var2))
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 2, "</div></div><div class=\"col-auto\"><i class=\"fas fa-users fa-2x text-gray-300\"></i></div></div></div></div></div><div class=\"col-xl-3 col-md-6 mb-4\"><div class=\"card border-left-success shadow h-100 py-2\"><div class=\"card-body\"><div class=\"row no-gutters align-items-center\"><div class=\"col mr-2\"><div class=\"text-xs font-weight-bold text-success text-uppercase mb-1\">Total Users</div><div class=\"h5 mb-0 font-weight-bold text-gray-800\">")
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		var templ_7745c5c3_Var3 string
		templ_7745c5c3_Var3, templ_7745c5c3_Err = templ.JoinStringErrs(fmt.Sprintf("%d", len(data.Users)))
		if templ_7745c5c3_Err != nil {
			return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 58, Col: 71}
		}
		_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var3))
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 3, "</div></div><div class=\"col-auto\"><i class=\"fas fa-user-check fa-2x text-gray-300\"></i></div></div></div></div></div><div class=\"col-xl-3 col-md-6 mb-4\"><div class=\"card border-left-info shadow h-100 py-2\"><div class=\"card-body\"><div class=\"row no-gutters align-items-center\"><div class=\"col mr-2\"><div class=\"text-xs font-weight-bold text-info text-uppercase mb-1\">Last Updated</div><div class=\"h6 mb-0 font-weight-bold text-gray-800\">")
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		var templ_7745c5c3_Var4 string
		templ_7745c5c3_Var4, templ_7745c5c3_Err = templ.JoinStringErrs(data.LastUpdated.Format("15:04"))
		if templ_7745c5c3_Err != nil {
			return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 78, Col: 69}
		}
		_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var4))
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 4, "</div></div><div class=\"col-auto\"><i class=\"fas fa-clock fa-2x text-gray-300\"></i></div></div></div></div></div></div><!-- Users Table --><div class=\"row\"><div class=\"col-12\"><div class=\"card shadow mb-4\"><div class=\"card-header py-3 d-flex flex-row align-items-center justify-content-between\"><h6 class=\"m-0 font-weight-bold text-primary\"><i class=\"fas fa-users me-2\"></i>Object Store Users</h6><div class=\"dropdown no-arrow\"><a class=\"dropdown-toggle\" href=\"#\" role=\"button\" data-bs-toggle=\"dropdown\"><i class=\"fas fa-ellipsis-v fa-sm fa-fw text-gray-400\"></i></a><div class=\"dropdown-menu dropdown-menu-right shadow animated--fade-in\"><div class=\"dropdown-header\">Actions:</div><a class=\"dropdown-item\" href=\"#\" onclick=\"exportUsers()\"><i class=\"fas fa-download me-2\"></i>Export List</a></div></div></div><div class=\"card-body\"><div class=\"table-responsive\"><table class=\"table table-hover\" width=\"100%\" cellspacing=\"0\" id=\"usersTable\"><thead><tr><th>Username</th><th>Email</th><th>Access Key</th><th>Actions</th></tr></thead> <tbody>")
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		for _, user := range data.Users {
			templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 5, "<tr><td><div class=\"d-flex align-items-center\"><i class=\"fas fa-user me-2 text-muted\"></i> <strong>")
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			var templ_7745c5c3_Var5 string
			templ_7745c5c3_Var5, templ_7745c5c3_Err = templ.JoinStringErrs(user.Username)
			if templ_7745c5c3_Err != nil {
				return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 127, Col: 74}
			}
			_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var5))
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 6, "</strong></div></td><td>")
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			var templ_7745c5c3_Var6 string
			templ_7745c5c3_Var6, templ_7745c5c3_Err = templ.JoinStringErrs(user.Email)
			if templ_7745c5c3_Err != nil {
				return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 130, Col: 59}
			}
			_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var6))
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 7, "</td><td><code class=\"text-muted\">")
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			var templ_7745c5c3_Var7 string
			templ_7745c5c3_Var7, templ_7745c5c3_Err = templ.JoinStringErrs(user.AccessKey)
			if templ_7745c5c3_Err != nil {
				return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 132, Col: 88}
			}
			_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var7))
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 8, "</code></td><td><div class=\"btn-group btn-group-sm\" role=\"group\"><button type=\"button\" class=\"btn btn-outline-info\" data-action=\"show-user-details\" data-username=\"")
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			var templ_7745c5c3_Var8 string
			templ_7745c5c3_Var8, templ_7745c5c3_Err = templ.JoinStringErrs(user.Username)
			if templ_7745c5c3_Err != nil {
				return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 137, Col: 121}
			}
			_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var8))
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 9, "\"><i class=\"fas fa-info-circle\"></i></button> <button type=\"button\" class=\"btn btn-outline-primary\" data-action=\"edit-user\" data-username=\"")
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			var templ_7745c5c3_Var9 string
			templ_7745c5c3_Var9, templ_7745c5c3_Err = templ.JoinStringErrs(user.Username)
			if templ_7745c5c3_Err != nil {
				return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 141, Col: 113}
			}
			_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var9))
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 10, "\"><i class=\"fas fa-edit\"></i></button> <button type=\"button\" class=\"btn btn-outline-secondary\" data-action=\"manage-access-keys\" data-username=\"")
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			var templ_7745c5c3_Var10 string
			templ_7745c5c3_Var10, templ_7745c5c3_Err = templ.JoinStringErrs(user.Username)
			if templ_7745c5c3_Err != nil {
				return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 145, Col: 122}
			}
			_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var10))
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 11, "\"><i class=\"fas fa-key\"></i></button> <button type=\"button\" class=\"btn btn-outline-danger\" data-action=\"delete-user\" data-username=\"")
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			var templ_7745c5c3_Var11 string
			templ_7745c5c3_Var11, templ_7745c5c3_Err = templ.JoinStringErrs(user.Username)
			if templ_7745c5c3_Err != nil {
				return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 149, Col: 115}
			}
			_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var11))
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
			templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 12, "\"><i class=\"fas fa-trash\"></i></button></div></td></tr>")
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
		}
		if len(data.Users) == 0 {
			templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 13, "<tr><td colspan=\"4\" class=\"text-center text-muted py-4\"><i class=\"fas fa-users fa-3x mb-3 text-muted\"></i><div><h5>No users found</h5><p>Create your first object store user to get started.</p></div></td></tr>")
			if templ_7745c5c3_Err != nil {
				return templ_7745c5c3_Err
			}
		}
		templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 14, "</tbody></table></div></div></div></div></div><!-- Last Updated --><div class=\"row\"><div class=\"col-12\"><small class=\"text-muted\"><i class=\"fas fa-clock me-1\"></i> Last updated: ")
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		var templ_7745c5c3_Var12 string
		templ_7745c5c3_Var12, templ_7745c5c3_Err = templ.JoinStringErrs(data.LastUpdated.Format("2006-01-02 15:04:05"))
		if templ_7745c5c3_Err != nil {
			return templ.Error{Err: templ_7745c5c3_Err, FileName: `view/app/object_store_users.templ`, Line: 180, Col: 81}
		}
		_, templ_7745c5c3_Err = templ_7745c5c3_Buffer.WriteString(templ.EscapeString(templ_7745c5c3_Var12))
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		templ_7745c5c3_Err = templruntime.WriteString(templ_7745c5c3_Buffer, 15, "</small></div></div></div><!-- Create User Modal --><div class=\"modal fade\" id=\"createUserModal\" tabindex=\"-1\" role=\"dialog\"><div class=\"modal-dialog\" role=\"document\"><div class=\"modal-content\"><div class=\"modal-header\"><h5 class=\"modal-title\"><i class=\"fas fa-user-plus me-2\"></i>Create New User</h5><button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button></div><div class=\"modal-body\"><form id=\"createUserForm\"><div class=\"mb-3\"><label for=\"username\" class=\"form-label\">Username *</label> <input type=\"text\" class=\"form-control\" id=\"username\" name=\"username\" required></div><div class=\"mb-3\"><label for=\"email\" class=\"form-label\">Email</label> <input type=\"email\" class=\"form-control\" id=\"email\" name=\"email\"></div><div class=\"mb-3\"><label for=\"actions\" class=\"form-label\">Permissions</label> <select multiple class=\"form-control\" id=\"actions\" name=\"actions\" size=\"10\"><option value=\"Admin\">Admin (Full Access)</option> <option value=\"Read\">Read</option> <option value=\"Write\">Write</option> <option value=\"List\">List</option> <option value=\"Tagging\">Tagging</option> <optgroup label=\"Object Lock Permissions\"><option value=\"BypassGovernanceRetention\">Bypass Governance Retention</option> <option value=\"GetObjectRetention\">Get Object Retention</option> <option value=\"PutObjectRetention\">Put Object Retention</option> <option value=\"GetObjectLegalHold\">Get Object Legal Hold</option> <option value=\"PutObjectLegalHold\">Put Object Legal Hold</option> <option value=\"GetBucketObjectLockConfiguration\">Get Bucket Object Lock Configuration</option> <option value=\"PutBucketObjectLockConfiguration\">Put Bucket Object Lock Configuration</option></optgroup></select> <small class=\"form-text text-muted\">Hold Ctrl/Cmd to select multiple permissions</small></div><div class=\"mb-3 form-check\"><input type=\"checkbox\" class=\"form-check-input\" id=\"generateKey\" name=\"generateKey\" checked> <label class=\"form-check-label\" for=\"generateKey\">Generate access key automatically</label></div></form></div><div class=\"modal-footer\"><button type=\"button\" class=\"btn btn-secondary\" data-bs-dismiss=\"modal\">Cancel</button> <button type=\"button\" class=\"btn btn-primary\" onclick=\"handleCreateUser()\">Create User</button></div></div></div></div><!-- Edit User Modal --><div class=\"modal fade\" id=\"editUserModal\" tabindex=\"-1\" role=\"dialog\"><div class=\"modal-dialog\" role=\"document\"><div class=\"modal-content\"><div class=\"modal-header\"><h5 class=\"modal-title\"><i class=\"fas fa-user-edit me-2\"></i>Edit User</h5><button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button></div><div class=\"modal-body\"><form id=\"editUserForm\"><input type=\"hidden\" id=\"editUsername\" name=\"username\"><div class=\"mb-3\"><label for=\"editEmail\" class=\"form-label\">Email</label> <input type=\"email\" class=\"form-control\" id=\"editEmail\" name=\"email\"></div><div class=\"mb-3\"><label for=\"editActions\" class=\"form-label\">Permissions</label> <select multiple class=\"form-control\" id=\"editActions\" name=\"actions\" size=\"10\"><option value=\"Admin\">Admin (Full Access)</option> <option value=\"Read\">Read</option> <option value=\"Write\">Write</option> <option value=\"List\">List</option> <option value=\"Tagging\">Tagging</option> <optgroup label=\"Object Lock Permissions\"><option value=\"BypassGovernanceRetention\">Bypass Governance Retention</option> <option value=\"GetObjectRetention\">Get Object Retention</option> <option value=\"PutObjectRetention\">Put Object Retention</option> <option value=\"GetObjectLegalHold\">Get Object Legal Hold</option> <option value=\"PutObjectLegalHold\">Put Object Legal Hold</option> <option value=\"GetBucketObjectLockConfiguration\">Get Bucket Object Lock Configuration</option> <option value=\"PutBucketObjectLockConfiguration\">Put Bucket Object Lock Configuration</option></optgroup></select></div></form></div><div class=\"modal-footer\"><button type=\"button\" class=\"btn btn-secondary\" data-bs-dismiss=\"modal\">Cancel</button> <button type=\"button\" class=\"btn btn-primary\" onclick=\"handleUpdateUser()\">Update User</button></div></div></div></div><!-- User Details Modal --><div class=\"modal fade\" id=\"userDetailsModal\" tabindex=\"-1\" role=\"dialog\"><div class=\"modal-dialog modal-lg\" role=\"document\"><div class=\"modal-content\"><div class=\"modal-header\"><h5 class=\"modal-title\"><i class=\"fas fa-user me-2\"></i>User Details</h5><button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button></div><div class=\"modal-body\" id=\"userDetailsContent\"><!-- Content will be loaded dynamically --></div><div class=\"modal-footer\"><button type=\"button\" class=\"btn btn-secondary\" data-bs-dismiss=\"modal\">Close</button></div></div></div></div><!-- Access Keys Management Modal --><div class=\"modal fade\" id=\"accessKeysModal\" tabindex=\"-1\" role=\"dialog\"><div class=\"modal-dialog modal-lg\" role=\"document\"><div class=\"modal-content\"><div class=\"modal-header\"><h5 class=\"modal-title\"><i class=\"fas fa-key me-2\"></i>Manage Access Keys</h5><button type=\"button\" class=\"btn-close\" data-bs-dismiss=\"modal\"></button></div><div class=\"modal-body\"><div class=\"d-flex justify-content-between align-items-center mb-3\"><h6>Access Keys for <span id=\"accessKeysUsername\"></span></h6><button type=\"button\" class=\"btn btn-primary btn-sm\" onclick=\"createAccessKey()\"><i class=\"fas fa-plus me-1\"></i>Create New Key</button></div><div id=\"accessKeysContent\"><!-- Content will be loaded dynamically --></div></div><div class=\"modal-footer\"><button type=\"button\" class=\"btn btn-secondary\" data-bs-dismiss=\"modal\">Close</button></div></div></div></div><!-- JavaScript for user management --><script>\n        document.addEventListener('DOMContentLoaded', function() {\n            // Event delegation for user action buttons\n            document.addEventListener('click', function(e) {\n                const button = e.target.closest('[data-action]');\n                if (!button) return;\n                \n                const action = button.getAttribute('data-action');\n                const username = button.getAttribute('data-username');\n                \n                switch (action) {\n                    case 'show-user-details':\n                        showUserDetails(username);\n                        break;\n                    case 'edit-user':\n                        editUser(username);\n                        break;\n                    case 'manage-access-keys':\n                        manageAccessKeys(username);\n                        break;\n                    case 'delete-user':\n                        deleteUser(username);\n                        break;\n                }\n            });\n        });\n\n        // Show user details modal\n        async function showUserDetails(username) {\n            try {\n                const response = await fetch(`/api/users/${username}`);\n                if (response.ok) {\n                    const user = await response.json();\n                    document.getElementById('userDetailsContent').innerHTML = createUserDetailsContent(user);\n                    const modal = new bootstrap.Modal(document.getElementById('userDetailsModal'));\n                    modal.show();\n                } else {\n                    showErrorMessage('Failed to load user details');\n                }\n            } catch (error) {\n                console.error('Error loading user details:', error);\n                showErrorMessage('Failed to load user details');\n            }\n        }\n\n        // Edit user function\n        async function editUser(username) {\n            try {\n                const response = await fetch(`/api/users/${username}`);\n                if (response.ok) {\n                    const user = await response.json();\n                    \n                    // Populate edit form\n                    document.getElementById('editUsername').value = username;\n                    document.getElementById('editEmail').value = user.email || '';\n                    \n                    // Set selected actions\n                    const actionsSelect = document.getElementById('editActions');\n                    Array.from(actionsSelect.options).forEach(option => {\n                        option.selected = user.actions && user.actions.includes(option.value);\n                    });\n                    \n                    // Show modal\n                    const modal = new bootstrap.Modal(document.getElementById('editUserModal'));\n                    modal.show();\n                } else {\n                    showErrorMessage('Failed to load user details');\n                }\n            } catch (error) {\n                console.error('Error loading user:', error);\n                showErrorMessage('Failed to load user details');\n            }\n        }\n\n        // Manage access keys function\n        async function manageAccessKeys(username) {\n            try {\n                const response = await fetch(`/api/users/${username}`);\n                if (response.ok) {\n                    const user = await response.json();\n                    document.getElementById('accessKeysUsername').textContent = username;\n                    document.getElementById('accessKeysContent').innerHTML = createAccessKeysContent(user);\n                    const modal = new bootstrap.Modal(document.getElementById('accessKeysModal'));\n                    modal.show();\n                } else {\n                    showErrorMessage('Failed to load access keys');\n                }\n            } catch (error) {\n                console.error('Error loading access keys:', error);\n                showErrorMessage('Failed to load access keys');\n            }\n        }\n\n        // Delete user function\n        async function deleteUser(username) {\n            if (confirm(`Are you sure you want to delete user \"${username}\"? This action cannot be undone.`)) {\n                try {\n                    const response = await fetch(`/api/users/${username}`, {\n                        method: 'DELETE'\n                    });\n                    \n                    if (response.ok) {\n                        showSuccessMessage('User deleted successfully');\n                        setTimeout(() => window.location.reload(), 1000);\n                    } else {\n                        const error = await response.json();\n                        showErrorMessage('Failed to delete user: ' + (error.error || 'Unknown error'));\n                    }\n                } catch (error) {\n                    console.error('Error deleting user:', error);\n                    showErrorMessage('Failed to delete user: ' + error.message);\n                }\n            }\n        }\n\n        // Handle create user form submission\n        async function handleCreateUser() {\n            const form = document.getElementById('createUserForm');\n            const formData = new FormData(form);\n            \n            const userData = {\n                username: formData.get('username'),\n                email: formData.get('email'),\n                actions: Array.from(document.getElementById('actions').selectedOptions).map(option => option.value),\n                generate_key: document.getElementById('generateKey').checked\n            };\n            \n            try {\n                const response = await fetch('/api/users', {\n                    method: 'POST',\n                    headers: {\n                        'Content-Type': 'application/json',\n                    },\n                    body: JSON.stringify(userData)\n                });\n                \n                if (response.ok) {\n                    const result = await response.json();\n                    showSuccessMessage('User created successfully');\n                    \n                    // Show the created access key if generated\n                    if (result.user && result.user.access_key) {\n                        showNewAccessKeyModal(result.user);\n                    }\n                    \n                    // Close modal and refresh page\n                    const modal = bootstrap.Modal.getInstance(document.getElementById('createUserModal'));\n                    modal.hide();\n                    form.reset();\n                    setTimeout(() => window.location.reload(), 1000);\n                } else {\n                    const error = await response.json();\n                    showErrorMessage('Failed to create user: ' + (error.error || 'Unknown error'));\n                }\n            } catch (error) {\n                console.error('Error creating user:', error);\n                showErrorMessage('Failed to create user: ' + error.message);\n            }\n        }\n\n        // Handle update user form submission\n        async function handleUpdateUser() {\n            const username = document.getElementById('editUsername').value;\n            const formData = new FormData(document.getElementById('editUserForm'));\n            \n            const userData = {\n                email: formData.get('email'),\n                actions: Array.from(document.getElementById('editActions').selectedOptions).map(option => option.value)\n            };\n            \n            try {\n                const response = await fetch(`/api/users/${username}`, {\n                    method: 'PUT',\n                    headers: {\n                        'Content-Type': 'application/json',\n                    },\n                    body: JSON.stringify(userData)\n                });\n                \n                if (response.ok) {\n                    showSuccessMessage('User updated successfully');\n                    \n                    // Close modal and refresh page\n                    const modal = bootstrap.Modal.getInstance(document.getElementById('editUserModal'));\n                    modal.hide();\n                    setTimeout(() => window.location.reload(), 1000);\n                } else {\n                    const error = await response.json();\n                    showErrorMessage('Failed to update user: ' + (error.error || 'Unknown error'));\n                }\n            } catch (error) {\n                console.error('Error updating user:', error);\n                showErrorMessage('Failed to update user: ' + error.message);\n            }\n        }\n\n        // Create user details content\n        function createUserDetailsContent(user) {\n            var detailsHtml = '<div class=\"row\">';\n            detailsHtml += '<div class=\"col-md-6\">';\n            detailsHtml += '<h6 class=\"text-muted\">Basic Information</h6>';\n            detailsHtml += '<table class=\"table table-sm\">';\n            detailsHtml += '<tr><td><strong>Username:</strong></td><td>' + escapeHtml(user.username) + '</td></tr>';\n            detailsHtml += '<tr><td><strong>Email:</strong></td><td>' + escapeHtml(user.email || 'Not set') + '</td></tr>';\n            detailsHtml += '</table>';\n            detailsHtml += '</div>';\n            detailsHtml += '<div class=\"col-md-6\">';\n                         detailsHtml += '<h6 class=\"text-muted\">Permissions</h6>';\n             detailsHtml += '<div class=\"mb-3\">';\n             if (user.actions && user.actions.length > 0) {\n                 detailsHtml += user.actions.map(function(action) {\n                     return '<span class=\"badge bg-info me-1\">' + action + '</span>';\n                 }).join('');\n             } else {\n                 detailsHtml += '<span class=\"text-muted\">No permissions assigned</span>';\n             }\n             detailsHtml += '</div>';\n             detailsHtml += '<h6 class=\"text-muted\">Access Keys</h6>';\n             if (user.access_keys && user.access_keys.length > 0) {\n                 detailsHtml += '<div class=\"mb-2\">';\n                 user.access_keys.forEach(function(key) {\n                     detailsHtml += '<div><code class=\"text-muted\">' + key.access_key + '</code></div>';\n                 });\n                 detailsHtml += '</div>';\n             } else {\n                 detailsHtml += '<p class=\"text-muted\">No access keys</p>';\n             }\n            detailsHtml += '</div>';\n            detailsHtml += '</div>';\n            return detailsHtml;\n        }\n\n        // Create access keys content\n        function createAccessKeysContent(user) {\n            if (!user.access_keys || user.access_keys.length === 0) {\n                return '<p class=\"text-muted\">No access keys available</p>';\n            }\n            \n            var keysHtml = '<div class=\"table-responsive\">';\n            keysHtml += '<table class=\"table table-sm\">';\n            keysHtml += '<thead><tr><th>Access Key</th><th>Status</th><th>Actions</th></tr></thead>';\n            keysHtml += '<tbody>';\n            \n            user.access_keys.forEach(function(key) {\n                keysHtml += '<tr>';\n                keysHtml += '<td><code>' + key.access_key + '</code></td>';\n                keysHtml += '<td><span class=\"badge bg-success\">Active</span></td>';\n                keysHtml += '<td>';\n                keysHtml += '<button class=\"btn btn-outline-danger btn-sm\" onclick=\"deleteAccessKey(\\'' + user.username + '\\', \\'' + key.access_key + '\\')\">';\n                keysHtml += '<i class=\"fas fa-trash\"></i> Delete';\n                keysHtml += '</button>';\n                keysHtml += '</td>';\n                keysHtml += '</tr>';\n            });\n            \n            keysHtml += '</tbody>';\n            keysHtml += '</table>';\n            keysHtml += '</div>';\n            return keysHtml;\n        }\n\n        // Create new access key\n        async function createAccessKey() {\n            const username = document.getElementById('accessKeysUsername').textContent;\n            \n            try {\n                const response = await fetch(`/api/users/${username}/access-keys`, {\n                    method: 'POST',\n                    headers: {\n                        'Content-Type': 'application/json',\n                    },\n                    body: JSON.stringify({})\n                });\n                \n                if (response.ok) {\n                    const result = await response.json();\n                    showSuccessMessage('Access key created successfully');\n                    \n                    // Refresh access keys display\n                    const userResponse = await fetch(`/api/users/${username}`);\n                    if (userResponse.ok) {\n                        const user = await userResponse.json();\n                        document.getElementById('accessKeysContent').innerHTML = createAccessKeysContent(user);\n                    }\n                } else {\n                    const error = await response.json();\n                    showErrorMessage('Failed to create access key: ' + (error.error || 'Unknown error'));\n                }\n            } catch (error) {\n                console.error('Error creating access key:', error);\n                showErrorMessage('Failed to create access key: ' + error.message);\n            }\n        }\n\n        // Delete access key\n        async function deleteAccessKey(username, accessKey) {\n            if (confirm('Are you sure you want to delete this access key?')) {\n                try {\n                    const response = await fetch(`/api/users/${username}/access-keys/${accessKey}`, {\n                        method: 'DELETE'\n                    });\n                    \n                    if (response.ok) {\n                        showSuccessMessage('Access key deleted successfully');\n                        \n                        // Refresh access keys display\n                        const userResponse = await fetch(`/api/users/${username}`);\n                        if (userResponse.ok) {\n                            const user = await userResponse.json();\n                            document.getElementById('accessKeysContent').innerHTML = createAccessKeysContent(user);\n                        }\n                    } else {\n                        const error = await response.json();\n                        showErrorMessage('Failed to delete access key: ' + (error.error || 'Unknown error'));\n                    }\n                } catch (error) {\n                    console.error('Error deleting access key:', error);\n                    showErrorMessage('Failed to delete access key: ' + error.message);\n                }\n            }\n        }\n\n        // Show new access key modal (when user is created with generated key)\n        function showNewAccessKeyModal(user) {\n            // Create a simple alert for now - could be enhanced with a dedicated modal\n            var message = 'New user created!\\n\\n';\n            message += 'Username: ' + user.username + '\\n';\n            message += 'Access Key: ' + user.access_key + '\\n';\n            message += 'Secret Key: ' + user.secret_key + '\\n\\n';\n            message += 'Please save these credentials securely.';\n            alert(message);\n        }\n\n        // Utility functions\n        function showSuccessMessage(message) {\n            // Simple implementation - could be enhanced with toast notifications\n            alert('Success: ' + message);\n        }\n\n        function showErrorMessage(message) {\n            // Simple implementation - could be enhanced with toast notifications\n            alert('Error: ' + message);\n        }\n\n        function escapeHtml(text) {\n            if (!text) return '';\n            const div = document.createElement('div');\n            div.textContent = text;\n            return div.innerHTML;\n        }\n    </script>")
		if templ_7745c5c3_Err != nil {
			return templ_7745c5c3_Err
		}
		return nil
	})
}

// Helper functions for template
var _ = templruntime.GeneratedTemplate
