from typing import cast

from canvas_sdk.value_set.value_set import ValueSet


class HCCConditions(ValueSet):
    """HCC Conditions."""

    VALUE_SET_NAME = "HCC Conditions"
    EXPANSION_VERSION = "CanvasHCC Update 18-10-23"

    ICD10CM = {
        "B20",
        "B9735",
        "Z21",
        "A021",
        "A207",
        "A227",
        "A267",
        "A327",
        "A392",
        "A393",
        "A394",
        "A400",
        "A401",
        "A403",
        "A408",
        "A409",
        "A4101",
        "A4102",
        "A411",
        "A412",
        "A413",
        "A414",
        "A4150",
        "A4151",
        "A4152",
        "A4153",
        "A4159",
        "A4181",
        "A4189",
        "A419",
        "A427",
        "A483",
        "A5486",
        "B007",
        "B377",
        "P360",
        "P3610",
        "P3619",
        "P362",
        "P3630",
        "P3639",
        "P364",
        "P365",
        "P368",
        "P369",
        "R571",
        "R578",
        "R6510",
        "R6511",
        "R6520",
        "R6521",
        "T8112XA",
        "A072",
        "A310",
        "A312",
        "B250",
        "B251",
        "B252",
        "B258",
        "B259",
        "B371",
        "B3781",
        "B440",
        "B441",
        "B442",
        "B447",
        "B4489",
        "B449",
        "B450",
        "B451",
        "B452",
        "B453",
        "B457",
        "B458",
        "B459",
        "B460",
        "B461",
        "B462",
        "B463",
        "B464",
        "B465",
        "B468",
        "B469",
        "B484",
        "B488",
        "B582",
        "B583",
        "B59",
        "C770",
        "C771",
        "C772",
        "C774",
        "C775",
        "C778",
        "C7800",
        "C7801",
        "C7802",
        "C781",
        "C782",
        "C7830",
        "C7839",
        "C784",
        "C785",
        "C786",
        "C787",
        "C7880",
        "C7889",
        "C7900",
        "C7901",
        "C7902",
        "C7910",
        "C7911",
        "C7919",
        "C7931",
        "C7932",
        "C7940",
        "C7949",
        "C7951",
        "C7952",
        "C7960",
        "C7961",
        "C7962",
        "C7970",
        "C7971",
        "C7972",
        "C7989",
        "C799",
        "C7B00",
        "C7B01",
        "C7B02",
        "C7B03",
        "C7B04",
        "C7B09",
        "C7B1",
        "C7B8",
        "C800",
        "C9100",
        "C9101",
        "C9102",
        "C9200",
        "C9201",
        "C9202",
        "C9240",
        "C9241",
        "C9242",
        "C9250",
        "C9251",
        "C9252",
        "C9260",
        "C9261",
        "C9262",
        "C92A0",
        "C92A1",
        "C92A2",
        "C9300",
        "C9301",
        "C9302",
        "C9400",
        "C9401",
        "C9402",
        "C9420",
        "C9421",
        "C9422",
        "C9440",
        "C9441",
        "C9442",
        "C9500",
        "C9501",
        "C9502",
        "C153",
        "C154",
        "C155",
        "C158",
        "C159",
        "C160",
        "C161",
        "C162",
        "C163",
        "C164",
        "C165",
        "C166",
        "C168",
        "C169",
        "C170",
        "C171",
        "C172",
        "C173",
        "C178",
        "C179",
        "C220",
        "C221",
        "C222",
        "C223",
        "C224",
        "C227",
        "C228",
        "C229",
        "C23",
        "C240",
        "C241",
        "C248",
        "C249",
        "C250",
        "C251",
        "C252",
        "C253",
        "C254",
        "C257",
        "C258",
        "C259",
        "C33",
        "C3400",
        "C3401",
        "C3402",
        "C3410",
        "C3411",
        "C3412",
        "C342",
        "C3430",
        "C3431",
        "C3432",
        "C3480",
        "C3481",
        "C3482",
        "C3490",
        "C3491",
        "C3492",
        "C384",
        "C450",
        "C451",
        "C452",
        "C457",
        "C459",
        "C480",
        "C481",
        "C482",
        "C488",
        "C9000",
        "C9001",
        "C9002",
        "C9010",
        "C9011",
        "C9012",
        "C9020",
        "C9021",
        "C9022",
        "C9210",
        "C9211",
        "C9212",
        "C9220",
        "C9221",
        "C9222",
        "C9230",
        "C9231",
        "C9232",
        "C9290",
        "C9291",
        "C9292",
        "C92Z0",
        "C92Z1",
        "C92Z2",
        "C9310",
        "C9311",
        "C9312",
        "C9330",
        "C9331",
        "C9332",
        "C9390",
        "C9391",
        "C9392",
        "C93Z0",
        "C93Z1",
        "C93Z2",
        "C9430",
        "C9431",
        "C9432",
        "C9480",
        "C9481",
        "C9482",
        "C4000",
        "C4001",
        "C4002",
        "C4010",
        "C4011",
        "C4012",
        "C4020",
        "C4021",
        "C4022",
        "C4030",
        "C4031",
        "C4032",
        "C4080",
        "C4081",
        "C4082",
        "C4090",
        "C4091",
        "C4092",
        "C410",
        "C411",
        "C412",
        "C413",
        "C414",
        "C419",
        "C460",
        "C461",
        "C462",
        "C463",
        "C464",
        "C4650",
        "C4651",
        "C4652",
        "C467",
        "C469",
        "C470",
        "C4710",
        "C4711",
        "C4712",
        "C4720",
        "C4721",
        "C4722",
        "C473",
        "C474",
        "C475",
        "C476",
        "C478",
        "C479",
        "C490",
        "C4910",
        "C4911",
        "C4912",
        "C4920",
        "C4921",
        "C4922",
        "C493",
        "C494",
        "C495",
        "C496",
        "C498",
        "C499",
        "C49A0",
        "C49A1",
        "C49A2",
        "C49A3",
        "C49A4",
        "C49A5",
        "C49A9",
        "C561",
        "C562",
        "C569",
        "C5700",
        "C5701",
        "C5702",
        "C5710",
        "C5711",
        "C5712",
        "C5720",
        "C5721",
        "C5722",
        "C573",
        "C574",
        "C58",
        "C700",
        "C701",
        "C709",
        "C710",
        "C711",
        "C712",
        "C713",
        "C714",
        "C715",
        "C716",
        "C717",
        "C718",
        "C719",
        "C720",
        "C721",
        "C7220",
        "C7221",
        "C7222",
        "C7230",
        "C7231",
        "C7232",
        "C7240",
        "C7241",
        "C7242",
        "C7250",
        "C7259",
        "C729",
        "C7400",
        "C7401",
        "C7402",
        "C7410",
        "C7411",
        "C7412",
        "C7490",
        "C7491",
        "C7492",
        "C751",
        "C752",
        "C753",
        "C773",
        "C779",
        "C792",
        "C7981",
        "C7982",
        "C8100",
        "C8101",
        "C8102",
        "C8103",
        "C8104",
        "C8105",
        "C8106",
        "C8107",
        "C8108",
        "C8109",
        "C8110",
        "C8111",
        "C8112",
        "C8113",
        "C8114",
        "C8115",
        "C8116",
        "C8117",
        "C8118",
        "C8119",
        "C8120",
        "C8121",
        "C8122",
        "C8123",
        "C8124",
        "C8125",
        "C8126",
        "C8127",
        "C8128",
        "C8129",
        "C8130",
        "C8131",
        "C8132",
        "C8133",
        "C8134",
        "C8135",
        "C8136",
        "C8137",
        "C8138",
        "C8139",
        "C8140",
        "C8141",
        "C8142",
        "C8143",
        "C8144",
        "C8145",
        "C8146",
        "C8147",
        "C8148",
        "C8149",
        "C8170",
        "C8171",
        "C8172",
        "C8173",
        "C8174",
        "C8175",
        "C8176",
        "C8177",
        "C8178",
        "C8179",
        "C8190",
        "C8191",
        "C8192",
        "C8193",
        "C8194",
        "C8195",
        "C8196",
        "C8197",
        "C8198",
        "C8199",
        "C8200",
        "C8201",
        "C8202",
        "C8203",
        "C8204",
        "C8205",
        "C8206",
        "C8207",
        "C8208",
        "C8209",
        "C8210",
        "C8211",
        "C8212",
        "C8213",
        "C8214",
        "C8215",
        "C8216",
        "C8217",
        "C8218",
        "C8219",
        "C8220",
        "C8221",
        "C8222",
        "C8223",
        "C8224",
        "C8225",
        "C8226",
        "C8227",
        "C8228",
        "C8229",
        "C8230",
        "C8231",
        "C8232",
        "C8233",
        "C8234",
        "C8235",
        "C8236",
        "C8237",
        "C8238",
        "C8239",
        "C8240",
        "C8241",
        "C8242",
        "C8243",
        "C8244",
        "C8245",
        "C8246",
        "C8247",
        "C8248",
        "C8249",
        "C8250",
        "C8251",
        "C8252",
        "C8253",
        "C8254",
        "C8255",
        "C8256",
        "C8257",
        "C8258",
        "C8259",
        "C8260",
        "C8261",
        "C8262",
        "C8263",
        "C8264",
        "C8265",
        "C8266",
        "C8267",
        "C8268",
        "C8269",
        "C8280",
        "C8281",
        "C8282",
        "C8283",
        "C8284",
        "C8285",
        "C8286",
        "C8287",
        "C8288",
        "C8289",
        "C8290",
        "C8291",
        "C8292",
        "C8293",
        "C8294",
        "C8295",
        "C8296",
        "C8297",
        "C8298",
        "C8299",
        "C8300",
        "C8301",
        "C8302",
        "C8303",
        "C8304",
        "C8305",
        "C8306",
        "C8307",
        "C8308",
        "C8309",
        "C8310",
        "C8311",
        "C8312",
        "C8313",
        "C8314",
        "C8315",
        "C8316",
        "C8317",
        "C8318",
        "C8319",
        "C8330",
        "C8331",
        "C8332",
        "C8333",
        "C8334",
        "C8335",
        "C8336",
        "C8337",
        "C8338",
        "C8339",
        "C8350",
        "C8351",
        "C8352",
        "C8353",
        "C8354",
        "C8355",
        "C8356",
        "C8357",
        "C8358",
        "C8359",
        "C8370",
        "C8371",
        "C8372",
        "C8373",
        "C8374",
        "C8375",
        "C8376",
        "C8377",
        "C8378",
        "C8379",
        "C8380",
        "C8381",
        "C8382",
        "C8383",
        "C8384",
        "C8385",
        "C8386",
        "C8387",
        "C8388",
        "C8389",
        "C8390",
        "C8391",
        "C8392",
        "C8393",
        "C8394",
        "C8395",
        "C8396",
        "C8397",
        "C8398",
        "C8399",
        "C8400",
        "C8401",
        "C8402",
        "C8403",
        "C8404",
        "C8405",
        "C8406",
        "C8407",
        "C8408",
        "C8409",
        "C8410",
        "C8411",
        "C8412",
        "C8413",
        "C8414",
        "C8415",
        "C8416",
        "C8417",
        "C8418",
        "C8419",
        "C8440",
        "C8441",
        "C8442",
        "C8443",
        "C8444",
        "C8445",
        "C8446",
        "C8447",
        "C8448",
        "C8449",
        "C8460",
        "C8461",
        "C8462",
        "C8463",
        "C8464",
        "C8465",
        "C8466",
        "C8467",
        "C8468",
        "C8469",
        "C8470",
        "C8471",
        "C8472",
        "C8473",
        "C8474",
        "C8475",
        "C8476",
        "C8477",
        "C8478",
        "C8479",
        "C8490",
        "C8491",
        "C8492",
        "C8493",
        "C8494",
        "C8495",
        "C8496",
        "C8497",
        "C8498",
        "C8499",
        "C84A0",
        "C84A1",
        "C84A2",
        "C84A3",
        "C84A4",
        "C84A5",
        "C84A6",
        "C84A7",
        "C84A8",
        "C84A9",
        "C84Z0",
        "C84Z1",
        "C84Z2",
        "C84Z3",
        "C84Z4",
        "C84Z5",
        "C84Z6",
        "C84Z7",
        "C84Z8",
        "C84Z9",
        "C8510",
        "C8511",
        "C8512",
        "C8513",
        "C8514",
        "C8515",
        "C8516",
        "C8517",
        "C8518",
        "C8519",
        "C8520",
        "C8521",
        "C8522",
        "C8523",
        "C8524",
        "C8525",
        "C8526",
        "C8527",
        "C8528",
        "C8529",
        "C8580",
        "C8581",
        "C8582",
        "C8583",
        "C8584",
        "C8585",
        "C8586",
        "C8587",
        "C8588",
        "C8589",
        "C8590",
        "C8591",
        "C8592",
        "C8593",
        "C8594",
        "C8595",
        "C8596",
        "C8597",
        "C8598",
        "C8599",
        "C860",
        "C861",
        "C862",
        "C863",
        "C864",
        "C865",
        "C866",
        "C882",
        "C883",
        "C884",
        "C888",
        "C889",
        "C9030",
        "C9031",
        "C9032",
        "C9110",
        "C9111",
        "C9112",
        "C9130",
        "C9131",
        "C9132",
        "C9140",
        "C9141",
        "C9142",
        "C9150",
        "C9151",
        "C9152",
        "C9160",
        "C9161",
        "C9162",
        "C9190",
        "C9191",
        "C9192",
        "C91A0",
        "C91A1",
        "C91A2",
        "C91Z0",
        "C91Z1",
        "C91Z2",
        "C9510",
        "C9511",
        "C9512",
        "C9590",
        "C9591",
        "C9592",
        "C960",
        "C962",
        "C964",
        "C965",
        "C966",
        "C969",
        "C96A",
        "C96Z",
        "C01",
        "C020",
        "C021",
        "C022",
        "C023",
        "C024",
        "C028",
        "C029",
        "C030",
        "C031",
        "C039",
        "C040",
        "C041",
        "C048",
        "C049",
        "C050",
        "C051",
        "C052",
        "C058",
        "C059",
        "C060",
        "C061",
        "C062",
        "C0680",
        "C0689",
        "C069",
        "C07",
        "C080",
        "C081",
        "C089",
        "C090",
        "C091",
        "C098",
        "C099",
        "C100",
        "C101",
        "C102",
        "C103",
        "C104",
        "C108",
        "C109",
        "C110",
        "C111",
        "C112",
        "C113",
        "C118",
        "C119",
        "C12",
        "C130",
        "C131",
        "C132",
        "C138",
        "C139",
        "C140",
        "C142",
        "C148",
        "C180",
        "C181",
        "C182",
        "C183",
        "C184",
        "C185",
        "C186",
        "C187",
        "C188",
        "C189",
        "C19",
        "C20",
        "C210",
        "C211",
        "C212",
        "C218",
        "C260",
        "C261",
        "C269",
        "C300",
        "C301",
        "C310",
        "C311",
        "C312",
        "C313",
        "C318",
        "C319",
        "C320",
        "C321",
        "C322",
        "C323",
        "C328",
        "C329",
        "C37",
        "C380",
        "C381",
        "C382",
        "C383",
        "C388",
        "C390",
        "C399",
        "C510",
        "C511",
        "C512",
        "C518",
        "C519",
        "C52",
        "C530",
        "C531",
        "C538",
        "C539",
        "C577",
        "C578",
        "C579",
        "C641",
        "C642",
        "C649",
        "C651",
        "C652",
        "C659",
        "C661",
        "C662",
        "C669",
        "C670",
        "C671",
        "C672",
        "C673",
        "C674",
        "C675",
        "C676",
        "C677",
        "C678",
        "C679",
        "C680",
        "C681",
        "C688",
        "C689",
        "C430",
        "C4310",
        "C4311",
        "C4312",
        "C4320",
        "C4321",
        "C4322",
        "C4330",
        "C4331",
        "C4339",
        "C434",
        "C4351",
        "C4352",
        "C4359",
        "C4360",
        "C4361",
        "C4362",
        "C4370",
        "C4371",
        "C4372",
        "C438",
        "C439",
        "C4A0",
        "C4A10",
        "C4A11",
        "C4A12",
        "C4A20",
        "C4A21",
        "C4A22",
        "C4A30",
        "C4A31",
        "C4A39",
        "C4A4",
        "C4A51",
        "C4A52",
        "C4A59",
        "C4A60",
        "C4A61",
        "C4A62",
        "C4A70",
        "C4A71",
        "C4A72",
        "C4A8",
        "C4A9",
        "C50011",
        "C50012",
        "C50019",
        "C50021",
        "C50022",
        "C50029",
        "C50111",
        "C50112",
        "C50119",
        "C50121",
        "C50122",
        "C50129",
        "C50211",
        "C50212",
        "C50219",
        "C50221",
        "C50222",
        "C50229",
        "C50311",
        "C50312",
        "C50319",
        "C50321",
        "C50322",
        "C50329",
        "C50411",
        "C50412",
        "C50419",
        "C50421",
        "C50422",
        "C50429",
        "C50511",
        "C50512",
        "C50519",
        "C50521",
        "C50522",
        "C50529",
        "C50611",
        "C50612",
        "C50619",
        "C50621",
        "C50622",
        "C50629",
        "C50811",
        "C50812",
        "C50819",
        "C50821",
        "C50822",
        "C50829",
        "C50911",
        "C50912",
        "C50919",
        "C50921",
        "C50922",
        "C50929",
        "C540",
        "C541",
        "C542",
        "C543",
        "C548",
        "C549",
        "C55",
        "C600",
        "C601",
        "C602",
        "C608",
        "C609",
        "C61",
        "C6200",
        "C6201",
        "C6202",
        "C6210",
        "C6211",
        "C6212",
        "C6290",
        "C6291",
        "C6292",
        "C6300",
        "C6301",
        "C6302",
        "C6310",
        "C6311",
        "C6312",
        "C632",
        "C637",
        "C638",
        "C639",
        "C6900",
        "C6901",
        "C6902",
        "C6910",
        "C6911",
        "C6912",
        "C6920",
        "C6921",
        "C6922",
        "C6930",
        "C6931",
        "C6932",
        "C6940",
        "C6941",
        "C6942",
        "C6950",
        "C6951",
        "C6952",
        "C6960",
        "C6961",
        "C6962",
        "C6980",
        "C6981",
        "C6982",
        "C6990",
        "C6991",
        "C6992",
        "C73",
        "C750",
        "C754",
        "C755",
        "C758",
        "C759",
        "C760",
        "C761",
        "C762",
        "C763",
        "C7640",
        "C7641",
        "C7642",
        "C7650",
        "C7651",
        "C7652",
        "C768",
        "C7A00",
        "C7A010",
        "C7A011",
        "C7A012",
        "C7A019",
        "C7A020",
        "C7A021",
        "C7A022",
        "C7A023",
        "C7A024",
        "C7A025",
        "C7A026",
        "C7A029",
        "C7A090",
        "C7A091",
        "C7A092",
        "C7A093",
        "C7A094",
        "C7A095",
        "C7A096",
        "C7A098",
        "C7A1",
        "C7A8",
        "C801",
        "C802",
        "D030",
        "D0310",
        "D0311",
        "D0312",
        "D0320",
        "D0321",
        "D0322",
        "D0330",
        "D0339",
        "D034",
        "D0351",
        "D0352",
        "D0359",
        "D0360",
        "D0361",
        "D0362",
        "D0370",
        "D0371",
        "D0372",
        "D038",
        "D039",
        "D1802",
        "D320",
        "D321",
        "D329",
        "D330",
        "D331",
        "D332",
        "D333",
        "D334",
        "D337",
        "D339",
        "D352",
        "D353",
        "D354",
        "D420",
        "D421",
        "D429",
        "D430",
        "D431",
        "D432",
        "D433",
        "D434",
        "D438",
        "D439",
        "D443",
        "D444",
        "D445",
        "D446",
        "D447",
        "D496",
        "E340",
        "Q8500",
        "Q8501",
        "Q8502",
        "Q8503",
        "Q8509",
        "Q851",
        "Q858",
        "Q859",
        "E0800",
        "E0801",
        "E0810",
        "E0811",
        "E08641",
        "E0900",
        "E0901",
        "E0910",
        "E0911",
        "E09641",
        "E1010",
        "E1011",
        "E10641",
        "E1100",
        "E1101",
        "E11641",
        "E1300",
        "E1301",
        "E1310",
        "E1311",
        "E13641",
        "E0821",
        "E0822",
        "E0829",
        "E08311",
        "E08319",
        "E08321",
        "E083211",
        "E083212",
        "E083213",
        "E083219",
        "E08329",
        "E083291",
        "E083292",
        "E083293",
        "E083299",
        "E08331",
        "E083311",
        "E083312",
        "E083313",
        "E083319",
        "E08339",
        "E083391",
        "E083392",
        "E083393",
        "E083399",
        "E08341",
        "E083411",
        "E083412",
        "E083413",
        "E083419",
        "E08349",
        "E083491",
        "E083492",
        "E083493",
        "E083499",
        "E08351",
        "E083511",
        "E083512",
        "E083513",
        "E083519",
        "E083521",
        "E083522",
        "E083523",
        "E083529",
        "E083531",
        "E083532",
        "E083533",
        "E083539",
        "E083541",
        "E083542",
        "E083543",
        "E083549",
        "E083551",
        "E083552",
        "E083553",
        "E083559",
        "E08359",
        "E083591",
        "E083592",
        "E083593",
        "E083599",
        "E0836",
        "E0837X1",
        "E0837X2",
        "E0837X3",
        "E0837X9",
        "E0839",
        "E0840",
        "E0841",
        "E0842",
        "E0843",
        "E0844",
        "E0849",
        "E0851",
        "E0852",
        "E0859",
        "E08610",
        "E08618",
        "E08620",
        "E08621",
        "E08622",
        "E08628",
        "E08630",
        "E08638",
        "E08649",
        "E0865",
        "E0869",
        "E088",
        "E0921",
        "E0922",
        "E0929",
        "E09311",
        "E09319",
        "E09321",
        "E093211",
        "E093212",
        "E093213",
        "E093219",
        "E09329",
        "E093291",
        "E093292",
        "E093293",
        "E093299",
        "E09331",
        "E093311",
        "E093312",
        "E093313",
        "E093319",
        "E09339",
        "E093391",
        "E093392",
        "E093393",
        "E093399",
        "E09341",
        "E093411",
        "E093412",
        "E093413",
        "E093419",
        "E09349",
        "E093491",
        "E093492",
        "E093493",
        "E093499",
        "E09351",
        "E093511",
        "E093512",
        "E093513",
        "E093519",
        "E093521",
        "E093522",
        "E093523",
        "E093529",
        "E093531",
        "E093532",
        "E093533",
        "E093539",
        "E093541",
        "E093542",
        "E093543",
        "E093549",
        "E093551",
        "E093552",
        "E093553",
        "E093559",
        "E09359",
        "E093591",
        "E093592",
        "E093593",
        "E093599",
        "E0936",
        "E0937X1",
        "E0937X2",
        "E0937X3",
        "E0937X9",
        "E0939",
        "E0940",
        "E0941",
        "E0942",
        "E0943",
        "E0944",
        "E0949",
        "E0951",
        "E0952",
        "E0959",
        "E09610",
        "E09618",
        "E09620",
        "E09621",
        "E09622",
        "E09628",
        "E09630",
        "E09638",
        "E09649",
        "E0965",
        "E0969",
        "E098",
        "E1021",
        "E1022",
        "E1029",
        "E10311",
        "E10319",
        "E10321",
        "E103211",
        "E103212",
        "E103213",
        "E103219",
        "E10329",
        "E103291",
        "E103292",
        "E103293",
        "E103299",
        "E10331",
        "E103311",
        "E103312",
        "E103313",
        "E103319",
        "E10339",
        "E103391",
        "E103392",
        "E103393",
        "E103399",
        "E10341",
        "E103411",
        "E103412",
        "E103413",
        "E103419",
        "E10349",
        "E103491",
        "E103492",
        "E103493",
        "E103499",
        "E10351",
        "E103511",
        "E103512",
        "E103513",
        "E103519",
        "E103521",
        "E103522",
        "E103523",
        "E103529",
        "E103531",
        "E103532",
        "E103533",
        "E103539",
        "E103541",
        "E103542",
        "E103543",
        "E103549",
        "E103551",
        "E103552",
        "E103553",
        "E103559",
        "E10359",
        "E103591",
        "E103592",
        "E103593",
        "E103599",
        "E1036",
        "E1037X1",
        "E1037X2",
        "E1037X3",
        "E1037X9",
        "E1039",
        "E1040",
        "E1041",
        "E1042",
        "E1043",
        "E1044",
        "E1049",
        "E1051",
        "E1052",
        "E1059",
        "E10610",
        "E10618",
        "E10620",
        "E10621",
        "E10622",
        "E10628",
        "E10630",
        "E10638",
        "E10649",
        "E1065",
        "E1069",
        "E108",
        "E1121",
        "E1122",
        "E1129",
        "E11311",
        "E11319",
        "E11321",
        "E113211",
        "E113212",
        "E113213",
        "E113219",
        "E11329",
        "E113291",
        "E113292",
        "E113293",
        "E113299",
        "E11331",
        "E113311",
        "E113312",
        "E113313",
        "E113319",
        "E11339",
        "E113391",
        "E113392",
        "E113393",
        "E113399",
        "E11341",
        "E113411",
        "E113412",
        "E113413",
        "E113419",
        "E11349",
        "E113491",
        "E113492",
        "E113493",
        "E113499",
        "E11351",
        "E113511",
        "E113512",
        "E113513",
        "E113519",
        "E113521",
        "E113522",
        "E113523",
        "E113529",
        "E113531",
        "E113532",
        "E113533",
        "E113539",
        "E113541",
        "E113542",
        "E113543",
        "E113549",
        "E113551",
        "E113552",
        "E113553",
        "E113559",
        "E11359",
        "E113591",
        "E113592",
        "E113593",
        "E113599",
        "E1136",
        "E1137X1",
        "E1137X2",
        "E1137X3",
        "E1137X9",
        "E1139",
        "E1140",
        "E1141",
        "E1142",
        "E1143",
        "E1144",
        "E1149",
        "E1151",
        "E1152",
        "E1159",
        "E11610",
        "E11618",
        "E11620",
        "E11621",
        "E11622",
        "E11628",
        "E11630",
        "E11638",
        "E11649",
        "E1165",
        "E1169",
        "E118",
        "E1321",
        "E1322",
        "E1329",
        "E13311",
        "E13319",
        "E13321",
        "E133211",
        "E133212",
        "E133213",
        "E133219",
        "E13329",
        "E133291",
        "E133292",
        "E133293",
        "E133299",
        "E13331",
        "E133311",
        "E133312",
        "E133313",
        "E133319",
        "E13339",
        "E133391",
        "E133392",
        "E133393",
        "E133399",
        "E13341",
        "E133411",
        "E133412",
        "E133413",
        "E133419",
        "E13349",
        "E133491",
        "E133492",
        "E133493",
        "E133499",
        "E13351",
        "E133511",
        "E133512",
        "E133513",
        "E133519",
        "E133521",
        "E133522",
        "E133523",
        "E133529",
        "E133531",
        "E133532",
        "E133533",
        "E133539",
        "E133541",
        "E133542",
        "E133543",
        "E133549",
        "E133551",
        "E133552",
        "E133553",
        "E133559",
        "E13359",
        "E133591",
        "E133592",
        "E133593",
        "E133599",
        "E1336",
        "E1337X1",
        "E1337X2",
        "E1337X3",
        "E1337X9",
        "E1339",
        "E1340",
        "E1341",
        "E1342",
        "E1343",
        "E1344",
        "E1349",
        "E1351",
        "E1352",
        "E1359",
        "E13610",
        "E13618",
        "E13620",
        "E13621",
        "E13622",
        "E13628",
        "E13630",
        "E13638",
        "E13649",
        "E1365",
        "E1369",
        "E138",
        "E089",
        "E099",
        "E109",
        "E119",
        "E139",
        "Z794",
        "E40",
        "E41",
        "E42",
        "E43",
        "E440",
        "E441",
        "E45",
        "E46",
        "E640",
        "R64",
        "E6601",
        "E662",
        "Z6841",
        "Z6842",
        "Z6843",
        "Z6844",
        "Z6845",
        "A391",
        "C880",
        "D841",
        "D891",
        "E035",
        "E15",
        "E200",
        "E208",
        "E209",
        "E210",
        "E211",
        "E212",
        "E213",
        "E214",
        "E215",
        "E220",
        "E221",
        "E222",
        "E228",
        "E229",
        "E230",
        "E231",
        "E232",
        "E233",
        "E236",
        "E237",
        "E240",
        "E241",
        "E242",
        "E243",
        "E244",
        "E248",
        "E249",
        "E250",
        "E258",
        "E259",
        "E2601",
        "E2602",
        "E2609",
        "E261",
        "E2681",
        "E2689",
        "E269",
        "E270",
        "E271",
        "E272",
        "E273",
        "E2740",
        "E2749",
        "E275",
        "E278",
        "E279",
        "E310",
        "E311",
        "E3120",
        "E3121",
        "E3122",
        "E3123",
        "E318",
        "E319",
        "E320",
        "E321",
        "E328",
        "E329",
        "E344",
        "E700",
        "E701",
        "E7020",
        "E7021",
        "E7029",
        "E7030",
        "E70310",
        "E70311",
        "E70318",
        "E70319",
        "E70320",
        "E70321",
        "E70328",
        "E70329",
        "E70330",
        "E70331",
        "E70338",
        "E70339",
        "E7039",
        "E7040",
        "E7041",
        "E7049",
        "E705",
        "E708",
        "E709",
        "E710",
        "E71110",
        "E71111",
        "E71118",
        "E71120",
        "E71121",
        "E71128",
        "E7119",
        "E712",
        "E71310",
        "E71311",
        "E71312",
        "E71313",
        "E71314",
        "E71318",
        "E7132",
        "E7139",
        "E7140",
        "E7141",
        "E7142",
        "E7143",
        "E71440",
        "E71448",
        "E7150",
        "E71510",
        "E71511",
        "E71518",
        "E71520",
        "E71521",
        "E71522",
        "E71528",
        "E71529",
        "E7153",
        "E71540",
        "E71541",
        "E71542",
        "E71548",
        "E7200",
        "E7201",
        "E7202",
        "E7203",
        "E7204",
        "E7209",
        "E7210",
        "E7211",
        "E7212",
        "E7219",
        "E7220",
        "E7221",
        "E7222",
        "E7223",
        "E7229",
        "E723",
        "E724",
        "E7250",
        "E7251",
        "E7252",
        "E7253",
        "E7259",
        "E728",
        "E729",
        "E7400",
        "E7401",
        "E7402",
        "E7403",
        "E7404",
        "E7409",
        "E7420",
        "E7421",
        "E7429",
        "E744",
        "E748",
        "E749",
        "E7521",
        "E7522",
        "E75240",
        "E75241",
        "E75242",
        "E75243",
        "E75248",
        "E75249",
        "E753",
        "E7601",
        "E7602",
        "E7603",
        "E761",
        "E76210",
        "E76211",
        "E76219",
        "E7622",
        "E7629",
        "E763",
        "E768",
        "E769",
        "E770",
        "E771",
        "E778",
        "E779",
        "E791",
        "E792",
        "E798",
        "E799",
        "E800",
        "E801",
        "E8020",
        "E8021",
        "E8029",
        "E803",
        "E83110",
        "E850",
        "E851",
        "E852",
        "E853",
        "E854",
        "E858",
        "E859",
        "E8801",
        "E8840",
        "E8841",
        "E8842",
        "E8849",
        "E8889",
        "E892",
        "E893",
        "E896",
        "H49811",
        "H49812",
        "H49813",
        "H49819",
        "N251",
        "N2581",
        "I8500",
        "I8501",
        "I8510",
        "I8511",
        "K7041",
        "K7111",
        "K7201",
        "K7210",
        "K7211",
        "K7290",
        "K7291",
        "K766",
        "K767",
        "K7681",
        "K7030",
        "K7031",
        "K7040",
        "K709",
        "K743",
        "K744",
        "K745",
        "K7460",
        "K7469",
        "B180",
        "B181",
        "B182",
        "B188",
        "B189",
        "K730",
        "K731",
        "K732",
        "K738",
        "K739",
        "K754",
        "A5485",
        "K251",
        "K252",
        "K255",
        "K256",
        "K261",
        "K262",
        "K265",
        "K266",
        "K271",
        "K272",
        "K275",
        "K276",
        "K281",
        "K282",
        "K285",
        "K286",
        "K50012",
        "K50112",
        "K50812",
        "K50912",
        "K51012",
        "K51212",
        "K51312",
        "K51412",
        "K51512",
        "K51812",
        "K51912",
        "K560",
        "K561",
        "K562",
        "K563",
        "K5641",
        "K5649",
        "K565",
        "K5660",
        "K5669",
        "K567",
        "K5931",
        "K631",
        "K650",
        "K651",
        "K652",
        "K653",
        "K654",
        "K658",
        "K659",
        "K67",
        "K6812",
        "K6819",
        "K860",
        "K861",
        "K5000",
        "K50011",
        "K50013",
        "K50014",
        "K50018",
        "K50019",
        "K5010",
        "K50111",
        "K50113",
        "K50114",
        "K50118",
        "K50119",
        "K5080",
        "K50811",
        "K50813",
        "K50814",
        "K50818",
        "K50819",
        "K5090",
        "K50911",
        "K50913",
        "K50914",
        "K50918",
        "K50919",
        "K5100",
        "K51011",
        "K51013",
        "K51014",
        "K51018",
        "K51019",
        "K5120",
        "K51211",
        "K51213",
        "K51214",
        "K51218",
        "K51219",
        "K5130",
        "K51311",
        "K51313",
        "K51314",
        "K51318",
        "K51319",
        "K5140",
        "K51411",
        "K51413",
        "K51414",
        "K51418",
        "K51419",
        "K5150",
        "K51511",
        "K51513",
        "K51514",
        "K51518",
        "K51519",
        "K5180",
        "K51811",
        "K51813",
        "K51814",
        "K51818",
        "K51819",
        "K5190",
        "K51911",
        "K51913",
        "K51914",
        "K51918",
        "K51919",
        "A0104",
        "A0105",
        "A0223",
        "A0224",
        "A3983",
        "A3984",
        "A5055",
        "A5440",
        "A5441",
        "A5442",
        "A5443",
        "A5449",
        "A666",
        "A6923",
        "B0682",
        "B2685",
        "B4282",
        "M0000",
        "M00011",
        "M00012",
        "M00019",
        "M00021",
        "M00022",
        "M00029",
        "M00031",
        "M00032",
        "M00039",
        "M00041",
        "M00042",
        "M00049",
        "M00051",
        "M00052",
        "M00059",
        "M00061",
        "M00062",
        "M00069",
        "M00071",
        "M00072",
        "M00079",
        "M0008",
        "M0009",
        "M0010",
        "M00111",
        "M00112",
        "M00119",
        "M00121",
        "M00122",
        "M00129",
        "M00131",
        "M00132",
        "M00139",
        "M00141",
        "M00142",
        "M00149",
        "M00151",
        "M00152",
        "M00159",
        "M00161",
        "M00162",
        "M00169",
        "M00171",
        "M00172",
        "M00179",
        "M0018",
        "M0019",
        "M0020",
        "M00211",
        "M00212",
        "M00219",
        "M00221",
        "M00222",
        "M00229",
        "M00231",
        "M00232",
        "M00239",
        "M00241",
        "M00242",
        "M00249",
        "M00251",
        "M00252",
        "M00259",
        "M00261",
        "M00262",
        "M00269",
        "M00271",
        "M00272",
        "M00279",
        "M0028",
        "M0029",
        "M0080",
        "M00811",
        "M00812",
        "M00819",
        "M00821",
        "M00822",
        "M00829",
        "M00831",
        "M00832",
        "M00839",
        "M00841",
        "M00842",
        "M00849",
        "M00851",
        "M00852",
        "M00859",
        "M00861",
        "M00862",
        "M00869",
        "M00871",
        "M00872",
        "M00879",
        "M0088",
        "M0089",
        "M009",
        "M01X0",
        "M01X11",
        "M01X12",
        "M01X19",
        "M01X21",
        "M01X22",
        "M01X29",
        "M01X31",
        "M01X32",
        "M01X39",
        "M01X41",
        "M01X42",
        "M01X49",
        "M01X51",
        "M01X52",
        "M01X59",
        "M01X61",
        "M01X62",
        "M01X69",
        "M01X71",
        "M01X72",
        "M01X79",
        "M01X8",
        "M01X9",
        "M0210",
        "M02111",
        "M02112",
        "M02119",
        "M02121",
        "M02122",
        "M02129",
        "M02131",
        "M02132",
        "M02139",
        "M02141",
        "M02142",
        "M02149",
        "M02151",
        "M02152",
        "M02159",
        "M02161",
        "M02162",
        "M02169",
        "M02171",
        "M02172",
        "M02179",
        "M0218",
        "M0219",
        "M0280",
        "M02811",
        "M02812",
        "M02819",
        "M02821",
        "M02822",
        "M02829",
        "M02831",
        "M02832",
        "M02839",
        "M02841",
        "M02842",
        "M02849",
        "M02851",
        "M02852",
        "M02859",
        "M02861",
        "M02862",
        "M02869",
        "M02871",
        "M02872",
        "M02879",
        "M0288",
        "M0289",
        "M029",
        "M4620",
        "M4621",
        "M4622",
        "M4623",
        "M4624",
        "M4625",
        "M4626",
        "M4627",
        "M4628",
        "M4630",
        "M4631",
        "M4632",
        "M4633",
        "M4634",
        "M4635",
        "M4636",
        "M4637",
        "M4638",
        "M4639",
        "M726",
        "M8600",
        "M86011",
        "M86012",
        "M86019",
        "M86021",
        "M86022",
        "M86029",
        "M86031",
        "M86032",
        "M86039",
        "M86041",
        "M86042",
        "M86049",
        "M86051",
        "M86052",
        "M86059",
        "M86061",
        "M86062",
        "M86069",
        "M86071",
        "M86072",
        "M86079",
        "M8608",
        "M8609",
        "M8610",
        "M86111",
        "M86112",
        "M86119",
        "M86121",
        "M86122",
        "M86129",
        "M86131",
        "M86132",
        "M86139",
        "M86141",
        "M86142",
        "M86149",
        "M86151",
        "M86152",
        "M86159",
        "M86161",
        "M86162",
        "M86169",
        "M86171",
        "M86172",
        "M86179",
        "M8618",
        "M8619",
        "M8620",
        "M86211",
        "M86212",
        "M86219",
        "M86221",
        "M86222",
        "M86229",
        "M86231",
        "M86232",
        "M86239",
        "M86241",
        "M86242",
        "M86249",
        "M86251",
        "M86252",
        "M86259",
        "M86261",
        "M86262",
        "M86269",
        "M86271",
        "M86272",
        "M86279",
        "M8628",
        "M8629",
        "M8630",
        "M86311",
        "M86312",
        "M86319",
        "M86321",
        "M86322",
        "M86329",
        "M86331",
        "M86332",
        "M86339",
        "M86341",
        "M86342",
        "M86349",
        "M86351",
        "M86352",
        "M86359",
        "M86361",
        "M86362",
        "M86369",
        "M86371",
        "M86372",
        "M86379",
        "M8638",
        "M8639",
        "M8640",
        "M86411",
        "M86412",
        "M86419",
        "M86421",
        "M86422",
        "M86429",
        "M86431",
        "M86432",
        "M86439",
        "M86441",
        "M86442",
        "M86449",
        "M86451",
        "M86452",
        "M86459",
        "M86461",
        "M86462",
        "M86469",
        "M86471",
        "M86472",
        "M86479",
        "M8648",
        "M8649",
        "M8650",
        "M86511",
        "M86512",
        "M86519",
        "M86521",
        "M86522",
        "M86529",
        "M86531",
        "M86532",
        "M86539",
        "M86541",
        "M86542",
        "M86549",
        "M86551",
        "M86552",
        "M86559",
        "M86561",
        "M86562",
        "M86569",
        "M86571",
        "M86572",
        "M86579",
        "M8658",
        "M8659",
        "M8660",
        "M86611",
        "M86612",
        "M86619",
        "M86621",
        "M86622",
        "M86629",
        "M86631",
        "M86632",
        "M86639",
        "M86641",
        "M86642",
        "M86649",
        "M86651",
        "M86652",
        "M86659",
        "M86661",
        "M86662",
        "M86669",
        "M86671",
        "M86672",
        "M86679",
        "M8668",
        "M8669",
        "M868X0",
        "M868X1",
        "M868X2",
        "M868X3",
        "M868X4",
        "M868X5",
        "M868X6",
        "M868X7",
        "M868X8",
        "M868X9",
        "M869",
        "M8700",
        "M87011",
        "M87012",
        "M87019",
        "M87021",
        "M87022",
        "M87029",
        "M87031",
        "M87032",
        "M87033",
        "M87034",
        "M87035",
        "M87036",
        "M87037",
        "M87038",
        "M87039",
        "M87041",
        "M87042",
        "M87043",
        "M87044",
        "M87045",
        "M87046",
        "M87050",
        "M87051",
        "M87052",
        "M87059",
        "M87061",
        "M87062",
        "M87063",
        "M87064",
        "M87065",
        "M87066",
        "M87071",
        "M87072",
        "M87073",
        "M87074",
        "M87075",
        "M87076",
        "M87077",
        "M87078",
        "M87079",
        "M8708",
        "M8709",
        "M8710",
        "M87111",
        "M87112",
        "M87119",
        "M87121",
        "M87122",
        "M87129",
        "M87131",
        "M87132",
        "M87133",
        "M87134",
        "M87135",
        "M87136",
        "M87137",
        "M87138",
        "M87139",
        "M87141",
        "M87142",
        "M87143",
        "M87144",
        "M87145",
        "M87146",
        "M87150",
        "M87151",
        "M87152",
        "M87159",
        "M87161",
        "M87162",
        "M87163",
        "M87164",
        "M87165",
        "M87166",
        "M87171",
        "M87172",
        "M87173",
        "M87174",
        "M87175",
        "M87176",
        "M87177",
        "M87178",
        "M87179",
        "M87180",
        "M87188",
        "M8719",
        "M8720",
        "M87211",
        "M87212",
        "M87219",
        "M87221",
        "M87222",
        "M87229",
        "M87231",
        "M87232",
        "M87233",
        "M87234",
        "M87235",
        "M87236",
        "M87237",
        "M87238",
        "M87239",
        "M87241",
        "M87242",
        "M87243",
        "M87244",
        "M87245",
        "M87246",
        "M87250",
        "M87251",
        "M87252",
        "M87256",
        "M87261",
        "M87262",
        "M87263",
        "M87264",
        "M87265",
        "M87266",
        "M87271",
        "M87272",
        "M87273",
        "M87274",
        "M87275",
        "M87276",
        "M87277",
        "M87278",
        "M87279",
        "M8728",
        "M8729",
        "M8730",
        "M87311",
        "M87312",
        "M87319",
        "M87321",
        "M87322",
        "M87329",
        "M87331",
        "M87332",
        "M87333",
        "M87334",
        "M87335",
        "M87336",
        "M87337",
        "M87338",
        "M87339",
        "M87341",
        "M87342",
        "M87343",
        "M87344",
        "M87345",
        "M87346",
        "M87350",
        "M87351",
        "M87352",
        "M87353",
        "M87361",
        "M87362",
        "M87363",
        "M87364",
        "M87365",
        "M87366",
        "M87371",
        "M87372",
        "M87373",
        "M87374",
        "M87375",
        "M87376",
        "M87377",
        "M87378",
        "M87379",
        "M8738",
        "M8739",
        "M8780",
        "M87811",
        "M87812",
        "M87819",
        "M87821",
        "M87822",
        "M87829",
        "M87831",
        "M87832",
        "M87833",
        "M87834",
        "M87835",
        "M87836",
        "M87837",
        "M87838",
        "M87839",
        "M87841",
        "M87842",
        "M87843",
        "M87844",
        "M87845",
        "M87849",
        "M87850",
        "M87851",
        "M87852",
        "M87859",
        "M87861",
        "M87862",
        "M87863",
        "M87864",
        "M87865",
        "M87869",
        "M87871",
        "M87872",
        "M87873",
        "M87874",
        "M87875",
        "M87876",
        "M87877",
        "M87878",
        "M87879",
        "M8788",
        "M8789",
        "M879",
        "M8960",
        "M89611",
        "M89612",
        "M89619",
        "M89621",
        "M89622",
        "M89629",
        "M89631",
        "M89632",
        "M89639",
        "M89641",
        "M89642",
        "M89649",
        "M89651",
        "M89652",
        "M89659",
        "M89661",
        "M89662",
        "M89669",
        "M89671",
        "M89672",
        "M89679",
        "M8968",
        "M8969",
        "M9050",
        "M90511",
        "M90512",
        "M90519",
        "M90521",
        "M90522",
        "M90529",
        "M90531",
        "M90532",
        "M90539",
        "M90541",
        "M90542",
        "M90549",
        "M90551",
        "M90552",
        "M90559",
        "M90561",
        "M90562",
        "M90569",
        "M90571",
        "M90572",
        "M90579",
        "M9058",
        "M9059",
        "L4050",
        "L4051",
        "L4052",
        "L4053",
        "L4054",
        "L4059",
        "M0230",
        "M02311",
        "M02312",
        "M02319",
        "M02321",
        "M02322",
        "M02329",
        "M02331",
        "M02332",
        "M02339",
        "M02341",
        "M02342",
        "M02349",
        "M02351",
        "M02352",
        "M02359",
        "M02361",
        "M02362",
        "M02369",
        "M02371",
        "M02372",
        "M02379",
        "M0238",
        "M0239",
        "M041",
        "M042",
        "M048",
        "M049",
        "M0500",
        "M05011",
        "M05012",
        "M05019",
        "M05021",
        "M05022",
        "M05029",
        "M05031",
        "M05032",
        "M05039",
        "M05041",
        "M05042",
        "M05049",
        "M05051",
        "M05052",
        "M05059",
        "M05061",
        "M05062",
        "M05069",
        "M05071",
        "M05072",
        "M05079",
        "M0509",
        "M0510",
        "M05111",
        "M05112",
        "M05119",
        "M05121",
        "M05122",
        "M05129",
        "M05131",
        "M05132",
        "M05139",
        "M05141",
        "M05142",
        "M05149",
        "M05151",
        "M05152",
        "M05159",
        "M05161",
        "M05162",
        "M05169",
        "M05171",
        "M05172",
        "M05179",
        "M0519",
        "M0520",
        "M05211",
        "M05212",
        "M05219",
        "M05221",
        "M05222",
        "M05229",
        "M05231",
        "M05232",
        "M05239",
        "M05241",
        "M05242",
        "M05249",
        "M05251",
        "M05252",
        "M05259",
        "M05261",
        "M05262",
        "M05269",
        "M05271",
        "M05272",
        "M05279",
        "M0529",
        "M0530",
        "M05311",
        "M05312",
        "M05319",
        "M05321",
        "M05322",
        "M05329",
        "M05331",
        "M05332",
        "M05339",
        "M05341",
        "M05342",
        "M05349",
        "M05351",
        "M05352",
        "M05359",
        "M05361",
        "M05362",
        "M05369",
        "M05371",
        "M05372",
        "M05379",
        "M0539",
        "M0540",
        "M05411",
        "M05412",
        "M05419",
        "M05421",
        "M05422",
        "M05429",
        "M05431",
        "M05432",
        "M05439",
        "M05441",
        "M05442",
        "M05449",
        "M05451",
        "M05452",
        "M05459",
        "M05461",
        "M05462",
        "M05469",
        "M05471",
        "M05472",
        "M05479",
        "M0549",
        "M0550",
        "M05511",
        "M05512",
        "M05519",
        "M05521",
        "M05522",
        "M05529",
        "M05531",
        "M05532",
        "M05539",
        "M05541",
        "M05542",
        "M05549",
        "M05551",
        "M05552",
        "M05559",
        "M05561",
        "M05562",
        "M05569",
        "M05571",
        "M05572",
        "M05579",
        "M0559",
        "M0560",
        "M05611",
        "M05612",
        "M05619",
        "M05621",
        "M05622",
        "M05629",
        "M05631",
        "M05632",
        "M05639",
        "M05641",
        "M05642",
        "M05649",
        "M05651",
        "M05652",
        "M05659",
        "M05661",
        "M05662",
        "M05669",
        "M05671",
        "M05672",
        "M05679",
        "M0569",
        "M0570",
        "M05711",
        "M05712",
        "M05719",
        "M05721",
        "M05722",
        "M05729",
        "M05731",
        "M05732",
        "M05739",
        "M05741",
        "M05742",
        "M05749",
        "M05751",
        "M05752",
        "M05759",
        "M05761",
        "M05762",
        "M05769",
        "M05771",
        "M05772",
        "M05779",
        "M0579",
        "M0580",
        "M05811",
        "M05812",
        "M05819",
        "M05821",
        "M05822",
        "M05829",
        "M05831",
        "M05832",
        "M05839",
        "M05841",
        "M05842",
        "M05849",
        "M05851",
        "M05852",
        "M05859",
        "M05861",
        "M05862",
        "M05869",
        "M05871",
        "M05872",
        "M05879",
        "M0589",
        "M059",
        "M0600",
        "M06011",
        "M06012",
        "M06019",
        "M06021",
        "M06022",
        "M06029",
        "M06031",
        "M06032",
        "M06039",
        "M06041",
        "M06042",
        "M06049",
        "M06051",
        "M06052",
        "M06059",
        "M06061",
        "M06062",
        "M06069",
        "M06071",
        "M06072",
        "M06079",
        "M0608",
        "M0609",
        "M061",
        "M0620",
        "M06211",
        "M06212",
        "M06219",
        "M06221",
        "M06222",
        "M06229",
        "M06231",
        "M06232",
        "M06239",
        "M06241",
        "M06242",
        "M06249",
        "M06251",
        "M06252",
        "M06259",
        "M06261",
        "M06262",
        "M06269",
        "M06271",
        "M06272",
        "M06279",
        "M0628",
        "M0629",
        "M0630",
        "M06311",
        "M06312",
        "M06319",
        "M06321",
        "M06322",
        "M06329",
        "M06331",
        "M06332",
        "M06339",
        "M06341",
        "M06342",
        "M06349",
        "M06351",
        "M06352",
        "M06359",
        "M06361",
        "M06362",
        "M06369",
        "M06371",
        "M06372",
        "M06379",
        "M0638",
        "M0639",
        "M064",
        "M0680",
        "M06811",
        "M06812",
        "M06819",
        "M06821",
        "M06822",
        "M06829",
        "M06831",
        "M06832",
        "M06839",
        "M06841",
        "M06842",
        "M06849",
        "M06851",
        "M06852",
        "M06859",
        "M06861",
        "M06862",
        "M06869",
        "M06871",
        "M06872",
        "M06879",
        "M0688",
        "M0689",
        "M069",
        "M0800",
        "M08011",
        "M08012",
        "M08019",
        "M08021",
        "M08022",
        "M08029",
        "M08031",
        "M08032",
        "M08039",
        "M08041",
        "M08042",
        "M08049",
        "M08051",
        "M08052",
        "M08059",
        "M08061",
        "M08062",
        "M08069",
        "M08071",
        "M08072",
        "M08079",
        "M0808",
        "M0809",
        "M081",
        "M0820",
        "M08211",
        "M08212",
        "M08219",
        "M08221",
        "M08222",
        "M08229",
        "M08231",
        "M08232",
        "M08239",
        "M08241",
        "M08242",
        "M08249",
        "M08251",
        "M08252",
        "M08259",
        "M08261",
        "M08262",
        "M08269",
        "M08271",
        "M08272",
        "M08279",
        "M0828",
        "M0829",
        "M083",
        "M0840",
        "M08411",
        "M08412",
        "M08419",
        "M08421",
        "M08422",
        "M08429",
        "M08431",
        "M08432",
        "M08439",
        "M08441",
        "M08442",
        "M08449",
        "M08451",
        "M08452",
        "M08459",
        "M08461",
        "M08462",
        "M08469",
        "M08471",
        "M08472",
        "M08479",
        "M0848",
        "M0880",
        "M08811",
        "M08812",
        "M08819",
        "M08821",
        "M08822",
        "M08829",
        "M08831",
        "M08832",
        "M08839",
        "M08841",
        "M08842",
        "M08849",
        "M08851",
        "M08852",
        "M08859",
        "M08861",
        "M08862",
        "M08869",
        "M08871",
        "M08872",
        "M08879",
        "M0888",
        "M0889",
        "M0890",
        "M08911",
        "M08912",
        "M08919",
        "M08921",
        "M08922",
        "M08929",
        "M08931",
        "M08932",
        "M08939",
        "M08941",
        "M08942",
        "M08949",
        "M08951",
        "M08952",
        "M08959",
        "M08961",
        "M08962",
        "M08969",
        "M08971",
        "M08972",
        "M08979",
        "M0898",
        "M0899",
        "M1200",
        "M12011",
        "M12012",
        "M12019",
        "M12021",
        "M12022",
        "M12029",
        "M12031",
        "M12032",
        "M12039",
        "M12041",
        "M12042",
        "M12049",
        "M12051",
        "M12052",
        "M12059",
        "M12061",
        "M12062",
        "M12069",
        "M12071",
        "M12072",
        "M12079",
        "M1208",
        "M1209",
        "M300",
        "M301",
        "M302",
        "M303",
        "M308",
        "M310",
        "M311",
        "M312",
        "M3130",
        "M3131",
        "M314",
        "M315",
        "M316",
        "M317",
        "M320",
        "M3210",
        "M3211",
        "M3212",
        "M3213",
        "M3214",
        "M3215",
        "M3219",
        "M328",
        "M329",
        "M3300",
        "M3301",
        "M3302",
        "M3309",
        "M3310",
        "M3311",
        "M3312",
        "M3319",
        "M3320",
        "M3321",
        "M3322",
        "M3329",
        "M3390",
        "M3391",
        "M3392",
        "M3399",
        "M340",
        "M341",
        "M342",
        "M3481",
        "M3482",
        "M3483",
        "M3489",
        "M349",
        "M3500",
        "M3501",
        "M3502",
        "M3503",
        "M3504",
        "M3509",
        "M351",
        "M352",
        "M353",
        "M355",
        "M358",
        "M359",
        "M360",
        "M368",
        "M450",
        "M451",
        "M452",
        "M453",
        "M454",
        "M455",
        "M456",
        "M457",
        "M458",
        "M459",
        "M4600",
        "M4601",
        "M4602",
        "M4603",
        "M4604",
        "M4605",
        "M4606",
        "M4607",
        "M4608",
        "M4609",
        "M461",
        "M4650",
        "M4651",
        "M4652",
        "M4653",
        "M4654",
        "M4655",
        "M4656",
        "M4657",
        "M4658",
        "M4659",
        "M4680",
        "M4681",
        "M4682",
        "M4683",
        "M4684",
        "M4685",
        "M4686",
        "M4687",
        "M4688",
        "M4689",
        "M4690",
        "M4691",
        "M4692",
        "M4693",
        "M4694",
        "M4695",
        "M4696",
        "M4697",
        "M4698",
        "M4699",
        "M488X1",
        "M488X2",
        "M488X3",
        "M488X4",
        "M488X5",
        "M488X6",
        "M488X7",
        "M488X8",
        "M488X9",
        "M4980",
        "M4981",
        "M4982",
        "M4983",
        "M4984",
        "M4985",
        "M4986",
        "M4987",
        "M4988",
        "M4989",
        "D460",
        "D461",
        "D4620",
        "D4621",
        "D4622",
        "D464",
        "D469",
        "D46A",
        "D46B",
        "D46C",
        "D46Z",
        "D474",
        "D5700",
        "D5701",
        "D5702",
        "D571",
        "D5720",
        "D57211",
        "D57212",
        "D57219",
        "D5740",
        "D57411",
        "D57412",
        "D57419",
        "D5780",
        "D57811",
        "D57812",
        "D57819",
        "D590",
        "D591",
        "D592",
        "D593",
        "D594",
        "D595",
        "D596",
        "D598",
        "D599",
        "D600",
        "D601",
        "D608",
        "D609",
        "D6101",
        "D6109",
        "D611",
        "D612",
        "D613",
        "D6182",
        "D6189",
        "D619",
        "D66",
        "D67",
        "D7581",
        "D61810",
        "D61811",
        "D61818",
        "D700",
        "D701",
        "D702",
        "D703",
        "D704",
        "D708",
        "D709",
        "D71",
        "D720",
        "D761",
        "D762",
        "D763",
        "D800",
        "D801",
        "D802",
        "D803",
        "D804",
        "D805",
        "D806",
        "D807",
        "D808",
        "D809",
        "D810",
        "D811",
        "D812",
        "D813",
        "D814",
        "D815",
        "D816",
        "D817",
        "D8189",
        "D819",
        "D820",
        "D821",
        "D822",
        "D823",
        "D824",
        "D828",
        "D829",
        "D830",
        "D831",
        "D832",
        "D838",
        "D839",
        "D840",
        "D848",
        "D849",
        "D893",
        "D8940",
        "D8941",
        "D8942",
        "D8943",
        "D8949",
        "D89810",
        "D89811",
        "D89812",
        "D89813",
        "D8982",
        "D8989",
        "D899",
        "C946",
        "D45",
        "D471",
        "D473",
        "D479",
        "D47Z1",
        "D47Z2",
        "D47Z9",
        "D550",
        "D551",
        "D552",
        "D553",
        "D558",
        "D559",
        "D560",
        "D561",
        "D562",
        "D564",
        "D565",
        "D568",
        "D573",
        "D580",
        "D581",
        "D582",
        "D588",
        "D589",
        "D640",
        "D641",
        "D642",
        "D643",
        "D65",
        "D680",
        "D681",
        "D682",
        "D68311",
        "D68312",
        "D68318",
        "D6832",
        "D684",
        "D6851",
        "D6852",
        "D6859",
        "D6861",
        "D6862",
        "D6869",
        "D688",
        "D689",
        "D690",
        "D691",
        "D692",
        "D693",
        "D6941",
        "D6942",
        "D6949",
        "D696",
        "D698",
        "D699",
        "D7582",
        "F10150",
        "F10151",
        "F10159",
        "F10231",
        "F10232",
        "F10250",
        "F10251",
        "F10259",
        "F1026",
        "F1027",
        "F10950",
        "F10951",
        "F10959",
        "F1096",
        "F1097",
        "F11150",
        "F11151",
        "F11159",
        "F11250",
        "F11251",
        "F11259",
        "F11950",
        "F11951",
        "F11959",
        "F12150",
        "F12151",
        "F12159",
        "F12250",
        "F12251",
        "F12259",
        "F12950",
        "F12951",
        "F12959",
        "F13150",
        "F13151",
        "F13159",
        "F13231",
        "F13232",
        "F13250",
        "F13251",
        "F13259",
        "F1326",
        "F1327",
        "F13931",
        "F13932",
        "F13950",
        "F13951",
        "F13959",
        "F1396",
        "F1397",
        "F14150",
        "F14151",
        "F14159",
        "F14250",
        "F14251",
        "F14259",
        "F14950",
        "F14951",
        "F14959",
        "F15150",
        "F15151",
        "F15159",
        "F15250",
        "F15251",
        "F15259",
        "F15950",
        "F15951",
        "F15959",
        "F16150",
        "F16151",
        "F16159",
        "F16250",
        "F16251",
        "F16259",
        "F16950",
        "F16951",
        "F16959",
        "F18150",
        "F18151",
        "F18159",
        "F1817",
        "F18250",
        "F18251",
        "F18259",
        "F1827",
        "F18950",
        "F18951",
        "F18959",
        "F1897",
        "F19150",
        "F19151",
        "F19159",
        "F1916",
        "F1917",
        "F19231",
        "F19232",
        "F19250",
        "F19251",
        "F19259",
        "F1926",
        "F1927",
        "F19931",
        "F19932",
        "F19950",
        "F19951",
        "F19959",
        "F1996",
        "F1997",
        "F10120",
        "F10121",
        "F10129",
        "F1014",
        "F10180",
        "F10181",
        "F10182",
        "F10188",
        "F1019",
        "F1020",
        "F1021",
        "F10220",
        "F10221",
        "F10229",
        "F10230",
        "F10239",
        "F1024",
        "F10280",
        "F10281",
        "F10282",
        "F10288",
        "F1029",
        "F10920",
        "F10921",
        "F10929",
        "F1094",
        "F10980",
        "F10981",
        "F10982",
        "F10988",
        "F1099",
        "F11120",
        "F11121",
        "F11122",
        "F11129",
        "F1114",
        "F11181",
        "F11182",
        "F11188",
        "F1119",
        "F1120",
        "F1121",
        "F11220",
        "F11221",
        "F11222",
        "F11229",
        "F1123",
        "F1124",
        "F11281",
        "F11282",
        "F11288",
        "F1129",
        "F11920",
        "F11921",
        "F11922",
        "F11929",
        "F1193",
        "F1194",
        "F11981",
        "F11982",
        "F11988",
        "F1199",
        "F12120",
        "F12121",
        "F12122",
        "F12129",
        "F12180",
        "F12188",
        "F1219",
        "F1220",
        "F1221",
        "F12220",
        "F12221",
        "F12222",
        "F12229",
        "F12280",
        "F12288",
        "F1229",
        "F12920",
        "F12921",
        "F12922",
        "F12929",
        "F12980",
        "F12988",
        "F1299",
        "F13120",
        "F13121",
        "F13129",
        "F1314",
        "F13180",
        "F13181",
        "F13182",
        "F13188",
        "F1319",
        "F1320",
        "F1321",
        "F13220",
        "F13221",
        "F13229",
        "F13230",
        "F13239",
        "F1324",
        "F13280",
        "F13281",
        "F13282",
        "F13288",
        "F1329",
        "F13920",
        "F13921",
        "F13929",
        "F13930",
        "F13939",
        "F1394",
        "F13980",
        "F13981",
        "F13982",
        "F13988",
        "F1399",
        "F14120",
        "F14121",
        "F14122",
        "F14129",
        "F1414",
        "F14180",
        "F14181",
        "F14182",
        "F14188",
        "F1419",
        "F1420",
        "F1421",
        "F14220",
        "F14221",
        "F14222",
        "F14229",
        "F1423",
        "F1424",
        "F14280",
        "F14281",
        "F14282",
        "F14288",
        "F1429",
        "F14920",
        "F14921",
        "F14922",
        "F14929",
        "F1494",
        "F14980",
        "F14981",
        "F14982",
        "F14988",
        "F1499",
        "F15120",
        "F15121",
        "F15122",
        "F15129",
        "F1514",
        "F15180",
        "F15181",
        "F15182",
        "F15188",
        "F1519",
        "F1520",
        "F1521",
        "F15220",
        "F15221",
        "F15222",
        "F15229",
        "F1523",
        "F1524",
        "F15280",
        "F15281",
        "F15282",
        "F15288",
        "F1529",
        "F15920",
        "F15921",
        "F15922",
        "F15929",
        "F1593",
        "F1594",
        "F15980",
        "F15981",
        "F15982",
        "F15988",
        "F1599",
        "F16120",
        "F16121",
        "F16122",
        "F16129",
        "F1614",
        "F16180",
        "F16183",
        "F16188",
        "F1619",
        "F1620",
        "F1621",
        "F16220",
        "F16221",
        "F16229",
        "F1624",
        "F16280",
        "F16283",
        "F16288",
        "F1629",
        "F16920",
        "F16921",
        "F16929",
        "F1694",
        "F16980",
        "F16983",
        "F16988",
        "F1699",
        "F18120",
        "F18121",
        "F18129",
        "F1814",
        "F18180",
        "F18188",
        "F1819",
        "F1820",
        "F1821",
        "F18220",
        "F18221",
        "F18229",
        "F1824",
        "F18280",
        "F18288",
        "F1829",
        "F18920",
        "F18921",
        "F18929",
        "F1894",
        "F18980",
        "F18988",
        "F1899",
        "F19121",
        "F19122",
        "F19129",
        "F1914",
        "F19180",
        "F19181",
        "F19182",
        "F19188",
        "F1919",
        "F1920",
        "F1921",
        "F19220",
        "F19221",
        "F19222",
        "F19229",
        "F19230",
        "F19239",
        "F1924",
        "F19280",
        "F19281",
        "F19282",
        "F19288",
        "F1929",
        "F19920",
        "F19921",
        "F19922",
        "F19929",
        "F19930",
        "F19939",
        "F1994",
        "F19980",
        "F19981",
        "F19982",
        "F19988",
        "F1999",
        "F200",
        "F201",
        "F202",
        "F203",
        "F205",
        "F2081",
        "F2089",
        "F209",
        "F250",
        "F251",
        "F258",
        "F259",
        "F22",
        "F24",
        "F3010",
        "F3011",
        "F3012",
        "F3013",
        "F302",
        "F303",
        "F304",
        "F308",
        "F309",
        "F310",
        "F3110",
        "F3111",
        "F3112",
        "F3113",
        "F312",
        "F3130",
        "F3131",
        "F3132",
        "F314",
        "F315",
        "F3160",
        "F3161",
        "F3162",
        "F3163",
        "F3164",
        "F3170",
        "F3171",
        "F3172",
        "F3173",
        "F3174",
        "F3175",
        "F3176",
        "F3177",
        "F3178",
        "F3181",
        "F3189",
        "F319",
        "F320",
        "F321",
        "F322",
        "F323",
        "F324",
        "F325",
        "F330",
        "F331",
        "F332",
        "F333",
        "F3340",
        "F3341",
        "F3342",
        "F338",
        "F339",
        "F348",
        "F3481",
        "F3489",
        "F349",
        "F39",
        "T1491",
        "T360X2A",
        "T360X2S",
        "T361X2A",
        "T361X2S",
        "T362X2A",
        "T362X2S",
        "T363X2A",
        "T363X2S",
        "T364X2A",
        "T364X2S",
        "T365X2A",
        "T365X2S",
        "T366X2A",
        "T366X2S",
        "T367X2A",
        "T367X2S",
        "T368X2A",
        "T368X2S",
        "T3692XA",
        "T3692XS",
        "T370X2A",
        "T370X2S",
        "T371X2A",
        "T371X2S",
        "T372X2A",
        "T372X2S",
        "T373X2A",
        "T373X2S",
        "T374X2A",
        "T374X2S",
        "T375X2A",
        "T375X2S",
        "T378X2A",
        "T378X2S",
        "T3792XA",
        "T3792XS",
        "T380X2A",
        "T380X2S",
        "T381X2A",
        "T381X2S",
        "T382X2A",
        "T382X2S",
        "T383X2A",
        "T383X2S",
        "T384X2A",
        "T384X2S",
        "T385X2A",
        "T385X2S",
        "T386X2A",
        "T386X2S",
        "T387X2A",
        "T387X2S",
        "T38802A",
        "T38802S",
        "T38812A",
        "T38812S",
        "T38892A",
        "T38892S",
        "T38902A",
        "T38902S",
        "T38992A",
        "T38992S",
        "T39012A",
        "T39012S",
        "T39092A",
        "T39092S",
        "T391X2A",
        "T391X2S",
        "T392X2A",
        "T392X2S",
        "T39312A",
        "T39312S",
        "T39392A",
        "T39392S",
        "T394X2A",
        "T394X2S",
        "T398X2A",
        "T398X2S",
        "T3992XA",
        "T3992XS",
        "T400X2A",
        "T400X2S",
        "T401X2A",
        "T401X2S",
        "T402X2A",
        "T402X2S",
        "T403X2A",
        "T403X2S",
        "T404X2A",
        "T404X2S",
        "T405X2A",
        "T405X2S",
        "T40602A",
        "T40602S",
        "T40692A",
        "T40692S",
        "T407X2A",
        "T407X2S",
        "T408X2A",
        "T408X2S",
        "T40902A",
        "T40902S",
        "T40992A",
        "T40992S",
        "T410X2A",
        "T410X2S",
        "T411X2A",
        "T411X2S",
        "T41202A",
        "T41202S",
        "T41292A",
        "T41292S",
        "T413X2A",
        "T413X2S",
        "T4142XA",
        "T4142XS",
        "T415X2A",
        "T415X2S",
        "T420X2A",
        "T420X2S",
        "T421X2A",
        "T421X2S",
        "T422X2A",
        "T422X2S",
        "T423X2A",
        "T423X2S",
        "T424X2A",
        "T424X2S",
        "T425X2A",
        "T425X2S",
        "T426X2A",
        "T426X2S",
        "T4272XA",
        "T4272XS",
        "T428X2A",
        "T428X2S",
        "T43012A",
        "T43012S",
        "T43022A",
        "T43022S",
        "T431X2A",
        "T431X2S",
        "T43202A",
        "T43202S",
        "T43212A",
        "T43212S",
        "T43222A",
        "T43222S",
        "T43292A",
        "T43292S",
        "T433X2A",
        "T433X2S",
        "T434X2A",
        "T434X2S",
        "T43502A",
        "T43502S",
        "T43592A",
        "T43592S",
        "T43602A",
        "T43602S",
        "T43612A",
        "T43612S",
        "T43622A",
        "T43622S",
        "T43632A",
        "T43632S",
        "T43692A",
        "T43692S",
        "T438X2A",
        "T438X2S",
        "T4392XA",
        "T4392XS",
        "T440X2A",
        "T440X2S",
        "T441X2A",
        "T441X2S",
        "T442X2A",
        "T442X2S",
        "T443X2A",
        "T443X2S",
        "T444X2A",
        "T444X2S",
        "T445X2A",
        "T445X2S",
        "T446X2A",
        "T446X2S",
        "T447X2A",
        "T447X2S",
        "T448X2A",
        "T448X2S",
        "T44902A",
        "T44902S",
        "T44992A",
        "T44992S",
        "T450X2A",
        "T450X2S",
        "T451X2A",
        "T451X2S",
        "T452X2A",
        "T452X2S",
        "T453X2A",
        "T453X2S",
        "T454X2A",
        "T454X2S",
        "T45512A",
        "T45512S",
        "T45522A",
        "T45522S",
        "T45602A",
        "T45602S",
        "T45612A",
        "T45612S",
        "T45622A",
        "T45622S",
        "T45692A",
        "T45692S",
        "T457X2A",
        "T457X2S",
        "T458X2A",
        "T458X2S",
        "T4592XA",
        "T4592XS",
        "T460X2A",
        "T460X2S",
        "T461X2A",
        "T461X2S",
        "T462X2A",
        "T462X2S",
        "T463X2A",
        "T463X2S",
        "T464X2A",
        "T464X2S",
        "T465X2A",
        "T465X2S",
        "T466X2A",
        "T466X2S",
        "T467X2A",
        "T467X2S",
        "T468X2A",
        "T468X2S",
        "T46902A",
        "T46902S",
        "T46992A",
        "T46992S",
        "T470X2A",
        "T470X2S",
        "T471X2A",
        "T471X2S",
        "T472X2A",
        "T472X2S",
        "T473X2A",
        "T473X2S",
        "T474X2A",
        "T474X2S",
        "T475X2A",
        "T475X2S",
        "T476X2A",
        "T476X2S",
        "T477X2A",
        "T477X2S",
        "T478X2A",
        "T478X2S",
        "T4792XA",
        "T4792XS",
        "T480X2A",
        "T480X2S",
        "T481X2A",
        "T481X2S",
        "T48202A",
        "T48202S",
        "T48292A",
        "T48292S",
        "T483X2A",
        "T483X2S",
        "T484X2A",
        "T484X2S",
        "T485X2A",
        "T485X2S",
        "T486X2A",
        "T486X2S",
        "T48902A",
        "T48902S",
        "T48992A",
        "T48992S",
        "T490X2A",
        "T490X2S",
        "T491X2A",
        "T491X2S",
        "T492X2A",
        "T492X2S",
        "T493X2A",
        "T493X2S",
        "T494X2A",
        "T494X2S",
        "T495X2A",
        "T495X2S",
        "T496X2A",
        "T496X2S",
        "T497X2A",
        "T497X2S",
        "T498X2A",
        "T498X2S",
        "T4992XA",
        "T4992XS",
        "T500X2A",
        "T500X2S",
        "T501X2A",
        "T501X2S",
        "T502X2A",
        "T502X2S",
        "T503X2A",
        "T503X2S",
        "T504X2A",
        "T504X2S",
        "T505X2A",
        "T505X2S",
        "T506X2A",
        "T506X2S",
        "T507X2A",
        "T507X2S",
        "T508X2A",
        "T508X2S",
        "T50902A",
        "T50902S",
        "T50992A",
        "T50992S",
        "T50A12A",
        "T50A12S",
        "T50A22A",
        "T50A22S",
        "T50A92A",
        "T50A92S",
        "T50B12A",
        "T50B12S",
        "T50B92A",
        "T50B92S",
        "T50Z12A",
        "T50Z12S",
        "T50Z92A",
        "T50Z92S",
        "T510X2A",
        "T510X2S",
        "T511X2A",
        "T511X2S",
        "T512X2A",
        "T512X2S",
        "T513X2A",
        "T513X2S",
        "T518X2A",
        "T518X2S",
        "T5192XA",
        "T5192XS",
        "T520X2A",
        "T520X2S",
        "T521X2A",
        "T521X2S",
        "T522X2A",
        "T522X2S",
        "T523X2A",
        "T523X2S",
        "T524X2A",
        "T524X2S",
        "T528X2A",
        "T528X2S",
        "T5292XA",
        "T5292XS",
        "T530X2A",
        "T530X2S",
        "T531X2A",
        "T531X2S",
        "T532X2A",
        "T532X2S",
        "T533X2A",
        "T533X2S",
        "T534X2A",
        "T534X2S",
        "T535X2A",
        "T535X2S",
        "T536X2A",
        "T536X2S",
        "T537X2A",
        "T537X2S",
        "T5392XA",
        "T5392XS",
        "T540X2A",
        "T540X2S",
        "T541X2A",
        "T541X2S",
        "T542X2A",
        "T542X2S",
        "T543X2A",
        "T543X2S",
        "T5492XA",
        "T5492XS",
        "T550X2A",
        "T550X2S",
        "T551X2A",
        "T551X2S",
        "T560X2A",
        "T560X2S",
        "T561X2A",
        "T561X2S",
        "T562X2A",
        "T562X2S",
        "T563X2A",
        "T563X2S",
        "T564X2A",
        "T564X2S",
        "T565X2A",
        "T565X2S",
        "T566X2A",
        "T566X2S",
        "T567X2A",
        "T567X2S",
        "T56812A",
        "T56812S",
        "T56892A",
        "T56892S",
        "T5692XA",
        "T5692XS",
        "T570X2A",
        "T570X2S",
        "T571X2A",
        "T571X2S",
        "T572X2A",
        "T572X2S",
        "T573X2A",
        "T573X2S",
        "T578X2A",
        "T578X2S",
        "T5792XA",
        "T5792XS",
        "T5802XA",
        "T5802XS",
        "T5812XA",
        "T5812XS",
        "T582X2A",
        "T582X2S",
        "T588X2A",
        "T588X2S",
        "T5892XA",
        "T5892XS",
        "T590X2A",
        "T590X2S",
        "T591X2A",
        "T591X2S",
        "T592X2A",
        "T592X2S",
        "T593X2A",
        "T593X2S",
        "T594X2A",
        "T594X2S",
        "T595X2A",
        "T595X2S",
        "T596X2A",
        "T596X2S",
        "T597X2A",
        "T597X2S",
        "T59812A",
        "T59812S",
        "T59892A",
        "T59892S",
        "T5992XA",
        "T5992XS",
        "T600X2A",
        "T600X2S",
        "T601X2A",
        "T601X2S",
        "T602X2A",
        "T602X2S",
        "T603X2A",
        "T603X2S",
        "T604X2A",
        "T604X2S",
        "T608X2A",
        "T608X2S",
        "T6092XA",
        "T6092XS",
        "T6102XA",
        "T6102XS",
        "T6112XA",
        "T6112XS",
        "T61772A",
        "T61772S",
        "T61782A",
        "T61782S",
        "T618X2A",
        "T618X2S",
        "T6192XA",
        "T6192XS",
        "T620X2A",
        "T620X2S",
        "T621X2A",
        "T621X2S",
        "T622X2A",
        "T622X2S",
        "T628X2A",
        "T628X2S",
        "T6292XA",
        "T6292XS",
        "T63002A",
        "T63002S",
        "T63012A",
        "T63012S",
        "T63022A",
        "T63022S",
        "T63032A",
        "T63032S",
        "T63042A",
        "T63042S",
        "T63062A",
        "T63062S",
        "T63072A",
        "T63072S",
        "T63082A",
        "T63082S",
        "T63092A",
        "T63092S",
        "T63112A",
        "T63112S",
        "T63122A",
        "T63122S",
        "T63192A",
        "T63192S",
        "T632X2A",
        "T632X2S",
        "T63302A",
        "T63302S",
        "T63312A",
        "T63312S",
        "T63322A",
        "T63322S",
        "T63332A",
        "T63332S",
        "T63392A",
        "T63392S",
        "T63412A",
        "T63412S",
        "T63422A",
        "T63422S",
        "T63432A",
        "T63432S",
        "T63442A",
        "T63442S",
        "T63452A",
        "T63452S",
        "T63462A",
        "T63462S",
        "T63482A",
        "T63482S",
        "T63512A",
        "T63512S",
        "T63592A",
        "T63592S",
        "T63612A",
        "T63612S",
        "T63622A",
        "T63622S",
        "T63632A",
        "T63632S",
        "T63692A",
        "T63692S",
        "T63712A",
        "T63712S",
        "T63792A",
        "T63792S",
        "T63812A",
        "T63812S",
        "T63822A",
        "T63822S",
        "T63832A",
        "T63832S",
        "T63892A",
        "T63892S",
        "T6392XA",
        "T6392XS",
        "T6402XA",
        "T6402XS",
        "T6482XA",
        "T6482XS",
        "T650X2A",
        "T650X2S",
        "T651X2A",
        "T651X2S",
        "T65212A",
        "T65212S",
        "T65222A",
        "T65222S",
        "T65292A",
        "T65292S",
        "T653X2A",
        "T653X2S",
        "T654X2A",
        "T654X2S",
        "T655X2A",
        "T655X2S",
        "T656X2A",
        "T656X2S",
        "T65812A",
        "T65812S",
        "T65822A",
        "T65822S",
        "T65832A",
        "T65832S",
        "T65892A",
        "T65892S",
        "T6592XA",
        "T6592XS",
        "T71112A",
        "T71112S",
        "T71122A",
        "T71122S",
        "T71132A",
        "T71132S",
        "T71152A",
        "T71152S",
        "T71162A",
        "T71162S",
        "T71192A",
        "T71192S",
        "T71222A",
        "T71222S",
        "T71232A",
        "T71232S",
        "X710XXA",
        "X710XXD",
        "X710XXS",
        "X711XXA",
        "X711XXD",
        "X711XXS",
        "X712XXA",
        "X712XXD",
        "X712XXS",
        "X713XXA",
        "X713XXD",
        "X713XXS",
        "X718XXA",
        "X718XXD",
        "X718XXS",
        "X719XXA",
        "X719XXD",
        "X719XXS",
        "X72XXXA",
        "X72XXXD",
        "X72XXXS",
        "X730XXA",
        "X730XXD",
        "X730XXS",
        "X731XXA",
        "X731XXD",
        "X731XXS",
        "X732XXA",
        "X732XXD",
        "X732XXS",
        "X738XXA",
        "X738XXD",
        "X738XXS",
        "X739XXA",
        "X739XXD",
        "X739XXS",
        "X7401XA",
        "X7401XD",
        "X7401XS",
        "X7402XA",
        "X7402XD",
        "X7402XS",
        "X7409XA",
        "X7409XD",
        "X7409XS",
        "X748XXA",
        "X748XXD",
        "X748XXS",
        "X749XXA",
        "X749XXD",
        "X749XXS",
        "X75XXXA",
        "X75XXXD",
        "X75XXXS",
        "X76XXXA",
        "X76XXXD",
        "X76XXXS",
        "X770XXA",
        "X770XXD",
        "X770XXS",
        "X771XXA",
        "X771XXD",
        "X771XXS",
        "X772XXA",
        "X772XXD",
        "X772XXS",
        "X773XXA",
        "X773XXD",
        "X773XXS",
        "X778XXA",
        "X778XXD",
        "X778XXS",
        "X779XXA",
        "X779XXD",
        "X779XXS",
        "X780XXA",
        "X780XXD",
        "X780XXS",
        "X781XXA",
        "X781XXD",
        "X781XXS",
        "X782XXA",
        "X782XXD",
        "X782XXS",
        "X788XXA",
        "X788XXD",
        "X788XXS",
        "X789XXA",
        "X789XXD",
        "X789XXS",
        "X79XXXA",
        "X79XXXD",
        "X79XXXS",
        "X80XXXA",
        "X80XXXD",
        "X80XXXS",
        "X810XXA",
        "X810XXD",
        "X810XXS",
        "X811XXA",
        "X811XXD",
        "X811XXS",
        "X818XXA",
        "X818XXD",
        "X818XXS",
        "X820XXA",
        "X820XXD",
        "X820XXS",
        "X821XXA",
        "X821XXD",
        "X821XXS",
        "X822XXA",
        "X822XXD",
        "X822XXS",
        "X828XXA",
        "X828XXD",
        "X828XXS",
        "X830XXA",
        "X830XXD",
        "X830XXS",
        "X831XXA",
        "X831XXD",
        "X831XXS",
        "X832XXA",
        "X832XXD",
        "X832XXS",
        "X838XXA",
        "X838XXD",
        "X838XXS",
        "G8250",
        "G8251",
        "G8252",
        "G8253",
        "G8254",
        "R532",
        "S14111A",
        "S14111D",
        "S14111S",
        "S14112A",
        "S14112D",
        "S14112S",
        "S14113A",
        "S14113D",
        "S14113S",
        "S14114A",
        "S14114D",
        "S14114S",
        "S14115A",
        "S14115D",
        "S14115S",
        "S14116A",
        "S14116D",
        "S14116S",
        "S14117A",
        "S14117D",
        "S14117S",
        "S14118A",
        "S14118D",
        "S14118S",
        "S14119A",
        "S14119D",
        "S14119S",
        "G8220",
        "G8221",
        "G8222",
        "S24111A",
        "S24111D",
        "S24111S",
        "S24112A",
        "S24112D",
        "S24112S",
        "S24113A",
        "S24113D",
        "S24113S",
        "S24114A",
        "S24114D",
        "S24114S",
        "S24119A",
        "S24119D",
        "S24119S",
        "B0082",
        "B0112",
        "B0224",
        "G041",
        "G0489",
        "G0491",
        "G054",
        "G110",
        "G111",
        "G112",
        "G113",
        "G114",
        "G118",
        "G119",
        "G120",
        "G121",
        "G128",
        "G129",
        "G320",
        "G3281",
        "G373",
        "G374",
        "G834",
        "G901",
        "G950",
        "G9511",
        "G9519",
        "G9520",
        "G9529",
        "G9581",
        "G9589",
        "G959",
        "G992",
        "Q000",
        "Q001",
        "Q002",
        "Q010",
        "Q011",
        "Q012",
        "Q018",
        "Q019",
        "Q02",
        "Q030",
        "Q031",
        "Q038",
        "Q039",
        "Q040",
        "Q041",
        "Q042",
        "Q043",
        "Q044",
        "Q045",
        "Q046",
        "Q048",
        "Q049",
        "Q050",
        "Q051",
        "Q052",
        "Q053",
        "Q054",
        "Q055",
        "Q056",
        "Q057",
        "Q058",
        "Q059",
        "Q060",
        "Q061",
        "Q062",
        "Q063",
        "Q064",
        "Q068",
        "Q069",
        "Q0700",
        "Q0701",
        "Q0702",
        "Q0703",
        "Q078",
        "Q079",
        "S140XXA",
        "S140XXD",
        "S140XXS",
        "S14101A",
        "S14101D",
        "S14101S",
        "S14102A",
        "S14102D",
        "S14102S",
        "S14103A",
        "S14103D",
        "S14103S",
        "S14104A",
        "S14104D",
        "S14104S",
        "S14105A",
        "S14105D",
        "S14105S",
        "S14106A",
        "S14106D",
        "S14106S",
        "S14107A",
        "S14107D",
        "S14107S",
        "S14108A",
        "S14108D",
        "S14108S",
        "S14109A",
        "S14109D",
        "S14109S",
        "S14121A",
        "S14121D",
        "S14121S",
        "S14122A",
        "S14122D",
        "S14122S",
        "S14123A",
        "S14123D",
        "S14123S",
        "S14124A",
        "S14124D",
        "S14124S",
        "S14125A",
        "S14125D",
        "S14125S",
        "S14126A",
        "S14126D",
        "S14126S",
        "S14127A",
        "S14127D",
        "S14127S",
        "S14128A",
        "S14128D",
        "S14128S",
        "S14129A",
        "S14129D",
        "S14129S",
        "S14131A",
        "S14131D",
        "S14131S",
        "S14132A",
        "S14132D",
        "S14132S",
        "S14133A",
        "S14133D",
        "S14133S",
        "S14134A",
        "S14134D",
        "S14134S",
        "S14135A",
        "S14135D",
        "S14135S",
        "S14136A",
        "S14136D",
        "S14136S",
        "S14137A",
        "S14137D",
        "S14137S",
        "S14138A",
        "S14138D",
        "S14138S",
        "S14139A",
        "S14139D",
        "S14139S",
        "S14141A",
        "S14141D",
        "S14141S",
        "S14142A",
        "S14142D",
        "S14142S",
        "S14143A",
        "S14143D",
        "S14143S",
        "S14144A",
        "S14144D",
        "S14144S",
        "S14145A",
        "S14145D",
        "S14145S",
        "S14146A",
        "S14146D",
        "S14146S",
        "S14147A",
        "S14147D",
        "S14147S",
        "S14148A",
        "S14148D",
        "S14148S",
        "S14149A",
        "S14149D",
        "S14149S",
        "S14151A",
        "S14151D",
        "S14151S",
        "S14152A",
        "S14152D",
        "S14152S",
        "S14153A",
        "S14153D",
        "S14153S",
        "S14154A",
        "S14154D",
        "S14154S",
        "S14155A",
        "S14155D",
        "S14155S",
        "S14156A",
        "S14156D",
        "S14156S",
        "S14157A",
        "S14157D",
        "S14157S",
        "S14158A",
        "S14158D",
        "S14158S",
        "S14159A",
        "S14159D",
        "S14159S",
        "S240XXA",
        "S240XXD",
        "S240XXS",
        "S24101A",
        "S24101D",
        "S24101S",
        "S24102A",
        "S24102D",
        "S24102S",
        "S24103A",
        "S24103D",
        "S24103S",
        "S24104A",
        "S24104D",
        "S24104S",
        "S24109A",
        "S24109D",
        "S24109S",
        "S24131A",
        "S24131D",
        "S24131S",
        "S24132A",
        "S24132D",
        "S24132S",
        "S24133A",
        "S24133D",
        "S24133S",
        "S24134A",
        "S24134D",
        "S24134S",
        "S24139A",
        "S24139D",
        "S24139S",
        "S24141A",
        "S24141D",
        "S24141S",
        "S24142A",
        "S24142D",
        "S24142S",
        "S24143A",
        "S24143D",
        "S24143S",
        "S24144A",
        "S24144D",
        "S24144S",
        "S24149A",
        "S24149D",
        "S24149S",
        "S24151A",
        "S24151D",
        "S24151S",
        "S24152A",
        "S24152D",
        "S24152S",
        "S24153A",
        "S24153D",
        "S24153S",
        "S24154A",
        "S24154D",
        "S24154S",
        "S24159A",
        "S24159D",
        "S24159S",
        "S3401XA",
        "S3401XD",
        "S3401XS",
        "S3402XA",
        "S3402XD",
        "S3402XS",
        "S34101A",
        "S34101D",
        "S34101S",
        "S34102A",
        "S34102D",
        "S34102S",
        "S34103A",
        "S34103D",
        "S34103S",
        "S34104A",
        "S34104D",
        "S34104S",
        "S34105A",
        "S34105D",
        "S34105S",
        "S34109A",
        "S34109D",
        "S34109S",
        "S34111A",
        "S34111D",
        "S34111S",
        "S34112A",
        "S34112D",
        "S34112S",
        "S34113A",
        "S34113D",
        "S34113S",
        "S34114A",
        "S34114D",
        "S34114S",
        "S34115A",
        "S34115D",
        "S34115S",
        "S34119A",
        "S34119D",
        "S34119S",
        "S34121A",
        "S34121D",
        "S34121S",
        "S34122A",
        "S34122D",
        "S34122S",
        "S34123A",
        "S34123D",
        "S34123S",
        "S34124A",
        "S34124D",
        "S34124S",
        "S34125A",
        "S34125D",
        "S34125S",
        "S34129A",
        "S34129D",
        "S34129S",
        "S34131A",
        "S34131D",
        "S34131S",
        "S34132A",
        "S34132D",
        "S34132S",
        "S34139A",
        "S34139D",
        "S34139S",
        "S343XXA",
        "G1220",
        "G1221",
        "G1222",
        "G1229",
        "G800",
        "G801",
        "G802",
        "G803",
        "G804",
        "G808",
        "G809",
        "D8682",
        "G130",
        "G131",
        "G610",
        "G611",
        "G6181",
        "G6182",
        "G6189",
        "G619",
        "G620",
        "G621",
        "G622",
        "G6281",
        "G6282",
        "G63",
        "G650",
        "G651",
        "G652",
        "G7000",
        "G7001",
        "G701",
        "G702",
        "G7080",
        "G7081",
        "G7089",
        "G709",
        "G731",
        "G733",
        "G710",
        "G7111",
        "G712",
        "G35",
        "G360",
        "G361",
        "G368",
        "G369",
        "G370",
        "G371",
        "G372",
        "G375",
        "G378",
        "G379",
        "G10",
        "G20",
        "G2111",
        "G2119",
        "G212",
        "G213",
        "G214",
        "G218",
        "G219",
        "G230",
        "G231",
        "G232",
        "G238",
        "G239",
        "G903",
        "G40001",
        "G40009",
        "G40011",
        "G40019",
        "G40101",
        "G40109",
        "G40111",
        "G40119",
        "G40201",
        "G40209",
        "G40211",
        "G40219",
        "G40301",
        "G40309",
        "G40311",
        "G40319",
        "G40401",
        "G40409",
        "G40411",
        "G40419",
        "G40501",
        "G40509",
        "G40801",
        "G40802",
        "G40803",
        "G40804",
        "G40811",
        "G40812",
        "G40813",
        "G40814",
        "G40821",
        "G40822",
        "G40823",
        "G40824",
        "G4089",
        "G40901",
        "G40909",
        "G40911",
        "G40919",
        "G40A01",
        "G40A09",
        "G40A11",
        "G40A19",
        "G40B01",
        "G40B09",
        "G40B11",
        "G40B19",
        "R5600",
        "R5601",
        "R561",
        "R569",
        "G931",
        "G935",
        "G936",
        "R4020",
        "R402110",
        "R402111",
        "R402112",
        "R402113",
        "R402114",
        "R402120",
        "R402121",
        "R402122",
        "R402123",
        "R402124",
        "R402210",
        "R402211",
        "R402212",
        "R402213",
        "R402214",
        "R402220",
        "R402221",
        "R402222",
        "R402223",
        "R402224",
        "R402310",
        "R402311",
        "R402312",
        "R402313",
        "R402314",
        "R402320",
        "R402321",
        "R402322",
        "R402323",
        "R402324",
        "R402340",
        "R402341",
        "R402342",
        "R402343",
        "R402344",
        "R40243",
        "R402430",
        "R402431",
        "R402432",
        "R402433",
        "R402434",
        "R40244",
        "R402440",
        "R402441",
        "R402442",
        "R402443",
        "R402444",
        "R403",
        "J9500",
        "J9501",
        "J9502",
        "J9503",
        "J9504",
        "J9509",
        "J95850",
        "J95859",
        "Z430",
        "Z930",
        "Z9911",
        "Z9912",
        "R092",
        "I462",
        "I468",
        "I469",
        "I4901",
        "I4902",
        "J80",
        "J810",
        "J951",
        "J952",
        "J953",
        "J95821",
        "J95822",
        "J9600",
        "J9601",
        "J9602",
        "J9610",
        "J9611",
        "J9612",
        "J9620",
        "J9621",
        "J9622",
        "J9690",
        "J9691",
        "J9692",
        "R570",
        "R579",
        "T8111XA",
        "A3681",
        "B3324",
        "I0981",
        "I110",
        "I130",
        "I132",
        "I2601",
        "I2602",
        "I2609",
        "I270",
        "I271",
        "I272",
        "I2781",
        "I2789",
        "I279",
        "I280",
        "I281",
        "I288",
        "I289",
        "I420",
        "I421",
        "I422",
        "I423",
        "I424",
        "I425",
        "I426",
        "I427",
        "I428",
        "I429",
        "I43",
        "I501",
        "I5020",
        "I5021",
        "I5022",
        "I5023",
        "I5030",
        "I5031",
        "I5032",
        "I5033",
        "I5040",
        "I5041",
        "I5042",
        "I5043",
        "I509",
        "I514",
        "I515",
        "I2101",
        "I2102",
        "I2109",
        "I2111",
        "I2119",
        "I2121",
        "I2129",
        "I213",
        "I214",
        "I220",
        "I221",
        "I222",
        "I228",
        "I229",
        "I234",
        "I235",
        "I511",
        "I512",
        "I200",
        "I230",
        "I231",
        "I232",
        "I233",
        "I236",
        "I237",
        "I238",
        "I240",
        "I241",
        "I248",
        "I249",
        "I25110",
        "I25700",
        "I25710",
        "I25720",
        "I25730",
        "I25750",
        "I25760",
        "I25790",
        "I201",
        "I208",
        "I209",
        "I25111",
        "I25118",
        "I25119",
        "I25701",
        "I25708",
        "I25709",
        "I25711",
        "I25718",
        "I25719",
        "I25721",
        "I25728",
        "I25729",
        "I25731",
        "I25738",
        "I25739",
        "I25751",
        "I25758",
        "I25759",
        "I25761",
        "I25768",
        "I25769",
        "I25791",
        "I25798",
        "I25799",
        "I442",
        "I470",
        "I471",
        "I472",
        "I479",
        "I480",
        "I481",
        "I482",
        "I483",
        "I484",
        "I4891",
        "I4892",
        "I492",
        "I495",
        "I6000",
        "I6001",
        "I6002",
        "I6010",
        "I6011",
        "I6012",
        "I602",
        "I6020",
        "I6021",
        "I6022",
        "I6030",
        "I6031",
        "I6032",
        "I604",
        "I6050",
        "I6051",
        "I6052",
        "I606",
        "I607",
        "I608",
        "I609",
        "I610",
        "I611",
        "I612",
        "I613",
        "I614",
        "I615",
        "I616",
        "I618",
        "I619",
        "I6200",
        "I6201",
        "I6202",
        "I6203",
        "I621",
        "I629",
        "I6300",
        "I63011",
        "I63012",
        "I63013",
        "I63019",
        "I6302",
        "I63031",
        "I63032",
        "I63033",
        "I63039",
        "I6309",
        "I6310",
        "I63111",
        "I63112",
        "I63113",
        "I63119",
        "I6312",
        "I63131",
        "I63132",
        "I63133",
        "I63139",
        "I6319",
        "I6320",
        "I63211",
        "I63212",
        "I63213",
        "I63219",
        "I6322",
        "I63231",
        "I63232",
        "I63233",
        "I63239",
        "I6329",
        "I6330",
        "I63311",
        "I63312",
        "I63313",
        "I63319",
        "I63321",
        "I63322",
        "I63323",
        "I63329",
        "I63331",
        "I63332",
        "I63333",
        "I63339",
        "I63341",
        "I63342",
        "I63343",
        "I63349",
        "I6339",
        "I6340",
        "I63411",
        "I63412",
        "I63413",
        "I63419",
        "I63421",
        "I63422",
        "I63423",
        "I63429",
        "I63431",
        "I63432",
        "I63433",
        "I63439",
        "I63441",
        "I63442",
        "I63443",
        "I63449",
        "I6349",
        "I6350",
        "I63511",
        "I63512",
        "I63513",
        "I63519",
        "I63521",
        "I63522",
        "I63523",
        "I63529",
        "I63531",
        "I63532",
        "I63533",
        "I63539",
        "I63541",
        "I63542",
        "I63543",
        "I63549",
        "I6359",
        "I636",
        "I638",
        "I639",
        "I97810",
        "I97811",
        "I97820",
        "I97821",
        "G8100",
        "G8101",
        "G8102",
        "G8103",
        "G8104",
        "G8110",
        "G8111",
        "G8112",
        "G8113",
        "G8114",
        "G8190",
        "G8191",
        "G8192",
        "G8193",
        "G8194",
        "I69051",
        "I69052",
        "I69053",
        "I69054",
        "I69059",
        "I69151",
        "I69152",
        "I69153",
        "I69154",
        "I69159",
        "I69251",
        "I69252",
        "I69253",
        "I69254",
        "I69259",
        "I69351",
        "I69352",
        "I69353",
        "I69354",
        "I69359",
        "I69851",
        "I69852",
        "I69853",
        "I69854",
        "I69859",
        "I69951",
        "I69952",
        "I69953",
        "I69954",
        "I69959",
        "G830",
        "G8310",
        "G8311",
        "G8312",
        "G8313",
        "G8314",
        "G8320",
        "G8321",
        "G8322",
        "G8323",
        "G8324",
        "G8330",
        "G8331",
        "G8332",
        "G8333",
        "G8334",
        "G835",
        "G8381",
        "G8382",
        "G8383",
        "G8384",
        "G8389",
        "G839",
        "I69031",
        "I69032",
        "I69033",
        "I69034",
        "I69039",
        "I69041",
        "I69042",
        "I69043",
        "I69044",
        "I69049",
        "I69061",
        "I69062",
        "I69063",
        "I69064",
        "I69065",
        "I69069",
        "I69131",
        "I69132",
        "I69133",
        "I69134",
        "I69139",
        "I69141",
        "I69142",
        "I69143",
        "I69144",
        "I69149",
        "I69161",
        "I69162",
        "I69163",
        "I69164",
        "I69165",
        "I69169",
        "I69231",
        "I69232",
        "I69233",
        "I69234",
        "I69239",
        "I69241",
        "I69242",
        "I69243",
        "I69244",
        "I69249",
        "I69261",
        "I69262",
        "I69263",
        "I69264",
        "I69265",
        "I69269",
        "I69331",
        "I69332",
        "I69333",
        "I69334",
        "I69339",
        "I69341",
        "I69342",
        "I69343",
        "I69344",
        "I69349",
        "I69361",
        "I69362",
        "I69363",
        "I69364",
        "I69365",
        "I69369",
        "I69831",
        "I69832",
        "I69833",
        "I69834",
        "I69839",
        "I69841",
        "I69842",
        "I69843",
        "I69844",
        "I69849",
        "I69861",
        "I69862",
        "I69863",
        "I69864",
        "I69865",
        "I69869",
        "I69931",
        "I69932",
        "I69933",
        "I69934",
        "I69939",
        "I69941",
        "I69942",
        "I69943",
        "I69944",
        "I69949",
        "I69961",
        "I69962",
        "I69963",
        "I69964",
        "I69965",
        "I69969",
        "A480",
        "I70231",
        "I70232",
        "I70233",
        "I70234",
        "I70235",
        "I70238",
        "I70239",
        "I70241",
        "I70242",
        "I70243",
        "I70244",
        "I70245",
        "I70248",
        "I70249",
        "I7025",
        "I70261",
        "I70262",
        "I70263",
        "I70268",
        "I70269",
        "I70331",
        "I70332",
        "I70333",
        "I70334",
        "I70335",
        "I70338",
        "I70339",
        "I70341",
        "I70342",
        "I70343",
        "I70344",
        "I70345",
        "I70348",
        "I70349",
        "I7035",
        "I70361",
        "I70362",
        "I70363",
        "I70368",
        "I70369",
        "I70431",
        "I70432",
        "I70433",
        "I70434",
        "I70435",
        "I70438",
        "I70439",
        "I70441",
        "I70442",
        "I70443",
        "I70444",
        "I70445",
        "I70448",
        "I70449",
        "I7045",
        "I70461",
        "I70462",
        "I70463",
        "I70468",
        "I70469",
        "I70531",
        "I70532",
        "I70533",
        "I70534",
        "I70535",
        "I70538",
        "I70539",
        "I70541",
        "I70542",
        "I70543",
        "I70544",
        "I70545",
        "I70548",
        "I70549",
        "I7055",
        "I70561",
        "I70562",
        "I70563",
        "I70568",
        "I70569",
        "I70631",
        "I70632",
        "I70633",
        "I70634",
        "I70635",
        "I70638",
        "I70639",
        "I70641",
        "I70642",
        "I70643",
        "I70644",
        "I70645",
        "I70648",
        "I70649",
        "I7065",
        "I70661",
        "I70662",
        "I70663",
        "I70668",
        "I70669",
        "I70731",
        "I70732",
        "I70733",
        "I70734",
        "I70735",
        "I70738",
        "I70739",
        "I70741",
        "I70742",
        "I70743",
        "I70744",
        "I70745",
        "I70748",
        "I70749",
        "I7075",
        "I70761",
        "I70762",
        "I70763",
        "I70768",
        "I70769",
        "I7301",
        "I96",
        "I2690",
        "I2692",
        "I2699",
        "I2782",
        "I670",
        "I7100",
        "I7101",
        "I7102",
        "I7103",
        "I711",
        "I713",
        "I715",
        "I718",
        "I7401",
        "I7409",
        "I7410",
        "I7411",
        "I7419",
        "I742",
        "I743",
        "I744",
        "I745",
        "I748",
        "I749",
        "I75011",
        "I75012",
        "I75013",
        "I75019",
        "I75021",
        "I75022",
        "I75023",
        "I75029",
        "I7581",
        "I7589",
        "I76",
        "I7770",
        "I7771",
        "I7772",
        "I7773",
        "I7774",
        "I7775",
        "I7776",
        "I7777",
        "I7779",
        "I83001",
        "I83002",
        "I83003",
        "I83004",
        "I83005",
        "I83008",
        "I83009",
        "I83011",
        "I83012",
        "I83013",
        "I83014",
        "I83015",
        "I83018",
        "I83019",
        "I83021",
        "I83022",
        "I83023",
        "I83024",
        "I83025",
        "I83028",
        "I83029",
        "I83201",
        "I83202",
        "I83203",
        "I83204",
        "I83205",
        "I83208",
        "I83209",
        "I83211",
        "I83212",
        "I83213",
        "I83214",
        "I83215",
        "I83218",
        "I83219",
        "I83221",
        "I83222",
        "I83223",
        "I83224",
        "I83225",
        "I83228",
        "I83229",
        "I87011",
        "I87012",
        "I87013",
        "I87019",
        "I87031",
        "I87032",
        "I87033",
        "I87039",
        "I87311",
        "I87312",
        "I87313",
        "I87319",
        "I87331",
        "I87332",
        "I87333",
        "I87339",
        "K550",
        "K55011",
        "K55012",
        "K55019",
        "K55021",
        "K55022",
        "K55029",
        "K55031",
        "K55032",
        "K55039",
        "K55041",
        "K55042",
        "K55049",
        "K55051",
        "K55052",
        "K55059",
        "K55061",
        "K55062",
        "K55069",
        "K5530",
        "K5531",
        "K5532",
        "K5533",
        "N280",
        "I700",
        "I701",
        "I70201",
        "I70202",
        "I70203",
        "I70208",
        "I70209",
        "I70211",
        "I70212",
        "I70213",
        "I70218",
        "I70219",
        "I70221",
        "I70222",
        "I70223",
        "I70228",
        "I70229",
        "I70291",
        "I70292",
        "I70293",
        "I70298",
        "I70299",
        "I70301",
        "I70302",
        "I70303",
        "I70308",
        "I70309",
        "I70311",
        "I70312",
        "I70313",
        "I70318",
        "I70319",
        "I70321",
        "I70322",
        "I70323",
        "I70328",
        "I70329",
        "I70391",
        "I70392",
        "I70393",
        "I70398",
        "I70399",
        "I70401",
        "I70402",
        "I70403",
        "I70408",
        "I70409",
        "I70411",
        "I70412",
        "I70413",
        "I70418",
        "I70419",
        "I70421",
        "I70422",
        "I70423",
        "I70428",
        "I70429",
        "I70491",
        "I70492",
        "I70493",
        "I70498",
        "I70499",
        "I70501",
        "I70502",
        "I70503",
        "I70508",
        "I70509",
        "I70511",
        "I70512",
        "I70513",
        "I70518",
        "I70519",
        "I70521",
        "I70522",
        "I70523",
        "I70528",
        "I70529",
        "I70591",
        "I70592",
        "I70593",
        "I70598",
        "I70599",
        "I70601",
        "I70602",
        "I70603",
        "I70608",
        "I70609",
        "I70611",
        "I70612",
        "I70613",
        "I70618",
        "I70619",
        "I70621",
        "I70622",
        "I70623",
        "I70628",
        "I70629",
        "I70691",
        "I70692",
        "I70693",
        "I70698",
        "I70699",
        "I70701",
        "I70702",
        "I70703",
        "I70708",
        "I70709",
        "I70711",
        "I70712",
        "I70713",
        "I70718",
        "I70719",
        "I70721",
        "I70722",
        "I70723",
        "I70728",
        "I70729",
        "I70791",
        "I70792",
        "I70793",
        "I70798",
        "I70799",
        "I7092",
        "I712",
        "I714",
        "I716",
        "I719",
        "I720",
        "I721",
        "I722",
        "I723",
        "I724",
        "I725",
        "I726",
        "I728",
        "I729",
        "I731",
        "I7381",
        "I7389",
        "I739",
        "I770",
        "I771",
        "I772",
        "I773",
        "I774",
        "I775",
        "I776",
        "I77810",
        "I77811",
        "I77812",
        "I77819",
        "I7789",
        "I779",
        "I780",
        "I790",
        "I791",
        "I798",
        "I8010",
        "I8011",
        "I8012",
        "I8013",
        "I80201",
        "I80202",
        "I80203",
        "I80209",
        "I80211",
        "I80212",
        "I80213",
        "I80219",
        "I80221",
        "I80222",
        "I80223",
        "I80229",
        "I80231",
        "I80232",
        "I80233",
        "I80239",
        "I80291",
        "I80292",
        "I80293",
        "I80299",
        "I820",
        "I82210",
        "I82211",
        "I82220",
        "I82221",
        "I82290",
        "I82291",
        "I823",
        "I82401",
        "I82402",
        "I82403",
        "I82409",
        "I82411",
        "I82412",
        "I82413",
        "I82419",
        "I82421",
        "I82422",
        "I82423",
        "I82429",
        "I82431",
        "I82432",
        "I82433",
        "I82439",
        "I82441",
        "I82442",
        "I82443",
        "I82449",
        "I82491",
        "I82492",
        "I82493",
        "I82499",
        "I824Y1",
        "I824Y2",
        "I824Y3",
        "I824Y9",
        "I824Z1",
        "I824Z2",
        "I824Z3",
        "I824Z9",
        "I82501",
        "I82502",
        "I82503",
        "I82509",
        "I82511",
        "I82512",
        "I82513",
        "I82519",
        "I82521",
        "I82522",
        "I82523",
        "I82529",
        "I82531",
        "I82532",
        "I82533",
        "I82539",
        "I82541",
        "I82542",
        "I82543",
        "I82549",
        "I82591",
        "I82592",
        "I82593",
        "I82599",
        "I825Y1",
        "I825Y2",
        "I825Y3",
        "I825Y9",
        "I825Z1",
        "I825Z2",
        "I825Z3",
        "I825Z9",
        "I82621",
        "I82622",
        "I82623",
        "I82629",
        "I82721",
        "I82722",
        "I82723",
        "I82729",
        "I82A11",
        "I82A12",
        "I82A13",
        "I82A19",
        "I82A21",
        "I82A22",
        "I82A23",
        "I82A29",
        "I82B11",
        "I82B12",
        "I82B13",
        "I82B19",
        "I82B21",
        "I82B22",
        "I82B23",
        "I82B29",
        "I82C11",
        "I82C12",
        "I82C13",
        "I82C19",
        "I82C21",
        "I82C22",
        "I82C23",
        "I82C29",
        "K551",
        "K558",
        "K559",
        "M318",
        "M319",
        "E840",
        "E8411",
        "E8419",
        "E848",
        "E849",
        "J410",
        "J411",
        "J418",
        "J42",
        "J430",
        "J431",
        "J432",
        "J438",
        "J439",
        "J440",
        "J441",
        "J449",
        "J982",
        "J983",
        "B4481",
        "D860",
        "D862",
        "J470",
        "J471",
        "J479",
        "J60",
        "J61",
        "J620",
        "J628",
        "J630",
        "J631",
        "J632",
        "J633",
        "J634",
        "J635",
        "J636",
        "J64",
        "J65",
        "J660",
        "J661",
        "J662",
        "J668",
        "J670",
        "J671",
        "J672",
        "J673",
        "J674",
        "J675",
        "J676",
        "J677",
        "J678",
        "J679",
        "J680",
        "J681",
        "J682",
        "J683",
        "J684",
        "J688",
        "J689",
        "J700",
        "J701",
        "J702",
        "J703",
        "J704",
        "J705",
        "J708",
        "J709",
        "J82",
        "J8401",
        "J8402",
        "J8403",
        "J8409",
        "J8410",
        "J84111",
        "J84112",
        "J84113",
        "J84114",
        "J84115",
        "J84116",
        "J84117",
        "J8417",
        "J842",
        "J8481",
        "J8482",
        "J8483",
        "J84841",
        "J84842",
        "J84843",
        "J84848",
        "J8489",
        "J849",
        "J99",
        "A481",
        "J150",
        "J151",
        "J1520",
        "J15211",
        "J15212",
        "J1529",
        "J155",
        "J156",
        "J158",
        "J690",
        "J691",
        "J698",
        "J95851",
        "A0103",
        "A0222",
        "A065",
        "A202",
        "A212",
        "A221",
        "A420",
        "A430",
        "A5484",
        "B380",
        "B381",
        "B382",
        "B390",
        "B391",
        "B392",
        "B400",
        "B401",
        "B402",
        "B410",
        "B664",
        "B671",
        "J13",
        "J14",
        "J153",
        "J154",
        "J181",
        "J850",
        "J851",
        "J852",
        "J853",
        "J860",
        "J869",
        "H4310",
        "H4311",
        "H4312",
        "H4313",
        "H3532",
        "H353210",
        "H353211",
        "H353212",
        "H353213",
        "H353220",
        "H353221",
        "H353222",
        "H353223",
        "H353230",
        "H353231",
        "H353232",
        "H353233",
        "H353290",
        "H353291",
        "H353292",
        "H353293",
        "T81502A",
        "T81502D",
        "T81502S",
        "T81512A",
        "T81512D",
        "T81512S",
        "T81522A",
        "T81522D",
        "T81522S",
        "T81532A",
        "T81532D",
        "T81532S",
        "T81592A",
        "T81592D",
        "T81592S",
        "T8241XA",
        "T8241XD",
        "T8241XS",
        "T8242XA",
        "T8242XD",
        "T8242XS",
        "T8243XA",
        "T8243XD",
        "T8243XS",
        "T8249XA",
        "T8249XD",
        "T8249XS",
        "T85611A",
        "T85611D",
        "T85611S",
        "T85621A",
        "T85621D",
        "T85621S",
        "T85631A",
        "T85631D",
        "T85631S",
        "T85691A",
        "T85691D",
        "T85691S",
        "T8571XA",
        "T8571XD",
        "T8571XS",
        "Y622",
        "Z4901",
        "Z4902",
        "Z4931",
        "Z4932",
        "Z9115",
        "Z992",
        "N170",
        "N171",
        "N172",
        "N178",
        "N179",
        "I120",
        "I1311",
        "N185",
        "N186",
        "N184",
        "L89004",
        "L89014",
        "L89024",
        "L89104",
        "L89114",
        "L89124",
        "L89134",
        "L89144",
        "L89154",
        "L89204",
        "L89214",
        "L89224",
        "L89304",
        "L89314",
        "L89324",
        "L8944",
        "L89504",
        "L89514",
        "L89524",
        "L89604",
        "L89614",
        "L89624",
        "L89814",
        "L89894",
        "L8994",
        "L89000",
        "L89003",
        "L89010",
        "L89013",
        "L89020",
        "L89023",
        "L89100",
        "L89103",
        "L89110",
        "L89113",
        "L89120",
        "L89123",
        "L89130",
        "L89133",
        "L89140",
        "L89143",
        "L89150",
        "L89153",
        "L89200",
        "L89203",
        "L89210",
        "L89213",
        "L89220",
        "L89223",
        "L89300",
        "L89303",
        "L89310",
        "L89313",
        "L89320",
        "L89323",
        "L8943",
        "L8945",
        "L89500",
        "L89503",
        "L89510",
        "L89513",
        "L89520",
        "L89523",
        "L89600",
        "L89603",
        "L89610",
        "L89613",
        "L89620",
        "L89623",
        "L89810",
        "L89813",
        "L89890",
        "L89893",
        "L8993",
        "L8995",
        "L97101",
        "L97102",
        "L97103",
        "L97104",
        "L97109",
        "L97111",
        "L97112",
        "L97113",
        "L97114",
        "L97119",
        "L97121",
        "L97122",
        "L97123",
        "L97124",
        "L97129",
        "L97201",
        "L97202",
        "L97203",
        "L97204",
        "L97209",
        "L97211",
        "L97212",
        "L97213",
        "L97214",
        "L97219",
        "L97221",
        "L97222",
        "L97223",
        "L97224",
        "L97229",
        "L97301",
        "L97302",
        "L97303",
        "L97304",
        "L97309",
        "L97311",
        "L97312",
        "L97313",
        "L97314",
        "L97319",
        "L97321",
        "L97322",
        "L97323",
        "L97324",
        "L97329",
        "L97401",
        "L97402",
        "L97403",
        "L97404",
        "L97409",
        "L97411",
        "L97412",
        "L97413",
        "L97414",
        "L97419",
        "L97421",
        "L97422",
        "L97423",
        "L97424",
        "L97429",
        "L97501",
        "L97502",
        "L97503",
        "L97504",
        "L97509",
        "L97511",
        "L97512",
        "L97513",
        "L97514",
        "L97519",
        "L97521",
        "L97522",
        "L97523",
        "L97524",
        "L97529",
        "L97801",
        "L97802",
        "L97803",
        "L97804",
        "L97809",
        "L97811",
        "L97812",
        "L97813",
        "L97814",
        "L97819",
        "L97821",
        "L97822",
        "L97823",
        "L97824",
        "L97829",
        "L97901",
        "L97902",
        "L97903",
        "L97904",
        "L97909",
        "L97911",
        "L97912",
        "L97913",
        "L97914",
        "L97919",
        "L97921",
        "L97922",
        "L97923",
        "L97924",
        "L97929",
        "L98411",
        "L98412",
        "L98413",
        "L98414",
        "L98419",
        "L98421",
        "L98422",
        "L98423",
        "L98424",
        "L98429",
        "L98491",
        "L98492",
        "L98493",
        "L98494",
        "L98499",
        "L1230",
        "L1231",
        "L1235",
        "L511",
        "L512",
        "L513",
        "T3111",
        "T3121",
        "T3122",
        "T3131",
        "T3132",
        "T3133",
        "T3141",
        "T3142",
        "T3143",
        "T3144",
        "T3151",
        "T3152",
        "T3153",
        "T3154",
        "T3155",
        "T3161",
        "T3162",
        "T3163",
        "T3164",
        "T3165",
        "T3166",
        "T3171",
        "T3172",
        "T3173",
        "T3174",
        "T3175",
        "T3176",
        "T3177",
        "T3181",
        "T3182",
        "T3183",
        "T3184",
        "T3185",
        "T3186",
        "T3187",
        "T3188",
        "T3191",
        "T3192",
        "T3193",
        "T3194",
        "T3195",
        "T3196",
        "T3197",
        "T3198",
        "T3199",
        "T3211",
        "T3221",
        "T3222",
        "T3231",
        "T3232",
        "T3233",
        "T3241",
        "T3242",
        "T3243",
        "T3244",
        "T3251",
        "T3252",
        "T3253",
        "T3254",
        "T3255",
        "T3261",
        "T3262",
        "T3263",
        "T3264",
        "T3265",
        "T3266",
        "T3271",
        "T3272",
        "T3273",
        "T3274",
        "T3275",
        "T3276",
        "T3277",
        "T3281",
        "T3282",
        "T3283",
        "T3284",
        "T3285",
        "T3286",
        "T3287",
        "T3288",
        "T3291",
        "T3292",
        "T3293",
        "T3294",
        "T3295",
        "T3296",
        "T3297",
        "T3298",
        "T3299",
        "S061X3A",
        "S061X4A",
        "S061X5A",
        "S061X6A",
        "S062X3A",
        "S062X4A",
        "S062X5A",
        "S062X6A",
        "S06303A",
        "S06304A",
        "S06305A",
        "S06306A",
        "S06313A",
        "S06314A",
        "S06315A",
        "S06316A",
        "S06323A",
        "S06324A",
        "S06325A",
        "S06326A",
        "S06333A",
        "S06334A",
        "S06335A",
        "S06336A",
        "S06343A",
        "S06344A",
        "S06345A",
        "S06346A",
        "S06353A",
        "S06354A",
        "S06355A",
        "S06356A",
        "S06363A",
        "S06364A",
        "S06365A",
        "S06366A",
        "S06373A",
        "S06374A",
        "S06375A",
        "S06376A",
        "S06383A",
        "S06384A",
        "S06385A",
        "S06386A",
        "S064X3A",
        "S064X4A",
        "S064X5A",
        "S064X6A",
        "S065X3A",
        "S065X4A",
        "S065X5A",
        "S065X6A",
        "S066X3A",
        "S066X4A",
        "S066X5A",
        "S066X6A",
        "S06813A",
        "S06814A",
        "S06815A",
        "S06816A",
        "S06823A",
        "S06824A",
        "S06825A",
        "S06826A",
        "S06893A",
        "S06894A",
        "S06895A",
        "S06896A",
        "S069X3A",
        "S069X4A",
        "S069X5A",
        "S069X6A",
        "S020XXA",
        "S020XXB",
        "S020XXS",
        "S02101A",
        "S02101B",
        "S02101S",
        "S02102A",
        "S02102B",
        "S02102S",
        "S02109A",
        "S02109B",
        "S02109S",
        "S0210XA",
        "S0210XB",
        "S0210XS",
        "S02110A",
        "S02110B",
        "S02110S",
        "S02111A",
        "S02111B",
        "S02111S",
        "S02112A",
        "S02112B",
        "S02112S",
        "S02113A",
        "S02113B",
        "S02113S",
        "S02118A",
        "S02118B",
        "S02118S",
        "S02119A",
        "S02119B",
        "S02119S",
        "S0211AA",
        "S0211AB",
        "S0211AS",
        "S0211BA",
        "S0211BB",
        "S0211BS",
        "S0211CA",
        "S0211CB",
        "S0211CS",
        "S0211DA",
        "S0211DB",
        "S0211DS",
        "S0211EA",
        "S0211EB",
        "S0211ES",
        "S0211FA",
        "S0211FB",
        "S0211FS",
        "S0211GA",
        "S0211GB",
        "S0211GS",
        "S0211HA",
        "S0211HB",
        "S0211HS",
        "S0219XA",
        "S0219XB",
        "S0219XS",
        "S0230XA",
        "S0230XB",
        "S0230XS",
        "S0231XA",
        "S0231XB",
        "S0231XS",
        "S0232XA",
        "S0232XB",
        "S0232XS",
        "S023XXA",
        "S023XXB",
        "S023XXS",
        "S02400A",
        "S02400B",
        "S02400S",
        "S02401A",
        "S02401B",
        "S02401S",
        "S02402A",
        "S02402B",
        "S02402S",
        "S0240AA",
        "S0240AB",
        "S0240AS",
        "S0240BA",
        "S0240BB",
        "S0240BS",
        "S0240CA",
        "S0240CB",
        "S0240CS",
        "S0240DA",
        "S0240DB",
        "S0240DS",
        "S0240EA",
        "S0240EB",
        "S0240ES",
        "S0240FA",
        "S0240FB",
        "S0240FS",
        "S02411A",
        "S02411B",
        "S02411S",
        "S02412A",
        "S02412B",
        "S02412S",
        "S02413A",
        "S02413B",
        "S02413S",
        "S0242XA",
        "S0242XB",
        "S0242XS",
        "S02600A",
        "S02600B",
        "S02600S",
        "S02601A",
        "S02601B",
        "S02601S",
        "S02602A",
        "S02602B",
        "S02602S",
        "S02609A",
        "S02609B",
        "S02609S",
        "S02610A",
        "S02610B",
        "S02610S",
        "S02611A",
        "S02611B",
        "S02611S",
        "S02612A",
        "S02612B",
        "S02612S",
        "S0261XA",
        "S0261XB",
        "S0261XS",
        "S02620A",
        "S02620B",
        "S02620S",
        "S02621A",
        "S02621B",
        "S02621S",
        "S02622A",
        "S02622B",
        "S02622S",
        "S0262XA",
        "S0262XB",
        "S0262XS",
        "S02630A",
        "S02630B",
        "S02630S",
        "S02631A",
        "S02631B",
        "S02631S",
        "S02632A",
        "S02632B",
        "S02632S",
        "S0263XA",
        "S0263XB",
        "S0263XS",
        "S02640A",
        "S02640B",
        "S02640S",
        "S02641A",
        "S02641B",
        "S02641S",
        "S02642A",
        "S02642B",
        "S02642S",
        "S0264XA",
        "S0264XB",
        "S0264XS",
        "S02650A",
        "S02650B",
        "S02650S",
        "S02651A",
        "S02651B",
        "S02651S",
        "S02652A",
        "S02652B",
        "S02652S",
        "S0265XA",
        "S0265XB",
        "S0265XS",
        "S0266XA",
        "S0266XB",
        "S0266XS",
        "S02670A",
        "S02670B",
        "S02670S",
        "S02671A",
        "S02671B",
        "S02671S",
        "S02672A",
        "S02672B",
        "S02672S",
        "S0267XA",
        "S0267XB",
        "S0267XS",
        "S0269XA",
        "S0269XB",
        "S0269XS",
        "S0280XA",
        "S0280XB",
        "S0280XS",
        "S0281XA",
        "S0281XB",
        "S0281XS",
        "S0282XA",
        "S0282XB",
        "S0282XS",
        "S028XXA",
        "S028XXB",
        "S028XXS",
        "S0291XA",
        "S0291XB",
        "S0291XS",
        "S0292XA",
        "S0292XB",
        "S0292XS",
        "S060X0S",
        "S060X1S",
        "S060X2S",
        "S060X3A",
        "S060X3S",
        "S060X4A",
        "S060X4S",
        "S060X5A",
        "S060X5S",
        "S060X6A",
        "S060X6S",
        "S060X9S",
        "S061X0A",
        "S061X0S",
        "S061X1A",
        "S061X1S",
        "S061X2A",
        "S061X2S",
        "S061X3S",
        "S061X4S",
        "S061X5S",
        "S061X6S",
        "S061X9A",
        "S061X9S",
        "S062X0A",
        "S062X0S",
        "S062X1A",
        "S062X1S",
        "S062X2A",
        "S062X2S",
        "S062X3S",
        "S062X4S",
        "S062X5S",
        "S062X6S",
        "S062X9A",
        "S062X9S",
        "S06300A",
        "S06300S",
        "S06301A",
        "S06301S",
        "S06302A",
        "S06302S",
        "S06303S",
        "S06304S",
        "S06305S",
        "S06306S",
        "S06309A",
        "S06309S",
        "S06310A",
        "S06310S",
        "S06311A",
        "S06311S",
        "S06312A",
        "S06312S",
        "S06313S",
        "S06314S",
        "S06315S",
        "S06316S",
        "S06319A",
        "S06319S",
        "S06320A",
        "S06320S",
        "S06321A",
        "S06321S",
        "S06322A",
        "S06322S",
        "S06323S",
        "S06324S",
        "S06325S",
        "S06326S",
        "S06329A",
        "S06329S",
        "S06330A",
        "S06330S",
        "S06331A",
        "S06331S",
        "S06332A",
        "S06332S",
        "S06333S",
        "S06334S",
        "S06335S",
        "S06336S",
        "S06339A",
        "S06339S",
        "S06340A",
        "S06340S",
        "S06341A",
        "S06341S",
        "S06342A",
        "S06342S",
        "S06343S",
        "S06344S",
        "S06345S",
        "S06346S",
        "S06349A",
        "S06349S",
        "S06350A",
        "S06350S",
        "S06351A",
        "S06351S",
        "S06352A",
        "S06352S",
        "S06353S",
        "S06354S",
        "S06355S",
        "S06356S",
        "S06359A",
        "S06359S",
        "S06360A",
        "S06360S",
        "S06361A",
        "S06361S",
        "S06362A",
        "S06362S",
        "S06363S",
        "S06364S",
        "S06365S",
        "S06366S",
        "S06369A",
        "S06369S",
        "S06370A",
        "S06370S",
        "S06371A",
        "S06371S",
        "S06372A",
        "S06372S",
        "S06373S",
        "S06374S",
        "S06375S",
        "S06376S",
        "S06379A",
        "S06379S",
        "S06380A",
        "S06380S",
        "S06381A",
        "S06381S",
        "S06382A",
        "S06382S",
        "S06383S",
        "S06384S",
        "S06385S",
        "S06386S",
        "S06389A",
        "S06389S",
        "S064X0A",
        "S064X0S",
        "S064X1A",
        "S064X1S",
        "S064X2A",
        "S064X2S",
        "S064X3S",
        "S064X4S",
        "S064X5S",
        "S064X6S",
        "S064X9A",
        "S064X9S",
        "S065X0A",
        "S065X0S",
        "S065X1A",
        "S065X1S",
        "S065X2A",
        "S065X2S",
        "S065X3S",
        "S065X4S",
        "S065X5S",
        "S065X6S",
        "S065X9A",
        "S065X9S",
        "S066X0A",
        "S066X0S",
        "S066X1A",
        "S066X1S",
        "S066X2A",
        "S066X2S",
        "S066X3S",
        "S066X4S",
        "S066X5S",
        "S066X6S",
        "S066X9A",
        "S066X9S",
        "S06810A",
        "S06810S",
        "S06811A",
        "S06811S",
        "S06812A",
        "S06812S",
        "S06813S",
        "S06814S",
        "S06815S",
        "S06816S",
        "S06819A",
        "S06819S",
        "S06820A",
        "S06820S",
        "S06821A",
        "S06821S",
        "S06822A",
        "S06822S",
        "S06823S",
        "S06824S",
        "S06825S",
        "S06826S",
        "S06829A",
        "S06829S",
        "S06890A",
        "S06890S",
        "S06891A",
        "S06891S",
        "S06892A",
        "S06892S",
        "S06893S",
        "S06894S",
        "S06895S",
        "S06896S",
        "S06899A",
        "S06899S",
        "S069X0A",
        "S069X0S",
        "S069X1A",
        "S069X1S",
        "S069X2A",
        "S069X2S",
        "S069X3S",
        "S069X4S",
        "S069X5S",
        "S069X6S",
        "S069X9A",
        "S069X9S",
        "M4850XA",
        "M4851XA",
        "M4852XA",
        "M4853XA",
        "M4854XA",
        "M4855XA",
        "M4856XA",
        "M4857XA",
        "M4858XA",
        "M8008XA",
        "M8088XA",
        "S12000A",
        "S12000B",
        "S12001A",
        "S12001B",
        "S1201XA",
        "S1201XB",
        "S1202XA",
        "S1202XB",
        "S12030A",
        "S12030B",
        "S12031A",
        "S12031B",
        "S12040A",
        "S12040B",
        "S12041A",
        "S12041B",
        "S12090A",
        "S12090B",
        "S12091A",
        "S12091B",
        "S12100A",
        "S12100B",
        "S12101A",
        "S12101B",
        "S12110A",
        "S12110B",
        "S12111A",
        "S12111B",
        "S12112A",
        "S12112B",
        "S12120A",
        "S12120B",
        "S12121A",
        "S12121B",
        "S12130A",
        "S12130B",
        "S12131A",
        "S12131B",
        "S1214XA",
        "S1214XB",
        "S12150A",
        "S12150B",
        "S12151A",
        "S12151B",
        "S12190A",
        "S12190B",
        "S12191A",
        "S12191B",
        "S12200A",
        "S12200B",
        "S12201A",
        "S12201B",
        "S12230A",
        "S12230B",
        "S12231A",
        "S12231B",
        "S1224XA",
        "S1224XB",
        "S12250A",
        "S12250B",
        "S12251A",
        "S12251B",
        "S12290A",
        "S12290B",
        "S12291A",
        "S12291B",
        "S12300A",
        "S12300B",
        "S12301A",
        "S12301B",
        "S12330A",
        "S12330B",
        "S12331A",
        "S12331B",
        "S1234XA",
        "S1234XB",
        "S12350A",
        "S12350B",
        "S12351A",
        "S12351B",
        "S12390A",
        "S12390B",
        "S12391A",
        "S12391B",
        "S12400A",
        "S12400B",
        "S12401A",
        "S12401B",
        "S12430A",
        "S12430B",
        "S12431A",
        "S12431B",
        "S1244XA",
        "S1244XB",
        "S12450A",
        "S12450B",
        "S12451A",
        "S12451B",
        "S12490A",
        "S12490B",
        "S12491A",
        "S12491B",
        "S12500A",
        "S12500B",
        "S12501A",
        "S12501B",
        "S12530A",
        "S12530B",
        "S12531A",
        "S12531B",
        "S1254XA",
        "S1254XB",
        "S12550A",
        "S12550B",
        "S12551A",
        "S12551B",
        "S12590A",
        "S12590B",
        "S12591A",
        "S12591B",
        "S12600A",
        "S12600B",
        "S12601A",
        "S12601B",
        "S12630A",
        "S12630B",
        "S12631A",
        "S12631B",
        "S1264XA",
        "S1264XB",
        "S12650A",
        "S12650B",
        "S12651A",
        "S12651B",
        "S12690A",
        "S12690B",
        "S12691A",
        "S12691B",
        "S128XXA",
        "S129XXA",
        "S22000A",
        "S22000B",
        "S22001A",
        "S22001B",
        "S22002A",
        "S22002B",
        "S22008A",
        "S22008B",
        "S22009A",
        "S22009B",
        "S22010A",
        "S22010B",
        "S22011A",
        "S22011B",
        "S22012A",
        "S22012B",
        "S22018A",
        "S22018B",
        "S22019A",
        "S22019B",
        "S22020A",
        "S22020B",
        "S22021A",
        "S22021B",
        "S22022A",
        "S22022B",
        "S22028A",
        "S22028B",
        "S22029A",
        "S22029B",
        "S22030A",
        "S22030B",
        "S22031A",
        "S22031B",
        "S22032A",
        "S22032B",
        "S22038A",
        "S22038B",
        "S22039A",
        "S22039B",
        "S22040A",
        "S22040B",
        "S22041A",
        "S22041B",
        "S22042A",
        "S22042B",
        "S22048A",
        "S22048B",
        "S22049A",
        "S22049B",
        "S22050A",
        "S22050B",
        "S22051A",
        "S22051B",
        "S22052A",
        "S22052B",
        "S22058A",
        "S22058B",
        "S22059A",
        "S22059B",
        "S22060A",
        "S22060B",
        "S22061A",
        "S22061B",
        "S22062A",
        "S22062B",
        "S22068A",
        "S22068B",
        "S22069A",
        "S22069B",
        "S22070A",
        "S22070B",
        "S22071A",
        "S22071B",
        "S22072A",
        "S22072B",
        "S22078A",
        "S22078B",
        "S22079A",
        "S22079B",
        "S22080A",
        "S22080B",
        "S22081A",
        "S22081B",
        "S22082A",
        "S22082B",
        "S22088A",
        "S22088B",
        "S22089A",
        "S22089B",
        "S32000A",
        "S32000B",
        "S32001A",
        "S32001B",
        "S32002A",
        "S32002B",
        "S32008A",
        "S32008B",
        "S32009A",
        "S32009B",
        "S32010A",
        "S32010B",
        "S32011A",
        "S32011B",
        "S32012A",
        "S32012B",
        "S32018A",
        "S32018B",
        "S32019A",
        "S32019B",
        "S32020A",
        "S32020B",
        "S32021A",
        "S32021B",
        "S32022A",
        "S32022B",
        "S32028A",
        "S32028B",
        "S32029A",
        "S32029B",
        "S32030A",
        "S32030B",
        "S32031A",
        "S32031B",
        "S32032A",
        "S32032B",
        "S32038A",
        "S32038B",
        "S32039A",
        "S32039B",
        "S32040A",
        "S32040B",
        "S32041A",
        "S32041B",
        "S32042A",
        "S32042B",
        "S32048A",
        "S32048B",
        "S32049A",
        "S32049B",
        "S32050A",
        "S32050B",
        "S32051A",
        "S32051B",
        "S32052A",
        "S32052B",
        "S32058A",
        "S32058B",
        "S32059A",
        "S32059B",
        "S3210XA",
        "S3210XB",
        "S32110A",
        "S32110B",
        "S32111A",
        "S32111B",
        "S32112A",
        "S32112B",
        "S32119A",
        "S32119B",
        "S32120A",
        "S32120B",
        "S32121A",
        "S32121B",
        "S32122A",
        "S32122B",
        "S32129A",
        "S32129B",
        "S32130A",
        "S32130B",
        "S32131A",
        "S32131B",
        "S32132A",
        "S32132B",
        "S32139A",
        "S32139B",
        "S3214XA",
        "S3214XB",
        "S3215XA",
        "S3215XB",
        "S3216XA",
        "S3216XB",
        "S3217XA",
        "S3217XB",
        "S3219XA",
        "S3219XB",
        "S322XXA",
        "S322XXB",
        "M80051A",
        "M80052A",
        "M80059A",
        "M80851A",
        "M80852A",
        "M80859A",
        "M84451A",
        "M84452A",
        "M84453A",
        "M84459A",
        "M84551A",
        "M84552A",
        "M84553A",
        "M84559A",
        "M84651A",
        "M84652A",
        "M84653A",
        "M84659A",
        "M84754A",
        "M84755A",
        "M84756A",
        "M84757A",
        "M84758A",
        "M84759A",
        "M9701XA",
        "M9702XA",
        "S32301A",
        "S32301B",
        "S32302A",
        "S32302B",
        "S32309A",
        "S32309B",
        "S32311A",
        "S32311B",
        "S32312A",
        "S32312B",
        "S32313A",
        "S32313B",
        "S32314A",
        "S32314B",
        "S32315A",
        "S32315B",
        "S32316A",
        "S32316B",
        "S32391A",
        "S32391B",
        "S32392A",
        "S32392B",
        "S32399A",
        "S32399B",
        "S32401A",
        "S32401B",
        "S32402A",
        "S32402B",
        "S32409A",
        "S32409B",
        "S32411A",
        "S32411B",
        "S32412A",
        "S32412B",
        "S32413A",
        "S32413B",
        "S32414A",
        "S32414B",
        "S32415A",
        "S32415B",
        "S32416A",
        "S32416B",
        "S32421A",
        "S32421B",
        "S32422A",
        "S32422B",
        "S32423A",
        "S32423B",
        "S32424A",
        "S32424B",
        "S32425A",
        "S32425B",
        "S32426A",
        "S32426B",
        "S32431A",
        "S32431B",
        "S32432A",
        "S32432B",
        "S32433A",
        "S32433B",
        "S32434A",
        "S32434B",
        "S32435A",
        "S32435B",
        "S32436A",
        "S32436B",
        "S32441A",
        "S32441B",
        "S32442A",
        "S32442B",
        "S32443A",
        "S32443B",
        "S32444A",
        "S32444B",
        "S32445A",
        "S32445B",
        "S32446A",
        "S32446B",
        "S32451A",
        "S32451B",
        "S32452A",
        "S32452B",
        "S32453A",
        "S32453B",
        "S32454A",
        "S32454B",
        "S32455A",
        "S32455B",
        "S32456A",
        "S32456B",
        "S32461A",
        "S32461B",
        "S32462A",
        "S32462B",
        "S32463A",
        "S32463B",
        "S32464A",
        "S32464B",
        "S32465A",
        "S32465B",
        "S32466A",
        "S32466B",
        "S32471A",
        "S32471B",
        "S32472A",
        "S32472B",
        "S32473A",
        "S32473B",
        "S32474A",
        "S32474B",
        "S32475A",
        "S32475B",
        "S32476A",
        "S32476B",
        "S32481A",
        "S32481B",
        "S32482A",
        "S32482B",
        "S32483A",
        "S32483B",
        "S32484A",
        "S32484B",
        "S32485A",
        "S32485B",
        "S32486A",
        "S32486B",
        "S32491A",
        "S32491B",
        "S32492A",
        "S32492B",
        "S32499A",
        "S32499B",
        "S32501A",
        "S32501B",
        "S32502A",
        "S32502B",
        "S32509A",
        "S32509B",
        "S32511A",
        "S32511B",
        "S32512A",
        "S32512B",
        "S32519A",
        "S32519B",
        "S32591A",
        "S32591B",
        "S32592A",
        "S32592B",
        "S32599A",
        "S32599B",
        "S32601A",
        "S32601B",
        "S32602A",
        "S32602B",
        "S32609A",
        "S32609B",
        "S32611A",
        "S32611B",
        "S32612A",
        "S32612B",
        "S32613A",
        "S32613B",
        "S32614A",
        "S32614B",
        "S32615A",
        "S32615B",
        "S32616A",
        "S32616B",
        "S32691A",
        "S32691B",
        "S32692A",
        "S32692B",
        "S32699A",
        "S32699B",
        "S32810A",
        "S32810B",
        "S32811A",
        "S32811B",
        "S3282XA",
        "S3282XB",
        "S3289XA",
        "S3289XB",
        "S329XXA",
        "S329XXB",
        "S72001A",
        "S72001B",
        "S72001C",
        "S72002A",
        "S72002B",
        "S72002C",
        "S72009A",
        "S72009B",
        "S72009C",
        "S72011A",
        "S72011B",
        "S72011C",
        "S72012A",
        "S72012B",
        "S72012C",
        "S72019A",
        "S72019B",
        "S72019C",
        "S72021A",
        "S72021B",
        "S72021C",
        "S72022A",
        "S72022B",
        "S72022C",
        "S72023A",
        "S72023B",
        "S72023C",
        "S72024A",
        "S72024B",
        "S72024C",
        "S72025A",
        "S72025B",
        "S72025C",
        "S72026A",
        "S72026B",
        "S72026C",
        "S72031A",
        "S72031B",
        "S72031C",
        "S72032A",
        "S72032B",
        "S72032C",
        "S72033A",
        "S72033B",
        "S72033C",
        "S72034A",
        "S72034B",
        "S72034C",
        "S72035A",
        "S72035B",
        "S72035C",
        "S72036A",
        "S72036B",
        "S72036C",
        "S72041A",
        "S72041B",
        "S72041C",
        "S72042A",
        "S72042B",
        "S72042C",
        "S72043A",
        "S72043B",
        "S72043C",
        "S72044A",
        "S72044B",
        "S72044C",
        "S72045A",
        "S72045B",
        "S72045C",
        "S72046A",
        "S72046B",
        "S72046C",
        "S72051A",
        "S72051B",
        "S72051C",
        "S72052A",
        "S72052B",
        "S72052C",
        "S72059A",
        "S72059B",
        "S72059C",
        "S72061A",
        "S72061B",
        "S72061C",
        "S72062A",
        "S72062B",
        "S72062C",
        "S72063A",
        "S72063B",
        "S72063C",
        "S72064A",
        "S72064B",
        "S72064C",
        "S72065A",
        "S72065B",
        "S72065C",
        "S72066A",
        "S72066B",
        "S72066C",
        "S72091A",
        "S72091B",
        "S72091C",
        "S72092A",
        "S72092B",
        "S72092C",
        "S72099A",
        "S72099B",
        "S72099C",
        "S72101A",
        "S72101B",
        "S72101C",
        "S72102A",
        "S72102B",
        "S72102C",
        "S72109A",
        "S72109B",
        "S72109C",
        "S72111A",
        "S72111B",
        "S72111C",
        "S72112A",
        "S72112B",
        "S72112C",
        "S72113A",
        "S72113B",
        "S72113C",
        "S72114A",
        "S72114B",
        "S72114C",
        "S72115A",
        "S72115B",
        "S72115C",
        "S72116A",
        "S72116B",
        "S72116C",
        "S72121A",
        "S72121B",
        "S72121C",
        "S72122A",
        "S72122B",
        "S72122C",
        "S72123A",
        "S72123B",
        "S72123C",
        "S72124A",
        "S72124B",
        "S72124C",
        "S72125A",
        "S72125B",
        "S72125C",
        "S72126A",
        "S72126B",
        "S72126C",
        "S72131A",
        "S72131B",
        "S72131C",
        "S72132A",
        "S72132B",
        "S72132C",
        "S72133A",
        "S72133B",
        "S72133C",
        "S72134A",
        "S72134B",
        "S72134C",
        "S72135A",
        "S72135B",
        "S72135C",
        "S72136A",
        "S72136B",
        "S72136C",
        "S72141A",
        "S72141B",
        "S72141C",
        "S72142A",
        "S72142B",
        "S72142C",
        "S72143A",
        "S72143B",
        "S72143C",
        "S72144A",
        "S72144B",
        "S72144C",
        "S72145A",
        "S72145B",
        "S72145C",
        "S72146A",
        "S72146B",
        "S72146C",
        "S7221XA",
        "S7221XB",
        "S7221XC",
        "S7222XA",
        "S7222XB",
        "S7222XC",
        "S7223XA",
        "S7223XB",
        "S7223XC",
        "S7224XA",
        "S7224XB",
        "S7224XC",
        "S7225XA",
        "S7225XB",
        "S7225XC",
        "S7226XA",
        "S7226XB",
        "S7226XC",
        "S72301A",
        "S72301B",
        "S72301C",
        "S72302A",
        "S72302B",
        "S72302C",
        "S72309A",
        "S72309B",
        "S72309C",
        "S72321A",
        "S72321B",
        "S72321C",
        "S72322A",
        "S72322B",
        "S72322C",
        "S72323A",
        "S72323B",
        "S72323C",
        "S72324A",
        "S72324B",
        "S72324C",
        "S72325A",
        "S72325B",
        "S72325C",
        "S72326A",
        "S72326B",
        "S72326C",
        "S72331A",
        "S72331B",
        "S72331C",
        "S72332A",
        "S72332B",
        "S72332C",
        "S72333A",
        "S72333B",
        "S72333C",
        "S72334A",
        "S72334B",
        "S72334C",
        "S72335A",
        "S72335B",
        "S72335C",
        "S72336A",
        "S72336B",
        "S72336C",
        "S72341A",
        "S72341B",
        "S72341C",
        "S72342A",
        "S72342B",
        "S72342C",
        "S72343A",
        "S72343B",
        "S72343C",
        "S72344A",
        "S72344B",
        "S72344C",
        "S72345A",
        "S72345B",
        "S72345C",
        "S72346A",
        "S72346B",
        "S72346C",
        "S72351A",
        "S72351B",
        "S72351C",
        "S72352A",
        "S72352B",
        "S72352C",
        "S72353A",
        "S72353B",
        "S72353C",
        "S72354A",
        "S72354B",
        "S72354C",
        "S72355A",
        "S72355B",
        "S72355C",
        "S72356A",
        "S72356B",
        "S72356C",
        "S72361A",
        "S72361B",
        "S72361C",
        "S72362A",
        "S72362B",
        "S72362C",
        "S72363A",
        "S72363B",
        "S72363C",
        "S72364A",
        "S72364B",
        "S72364C",
        "S72365A",
        "S72365B",
        "S72365C",
        "S72366A",
        "S72366B",
        "S72366C",
        "S72391A",
        "S72391B",
        "S72391C",
        "S72392A",
        "S72392B",
        "S72392C",
        "S72399A",
        "S72399B",
        "S72399C",
        "S72401A",
        "S72401B",
        "S72401C",
        "S72402A",
        "S72402B",
        "S72402C",
        "S72409A",
        "S72409B",
        "S72409C",
        "S72411A",
        "S72411B",
        "S72411C",
        "S72412A",
        "S72412B",
        "S72412C",
        "S72413A",
        "S72413B",
        "S72413C",
        "S72414A",
        "S72414B",
        "S72414C",
        "S72415A",
        "S72415B",
        "S72415C",
        "S72416A",
        "S72416B",
        "S72416C",
        "S72421A",
        "S72421B",
        "S72421C",
        "S72422A",
        "S72422B",
        "S72422C",
        "S72423A",
        "S72423B",
        "S72423C",
        "S72424A",
        "S72424B",
        "S72424C",
        "S72425A",
        "S72425B",
        "S72425C",
        "S72426A",
        "S72426B",
        "S72426C",
        "S72431A",
        "S72431B",
        "S72431C",
        "S72432A",
        "S72432B",
        "S72432C",
        "S72433A",
        "S72433B",
        "S72433C",
        "S72434A",
        "S72434B",
        "S72434C",
        "S72435A",
        "S72435B",
        "S72435C",
        "S72436A",
        "S72436B",
        "S72436C",
        "S72441A",
        "S72441B",
        "S72441C",
        "S72442A",
        "S72442B",
        "S72442C",
        "S72443A",
        "S72443B",
        "S72443C",
        "S72444A",
        "S72444B",
        "S72444C",
        "S72445A",
        "S72445B",
        "S72445C",
        "S72446A",
        "S72446B",
        "S72446C",
        "S72451A",
        "S72451B",
        "S72451C",
        "S72452A",
        "S72452B",
        "S72452C",
        "S72453A",
        "S72453B",
        "S72453C",
        "S72454A",
        "S72454B",
        "S72454C",
        "S72455A",
        "S72455B",
        "S72455C",
        "S72456A",
        "S72456B",
        "S72456C",
        "S72461A",
        "S72461B",
        "S72461C",
        "S72462A",
        "S72462B",
        "S72462C",
        "S72463A",
        "S72463B",
        "S72463C",
        "S72464A",
        "S72464B",
        "S72464C",
        "S72465A",
        "S72465B",
        "S72465C",
        "S72466A",
        "S72466B",
        "S72466C",
        "S72471A",
        "S72472A",
        "S72479A",
        "S72491A",
        "S72491B",
        "S72491C",
        "S72492A",
        "S72492B",
        "S72492C",
        "S72499A",
        "S72499B",
        "S72499C",
        "S728X1A",
        "S728X1B",
        "S728X1C",
        "S728X2A",
        "S728X2B",
        "S728X2C",
        "S728X9A",
        "S728X9B",
        "S728X9C",
        "S7290XA",
        "S7290XB",
        "S7290XC",
        "S7291XA",
        "S7291XB",
        "S7291XC",
        "S7292XA",
        "S7292XB",
        "S7292XC",
        "S73001A",
        "S73002A",
        "S73003A",
        "S73004A",
        "S73005A",
        "S73006A",
        "S73011A",
        "S73012A",
        "S73013A",
        "S73014A",
        "S73015A",
        "S73016A",
        "S73021A",
        "S73022A",
        "S73023A",
        "S73024A",
        "S73025A",
        "S73026A",
        "S73031A",
        "S73032A",
        "S73033A",
        "S73034A",
        "S73035A",
        "S73036A",
        "S73041A",
        "S73042A",
        "S73043A",
        "S73044A",
        "S73045A",
        "S73046A",
        "S79001A",
        "S79002A",
        "S79009A",
        "S79011A",
        "S79012A",
        "S79019A",
        "S79091A",
        "S79092A",
        "S79099A",
        "S79101A",
        "S79102A",
        "S79109A",
        "S79111A",
        "S79112A",
        "S79119A",
        "S79121A",
        "S79122A",
        "S79129A",
        "S79131A",
        "S79132A",
        "S79139A",
        "S79141A",
        "S79142A",
        "S79149A",
        "S79191A",
        "S79192A",
        "S79199A",
        "S48011A",
        "S48012A",
        "S48019A",
        "S48021A",
        "S48022A",
        "S48029A",
        "S48111A",
        "S48112A",
        "S48119A",
        "S48121A",
        "S48122A",
        "S48129A",
        "S48911A",
        "S48912A",
        "S48919A",
        "S48921A",
        "S48922A",
        "S48929A",
        "S58011A",
        "S58012A",
        "S58019A",
        "S58021A",
        "S58022A",
        "S58029A",
        "S58111A",
        "S58112A",
        "S58119A",
        "S58121A",
        "S58122A",
        "S58129A",
        "S58911A",
        "S58912A",
        "S58919A",
        "S58921A",
        "S58922A",
        "S58929A",
        "S68411A",
        "S68412A",
        "S68419A",
        "S68421A",
        "S68422A",
        "S68429A",
        "S68711A",
        "S68712A",
        "S68719A",
        "S68721A",
        "S68722A",
        "S68729A",
        "S78011A",
        "S78012A",
        "S78019A",
        "S78021A",
        "S78022A",
        "S78029A",
        "S78111A",
        "S78112A",
        "S78119A",
        "S78121A",
        "S78122A",
        "S78129A",
        "S78911A",
        "S78912A",
        "S78919A",
        "S78921A",
        "S78922A",
        "S78929A",
        "S88011A",
        "S88012A",
        "S88019A",
        "S88021A",
        "S88022A",
        "S88029A",
        "S88111A",
        "S88112A",
        "S88119A",
        "S88121A",
        "S88122A",
        "S88129A",
        "S88911A",
        "S88912A",
        "S88919A",
        "S88921A",
        "S88922A",
        "S88929A",
        "S98011A",
        "S98012A",
        "S98019A",
        "S98021A",
        "S98022A",
        "S98029A",
        "S98111A",
        "S98112A",
        "S98119A",
        "S98121A",
        "S98122A",
        "S98129A",
        "S98131A",
        "S98132A",
        "S98139A",
        "S98141A",
        "S98142A",
        "S98149A",
        "S98211A",
        "S98212A",
        "S98219A",
        "S98221A",
        "S98222A",
        "S98229A",
        "S98311A",
        "S98312A",
        "S98319A",
        "S98321A",
        "S98322A",
        "S98329A",
        "S98911A",
        "S98912A",
        "S98919A",
        "S98921A",
        "S98922A",
        "S98929A",
        "T790XXA",
        "T791XXA",
        "T792XXA",
        "T794XXA",
        "T795XXA",
        "T796XXA",
        "T797XXA",
        "T798XXA",
        "T799XXA",
        "T79A0XA",
        "T79A11A",
        "T79A12A",
        "T79A19A",
        "T79A21A",
        "T79A22A",
        "T79A29A",
        "T79A3XA",
        "T79A9XA",
        "T870X1",
        "T870X2",
        "T870X9",
        "T871X1",
        "T871X2",
        "T871X9",
        "T872",
        "M96621",
        "M96622",
        "M96629",
        "M96631",
        "M96632",
        "M96639",
        "M9665",
        "M96661",
        "M96662",
        "M96669",
        "M96671",
        "M96672",
        "M96679",
        "M9669",
        "N99510",
        "N99511",
        "N99512",
        "N99518",
        "N99520",
        "N99521",
        "N99522",
        "N99523",
        "N99524",
        "N99528",
        "N99530",
        "N99531",
        "N99532",
        "N99533",
        "N99534",
        "N99538",
        "T82310A",
        "T82311A",
        "T82312A",
        "T82318A",
        "T82319A",
        "T82320A",
        "T82321A",
        "T82322A",
        "T82328A",
        "T82329A",
        "T82330A",
        "T82331A",
        "T82332A",
        "T82338A",
        "T82339A",
        "T82390A",
        "T82391A",
        "T82392A",
        "T82398A",
        "T82399A",
        "T82510A",
        "T82511A",
        "T82513A",
        "T82514A",
        "T82515A",
        "T82518A",
        "T82520A",
        "T82521A",
        "T82523A",
        "T82524A",
        "T82525A",
        "T82528A",
        "T82530A",
        "T82531A",
        "T82533A",
        "T82534A",
        "T82535A",
        "T82538A",
        "T82590A",
        "T82591A",
        "T82593A",
        "T82594A",
        "T82595A",
        "T82598A",
        "T826XXA",
        "T827XXA",
        "T82818A",
        "T82828A",
        "T82838A",
        "T82848A",
        "T82856A",
        "T82858A",
        "T82868A",
        "T82898A",
        "T83010A",
        "T83011A",
        "T83012A",
        "T83018A",
        "T83020A",
        "T83021A",
        "T83022A",
        "T83028A",
        "T83030A",
        "T83031A",
        "T83032A",
        "T83038A",
        "T83090A",
        "T83091A",
        "T83092A",
        "T83098A",
        "T83110A",
        "T83111A",
        "T83112A",
        "T83113A",
        "T83118A",
        "T83120A",
        "T83121A",
        "T83122A",
        "T83123A",
        "T83128A",
        "T83190A",
        "T83191A",
        "T83192A",
        "T83193A",
        "T83198A",
        "T8321XA",
        "T8322XA",
        "T8323XA",
        "T8324XA",
        "T8325XA",
        "T8329XA",
        "T83410A",
        "T83411A",
        "T83418A",
        "T83420A",
        "T83421A",
        "T83428A",
        "T83490A",
        "T83491A",
        "T83498A",
        "T83510A",
        "T83511A",
        "T83512A",
        "T83518A",
        "T8351XA",
        "T83590A",
        "T83591A",
        "T83592A",
        "T83593A",
        "T83598A",
        "T8359XA",
        "T8361XA",
        "T8362XA",
        "T8369XA",
        "T836XXA",
        "T83711A",
        "T83712A",
        "T83713A",
        "T83714A",
        "T83718A",
        "T83719A",
        "T83721A",
        "T83722A",
        "T83723A",
        "T83724A",
        "T83728A",
        "T83729A",
        "T8379XA",
        "T8381XA",
        "T8382XA",
        "T8383XA",
        "T8384XA",
        "T8385XA",
        "T8386XA",
        "T8389XA",
        "T839XXA",
        "T84010A",
        "T84011A",
        "T84012A",
        "T84013A",
        "T84018A",
        "T84019A",
        "T84020A",
        "T84021A",
        "T84022A",
        "T84023A",
        "T84028A",
        "T84029A",
        "T84030A",
        "T84031A",
        "T84032A",
        "T84033A",
        "T84038A",
        "T84039A",
        "T84040A",
        "T84041A",
        "T84042A",
        "T84043A",
        "T84048A",
        "T84049A",
        "T84050A",
        "T84051A",
        "T84052A",
        "T84053A",
        "T84058A",
        "T84059A",
        "T84060A",
        "T84061A",
        "T84062A",
        "T84063A",
        "T84068A",
        "T84069A",
        "T84090A",
        "T84091A",
        "T84092A",
        "T84093A",
        "T84098A",
        "T84099A",
        "T84110A",
        "T84111A",
        "T84112A",
        "T84113A",
        "T84114A",
        "T84115A",
        "T84116A",
        "T84117A",
        "T84119A",
        "T84120A",
        "T84121A",
        "T84122A",
        "T84123A",
        "T84124A",
        "T84125A",
        "T84126A",
        "T84127A",
        "T84129A",
        "T84190A",
        "T84191A",
        "T84192A",
        "T84193A",
        "T84194A",
        "T84195A",
        "T84196A",
        "T84197A",
        "T84199A",
        "T84210A",
        "T84213A",
        "T84216A",
        "T84218A",
        "T84220A",
        "T84223A",
        "T84226A",
        "T84228A",
        "T84290A",
        "T84293A",
        "T84296A",
        "T84298A",
        "T84310A",
        "T84318A",
        "T84320A",
        "T84328A",
        "T84390A",
        "T84398A",
        "T84410A",
        "T84418A",
        "T84420A",
        "T84428A",
        "T84490A",
        "T84498A",
        "T8450XA",
        "T8451XA",
        "T8452XA",
        "T8453XA",
        "T8454XA",
        "T8459XA",
        "T8460XA",
        "T84610A",
        "T84611A",
        "T84612A",
        "T84613A",
        "T84614A",
        "T84615A",
        "T84619A",
        "T84620A",
        "T84621A",
        "T84622A",
        "T84623A",
        "T84624A",
        "T84625A",
        "T84629A",
        "T8463XA",
        "T8469XA",
        "T847XXA",
        "T8481XA",
        "T8482XA",
        "T8483XA",
        "T8484XA",
        "T8485XA",
        "T8486XA",
        "T8489XA",
        "T849XXA",
        "T8501XA",
        "T8502XA",
        "T8503XA",
        "T8509XA",
        "T85110A",
        "T85111A",
        "T85112A",
        "T85113A",
        "T85118A",
        "T85120A",
        "T85121A",
        "T85122A",
        "T85123A",
        "T85128A",
        "T85190A",
        "T85191A",
        "T85192A",
        "T85193A",
        "T85199A",
        "T85615A",
        "T85625A",
        "T85635A",
        "T85695A",
        "T8572XA",
        "T85730A",
        "T85731A",
        "T85732A",
        "T85733A",
        "T85734A",
        "T85735A",
        "T85738A",
        "T8579XA",
        "T85810A",
        "T85820A",
        "T85830A",
        "T85840A",
        "T85850A",
        "T85860A",
        "T85890A",
        "T86842",
        "T8600",
        "T8601",
        "T8602",
        "T8603",
        "T8609",
        "T8620",
        "T8621",
        "T8622",
        "T8623",
        "T86290",
        "T86298",
        "T8630",
        "T8631",
        "T8632",
        "T8633",
        "T8639",
        "T8640",
        "T8641",
        "T8642",
        "T8643",
        "T8649",
        "T865",
        "T86810",
        "T86811",
        "T86812",
        "T86818",
        "T86819",
        "T86850",
        "T86851",
        "T86852",
        "T86858",
        "T86859",
        "Z4821",
        "Z4823",
        "Z4824",
        "Z48280",
        "Z48290",
        "Z941",
        "Z942",
        "Z943",
        "Z944",
        "Z9481",
        "Z9482",
        "Z9483",
        "Z9484",
        "Z95811",
        "Z95812",
        "K91850",
        "K91858",
        "K9400",
        "K9401",
        "K9402",
        "K9403",
        "K9409",
        "K9410",
        "K9411",
        "K9412",
        "K9413",
        "K9419",
        "K9420",
        "K9421",
        "K9422",
        "K9423",
        "K9429",
        "K9430",
        "K9431",
        "K9432",
        "K9433",
        "K9439",
        "Z431",
        "Z432",
        "Z433",
        "Z434",
        "Z435",
        "Z436",
        "Z438",
        "Z439",
        "Z931",
        "Z932",
        "Z933",
        "Z934",
        "Z9350",
        "Z9351",
        "Z9352",
        "Z9359",
        "Z936",
        "Z938",
        "Z939",
        "G546",
        "G547",
        "S48011S",
        "S48012S",
        "S48019S",
        "S48021S",
        "S48022S",
        "S48029S",
        "S48111S",
        "S48112S",
        "S48119S",
        "S48121S",
        "S48122S",
        "S48129S",
        "S48911S",
        "S48912S",
        "S48919S",
        "S48921S",
        "S48922S",
        "S48929S",
        "S58011S",
        "S58012S",
        "S58019S",
        "S58021S",
        "S58022S",
        "S58029S",
        "S58111S",
        "S58112S",
        "S58119S",
        "S58121S",
        "S58122S",
        "S58129S",
        "S58911S",
        "S58912S",
        "S58919S",
        "S58921S",
        "S58922S",
        "S58929S",
        "S68011S",
        "S68012S",
        "S68019S",
        "S68021S",
        "S68022S",
        "S68029S",
        "S68110S",
        "S68111S",
        "S68112S",
        "S68113S",
        "S68114S",
        "S68115S",
        "S68116S",
        "S68117S",
        "S68118S",
        "S68119S",
        "S68120S",
        "S68121S",
        "S68122S",
        "S68123S",
        "S68124S",
        "S68125S",
        "S68126S",
        "S68127S",
        "S68128S",
        "S68129S",
        "S68411S",
        "S68412S",
        "S68419S",
        "S68421S",
        "S68422S",
        "S68429S",
        "S68511S",
        "S68512S",
        "S68519S",
        "S68521S",
        "S68522S",
        "S68529S",
        "S68610S",
        "S68611S",
        "S68612S",
        "S68613S",
        "S68614S",
        "S68615S",
        "S68616S",
        "S68617S",
        "S68618S",
        "S68619S",
        "S68620S",
        "S68621S",
        "S68622S",
        "S68623S",
        "S68624S",
        "S68625S",
        "S68626S",
        "S68627S",
        "S68628S",
        "S68629S",
        "S68711S",
        "S68712S",
        "S68719S",
        "S68721S",
        "S68722S",
        "S68729S",
        "S78011D",
        "S78011S",
        "S78012D",
        "S78012S",
        "S78019D",
        "S78019S",
        "S78021D",
        "S78021S",
        "S78022D",
        "S78022S",
        "S78029D",
        "S78029S",
        "S78111D",
        "S78111S",
        "S78112D",
        "S78112S",
        "S78119D",
        "S78119S",
        "S78121D",
        "S78121S",
        "S78122D",
        "S78122S",
        "S78129D",
        "S78129S",
        "S78911D",
        "S78911S",
        "S78912D",
        "S78912S",
        "S78919D",
        "S78919S",
        "S78921D",
        "S78921S",
        "S78922D",
        "S78922S",
        "S78929D",
        "S78929S",
        "S88011D",
        "S88011S",
        "S88012D",
        "S88012S",
        "S88019D",
        "S88019S",
        "S88021D",
        "S88021S",
        "S88022D",
        "S88022S",
        "S88029D",
        "S88029S",
        "S88111D",
        "S88111S",
        "S88112D",
        "S88112S",
        "S88119D",
        "S88119S",
        "S88121D",
        "S88121S",
        "S88122D",
        "S88122S",
        "S88129D",
        "S88129S",
        "S88911D",
        "S88911S",
        "S88912D",
        "S88912S",
        "S88919D",
        "S88919S",
        "S88921D",
        "S88921S",
        "S88922D",
        "S88922S",
        "S88929D",
        "S88929S",
        "S98011D",
        "S98011S",
        "S98012D",
        "S98012S",
        "S98019D",
        "S98019S",
        "S98021D",
        "S98021S",
        "S98022D",
        "S98022S",
        "S98029D",
        "S98029S",
        "S98111D",
        "S98111S",
        "S98112D",
        "S98112S",
        "S98119D",
        "S98119S",
        "S98121D",
        "S98121S",
        "S98122D",
        "S98122S",
        "S98129D",
        "S98129S",
        "S98131D",
        "S98131S",
        "S98132D",
        "S98132S",
        "S98139D",
        "S98139S",
        "S98141D",
        "S98141S",
        "S98142D",
        "S98142S",
        "S98149D",
        "S98149S",
        "S98211D",
        "S98211S",
        "S98212D",
        "S98212S",
        "S98219D",
        "S98219S",
        "S98221D",
        "S98221S",
        "S98222D",
        "S98222S",
        "S98229D",
        "S98229S",
        "S98311D",
        "S98311S",
        "S98312D",
        "S98312S",
        "S98319D",
        "S98319S",
        "S98321D",
        "S98321S",
        "S98322D",
        "S98322S",
        "S98329D",
        "S98329S",
        "S98911D",
        "S98911S",
        "S98912D",
        "S98912S",
        "S98919D",
        "S98919S",
        "S98921D",
        "S98921S",
        "S98922D",
        "S98922S",
        "S98929D",
        "S98929S",
        "T8730",
        "T8731",
        "T8732",
        "T8733",
        "T8734",
        "T8740",
        "T8741",
        "T8742",
        "T8743",
        "T8744",
        "T8750",
        "T8751",
        "T8752",
        "T8753",
        "T8754",
        "T8781",
        "T8789",
        "T879",
        "Z44101",
        "Z44102",
        "Z44109",
        "Z44111",
        "Z44112",
        "Z44119",
        "Z44121",
        "Z44122",
        "Z44129",
        "Z89411",
        "Z89412",
        "Z89419",
        "Z89421",
        "Z89422",
        "Z89429",
        "Z89431",
        "Z89432",
        "Z89439",
        "Z89441",
        "Z89442",
        "Z89449",
        "Z89511",
        "Z89512",
        "Z89519",
        "Z89611",
        "Z89612",
        "Z89619",
    }

    LABELS: dict[str, dict[str, str | float]] = {
        "B20": {
            "HCC": "HIV/AIDS",
            "ICD10": "Human immunodeficiency virus [HIV] disease",
            "CommunityRAF": 0.470,
        },
        "B9735": {
            "HCC": "HIV/AIDS",
            "ICD10": "Human immunodeficiency virus, type 2 [HIV 2] as the cause of diseases classified elsewhere",
            "CommunityRAF": 0.470,
        },
        "Z21": {
            "HCC": "HIV/AIDS",
            "ICD10": "Asymptomatic human immunodeficiency virus [HIV] infection status",
            "CommunityRAF": 0.470,
        },
        "A021": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Salmonella sepsis",
            "CommunityRAF": 0.535,
        },
        "A207": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Septicemic plague",
            "CommunityRAF": 0.535,
        },
        "A227": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Anthrax sepsis",
            "CommunityRAF": 0.535,
        },
        "A267": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Erysipelothrix sepsis",
            "CommunityRAF": 0.535,
        },
        "A327": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Listerial sepsis",
            "CommunityRAF": 0.535,
        },
        "A392": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Acute meningococcemia",
            "CommunityRAF": 0.535,
        },
        "A393": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Chronic meningococcemia",
            "CommunityRAF": 0.535,
        },
        "A394": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Meningococcemia, unspecified",
            "CommunityRAF": 0.535,
        },
        "A400": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to streptococcus, group A",
            "CommunityRAF": 0.535,
        },
        "A401": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to streptococcus, group B",
            "CommunityRAF": 0.535,
        },
        "A403": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to Streptococcus pneumoniae",
            "CommunityRAF": 0.535,
        },
        "A408": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Other streptococcal sepsis",
            "CommunityRAF": 0.535,
        },
        "A409": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Streptococcal sepsis, unspecified",
            "CommunityRAF": 0.535,
        },
        "A4101": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to Methicillin susceptible Staphylococcus aureus",
            "CommunityRAF": 0.535,
        },
        "A4102": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to Methicillin resistant Staphylococcus aureus",
            "CommunityRAF": 0.535,
        },
        "A411": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to other specified staphylococcus",
            "CommunityRAF": 0.535,
        },
        "A412": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to unspecified staphylococcus",
            "CommunityRAF": 0.535,
        },
        "A413": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to Hemophilus influenzae",
            "CommunityRAF": 0.535,
        },
        "A414": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to anaerobes",
            "CommunityRAF": 0.535,
        },
        "A4150": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Gram-negative sepsis, unspecified",
            "CommunityRAF": 0.535,
        },
        "A4151": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to Escherichia coli [E. coli]",
            "CommunityRAF": 0.535,
        },
        "A4152": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to Pseudomonas",
            "CommunityRAF": 0.535,
        },
        "A4153": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to Serratia",
            "CommunityRAF": 0.535,
        },
        "A4159": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Other Gram-negative sepsis",
            "CommunityRAF": 0.535,
        },
        "A4181": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis due to Enterococcus",
            "CommunityRAF": 0.535,
        },
        "A4189": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Other specified sepsis",
            "CommunityRAF": 0.535,
        },
        "A419": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis, unspecified organism",
            "CommunityRAF": 0.535,
        },
        "A427": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Actinomycotic sepsis",
            "CommunityRAF": 0.535,
        },
        "A483": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Toxic shock syndrome",
            "CommunityRAF": 0.535,
        },
        "A5486": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Gonococcal sepsis",
            "CommunityRAF": 0.535,
        },
        "B007": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Disseminated herpesviral disease",
            "CommunityRAF": 0.535,
        },
        "B377": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Candidal sepsis",
            "CommunityRAF": 0.535,
        },
        "P360": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis of newborn due to streptococcus, group B",
            "CommunityRAF": 0.535,
        },
        "P3610": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis of newborn due to unspecified streptococci",
            "CommunityRAF": 0.535,
        },
        "P3619": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis of newborn due to other streptococci",
            "CommunityRAF": 0.535,
        },
        "P362": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis of newborn due to Staphylococcus aureus",
            "CommunityRAF": 0.535,
        },
        "P3630": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis of newborn due to unspecified staphylococci",
            "CommunityRAF": 0.535,
        },
        "P3639": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis of newborn due to other staphylococci",
            "CommunityRAF": 0.535,
        },
        "P364": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis of newborn due to Escherichia coli",
            "CommunityRAF": 0.535,
        },
        "P365": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Sepsis of newborn due to anaerobes",
            "CommunityRAF": 0.535,
        },
        "P368": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Other bacterial sepsis of newborn",
            "CommunityRAF": 0.535,
        },
        "P369": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Bacterial sepsis of newborn, unspecified",
            "CommunityRAF": 0.535,
        },
        "R571": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Hypovolemic shock",
            "CommunityRAF": 0.535,
        },
        "R578": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Other shock",
            "CommunityRAF": 0.535,
        },
        "R6510": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Systemic inflammatory response syndrome (SIRS) of non-infectious origin without acute organ dysfunction",
            "CommunityRAF": 0.535,
        },
        "R6511": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Systemic inflammatory response syndrome (SIRS) of non-infectious origin with acute organ dysfunction",
            "CommunityRAF": 0.535,
        },
        "R6520": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Severe sepsis without septic shock",
            "CommunityRAF": 0.535,
        },
        "R6521": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Severe sepsis with septic shock",
            "CommunityRAF": 0.535,
        },
        "T8112XA": {
            "HCC": "Septicemia, Sepsis, Systemic Inflammatory Response Syndrome/Shock",
            "ICD10": "Postprocedural septic shock, initial encounter",
            "CommunityRAF": 0.535,
        },
        "A072": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Cryptosporidiosis",
            "CommunityRAF": 0.440,
        },
        "A310": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Pulmonary mycobacterial infection",
            "CommunityRAF": 0.440,
        },
        "A312": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Disseminated mycobacterium avium-intracellulare complex (DMAC)",
            "CommunityRAF": 0.440,
        },
        "B250": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Cytomegaloviral pneumonitis",
            "CommunityRAF": 0.440,
        },
        "B251": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Cytomegaloviral hepatitis",
            "CommunityRAF": 0.440,
        },
        "B252": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Cytomegaloviral pancreatitis",
            "CommunityRAF": 0.440,
        },
        "B258": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Other cytomegaloviral diseases",
            "CommunityRAF": 0.440,
        },
        "B259": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Cytomegaloviral disease, unspecified",
            "CommunityRAF": 0.440,
        },
        "B371": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Pulmonary candidiasis",
            "CommunityRAF": 0.440,
        },
        "B3781": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Candidal esophagitis",
            "CommunityRAF": 0.440,
        },
        "B440": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Invasive pulmonary aspergillosis",
            "CommunityRAF": 0.440,
        },
        "B441": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Other pulmonary aspergillosis",
            "CommunityRAF": 0.440,
        },
        "B442": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Tonsillar aspergillosis",
            "CommunityRAF": 0.440,
        },
        "B447": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Disseminated aspergillosis",
            "CommunityRAF": 0.440,
        },
        "B4489": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Other forms of aspergillosis",
            "CommunityRAF": 0.440,
        },
        "B449": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Aspergillosis, unspecified",
            "CommunityRAF": 0.440,
        },
        "B450": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Pulmonary cryptococcosis",
            "CommunityRAF": 0.440,
        },
        "B451": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Cerebral cryptococcosis",
            "CommunityRAF": 0.440,
        },
        "B452": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Cutaneous cryptococcosis",
            "CommunityRAF": 0.440,
        },
        "B453": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Osseous cryptococcosis",
            "CommunityRAF": 0.440,
        },
        "B457": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Disseminated cryptococcosis",
            "CommunityRAF": 0.440,
        },
        "B458": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Other forms of cryptococcosis",
            "CommunityRAF": 0.440,
        },
        "B459": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Cryptococcosis, unspecified",
            "CommunityRAF": 0.440,
        },
        "B460": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Pulmonary mucormycosis",
            "CommunityRAF": 0.440,
        },
        "B461": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Rhinocerebral mucormycosis",
            "CommunityRAF": 0.440,
        },
        "B462": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Gastrointestinal mucormycosis",
            "CommunityRAF": 0.440,
        },
        "B463": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Cutaneous mucormycosis",
            "CommunityRAF": 0.440,
        },
        "B464": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Disseminated mucormycosis",
            "CommunityRAF": 0.440,
        },
        "B465": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Mucormycosis, unspecified",
            "CommunityRAF": 0.440,
        },
        "B468": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Other zygomycoses",
            "CommunityRAF": 0.440,
        },
        "B469": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Zygomycosis, unspecified",
            "CommunityRAF": 0.440,
        },
        "B484": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Penicillosis",
            "CommunityRAF": 0.440,
        },
        "B488": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Other specified mycoses",
            "CommunityRAF": 0.440,
        },
        "B582": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Toxoplasma meningoencephalitis",
            "CommunityRAF": 0.440,
        },
        "B583": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Pulmonary toxoplasmosis",
            "CommunityRAF": 0.440,
        },
        "B59": {
            "HCC": "Opportunistic Infections",
            "ICD10": "Pneumocystosis",
            "CommunityRAF": 0.440,
        },
        "C770": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary and unspecified malignant neoplasm of lymph nodes of head, face and neck",
            "CommunityRAF": 2.484,
        },
        "C771": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary and unspecified malignant neoplasm of intrathoracic lymph nodes",
            "CommunityRAF": 2.484,
        },
        "C772": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary and unspecified malignant neoplasm of intra-abdominal lymph nodes",
            "CommunityRAF": 2.484,
        },
        "C774": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary and unspecified malignant neoplasm of inguinal and lower limb lymph nodes",
            "CommunityRAF": 2.484,
        },
        "C775": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary and unspecified malignant neoplasm of intrapelvic lymph nodes",
            "CommunityRAF": 2.484,
        },
        "C778": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary and unspecified malignant neoplasm of lymph nodes of multiple regions",
            "CommunityRAF": 2.484,
        },
        "C7800": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of unspecified lung",
            "CommunityRAF": 2.484,
        },
        "C7801": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of right lung",
            "CommunityRAF": 2.484,
        },
        "C7802": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of left lung",
            "CommunityRAF": 2.484,
        },
        "C781": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of mediastinum",
            "CommunityRAF": 2.484,
        },
        "C782": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of pleura",
            "CommunityRAF": 2.484,
        },
        "C7830": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of unspecified respiratory organ",
            "CommunityRAF": 2.484,
        },
        "C7839": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of other respiratory organs",
            "CommunityRAF": 2.484,
        },
        "C784": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of small intestine",
            "CommunityRAF": 2.484,
        },
        "C785": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of large intestine and rectum",
            "CommunityRAF": 2.484,
        },
        "C786": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of retroperitoneum and peritoneum",
            "CommunityRAF": 2.484,
        },
        "C787": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of liver and intrahepatic bile duct",
            "CommunityRAF": 2.484,
        },
        "C7880": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of unspecified digestive organ",
            "CommunityRAF": 2.484,
        },
        "C7889": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of other digestive organs",
            "CommunityRAF": 2.484,
        },
        "C7900": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of unspecified kidney and renal pelvis",
            "CommunityRAF": 2.484,
        },
        "C7901": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of right kidney and renal pelvis",
            "CommunityRAF": 2.484,
        },
        "C7902": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of left kidney and renal pelvis",
            "CommunityRAF": 2.484,
        },
        "C7910": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of unspecified urinary organs",
            "CommunityRAF": 2.484,
        },
        "C7911": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of bladder",
            "CommunityRAF": 2.484,
        },
        "C7919": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of other urinary organs",
            "CommunityRAF": 2.484,
        },
        "C7931": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of brain",
            "CommunityRAF": 2.484,
        },
        "C7932": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of cerebral meninges",
            "CommunityRAF": 2.484,
        },
        "C7940": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of unspecified part of nervous system",
            "CommunityRAF": 2.484,
        },
        "C7949": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of other parts of nervous system",
            "CommunityRAF": 2.484,
        },
        "C7951": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of bone",
            "CommunityRAF": 2.484,
        },
        "C7952": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of bone marrow",
            "CommunityRAF": 2.484,
        },
        "C7960": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of unspecified ovary",
            "CommunityRAF": 2.484,
        },
        "C7961": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of right ovary",
            "CommunityRAF": 2.484,
        },
        "C7962": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of left ovary",
            "CommunityRAF": 2.484,
        },
        "C7970": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of unspecified adrenal gland",
            "CommunityRAF": 2.484,
        },
        "C7971": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of right adrenal gland",
            "CommunityRAF": 2.484,
        },
        "C7972": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of left adrenal gland",
            "CommunityRAF": 2.484,
        },
        "C7989": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of other specified sites",
            "CommunityRAF": 2.484,
        },
        "C799": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary malignant neoplasm of unspecified site",
            "CommunityRAF": 2.484,
        },
        "C7B00": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary carcinoid tumors, unspecified site",
            "CommunityRAF": 2.484,
        },
        "C7B01": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary carcinoid tumors of distant lymph nodes",
            "CommunityRAF": 2.484,
        },
        "C7B02": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary carcinoid tumors of liver",
            "CommunityRAF": 2.484,
        },
        "C7B03": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary carcinoid tumors of bone",
            "CommunityRAF": 2.484,
        },
        "C7B04": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary carcinoid tumors of peritoneum",
            "CommunityRAF": 2.484,
        },
        "C7B09": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary carcinoid tumors of other sites",
            "CommunityRAF": 2.484,
        },
        "C7B1": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Secondary Merkel cell carcinoma",
            "CommunityRAF": 2.484,
        },
        "C7B8": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Other secondary neuroendocrine tumors",
            "CommunityRAF": 2.484,
        },
        "C800": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Disseminated malignant neoplasm, unspecified",
            "CommunityRAF": 2.484,
        },
        "C9100": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute lymphoblastic leukemia not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9101": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute lymphoblastic leukemia, in remission",
            "CommunityRAF": 2.484,
        },
        "C9102": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute lymphoblastic leukemia, in relapse",
            "CommunityRAF": 2.484,
        },
        "C9200": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myeloblastic leukemia, not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9201": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myeloblastic leukemia, in remission",
            "CommunityRAF": 2.484,
        },
        "C9202": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myeloblastic leukemia, in relapse",
            "CommunityRAF": 2.484,
        },
        "C9240": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute promyelocytic leukemia, not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9241": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute promyelocytic leukemia, in remission",
            "CommunityRAF": 2.484,
        },
        "C9242": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute promyelocytic leukemia, in relapse",
            "CommunityRAF": 2.484,
        },
        "C9250": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myelomonocytic leukemia, not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9251": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myelomonocytic leukemia, in remission",
            "CommunityRAF": 2.484,
        },
        "C9252": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myelomonocytic leukemia, in relapse",
            "CommunityRAF": 2.484,
        },
        "C9260": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myeloid leukemia with 11q23-abnormality not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9261": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myeloid leukemia with 11q23-abnormality in remission",
            "CommunityRAF": 2.484,
        },
        "C9262": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myeloid leukemia with 11q23-abnormality in relapse",
            "CommunityRAF": 2.484,
        },
        "C92A0": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myeloid leukemia with multilineage dysplasia, not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C92A1": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myeloid leukemia with multilineage dysplasia, in remission",
            "CommunityRAF": 2.484,
        },
        "C92A2": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute myeloid leukemia with multilineage dysplasia, in relapse",
            "CommunityRAF": 2.484,
        },
        "C9300": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute monoblastic/monocytic leukemia, not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9301": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute monoblastic/monocytic leukemia, in remission",
            "CommunityRAF": 2.484,
        },
        "C9302": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute monoblastic/monocytic leukemia, in relapse",
            "CommunityRAF": 2.484,
        },
        "C9400": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute erythroid leukemia, not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9401": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute erythroid leukemia, in remission",
            "CommunityRAF": 2.484,
        },
        "C9402": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute erythroid leukemia, in relapse",
            "CommunityRAF": 2.484,
        },
        "C9420": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute megakaryoblastic leukemia not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9421": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute megakaryoblastic leukemia, in remission",
            "CommunityRAF": 2.484,
        },
        "C9422": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute megakaryoblastic leukemia, in relapse",
            "CommunityRAF": 2.484,
        },
        "C9440": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute panmyelosis with myelofibrosis not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9441": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute panmyelosis with myelofibrosis, in remission",
            "CommunityRAF": 2.484,
        },
        "C9442": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute panmyelosis with myelofibrosis, in relapse",
            "CommunityRAF": 2.484,
        },
        "C9500": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute leukemia of unspecified cell type not having achieved remission",
            "CommunityRAF": 2.484,
        },
        "C9501": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute leukemia of unspecified cell type, in remission",
            "CommunityRAF": 2.484,
        },
        "C9502": {
            "HCC": "Metastatic Cancer and Acute Leukemia",
            "ICD10": "Acute leukemia of unspecified cell type, in relapse",
            "CommunityRAF": 2.484,
        },
        "C153": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of upper third of esophagus",
            "CommunityRAF": 0.973,
        },
        "C154": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of middle third of esophagus",
            "CommunityRAF": 0.973,
        },
        "C155": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of lower third of esophagus",
            "CommunityRAF": 0.973,
        },
        "C158": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of esophagus",
            "CommunityRAF": 0.973,
        },
        "C159": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of esophagus, unspecified",
            "CommunityRAF": 0.973,
        },
        "C160": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of cardia",
            "CommunityRAF": 0.973,
        },
        "C161": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of fundus of stomach",
            "CommunityRAF": 0.973,
        },
        "C162": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of body of stomach",
            "CommunityRAF": 0.973,
        },
        "C163": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of pyloric antrum",
            "CommunityRAF": 0.973,
        },
        "C164": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of pylorus",
            "CommunityRAF": 0.973,
        },
        "C165": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of lesser curvature of stomach, unspecified",
            "CommunityRAF": 0.973,
        },
        "C166": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of greater curvature of stomach, unspecified",
            "CommunityRAF": 0.973,
        },
        "C168": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of stomach",
            "CommunityRAF": 0.973,
        },
        "C169": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of stomach, unspecified",
            "CommunityRAF": 0.973,
        },
        "C170": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of duodenum",
            "CommunityRAF": 0.973,
        },
        "C171": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of jejunum",
            "CommunityRAF": 0.973,
        },
        "C172": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of ileum",
            "CommunityRAF": 0.973,
        },
        "C173": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Meckel's diverticulum, malignant",
            "CommunityRAF": 0.973,
        },
        "C178": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of small intestine",
            "CommunityRAF": 0.973,
        },
        "C179": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of small intestine, unspecified",
            "CommunityRAF": 0.973,
        },
        "C220": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Liver cell carcinoma",
            "CommunityRAF": 0.973,
        },
        "C221": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Intrahepatic bile duct carcinoma",
            "CommunityRAF": 0.973,
        },
        "C222": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Hepatoblastoma",
            "CommunityRAF": 0.973,
        },
        "C223": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Angiosarcoma of liver",
            "CommunityRAF": 0.973,
        },
        "C224": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other sarcomas of liver",
            "CommunityRAF": 0.973,
        },
        "C227": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other specified carcinomas of liver",
            "CommunityRAF": 0.973,
        },
        "C228": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of liver, primary, unspecified as to type",
            "CommunityRAF": 0.973,
        },
        "C229": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of liver, not specified as primary or secondary",
            "CommunityRAF": 0.973,
        },
        "C23": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of gallbladder",
            "CommunityRAF": 0.973,
        },
        "C240": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of extrahepatic bile duct",
            "CommunityRAF": 0.973,
        },
        "C241": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of ampulla of Vater",
            "CommunityRAF": 0.973,
        },
        "C248": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of biliary tract",
            "CommunityRAF": 0.973,
        },
        "C249": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of biliary tract, unspecified",
            "CommunityRAF": 0.973,
        },
        "C250": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of head of pancreas",
            "CommunityRAF": 0.973,
        },
        "C251": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of body of pancreas",
            "CommunityRAF": 0.973,
        },
        "C252": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of tail of pancreas",
            "CommunityRAF": 0.973,
        },
        "C253": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of pancreatic duct",
            "CommunityRAF": 0.973,
        },
        "C254": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of endocrine pancreas",
            "CommunityRAF": 0.973,
        },
        "C257": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of other parts of pancreas",
            "CommunityRAF": 0.973,
        },
        "C258": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of pancreas",
            "CommunityRAF": 0.973,
        },
        "C259": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of pancreas, unspecified",
            "CommunityRAF": 0.973,
        },
        "C33": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of trachea",
            "CommunityRAF": 0.973,
        },
        "C3400": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of unspecified main bronchus",
            "CommunityRAF": 0.973,
        },
        "C3401": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of right main bronchus",
            "CommunityRAF": 0.973,
        },
        "C3402": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of left main bronchus",
            "CommunityRAF": 0.973,
        },
        "C3410": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of upper lobe, unspecified bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C3411": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of upper lobe, right bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C3412": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of upper lobe, left bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C342": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of middle lobe, bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C3430": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of lower lobe, unspecified bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C3431": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of lower lobe, right bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C3432": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of lower lobe, left bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C3480": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of unspecified bronchus and lung",
            "CommunityRAF": 0.973,
        },
        "C3481": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of right bronchus and lung",
            "CommunityRAF": 0.973,
        },
        "C3482": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of left bronchus and lung",
            "CommunityRAF": 0.973,
        },
        "C3490": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of unspecified part of unspecified bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C3491": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of unspecified part of right bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C3492": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of unspecified part of left bronchus or lung",
            "CommunityRAF": 0.973,
        },
        "C384": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of pleura",
            "CommunityRAF": 0.973,
        },
        "C450": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Mesothelioma of pleura",
            "CommunityRAF": 0.973,
        },
        "C451": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Mesothelioma of peritoneum",
            "CommunityRAF": 0.973,
        },
        "C452": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Mesothelioma of pericardium",
            "CommunityRAF": 0.973,
        },
        "C457": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Mesothelioma of other sites",
            "CommunityRAF": 0.973,
        },
        "C459": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Mesothelioma, unspecified",
            "CommunityRAF": 0.973,
        },
        "C480": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of retroperitoneum",
            "CommunityRAF": 0.973,
        },
        "C481": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of specified parts of peritoneum",
            "CommunityRAF": 0.973,
        },
        "C482": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of peritoneum, unspecified",
            "CommunityRAF": 0.973,
        },
        "C488": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of retroperitoneum and peritoneum",
            "CommunityRAF": 0.973,
        },
        "C9000": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Multiple myeloma not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9001": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Multiple myeloma in remission",
            "CommunityRAF": 0.973,
        },
        "C9002": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Multiple myeloma in relapse",
            "CommunityRAF": 0.973,
        },
        "C9010": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Plasma cell leukemia not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9011": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Plasma cell leukemia in remission",
            "CommunityRAF": 0.973,
        },
        "C9012": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Plasma cell leukemia in relapse",
            "CommunityRAF": 0.973,
        },
        "C9020": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Extramedullary plasmacytoma not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9021": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Extramedullary plasmacytoma in remission",
            "CommunityRAF": 0.973,
        },
        "C9022": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Extramedullary plasmacytoma in relapse",
            "CommunityRAF": 0.973,
        },
        "C9210": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Chronic myeloid leukemia, BCR/ABL-positive, not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9211": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Chronic myeloid leukemia, BCR/ABL-positive, in remission",
            "CommunityRAF": 0.973,
        },
        "C9212": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Chronic myeloid leukemia, BCR/ABL-positive, in relapse",
            "CommunityRAF": 0.973,
        },
        "C9220": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Atypical chronic myeloid leukemia, BCR/ABL-negative, not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9221": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Atypical chronic myeloid leukemia, BCR/ABL-negative, in remission",
            "CommunityRAF": 0.973,
        },
        "C9222": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Atypical chronic myeloid leukemia, BCR/ABL-negative, in relapse",
            "CommunityRAF": 0.973,
        },
        "C9230": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Myeloid sarcoma, not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9231": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Myeloid sarcoma, in remission",
            "CommunityRAF": 0.973,
        },
        "C9232": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Myeloid sarcoma, in relapse",
            "CommunityRAF": 0.973,
        },
        "C9290": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Myeloid leukemia, unspecified, not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9291": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Myeloid leukemia, unspecified in remission",
            "CommunityRAF": 0.973,
        },
        "C9292": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Myeloid leukemia, unspecified in relapse",
            "CommunityRAF": 0.973,
        },
        "C92Z0": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other myeloid leukemia not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C92Z1": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other myeloid leukemia, in remission",
            "CommunityRAF": 0.973,
        },
        "C92Z2": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other myeloid leukemia, in relapse",
            "CommunityRAF": 0.973,
        },
        "C9310": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Chronic myelomonocytic leukemia not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9311": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Chronic myelomonocytic leukemia, in remission",
            "CommunityRAF": 0.973,
        },
        "C9312": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Chronic myelomonocytic leukemia, in relapse",
            "CommunityRAF": 0.973,
        },
        "C9330": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Juvenile myelomonocytic leukemia, not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9331": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Juvenile myelomonocytic leukemia, in remission",
            "CommunityRAF": 0.973,
        },
        "C9332": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Juvenile myelomonocytic leukemia, in relapse",
            "CommunityRAF": 0.973,
        },
        "C9390": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Monocytic leukemia, unspecified, not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9391": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Monocytic leukemia, unspecified in remission",
            "CommunityRAF": 0.973,
        },
        "C9392": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Monocytic leukemia, unspecified in relapse",
            "CommunityRAF": 0.973,
        },
        "C93Z0": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other monocytic leukemia, not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C93Z1": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other monocytic leukemia, in remission",
            "CommunityRAF": 0.973,
        },
        "C93Z2": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other monocytic leukemia, in relapse",
            "CommunityRAF": 0.973,
        },
        "C9430": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Mast cell leukemia not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9431": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Mast cell leukemia, in remission",
            "CommunityRAF": 0.973,
        },
        "C9432": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Mast cell leukemia, in relapse",
            "CommunityRAF": 0.973,
        },
        "C9480": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other specified leukemias not having achieved remission",
            "CommunityRAF": 0.973,
        },
        "C9481": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other specified leukemias, in remission",
            "CommunityRAF": 0.973,
        },
        "C9482": {
            "HCC": "Lung and Other Severe Cancers",
            "ICD10": "Other specified leukemias, in relapse",
            "CommunityRAF": 0.973,
        },
        "C4000": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of scapula and long bones of unspecified upper limb",
            "CommunityRAF": 0.672,
        },
        "C4001": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of scapula and long bones of right upper limb",
            "CommunityRAF": 0.672,
        },
        "C4002": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of scapula and long bones of left upper limb",
            "CommunityRAF": 0.672,
        },
        "C4010": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of short bones of unspecified upper limb",
            "CommunityRAF": 0.672,
        },
        "C4011": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of short bones of right upper limb",
            "CommunityRAF": 0.672,
        },
        "C4012": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of short bones of left upper limb",
            "CommunityRAF": 0.672,
        },
        "C4020": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of long bones of unspecified lower limb",
            "CommunityRAF": 0.672,
        },
        "C4021": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of long bones of right lower limb",
            "CommunityRAF": 0.672,
        },
        "C4022": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of long bones of left lower limb",
            "CommunityRAF": 0.672,
        },
        "C4030": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of short bones of unspecified lower limb",
            "CommunityRAF": 0.672,
        },
        "C4031": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of short bones of right lower limb",
            "CommunityRAF": 0.672,
        },
        "C4032": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of short bones of left lower limb",
            "CommunityRAF": 0.672,
        },
        "C4080": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of bone and articular cartilage of unspecified limb",
            "CommunityRAF": 0.672,
        },
        "C4081": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of bone and articular cartilage of right limb",
            "CommunityRAF": 0.672,
        },
        "C4082": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of bone and articular cartilage of left limb",
            "CommunityRAF": 0.672,
        },
        "C4090": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified bones and articular cartilage of unspecified limb",
            "CommunityRAF": 0.672,
        },
        "C4091": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified bones and articular cartilage of right limb",
            "CommunityRAF": 0.672,
        },
        "C4092": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified bones and articular cartilage of left limb",
            "CommunityRAF": 0.672,
        },
        "C410": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of bones of skull and face",
            "CommunityRAF": 0.672,
        },
        "C411": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of mandible",
            "CommunityRAF": 0.672,
        },
        "C412": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of vertebral column",
            "CommunityRAF": 0.672,
        },
        "C413": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of ribs, sternum and clavicle",
            "CommunityRAF": 0.672,
        },
        "C414": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of pelvic bones, sacrum and coccyx",
            "CommunityRAF": 0.672,
        },
        "C419": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of bone and articular cartilage, unspecified",
            "CommunityRAF": 0.672,
        },
        "C460": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma of skin",
            "CommunityRAF": 0.672,
        },
        "C461": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma of soft tissue",
            "CommunityRAF": 0.672,
        },
        "C462": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma of palate",
            "CommunityRAF": 0.672,
        },
        "C463": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma of lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C464": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma of gastrointestinal sites",
            "CommunityRAF": 0.672,
        },
        "C4650": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma of unspecified lung",
            "CommunityRAF": 0.672,
        },
        "C4651": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma of right lung",
            "CommunityRAF": 0.672,
        },
        "C4652": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma of left lung",
            "CommunityRAF": 0.672,
        },
        "C467": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma of other sites",
            "CommunityRAF": 0.672,
        },
        "C469": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Kaposi's sarcoma, unspecified",
            "CommunityRAF": 0.672,
        },
        "C470": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of head, face and neck",
            "CommunityRAF": 0.672,
        },
        "C4710": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of unspecified upper limb, including shoulder",
            "CommunityRAF": 0.672,
        },
        "C4711": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of right upper limb, including shoulder",
            "CommunityRAF": 0.672,
        },
        "C4712": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of left upper limb, including shoulder",
            "CommunityRAF": 0.672,
        },
        "C4720": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of unspecified lower limb, including hip",
            "CommunityRAF": 0.672,
        },
        "C4721": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of right lower limb, including hip",
            "CommunityRAF": 0.672,
        },
        "C4722": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of left lower limb, including hip",
            "CommunityRAF": 0.672,
        },
        "C473": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of thorax",
            "CommunityRAF": 0.672,
        },
        "C474": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of abdomen",
            "CommunityRAF": 0.672,
        },
        "C475": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of pelvis",
            "CommunityRAF": 0.672,
        },
        "C476": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves of trunk, unspecified",
            "CommunityRAF": 0.672,
        },
        "C478": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of peripheral nerves and autonomic nervous system",
            "CommunityRAF": 0.672,
        },
        "C479": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of peripheral nerves and autonomic nervous system, unspecified",
            "CommunityRAF": 0.672,
        },
        "C490": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of head, face and neck",
            "CommunityRAF": 0.672,
        },
        "C4910": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of unspecified upper limb, including shoulder",
            "CommunityRAF": 0.672,
        },
        "C4911": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of right upper limb, including shoulder",
            "CommunityRAF": 0.672,
        },
        "C4912": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of left upper limb, including shoulder",
            "CommunityRAF": 0.672,
        },
        "C4920": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of unspecified lower limb, including hip",
            "CommunityRAF": 0.672,
        },
        "C4921": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of right lower limb, including hip",
            "CommunityRAF": 0.672,
        },
        "C4922": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of left lower limb, including hip",
            "CommunityRAF": 0.672,
        },
        "C493": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of thorax",
            "CommunityRAF": 0.672,
        },
        "C494": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of abdomen",
            "CommunityRAF": 0.672,
        },
        "C495": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of pelvis",
            "CommunityRAF": 0.672,
        },
        "C496": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue of trunk, unspecified",
            "CommunityRAF": 0.672,
        },
        "C498": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of connective and soft tissue",
            "CommunityRAF": 0.672,
        },
        "C499": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of connective and soft tissue, unspecified",
            "CommunityRAF": 0.672,
        },
        "C49A0": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Gastrointestinal stromal tumor, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C49A1": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Gastrointestinal stromal tumor of esophagus",
            "CommunityRAF": 0.672,
        },
        "C49A2": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Gastrointestinal stromal tumor of stomach",
            "CommunityRAF": 0.672,
        },
        "C49A3": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Gastrointestinal stromal tumor of small intestine",
            "CommunityRAF": 0.672,
        },
        "C49A4": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Gastrointestinal stromal tumor of large intestine",
            "CommunityRAF": 0.672,
        },
        "C49A5": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Gastrointestinal stromal tumor of rectum",
            "CommunityRAF": 0.672,
        },
        "C49A9": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Gastrointestinal stromal tumor of other sites",
            "CommunityRAF": 0.672,
        },
        "C561": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of right ovary",
            "CommunityRAF": 0.672,
        },
        "C562": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of left ovary",
            "CommunityRAF": 0.672,
        },
        "C569": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified ovary",
            "CommunityRAF": 0.672,
        },
        "C5700": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified fallopian tube",
            "CommunityRAF": 0.672,
        },
        "C5701": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of right fallopian tube",
            "CommunityRAF": 0.672,
        },
        "C5702": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of left fallopian tube",
            "CommunityRAF": 0.672,
        },
        "C5710": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified broad ligament",
            "CommunityRAF": 0.672,
        },
        "C5711": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of right broad ligament",
            "CommunityRAF": 0.672,
        },
        "C5712": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of left broad ligament",
            "CommunityRAF": 0.672,
        },
        "C5720": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified round ligament",
            "CommunityRAF": 0.672,
        },
        "C5721": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of right round ligament",
            "CommunityRAF": 0.672,
        },
        "C5722": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of left round ligament",
            "CommunityRAF": 0.672,
        },
        "C573": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of parametrium",
            "CommunityRAF": 0.672,
        },
        "C574": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of uterine adnexa, unspecified",
            "CommunityRAF": 0.672,
        },
        "C58": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of placenta",
            "CommunityRAF": 0.672,
        },
        "C700": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of cerebral meninges",
            "CommunityRAF": 0.672,
        },
        "C701": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of spinal meninges",
            "CommunityRAF": 0.672,
        },
        "C709": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of meninges, unspecified",
            "CommunityRAF": 0.672,
        },
        "C710": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of cerebrum, except lobes and ventricles",
            "CommunityRAF": 0.672,
        },
        "C711": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of frontal lobe",
            "CommunityRAF": 0.672,
        },
        "C712": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of temporal lobe",
            "CommunityRAF": 0.672,
        },
        "C713": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of parietal lobe",
            "CommunityRAF": 0.672,
        },
        "C714": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of occipital lobe",
            "CommunityRAF": 0.672,
        },
        "C715": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of cerebral ventricle",
            "CommunityRAF": 0.672,
        },
        "C716": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of cerebellum",
            "CommunityRAF": 0.672,
        },
        "C717": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of brain stem",
            "CommunityRAF": 0.672,
        },
        "C718": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of brain",
            "CommunityRAF": 0.672,
        },
        "C719": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of brain, unspecified",
            "CommunityRAF": 0.672,
        },
        "C720": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of spinal cord",
            "CommunityRAF": 0.672,
        },
        "C721": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of cauda equina",
            "CommunityRAF": 0.672,
        },
        "C7220": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified olfactory nerve",
            "CommunityRAF": 0.672,
        },
        "C7221": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of right olfactory nerve",
            "CommunityRAF": 0.672,
        },
        "C7222": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of left olfactory nerve",
            "CommunityRAF": 0.672,
        },
        "C7230": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified optic nerve",
            "CommunityRAF": 0.672,
        },
        "C7231": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of right optic nerve",
            "CommunityRAF": 0.672,
        },
        "C7232": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of left optic nerve",
            "CommunityRAF": 0.672,
        },
        "C7240": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified acoustic nerve",
            "CommunityRAF": 0.672,
        },
        "C7241": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of right acoustic nerve",
            "CommunityRAF": 0.672,
        },
        "C7242": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of left acoustic nerve",
            "CommunityRAF": 0.672,
        },
        "C7250": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified cranial nerve",
            "CommunityRAF": 0.672,
        },
        "C7259": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of other cranial nerves",
            "CommunityRAF": 0.672,
        },
        "C729": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of central nervous system, unspecified",
            "CommunityRAF": 0.672,
        },
        "C7400": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of cortex of unspecified adrenal gland",
            "CommunityRAF": 0.672,
        },
        "C7401": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of cortex of right adrenal gland",
            "CommunityRAF": 0.672,
        },
        "C7402": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of cortex of left adrenal gland",
            "CommunityRAF": 0.672,
        },
        "C7410": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of medulla of unspecified adrenal gland",
            "CommunityRAF": 0.672,
        },
        "C7411": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of medulla of right adrenal gland",
            "CommunityRAF": 0.672,
        },
        "C7412": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of medulla of left adrenal gland",
            "CommunityRAF": 0.672,
        },
        "C7490": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified part of unspecified adrenal gland",
            "CommunityRAF": 0.672,
        },
        "C7491": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified part of right adrenal gland",
            "CommunityRAF": 0.672,
        },
        "C7492": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified part of left adrenal gland",
            "CommunityRAF": 0.672,
        },
        "C751": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of pituitary gland",
            "CommunityRAF": 0.672,
        },
        "C752": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of craniopharyngeal duct",
            "CommunityRAF": 0.672,
        },
        "C753": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of pineal gland",
            "CommunityRAF": 0.672,
        },
        "C773": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Secondary and unspecified malignant neoplasm of axilla and upper limb lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C779": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Secondary and unspecified malignant neoplasm of lymph node, unspecified",
            "CommunityRAF": 0.672,
        },
        "C792": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Secondary malignant neoplasm of skin",
            "CommunityRAF": 0.672,
        },
        "C7981": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Secondary malignant neoplasm of breast",
            "CommunityRAF": 0.672,
        },
        "C7982": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Secondary malignant neoplasm of genital organs",
            "CommunityRAF": 0.672,
        },
        "C8100": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8101": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8102": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8103": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8104": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8105": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8106": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8107": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8108": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8109": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular lymphocyte predominant Hodgkin lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8110": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8111": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8112": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8113": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8114": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8115": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8116": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8117": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8118": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8119": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Nodular sclerosis Hodgkin lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8120": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8121": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8122": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8123": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8124": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8125": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8126": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8127": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8128": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8129": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mixed cellularity Hodgkin lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8130": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8131": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8132": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8133": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8134": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8135": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8136": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8137": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8138": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8139": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte depleted Hodgkin lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8140": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8141": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8142": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8143": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8144": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8145": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8146": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8147": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8148": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8149": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphocyte-rich Hodgkin lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8170": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8171": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8172": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8173": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8174": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8175": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8176": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8177": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8178": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8179": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other Hodgkin lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8190": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8191": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8192": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8193": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8194": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8195": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8196": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8197": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, spleen",
            "CommunityRAF": 0.672,
        },
        "C8198": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8199": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hodgkin lymphoma, unspecified, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8200": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8201": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8202": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8203": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8204": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8205": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8206": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8207": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, spleen",
            "CommunityRAF": 0.672,
        },
        "C8208": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8209": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade I, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8210": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8211": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8212": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8213": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8214": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8215": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8216": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8217": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, spleen",
            "CommunityRAF": 0.672,
        },
        "C8218": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8219": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade II, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8220": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8221": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8222": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8223": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8224": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8225": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8226": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8227": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, spleen",
            "CommunityRAF": 0.672,
        },
        "C8228": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8229": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade III, unspecified, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8230": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8231": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8232": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8233": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8234": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8235": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8236": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8237": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, spleen",
            "CommunityRAF": 0.672,
        },
        "C8238": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8239": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIa, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8240": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8241": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8242": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8243": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8244": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8245": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8246": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8247": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, spleen",
            "CommunityRAF": 0.672,
        },
        "C8248": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8249": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma grade IIIb, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8250": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8251": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8252": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8253": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8254": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8255": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8256": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8257": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8258": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8259": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse follicle center lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8260": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8261": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8262": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8263": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8264": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8265": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8266": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8267": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8268": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8269": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous follicle center lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8280": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8281": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8282": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8283": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8284": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8285": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8286": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8287": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8288": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8289": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other types of follicular lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8290": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8291": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8292": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8293": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8294": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8295": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8296": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8297": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, spleen",
            "CommunityRAF": 0.672,
        },
        "C8298": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8299": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Follicular lymphoma, unspecified, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8300": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8301": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8302": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8303": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8304": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8305": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8306": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8307": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8308": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8309": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Small cell B-cell lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8310": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8311": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8312": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8313": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8314": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8315": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8316": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8317": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8318": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8319": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mantle cell lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8330": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8331": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8332": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8333": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8334": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8335": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8336": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8337": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8338": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8339": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Diffuse large B-cell lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8350": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8351": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8352": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8353": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8354": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8355": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8356": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8357": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8358": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8359": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoblastic (diffuse) lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8370": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8371": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8372": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8373": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8374": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8375": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8376": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8377": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8378": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8379": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Burkitt lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8380": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8381": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8382": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8383": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8384": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8385": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8386": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8387": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8388": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8389": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other non-follicular lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8390": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8391": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8392": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8393": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8394": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8395": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8396": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8397": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, spleen",
            "CommunityRAF": 0.672,
        },
        "C8398": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8399": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-follicular (diffuse) lymphoma, unspecified, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8400": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8401": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8402": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8403": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8404": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8405": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8406": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8407": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, spleen",
            "CommunityRAF": 0.672,
        },
        "C8408": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8409": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mycosis fungoides, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8410": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8411": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8412": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8413": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8414": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8415": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8416": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8417": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, spleen",
            "CommunityRAF": 0.672,
        },
        "C8418": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8419": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sezary disease, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8440": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8441": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8442": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8443": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8444": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8445": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8446": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8447": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, spleen",
            "CommunityRAF": 0.672,
        },
        "C8448": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8449": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Peripheral T-cell lymphoma, not classified, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8460": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8461": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8462": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8463": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8464": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8465": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8466": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8467": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, spleen",
            "CommunityRAF": 0.672,
        },
        "C8468": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8469": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-positive, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8470": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8471": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8472": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8473": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8474": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8475": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8476": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8477": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, spleen",
            "CommunityRAF": 0.672,
        },
        "C8478": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8479": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Anaplastic large cell lymphoma, ALK-negative, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8490": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8491": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8492": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8493": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8494": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8495": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8496": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8497": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, spleen",
            "CommunityRAF": 0.672,
        },
        "C8498": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8499": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature T/NK-cell lymphomas, unspecified, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C84A0": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C84A1": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C84A2": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C84A3": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C84A4": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C84A5": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C84A6": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C84A7": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified, spleen",
            "CommunityRAF": 0.672,
        },
        "C84A8": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C84A9": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Cutaneous T-cell lymphoma, unspecified, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C84Z0": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C84Z1": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C84Z2": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C84Z3": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C84Z4": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C84Z5": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C84Z6": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C84Z7": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, spleen",
            "CommunityRAF": 0.672,
        },
        "C84Z8": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C84Z9": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other mature T/NK-cell lymphomas, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8510": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8511": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8512": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8513": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8514": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8515": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8516": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8517": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8518": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8519": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unspecified B-cell lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8520": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8521": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8522": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8523": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8524": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8525": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8526": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8527": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8528": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8529": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mediastinal (thymic) large B-cell lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8580": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8581": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8582": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8583": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8584": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8585": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8586": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8587": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, spleen",
            "CommunityRAF": 0.672,
        },
        "C8588": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8589": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified types of non-Hodgkin lymphoma, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C8590": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, unspecified site",
            "CommunityRAF": 0.672,
        },
        "C8591": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, lymph nodes of head, face, and neck",
            "CommunityRAF": 0.672,
        },
        "C8592": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, intrathoracic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8593": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, intra-abdominal lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8594": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, lymph nodes of axilla and upper limb",
            "CommunityRAF": 0.672,
        },
        "C8595": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, lymph nodes of inguinal region and lower limb",
            "CommunityRAF": 0.672,
        },
        "C8596": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, intrapelvic lymph nodes",
            "CommunityRAF": 0.672,
        },
        "C8597": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, spleen",
            "CommunityRAF": 0.672,
        },
        "C8598": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, lymph nodes of multiple sites",
            "CommunityRAF": 0.672,
        },
        "C8599": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Non-Hodgkin lymphoma, unspecified, extranodal and solid organ sites",
            "CommunityRAF": 0.672,
        },
        "C860": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Extranodal NK/T-cell lymphoma, nasal type",
            "CommunityRAF": 0.672,
        },
        "C861": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hepatosplenic T-cell lymphoma",
            "CommunityRAF": 0.672,
        },
        "C862": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Enteropathy-type (intestinal) T-cell lymphoma",
            "CommunityRAF": 0.672,
        },
        "C863": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Subcutaneous panniculitis-like T-cell lymphoma",
            "CommunityRAF": 0.672,
        },
        "C864": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Blastic NK-cell lymphoma",
            "CommunityRAF": 0.672,
        },
        "C865": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Angioimmunoblastic T-cell lymphoma",
            "CommunityRAF": 0.672,
        },
        "C866": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Primary cutaneous CD30-positive T-cell proliferations",
            "CommunityRAF": 0.672,
        },
        "C882": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Heavy chain disease",
            "CommunityRAF": 0.672,
        },
        "C883": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Immunoproliferative small intestinal disease",
            "CommunityRAF": 0.672,
        },
        "C884": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Extranodal marginal zone B-cell lymphoma of mucosa-associated lymphoid tissue [MALT-lymphoma]",
            "CommunityRAF": 0.672,
        },
        "C888": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other malignant immunoproliferative diseases",
            "CommunityRAF": 0.672,
        },
        "C889": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant immunoproliferative disease, unspecified",
            "CommunityRAF": 0.672,
        },
        "C9030": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Solitary plasmacytoma not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C9031": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Solitary plasmacytoma in remission",
            "CommunityRAF": 0.672,
        },
        "C9032": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Solitary plasmacytoma in relapse",
            "CommunityRAF": 0.672,
        },
        "C9110": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Chronic lymphocytic leukemia of B-cell type not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C9111": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Chronic lymphocytic leukemia of B-cell type in remission",
            "CommunityRAF": 0.672,
        },
        "C9112": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Chronic lymphocytic leukemia of B-cell type in relapse",
            "CommunityRAF": 0.672,
        },
        "C9130": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Prolymphocytic leukemia of B-cell type not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C9131": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Prolymphocytic leukemia of B-cell type, in remission",
            "CommunityRAF": 0.672,
        },
        "C9132": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Prolymphocytic leukemia of B-cell type, in relapse",
            "CommunityRAF": 0.672,
        },
        "C9140": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hairy cell leukemia not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C9141": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hairy cell leukemia, in remission",
            "CommunityRAF": 0.672,
        },
        "C9142": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Hairy cell leukemia, in relapse",
            "CommunityRAF": 0.672,
        },
        "C9150": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Adult T-cell lymphoma/leukemia (HTLV-1-associated) not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C9151": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Adult T-cell lymphoma/leukemia (HTLV-1-associated), in remission",
            "CommunityRAF": 0.672,
        },
        "C9152": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Adult T-cell lymphoma/leukemia (HTLV-1-associated), in relapse",
            "CommunityRAF": 0.672,
        },
        "C9160": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Prolymphocytic leukemia of T-cell type not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C9161": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Prolymphocytic leukemia of T-cell type, in remission",
            "CommunityRAF": 0.672,
        },
        "C9162": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Prolymphocytic leukemia of T-cell type, in relapse",
            "CommunityRAF": 0.672,
        },
        "C9190": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoid leukemia, unspecified not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C9191": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoid leukemia, unspecified, in remission",
            "CommunityRAF": 0.672,
        },
        "C9192": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Lymphoid leukemia, unspecified, in relapse",
            "CommunityRAF": 0.672,
        },
        "C91A0": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature B-cell leukemia Burkitt-type not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C91A1": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature B-cell leukemia Burkitt-type, in remission",
            "CommunityRAF": 0.672,
        },
        "C91A2": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Mature B-cell leukemia Burkitt-type, in relapse",
            "CommunityRAF": 0.672,
        },
        "C91Z0": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other lymphoid leukemia not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C91Z1": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other lymphoid leukemia, in remission",
            "CommunityRAF": 0.672,
        },
        "C91Z2": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other lymphoid leukemia, in relapse",
            "CommunityRAF": 0.672,
        },
        "C9510": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Chronic leukemia of unspecified cell type not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C9511": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Chronic leukemia of unspecified cell type, in remission",
            "CommunityRAF": 0.672,
        },
        "C9512": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Chronic leukemia of unspecified cell type, in relapse",
            "CommunityRAF": 0.672,
        },
        "C9590": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Leukemia, unspecified not having achieved remission",
            "CommunityRAF": 0.672,
        },
        "C9591": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Leukemia, unspecified, in remission",
            "CommunityRAF": 0.672,
        },
        "C9592": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Leukemia, unspecified, in relapse",
            "CommunityRAF": 0.672,
        },
        "C960": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Multifocal and multisystemic (disseminated) Langerhans-cell histiocytosis",
            "CommunityRAF": 0.672,
        },
        "C962": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant mast cell tumor",
            "CommunityRAF": 0.672,
        },
        "C964": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Sarcoma of dendritic cells (accessory cells)",
            "CommunityRAF": 0.672,
        },
        "C965": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Multifocal and unisystemic Langerhans-cell histiocytosis",
            "CommunityRAF": 0.672,
        },
        "C966": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Unifocal Langerhans-cell histiocytosis",
            "CommunityRAF": 0.672,
        },
        "C969": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Malignant neoplasm of lymphoid, hematopoietic and related tissue, unspecified",
            "CommunityRAF": 0.672,
        },
        "C96A": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Histiocytic sarcoma",
            "CommunityRAF": 0.672,
        },
        "C96Z": {
            "HCC": "Lymphoma and Other Cancers",
            "ICD10": "Other specified malignant neoplasms of lymphoid, hematopoietic and related tissue",
            "CommunityRAF": 0.672,
        },
        "C01": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of base of tongue",
            "CommunityRAF": 0.317,
        },
        "C020": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of dorsal surface of tongue",
            "CommunityRAF": 0.317,
        },
        "C021": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of border of tongue",
            "CommunityRAF": 0.317,
        },
        "C022": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of ventral surface of tongue",
            "CommunityRAF": 0.317,
        },
        "C023": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of anterior two-thirds of tongue, part unspecified",
            "CommunityRAF": 0.317,
        },
        "C024": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of lingual tonsil",
            "CommunityRAF": 0.317,
        },
        "C028": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of tongue",
            "CommunityRAF": 0.317,
        },
        "C029": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of tongue, unspecified",
            "CommunityRAF": 0.317,
        },
        "C030": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of upper gum",
            "CommunityRAF": 0.317,
        },
        "C031": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of lower gum",
            "CommunityRAF": 0.317,
        },
        "C039": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of gum, unspecified",
            "CommunityRAF": 0.317,
        },
        "C040": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of anterior floor of mouth",
            "CommunityRAF": 0.317,
        },
        "C041": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of lateral floor of mouth",
            "CommunityRAF": 0.317,
        },
        "C048": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of floor of mouth",
            "CommunityRAF": 0.317,
        },
        "C049": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of floor of mouth, unspecified",
            "CommunityRAF": 0.317,
        },
        "C050": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of hard palate",
            "CommunityRAF": 0.317,
        },
        "C051": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of soft palate",
            "CommunityRAF": 0.317,
        },
        "C052": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of uvula",
            "CommunityRAF": 0.317,
        },
        "C058": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of palate",
            "CommunityRAF": 0.317,
        },
        "C059": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of palate, unspecified",
            "CommunityRAF": 0.317,
        },
        "C060": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of cheek mucosa",
            "CommunityRAF": 0.317,
        },
        "C061": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of vestibule of mouth",
            "CommunityRAF": 0.317,
        },
        "C062": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of retromolar area",
            "CommunityRAF": 0.317,
        },
        "C0680": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of unspecified parts of mouth",
            "CommunityRAF": 0.317,
        },
        "C0689": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of other parts of mouth",
            "CommunityRAF": 0.317,
        },
        "C069": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of mouth, unspecified",
            "CommunityRAF": 0.317,
        },
        "C07": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of parotid gland",
            "CommunityRAF": 0.317,
        },
        "C080": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of submandibular gland",
            "CommunityRAF": 0.317,
        },
        "C081": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of sublingual gland",
            "CommunityRAF": 0.317,
        },
        "C089": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of major salivary gland, unspecified",
            "CommunityRAF": 0.317,
        },
        "C090": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of tonsillar fossa",
            "CommunityRAF": 0.317,
        },
        "C091": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of tonsillar pillar (anterior) (posterior)",
            "CommunityRAF": 0.317,
        },
        "C098": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of tonsil",
            "CommunityRAF": 0.317,
        },
        "C099": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of tonsil, unspecified",
            "CommunityRAF": 0.317,
        },
        "C100": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of vallecula",
            "CommunityRAF": 0.317,
        },
        "C101": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of anterior surface of epiglottis",
            "CommunityRAF": 0.317,
        },
        "C102": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of lateral wall of oropharynx",
            "CommunityRAF": 0.317,
        },
        "C103": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of posterior wall of oropharynx",
            "CommunityRAF": 0.317,
        },
        "C104": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of branchial cleft",
            "CommunityRAF": 0.317,
        },
        "C108": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of oropharynx",
            "CommunityRAF": 0.317,
        },
        "C109": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of oropharynx, unspecified",
            "CommunityRAF": 0.317,
        },
        "C110": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of superior wall of nasopharynx",
            "CommunityRAF": 0.317,
        },
        "C111": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of posterior wall of nasopharynx",
            "CommunityRAF": 0.317,
        },
        "C112": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of lateral wall of nasopharynx",
            "CommunityRAF": 0.317,
        },
        "C113": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of anterior wall of nasopharynx",
            "CommunityRAF": 0.317,
        },
        "C118": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of nasopharynx",
            "CommunityRAF": 0.317,
        },
        "C119": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of nasopharynx, unspecified",
            "CommunityRAF": 0.317,
        },
        "C12": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of pyriform sinus",
            "CommunityRAF": 0.317,
        },
        "C130": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of postcricoid region",
            "CommunityRAF": 0.317,
        },
        "C131": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of aryepiglottic fold, hypopharyngeal aspect",
            "CommunityRAF": 0.317,
        },
        "C132": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of posterior wall of hypopharynx",
            "CommunityRAF": 0.317,
        },
        "C138": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of hypopharynx",
            "CommunityRAF": 0.317,
        },
        "C139": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of hypopharynx, unspecified",
            "CommunityRAF": 0.317,
        },
        "C140": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of pharynx, unspecified",
            "CommunityRAF": 0.317,
        },
        "C142": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of Waldeyer's ring",
            "CommunityRAF": 0.317,
        },
        "C148": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of lip, oral cavity and pharynx",
            "CommunityRAF": 0.317,
        },
        "C180": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of cecum",
            "CommunityRAF": 0.317,
        },
        "C181": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of appendix",
            "CommunityRAF": 0.317,
        },
        "C182": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of ascending colon",
            "CommunityRAF": 0.317,
        },
        "C183": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of hepatic flexure",
            "CommunityRAF": 0.317,
        },
        "C184": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of transverse colon",
            "CommunityRAF": 0.317,
        },
        "C185": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of splenic flexure",
            "CommunityRAF": 0.317,
        },
        "C186": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of descending colon",
            "CommunityRAF": 0.317,
        },
        "C187": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of sigmoid colon",
            "CommunityRAF": 0.317,
        },
        "C188": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of colon",
            "CommunityRAF": 0.317,
        },
        "C189": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of colon, unspecified",
            "CommunityRAF": 0.317,
        },
        "C19": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of rectosigmoid junction",
            "CommunityRAF": 0.317,
        },
        "C20": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of rectum",
            "CommunityRAF": 0.317,
        },
        "C210": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of anus, unspecified",
            "CommunityRAF": 0.317,
        },
        "C211": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of anal canal",
            "CommunityRAF": 0.317,
        },
        "C212": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of cloacogenic zone",
            "CommunityRAF": 0.317,
        },
        "C218": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of rectum, anus and anal canal",
            "CommunityRAF": 0.317,
        },
        "C260": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of intestinal tract, part unspecified",
            "CommunityRAF": 0.317,
        },
        "C261": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of spleen",
            "CommunityRAF": 0.317,
        },
        "C269": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of ill-defined sites within the digestive system",
            "CommunityRAF": 0.317,
        },
        "C300": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of nasal cavity",
            "CommunityRAF": 0.317,
        },
        "C301": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of middle ear",
            "CommunityRAF": 0.317,
        },
        "C310": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of maxillary sinus",
            "CommunityRAF": 0.317,
        },
        "C311": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of ethmoidal sinus",
            "CommunityRAF": 0.317,
        },
        "C312": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of frontal sinus",
            "CommunityRAF": 0.317,
        },
        "C313": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of sphenoid sinus",
            "CommunityRAF": 0.317,
        },
        "C318": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of accessory sinuses",
            "CommunityRAF": 0.317,
        },
        "C319": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of accessory sinus, unspecified",
            "CommunityRAF": 0.317,
        },
        "C320": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of glottis",
            "CommunityRAF": 0.317,
        },
        "C321": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of supraglottis",
            "CommunityRAF": 0.317,
        },
        "C322": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of subglottis",
            "CommunityRAF": 0.317,
        },
        "C323": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of laryngeal cartilage",
            "CommunityRAF": 0.317,
        },
        "C328": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of larynx",
            "CommunityRAF": 0.317,
        },
        "C329": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of larynx, unspecified",
            "CommunityRAF": 0.317,
        },
        "C37": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of thymus",
            "CommunityRAF": 0.317,
        },
        "C380": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of heart",
            "CommunityRAF": 0.317,
        },
        "C381": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of anterior mediastinum",
            "CommunityRAF": 0.317,
        },
        "C382": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of posterior mediastinum",
            "CommunityRAF": 0.317,
        },
        "C383": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of mediastinum, part unspecified",
            "CommunityRAF": 0.317,
        },
        "C388": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of heart, mediastinum and pleura",
            "CommunityRAF": 0.317,
        },
        "C390": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of upper respiratory tract, part unspecified",
            "CommunityRAF": 0.317,
        },
        "C399": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of lower respiratory tract, part unspecified",
            "CommunityRAF": 0.317,
        },
        "C510": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of labium majus",
            "CommunityRAF": 0.317,
        },
        "C511": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of labium minus",
            "CommunityRAF": 0.317,
        },
        "C512": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of clitoris",
            "CommunityRAF": 0.317,
        },
        "C518": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of vulva",
            "CommunityRAF": 0.317,
        },
        "C519": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of vulva, unspecified",
            "CommunityRAF": 0.317,
        },
        "C52": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of vagina",
            "CommunityRAF": 0.317,
        },
        "C530": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of endocervix",
            "CommunityRAF": 0.317,
        },
        "C531": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of exocervix",
            "CommunityRAF": 0.317,
        },
        "C538": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of cervix uteri",
            "CommunityRAF": 0.317,
        },
        "C539": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of cervix uteri, unspecified",
            "CommunityRAF": 0.317,
        },
        "C577": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of other specified female genital organs",
            "CommunityRAF": 0.317,
        },
        "C578": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of female genital organs",
            "CommunityRAF": 0.317,
        },
        "C579": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of female genital organ, unspecified",
            "CommunityRAF": 0.317,
        },
        "C641": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of right kidney, except renal pelvis",
            "CommunityRAF": 0.317,
        },
        "C642": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of left kidney, except renal pelvis",
            "CommunityRAF": 0.317,
        },
        "C649": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified kidney, except renal pelvis",
            "CommunityRAF": 0.317,
        },
        "C651": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of right renal pelvis",
            "CommunityRAF": 0.317,
        },
        "C652": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of left renal pelvis",
            "CommunityRAF": 0.317,
        },
        "C659": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified renal pelvis",
            "CommunityRAF": 0.317,
        },
        "C661": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of right ureter",
            "CommunityRAF": 0.317,
        },
        "C662": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of left ureter",
            "CommunityRAF": 0.317,
        },
        "C669": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of unspecified ureter",
            "CommunityRAF": 0.317,
        },
        "C670": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of trigone of bladder",
            "CommunityRAF": 0.317,
        },
        "C671": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of dome of bladder",
            "CommunityRAF": 0.317,
        },
        "C672": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of lateral wall of bladder",
            "CommunityRAF": 0.317,
        },
        "C673": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of anterior wall of bladder",
            "CommunityRAF": 0.317,
        },
        "C674": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of posterior wall of bladder",
            "CommunityRAF": 0.317,
        },
        "C675": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of bladder neck",
            "CommunityRAF": 0.317,
        },
        "C676": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of ureteric orifice",
            "CommunityRAF": 0.317,
        },
        "C677": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of urachus",
            "CommunityRAF": 0.317,
        },
        "C678": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of bladder",
            "CommunityRAF": 0.317,
        },
        "C679": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of bladder, unspecified",
            "CommunityRAF": 0.317,
        },
        "C680": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of urethra",
            "CommunityRAF": 0.317,
        },
        "C681": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of paraurethral glands",
            "CommunityRAF": 0.317,
        },
        "C688": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of overlapping sites of urinary organs",
            "CommunityRAF": 0.317,
        },
        "C689": {
            "HCC": "Colorectal, Bladder, and Other Cancers",
            "ICD10": "Malignant neoplasm of urinary organ, unspecified",
            "CommunityRAF": 0.317,
        },
        "C430": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of lip",
            "CommunityRAF": 0.154,
        },
        "C4310": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of unspecified eyelid, including canthus",
            "CommunityRAF": 0.154,
        },
        "C4311": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of right eyelid, including canthus",
            "CommunityRAF": 0.154,
        },
        "C4312": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of left eyelid, including canthus",
            "CommunityRAF": 0.154,
        },
        "C4320": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of unspecified ear and external auricular canal",
            "CommunityRAF": 0.154,
        },
        "C4321": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of right ear and external auricular canal",
            "CommunityRAF": 0.154,
        },
        "C4322": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of left ear and external auricular canal",
            "CommunityRAF": 0.154,
        },
        "C4330": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of unspecified part of face",
            "CommunityRAF": 0.154,
        },
        "C4331": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of nose",
            "CommunityRAF": 0.154,
        },
        "C4339": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of other parts of face",
            "CommunityRAF": 0.154,
        },
        "C434": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of scalp and neck",
            "CommunityRAF": 0.154,
        },
        "C4351": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of anal skin",
            "CommunityRAF": 0.154,
        },
        "C4352": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of skin of breast",
            "CommunityRAF": 0.154,
        },
        "C4359": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of other part of trunk",
            "CommunityRAF": 0.154,
        },
        "C4360": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of unspecified upper limb, including shoulder",
            "CommunityRAF": 0.154,
        },
        "C4361": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of right upper limb, including shoulder",
            "CommunityRAF": 0.154,
        },
        "C4362": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of left upper limb, including shoulder",
            "CommunityRAF": 0.154,
        },
        "C4370": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of unspecified lower limb, including hip",
            "CommunityRAF": 0.154,
        },
        "C4371": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of right lower limb, including hip",
            "CommunityRAF": 0.154,
        },
        "C4372": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of left lower limb, including hip",
            "CommunityRAF": 0.154,
        },
        "C438": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of overlapping sites of skin",
            "CommunityRAF": 0.154,
        },
        "C439": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant melanoma of skin, unspecified",
            "CommunityRAF": 0.154,
        },
        "C4A0": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of lip",
            "CommunityRAF": 0.154,
        },
        "C4A10": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of unspecified eyelid, including canthus",
            "CommunityRAF": 0.154,
        },
        "C4A11": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of right eyelid, including canthus",
            "CommunityRAF": 0.154,
        },
        "C4A12": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of left eyelid, including canthus",
            "CommunityRAF": 0.154,
        },
        "C4A20": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of unspecified ear and external auricular canal",
            "CommunityRAF": 0.154,
        },
        "C4A21": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of right ear and external auricular canal",
            "CommunityRAF": 0.154,
        },
        "C4A22": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of left ear and external auricular canal",
            "CommunityRAF": 0.154,
        },
        "C4A30": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of unspecified part of face",
            "CommunityRAF": 0.154,
        },
        "C4A31": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of nose",
            "CommunityRAF": 0.154,
        },
        "C4A39": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of other parts of face",
            "CommunityRAF": 0.154,
        },
        "C4A4": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of scalp and neck",
            "CommunityRAF": 0.154,
        },
        "C4A51": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of anal skin",
            "CommunityRAF": 0.154,
        },
        "C4A52": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of skin of breast",
            "CommunityRAF": 0.154,
        },
        "C4A59": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of other part of trunk",
            "CommunityRAF": 0.154,
        },
        "C4A60": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of unspecified upper limb, including shoulder",
            "CommunityRAF": 0.154,
        },
        "C4A61": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of right upper limb, including shoulder",
            "CommunityRAF": 0.154,
        },
        "C4A62": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of left upper limb, including shoulder",
            "CommunityRAF": 0.154,
        },
        "C4A70": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of unspecified lower limb, including hip",
            "CommunityRAF": 0.154,
        },
        "C4A71": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of right lower limb, including hip",
            "CommunityRAF": 0.154,
        },
        "C4A72": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of left lower limb, including hip",
            "CommunityRAF": 0.154,
        },
        "C4A8": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma of overlapping sites",
            "CommunityRAF": 0.154,
        },
        "C4A9": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Merkel cell carcinoma, unspecified",
            "CommunityRAF": 0.154,
        },
        "C50011": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of nipple and areola, right female breast",
            "CommunityRAF": 0.154,
        },
        "C50012": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of nipple and areola, left female breast",
            "CommunityRAF": 0.154,
        },
        "C50019": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of nipple and areola, unspecified female breast",
            "CommunityRAF": 0.154,
        },
        "C50021": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of nipple and areola, right male breast",
            "CommunityRAF": 0.154,
        },
        "C50022": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of nipple and areola, left male breast",
            "CommunityRAF": 0.154,
        },
        "C50029": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of nipple and areola, unspecified male breast",
            "CommunityRAF": 0.154,
        },
        "C50111": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of central portion of right female breast",
            "CommunityRAF": 0.154,
        },
        "C50112": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of central portion of left female breast",
            "CommunityRAF": 0.154,
        },
        "C50119": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of central portion of unspecified female breast",
            "CommunityRAF": 0.154,
        },
        "C50121": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of central portion of right male breast",
            "CommunityRAF": 0.154,
        },
        "C50122": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of central portion of left male breast",
            "CommunityRAF": 0.154,
        },
        "C50129": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of central portion of unspecified male breast",
            "CommunityRAF": 0.154,
        },
        "C50211": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-inner quadrant of right female breast",
            "CommunityRAF": 0.154,
        },
        "C50212": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-inner quadrant of left female breast",
            "CommunityRAF": 0.154,
        },
        "C50219": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-inner quadrant of unspecified female breast",
            "CommunityRAF": 0.154,
        },
        "C50221": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-inner quadrant of right male breast",
            "CommunityRAF": 0.154,
        },
        "C50222": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-inner quadrant of left male breast",
            "CommunityRAF": 0.154,
        },
        "C50229": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-inner quadrant of unspecified male breast",
            "CommunityRAF": 0.154,
        },
        "C50311": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-inner quadrant of right female breast",
            "CommunityRAF": 0.154,
        },
        "C50312": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-inner quadrant of left female breast",
            "CommunityRAF": 0.154,
        },
        "C50319": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-inner quadrant of unspecified female breast",
            "CommunityRAF": 0.154,
        },
        "C50321": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-inner quadrant of right male breast",
            "CommunityRAF": 0.154,
        },
        "C50322": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-inner quadrant of left male breast",
            "CommunityRAF": 0.154,
        },
        "C50329": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-inner quadrant of unspecified male breast",
            "CommunityRAF": 0.154,
        },
        "C50411": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-outer quadrant of right female breast",
            "CommunityRAF": 0.154,
        },
        "C50412": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-outer quadrant of left female breast",
            "CommunityRAF": 0.154,
        },
        "C50419": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-outer quadrant of unspecified female breast",
            "CommunityRAF": 0.154,
        },
        "C50421": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-outer quadrant of right male breast",
            "CommunityRAF": 0.154,
        },
        "C50422": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-outer quadrant of left male breast",
            "CommunityRAF": 0.154,
        },
        "C50429": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of upper-outer quadrant of unspecified male breast",
            "CommunityRAF": 0.154,
        },
        "C50511": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-outer quadrant of right female breast",
            "CommunityRAF": 0.154,
        },
        "C50512": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-outer quadrant of left female breast",
            "CommunityRAF": 0.154,
        },
        "C50519": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-outer quadrant of unspecified female breast",
            "CommunityRAF": 0.154,
        },
        "C50521": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-outer quadrant of right male breast",
            "CommunityRAF": 0.154,
        },
        "C50522": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-outer quadrant of left male breast",
            "CommunityRAF": 0.154,
        },
        "C50529": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of lower-outer quadrant of unspecified male breast",
            "CommunityRAF": 0.154,
        },
        "C50611": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of axillary tail of right female breast",
            "CommunityRAF": 0.154,
        },
        "C50612": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of axillary tail of left female breast",
            "CommunityRAF": 0.154,
        },
        "C50619": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of axillary tail of unspecified female breast",
            "CommunityRAF": 0.154,
        },
        "C50621": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of axillary tail of right male breast",
            "CommunityRAF": 0.154,
        },
        "C50622": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of axillary tail of left male breast",
            "CommunityRAF": 0.154,
        },
        "C50629": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of axillary tail of unspecified male breast",
            "CommunityRAF": 0.154,
        },
        "C50811": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of right female breast",
            "CommunityRAF": 0.154,
        },
        "C50812": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of left female breast",
            "CommunityRAF": 0.154,
        },
        "C50819": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of unspecified female breast",
            "CommunityRAF": 0.154,
        },
        "C50821": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of right male breast",
            "CommunityRAF": 0.154,
        },
        "C50822": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of left male breast",
            "CommunityRAF": 0.154,
        },
        "C50829": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of unspecified male breast",
            "CommunityRAF": 0.154,
        },
        "C50911": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified site of right female breast",
            "CommunityRAF": 0.154,
        },
        "C50912": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified site of left female breast",
            "CommunityRAF": 0.154,
        },
        "C50919": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified site of unspecified female breast",
            "CommunityRAF": 0.154,
        },
        "C50921": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified site of right male breast",
            "CommunityRAF": 0.154,
        },
        "C50922": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified site of left male breast",
            "CommunityRAF": 0.154,
        },
        "C50929": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified site of unspecified male breast",
            "CommunityRAF": 0.154,
        },
        "C540": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of isthmus uteri",
            "CommunityRAF": 0.154,
        },
        "C541": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of endometrium",
            "CommunityRAF": 0.154,
        },
        "C542": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of myometrium",
            "CommunityRAF": 0.154,
        },
        "C543": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of fundus uteri",
            "CommunityRAF": 0.154,
        },
        "C548": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of corpus uteri",
            "CommunityRAF": 0.154,
        },
        "C549": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of corpus uteri, unspecified",
            "CommunityRAF": 0.154,
        },
        "C55": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of uterus, part unspecified",
            "CommunityRAF": 0.154,
        },
        "C600": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of prepuce",
            "CommunityRAF": 0.154,
        },
        "C601": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of glans penis",
            "CommunityRAF": 0.154,
        },
        "C602": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of body of penis",
            "CommunityRAF": 0.154,
        },
        "C608": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of penis",
            "CommunityRAF": 0.154,
        },
        "C609": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of penis, unspecified",
            "CommunityRAF": 0.154,
        },
        "C61": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of prostate",
            "CommunityRAF": 0.154,
        },
        "C6200": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified undescended testis",
            "CommunityRAF": 0.154,
        },
        "C6201": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of undescended right testis",
            "CommunityRAF": 0.154,
        },
        "C6202": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of undescended left testis",
            "CommunityRAF": 0.154,
        },
        "C6210": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified descended testis",
            "CommunityRAF": 0.154,
        },
        "C6211": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of descended right testis",
            "CommunityRAF": 0.154,
        },
        "C6212": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of descended left testis",
            "CommunityRAF": 0.154,
        },
        "C6290": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified testis, unspecified whether descended or undescended",
            "CommunityRAF": 0.154,
        },
        "C6291": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right testis, unspecified whether descended or undescended",
            "CommunityRAF": 0.154,
        },
        "C6292": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left testis, unspecified whether descended or undescended",
            "CommunityRAF": 0.154,
        },
        "C6300": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified epididymis",
            "CommunityRAF": 0.154,
        },
        "C6301": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right epididymis",
            "CommunityRAF": 0.154,
        },
        "C6302": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left epididymis",
            "CommunityRAF": 0.154,
        },
        "C6310": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified spermatic cord",
            "CommunityRAF": 0.154,
        },
        "C6311": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right spermatic cord",
            "CommunityRAF": 0.154,
        },
        "C6312": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left spermatic cord",
            "CommunityRAF": 0.154,
        },
        "C632": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of scrotum",
            "CommunityRAF": 0.154,
        },
        "C637": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of other specified male genital organs",
            "CommunityRAF": 0.154,
        },
        "C638": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of male genital organs",
            "CommunityRAF": 0.154,
        },
        "C639": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of male genital organ, unspecified",
            "CommunityRAF": 0.154,
        },
        "C6900": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified conjunctiva",
            "CommunityRAF": 0.154,
        },
        "C6901": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right conjunctiva",
            "CommunityRAF": 0.154,
        },
        "C6902": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left conjunctiva",
            "CommunityRAF": 0.154,
        },
        "C6910": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified cornea",
            "CommunityRAF": 0.154,
        },
        "C6911": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right cornea",
            "CommunityRAF": 0.154,
        },
        "C6912": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left cornea",
            "CommunityRAF": 0.154,
        },
        "C6920": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified retina",
            "CommunityRAF": 0.154,
        },
        "C6921": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right retina",
            "CommunityRAF": 0.154,
        },
        "C6922": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left retina",
            "CommunityRAF": 0.154,
        },
        "C6930": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified choroid",
            "CommunityRAF": 0.154,
        },
        "C6931": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right choroid",
            "CommunityRAF": 0.154,
        },
        "C6932": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left choroid",
            "CommunityRAF": 0.154,
        },
        "C6940": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified ciliary body",
            "CommunityRAF": 0.154,
        },
        "C6941": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right ciliary body",
            "CommunityRAF": 0.154,
        },
        "C6942": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left ciliary body",
            "CommunityRAF": 0.154,
        },
        "C6950": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified lacrimal gland and duct",
            "CommunityRAF": 0.154,
        },
        "C6951": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right lacrimal gland and duct",
            "CommunityRAF": 0.154,
        },
        "C6952": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left lacrimal gland and duct",
            "CommunityRAF": 0.154,
        },
        "C6960": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified orbit",
            "CommunityRAF": 0.154,
        },
        "C6961": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right orbit",
            "CommunityRAF": 0.154,
        },
        "C6962": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left orbit",
            "CommunityRAF": 0.154,
        },
        "C6980": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of unspecified eye and adnexa",
            "CommunityRAF": 0.154,
        },
        "C6981": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of right eye and adnexa",
            "CommunityRAF": 0.154,
        },
        "C6982": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of overlapping sites of left eye and adnexa",
            "CommunityRAF": 0.154,
        },
        "C6990": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified site of unspecified eye",
            "CommunityRAF": 0.154,
        },
        "C6991": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified site of right eye",
            "CommunityRAF": 0.154,
        },
        "C6992": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified site of left eye",
            "CommunityRAF": 0.154,
        },
        "C73": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of thyroid gland",
            "CommunityRAF": 0.154,
        },
        "C750": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of parathyroid gland",
            "CommunityRAF": 0.154,
        },
        "C754": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of carotid body",
            "CommunityRAF": 0.154,
        },
        "C755": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of aortic body and other paraganglia",
            "CommunityRAF": 0.154,
        },
        "C758": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm with pluriglandular involvement, unspecified",
            "CommunityRAF": 0.154,
        },
        "C759": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of endocrine gland, unspecified",
            "CommunityRAF": 0.154,
        },
        "C760": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of head, face and neck",
            "CommunityRAF": 0.154,
        },
        "C761": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of thorax",
            "CommunityRAF": 0.154,
        },
        "C762": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of abdomen",
            "CommunityRAF": 0.154,
        },
        "C763": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of pelvis",
            "CommunityRAF": 0.154,
        },
        "C7640": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified upper limb",
            "CommunityRAF": 0.154,
        },
        "C7641": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right upper limb",
            "CommunityRAF": 0.154,
        },
        "C7642": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left upper limb",
            "CommunityRAF": 0.154,
        },
        "C7650": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of unspecified lower limb",
            "CommunityRAF": 0.154,
        },
        "C7651": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of right lower limb",
            "CommunityRAF": 0.154,
        },
        "C7652": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of left lower limb",
            "CommunityRAF": 0.154,
        },
        "C768": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm of other specified ill-defined sites",
            "CommunityRAF": 0.154,
        },
        "C7A00": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of unspecified site",
            "CommunityRAF": 0.154,
        },
        "C7A010": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the duodenum",
            "CommunityRAF": 0.154,
        },
        "C7A011": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the jejunum",
            "CommunityRAF": 0.154,
        },
        "C7A012": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the ileum",
            "CommunityRAF": 0.154,
        },
        "C7A019": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the small intestine, unspecified portion",
            "CommunityRAF": 0.154,
        },
        "C7A020": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the appendix",
            "CommunityRAF": 0.154,
        },
        "C7A021": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the cecum",
            "CommunityRAF": 0.154,
        },
        "C7A022": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the ascending colon",
            "CommunityRAF": 0.154,
        },
        "C7A023": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the transverse colon",
            "CommunityRAF": 0.154,
        },
        "C7A024": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the descending colon",
            "CommunityRAF": 0.154,
        },
        "C7A025": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the sigmoid colon",
            "CommunityRAF": 0.154,
        },
        "C7A026": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the rectum",
            "CommunityRAF": 0.154,
        },
        "C7A029": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the large intestine, unspecified portion",
            "CommunityRAF": 0.154,
        },
        "C7A090": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the bronchus and lung",
            "CommunityRAF": 0.154,
        },
        "C7A091": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the thymus",
            "CommunityRAF": 0.154,
        },
        "C7A092": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the stomach",
            "CommunityRAF": 0.154,
        },
        "C7A093": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the kidney",
            "CommunityRAF": 0.154,
        },
        "C7A094": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the foregut, unspecified",
            "CommunityRAF": 0.154,
        },
        "C7A095": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the midgut, unspecified",
            "CommunityRAF": 0.154,
        },
        "C7A096": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumor of the hindgut, unspecified",
            "CommunityRAF": 0.154,
        },
        "C7A098": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant carcinoid tumors of other sites",
            "CommunityRAF": 0.154,
        },
        "C7A1": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant poorly differentiated neuroendocrine tumors",
            "CommunityRAF": 0.154,
        },
        "C7A8": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Other malignant neuroendocrine tumors",
            "CommunityRAF": 0.154,
        },
        "C801": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant (primary) neoplasm, unspecified",
            "CommunityRAF": 0.154,
        },
        "C802": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Malignant neoplasm associated with transplanted organ",
            "CommunityRAF": 0.154,
        },
        "D030": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of lip",
            "CommunityRAF": 0.154,
        },
        "D0310": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of unspecified eyelid, including canthus",
            "CommunityRAF": 0.154,
        },
        "D0311": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of right eyelid, including canthus",
            "CommunityRAF": 0.154,
        },
        "D0312": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of left eyelid, including canthus",
            "CommunityRAF": 0.154,
        },
        "D0320": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of unspecified ear and external auricular canal",
            "CommunityRAF": 0.154,
        },
        "D0321": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of right ear and external auricular canal",
            "CommunityRAF": 0.154,
        },
        "D0322": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of left ear and external auricular canal",
            "CommunityRAF": 0.154,
        },
        "D0330": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of unspecified part of face",
            "CommunityRAF": 0.154,
        },
        "D0339": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of other parts of face",
            "CommunityRAF": 0.154,
        },
        "D034": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of scalp and neck",
            "CommunityRAF": 0.154,
        },
        "D0351": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of anal skin",
            "CommunityRAF": 0.154,
        },
        "D0352": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of breast (skin) (soft tissue)",
            "CommunityRAF": 0.154,
        },
        "D0359": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of other part of trunk",
            "CommunityRAF": 0.154,
        },
        "D0360": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of unspecified upper limb, including shoulder",
            "CommunityRAF": 0.154,
        },
        "D0361": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of right upper limb, including shoulder",
            "CommunityRAF": 0.154,
        },
        "D0362": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of left upper limb, including shoulder",
            "CommunityRAF": 0.154,
        },
        "D0370": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of unspecified lower limb, including hip",
            "CommunityRAF": 0.154,
        },
        "D0371": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of right lower limb, including hip",
            "CommunityRAF": 0.154,
        },
        "D0372": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of left lower limb, including hip",
            "CommunityRAF": 0.154,
        },
        "D038": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ of other sites",
            "CommunityRAF": 0.154,
        },
        "D039": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Melanoma in situ, unspecified",
            "CommunityRAF": 0.154,
        },
        "D1802": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Hemangioma of intracranial structures",
            "CommunityRAF": 0.154,
        },
        "D320": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of cerebral meninges",
            "CommunityRAF": 0.154,
        },
        "D321": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of spinal meninges",
            "CommunityRAF": 0.154,
        },
        "D329": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of meninges, unspecified",
            "CommunityRAF": 0.154,
        },
        "D330": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of brain, supratentorial",
            "CommunityRAF": 0.154,
        },
        "D331": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of brain, infratentorial",
            "CommunityRAF": 0.154,
        },
        "D332": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of brain, unspecified",
            "CommunityRAF": 0.154,
        },
        "D333": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of cranial nerves",
            "CommunityRAF": 0.154,
        },
        "D334": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of spinal cord",
            "CommunityRAF": 0.154,
        },
        "D337": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of other specified parts of central nervous system",
            "CommunityRAF": 0.154,
        },
        "D339": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of central nervous system, unspecified",
            "CommunityRAF": 0.154,
        },
        "D352": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of pituitary gland",
            "CommunityRAF": 0.154,
        },
        "D353": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of craniopharyngeal duct",
            "CommunityRAF": 0.154,
        },
        "D354": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Benign neoplasm of pineal gland",
            "CommunityRAF": 0.154,
        },
        "D420": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of cerebral meninges",
            "CommunityRAF": 0.154,
        },
        "D421": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of spinal meninges",
            "CommunityRAF": 0.154,
        },
        "D429": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of meninges, unspecified",
            "CommunityRAF": 0.154,
        },
        "D430": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of brain, supratentorial",
            "CommunityRAF": 0.154,
        },
        "D431": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of brain, infratentorial",
            "CommunityRAF": 0.154,
        },
        "D432": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of brain, unspecified",
            "CommunityRAF": 0.154,
        },
        "D433": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of cranial nerves",
            "CommunityRAF": 0.154,
        },
        "D434": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of spinal cord",
            "CommunityRAF": 0.154,
        },
        "D438": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of other specified parts of central nervous system",
            "CommunityRAF": 0.154,
        },
        "D439": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of central nervous system, unspecified",
            "CommunityRAF": 0.154,
        },
        "D443": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of pituitary gland",
            "CommunityRAF": 0.154,
        },
        "D444": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of craniopharyngeal duct",
            "CommunityRAF": 0.154,
        },
        "D445": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of pineal gland",
            "CommunityRAF": 0.154,
        },
        "D446": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of carotid body",
            "CommunityRAF": 0.154,
        },
        "D447": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of uncertain behavior of aortic body and other paraganglia",
            "CommunityRAF": 0.154,
        },
        "D496": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neoplasm of unspecified behavior of brain",
            "CommunityRAF": 0.154,
        },
        "E340": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Carcinoid syndrome",
            "CommunityRAF": 0.154,
        },
        "Q8500": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neurofibromatosis, unspecified",
            "CommunityRAF": 0.154,
        },
        "Q8501": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neurofibromatosis, type 1",
            "CommunityRAF": 0.154,
        },
        "Q8502": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Neurofibromatosis, type 2",
            "CommunityRAF": 0.154,
        },
        "Q8503": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Schwannomatosis",
            "CommunityRAF": 0.154,
        },
        "Q8509": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Other neurofibromatosis",
            "CommunityRAF": 0.154,
        },
        "Q851": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Tuberous sclerosis",
            "CommunityRAF": 0.154,
        },
        "Q858": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Other phakomatoses, not elsewhere classified",
            "CommunityRAF": 0.154,
        },
        "Q859": {
            "HCC": "Breast, Prostate, and Other Cancers and Tumors",
            "ICD10": "Phakomatosis, unspecified",
            "CommunityRAF": 0.154,
        },
        "E0800": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with hyperosmolarity without nonketotic hyperglycemic-hyperosmolar coma (NKHHC)",
            "CommunityRAF": 0.368,
        },
        "E0801": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with hyperosmolarity with coma",
            "CommunityRAF": 0.368,
        },
        "E0810": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with ketoacidosis without coma",
            "CommunityRAF": 0.368,
        },
        "E0811": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with ketoacidosis with coma",
            "CommunityRAF": 0.368,
        },
        "E08641": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with hypoglycemia with coma",
            "CommunityRAF": 0.368,
        },
        "E0900": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with hyperosmolarity without nonketotic hyperglycemic-hyperosmolar coma (NKHHC)",
            "CommunityRAF": 0.368,
        },
        "E0901": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with hyperosmolarity with coma",
            "CommunityRAF": 0.368,
        },
        "E0910": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with ketoacidosis without coma",
            "CommunityRAF": 0.368,
        },
        "E0911": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with ketoacidosis with coma",
            "CommunityRAF": 0.368,
        },
        "E09641": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with hypoglycemia with coma",
            "CommunityRAF": 0.368,
        },
        "E1010": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Type 1 diabetes mellitus with ketoacidosis without coma",
            "CommunityRAF": 0.368,
        },
        "E1011": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Type 1 diabetes mellitus with ketoacidosis with coma",
            "CommunityRAF": 0.368,
        },
        "E10641": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Type 1 diabetes mellitus with hypoglycemia with coma",
            "CommunityRAF": 0.368,
        },
        "E1100": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Type 2 diabetes mellitus with hyperosmolarity without nonketotic hyperglycemic-hyperosmolar coma (NKHHC)",
            "CommunityRAF": 0.368,
        },
        "E1101": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Type 2 diabetes mellitus with hyperosmolarity with coma",
            "CommunityRAF": 0.368,
        },
        "E11641": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Type 2 diabetes mellitus with hypoglycemia with coma",
            "CommunityRAF": 0.368,
        },
        "E1300": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Other specified diabetes mellitus with hyperosmolarity without nonketotic hyperglycemic-hyperosmolar coma (NKHHC)",
            "CommunityRAF": 0.368,
        },
        "E1301": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Other specified diabetes mellitus with hyperosmolarity with coma",
            "CommunityRAF": 0.368,
        },
        "E1310": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Other specified diabetes mellitus with ketoacidosis without coma",
            "CommunityRAF": 0.368,
        },
        "E1311": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Other specified diabetes mellitus with ketoacidosis with coma",
            "CommunityRAF": 0.368,
        },
        "E13641": {
            "HCC": "Diabetes with Acute Complications",
            "ICD10": "Other specified diabetes mellitus with hypoglycemia with coma",
            "CommunityRAF": 0.368,
        },
        "E0821": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic nephropathy",
            "CommunityRAF": 0.368,
        },
        "E0822": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic chronic kidney disease",
            "CommunityRAF": 0.368,
        },
        "E0829": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with other diabetic kidney complication",
            "CommunityRAF": 0.368,
        },
        "E08311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with unspecified diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E08319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with unspecified diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E08321": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E083211": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E083212": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E083213": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083219": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E08329": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E083291": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E083292": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E083293": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083299": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with mild nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E08331": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E083311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E083312": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E083313": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E08339": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E083391": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E083392": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E083393": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083399": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with moderate nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E08341": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E083411": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E083412": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E083413": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083419": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E08349": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E083491": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E083492": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E083493": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083499": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with severe nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E08351": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E083511": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E083512": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E083513": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083519": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E083521": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with traction retinal detachment involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E083522": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with traction retinal detachment involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E083523": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with traction retinal detachment involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083529": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with traction retinal detachment involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E083531": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E083532": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E083533": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083539": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E083541": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, right eye",
            "CommunityRAF": 0.368,
        },
        "E083542": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, left eye",
            "CommunityRAF": 0.368,
        },
        "E083543": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083549": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E083551": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with stable proliferative diabetic retinopathy, right eye",
            "CommunityRAF": 0.368,
        },
        "E083552": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with stable proliferative diabetic retinopathy, left eye",
            "CommunityRAF": 0.368,
        },
        "E083553": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with stable proliferative diabetic retinopathy, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083559": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with stable proliferative diabetic retinopathy, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E08359": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E083591": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E083592": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E083593": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E083599": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with proliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E0836": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic cataract",
            "CommunityRAF": 0.368,
        },
        "E0837X1": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic macular edema, resolved following treatment, right eye",
            "CommunityRAF": 0.368,
        },
        "E0837X2": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic macular edema, resolved following treatment, left eye",
            "CommunityRAF": 0.368,
        },
        "E0837X3": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic macular edema, resolved following treatment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E0837X9": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic macular edema, resolved following treatment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E0839": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with other diabetic ophthalmic complication",
            "CommunityRAF": 0.368,
        },
        "E0840": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic neuropathy, unspecified",
            "CommunityRAF": 0.368,
        },
        "E0841": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic mononeuropathy",
            "CommunityRAF": 0.368,
        },
        "E0842": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic polyneuropathy",
            "CommunityRAF": 0.368,
        },
        "E0843": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic autonomic (poly)neuropathy",
            "CommunityRAF": 0.368,
        },
        "E0844": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic amyotrophy",
            "CommunityRAF": 0.368,
        },
        "E0849": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with other diabetic neurological complication",
            "CommunityRAF": 0.368,
        },
        "E0851": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic peripheral angiopathy without gangrene",
            "CommunityRAF": 0.368,
        },
        "E0852": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic peripheral angiopathy with gangrene",
            "CommunityRAF": 0.368,
        },
        "E0859": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with other circulatory complications",
            "CommunityRAF": 0.368,
        },
        "E08610": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic neuropathic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E08618": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with other diabetic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E08620": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with diabetic dermatitis",
            "CommunityRAF": 0.368,
        },
        "E08621": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with foot ulcer",
            "CommunityRAF": 0.368,
        },
        "E08622": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with other skin ulcer",
            "CommunityRAF": 0.368,
        },
        "E08628": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with other skin complications",
            "CommunityRAF": 0.368,
        },
        "E08630": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with periodontal disease",
            "CommunityRAF": 0.368,
        },
        "E08638": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with other oral complications",
            "CommunityRAF": 0.368,
        },
        "E08649": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with hypoglycemia without coma",
            "CommunityRAF": 0.368,
        },
        "E0865": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with hyperglycemia",
            "CommunityRAF": 0.368,
        },
        "E0869": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with other specified complication",
            "CommunityRAF": 0.368,
        },
        "E088": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Diabetes mellitus due to underlying condition with unspecified complications",
            "CommunityRAF": 0.368,
        },
        "E0921": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic nephropathy",
            "CommunityRAF": 0.368,
        },
        "E0922": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic chronic kidney disease",
            "CommunityRAF": 0.368,
        },
        "E0929": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with other diabetic kidney complication",
            "CommunityRAF": 0.368,
        },
        "E09311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with unspecified diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E09319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with unspecified diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E09321": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E093211": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E093212": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E093213": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093219": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E09329": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E093291": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E093292": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E093293": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093299": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E09331": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E093311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E093312": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E093313": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E09339": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E093391": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E093392": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E093393": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093399": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E09341": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E093411": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E093412": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E093413": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093419": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E09349": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E093491": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E093492": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E093493": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093499": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E09351": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E093511": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E093512": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E093513": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093519": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E093521": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E093522": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E093523": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093529": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E093531": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E093532": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E093533": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093539": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E093541": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, right eye",
            "CommunityRAF": 0.368,
        },
        "E093542": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, left eye",
            "CommunityRAF": 0.368,
        },
        "E093543": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093549": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E093551": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with stable proliferative diabetic retinopathy, right eye",
            "CommunityRAF": 0.368,
        },
        "E093552": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with stable proliferative diabetic retinopathy, left eye",
            "CommunityRAF": 0.368,
        },
        "E093553": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with stable proliferative diabetic retinopathy, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093559": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with stable proliferative diabetic retinopathy, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E09359": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E093591": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E093592": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E093593": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E093599": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with proliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E0936": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic cataract",
            "CommunityRAF": 0.368,
        },
        "E0937X1": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic macular edema, resolved following treatment, right eye",
            "CommunityRAF": 0.368,
        },
        "E0937X2": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic macular edema, resolved following treatment, left eye",
            "CommunityRAF": 0.368,
        },
        "E0937X3": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic macular edema, resolved following treatment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E0937X9": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic macular edema, resolved following treatment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E0939": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with other diabetic ophthalmic complication",
            "CommunityRAF": 0.368,
        },
        "E0940": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with neurological complications with diabetic neuropathy, unspecified",
            "CommunityRAF": 0.368,
        },
        "E0941": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with neurological complications with diabetic mononeuropathy",
            "CommunityRAF": 0.368,
        },
        "E0942": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with neurological complications with diabetic polyneuropathy",
            "CommunityRAF": 0.368,
        },
        "E0943": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with neurological complications with diabetic autonomic (poly)neuropathy",
            "CommunityRAF": 0.368,
        },
        "E0944": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with neurological complications with diabetic amyotrophy",
            "CommunityRAF": 0.368,
        },
        "E0949": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with neurological complications with other diabetic neurological complication",
            "CommunityRAF": 0.368,
        },
        "E0951": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic peripheral angiopathy without gangrene",
            "CommunityRAF": 0.368,
        },
        "E0952": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic peripheral angiopathy with gangrene",
            "CommunityRAF": 0.368,
        },
        "E0959": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with other circulatory complications",
            "CommunityRAF": 0.368,
        },
        "E09610": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic neuropathic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E09618": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with other diabetic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E09620": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with diabetic dermatitis",
            "CommunityRAF": 0.368,
        },
        "E09621": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with foot ulcer",
            "CommunityRAF": 0.368,
        },
        "E09622": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with other skin ulcer",
            "CommunityRAF": 0.368,
        },
        "E09628": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with other skin complications",
            "CommunityRAF": 0.368,
        },
        "E09630": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with periodontal disease",
            "CommunityRAF": 0.368,
        },
        "E09638": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with other oral complications",
            "CommunityRAF": 0.368,
        },
        "E09649": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with hypoglycemia without coma",
            "CommunityRAF": 0.368,
        },
        "E0965": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with hyperglycemia",
            "CommunityRAF": 0.368,
        },
        "E0969": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with other specified complication",
            "CommunityRAF": 0.368,
        },
        "E098": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Drug or chemical induced diabetes mellitus with unspecified complications",
            "CommunityRAF": 0.368,
        },
        "E1021": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic nephropathy",
            "CommunityRAF": 0.368,
        },
        "E1022": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic chronic kidney disease",
            "CommunityRAF": 0.368,
        },
        "E1029": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with other diabetic kidney complication",
            "CommunityRAF": 0.368,
        },
        "E10311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with unspecified diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E10319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with unspecified diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E10321": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E103211": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E103212": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E103213": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103219": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E10329": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E103291": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E103292": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E103293": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103299": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E10331": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E103311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E103312": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E103313": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E10339": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E103391": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E103392": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E103393": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103399": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E10341": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E103411": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E103412": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E103413": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103419": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E10349": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E103491": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E103492": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E103493": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103499": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E10351": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E103511": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E103512": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E103513": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103519": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E103521": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E103522": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E103523": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103529": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E103531": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E103532": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E103533": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103539": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E103541": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, right eye",
            "CommunityRAF": 0.368,
        },
        "E103542": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, left eye",
            "CommunityRAF": 0.368,
        },
        "E103543": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103549": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E103551": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with stable proliferative diabetic retinopathy, right eye",
            "CommunityRAF": 0.368,
        },
        "E103552": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with stable proliferative diabetic retinopathy, left eye",
            "CommunityRAF": 0.368,
        },
        "E103553": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with stable proliferative diabetic retinopathy, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103559": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with stable proliferative diabetic retinopathy, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E10359": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E103591": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E103592": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E103593": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E103599": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with proliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E1036": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic cataract",
            "CommunityRAF": 0.368,
        },
        "E1037X1": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic macular edema, resolved following treatment, right eye",
            "CommunityRAF": 0.368,
        },
        "E1037X2": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic macular edema, resolved following treatment, left eye",
            "CommunityRAF": 0.368,
        },
        "E1037X3": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic macular edema, resolved following treatment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E1037X9": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic macular edema, resolved following treatment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E1039": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with other diabetic ophthalmic complication",
            "CommunityRAF": 0.368,
        },
        "E1040": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic neuropathy, unspecified",
            "CommunityRAF": 0.368,
        },
        "E1041": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic mononeuropathy",
            "CommunityRAF": 0.368,
        },
        "E1042": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic polyneuropathy",
            "CommunityRAF": 0.368,
        },
        "E1043": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic autonomic (poly)neuropathy",
            "CommunityRAF": 0.368,
        },
        "E1044": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic amyotrophy",
            "CommunityRAF": 0.368,
        },
        "E1049": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with other diabetic neurological complication",
            "CommunityRAF": 0.368,
        },
        "E1051": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic peripheral angiopathy without gangrene",
            "CommunityRAF": 0.368,
        },
        "E1052": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic peripheral angiopathy with gangrene",
            "CommunityRAF": 0.368,
        },
        "E1059": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with other circulatory complications",
            "CommunityRAF": 0.368,
        },
        "E10610": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic neuropathic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E10618": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with other diabetic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E10620": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with diabetic dermatitis",
            "CommunityRAF": 0.368,
        },
        "E10621": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with foot ulcer",
            "CommunityRAF": 0.368,
        },
        "E10622": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with other skin ulcer",
            "CommunityRAF": 0.368,
        },
        "E10628": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with other skin complications",
            "CommunityRAF": 0.368,
        },
        "E10630": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with periodontal disease",
            "CommunityRAF": 0.368,
        },
        "E10638": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with other oral complications",
            "CommunityRAF": 0.368,
        },
        "E10649": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with hypoglycemia without coma",
            "CommunityRAF": 0.368,
        },
        "E1065": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with hyperglycemia",
            "CommunityRAF": 0.368,
        },
        "E1069": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with other specified complication",
            "CommunityRAF": 0.368,
        },
        "E108": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 1 diabetes mellitus with unspecified complications",
            "CommunityRAF": 0.368,
        },
        "E1121": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic nephropathy",
            "CommunityRAF": 0.368,
        },
        "E1122": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic chronic kidney disease",
            "CommunityRAF": 0.368,
        },
        "E1129": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with other diabetic kidney complication",
            "CommunityRAF": 0.368,
        },
        "E11311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with unspecified diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E11319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with unspecified diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E11321": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E113211": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E113212": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E113213": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113219": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E11329": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E113291": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E113292": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E113293": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113299": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E11331": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E113311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E113312": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E113313": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E11339": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E113391": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E113392": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E113393": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113399": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E11341": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E113411": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E113412": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E113413": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113419": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E11349": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E113491": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E113492": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E113493": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113499": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E11351": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E113511": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E113512": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E113513": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113519": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E113521": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E113522": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E113523": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113529": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E113531": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E113532": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E113533": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113539": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E113541": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, right eye",
            "CommunityRAF": 0.368,
        },
        "E113542": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, left eye",
            "CommunityRAF": 0.368,
        },
        "E113543": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113549": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E113551": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with stable proliferative diabetic retinopathy, right eye",
            "CommunityRAF": 0.368,
        },
        "E113552": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with stable proliferative diabetic retinopathy, left eye",
            "CommunityRAF": 0.368,
        },
        "E113553": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with stable proliferative diabetic retinopathy, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113559": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with stable proliferative diabetic retinopathy, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E11359": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E113591": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E113592": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E113593": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E113599": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with proliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E1136": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic cataract",
            "CommunityRAF": 0.368,
        },
        "E1137X1": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic macular edema, resolved following treatment, right eye",
            "CommunityRAF": 0.368,
        },
        "E1137X2": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic macular edema, resolved following treatment, left eye",
            "CommunityRAF": 0.368,
        },
        "E1137X3": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic macular edema, resolved following treatment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E1137X9": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic macular edema, resolved following treatment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E1139": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with other diabetic ophthalmic complication",
            "CommunityRAF": 0.368,
        },
        "E1140": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic neuropathy, unspecified",
            "CommunityRAF": 0.368,
        },
        "E1141": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic mononeuropathy",
            "CommunityRAF": 0.368,
        },
        "E1142": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic polyneuropathy",
            "CommunityRAF": 0.368,
        },
        "E1143": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic autonomic (poly)neuropathy",
            "CommunityRAF": 0.368,
        },
        "E1144": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic amyotrophy",
            "CommunityRAF": 0.368,
        },
        "E1149": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with other diabetic neurological complication",
            "CommunityRAF": 0.368,
        },
        "E1151": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic peripheral angiopathy without gangrene",
            "CommunityRAF": 0.368,
        },
        "E1152": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic peripheral angiopathy with gangrene",
            "CommunityRAF": 0.368,
        },
        "E1159": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with other circulatory complications",
            "CommunityRAF": 0.368,
        },
        "E11610": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic neuropathic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E11618": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with other diabetic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E11620": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with diabetic dermatitis",
            "CommunityRAF": 0.368,
        },
        "E11621": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with foot ulcer",
            "CommunityRAF": 0.368,
        },
        "E11622": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with other skin ulcer",
            "CommunityRAF": 0.368,
        },
        "E11628": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with other skin complications",
            "CommunityRAF": 0.368,
        },
        "E11630": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with periodontal disease",
            "CommunityRAF": 0.368,
        },
        "E11638": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with other oral complications",
            "CommunityRAF": 0.368,
        },
        "E11649": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with hypoglycemia without coma",
            "CommunityRAF": 0.368,
        },
        "E1165": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with hyperglycemia",
            "CommunityRAF": 0.368,
        },
        "E1169": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with other specified complication",
            "CommunityRAF": 0.368,
        },
        "E118": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Type 2 diabetes mellitus with unspecified complications",
            "CommunityRAF": 0.368,
        },
        "E1321": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic nephropathy",
            "CommunityRAF": 0.368,
        },
        "E1322": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic chronic kidney disease",
            "CommunityRAF": 0.368,
        },
        "E1329": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with other diabetic kidney complication",
            "CommunityRAF": 0.368,
        },
        "E13311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with unspecified diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E13319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with unspecified diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E13321": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E133211": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E133212": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E133213": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133219": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E13329": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E133291": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E133292": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E133293": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133299": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with mild nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E13331": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E133311": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E133312": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E133313": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133319": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E13339": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E133391": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E133392": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E133393": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133399": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with moderate nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E13341": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E133411": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E133412": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E133413": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133419": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E13349": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E133491": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E133492": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E133493": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133499": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with severe nonproliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E13351": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with macular edema",
            "CommunityRAF": 0.368,
        },
        "E133511": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E133512": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E133513": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133519": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E133521": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E133522": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E133523": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133529": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E133531": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, right eye",
            "CommunityRAF": 0.368,
        },
        "E133532": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, left eye",
            "CommunityRAF": 0.368,
        },
        "E133533": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133539": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with traction retinal detachment not involving the macula, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E133541": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, right eye",
            "CommunityRAF": 0.368,
        },
        "E133542": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, left eye",
            "CommunityRAF": 0.368,
        },
        "E133543": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133549": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy with combined traction retinal detachment and rhegmatogenous retinal detachment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E133551": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with stable proliferative diabetic retinopathy, right eye",
            "CommunityRAF": 0.368,
        },
        "E133552": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with stable proliferative diabetic retinopathy, left eye",
            "CommunityRAF": 0.368,
        },
        "E133553": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with stable proliferative diabetic retinopathy, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133559": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with stable proliferative diabetic retinopathy, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E13359": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy without macular edema",
            "CommunityRAF": 0.368,
        },
        "E133591": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy without macular edema, right eye",
            "CommunityRAF": 0.368,
        },
        "E133592": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy without macular edema, left eye",
            "CommunityRAF": 0.368,
        },
        "E133593": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy without macular edema, bilateral",
            "CommunityRAF": 0.368,
        },
        "E133599": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with proliferative diabetic retinopathy without macular edema, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E1336": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic cataract",
            "CommunityRAF": 0.368,
        },
        "E1337X1": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic macular edema, resolved following treatment, right eye",
            "CommunityRAF": 0.368,
        },
        "E1337X2": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic macular edema, resolved following treatment, left eye",
            "CommunityRAF": 0.368,
        },
        "E1337X3": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic macular edema, resolved following treatment, bilateral",
            "CommunityRAF": 0.368,
        },
        "E1337X9": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic macular edema, resolved following treatment, unspecified eye",
            "CommunityRAF": 0.368,
        },
        "E1339": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with other diabetic ophthalmic complication",
            "CommunityRAF": 0.368,
        },
        "E1340": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic neuropathy, unspecified",
            "CommunityRAF": 0.368,
        },
        "E1341": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic mononeuropathy",
            "CommunityRAF": 0.368,
        },
        "E1342": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic polyneuropathy",
            "CommunityRAF": 0.368,
        },
        "E1343": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic autonomic (poly)neuropathy",
            "CommunityRAF": 0.368,
        },
        "E1344": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic amyotrophy",
            "CommunityRAF": 0.368,
        },
        "E1349": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with other diabetic neurological complication",
            "CommunityRAF": 0.368,
        },
        "E1351": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic peripheral angiopathy without gangrene",
            "CommunityRAF": 0.368,
        },
        "E1352": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic peripheral angiopathy with gangrene",
            "CommunityRAF": 0.368,
        },
        "E1359": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with other circulatory complications",
            "CommunityRAF": 0.368,
        },
        "E13610": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic neuropathic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E13618": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with other diabetic arthropathy",
            "CommunityRAF": 0.368,
        },
        "E13620": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with diabetic dermatitis",
            "CommunityRAF": 0.368,
        },
        "E13621": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with foot ulcer",
            "CommunityRAF": 0.368,
        },
        "E13622": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with other skin ulcer",
            "CommunityRAF": 0.368,
        },
        "E13628": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with other skin complications",
            "CommunityRAF": 0.368,
        },
        "E13630": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with periodontal disease",
            "CommunityRAF": 0.368,
        },
        "E13638": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with other oral complications",
            "CommunityRAF": 0.368,
        },
        "E13649": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with hypoglycemia without coma",
            "CommunityRAF": 0.368,
        },
        "E1365": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with hyperglycemia",
            "CommunityRAF": 0.368,
        },
        "E1369": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with other specified complication",
            "CommunityRAF": 0.368,
        },
        "E138": {
            "HCC": "Diabetes with Chronic Complications",
            "ICD10": "Other specified diabetes mellitus with unspecified complications",
            "CommunityRAF": 0.368,
        },
        "E089": {
            "HCC": "Diabetes without Complication",
            "ICD10": "Diabetes mellitus due to underlying condition without complications",
            "CommunityRAF": 0.118,
        },
        "E099": {
            "HCC": "Diabetes without Complication",
            "ICD10": "Drug or chemical induced diabetes mellitus without complications",
            "CommunityRAF": 0.118,
        },
        "E109": {
            "HCC": "Diabetes without Complication",
            "ICD10": "Type 1 diabetes mellitus without complications",
            "CommunityRAF": 0.118,
        },
        "E119": {
            "HCC": "Diabetes without Complication",
            "ICD10": "Type 2 diabetes mellitus without complications",
            "CommunityRAF": 0.118,
        },
        "E139": {
            "HCC": "Diabetes without Complication",
            "ICD10": "Other specified diabetes mellitus without complications",
            "CommunityRAF": 0.118,
        },
        "Z794": {
            "HCC": "Diabetes without Complication",
            "ICD10": "Long term (current) use of insulin",
            "CommunityRAF": 0.118,
        },
        "E40": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Kwashiorkor",
            "CommunityRAF": 0.713,
        },
        "E41": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Nutritional marasmus",
            "CommunityRAF": 0.713,
        },
        "E42": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Marasmic kwashiorkor",
            "CommunityRAF": 0.713,
        },
        "E43": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Unspecified severe protein-calorie malnutrition",
            "CommunityRAF": 0.713,
        },
        "E440": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Moderate protein-calorie malnutrition",
            "CommunityRAF": 0.713,
        },
        "E441": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Mild protein-calorie malnutrition",
            "CommunityRAF": 0.713,
        },
        "E45": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Retarded development following protein-calorie malnutrition",
            "CommunityRAF": 0.713,
        },
        "E46": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Unspecified protein-calorie malnutrition",
            "CommunityRAF": 0.713,
        },
        "E640": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Sequelae of protein-calorie malnutrition",
            "CommunityRAF": 0.713,
        },
        "R64": {
            "HCC": "Protein-Calorie Malnutrition",
            "ICD10": "Cachexia",
            "CommunityRAF": 0.713,
        },
        "E6601": {
            "HCC": "Morbid Obesity",
            "ICD10": "Morbid (severe) obesity due to excess calories",
            "CommunityRAF": 0.365,
        },
        "E662": {
            "HCC": "Morbid Obesity",
            "ICD10": "Morbid (severe) obesity with alveolar hypoventilation",
            "CommunityRAF": 0.365,
        },
        "Z6841": {
            "HCC": "Morbid Obesity",
            "ICD10": "Body mass index (BMI) 40.0-44.9, adult",
            "CommunityRAF": 0.365,
        },
        "Z6842": {
            "HCC": "Morbid Obesity",
            "ICD10": "Body mass index (BMI) 45.0-49.9, adult",
            "CommunityRAF": 0.365,
        },
        "Z6843": {
            "HCC": "Morbid Obesity",
            "ICD10": "Body mass index (BMI) 50-59.9 , adult",
            "CommunityRAF": 0.365,
        },
        "Z6844": {
            "HCC": "Morbid Obesity",
            "ICD10": "Body mass index (BMI) 60.0-69.9, adult",
            "CommunityRAF": 0.365,
        },
        "Z6845": {
            "HCC": "Morbid Obesity",
            "ICD10": "Body mass index (BMI) 70 or greater, adult",
            "CommunityRAF": 0.365,
        },
        "A391": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Waterhouse-Friderichsen syndrome",
            "CommunityRAF": 0.245,
        },
        "C880": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Waldenstrom macroglobulinemia",
            "CommunityRAF": 0.245,
        },
        "D841": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Defects in the complement system",
            "CommunityRAF": 0.245,
        },
        "D891": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Cryoglobulinemia",
            "CommunityRAF": 0.245,
        },
        "E035": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Myxedema coma",
            "CommunityRAF": 0.245,
        },
        "E15": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Nondiabetic hypoglycemic coma",
            "CommunityRAF": 0.245,
        },
        "E200": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Idiopathic hypoparathyroidism",
            "CommunityRAF": 0.245,
        },
        "E208": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other hypoparathyroidism",
            "CommunityRAF": 0.245,
        },
        "E209": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hypoparathyroidism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E210": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Primary hyperparathyroidism",
            "CommunityRAF": 0.245,
        },
        "E211": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Secondary hyperparathyroidism, not elsewhere classified",
            "CommunityRAF": 0.245,
        },
        "E212": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other hyperparathyroidism",
            "CommunityRAF": 0.245,
        },
        "E213": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hyperparathyroidism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E214": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other specified disorders of parathyroid gland",
            "CommunityRAF": 0.245,
        },
        "E215": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of parathyroid gland, unspecified",
            "CommunityRAF": 0.245,
        },
        "E220": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Acromegaly and pituitary gigantism",
            "CommunityRAF": 0.245,
        },
        "E221": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hyperprolactinemia",
            "CommunityRAF": 0.245,
        },
        "E222": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Syndrome of inappropriate secretion of antidiuretic hormone",
            "CommunityRAF": 0.245,
        },
        "E228": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other hyperfunction of pituitary gland",
            "CommunityRAF": 0.245,
        },
        "E229": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hyperfunction of pituitary gland, unspecified",
            "CommunityRAF": 0.245,
        },
        "E230": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hypopituitarism",
            "CommunityRAF": 0.245,
        },
        "E231": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Drug-induced hypopituitarism",
            "CommunityRAF": 0.245,
        },
        "E232": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Diabetes insipidus",
            "CommunityRAF": 0.245,
        },
        "E233": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hypothalamic dysfunction, not elsewhere classified",
            "CommunityRAF": 0.245,
        },
        "E236": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of pituitary gland",
            "CommunityRAF": 0.245,
        },
        "E237": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of pituitary gland, unspecified",
            "CommunityRAF": 0.245,
        },
        "E240": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Pituitary-dependent Cushing's disease",
            "CommunityRAF": 0.245,
        },
        "E241": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Nelson's syndrome",
            "CommunityRAF": 0.245,
        },
        "E242": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Drug-induced Cushing's syndrome",
            "CommunityRAF": 0.245,
        },
        "E243": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Ectopic ACTH syndrome",
            "CommunityRAF": 0.245,
        },
        "E244": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Alcohol-induced pseudo-Cushing's syndrome",
            "CommunityRAF": 0.245,
        },
        "E248": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other Cushing's syndrome",
            "CommunityRAF": 0.245,
        },
        "E249": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Cushing's syndrome, unspecified",
            "CommunityRAF": 0.245,
        },
        "E250": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Congenital adrenogenital disorders associated with enzyme deficiency",
            "CommunityRAF": 0.245,
        },
        "E258": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other adrenogenital disorders",
            "CommunityRAF": 0.245,
        },
        "E259": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Adrenogenital disorder, unspecified",
            "CommunityRAF": 0.245,
        },
        "E2601": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Conn's syndrome",
            "CommunityRAF": 0.245,
        },
        "E2602": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Glucocorticoid-remediable aldosteronism",
            "CommunityRAF": 0.245,
        },
        "E2609": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other primary hyperaldosteronism",
            "CommunityRAF": 0.245,
        },
        "E261": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Secondary hyperaldosteronism",
            "CommunityRAF": 0.245,
        },
        "E2681": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Bartter's syndrome",
            "CommunityRAF": 0.245,
        },
        "E2689": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other hyperaldosteronism",
            "CommunityRAF": 0.245,
        },
        "E269": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hyperaldosteronism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E270": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other adrenocortical overactivity",
            "CommunityRAF": 0.245,
        },
        "E271": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Primary adrenocortical insufficiency",
            "CommunityRAF": 0.245,
        },
        "E272": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Addisonian crisis",
            "CommunityRAF": 0.245,
        },
        "E273": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Drug-induced adrenocortical insufficiency",
            "CommunityRAF": 0.245,
        },
        "E2740": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Unspecified adrenocortical insufficiency",
            "CommunityRAF": 0.245,
        },
        "E2749": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other adrenocortical insufficiency",
            "CommunityRAF": 0.245,
        },
        "E275": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Adrenomedullary hyperfunction",
            "CommunityRAF": 0.245,
        },
        "E278": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other specified disorders of adrenal gland",
            "CommunityRAF": 0.245,
        },
        "E279": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of adrenal gland, unspecified",
            "CommunityRAF": 0.245,
        },
        "E310": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Autoimmune polyglandular failure",
            "CommunityRAF": 0.245,
        },
        "E311": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Polyglandular hyperfunction",
            "CommunityRAF": 0.245,
        },
        "E3120": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Multiple endocrine neoplasia [MEN] syndrome, unspecified",
            "CommunityRAF": 0.245,
        },
        "E3121": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Multiple endocrine neoplasia [MEN] type I",
            "CommunityRAF": 0.245,
        },
        "E3122": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Multiple endocrine neoplasia [MEN] type IIA",
            "CommunityRAF": 0.245,
        },
        "E3123": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Multiple endocrine neoplasia [MEN] type IIB",
            "CommunityRAF": 0.245,
        },
        "E318": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other polyglandular dysfunction",
            "CommunityRAF": 0.245,
        },
        "E319": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Polyglandular dysfunction, unspecified",
            "CommunityRAF": 0.245,
        },
        "E320": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Persistent hyperplasia of thymus",
            "CommunityRAF": 0.245,
        },
        "E321": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Abscess of thymus",
            "CommunityRAF": 0.245,
        },
        "E328": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other diseases of thymus",
            "CommunityRAF": 0.245,
        },
        "E329": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disease of thymus, unspecified",
            "CommunityRAF": 0.245,
        },
        "E344": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Constitutional tall stature",
            "CommunityRAF": 0.245,
        },
        "E700": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Classical phenylketonuria",
            "CommunityRAF": 0.245,
        },
        "E701": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other hyperphenylalaninemias",
            "CommunityRAF": 0.245,
        },
        "E7020": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of tyrosine metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7021": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Tyrosinemia",
            "CommunityRAF": 0.245,
        },
        "E7029": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of tyrosine metabolism",
            "CommunityRAF": 0.245,
        },
        "E7030": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Albinism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E70310": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "X-linked ocular albinism",
            "CommunityRAF": 0.245,
        },
        "E70311": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Autosomal recessive ocular albinism",
            "CommunityRAF": 0.245,
        },
        "E70318": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other ocular albinism",
            "CommunityRAF": 0.245,
        },
        "E70319": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Ocular albinism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E70320": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Tyrosinase negative oculocutaneous albinism",
            "CommunityRAF": 0.245,
        },
        "E70321": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Tyrosinase positive oculocutaneous albinism",
            "CommunityRAF": 0.245,
        },
        "E70328": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other oculocutaneous albinism",
            "CommunityRAF": 0.245,
        },
        "E70329": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Oculocutaneous albinism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E70330": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Chediak-Higashi syndrome",
            "CommunityRAF": 0.245,
        },
        "E70331": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hermansky-Pudlak syndrome",
            "CommunityRAF": 0.245,
        },
        "E70338": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other albinism with hematologic abnormality",
            "CommunityRAF": 0.245,
        },
        "E70339": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Albinism with hematologic abnormality, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7039": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other specified albinism",
            "CommunityRAF": 0.245,
        },
        "E7040": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorders of histidine metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7041": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Histidinemia",
            "CommunityRAF": 0.245,
        },
        "E7049": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of histidine metabolism",
            "CommunityRAF": 0.245,
        },
        "E705": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorders of tryptophan metabolism",
            "CommunityRAF": 0.245,
        },
        "E708": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of aromatic amino-acid metabolism",
            "CommunityRAF": 0.245,
        },
        "E709": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of aromatic amino-acid metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E710": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Maple-syrup-urine disease",
            "CommunityRAF": 0.245,
        },
        "E71110": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Isovaleric acidemia",
            "CommunityRAF": 0.245,
        },
        "E71111": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "3-methylglutaconic aciduria",
            "CommunityRAF": 0.245,
        },
        "E71118": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other branched-chain organic acidurias",
            "CommunityRAF": 0.245,
        },
        "E71120": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Methylmalonic acidemia",
            "CommunityRAF": 0.245,
        },
        "E71121": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Propionic acidemia",
            "CommunityRAF": 0.245,
        },
        "E71128": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of propionate metabolism",
            "CommunityRAF": 0.245,
        },
        "E7119": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of branched-chain amino-acid metabolism",
            "CommunityRAF": 0.245,
        },
        "E712": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of branched-chain amino-acid metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E71310": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Long chain/very long chain acyl CoA dehydrogenase deficiency",
            "CommunityRAF": 0.245,
        },
        "E71311": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Medium chain acyl CoA dehydrogenase deficiency",
            "CommunityRAF": 0.245,
        },
        "E71312": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Short chain acyl CoA dehydrogenase deficiency",
            "CommunityRAF": 0.245,
        },
        "E71313": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Glutaric aciduria type II",
            "CommunityRAF": 0.245,
        },
        "E71314": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Muscle carnitine palmitoyltransferase deficiency",
            "CommunityRAF": 0.245,
        },
        "E71318": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of fatty-acid oxidation",
            "CommunityRAF": 0.245,
        },
        "E7132": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorders of ketone metabolism",
            "CommunityRAF": 0.245,
        },
        "E7139": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of fatty-acid metabolism",
            "CommunityRAF": 0.245,
        },
        "E7140": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of carnitine metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7141": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Primary carnitine deficiency",
            "CommunityRAF": 0.245,
        },
        "E7142": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Carnitine deficiency due to inborn errors of metabolism",
            "CommunityRAF": 0.245,
        },
        "E7143": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Iatrogenic carnitine deficiency",
            "CommunityRAF": 0.245,
        },
        "E71440": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Ruvalcaba-Myhre-Smith syndrome",
            "CommunityRAF": 0.245,
        },
        "E71448": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other secondary carnitine deficiency",
            "CommunityRAF": 0.245,
        },
        "E7150": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Peroxisomal disorder, unspecified",
            "CommunityRAF": 0.245,
        },
        "E71510": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Zellweger syndrome",
            "CommunityRAF": 0.245,
        },
        "E71511": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Neonatal adrenoleukodystrophy",
            "CommunityRAF": 0.245,
        },
        "E71518": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of peroxisome biogenesis",
            "CommunityRAF": 0.245,
        },
        "E71520": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Childhood cerebral X-linked adrenoleukodystrophy",
            "CommunityRAF": 0.245,
        },
        "E71521": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Adolescent X-linked adrenoleukodystrophy",
            "CommunityRAF": 0.245,
        },
        "E71522": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Adrenomyeloneuropathy",
            "CommunityRAF": 0.245,
        },
        "E71528": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other X-linked adrenoleukodystrophy",
            "CommunityRAF": 0.245,
        },
        "E71529": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "X-linked adrenoleukodystrophy, unspecified type",
            "CommunityRAF": 0.245,
        },
        "E7153": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other group 2 peroxisomal disorders",
            "CommunityRAF": 0.245,
        },
        "E71540": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Rhizomelic chondrodysplasia punctata",
            "CommunityRAF": 0.245,
        },
        "E71541": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Zellweger-like syndrome",
            "CommunityRAF": 0.245,
        },
        "E71542": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other group 3 peroxisomal disorders",
            "CommunityRAF": 0.245,
        },
        "E71548": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other peroxisomal disorders",
            "CommunityRAF": 0.245,
        },
        "E7200": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorders of amino-acid transport, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7201": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Cystinuria",
            "CommunityRAF": 0.245,
        },
        "E7202": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hartnup's disease",
            "CommunityRAF": 0.245,
        },
        "E7203": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Lowe's syndrome",
            "CommunityRAF": 0.245,
        },
        "E7204": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Cystinosis",
            "CommunityRAF": 0.245,
        },
        "E7209": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of amino-acid transport",
            "CommunityRAF": 0.245,
        },
        "E7210": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorders of sulfur-bearing amino-acid metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7211": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Homocystinuria",
            "CommunityRAF": 0.245,
        },
        "E7212": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Methylenetetrahydrofolate reductase deficiency",
            "CommunityRAF": 0.245,
        },
        "E7219": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of sulfur-bearing amino-acid metabolism",
            "CommunityRAF": 0.245,
        },
        "E7220": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of urea cycle metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7221": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Argininemia",
            "CommunityRAF": 0.245,
        },
        "E7222": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Arginosuccinic aciduria",
            "CommunityRAF": 0.245,
        },
        "E7223": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Citrullinemia",
            "CommunityRAF": 0.245,
        },
        "E7229": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of urea cycle metabolism",
            "CommunityRAF": 0.245,
        },
        "E723": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorders of lysine and hydroxylysine metabolism",
            "CommunityRAF": 0.245,
        },
        "E724": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorders of ornithine metabolism",
            "CommunityRAF": 0.245,
        },
        "E7250": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of glycine metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7251": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Non-ketotic hyperglycinemia",
            "CommunityRAF": 0.245,
        },
        "E7252": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Trimethylaminuria",
            "CommunityRAF": 0.245,
        },
        "E7253": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hyperoxaluria",
            "CommunityRAF": 0.245,
        },
        "E7259": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of glycine metabolism",
            "CommunityRAF": 0.245,
        },
        "E728": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other specified disorders of amino-acid metabolism",
            "CommunityRAF": 0.245,
        },
        "E729": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of amino-acid metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7400": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Glycogen storage disease, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7401": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "von Gierke disease",
            "CommunityRAF": 0.245,
        },
        "E7402": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Pompe disease",
            "CommunityRAF": 0.245,
        },
        "E7403": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Cori disease",
            "CommunityRAF": 0.245,
        },
        "E7404": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "McArdle disease",
            "CommunityRAF": 0.245,
        },
        "E7409": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other glycogen storage disease",
            "CommunityRAF": 0.245,
        },
        "E7420": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorders of galactose metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7421": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Galactosemia",
            "CommunityRAF": 0.245,
        },
        "E7429": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of galactose metabolism",
            "CommunityRAF": 0.245,
        },
        "E744": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorders of pyruvate metabolism and gluconeogenesis",
            "CommunityRAF": 0.245,
        },
        "E748": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other specified disorders of carbohydrate metabolism",
            "CommunityRAF": 0.245,
        },
        "E749": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of carbohydrate metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7521": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Fabry (-Anderson) disease",
            "CommunityRAF": 0.245,
        },
        "E7522": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Gaucher disease",
            "CommunityRAF": 0.245,
        },
        "E75240": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Niemann-Pick disease type A",
            "CommunityRAF": 0.245,
        },
        "E75241": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Niemann-Pick disease type B",
            "CommunityRAF": 0.245,
        },
        "E75242": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Niemann-Pick disease type C",
            "CommunityRAF": 0.245,
        },
        "E75243": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Niemann-Pick disease type D",
            "CommunityRAF": 0.245,
        },
        "E75248": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other Niemann-Pick disease",
            "CommunityRAF": 0.245,
        },
        "E75249": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Niemann-Pick disease, unspecified",
            "CommunityRAF": 0.245,
        },
        "E753": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Sphingolipidosis, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7601": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hurler's syndrome",
            "CommunityRAF": 0.245,
        },
        "E7602": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hurler-Scheie syndrome",
            "CommunityRAF": 0.245,
        },
        "E7603": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Scheie's syndrome",
            "CommunityRAF": 0.245,
        },
        "E761": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Mucopolysaccharidosis, type II",
            "CommunityRAF": 0.245,
        },
        "E76210": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Morquio A mucopolysaccharidoses",
            "CommunityRAF": 0.245,
        },
        "E76211": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Morquio B mucopolysaccharidoses",
            "CommunityRAF": 0.245,
        },
        "E76219": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Morquio mucopolysaccharidoses, unspecified",
            "CommunityRAF": 0.245,
        },
        "E7622": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Sanfilippo mucopolysaccharidoses",
            "CommunityRAF": 0.245,
        },
        "E7629": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other mucopolysaccharidoses",
            "CommunityRAF": 0.245,
        },
        "E763": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Mucopolysaccharidosis, unspecified",
            "CommunityRAF": 0.245,
        },
        "E768": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of glucosaminoglycan metabolism",
            "CommunityRAF": 0.245,
        },
        "E769": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Glucosaminoglycan metabolism disorder, unspecified",
            "CommunityRAF": 0.245,
        },
        "E770": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Defects in post-translational modification of lysosomal enzymes",
            "CommunityRAF": 0.245,
        },
        "E771": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Defects in glycoprotein degradation",
            "CommunityRAF": 0.245,
        },
        "E778": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of glycoprotein metabolism",
            "CommunityRAF": 0.245,
        },
        "E779": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of glycoprotein metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E791": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Lesch-Nyhan syndrome",
            "CommunityRAF": 0.245,
        },
        "E792": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Myoadenylate deaminase deficiency",
            "CommunityRAF": 0.245,
        },
        "E798": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other disorders of purine and pyrimidine metabolism",
            "CommunityRAF": 0.245,
        },
        "E799": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Disorder of purine and pyrimidine metabolism, unspecified",
            "CommunityRAF": 0.245,
        },
        "E800": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hereditary erythropoietic porphyria",
            "CommunityRAF": 0.245,
        },
        "E801": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Porphyria cutanea tarda",
            "CommunityRAF": 0.245,
        },
        "E8020": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Unspecified porphyria",
            "CommunityRAF": 0.245,
        },
        "E8021": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Acute intermittent (hepatic) porphyria",
            "CommunityRAF": 0.245,
        },
        "E8029": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other porphyria",
            "CommunityRAF": 0.245,
        },
        "E803": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Defects of catalase and peroxidase",
            "CommunityRAF": 0.245,
        },
        "E83110": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Hereditary hemochromatosis",
            "CommunityRAF": 0.245,
        },
        "E850": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Non-neuropathic heredofamilial amyloidosis",
            "CommunityRAF": 0.245,
        },
        "E851": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Neuropathic heredofamilial amyloidosis",
            "CommunityRAF": 0.245,
        },
        "E852": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Heredofamilial amyloidosis, unspecified",
            "CommunityRAF": 0.245,
        },
        "E853": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Secondary systemic amyloidosis",
            "CommunityRAF": 0.245,
        },
        "E854": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Organ-limited amyloidosis",
            "CommunityRAF": 0.245,
        },
        "E858": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other amyloidosis",
            "CommunityRAF": 0.245,
        },
        "E859": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Amyloidosis, unspecified",
            "CommunityRAF": 0.245,
        },
        "E8801": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Alpha-1-antitrypsin deficiency",
            "CommunityRAF": 0.245,
        },
        "E8840": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Mitochondrial metabolism disorder, unspecified",
            "CommunityRAF": 0.245,
        },
        "E8841": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "MELAS syndrome",
            "CommunityRAF": 0.245,
        },
        "E8842": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "MERRF syndrome",
            "CommunityRAF": 0.245,
        },
        "E8849": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other mitochondrial metabolism disorders",
            "CommunityRAF": 0.245,
        },
        "E8889": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Other specified metabolic disorders",
            "CommunityRAF": 0.245,
        },
        "E892": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Postprocedural hypoparathyroidism",
            "CommunityRAF": 0.245,
        },
        "E893": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Postprocedural hypopituitarism",
            "CommunityRAF": 0.245,
        },
        "E896": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Postprocedural adrenocortical (-medullary) hypofunction",
            "CommunityRAF": 0.245,
        },
        "H49811": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Kearns-Sayre syndrome, right eye",
            "CommunityRAF": 0.245,
        },
        "H49812": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Kearns-Sayre syndrome, left eye",
            "CommunityRAF": 0.245,
        },
        "H49813": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Kearns-Sayre syndrome, bilateral",
            "CommunityRAF": 0.245,
        },
        "H49819": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Kearns-Sayre syndrome, unspecified eye",
            "CommunityRAF": 0.245,
        },
        "N251": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Nephrogenic diabetes insipidus",
            "CommunityRAF": 0.245,
        },
        "N2581": {
            "HCC": "Other Significant Endocrine and Metabolic Disorders",
            "ICD10": "Secondary hyperparathyroidism of renal origin",
            "CommunityRAF": 0.245,
        },
        "I8500": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Esophageal varices without bleeding",
            "CommunityRAF": 0.923,
        },
        "I8501": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Esophageal varices with bleeding",
            "CommunityRAF": 0.923,
        },
        "I8510": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Secondary esophageal varices without bleeding",
            "CommunityRAF": 0.923,
        },
        "I8511": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Secondary esophageal varices with bleeding",
            "CommunityRAF": 0.923,
        },
        "K7041": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Alcoholic hepatic failure with coma",
            "CommunityRAF": 0.923,
        },
        "K7111": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Toxic liver disease with hepatic necrosis, with coma",
            "CommunityRAF": 0.923,
        },
        "K7201": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Acute and subacute hepatic failure with coma",
            "CommunityRAF": 0.923,
        },
        "K7210": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Chronic hepatic failure without coma",
            "CommunityRAF": 0.923,
        },
        "K7211": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Chronic hepatic failure with coma",
            "CommunityRAF": 0.923,
        },
        "K7290": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Hepatic failure, unspecified without coma",
            "CommunityRAF": 0.923,
        },
        "K7291": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Hepatic failure, unspecified with coma",
            "CommunityRAF": 0.923,
        },
        "K766": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Portal hypertension",
            "CommunityRAF": 0.923,
        },
        "K767": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Hepatorenal syndrome",
            "CommunityRAF": 0.923,
        },
        "K7681": {
            "HCC": "End-Stage Liver Disease",
            "ICD10": "Hepatopulmonary syndrome",
            "CommunityRAF": 0.923,
        },
        "K7030": {
            "HCC": "Cirrhosis of Liver",
            "ICD10": "Alcoholic cirrhosis of liver without ascites",
            "CommunityRAF": 0.399,
        },
        "K7031": {
            "HCC": "Cirrhosis of Liver",
            "ICD10": "Alcoholic cirrhosis of liver with ascites",
            "CommunityRAF": 0.399,
        },
        "K7040": {
            "HCC": "Cirrhosis of Liver",
            "ICD10": "Alcoholic hepatic failure without coma",
            "CommunityRAF": 0.399,
        },
        "K709": {
            "HCC": "Cirrhosis of Liver",
            "ICD10": "Alcoholic liver disease, unspecified",
            "CommunityRAF": 0.399,
        },
        "K743": {
            "HCC": "Cirrhosis of Liver",
            "ICD10": "Primary biliary cirrhosis",
            "CommunityRAF": 0.399,
        },
        "K744": {
            "HCC": "Cirrhosis of Liver",
            "ICD10": "Secondary biliary cirrhosis",
            "CommunityRAF": 0.399,
        },
        "K745": {
            "HCC": "Cirrhosis of Liver",
            "ICD10": "Biliary cirrhosis, unspecified",
            "CommunityRAF": 0.399,
        },
        "K7460": {
            "HCC": "Cirrhosis of Liver",
            "ICD10": "Unspecified cirrhosis of liver",
            "CommunityRAF": 0.399,
        },
        "K7469": {
            "HCC": "Cirrhosis of Liver",
            "ICD10": "Other cirrhosis of liver",
            "CommunityRAF": 0.399,
        },
        "B180": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Chronic viral hepatitis B with delta-agent",
            "CommunityRAF": 0.251,
        },
        "B181": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Chronic viral hepatitis B without delta-agent",
            "CommunityRAF": 0.251,
        },
        "B182": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Chronic viral hepatitis C",
            "CommunityRAF": 0.251,
        },
        "B188": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Other chronic viral hepatitis",
            "CommunityRAF": 0.251,
        },
        "B189": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Chronic viral hepatitis, unspecified",
            "CommunityRAF": 0.251,
        },
        "K730": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Chronic persistent hepatitis, not elsewhere classified",
            "CommunityRAF": 0.251,
        },
        "K731": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Chronic lobular hepatitis, not elsewhere classified",
            "CommunityRAF": 0.251,
        },
        "K732": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Chronic active hepatitis, not elsewhere classified",
            "CommunityRAF": 0.251,
        },
        "K738": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Other chronic hepatitis, not elsewhere classified",
            "CommunityRAF": 0.251,
        },
        "K739": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Chronic hepatitis, unspecified",
            "CommunityRAF": 0.251,
        },
        "K754": {
            "HCC": "Chronic Hepatitis",
            "ICD10": "Autoimmune hepatitis",
            "CommunityRAF": 0.251,
        },
        "A5485": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Gonococcal peritonitis",
            "CommunityRAF": 0.310,
        },
        "K251": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Acute gastric ulcer with perforation",
            "CommunityRAF": 0.310,
        },
        "K252": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Acute gastric ulcer with both hemorrhage and perforation",
            "CommunityRAF": 0.310,
        },
        "K255": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Chronic or unspecified gastric ulcer with perforation",
            "CommunityRAF": 0.310,
        },
        "K256": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Chronic or unspecified gastric ulcer with both hemorrhage and perforation",
            "CommunityRAF": 0.310,
        },
        "K261": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Acute duodenal ulcer with perforation",
            "CommunityRAF": 0.310,
        },
        "K262": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Acute duodenal ulcer with both hemorrhage and perforation",
            "CommunityRAF": 0.310,
        },
        "K265": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Chronic or unspecified duodenal ulcer with perforation",
            "CommunityRAF": 0.310,
        },
        "K266": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Chronic or unspecified duodenal ulcer with both hemorrhage and perforation",
            "CommunityRAF": 0.310,
        },
        "K271": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Acute peptic ulcer, site unspecified, with perforation",
            "CommunityRAF": 0.310,
        },
        "K272": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Acute peptic ulcer, site unspecified, with both hemorrhage and perforation",
            "CommunityRAF": 0.310,
        },
        "K275": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Chronic or unspecified peptic ulcer, site unspecified, with perforation",
            "CommunityRAF": 0.310,
        },
        "K276": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Chronic or unspecified peptic ulcer, site unspecified, with both hemorrhage and perforation",
            "CommunityRAF": 0.310,
        },
        "K281": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Acute gastrojejunal ulcer with perforation",
            "CommunityRAF": 0.310,
        },
        "K282": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Acute gastrojejunal ulcer with both hemorrhage and perforation",
            "CommunityRAF": 0.310,
        },
        "K285": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Chronic or unspecified gastrojejunal ulcer with perforation",
            "CommunityRAF": 0.310,
        },
        "K286": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Chronic or unspecified gastrojejunal ulcer with both hemorrhage and perforation",
            "CommunityRAF": 0.310,
        },
        "K50012": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Crohn's disease of small intestine with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K50112": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Crohn's disease of large intestine with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K50812": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Crohn's disease of both small and large intestine with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K50912": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Crohn's disease, unspecified, with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K51012": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Ulcerative (chronic) pancolitis with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K51212": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Ulcerative (chronic) proctitis with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K51312": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Ulcerative (chronic) rectosigmoiditis with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K51412": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Inflammatory polyps of colon with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K51512": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Left sided colitis with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K51812": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Other ulcerative colitis with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K51912": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Ulcerative colitis, unspecified with intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K560": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Paralytic ileus",
            "CommunityRAF": 0.310,
        },
        "K561": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Intussusception",
            "CommunityRAF": 0.310,
        },
        "K562": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Volvulus",
            "CommunityRAF": 0.310,
        },
        "K563": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Gallstone ileus",
            "CommunityRAF": 0.310,
        },
        "K5641": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Fecal impaction",
            "CommunityRAF": 0.310,
        },
        "K5649": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Other impaction of intestine",
            "CommunityRAF": 0.310,
        },
        "K565": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Intestinal adhesions [bands] with obstruction (postprocedural) (postinfection)",
            "CommunityRAF": 0.310,
        },
        "K5660": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Unspecified intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K5669": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Other intestinal obstruction",
            "CommunityRAF": 0.310,
        },
        "K567": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Ileus, unspecified",
            "CommunityRAF": 0.310,
        },
        "K5931": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Toxic megacolon",
            "CommunityRAF": 0.310,
        },
        "K631": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Perforation of intestine (nontraumatic)",
            "CommunityRAF": 0.310,
        },
        "K650": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Generalized (acute) peritonitis",
            "CommunityRAF": 0.310,
        },
        "K651": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Peritoneal abscess",
            "CommunityRAF": 0.310,
        },
        "K652": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Spontaneous bacterial peritonitis",
            "CommunityRAF": 0.310,
        },
        "K653": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Choleperitonitis",
            "CommunityRAF": 0.310,
        },
        "K654": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Sclerosing mesenteritis",
            "CommunityRAF": 0.310,
        },
        "K658": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Other peritonitis",
            "CommunityRAF": 0.310,
        },
        "K659": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Peritonitis, unspecified",
            "CommunityRAF": 0.310,
        },
        "K67": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Disorders of peritoneum in infectious diseases classified elsewhere",
            "CommunityRAF": 0.310,
        },
        "K6812": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Psoas muscle abscess",
            "CommunityRAF": 0.310,
        },
        "K6819": {
            "HCC": "Intestinal Obstruction/Perforation",
            "ICD10": "Other retroperitoneal abscess",
            "CommunityRAF": 0.310,
        },
        "K860": {
            "HCC": "Chronic Pancreatitis",
            "ICD10": "Alcohol-induced chronic pancreatitis",
            "CommunityRAF": 0.286,
        },
        "K861": {
            "HCC": "Chronic Pancreatitis",
            "ICD10": "Other chronic pancreatitis",
            "CommunityRAF": 0.286,
        },
        "K5000": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of small intestine without complications",
            "CommunityRAF": 0.302,
        },
        "K50011": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of small intestine with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K50013": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of small intestine with fistula",
            "CommunityRAF": 0.302,
        },
        "K50014": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of small intestine with abscess",
            "CommunityRAF": 0.302,
        },
        "K50018": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of small intestine with other complication",
            "CommunityRAF": 0.302,
        },
        "K50019": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of small intestine with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5010": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of large intestine without complications",
            "CommunityRAF": 0.302,
        },
        "K50111": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of large intestine with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K50113": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of large intestine with fistula",
            "CommunityRAF": 0.302,
        },
        "K50114": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of large intestine with abscess",
            "CommunityRAF": 0.302,
        },
        "K50118": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of large intestine with other complication",
            "CommunityRAF": 0.302,
        },
        "K50119": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of large intestine with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5080": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of both small and large intestine without complications",
            "CommunityRAF": 0.302,
        },
        "K50811": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of both small and large intestine with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K50813": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of both small and large intestine with fistula",
            "CommunityRAF": 0.302,
        },
        "K50814": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of both small and large intestine with abscess",
            "CommunityRAF": 0.302,
        },
        "K50818": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of both small and large intestine with other complication",
            "CommunityRAF": 0.302,
        },
        "K50819": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease of both small and large intestine with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5090": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease, unspecified, without complications",
            "CommunityRAF": 0.302,
        },
        "K50911": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease, unspecified, with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K50913": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease, unspecified, with fistula",
            "CommunityRAF": 0.302,
        },
        "K50914": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease, unspecified, with abscess",
            "CommunityRAF": 0.302,
        },
        "K50918": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease, unspecified, with other complication",
            "CommunityRAF": 0.302,
        },
        "K50919": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Crohn's disease, unspecified, with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5100": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) pancolitis without complications",
            "CommunityRAF": 0.302,
        },
        "K51011": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) pancolitis with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K51013": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) pancolitis with fistula",
            "CommunityRAF": 0.302,
        },
        "K51014": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) pancolitis with abscess",
            "CommunityRAF": 0.302,
        },
        "K51018": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) pancolitis with other complication",
            "CommunityRAF": 0.302,
        },
        "K51019": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) pancolitis with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5120": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) proctitis without complications",
            "CommunityRAF": 0.302,
        },
        "K51211": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) proctitis with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K51213": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) proctitis with fistula",
            "CommunityRAF": 0.302,
        },
        "K51214": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) proctitis with abscess",
            "CommunityRAF": 0.302,
        },
        "K51218": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) proctitis with other complication",
            "CommunityRAF": 0.302,
        },
        "K51219": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) proctitis with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5130": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) rectosigmoiditis without complications",
            "CommunityRAF": 0.302,
        },
        "K51311": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) rectosigmoiditis with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K51313": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) rectosigmoiditis with fistula",
            "CommunityRAF": 0.302,
        },
        "K51314": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) rectosigmoiditis with abscess",
            "CommunityRAF": 0.302,
        },
        "K51318": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) rectosigmoiditis with other complication",
            "CommunityRAF": 0.302,
        },
        "K51319": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative (chronic) rectosigmoiditis with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5140": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Inflammatory polyps of colon without complications",
            "CommunityRAF": 0.302,
        },
        "K51411": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Inflammatory polyps of colon with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K51413": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Inflammatory polyps of colon with fistula",
            "CommunityRAF": 0.302,
        },
        "K51414": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Inflammatory polyps of colon with abscess",
            "CommunityRAF": 0.302,
        },
        "K51418": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Inflammatory polyps of colon with other complication",
            "CommunityRAF": 0.302,
        },
        "K51419": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Inflammatory polyps of colon with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5150": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Left sided colitis without complications",
            "CommunityRAF": 0.302,
        },
        "K51511": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Left sided colitis with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K51513": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Left sided colitis with fistula",
            "CommunityRAF": 0.302,
        },
        "K51514": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Left sided colitis with abscess",
            "CommunityRAF": 0.302,
        },
        "K51518": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Left sided colitis with other complication",
            "CommunityRAF": 0.302,
        },
        "K51519": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Left sided colitis with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5180": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Other ulcerative colitis without complications",
            "CommunityRAF": 0.302,
        },
        "K51811": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Other ulcerative colitis with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K51813": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Other ulcerative colitis with fistula",
            "CommunityRAF": 0.302,
        },
        "K51814": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Other ulcerative colitis with abscess",
            "CommunityRAF": 0.302,
        },
        "K51818": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Other ulcerative colitis with other complication",
            "CommunityRAF": 0.302,
        },
        "K51819": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Other ulcerative colitis with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "K5190": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative colitis, unspecified, without complications",
            "CommunityRAF": 0.302,
        },
        "K51911": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative colitis, unspecified with rectal bleeding",
            "CommunityRAF": 0.302,
        },
        "K51913": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative colitis, unspecified with fistula",
            "CommunityRAF": 0.302,
        },
        "K51914": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative colitis, unspecified with abscess",
            "CommunityRAF": 0.302,
        },
        "K51918": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative colitis, unspecified with other complication",
            "CommunityRAF": 0.302,
        },
        "K51919": {
            "HCC": "Inflammatory Bowel Disease",
            "ICD10": "Ulcerative colitis, unspecified with unspecified complications",
            "CommunityRAF": 0.302,
        },
        "A0104": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Typhoid arthritis",
            "CommunityRAF": 0.498,
        },
        "A0105": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Typhoid osteomyelitis",
            "CommunityRAF": 0.498,
        },
        "A0223": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Salmonella arthritis",
            "CommunityRAF": 0.498,
        },
        "A0224": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Salmonella osteomyelitis",
            "CommunityRAF": 0.498,
        },
        "A3983": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Meningococcal arthritis",
            "CommunityRAF": 0.498,
        },
        "A3984": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postmeningococcal arthritis",
            "CommunityRAF": 0.498,
        },
        "A5055": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Late congenital syphilitic arthropathy",
            "CommunityRAF": 0.498,
        },
        "A5440": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Gonococcal infection of musculoskeletal system, unspecified",
            "CommunityRAF": 0.498,
        },
        "A5441": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Gonococcal spondylopathy",
            "CommunityRAF": 0.498,
        },
        "A5442": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Gonococcal arthritis",
            "CommunityRAF": 0.498,
        },
        "A5443": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Gonococcal osteomyelitis",
            "CommunityRAF": 0.498,
        },
        "A5449": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Gonococcal infection of other musculoskeletal tissue",
            "CommunityRAF": 0.498,
        },
        "A666": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Bone and joint lesions of yaws",
            "CommunityRAF": 0.498,
        },
        "A6923": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to Lyme disease",
            "CommunityRAF": 0.498,
        },
        "B0682": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Rubella arthritis",
            "CommunityRAF": 0.498,
        },
        "B2685": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Mumps arthritis",
            "CommunityRAF": 0.498,
        },
        "B4282": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Sporotrichosis arthritis",
            "CommunityRAF": 0.498,
        },
        "M0000": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, unspecified joint",
            "CommunityRAF": 0.498,
        },
        "M00011": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M00012": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M00019": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M00021": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, right elbow",
            "CommunityRAF": 0.498,
        },
        "M00022": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, left elbow",
            "CommunityRAF": 0.498,
        },
        "M00029": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, unspecified elbow",
            "CommunityRAF": 0.498,
        },
        "M00031": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, right wrist",
            "CommunityRAF": 0.498,
        },
        "M00032": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, left wrist",
            "CommunityRAF": 0.498,
        },
        "M00039": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, unspecified wrist",
            "CommunityRAF": 0.498,
        },
        "M00041": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, right hand",
            "CommunityRAF": 0.498,
        },
        "M00042": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, left hand",
            "CommunityRAF": 0.498,
        },
        "M00049": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M00051": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, right hip",
            "CommunityRAF": 0.498,
        },
        "M00052": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, left hip",
            "CommunityRAF": 0.498,
        },
        "M00059": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, unspecified hip",
            "CommunityRAF": 0.498,
        },
        "M00061": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, right knee",
            "CommunityRAF": 0.498,
        },
        "M00062": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, left knee",
            "CommunityRAF": 0.498,
        },
        "M00069": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, unspecified knee",
            "CommunityRAF": 0.498,
        },
        "M00071": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M00072": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M00079": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M0008": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal arthritis, vertebrae",
            "CommunityRAF": 0.498,
        },
        "M0009": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Staphylococcal polyarthritis",
            "CommunityRAF": 0.498,
        },
        "M0010": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, unspecified joint",
            "CommunityRAF": 0.498,
        },
        "M00111": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M00112": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M00119": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M00121": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, right elbow",
            "CommunityRAF": 0.498,
        },
        "M00122": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, left elbow",
            "CommunityRAF": 0.498,
        },
        "M00129": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, unspecified elbow",
            "CommunityRAF": 0.498,
        },
        "M00131": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, right wrist",
            "CommunityRAF": 0.498,
        },
        "M00132": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, left wrist",
            "CommunityRAF": 0.498,
        },
        "M00139": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, unspecified wrist",
            "CommunityRAF": 0.498,
        },
        "M00141": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, right hand",
            "CommunityRAF": 0.498,
        },
        "M00142": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, left hand",
            "CommunityRAF": 0.498,
        },
        "M00149": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M00151": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, right hip",
            "CommunityRAF": 0.498,
        },
        "M00152": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, left hip",
            "CommunityRAF": 0.498,
        },
        "M00159": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, unspecified hip",
            "CommunityRAF": 0.498,
        },
        "M00161": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, right knee",
            "CommunityRAF": 0.498,
        },
        "M00162": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, left knee",
            "CommunityRAF": 0.498,
        },
        "M00169": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, unspecified knee",
            "CommunityRAF": 0.498,
        },
        "M00171": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M00172": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M00179": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M0018": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal arthritis, vertebrae",
            "CommunityRAF": 0.498,
        },
        "M0019": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pneumococcal polyarthritis",
            "CommunityRAF": 0.498,
        },
        "M0020": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, unspecified joint",
            "CommunityRAF": 0.498,
        },
        "M00211": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M00212": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M00219": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M00221": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, right elbow",
            "CommunityRAF": 0.498,
        },
        "M00222": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, left elbow",
            "CommunityRAF": 0.498,
        },
        "M00229": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, unspecified elbow",
            "CommunityRAF": 0.498,
        },
        "M00231": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, right wrist",
            "CommunityRAF": 0.498,
        },
        "M00232": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, left wrist",
            "CommunityRAF": 0.498,
        },
        "M00239": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, unspecified wrist",
            "CommunityRAF": 0.498,
        },
        "M00241": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, right hand",
            "CommunityRAF": 0.498,
        },
        "M00242": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, left hand",
            "CommunityRAF": 0.498,
        },
        "M00249": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M00251": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, right hip",
            "CommunityRAF": 0.498,
        },
        "M00252": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, left hip",
            "CommunityRAF": 0.498,
        },
        "M00259": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, unspecified hip",
            "CommunityRAF": 0.498,
        },
        "M00261": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, right knee",
            "CommunityRAF": 0.498,
        },
        "M00262": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, left knee",
            "CommunityRAF": 0.498,
        },
        "M00269": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, unspecified knee",
            "CommunityRAF": 0.498,
        },
        "M00271": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M00272": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M00279": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M0028": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal arthritis, vertebrae",
            "CommunityRAF": 0.498,
        },
        "M0029": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other streptococcal polyarthritis",
            "CommunityRAF": 0.498,
        },
        "M0080": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, unspecified joint",
            "CommunityRAF": 0.498,
        },
        "M00811": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M00812": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M00819": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M00821": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, right elbow",
            "CommunityRAF": 0.498,
        },
        "M00822": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, left elbow",
            "CommunityRAF": 0.498,
        },
        "M00829": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, unspecified elbow",
            "CommunityRAF": 0.498,
        },
        "M00831": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, right wrist",
            "CommunityRAF": 0.498,
        },
        "M00832": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, left wrist",
            "CommunityRAF": 0.498,
        },
        "M00839": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, unspecified wrist",
            "CommunityRAF": 0.498,
        },
        "M00841": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, right hand",
            "CommunityRAF": 0.498,
        },
        "M00842": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, left hand",
            "CommunityRAF": 0.498,
        },
        "M00849": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M00851": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, right hip",
            "CommunityRAF": 0.498,
        },
        "M00852": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, left hip",
            "CommunityRAF": 0.498,
        },
        "M00859": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, unspecified hip",
            "CommunityRAF": 0.498,
        },
        "M00861": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, right knee",
            "CommunityRAF": 0.498,
        },
        "M00862": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, left knee",
            "CommunityRAF": 0.498,
        },
        "M00869": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, unspecified knee",
            "CommunityRAF": 0.498,
        },
        "M00871": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M00872": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M00879": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M0088": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Arthritis due to other bacteria, vertebrae",
            "CommunityRAF": 0.498,
        },
        "M0089": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Polyarthritis due to other bacteria",
            "CommunityRAF": 0.498,
        },
        "M009": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Pyogenic arthritis, unspecified",
            "CommunityRAF": 0.498,
        },
        "M01X0": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of unspecified joint in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X11": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of right shoulder in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X12": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of left shoulder in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X19": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of unspecified shoulder in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X21": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of right elbow in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X22": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of left elbow in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X29": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of unspecified elbow in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X31": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of right wrist in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X32": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of left wrist in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X39": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of unspecified wrist in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X41": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of right hand in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X42": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of left hand in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X49": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of unspecified hand in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X51": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of right hip in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X52": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of left hip in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X59": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of unspecified hip in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X61": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of right knee in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X62": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of left knee in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X69": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of unspecified knee in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X71": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of right ankle and foot in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X72": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of left ankle and foot in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X79": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of unspecified ankle and foot in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X8": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of vertebrae in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M01X9": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Direct infection of multiple joints in infectious and parasitic diseases classified elsewhere",
            "CommunityRAF": 0.498,
        },
        "M0210": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M02111": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M02112": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M02119": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M02121": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, right elbow",
            "CommunityRAF": 0.498,
        },
        "M02122": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, left elbow",
            "CommunityRAF": 0.498,
        },
        "M02129": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, unspecified elbow",
            "CommunityRAF": 0.498,
        },
        "M02131": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, right wrist",
            "CommunityRAF": 0.498,
        },
        "M02132": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, left wrist",
            "CommunityRAF": 0.498,
        },
        "M02139": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, unspecified wrist",
            "CommunityRAF": 0.498,
        },
        "M02141": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, right hand",
            "CommunityRAF": 0.498,
        },
        "M02142": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, left hand",
            "CommunityRAF": 0.498,
        },
        "M02149": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M02151": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, right hip",
            "CommunityRAF": 0.498,
        },
        "M02152": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, left hip",
            "CommunityRAF": 0.498,
        },
        "M02159": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, unspecified hip",
            "CommunityRAF": 0.498,
        },
        "M02161": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, right knee",
            "CommunityRAF": 0.498,
        },
        "M02162": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, left knee",
            "CommunityRAF": 0.498,
        },
        "M02169": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, unspecified knee",
            "CommunityRAF": 0.498,
        },
        "M02171": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M02172": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M02179": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M0218": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, vertebrae",
            "CommunityRAF": 0.498,
        },
        "M0219": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Postdysenteric arthropathy, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M0280": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M02811": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M02812": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M02819": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M02821": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, right elbow",
            "CommunityRAF": 0.498,
        },
        "M02822": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, left elbow",
            "CommunityRAF": 0.498,
        },
        "M02829": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, unspecified elbow",
            "CommunityRAF": 0.498,
        },
        "M02831": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, right wrist",
            "CommunityRAF": 0.498,
        },
        "M02832": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, left wrist",
            "CommunityRAF": 0.498,
        },
        "M02839": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, unspecified wrist",
            "CommunityRAF": 0.498,
        },
        "M02841": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, right hand",
            "CommunityRAF": 0.498,
        },
        "M02842": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, left hand",
            "CommunityRAF": 0.498,
        },
        "M02849": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M02851": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, right hip",
            "CommunityRAF": 0.498,
        },
        "M02852": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, left hip",
            "CommunityRAF": 0.498,
        },
        "M02859": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, unspecified hip",
            "CommunityRAF": 0.498,
        },
        "M02861": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, right knee",
            "CommunityRAF": 0.498,
        },
        "M02862": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, left knee",
            "CommunityRAF": 0.498,
        },
        "M02869": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, unspecified knee",
            "CommunityRAF": 0.498,
        },
        "M02871": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M02872": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M02879": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M0288": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, vertebrae",
            "CommunityRAF": 0.498,
        },
        "M0289": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other reactive arthropathies, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M029": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Reactive arthropathy, unspecified",
            "CommunityRAF": 0.498,
        },
        "M4620": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis of vertebra, site unspecified",
            "CommunityRAF": 0.498,
        },
        "M4621": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis of vertebra, occipito-atlanto-axial region",
            "CommunityRAF": 0.498,
        },
        "M4622": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis of vertebra, cervical region",
            "CommunityRAF": 0.498,
        },
        "M4623": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis of vertebra, cervicothoracic region",
            "CommunityRAF": 0.498,
        },
        "M4624": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis of vertebra, thoracic region",
            "CommunityRAF": 0.498,
        },
        "M4625": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis of vertebra, thoracolumbar region",
            "CommunityRAF": 0.498,
        },
        "M4626": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis of vertebra, lumbar region",
            "CommunityRAF": 0.498,
        },
        "M4627": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis of vertebra, lumbosacral region",
            "CommunityRAF": 0.498,
        },
        "M4628": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis of vertebra, sacral and sacrococcygeal region",
            "CommunityRAF": 0.498,
        },
        "M4630": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), site unspecified",
            "CommunityRAF": 0.498,
        },
        "M4631": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), occipito-atlanto-axial region",
            "CommunityRAF": 0.498,
        },
        "M4632": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), cervical region",
            "CommunityRAF": 0.498,
        },
        "M4633": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), cervicothoracic region",
            "CommunityRAF": 0.498,
        },
        "M4634": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), thoracic region",
            "CommunityRAF": 0.498,
        },
        "M4635": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), thoracolumbar region",
            "CommunityRAF": 0.498,
        },
        "M4636": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), lumbar region",
            "CommunityRAF": 0.498,
        },
        "M4637": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), lumbosacral region",
            "CommunityRAF": 0.498,
        },
        "M4638": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), sacral and sacrococcygeal region",
            "CommunityRAF": 0.498,
        },
        "M4639": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Infection of intervertebral disc (pyogenic), multiple sites in spine",
            "CommunityRAF": 0.498,
        },
        "M726": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Necrotizing fasciitis",
            "CommunityRAF": 0.498,
        },
        "M8600": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M86011": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M86012": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M86019": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M86021": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, right humerus",
            "CommunityRAF": 0.498,
        },
        "M86022": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, left humerus",
            "CommunityRAF": 0.498,
        },
        "M86029": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M86031": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, right radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86032": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, left radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86039": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, unspecified radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86041": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, right hand",
            "CommunityRAF": 0.498,
        },
        "M86042": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, left hand",
            "CommunityRAF": 0.498,
        },
        "M86049": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M86051": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, right femur",
            "CommunityRAF": 0.498,
        },
        "M86052": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, left femur",
            "CommunityRAF": 0.498,
        },
        "M86059": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M86061": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, right tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86062": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, left tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86069": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, unspecified tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86071": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86072": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86079": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M8608": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, other sites",
            "CommunityRAF": 0.498,
        },
        "M8609": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Acute hematogenous osteomyelitis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8610": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M86111": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M86112": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M86119": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M86121": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, right humerus",
            "CommunityRAF": 0.498,
        },
        "M86122": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, left humerus",
            "CommunityRAF": 0.498,
        },
        "M86129": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M86131": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, right radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86132": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, left radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86139": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, unspecified radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86141": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, right hand",
            "CommunityRAF": 0.498,
        },
        "M86142": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, left hand",
            "CommunityRAF": 0.498,
        },
        "M86149": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M86151": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, right femur",
            "CommunityRAF": 0.498,
        },
        "M86152": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, left femur",
            "CommunityRAF": 0.498,
        },
        "M86159": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M86161": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, right tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86162": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, left tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86169": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, unspecified tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86171": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86172": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86179": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M8618": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, other site",
            "CommunityRAF": 0.498,
        },
        "M8619": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other acute osteomyelitis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8620": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M86211": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M86212": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M86219": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M86221": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, right humerus",
            "CommunityRAF": 0.498,
        },
        "M86222": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, left humerus",
            "CommunityRAF": 0.498,
        },
        "M86229": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M86231": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, right radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86232": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, left radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86239": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, unspecified radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86241": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, right hand",
            "CommunityRAF": 0.498,
        },
        "M86242": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, left hand",
            "CommunityRAF": 0.498,
        },
        "M86249": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M86251": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, right femur",
            "CommunityRAF": 0.498,
        },
        "M86252": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, left femur",
            "CommunityRAF": 0.498,
        },
        "M86259": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M86261": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, right tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86262": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, left tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86269": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, unspecified tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86271": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86272": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86279": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M8628": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, other site",
            "CommunityRAF": 0.498,
        },
        "M8629": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Subacute osteomyelitis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8630": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M86311": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M86312": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M86319": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M86321": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, right humerus",
            "CommunityRAF": 0.498,
        },
        "M86322": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, left humerus",
            "CommunityRAF": 0.498,
        },
        "M86329": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M86331": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, right radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86332": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, left radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86339": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, unspecified radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86341": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, right hand",
            "CommunityRAF": 0.498,
        },
        "M86342": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, left hand",
            "CommunityRAF": 0.498,
        },
        "M86349": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M86351": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, right femur",
            "CommunityRAF": 0.498,
        },
        "M86352": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, left femur",
            "CommunityRAF": 0.498,
        },
        "M86359": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M86361": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, right tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86362": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, left tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86369": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, unspecified tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86371": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86372": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86379": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M8638": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, other site",
            "CommunityRAF": 0.498,
        },
        "M8639": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic multifocal osteomyelitis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8640": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M86411": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M86412": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M86419": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M86421": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, right humerus",
            "CommunityRAF": 0.498,
        },
        "M86422": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, left humerus",
            "CommunityRAF": 0.498,
        },
        "M86429": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M86431": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, right radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86432": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, left radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86439": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, unspecified radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86441": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, right hand",
            "CommunityRAF": 0.498,
        },
        "M86442": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, left hand",
            "CommunityRAF": 0.498,
        },
        "M86449": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M86451": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, right femur",
            "CommunityRAF": 0.498,
        },
        "M86452": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, left femur",
            "CommunityRAF": 0.498,
        },
        "M86459": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M86461": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, right tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86462": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, left tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86469": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, unspecified tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86471": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86472": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86479": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M8648": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, other site",
            "CommunityRAF": 0.498,
        },
        "M8649": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Chronic osteomyelitis with draining sinus, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8650": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M86511": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M86512": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M86519": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M86521": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, right humerus",
            "CommunityRAF": 0.498,
        },
        "M86522": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, left humerus",
            "CommunityRAF": 0.498,
        },
        "M86529": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M86531": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, right radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86532": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, left radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86539": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, unspecified radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86541": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, right hand",
            "CommunityRAF": 0.498,
        },
        "M86542": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, left hand",
            "CommunityRAF": 0.498,
        },
        "M86549": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M86551": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, right femur",
            "CommunityRAF": 0.498,
        },
        "M86552": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, left femur",
            "CommunityRAF": 0.498,
        },
        "M86559": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M86561": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, right tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86562": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, left tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86569": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, unspecified tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86571": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86572": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86579": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M8658": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, other site",
            "CommunityRAF": 0.498,
        },
        "M8659": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic hematogenous osteomyelitis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8660": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M86611": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M86612": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M86619": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M86621": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, right humerus",
            "CommunityRAF": 0.498,
        },
        "M86622": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, left humerus",
            "CommunityRAF": 0.498,
        },
        "M86629": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M86631": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, right radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86632": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, left radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86639": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, unspecified radius and ulna",
            "CommunityRAF": 0.498,
        },
        "M86641": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, right hand",
            "CommunityRAF": 0.498,
        },
        "M86642": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, left hand",
            "CommunityRAF": 0.498,
        },
        "M86649": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M86651": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, right thigh",
            "CommunityRAF": 0.498,
        },
        "M86652": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, left thigh",
            "CommunityRAF": 0.498,
        },
        "M86659": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, unspecified thigh",
            "CommunityRAF": 0.498,
        },
        "M86661": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, right tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86662": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, left tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86669": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, unspecified tibia and fibula",
            "CommunityRAF": 0.498,
        },
        "M86671": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86672": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M86679": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M8668": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, other site",
            "CommunityRAF": 0.498,
        },
        "M8669": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other chronic osteomyelitis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M868X0": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M868X1": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, shoulder",
            "CommunityRAF": 0.498,
        },
        "M868X2": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, upper arm",
            "CommunityRAF": 0.498,
        },
        "M868X3": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, forearm",
            "CommunityRAF": 0.498,
        },
        "M868X4": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, hand",
            "CommunityRAF": 0.498,
        },
        "M868X5": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, thigh",
            "CommunityRAF": 0.498,
        },
        "M868X6": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, lower leg",
            "CommunityRAF": 0.498,
        },
        "M868X7": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M868X8": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, other site",
            "CommunityRAF": 0.498,
        },
        "M868X9": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteomyelitis, unspecified sites",
            "CommunityRAF": 0.498,
        },
        "M869": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteomyelitis, unspecified",
            "CommunityRAF": 0.498,
        },
        "M8700": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified bone",
            "CommunityRAF": 0.498,
        },
        "M87011": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right shoulder",
            "CommunityRAF": 0.498,
        },
        "M87012": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left shoulder",
            "CommunityRAF": 0.498,
        },
        "M87019": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M87021": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right humerus",
            "CommunityRAF": 0.498,
        },
        "M87022": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left humerus",
            "CommunityRAF": 0.498,
        },
        "M87029": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M87031": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right radius",
            "CommunityRAF": 0.498,
        },
        "M87032": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left radius",
            "CommunityRAF": 0.498,
        },
        "M87033": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified radius",
            "CommunityRAF": 0.498,
        },
        "M87034": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right ulna",
            "CommunityRAF": 0.498,
        },
        "M87035": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left ulna",
            "CommunityRAF": 0.498,
        },
        "M87036": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified ulna",
            "CommunityRAF": 0.498,
        },
        "M87037": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right carpus",
            "CommunityRAF": 0.498,
        },
        "M87038": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left carpus",
            "CommunityRAF": 0.498,
        },
        "M87039": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified carpus",
            "CommunityRAF": 0.498,
        },
        "M87041": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right hand",
            "CommunityRAF": 0.498,
        },
        "M87042": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left hand",
            "CommunityRAF": 0.498,
        },
        "M87043": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M87044": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87045": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87046": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87050": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of pelvis",
            "CommunityRAF": 0.498,
        },
        "M87051": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right femur",
            "CommunityRAF": 0.498,
        },
        "M87052": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left femur",
            "CommunityRAF": 0.498,
        },
        "M87059": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M87061": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right tibia",
            "CommunityRAF": 0.498,
        },
        "M87062": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left tibia",
            "CommunityRAF": 0.498,
        },
        "M87063": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified tibia",
            "CommunityRAF": 0.498,
        },
        "M87064": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right fibula",
            "CommunityRAF": 0.498,
        },
        "M87065": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left fibula",
            "CommunityRAF": 0.498,
        },
        "M87066": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified fibula",
            "CommunityRAF": 0.498,
        },
        "M87071": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right ankle",
            "CommunityRAF": 0.498,
        },
        "M87072": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left ankle",
            "CommunityRAF": 0.498,
        },
        "M87073": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified ankle",
            "CommunityRAF": 0.498,
        },
        "M87074": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right foot",
            "CommunityRAF": 0.498,
        },
        "M87075": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left foot",
            "CommunityRAF": 0.498,
        },
        "M87076": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified foot",
            "CommunityRAF": 0.498,
        },
        "M87077": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of right toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87078": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of left toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87079": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of unspecified toe(s)",
            "CommunityRAF": 0.498,
        },
        "M8708": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of bone, other site",
            "CommunityRAF": 0.498,
        },
        "M8709": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Idiopathic aseptic necrosis of bone, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8710": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified bone",
            "CommunityRAF": 0.498,
        },
        "M87111": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M87112": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M87119": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M87121": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right humerus",
            "CommunityRAF": 0.498,
        },
        "M87122": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left humerus",
            "CommunityRAF": 0.498,
        },
        "M87129": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M87131": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs of right radius",
            "CommunityRAF": 0.498,
        },
        "M87132": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs of left radius",
            "CommunityRAF": 0.498,
        },
        "M87133": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs of unspecified radius",
            "CommunityRAF": 0.498,
        },
        "M87134": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs of right ulna",
            "CommunityRAF": 0.498,
        },
        "M87135": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs of left ulna",
            "CommunityRAF": 0.498,
        },
        "M87136": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs of unspecified ulna",
            "CommunityRAF": 0.498,
        },
        "M87137": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs of right carpus",
            "CommunityRAF": 0.498,
        },
        "M87138": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs of left carpus",
            "CommunityRAF": 0.498,
        },
        "M87139": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs of unspecified carpus",
            "CommunityRAF": 0.498,
        },
        "M87141": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right hand",
            "CommunityRAF": 0.498,
        },
        "M87142": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left hand",
            "CommunityRAF": 0.498,
        },
        "M87143": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M87144": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87145": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87146": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87150": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, pelvis",
            "CommunityRAF": 0.498,
        },
        "M87151": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right femur",
            "CommunityRAF": 0.498,
        },
        "M87152": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left femur",
            "CommunityRAF": 0.498,
        },
        "M87159": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M87161": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right tibia",
            "CommunityRAF": 0.498,
        },
        "M87162": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left tibia",
            "CommunityRAF": 0.498,
        },
        "M87163": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified tibia",
            "CommunityRAF": 0.498,
        },
        "M87164": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right fibula",
            "CommunityRAF": 0.498,
        },
        "M87165": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left fibula",
            "CommunityRAF": 0.498,
        },
        "M87166": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified fibula",
            "CommunityRAF": 0.498,
        },
        "M87171": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right ankle",
            "CommunityRAF": 0.498,
        },
        "M87172": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left ankle",
            "CommunityRAF": 0.498,
        },
        "M87173": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified ankle",
            "CommunityRAF": 0.498,
        },
        "M87174": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right foot",
            "CommunityRAF": 0.498,
        },
        "M87175": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left foot",
            "CommunityRAF": 0.498,
        },
        "M87176": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified foot",
            "CommunityRAF": 0.498,
        },
        "M87177": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, right toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87178": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, left toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87179": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, unspecified toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87180": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, jaw",
            "CommunityRAF": 0.498,
        },
        "M87188": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, other site",
            "CommunityRAF": 0.498,
        },
        "M8719": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to drugs, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8720": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified bone",
            "CommunityRAF": 0.498,
        },
        "M87211": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M87212": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M87219": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M87221": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right humerus",
            "CommunityRAF": 0.498,
        },
        "M87222": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left humerus",
            "CommunityRAF": 0.498,
        },
        "M87229": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M87231": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma of right radius",
            "CommunityRAF": 0.498,
        },
        "M87232": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma of left radius",
            "CommunityRAF": 0.498,
        },
        "M87233": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma of unspecified radius",
            "CommunityRAF": 0.498,
        },
        "M87234": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma of right ulna",
            "CommunityRAF": 0.498,
        },
        "M87235": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma of left ulna",
            "CommunityRAF": 0.498,
        },
        "M87236": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma of unspecified ulna",
            "CommunityRAF": 0.498,
        },
        "M87237": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma of right carpus",
            "CommunityRAF": 0.498,
        },
        "M87238": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma of left carpus",
            "CommunityRAF": 0.498,
        },
        "M87239": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma of unspecified carpus",
            "CommunityRAF": 0.498,
        },
        "M87241": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right hand",
            "CommunityRAF": 0.498,
        },
        "M87242": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left hand",
            "CommunityRAF": 0.498,
        },
        "M87243": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M87244": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87245": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87246": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87250": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, pelvis",
            "CommunityRAF": 0.498,
        },
        "M87251": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right femur",
            "CommunityRAF": 0.498,
        },
        "M87252": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left femur",
            "CommunityRAF": 0.498,
        },
        "M87256": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M87261": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right tibia",
            "CommunityRAF": 0.498,
        },
        "M87262": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left tibia",
            "CommunityRAF": 0.498,
        },
        "M87263": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified tibia",
            "CommunityRAF": 0.498,
        },
        "M87264": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right fibula",
            "CommunityRAF": 0.498,
        },
        "M87265": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left fibula",
            "CommunityRAF": 0.498,
        },
        "M87266": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified fibula",
            "CommunityRAF": 0.498,
        },
        "M87271": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right ankle",
            "CommunityRAF": 0.498,
        },
        "M87272": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left ankle",
            "CommunityRAF": 0.498,
        },
        "M87273": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified ankle",
            "CommunityRAF": 0.498,
        },
        "M87274": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right foot",
            "CommunityRAF": 0.498,
        },
        "M87275": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left foot",
            "CommunityRAF": 0.498,
        },
        "M87276": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified foot",
            "CommunityRAF": 0.498,
        },
        "M87277": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, right toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87278": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, left toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87279": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, unspecified toe(s)",
            "CommunityRAF": 0.498,
        },
        "M8728": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, other site",
            "CommunityRAF": 0.498,
        },
        "M8729": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis due to previous trauma, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8730": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified bone",
            "CommunityRAF": 0.498,
        },
        "M87311": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M87312": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M87319": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M87321": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right humerus",
            "CommunityRAF": 0.498,
        },
        "M87322": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left humerus",
            "CommunityRAF": 0.498,
        },
        "M87329": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M87331": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis of right radius",
            "CommunityRAF": 0.498,
        },
        "M87332": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis of left radius",
            "CommunityRAF": 0.498,
        },
        "M87333": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis of unspecified radius",
            "CommunityRAF": 0.498,
        },
        "M87334": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis of right ulna",
            "CommunityRAF": 0.498,
        },
        "M87335": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis of left ulna",
            "CommunityRAF": 0.498,
        },
        "M87336": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis of unspecified ulna",
            "CommunityRAF": 0.498,
        },
        "M87337": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis of right carpus",
            "CommunityRAF": 0.498,
        },
        "M87338": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis of left carpus",
            "CommunityRAF": 0.498,
        },
        "M87339": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis of unspecified carpus",
            "CommunityRAF": 0.498,
        },
        "M87341": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right hand",
            "CommunityRAF": 0.498,
        },
        "M87342": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left hand",
            "CommunityRAF": 0.498,
        },
        "M87343": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M87344": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87345": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87346": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87350": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, pelvis",
            "CommunityRAF": 0.498,
        },
        "M87351": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right femur",
            "CommunityRAF": 0.498,
        },
        "M87352": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left femur",
            "CommunityRAF": 0.498,
        },
        "M87353": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M87361": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right tibia",
            "CommunityRAF": 0.498,
        },
        "M87362": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left tibia",
            "CommunityRAF": 0.498,
        },
        "M87363": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified tibia",
            "CommunityRAF": 0.498,
        },
        "M87364": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right fibula",
            "CommunityRAF": 0.498,
        },
        "M87365": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left fibula",
            "CommunityRAF": 0.498,
        },
        "M87366": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified fibula",
            "CommunityRAF": 0.498,
        },
        "M87371": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right ankle",
            "CommunityRAF": 0.498,
        },
        "M87372": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left ankle",
            "CommunityRAF": 0.498,
        },
        "M87373": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified ankle",
            "CommunityRAF": 0.498,
        },
        "M87374": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right foot",
            "CommunityRAF": 0.498,
        },
        "M87375": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left foot",
            "CommunityRAF": 0.498,
        },
        "M87376": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified foot",
            "CommunityRAF": 0.498,
        },
        "M87377": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, right toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87378": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, left toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87379": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, unspecified toe(s)",
            "CommunityRAF": 0.498,
        },
        "M8738": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, other site",
            "CommunityRAF": 0.498,
        },
        "M8739": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other secondary osteonecrosis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M8780": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified bone",
            "CommunityRAF": 0.498,
        },
        "M87811": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M87812": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M87819": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M87821": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right humerus",
            "CommunityRAF": 0.498,
        },
        "M87822": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left humerus",
            "CommunityRAF": 0.498,
        },
        "M87829": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified humerus",
            "CommunityRAF": 0.498,
        },
        "M87831": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis of right radius",
            "CommunityRAF": 0.498,
        },
        "M87832": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis of left radius",
            "CommunityRAF": 0.498,
        },
        "M87833": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis of unspecified radius",
            "CommunityRAF": 0.498,
        },
        "M87834": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis of right ulna",
            "CommunityRAF": 0.498,
        },
        "M87835": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis of left ulna",
            "CommunityRAF": 0.498,
        },
        "M87836": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis of unspecified ulna",
            "CommunityRAF": 0.498,
        },
        "M87837": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis of right carpus",
            "CommunityRAF": 0.498,
        },
        "M87838": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis of left carpus",
            "CommunityRAF": 0.498,
        },
        "M87839": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis of unspecified carpus",
            "CommunityRAF": 0.498,
        },
        "M87841": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right hand",
            "CommunityRAF": 0.498,
        },
        "M87842": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left hand",
            "CommunityRAF": 0.498,
        },
        "M87843": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M87844": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87845": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87849": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified finger(s)",
            "CommunityRAF": 0.498,
        },
        "M87850": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, pelvis",
            "CommunityRAF": 0.498,
        },
        "M87851": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right femur",
            "CommunityRAF": 0.498,
        },
        "M87852": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left femur",
            "CommunityRAF": 0.498,
        },
        "M87859": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified femur",
            "CommunityRAF": 0.498,
        },
        "M87861": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right tibia",
            "CommunityRAF": 0.498,
        },
        "M87862": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left tibia",
            "CommunityRAF": 0.498,
        },
        "M87863": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified tibia",
            "CommunityRAF": 0.498,
        },
        "M87864": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right fibula",
            "CommunityRAF": 0.498,
        },
        "M87865": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left fibula",
            "CommunityRAF": 0.498,
        },
        "M87869": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified fibula",
            "CommunityRAF": 0.498,
        },
        "M87871": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right ankle",
            "CommunityRAF": 0.498,
        },
        "M87872": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left ankle",
            "CommunityRAF": 0.498,
        },
        "M87873": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified ankle",
            "CommunityRAF": 0.498,
        },
        "M87874": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right foot",
            "CommunityRAF": 0.498,
        },
        "M87875": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left foot",
            "CommunityRAF": 0.498,
        },
        "M87876": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified foot",
            "CommunityRAF": 0.498,
        },
        "M87877": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, right toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87878": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, left toe(s)",
            "CommunityRAF": 0.498,
        },
        "M87879": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, unspecified toe(s)",
            "CommunityRAF": 0.498,
        },
        "M8788": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, other site",
            "CommunityRAF": 0.498,
        },
        "M8789": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Other osteonecrosis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M879": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis, unspecified",
            "CommunityRAF": 0.498,
        },
        "M8960": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M89611": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M89612": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M89619": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M89621": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, right upper arm",
            "CommunityRAF": 0.498,
        },
        "M89622": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, left upper arm",
            "CommunityRAF": 0.498,
        },
        "M89629": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, unspecified upper arm",
            "CommunityRAF": 0.498,
        },
        "M89631": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, right forearm",
            "CommunityRAF": 0.498,
        },
        "M89632": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, left forearm",
            "CommunityRAF": 0.498,
        },
        "M89639": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, unspecified forearm",
            "CommunityRAF": 0.498,
        },
        "M89641": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, right hand",
            "CommunityRAF": 0.498,
        },
        "M89642": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, left hand",
            "CommunityRAF": 0.498,
        },
        "M89649": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M89651": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, right thigh",
            "CommunityRAF": 0.498,
        },
        "M89652": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, left thigh",
            "CommunityRAF": 0.498,
        },
        "M89659": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, unspecified thigh",
            "CommunityRAF": 0.498,
        },
        "M89661": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, right lower leg",
            "CommunityRAF": 0.498,
        },
        "M89662": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, left lower leg",
            "CommunityRAF": 0.498,
        },
        "M89669": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, unspecified lower leg",
            "CommunityRAF": 0.498,
        },
        "M89671": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M89672": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M89679": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M8968": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, other site",
            "CommunityRAF": 0.498,
        },
        "M8969": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteopathy after poliomyelitis, multiple sites",
            "CommunityRAF": 0.498,
        },
        "M9050": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, unspecified site",
            "CommunityRAF": 0.498,
        },
        "M90511": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, right shoulder",
            "CommunityRAF": 0.498,
        },
        "M90512": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, left shoulder",
            "CommunityRAF": 0.498,
        },
        "M90519": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, unspecified shoulder",
            "CommunityRAF": 0.498,
        },
        "M90521": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, right upper arm",
            "CommunityRAF": 0.498,
        },
        "M90522": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, left upper arm",
            "CommunityRAF": 0.498,
        },
        "M90529": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, unspecified upper arm",
            "CommunityRAF": 0.498,
        },
        "M90531": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, right forearm",
            "CommunityRAF": 0.498,
        },
        "M90532": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, left forearm",
            "CommunityRAF": 0.498,
        },
        "M90539": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, unspecified forearm",
            "CommunityRAF": 0.498,
        },
        "M90541": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, right hand",
            "CommunityRAF": 0.498,
        },
        "M90542": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, left hand",
            "CommunityRAF": 0.498,
        },
        "M90549": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, unspecified hand",
            "CommunityRAF": 0.498,
        },
        "M90551": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, right thigh",
            "CommunityRAF": 0.498,
        },
        "M90552": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, left thigh",
            "CommunityRAF": 0.498,
        },
        "M90559": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, unspecified thigh",
            "CommunityRAF": 0.498,
        },
        "M90561": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, right lower leg",
            "CommunityRAF": 0.498,
        },
        "M90562": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, left lower leg",
            "CommunityRAF": 0.498,
        },
        "M90569": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, unspecified lower leg",
            "CommunityRAF": 0.498,
        },
        "M90571": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, right ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M90572": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, left ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M90579": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, unspecified ankle and foot",
            "CommunityRAF": 0.498,
        },
        "M9058": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, other site",
            "CommunityRAF": 0.498,
        },
        "M9059": {
            "HCC": "Bone/Joint/Muscle Infections/Necrosis",
            "ICD10": "Osteonecrosis in diseases classified elsewhere, multiple sites",
            "CommunityRAF": 0.498,
        },
        "L4050": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Arthropathic psoriasis, unspecified",
            "CommunityRAF": 0.374,
        },
        "L4051": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Distal interphalangeal psoriatic arthropathy",
            "CommunityRAF": 0.374,
        },
        "L4052": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Psoriatic arthritis mutilans",
            "CommunityRAF": 0.374,
        },
        "L4053": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Psoriatic spondylitis",
            "CommunityRAF": 0.374,
        },
        "L4054": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Psoriatic juvenile arthropathy",
            "CommunityRAF": 0.374,
        },
        "L4059": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other psoriatic arthropathy",
            "CommunityRAF": 0.374,
        },
        "M0230": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M02311": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M02312": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M02319": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M02321": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, right elbow",
            "CommunityRAF": 0.374,
        },
        "M02322": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, left elbow",
            "CommunityRAF": 0.374,
        },
        "M02329": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M02331": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, right wrist",
            "CommunityRAF": 0.374,
        },
        "M02332": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, left wrist",
            "CommunityRAF": 0.374,
        },
        "M02339": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M02341": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, right hand",
            "CommunityRAF": 0.374,
        },
        "M02342": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, left hand",
            "CommunityRAF": 0.374,
        },
        "M02349": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M02351": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, right hip",
            "CommunityRAF": 0.374,
        },
        "M02352": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, left hip",
            "CommunityRAF": 0.374,
        },
        "M02359": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M02361": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, right knee",
            "CommunityRAF": 0.374,
        },
        "M02362": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, left knee",
            "CommunityRAF": 0.374,
        },
        "M02369": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M02371": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M02372": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M02379": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0238": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, vertebrae",
            "CommunityRAF": 0.374,
        },
        "M0239": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Reiter's disease, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M041": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Periodic fever syndromes",
            "CommunityRAF": 0.374,
        },
        "M042": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Cryopyrin-associated periodic syndromes",
            "CommunityRAF": 0.374,
        },
        "M048": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other autoinflammatory syndromes",
            "CommunityRAF": 0.374,
        },
        "M049": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Autoinflammatory syndrome, unspecified",
            "CommunityRAF": 0.374,
        },
        "M0500": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M05011": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M05012": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M05019": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M05021": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, right elbow",
            "CommunityRAF": 0.374,
        },
        "M05022": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, left elbow",
            "CommunityRAF": 0.374,
        },
        "M05029": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M05031": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, right wrist",
            "CommunityRAF": 0.374,
        },
        "M05032": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, left wrist",
            "CommunityRAF": 0.374,
        },
        "M05039": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M05041": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, right hand",
            "CommunityRAF": 0.374,
        },
        "M05042": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, left hand",
            "CommunityRAF": 0.374,
        },
        "M05049": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M05051": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, right hip",
            "CommunityRAF": 0.374,
        },
        "M05052": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, left hip",
            "CommunityRAF": 0.374,
        },
        "M05059": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M05061": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, right knee",
            "CommunityRAF": 0.374,
        },
        "M05062": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, left knee",
            "CommunityRAF": 0.374,
        },
        "M05069": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M05071": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05072": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05079": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0509": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Felty's syndrome, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M0510": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of unspecified site",
            "CommunityRAF": 0.374,
        },
        "M05111": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of right shoulder",
            "CommunityRAF": 0.374,
        },
        "M05112": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of left shoulder",
            "CommunityRAF": 0.374,
        },
        "M05119": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M05121": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of right elbow",
            "CommunityRAF": 0.374,
        },
        "M05122": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of left elbow",
            "CommunityRAF": 0.374,
        },
        "M05129": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M05131": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of right wrist",
            "CommunityRAF": 0.374,
        },
        "M05132": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of left wrist",
            "CommunityRAF": 0.374,
        },
        "M05139": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M05141": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of right hand",
            "CommunityRAF": 0.374,
        },
        "M05142": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of left hand",
            "CommunityRAF": 0.374,
        },
        "M05149": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M05151": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of right hip",
            "CommunityRAF": 0.374,
        },
        "M05152": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of left hip",
            "CommunityRAF": 0.374,
        },
        "M05159": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M05161": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of right knee",
            "CommunityRAF": 0.374,
        },
        "M05162": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of left knee",
            "CommunityRAF": 0.374,
        },
        "M05169": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M05171": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05172": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05179": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0519": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid lung disease with rheumatoid arthritis of multiple sites",
            "CommunityRAF": 0.374,
        },
        "M0520": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of unspecified site",
            "CommunityRAF": 0.374,
        },
        "M05211": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of right shoulder",
            "CommunityRAF": 0.374,
        },
        "M05212": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of left shoulder",
            "CommunityRAF": 0.374,
        },
        "M05219": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M05221": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of right elbow",
            "CommunityRAF": 0.374,
        },
        "M05222": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of left elbow",
            "CommunityRAF": 0.374,
        },
        "M05229": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M05231": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of right wrist",
            "CommunityRAF": 0.374,
        },
        "M05232": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of left wrist",
            "CommunityRAF": 0.374,
        },
        "M05239": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M05241": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of right hand",
            "CommunityRAF": 0.374,
        },
        "M05242": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of left hand",
            "CommunityRAF": 0.374,
        },
        "M05249": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M05251": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of right hip",
            "CommunityRAF": 0.374,
        },
        "M05252": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of left hip",
            "CommunityRAF": 0.374,
        },
        "M05259": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M05261": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of right knee",
            "CommunityRAF": 0.374,
        },
        "M05262": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of left knee",
            "CommunityRAF": 0.374,
        },
        "M05269": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M05271": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05272": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05279": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0529": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid vasculitis with rheumatoid arthritis of multiple sites",
            "CommunityRAF": 0.374,
        },
        "M0530": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of unspecified site",
            "CommunityRAF": 0.374,
        },
        "M05311": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of right shoulder",
            "CommunityRAF": 0.374,
        },
        "M05312": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of left shoulder",
            "CommunityRAF": 0.374,
        },
        "M05319": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M05321": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of right elbow",
            "CommunityRAF": 0.374,
        },
        "M05322": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of left elbow",
            "CommunityRAF": 0.374,
        },
        "M05329": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M05331": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of right wrist",
            "CommunityRAF": 0.374,
        },
        "M05332": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of left wrist",
            "CommunityRAF": 0.374,
        },
        "M05339": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M05341": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of right hand",
            "CommunityRAF": 0.374,
        },
        "M05342": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of left hand",
            "CommunityRAF": 0.374,
        },
        "M05349": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M05351": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of right hip",
            "CommunityRAF": 0.374,
        },
        "M05352": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of left hip",
            "CommunityRAF": 0.374,
        },
        "M05359": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M05361": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of right knee",
            "CommunityRAF": 0.374,
        },
        "M05362": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of left knee",
            "CommunityRAF": 0.374,
        },
        "M05369": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M05371": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05372": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05379": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0539": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid heart disease with rheumatoid arthritis of multiple sites",
            "CommunityRAF": 0.374,
        },
        "M0540": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of unspecified site",
            "CommunityRAF": 0.374,
        },
        "M05411": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of right shoulder",
            "CommunityRAF": 0.374,
        },
        "M05412": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of left shoulder",
            "CommunityRAF": 0.374,
        },
        "M05419": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M05421": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of right elbow",
            "CommunityRAF": 0.374,
        },
        "M05422": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of left elbow",
            "CommunityRAF": 0.374,
        },
        "M05429": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M05431": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of right wrist",
            "CommunityRAF": 0.374,
        },
        "M05432": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of left wrist",
            "CommunityRAF": 0.374,
        },
        "M05439": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M05441": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of right hand",
            "CommunityRAF": 0.374,
        },
        "M05442": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of left hand",
            "CommunityRAF": 0.374,
        },
        "M05449": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M05451": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of right hip",
            "CommunityRAF": 0.374,
        },
        "M05452": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of left hip",
            "CommunityRAF": 0.374,
        },
        "M05459": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M05461": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of right knee",
            "CommunityRAF": 0.374,
        },
        "M05462": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of left knee",
            "CommunityRAF": 0.374,
        },
        "M05469": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M05471": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05472": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05479": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0549": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid myopathy with rheumatoid arthritis of multiple sites",
            "CommunityRAF": 0.374,
        },
        "M0550": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of unspecified site",
            "CommunityRAF": 0.374,
        },
        "M05511": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of right shoulder",
            "CommunityRAF": 0.374,
        },
        "M05512": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of left shoulder",
            "CommunityRAF": 0.374,
        },
        "M05519": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M05521": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of right elbow",
            "CommunityRAF": 0.374,
        },
        "M05522": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of left elbow",
            "CommunityRAF": 0.374,
        },
        "M05529": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M05531": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of right wrist",
            "CommunityRAF": 0.374,
        },
        "M05532": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of left wrist",
            "CommunityRAF": 0.374,
        },
        "M05539": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M05541": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of right hand",
            "CommunityRAF": 0.374,
        },
        "M05542": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of left hand",
            "CommunityRAF": 0.374,
        },
        "M05549": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M05551": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of right hip",
            "CommunityRAF": 0.374,
        },
        "M05552": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of left hip",
            "CommunityRAF": 0.374,
        },
        "M05559": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M05561": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of right knee",
            "CommunityRAF": 0.374,
        },
        "M05562": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of left knee",
            "CommunityRAF": 0.374,
        },
        "M05569": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M05571": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05572": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05579": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0559": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid polyneuropathy with rheumatoid arthritis of multiple sites",
            "CommunityRAF": 0.374,
        },
        "M0560": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "",
            "CommunityRAF": 0.374,
        },
        "M05611": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of right shoulder with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05612": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of left shoulder with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05619": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of unspecified shoulder with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05621": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of right elbow with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05622": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of left elbow with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05629": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of unspecified elbow with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05631": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of right wrist with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05632": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of left wrist with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05639": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of unspecified wrist with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05641": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of right hand with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05642": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of left hand with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05649": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of unspecified hand with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05651": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of right hip with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05652": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of left hip with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05659": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of unspecified hip with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05661": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of right knee with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05662": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of left knee with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05669": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of unspecified knee with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05671": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of right ankle and foot with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05672": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of left ankle and foot with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M05679": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of unspecified ankle and foot with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M0569": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis of multiple sites with involvement of other organs and systems",
            "CommunityRAF": 0.374,
        },
        "M0570": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of unspecified site without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05711": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of right shoulder without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05712": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of left shoulder without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05719": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of unspecified shoulder without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05721": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of right elbow without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05722": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of left elbow without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05729": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of unspecified elbow without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05731": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of right wrist without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05732": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of left wrist without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05739": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of unspecified wrist without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05741": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of right hand without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05742": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of left hand without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05749": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of unspecified hand without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05751": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of right hip without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05752": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of left hip without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05759": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of unspecified hip without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05761": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of right knee without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05762": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of left knee without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05769": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of unspecified knee without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05771": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of right ankle and foot without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05772": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of left ankle and foot without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M05779": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of unspecified ankle and foot without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M0579": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor of multiple sites without organ or systems involvement",
            "CommunityRAF": 0.374,
        },
        "M0580": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of unspecified site",
            "CommunityRAF": 0.374,
        },
        "M05811": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of right shoulder",
            "CommunityRAF": 0.374,
        },
        "M05812": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of left shoulder",
            "CommunityRAF": 0.374,
        },
        "M05819": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M05821": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of right elbow",
            "CommunityRAF": 0.374,
        },
        "M05822": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of left elbow",
            "CommunityRAF": 0.374,
        },
        "M05829": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M05831": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of right wrist",
            "CommunityRAF": 0.374,
        },
        "M05832": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of left wrist",
            "CommunityRAF": 0.374,
        },
        "M05839": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M05841": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of right hand",
            "CommunityRAF": 0.374,
        },
        "M05842": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of left hand",
            "CommunityRAF": 0.374,
        },
        "M05849": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M05851": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of right hip",
            "CommunityRAF": 0.374,
        },
        "M05852": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of left hip",
            "CommunityRAF": 0.374,
        },
        "M05859": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M05861": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of right knee",
            "CommunityRAF": 0.374,
        },
        "M05862": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of left knee",
            "CommunityRAF": 0.374,
        },
        "M05869": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M05871": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05872": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M05879": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0589": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other rheumatoid arthritis with rheumatoid factor of multiple sites",
            "CommunityRAF": 0.374,
        },
        "M059": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis with rheumatoid factor, unspecified",
            "CommunityRAF": 0.374,
        },
        "M0600": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M06011": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M06012": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M06019": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M06021": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, right elbow",
            "CommunityRAF": 0.374,
        },
        "M06022": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, left elbow",
            "CommunityRAF": 0.374,
        },
        "M06029": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M06031": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, right wrist",
            "CommunityRAF": 0.374,
        },
        "M06032": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, left wrist",
            "CommunityRAF": 0.374,
        },
        "M06039": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M06041": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, right hand",
            "CommunityRAF": 0.374,
        },
        "M06042": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, left hand",
            "CommunityRAF": 0.374,
        },
        "M06049": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M06051": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, right hip",
            "CommunityRAF": 0.374,
        },
        "M06052": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, left hip",
            "CommunityRAF": 0.374,
        },
        "M06059": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M06061": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, right knee",
            "CommunityRAF": 0.374,
        },
        "M06062": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, left knee",
            "CommunityRAF": 0.374,
        },
        "M06069": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M06071": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M06072": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M06079": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0608": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, vertebrae",
            "CommunityRAF": 0.374,
        },
        "M0609": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis without rheumatoid factor, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M061": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Adult-onset Still's disease",
            "CommunityRAF": 0.374,
        },
        "M0620": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M06211": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M06212": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M06219": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M06221": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, right elbow",
            "CommunityRAF": 0.374,
        },
        "M06222": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, left elbow",
            "CommunityRAF": 0.374,
        },
        "M06229": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M06231": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, right wrist",
            "CommunityRAF": 0.374,
        },
        "M06232": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, left wrist",
            "CommunityRAF": 0.374,
        },
        "M06239": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M06241": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, right hand",
            "CommunityRAF": 0.374,
        },
        "M06242": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, left hand",
            "CommunityRAF": 0.374,
        },
        "M06249": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M06251": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, right hip",
            "CommunityRAF": 0.374,
        },
        "M06252": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, left hip",
            "CommunityRAF": 0.374,
        },
        "M06259": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M06261": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, right knee",
            "CommunityRAF": 0.374,
        },
        "M06262": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, left knee",
            "CommunityRAF": 0.374,
        },
        "M06269": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M06271": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M06272": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M06279": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0628": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, vertebrae",
            "CommunityRAF": 0.374,
        },
        "M0629": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid bursitis, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M0630": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M06311": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M06312": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M06319": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M06321": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, right elbow",
            "CommunityRAF": 0.374,
        },
        "M06322": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, left elbow",
            "CommunityRAF": 0.374,
        },
        "M06329": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M06331": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, right wrist",
            "CommunityRAF": 0.374,
        },
        "M06332": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, left wrist",
            "CommunityRAF": 0.374,
        },
        "M06339": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M06341": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, right hand",
            "CommunityRAF": 0.374,
        },
        "M06342": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, left hand",
            "CommunityRAF": 0.374,
        },
        "M06349": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M06351": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, right hip",
            "CommunityRAF": 0.374,
        },
        "M06352": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, left hip",
            "CommunityRAF": 0.374,
        },
        "M06359": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M06361": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, right knee",
            "CommunityRAF": 0.374,
        },
        "M06362": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, left knee",
            "CommunityRAF": 0.374,
        },
        "M06369": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M06371": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M06372": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M06379": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0638": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, vertebrae",
            "CommunityRAF": 0.374,
        },
        "M0639": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid nodule, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M064": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Inflammatory polyarthropathy",
            "CommunityRAF": 0.374,
        },
        "M0680": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M06811": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M06812": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M06819": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M06821": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, right elbow",
            "CommunityRAF": 0.374,
        },
        "M06822": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, left elbow",
            "CommunityRAF": 0.374,
        },
        "M06829": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M06831": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, right wrist",
            "CommunityRAF": 0.374,
        },
        "M06832": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, left wrist",
            "CommunityRAF": 0.374,
        },
        "M06839": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M06841": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, right hand",
            "CommunityRAF": 0.374,
        },
        "M06842": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, left hand",
            "CommunityRAF": 0.374,
        },
        "M06849": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M06851": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, right hip",
            "CommunityRAF": 0.374,
        },
        "M06852": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, left hip",
            "CommunityRAF": 0.374,
        },
        "M06859": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M06861": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, right knee",
            "CommunityRAF": 0.374,
        },
        "M06862": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, left knee",
            "CommunityRAF": 0.374,
        },
        "M06869": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M06871": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M06872": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M06879": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0688": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, vertebrae",
            "CommunityRAF": 0.374,
        },
        "M0689": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified rheumatoid arthritis, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M069": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Rheumatoid arthritis, unspecified",
            "CommunityRAF": 0.374,
        },
        "M0800": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis of unspecified site",
            "CommunityRAF": 0.374,
        },
        "M08011": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M08012": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M08019": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M08021": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, right elbow",
            "CommunityRAF": 0.374,
        },
        "M08022": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, left elbow",
            "CommunityRAF": 0.374,
        },
        "M08029": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M08031": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, right wrist",
            "CommunityRAF": 0.374,
        },
        "M08032": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, left wrist",
            "CommunityRAF": 0.374,
        },
        "M08039": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M08041": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, right hand",
            "CommunityRAF": 0.374,
        },
        "M08042": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, left hand",
            "CommunityRAF": 0.374,
        },
        "M08049": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M08051": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, right hip",
            "CommunityRAF": 0.374,
        },
        "M08052": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, left hip",
            "CommunityRAF": 0.374,
        },
        "M08059": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M08061": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, right knee",
            "CommunityRAF": 0.374,
        },
        "M08062": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, left knee",
            "CommunityRAF": 0.374,
        },
        "M08069": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M08071": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08072": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08079": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0808": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, vertebrae",
            "CommunityRAF": 0.374,
        },
        "M0809": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified juvenile rheumatoid arthritis, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M081": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile ankylosing spondylitis",
            "CommunityRAF": 0.374,
        },
        "M0820": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M08211": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M08212": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M08219": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M08221": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, right elbow",
            "CommunityRAF": 0.374,
        },
        "M08222": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, left elbow",
            "CommunityRAF": 0.374,
        },
        "M08229": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M08231": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, right wrist",
            "CommunityRAF": 0.374,
        },
        "M08232": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, left wrist",
            "CommunityRAF": 0.374,
        },
        "M08239": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M08241": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, right hand",
            "CommunityRAF": 0.374,
        },
        "M08242": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, left hand",
            "CommunityRAF": 0.374,
        },
        "M08249": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M08251": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, right hip",
            "CommunityRAF": 0.374,
        },
        "M08252": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, left hip",
            "CommunityRAF": 0.374,
        },
        "M08259": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M08261": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, right knee",
            "CommunityRAF": 0.374,
        },
        "M08262": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, left knee",
            "CommunityRAF": 0.374,
        },
        "M08269": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M08271": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08272": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08279": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0828": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, vertebrae",
            "CommunityRAF": 0.374,
        },
        "M0829": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid arthritis with systemic onset, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M083": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile rheumatoid polyarthritis (seronegative)",
            "CommunityRAF": 0.374,
        },
        "M0840": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M08411": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M08412": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M08419": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M08421": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, right elbow",
            "CommunityRAF": 0.374,
        },
        "M08422": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, left elbow",
            "CommunityRAF": 0.374,
        },
        "M08429": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M08431": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, right wrist",
            "CommunityRAF": 0.374,
        },
        "M08432": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, left wrist",
            "CommunityRAF": 0.374,
        },
        "M08439": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M08441": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, right hand",
            "CommunityRAF": 0.374,
        },
        "M08442": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, left hand",
            "CommunityRAF": 0.374,
        },
        "M08449": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M08451": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, right hip",
            "CommunityRAF": 0.374,
        },
        "M08452": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, left hip",
            "CommunityRAF": 0.374,
        },
        "M08459": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M08461": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, right knee",
            "CommunityRAF": 0.374,
        },
        "M08462": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, left knee",
            "CommunityRAF": 0.374,
        },
        "M08469": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M08471": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08472": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08479": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0848": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pauciarticular juvenile rheumatoid arthritis, vertebrae",
            "CommunityRAF": 0.374,
        },
        "M0880": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M08811": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M08812": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M08819": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M08821": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, right elbow",
            "CommunityRAF": 0.374,
        },
        "M08822": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, left elbow",
            "CommunityRAF": 0.374,
        },
        "M08829": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M08831": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, right wrist",
            "CommunityRAF": 0.374,
        },
        "M08832": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, left wrist",
            "CommunityRAF": 0.374,
        },
        "M08839": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M08841": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, right hand",
            "CommunityRAF": 0.374,
        },
        "M08842": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, left hand",
            "CommunityRAF": 0.374,
        },
        "M08849": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M08851": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, right hip",
            "CommunityRAF": 0.374,
        },
        "M08852": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, left hip",
            "CommunityRAF": 0.374,
        },
        "M08859": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M08861": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, right knee",
            "CommunityRAF": 0.374,
        },
        "M08862": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, left knee",
            "CommunityRAF": 0.374,
        },
        "M08869": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M08871": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08872": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08879": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0888": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, other specified site",
            "CommunityRAF": 0.374,
        },
        "M0889": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other juvenile arthritis, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M0890": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, unspecified site",
            "CommunityRAF": 0.374,
        },
        "M08911": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, right shoulder",
            "CommunityRAF": 0.374,
        },
        "M08912": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, left shoulder",
            "CommunityRAF": 0.374,
        },
        "M08919": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M08921": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, right elbow",
            "CommunityRAF": 0.374,
        },
        "M08922": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, left elbow",
            "CommunityRAF": 0.374,
        },
        "M08929": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M08931": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, right wrist",
            "CommunityRAF": 0.374,
        },
        "M08932": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, left wrist",
            "CommunityRAF": 0.374,
        },
        "M08939": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M08941": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, right hand",
            "CommunityRAF": 0.374,
        },
        "M08942": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, left hand",
            "CommunityRAF": 0.374,
        },
        "M08949": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M08951": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, right hip",
            "CommunityRAF": 0.374,
        },
        "M08952": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, left hip",
            "CommunityRAF": 0.374,
        },
        "M08959": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M08961": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, right knee",
            "CommunityRAF": 0.374,
        },
        "M08962": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, left knee",
            "CommunityRAF": 0.374,
        },
        "M08969": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M08971": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08972": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M08979": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M0898": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, vertebrae",
            "CommunityRAF": 0.374,
        },
        "M0899": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile arthritis, unspecified, multiple sites",
            "CommunityRAF": 0.374,
        },
        "M1200": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], unspecified site",
            "CommunityRAF": 0.374,
        },
        "M12011": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], right shoulder",
            "CommunityRAF": 0.374,
        },
        "M12012": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], left shoulder",
            "CommunityRAF": 0.374,
        },
        "M12019": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], unspecified shoulder",
            "CommunityRAF": 0.374,
        },
        "M12021": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], right elbow",
            "CommunityRAF": 0.374,
        },
        "M12022": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], left elbow",
            "CommunityRAF": 0.374,
        },
        "M12029": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], unspecified elbow",
            "CommunityRAF": 0.374,
        },
        "M12031": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], right wrist",
            "CommunityRAF": 0.374,
        },
        "M12032": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], left wrist",
            "CommunityRAF": 0.374,
        },
        "M12039": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], unspecified wrist",
            "CommunityRAF": 0.374,
        },
        "M12041": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], right hand",
            "CommunityRAF": 0.374,
        },
        "M12042": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], left hand",
            "CommunityRAF": 0.374,
        },
        "M12049": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], unspecified hand",
            "CommunityRAF": 0.374,
        },
        "M12051": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], right hip",
            "CommunityRAF": 0.374,
        },
        "M12052": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], left hip",
            "CommunityRAF": 0.374,
        },
        "M12059": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], unspecified hip",
            "CommunityRAF": 0.374,
        },
        "M12061": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], right knee",
            "CommunityRAF": 0.374,
        },
        "M12062": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], left knee",
            "CommunityRAF": 0.374,
        },
        "M12069": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], unspecified knee",
            "CommunityRAF": 0.374,
        },
        "M12071": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], right ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M12072": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], left ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M12079": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], unspecified ankle and foot",
            "CommunityRAF": 0.374,
        },
        "M1208": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], other specified site",
            "CommunityRAF": 0.374,
        },
        "M1209": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Chronic postrheumatic arthropathy [Jaccoud], multiple sites",
            "CommunityRAF": 0.374,
        },
        "M300": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Polyarteritis nodosa",
            "CommunityRAF": 0.374,
        },
        "M301": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Polyarteritis with lung involvement [Churg-Strauss]",
            "CommunityRAF": 0.374,
        },
        "M302": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile polyarteritis",
            "CommunityRAF": 0.374,
        },
        "M303": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Mucocutaneous lymph node syndrome [Kawasaki]",
            "CommunityRAF": 0.374,
        },
        "M308": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other conditions related to polyarteritis nodosa",
            "CommunityRAF": 0.374,
        },
        "M310": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Hypersensitivity angiitis",
            "CommunityRAF": 0.374,
        },
        "M311": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Thrombotic microangiopathy",
            "CommunityRAF": 0.374,
        },
        "M312": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Lethal midline granuloma",
            "CommunityRAF": 0.374,
        },
        "M3130": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Wegener's granulomatosis without renal involvement",
            "CommunityRAF": 0.374,
        },
        "M3131": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Wegener's granulomatosis with renal involvement",
            "CommunityRAF": 0.374,
        },
        "M314": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Aortic arch syndrome [Takayasu]",
            "CommunityRAF": 0.374,
        },
        "M315": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Giant cell arteritis with polymyalgia rheumatica",
            "CommunityRAF": 0.374,
        },
        "M316": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other giant cell arteritis",
            "CommunityRAF": 0.374,
        },
        "M317": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Microscopic polyangiitis",
            "CommunityRAF": 0.374,
        },
        "M320": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Drug-induced systemic lupus erythematosus",
            "CommunityRAF": 0.374,
        },
        "M3210": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Systemic lupus erythematosus, organ or system involvement unspecified",
            "CommunityRAF": 0.374,
        },
        "M3211": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Endocarditis in systemic lupus erythematosus",
            "CommunityRAF": 0.374,
        },
        "M3212": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Pericarditis in systemic lupus erythematosus",
            "CommunityRAF": 0.374,
        },
        "M3213": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Lung involvement in systemic lupus erythematosus",
            "CommunityRAF": 0.374,
        },
        "M3214": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Glomerular disease in systemic lupus erythematosus",
            "CommunityRAF": 0.374,
        },
        "M3215": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Tubulo-interstitial nephropathy in systemic lupus erythematosus",
            "CommunityRAF": 0.374,
        },
        "M3219": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other organ or system involvement in systemic lupus erythematosus",
            "CommunityRAF": 0.374,
        },
        "M328": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other forms of systemic lupus erythematosus",
            "CommunityRAF": 0.374,
        },
        "M329": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Systemic lupus erythematosus, unspecified",
            "CommunityRAF": 0.374,
        },
        "M3300": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile dermatopolymyositis, organ involvement unspecified",
            "CommunityRAF": 0.374,
        },
        "M3301": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile dermatopolymyositis with respiratory involvement",
            "CommunityRAF": 0.374,
        },
        "M3302": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile dermatopolymyositis with myopathy",
            "CommunityRAF": 0.374,
        },
        "M3309": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Juvenile dermatopolymyositis with other organ involvement",
            "CommunityRAF": 0.374,
        },
        "M3310": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other dermatopolymyositis, organ involvement unspecified",
            "CommunityRAF": 0.374,
        },
        "M3311": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other dermatopolymyositis with respiratory involvement",
            "CommunityRAF": 0.374,
        },
        "M3312": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other dermatopolymyositis with myopathy",
            "CommunityRAF": 0.374,
        },
        "M3319": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other dermatopolymyositis with other organ involvement",
            "CommunityRAF": 0.374,
        },
        "M3320": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Polymyositis, organ involvement unspecified",
            "CommunityRAF": 0.374,
        },
        "M3321": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Polymyositis with respiratory involvement",
            "CommunityRAF": 0.374,
        },
        "M3322": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Polymyositis with myopathy",
            "CommunityRAF": 0.374,
        },
        "M3329": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Polymyositis with other organ involvement",
            "CommunityRAF": 0.374,
        },
        "M3390": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Dermatopolymyositis, unspecified, organ involvement unspecified",
            "CommunityRAF": 0.374,
        },
        "M3391": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Dermatopolymyositis, unspecified with respiratory involvement",
            "CommunityRAF": 0.374,
        },
        "M3392": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Dermatopolymyositis, unspecified with myopathy",
            "CommunityRAF": 0.374,
        },
        "M3399": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Dermatopolymyositis, unspecified with other organ involvement",
            "CommunityRAF": 0.374,
        },
        "M340": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Progressive systemic sclerosis",
            "CommunityRAF": 0.374,
        },
        "M341": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "CR(E)ST syndrome",
            "CommunityRAF": 0.374,
        },
        "M342": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Systemic sclerosis induced by drug and chemical",
            "CommunityRAF": 0.374,
        },
        "M3481": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Systemic sclerosis with lung involvement",
            "CommunityRAF": 0.374,
        },
        "M3482": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Systemic sclerosis with myopathy",
            "CommunityRAF": 0.374,
        },
        "M3483": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Systemic sclerosis with polyneuropathy",
            "CommunityRAF": 0.374,
        },
        "M3489": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other systemic sclerosis",
            "CommunityRAF": 0.374,
        },
        "M349": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Systemic sclerosis, unspecified",
            "CommunityRAF": 0.374,
        },
        "M3500": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Sicca syndrome, unspecified",
            "CommunityRAF": 0.374,
        },
        "M3501": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Sicca syndrome with keratoconjunctivitis",
            "CommunityRAF": 0.374,
        },
        "M3502": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Sicca syndrome with lung involvement",
            "CommunityRAF": 0.374,
        },
        "M3503": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Sicca syndrome with myopathy",
            "CommunityRAF": 0.374,
        },
        "M3504": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Sicca syndrome with tubulo-interstitial nephropathy",
            "CommunityRAF": 0.374,
        },
        "M3509": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Sicca syndrome with other organ involvement",
            "CommunityRAF": 0.374,
        },
        "M351": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other overlap syndromes",
            "CommunityRAF": 0.374,
        },
        "M352": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Behcet's disease",
            "CommunityRAF": 0.374,
        },
        "M353": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Polymyalgia rheumatica",
            "CommunityRAF": 0.374,
        },
        "M355": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Multifocal fibrosclerosis",
            "CommunityRAF": 0.374,
        },
        "M358": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified systemic involvement of connective tissue",
            "CommunityRAF": 0.374,
        },
        "M359": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Systemic involvement of connective tissue, unspecified",
            "CommunityRAF": 0.374,
        },
        "M360": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Dermato(poly)myositis in neoplastic disease",
            "CommunityRAF": 0.374,
        },
        "M368": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Systemic disorders of connective tissue in other diseases classified elsewhere",
            "CommunityRAF": 0.374,
        },
        "M450": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis of multiple sites in spine",
            "CommunityRAF": 0.374,
        },
        "M451": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis of occipito-atlanto-axial region",
            "CommunityRAF": 0.374,
        },
        "M452": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis of cervical region",
            "CommunityRAF": 0.374,
        },
        "M453": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis of cervicothoracic region",
            "CommunityRAF": 0.374,
        },
        "M454": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis of thoracic region",
            "CommunityRAF": 0.374,
        },
        "M455": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis of thoracolumbar region",
            "CommunityRAF": 0.374,
        },
        "M456": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis lumbar region",
            "CommunityRAF": 0.374,
        },
        "M457": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis of lumbosacral region",
            "CommunityRAF": 0.374,
        },
        "M458": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis sacral and sacrococcygeal region",
            "CommunityRAF": 0.374,
        },
        "M459": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Ankylosing spondylitis of unspecified sites in spine",
            "CommunityRAF": 0.374,
        },
        "M4600": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, site unspecified",
            "CommunityRAF": 0.374,
        },
        "M4601": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, occipito-atlanto-axial region",
            "CommunityRAF": 0.374,
        },
        "M4602": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, cervical region",
            "CommunityRAF": 0.374,
        },
        "M4603": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, cervicothoracic region",
            "CommunityRAF": 0.374,
        },
        "M4604": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, thoracic region",
            "CommunityRAF": 0.374,
        },
        "M4605": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, thoracolumbar region",
            "CommunityRAF": 0.374,
        },
        "M4606": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, lumbar region",
            "CommunityRAF": 0.374,
        },
        "M4607": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, lumbosacral region",
            "CommunityRAF": 0.374,
        },
        "M4608": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, sacral and sacrococcygeal region",
            "CommunityRAF": 0.374,
        },
        "M4609": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spinal enthesopathy, multiple sites in spine",
            "CommunityRAF": 0.374,
        },
        "M461": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Sacroiliitis, not elsewhere classified",
            "CommunityRAF": 0.374,
        },
        "M4650": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, site unspecified",
            "CommunityRAF": 0.374,
        },
        "M4651": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, occipito-atlanto-axial region",
            "CommunityRAF": 0.374,
        },
        "M4652": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, cervical region",
            "CommunityRAF": 0.374,
        },
        "M4653": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, cervicothoracic region",
            "CommunityRAF": 0.374,
        },
        "M4654": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, thoracic region",
            "CommunityRAF": 0.374,
        },
        "M4655": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, thoracolumbar region",
            "CommunityRAF": 0.374,
        },
        "M4656": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, lumbar region",
            "CommunityRAF": 0.374,
        },
        "M4657": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, lumbosacral region",
            "CommunityRAF": 0.374,
        },
        "M4658": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, sacral and sacrococcygeal region",
            "CommunityRAF": 0.374,
        },
        "M4659": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other infective spondylopathies, multiple sites in spine",
            "CommunityRAF": 0.374,
        },
        "M4680": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, site unspecified",
            "CommunityRAF": 0.374,
        },
        "M4681": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, occipito-atlanto-axial region",
            "CommunityRAF": 0.374,
        },
        "M4682": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, cervical region",
            "CommunityRAF": 0.374,
        },
        "M4683": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, cervicothoracic region",
            "CommunityRAF": 0.374,
        },
        "M4684": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, thoracic region",
            "CommunityRAF": 0.374,
        },
        "M4685": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, thoracolumbar region",
            "CommunityRAF": 0.374,
        },
        "M4686": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, lumbar region",
            "CommunityRAF": 0.374,
        },
        "M4687": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, lumbosacral region",
            "CommunityRAF": 0.374,
        },
        "M4688": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, sacral and sacrococcygeal region",
            "CommunityRAF": 0.374,
        },
        "M4689": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified inflammatory spondylopathies, multiple sites in spine",
            "CommunityRAF": 0.374,
        },
        "M4690": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, site unspecified",
            "CommunityRAF": 0.374,
        },
        "M4691": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, occipito-atlanto-axial region",
            "CommunityRAF": 0.374,
        },
        "M4692": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, cervical region",
            "CommunityRAF": 0.374,
        },
        "M4693": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, cervicothoracic region",
            "CommunityRAF": 0.374,
        },
        "M4694": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, thoracic region",
            "CommunityRAF": 0.374,
        },
        "M4695": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, thoracolumbar region",
            "CommunityRAF": 0.374,
        },
        "M4696": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, lumbar region",
            "CommunityRAF": 0.374,
        },
        "M4697": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, lumbosacral region",
            "CommunityRAF": 0.374,
        },
        "M4698": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, sacral and sacrococcygeal region",
            "CommunityRAF": 0.374,
        },
        "M4699": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Unspecified inflammatory spondylopathy, multiple sites in spine",
            "CommunityRAF": 0.374,
        },
        "M488X1": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified spondylopathies, occipito-atlanto-axial region",
            "CommunityRAF": 0.374,
        },
        "M488X2": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified spondylopathies, cervical region",
            "CommunityRAF": 0.374,
        },
        "M488X3": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified spondylopathies, cervicothoracic region",
            "CommunityRAF": 0.374,
        },
        "M488X4": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified spondylopathies, thoracic region",
            "CommunityRAF": 0.374,
        },
        "M488X5": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified spondylopathies, thoracolumbar region",
            "CommunityRAF": 0.374,
        },
        "M488X6": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified spondylopathies, lumbar region",
            "CommunityRAF": 0.374,
        },
        "M488X7": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified spondylopathies, lumbosacral region",
            "CommunityRAF": 0.374,
        },
        "M488X8": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified spondylopathies, sacral and sacrococcygeal region",
            "CommunityRAF": 0.374,
        },
        "M488X9": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Other specified spondylopathies, site unspecified",
            "CommunityRAF": 0.374,
        },
        "M4980": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, site unspecified",
            "CommunityRAF": 0.374,
        },
        "M4981": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, occipito-atlanto-axial region",
            "CommunityRAF": 0.374,
        },
        "M4982": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, cervical region",
            "CommunityRAF": 0.374,
        },
        "M4983": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, cervicothoracic region",
            "CommunityRAF": 0.374,
        },
        "M4984": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, thoracic region",
            "CommunityRAF": 0.374,
        },
        "M4985": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, thoracolumbar region",
            "CommunityRAF": 0.374,
        },
        "M4986": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, lumbar region",
            "CommunityRAF": 0.374,
        },
        "M4987": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, lumbosacral region",
            "CommunityRAF": 0.374,
        },
        "M4988": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, sacral and sacrococcygeal region",
            "CommunityRAF": 0.374,
        },
        "M4989": {
            "HCC": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
            "ICD10": "Spondylopathy in diseases classified elsewhere, multiple sites in spine",
            "CommunityRAF": 0.374,
        },
        "D460": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Refractory anemia without ring sideroblasts, so stated",
            "CommunityRAF": 1.136,
        },
        "D461": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Refractory anemia with ring sideroblasts",
            "CommunityRAF": 1.136,
        },
        "D4620": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Refractory anemia with excess of blasts, unspecified",
            "CommunityRAF": 1.136,
        },
        "D4621": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Refractory anemia with excess of blasts 1",
            "CommunityRAF": 1.136,
        },
        "D4622": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Refractory anemia with excess of blasts 2",
            "CommunityRAF": 1.136,
        },
        "D464": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Refractory anemia, unspecified",
            "CommunityRAF": 1.136,
        },
        "D469": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Myelodysplastic syndrome, unspecified",
            "CommunityRAF": 1.136,
        },
        "D46A": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Refractory cytopenia with multilineage dysplasia",
            "CommunityRAF": 1.136,
        },
        "D46B": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Refractory cytopenia with multilineage dysplasia and ring sideroblasts",
            "CommunityRAF": 1.136,
        },
        "D46C": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Myelodysplastic syndrome with isolated del(5q) chromosomal abnormality",
            "CommunityRAF": 1.136,
        },
        "D46Z": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other myelodysplastic syndromes",
            "CommunityRAF": 1.136,
        },
        "D474": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Osteomyelofibrosis",
            "CommunityRAF": 1.136,
        },
        "D5700": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Hb-SS disease with crisis, unspecified",
            "CommunityRAF": 1.136,
        },
        "D5701": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Hb-SS disease with acute chest syndrome",
            "CommunityRAF": 1.136,
        },
        "D5702": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Hb-SS disease with splenic sequestration",
            "CommunityRAF": 1.136,
        },
        "D571": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Sickle-cell disease without crisis",
            "CommunityRAF": 1.136,
        },
        "D5720": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Sickle-cell/Hb-C disease without crisis",
            "CommunityRAF": 1.136,
        },
        "D57211": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Sickle-cell/Hb-C disease with acute chest syndrome",
            "CommunityRAF": 1.136,
        },
        "D57212": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Sickle-cell/Hb-C disease with splenic sequestration",
            "CommunityRAF": 1.136,
        },
        "D57219": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Sickle-cell/Hb-C disease with crisis, unspecified",
            "CommunityRAF": 1.136,
        },
        "D5740": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Sickle-cell thalassemia without crisis",
            "CommunityRAF": 1.136,
        },
        "D57411": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Sickle-cell thalassemia with acute chest syndrome",
            "CommunityRAF": 1.136,
        },
        "D57412": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Sickle-cell thalassemia with splenic sequestration",
            "CommunityRAF": 1.136,
        },
        "D57419": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Sickle-cell thalassemia with crisis, unspecified",
            "CommunityRAF": 1.136,
        },
        "D5780": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other sickle-cell disorders without crisis",
            "CommunityRAF": 1.136,
        },
        "D57811": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other sickle-cell disorders with acute chest syndrome",
            "CommunityRAF": 1.136,
        },
        "D57812": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other sickle-cell disorders with splenic sequestration",
            "CommunityRAF": 1.136,
        },
        "D57819": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other sickle-cell disorders with crisis, unspecified",
            "CommunityRAF": 1.136,
        },
        "D590": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Drug-induced autoimmune hemolytic anemia",
            "CommunityRAF": 1.136,
        },
        "D591": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other autoimmune hemolytic anemias",
            "CommunityRAF": 1.136,
        },
        "D592": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Drug-induced nonautoimmune hemolytic anemia",
            "CommunityRAF": 1.136,
        },
        "D593": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Hemolytic-uremic syndrome",
            "CommunityRAF": 1.136,
        },
        "D594": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other nonautoimmune hemolytic anemias",
            "CommunityRAF": 1.136,
        },
        "D595": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Paroxysmal nocturnal hemoglobinuria [Marchiafava-Micheli]",
            "CommunityRAF": 1.136,
        },
        "D596": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Hemoglobinuria due to hemolysis from other external causes",
            "CommunityRAF": 1.136,
        },
        "D598": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other acquired hemolytic anemias",
            "CommunityRAF": 1.136,
        },
        "D599": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Acquired hemolytic anemia, unspecified",
            "CommunityRAF": 1.136,
        },
        "D600": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Chronic acquired pure red cell aplasia",
            "CommunityRAF": 1.136,
        },
        "D601": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Transient acquired pure red cell aplasia",
            "CommunityRAF": 1.136,
        },
        "D608": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other acquired pure red cell aplasias",
            "CommunityRAF": 1.136,
        },
        "D609": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Acquired pure red cell aplasia, unspecified",
            "CommunityRAF": 1.136,
        },
        "D6101": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Constitutional (pure) red blood cell aplasia",
            "CommunityRAF": 1.136,
        },
        "D6109": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other constitutional aplastic anemia",
            "CommunityRAF": 1.136,
        },
        "D611": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Drug-induced aplastic anemia",
            "CommunityRAF": 1.136,
        },
        "D612": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Aplastic anemia due to other external agents",
            "CommunityRAF": 1.136,
        },
        "D613": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Idiopathic aplastic anemia",
            "CommunityRAF": 1.136,
        },
        "D6182": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Myelophthisis",
            "CommunityRAF": 1.136,
        },
        "D6189": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Other specified aplastic anemias and other bone marrow failure syndromes",
            "CommunityRAF": 1.136,
        },
        "D619": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Aplastic anemia, unspecified",
            "CommunityRAF": 1.136,
        },
        "D66": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Hereditary factor VIII deficiency",
            "CommunityRAF": 1.136,
        },
        "D67": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Hereditary factor IX deficiency",
            "CommunityRAF": 1.136,
        },
        "D7581": {
            "HCC": "Severe Hematological Disorders",
            "ICD10": "Myelofibrosis",
            "CommunityRAF": 1.136,
        },
        "D61810": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Antineoplastic chemotherapy induced pancytopenia",
            "CommunityRAF": 0.521,
        },
        "D61811": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other drug-induced pancytopenia",
            "CommunityRAF": 0.521,
        },
        "D61818": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other pancytopenia",
            "CommunityRAF": 0.521,
        },
        "D700": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Congenital agranulocytosis",
            "CommunityRAF": 0.521,
        },
        "D701": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Agranulocytosis secondary to cancer chemotherapy",
            "CommunityRAF": 0.521,
        },
        "D702": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other drug-induced agranulocytosis",
            "CommunityRAF": 0.521,
        },
        "D703": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Neutropenia due to infection",
            "CommunityRAF": 0.521,
        },
        "D704": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Cyclic neutropenia",
            "CommunityRAF": 0.521,
        },
        "D708": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other neutropenia",
            "CommunityRAF": 0.521,
        },
        "D709": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Neutropenia, unspecified",
            "CommunityRAF": 0.521,
        },
        "D71": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Functional disorders of polymorphonuclear neutrophils",
            "CommunityRAF": 0.521,
        },
        "D720": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Genetic anomalies of leukocytes",
            "CommunityRAF": 0.521,
        },
        "D761": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Hemophagocytic lymphohistiocytosis",
            "CommunityRAF": 0.521,
        },
        "D762": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Hemophagocytic syndrome, infection-associated",
            "CommunityRAF": 0.521,
        },
        "D763": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other histiocytosis syndromes",
            "CommunityRAF": 0.521,
        },
        "D800": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Hereditary hypogammaglobulinemia",
            "CommunityRAF": 0.521,
        },
        "D801": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Nonfamilial hypogammaglobulinemia",
            "CommunityRAF": 0.521,
        },
        "D802": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Selective deficiency of immunoglobulin A [IgA]",
            "CommunityRAF": 0.521,
        },
        "D803": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Selective deficiency of immunoglobulin G [IgG] subclasses",
            "CommunityRAF": 0.521,
        },
        "D804": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Selective deficiency of immunoglobulin M [IgM]",
            "CommunityRAF": 0.521,
        },
        "D805": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Immunodeficiency with increased immunoglobulin M [IgM]",
            "CommunityRAF": 0.521,
        },
        "D806": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Antibody deficiency with near-normal immunoglobulins or with hyperimmunoglobulinemia",
            "CommunityRAF": 0.521,
        },
        "D807": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Transient hypogammaglobulinemia of infancy",
            "CommunityRAF": 0.521,
        },
        "D808": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other immunodeficiencies with predominantly antibody defects",
            "CommunityRAF": 0.521,
        },
        "D809": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Immunodeficiency with predominantly antibody defects, unspecified",
            "CommunityRAF": 0.521,
        },
        "D810": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Severe combined immunodeficiency [SCID] with reticular dysgenesis",
            "CommunityRAF": 0.521,
        },
        "D811": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Severe combined immunodeficiency [SCID] with low T- and B-cell numbers",
            "CommunityRAF": 0.521,
        },
        "D812": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Severe combined immunodeficiency [SCID] with low or normal B-cell numbers",
            "CommunityRAF": 0.521,
        },
        "D813": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Adenosine deaminase [ADA] deficiency",
            "CommunityRAF": 0.521,
        },
        "D814": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Nezelof's syndrome",
            "CommunityRAF": 0.521,
        },
        "D815": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Purine nucleoside phosphorylase [PNP] deficiency",
            "CommunityRAF": 0.521,
        },
        "D816": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Major histocompatibility complex class I deficiency",
            "CommunityRAF": 0.521,
        },
        "D817": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Major histocompatibility complex class II deficiency",
            "CommunityRAF": 0.521,
        },
        "D8189": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other combined immunodeficiencies",
            "CommunityRAF": 0.521,
        },
        "D819": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Combined immunodeficiency, unspecified",
            "CommunityRAF": 0.521,
        },
        "D820": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Wiskott-Aldrich syndrome",
            "CommunityRAF": 0.521,
        },
        "D821": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Di George's syndrome",
            "CommunityRAF": 0.521,
        },
        "D822": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Immunodeficiency with short-limbed stature",
            "CommunityRAF": 0.521,
        },
        "D823": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Immunodeficiency following hereditary defective response to Epstein-Barr virus",
            "CommunityRAF": 0.521,
        },
        "D824": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Hyperimmunoglobulin E [IgE] syndrome",
            "CommunityRAF": 0.521,
        },
        "D828": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Immunodeficiency associated with other specified major defects",
            "CommunityRAF": 0.521,
        },
        "D829": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Immunodeficiency associated with major defect, unspecified",
            "CommunityRAF": 0.521,
        },
        "D830": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Common variable immunodeficiency with predominant abnormalities of B-cell numbers and function",
            "CommunityRAF": 0.521,
        },
        "D831": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Common variable immunodeficiency with predominant immunoregulatory T-cell disorders",
            "CommunityRAF": 0.521,
        },
        "D832": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Common variable immunodeficiency with autoantibodies to B- or T-cells",
            "CommunityRAF": 0.521,
        },
        "D838": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other common variable immunodeficiencies",
            "CommunityRAF": 0.521,
        },
        "D839": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Common variable immunodeficiency, unspecified",
            "CommunityRAF": 0.521,
        },
        "D840": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Lymphocyte function antigen-1 [LFA-1] defect",
            "CommunityRAF": 0.521,
        },
        "D848": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other specified immunodeficiencies",
            "CommunityRAF": 0.521,
        },
        "D849": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Immunodeficiency, unspecified",
            "CommunityRAF": 0.521,
        },
        "D893": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Immune reconstitution syndrome",
            "CommunityRAF": 0.521,
        },
        "D8940": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Mast cell activation, unspecified",
            "CommunityRAF": 0.521,
        },
        "D8941": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Monoclonal mast cell activation syndrome",
            "CommunityRAF": 0.521,
        },
        "D8942": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Idiopathic mast cell activation syndrome",
            "CommunityRAF": 0.521,
        },
        "D8943": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Secondary mast cell activation",
            "CommunityRAF": 0.521,
        },
        "D8949": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other mast cell activation disorder",
            "CommunityRAF": 0.521,
        },
        "D89810": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Acute graft-versus-host disease",
            "CommunityRAF": 0.521,
        },
        "D89811": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Chronic graft-versus-host disease",
            "CommunityRAF": 0.521,
        },
        "D89812": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Acute on chronic graft-versus-host disease",
            "CommunityRAF": 0.521,
        },
        "D89813": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Graft-versus-host disease, unspecified",
            "CommunityRAF": 0.521,
        },
        "D8982": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Autoimmune lymphoproliferative syndrome [ALPS]",
            "CommunityRAF": 0.521,
        },
        "D8989": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Other specified disorders involving the immune mechanism, not elsewhere classified",
            "CommunityRAF": 0.521,
        },
        "D899": {
            "HCC": "Disorders of Immunity",
            "ICD10": "Disorder involving the immune mechanism, unspecified",
            "CommunityRAF": 0.521,
        },
        "C946": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Myelodysplastic disease, not classified",
            "CommunityRAF": 0.252,
        },
        "D45": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Polycythemia vera",
            "CommunityRAF": 0.252,
        },
        "D471": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Chronic myeloproliferative disease",
            "CommunityRAF": 0.252,
        },
        "D473": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Essential (hemorrhagic) thrombocythemia",
            "CommunityRAF": 0.252,
        },
        "D479": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Neoplasm of uncertain behavior of lymphoid, hematopoietic and related tissue, unspecified",
            "CommunityRAF": 0.252,
        },
        "D47Z1": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Post-transplant lymphoproliferative disorder (PTLD)",
            "CommunityRAF": 0.252,
        },
        "D47Z2": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Castleman disease",
            "CommunityRAF": 0.252,
        },
        "D47Z9": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other specified neoplasms of uncertain behavior of lymphoid, hematopoietic and related tissue",
            "CommunityRAF": 0.252,
        },
        "D550": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Anemia due to glucose-6-phosphate dehydrogenase [G6PD] deficiency",
            "CommunityRAF": 0.252,
        },
        "D551": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Anemia due to other disorders of glutathione metabolism",
            "CommunityRAF": 0.252,
        },
        "D552": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Anemia due to disorders of glycolytic enzymes",
            "CommunityRAF": 0.252,
        },
        "D553": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Anemia due to disorders of nucleotide metabolism",
            "CommunityRAF": 0.252,
        },
        "D558": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other anemias due to enzyme disorders",
            "CommunityRAF": 0.252,
        },
        "D559": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Anemia due to enzyme disorder, unspecified",
            "CommunityRAF": 0.252,
        },
        "D560": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Alpha thalassemia",
            "CommunityRAF": 0.252,
        },
        "D561": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Beta thalassemia",
            "CommunityRAF": 0.252,
        },
        "D562": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Delta-beta thalassemia",
            "CommunityRAF": 0.252,
        },
        "D564": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hereditary persistence of fetal hemoglobin [HPFH]",
            "CommunityRAF": 0.252,
        },
        "D565": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hemoglobin E-beta thalassemia",
            "CommunityRAF": 0.252,
        },
        "D568": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other thalassemias",
            "CommunityRAF": 0.252,
        },
        "D573": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Sickle-cell trait",
            "CommunityRAF": 0.252,
        },
        "D580": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hereditary spherocytosis",
            "CommunityRAF": 0.252,
        },
        "D581": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hereditary elliptocytosis",
            "CommunityRAF": 0.252,
        },
        "D582": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other hemoglobinopathies",
            "CommunityRAF": 0.252,
        },
        "D588": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other specified hereditary hemolytic anemias",
            "CommunityRAF": 0.252,
        },
        "D589": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hereditary hemolytic anemia, unspecified",
            "CommunityRAF": 0.252,
        },
        "D640": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hereditary sideroblastic anemia",
            "CommunityRAF": 0.252,
        },
        "D641": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Secondary sideroblastic anemia due to disease",
            "CommunityRAF": 0.252,
        },
        "D642": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Secondary sideroblastic anemia due to drugs and toxins",
            "CommunityRAF": 0.252,
        },
        "D643": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other sideroblastic anemias",
            "CommunityRAF": 0.252,
        },
        "D65": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Disseminated intravascular coagulation [defibrination syndrome]",
            "CommunityRAF": 0.252,
        },
        "D680": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Von Willebrand's disease",
            "CommunityRAF": 0.252,
        },
        "D681": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hereditary factor XI deficiency",
            "CommunityRAF": 0.252,
        },
        "D682": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hereditary deficiency of other clotting factors",
            "CommunityRAF": 0.252,
        },
        "D68311": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Acquired hemophilia",
            "CommunityRAF": 0.252,
        },
        "D68312": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Antiphospholipid antibody with hemorrhagic disorder",
            "CommunityRAF": 0.252,
        },
        "D68318": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other hemorrhagic disorder due to intrinsic circulating anticoagulants, antibodies, or inhibitors",
            "CommunityRAF": 0.252,
        },
        "D6832": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hemorrhagic disorder due to extrinsic circulating anticoagulants",
            "CommunityRAF": 0.252,
        },
        "D684": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Acquired coagulation factor deficiency",
            "CommunityRAF": 0.252,
        },
        "D6851": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Activated protein C resistance",
            "CommunityRAF": 0.252,
        },
        "D6852": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Prothrombin gene mutation",
            "CommunityRAF": 0.252,
        },
        "D6859": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other primary thrombophilia",
            "CommunityRAF": 0.252,
        },
        "D6861": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Antiphospholipid syndrome",
            "CommunityRAF": 0.252,
        },
        "D6862": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Lupus anticoagulant syndrome",
            "CommunityRAF": 0.252,
        },
        "D6869": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other thrombophilia",
            "CommunityRAF": 0.252,
        },
        "D688": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other specified coagulation defects",
            "CommunityRAF": 0.252,
        },
        "D689": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Coagulation defect, unspecified",
            "CommunityRAF": 0.252,
        },
        "D690": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Allergic purpura",
            "CommunityRAF": 0.252,
        },
        "D691": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Qualitative platelet defects",
            "CommunityRAF": 0.252,
        },
        "D692": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other nonthrombocytopenic purpura",
            "CommunityRAF": 0.252,
        },
        "D693": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Immune thrombocytopenic purpura",
            "CommunityRAF": 0.252,
        },
        "D6941": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Evans syndrome",
            "CommunityRAF": 0.252,
        },
        "D6942": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Congenital and hereditary thrombocytopenia purpura",
            "CommunityRAF": 0.252,
        },
        "D6949": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other primary thrombocytopenia",
            "CommunityRAF": 0.252,
        },
        "D696": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Thrombocytopenia, unspecified",
            "CommunityRAF": 0.252,
        },
        "D698": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Other specified hemorrhagic conditions",
            "CommunityRAF": 0.252,
        },
        "D699": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Hemorrhagic condition, unspecified",
            "CommunityRAF": 0.252,
        },
        "D7582": {
            "HCC": "Coagulation Defects and Other Specified Hematological Disorders",
            "ICD10": "Heparin induced thrombocytopenia (HIT)",
            "CommunityRAF": 0.252,
        },
        "F10150": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol abuse with alcohol-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F10151": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol abuse with alcohol-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F10159": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol abuse with alcohol-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F10231": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol dependence with withdrawal delirium",
            "CommunityRAF": 0.420,
        },
        "F10232": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol dependence with withdrawal with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F10250": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol dependence with alcohol-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F10251": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol dependence with alcohol-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F10259": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol dependence with alcohol-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1026": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol dependence with alcohol-induced persisting amnestic disorder",
            "CommunityRAF": 0.420,
        },
        "F1027": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol dependence with alcohol-induced persisting dementia",
            "CommunityRAF": 0.420,
        },
        "F10950": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol use, unspecified with alcohol-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F10951": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol use, unspecified with alcohol-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F10959": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol use, unspecified with alcohol-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1096": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol use, unspecified with alcohol-induced persisting amnestic disorder",
            "CommunityRAF": 0.420,
        },
        "F1097": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Alcohol use, unspecified with alcohol-induced persisting dementia",
            "CommunityRAF": 0.420,
        },
        "F11150": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Opioid abuse with opioid-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F11151": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Opioid abuse with opioid-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F11159": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Opioid abuse with opioid-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F11250": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Opioid dependence with opioid-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F11251": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Opioid dependence with opioid-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F11259": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Opioid dependence with opioid-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F11950": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Opioid use, unspecified with opioid-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F11951": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Opioid use, unspecified with opioid-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F11959": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Opioid use, unspecified with opioid-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F12150": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cannabis abuse with psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F12151": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cannabis abuse with psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F12159": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cannabis abuse with psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F12250": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cannabis dependence with psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F12251": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cannabis dependence with psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F12259": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cannabis dependence with psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F12950": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cannabis use, unspecified with psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F12951": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cannabis use, unspecified with psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F12959": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cannabis use, unspecified with psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F13150": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F13151": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F13159": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F13231": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with withdrawal delirium",
            "CommunityRAF": 0.420,
        },
        "F13232": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with withdrawal with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F13250": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F13251": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F13259": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1326": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced persisting amnestic disorder",
            "CommunityRAF": 0.420,
        },
        "F1327": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced persisting dementia",
            "CommunityRAF": 0.420,
        },
        "F13931": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with withdrawal delirium",
            "CommunityRAF": 0.420,
        },
        "F13932": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with withdrawal with perceptual disturbances",
            "CommunityRAF": 0.420,
        },
        "F13950": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F13951": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F13959": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1396": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced persisting amnestic disorder",
            "CommunityRAF": 0.420,
        },
        "F1397": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced persisting dementia",
            "CommunityRAF": 0.420,
        },
        "F14150": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cocaine abuse with cocaine-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F14151": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cocaine abuse with cocaine-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F14159": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cocaine abuse with cocaine-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F14250": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cocaine dependence with cocaine-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F14251": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cocaine dependence with cocaine-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F14259": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cocaine dependence with cocaine-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F14950": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cocaine use, unspecified with cocaine-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F14951": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cocaine use, unspecified with cocaine-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F14959": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Cocaine use, unspecified with cocaine-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F15150": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other stimulant abuse with stimulant-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F15151": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other stimulant abuse with stimulant-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F15159": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other stimulant abuse with stimulant-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F15250": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other stimulant dependence with stimulant-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F15251": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other stimulant dependence with stimulant-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F15259": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other stimulant dependence with stimulant-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F15950": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other stimulant use, unspecified with stimulant-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F15951": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other stimulant use, unspecified with stimulant-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F15959": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other stimulant use, unspecified with stimulant-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F16150": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Hallucinogen abuse with hallucinogen-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F16151": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Hallucinogen abuse with hallucinogen-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F16159": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Hallucinogen abuse with hallucinogen-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F16250": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Hallucinogen dependence with hallucinogen-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F16251": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Hallucinogen dependence with hallucinogen-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F16259": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Hallucinogen dependence with hallucinogen-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F16950": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Hallucinogen use, unspecified with hallucinogen-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F16951": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Hallucinogen use, unspecified with hallucinogen-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F16959": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Hallucinogen use, unspecified with hallucinogen-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F18150": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant abuse with inhalant-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F18151": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant abuse with inhalant-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F18159": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant abuse with inhalant-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1817": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant abuse with inhalant-induced dementia",
            "CommunityRAF": 0.420,
        },
        "F18250": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant dependence with inhalant-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F18251": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant dependence with inhalant-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F18259": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant dependence with inhalant-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1827": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant dependence with inhalant-induced dementia",
            "CommunityRAF": 0.420,
        },
        "F18950": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant use, unspecified with inhalant-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F18951": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant use, unspecified with inhalant-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F18959": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant use, unspecified with inhalant-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1897": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Inhalant use, unspecified with inhalant-induced persisting dementia",
            "CommunityRAF": 0.420,
        },
        "F19150": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance abuse with psychoactive substance-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F19151": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance abuse with psychoactive substance-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F19159": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance abuse with psychoactive substance-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1916": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance abuse with psychoactive substance-induced persisting amnestic disorder",
            "CommunityRAF": 0.420,
        },
        "F1917": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance abuse with psychoactive substance-induced persisting dementia",
            "CommunityRAF": 0.420,
        },
        "F19231": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance dependence with withdrawal delirium",
            "CommunityRAF": 0.420,
        },
        "F19232": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance dependence with withdrawal with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F19250": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance dependence with psychoactive substance-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F19251": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance dependence with psychoactive substance-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F19259": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance dependence with psychoactive substance-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1926": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance dependence with psychoactive substance-induced persisting amnestic disorder",
            "CommunityRAF": 0.420,
        },
        "F1927": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance dependence with psychoactive substance-induced persisting dementia",
            "CommunityRAF": 0.420,
        },
        "F19931": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance use, unspecified with withdrawal delirium",
            "CommunityRAF": 0.420,
        },
        "F19932": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance use, unspecified with withdrawal with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F19950": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance use, unspecified with psychoactive substance-induced psychotic disorder with delusions",
            "CommunityRAF": 0.420,
        },
        "F19951": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance use, unspecified with psychoactive substance-induced psychotic disorder with hallucinations",
            "CommunityRAF": 0.420,
        },
        "F19959": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance use, unspecified with psychoactive substance-induced psychotic disorder, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1996": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance use, unspecified with psychoactive substance-induced persisting amnestic disorder",
            "CommunityRAF": 0.420,
        },
        "F1997": {
            "HCC": "Drug/Alcohol Psychosis",
            "ICD10": "Other psychoactive substance use, unspecified with psychoactive substance-induced persisting dementia",
            "CommunityRAF": 0.420,
        },
        "F10120": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol abuse with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F10121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol abuse with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F10129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol abuse with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1014": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol abuse with alcohol-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F10180": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol abuse with alcohol-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F10181": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol abuse with alcohol-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F10182": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol abuse with alcohol-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F10188": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol abuse with other alcohol-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1019": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol abuse with unspecified alcohol-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1020": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F1021": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence, in remission",
            "CommunityRAF": 0.420,
        },
        "F10220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F10221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F10229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F10230": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with withdrawal, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F10239": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with withdrawal, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1024": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with alcohol-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F10280": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with alcohol-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F10281": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with alcohol-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F10282": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with alcohol-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F10288": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with other alcohol-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1029": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol dependence with unspecified alcohol-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F10920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol use, unspecified with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F10921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol use, unspecified with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F10929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol use, unspecified with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1094": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol use, unspecified with alcohol-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F10980": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol use, unspecified with alcohol-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F10981": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol use, unspecified with alcohol-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F10982": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol use, unspecified with alcohol-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F10988": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol use, unspecified with other alcohol-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1099": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Alcohol use, unspecified with unspecified alcohol-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F11120": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid abuse with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F11121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid abuse with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F11122": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid abuse with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F11129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid abuse with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1114": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid abuse with opioid-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F11181": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid abuse with opioid-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F11182": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid abuse with opioid-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F11188": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid abuse with other opioid-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1119": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid abuse with unspecified opioid-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1120": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F1121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence, in remission",
            "CommunityRAF": 0.420,
        },
        "F11220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F11221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F11222": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F11229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1123": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with withdrawal",
            "CommunityRAF": 0.420,
        },
        "F1124": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with opioid-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F11281": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with opioid-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F11282": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with opioid-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F11288": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with other opioid-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid dependence with unspecified opioid-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F11920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F11921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F11922": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F11929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1193": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with withdrawal",
            "CommunityRAF": 0.420,
        },
        "F1194": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with opioid-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F11981": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with opioid-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F11982": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with opioid-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F11988": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with other opioid-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1199": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Opioid use, unspecified with unspecified opioid-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F12120": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis abuse with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F12121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis abuse with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F12122": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis abuse with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F12129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis abuse with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F12180": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis abuse with cannabis-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F12188": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis abuse with other cannabis-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1219": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis abuse with unspecified cannabis-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis dependence, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F1221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis dependence, in remission",
            "CommunityRAF": 0.420,
        },
        "F12220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis dependence with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F12221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis dependence with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F12222": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis dependence with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F12229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis dependence with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F12280": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis dependence with cannabis-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F12288": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis dependence with other cannabis-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis dependence with unspecified cannabis-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F12920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis use, unspecified with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F12921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis use, unspecified with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F12922": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis use, unspecified with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F12929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis use, unspecified with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F12980": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis use, unspecified with anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F12988": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis use, unspecified with other cannabis-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1299": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cannabis use, unspecified with unspecified cannabis-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F13120": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F13121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F13129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1314": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F13180": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F13181": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F13182": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with sedative, hypnotic or anxiolytic-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F13188": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with other sedative, hypnotic or anxiolytic-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1319": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic abuse with unspecified sedative, hypnotic or anxiolytic-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1320": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F1321": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence, in remission",
            "CommunityRAF": 0.420,
        },
        "F13220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F13221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F13229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F13230": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with withdrawal, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F13239": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with withdrawal, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1324": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F13280": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F13281": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F13282": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with sedative, hypnotic or anxiolytic-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F13288": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with other sedative, hypnotic or anxiolytic-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1329": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic dependence with unspecified sedative, hypnotic or anxiolytic-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F13920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F13921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F13929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F13930": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with withdrawal, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F13939": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with withdrawal, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1394": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F13980": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F13981": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F13982": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with sedative, hypnotic or anxiolytic-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F13988": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with other sedative, hypnotic or anxiolytic-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1399": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Sedative, hypnotic or anxiolytic use, unspecified with unspecified sedative, hypnotic or anxiolytic-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F14120": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F14121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with intoxication with delirium",
            "CommunityRAF": 0.420,
        },
        "F14122": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F14129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1414": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with cocaine-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F14180": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with cocaine-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F14181": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with cocaine-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F14182": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with cocaine-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F14188": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with other cocaine-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1419": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine abuse with unspecified cocaine-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1420": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F1421": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence, in remission",
            "CommunityRAF": 0.420,
        },
        "F14220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F14221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F14222": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F14229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1423": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with withdrawal",
            "CommunityRAF": 0.420,
        },
        "F1424": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with cocaine-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F14280": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with cocaine-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F14281": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with cocaine-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F14282": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with cocaine-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F14288": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with other cocaine-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1429": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine dependence with unspecified cocaine-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F14920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F14921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F14922": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F14929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1494": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with cocaine-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F14980": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with cocaine-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F14981": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with cocaine-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F14982": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with cocaine-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F14988": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with other cocaine-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1499": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Cocaine use, unspecified with unspecified cocaine-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F15120": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F15121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F15122": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F15129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1514": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with stimulant-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F15180": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with stimulant-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F15181": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with stimulant-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F15182": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with stimulant-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F15188": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with other stimulant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1519": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant abuse with unspecified stimulant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1520": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F1521": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence, in remission",
            "CommunityRAF": 0.420,
        },
        "F15220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F15221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F15222": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F15229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1523": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with withdrawal",
            "CommunityRAF": 0.420,
        },
        "F1524": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with stimulant-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F15280": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with stimulant-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F15281": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with stimulant-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F15282": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with stimulant-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F15288": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with other stimulant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1529": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant dependence with unspecified stimulant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F15920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F15921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F15922": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F15929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1593": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with withdrawal",
            "CommunityRAF": 0.420,
        },
        "F1594": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with stimulant-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F15980": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with stimulant-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F15981": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with stimulant-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F15982": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with stimulant-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F15988": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with other stimulant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1599": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other stimulant use, unspecified with unspecified stimulant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F16120": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen abuse with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F16121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen abuse with intoxication with delirium",
            "CommunityRAF": 0.420,
        },
        "F16122": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen abuse with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F16129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen abuse with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1614": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen abuse with hallucinogen-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F16180": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen abuse with hallucinogen-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F16183": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen abuse with hallucinogen persisting perception disorder (flashbacks)",
            "CommunityRAF": 0.420,
        },
        "F16188": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen abuse with other hallucinogen-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1619": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen abuse with unspecified hallucinogen-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1620": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F1621": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence, in remission",
            "CommunityRAF": 0.420,
        },
        "F16220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F16221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence with intoxication with delirium",
            "CommunityRAF": 0.420,
        },
        "F16229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1624": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence with hallucinogen-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F16280": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence with hallucinogen-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F16283": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence with hallucinogen persisting perception disorder (flashbacks)",
            "CommunityRAF": 0.420,
        },
        "F16288": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence with other hallucinogen-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1629": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen dependence with unspecified hallucinogen-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F16920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen use, unspecified with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F16921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen use, unspecified with intoxication with delirium",
            "CommunityRAF": 0.420,
        },
        "F16929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen use, unspecified with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1694": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen use, unspecified with hallucinogen-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F16980": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen use, unspecified with hallucinogen-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F16983": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen use, unspecified with hallucinogen persisting perception disorder (flashbacks)",
            "CommunityRAF": 0.420,
        },
        "F16988": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen use, unspecified with other hallucinogen-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1699": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Hallucinogen use, unspecified with unspecified hallucinogen-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F18120": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant abuse with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F18121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant abuse with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F18129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant abuse with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1814": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant abuse with inhalant-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F18180": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant abuse with inhalant-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F18188": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant abuse with other inhalant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1819": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant abuse with unspecified inhalant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1820": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant dependence, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F1821": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant dependence, in remission",
            "CommunityRAF": 0.420,
        },
        "F18220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant dependence with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F18221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant dependence with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F18229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant dependence with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1824": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant dependence with inhalant-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F18280": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant dependence with inhalant-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F18288": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant dependence with other inhalant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1829": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant dependence with unspecified inhalant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F18920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant use, unspecified with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F18921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant use, unspecified with intoxication with delirium",
            "CommunityRAF": 0.420,
        },
        "F18929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant use, unspecified with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1894": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant use, unspecified with inhalant-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F18980": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant use, unspecified with inhalant-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F18988": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant use, unspecified with other inhalant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1899": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Inhalant use, unspecified with unspecified inhalant-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F19121": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance abuse with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F19122": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance abuse with intoxication with perceptual disturbances",
            "CommunityRAF": 0.420,
        },
        "F19129": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance abuse with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1914": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance abuse with psychoactive substance-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F19180": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance abuse with psychoactive substance-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F19181": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance abuse with psychoactive substance-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F19182": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance abuse with psychoactive substance-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F19188": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance abuse with other psychoactive substance-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1919": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance abuse with unspecified psychoactive substance-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F1921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence, in remission",
            "CommunityRAF": 0.420,
        },
        "F19220": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F19221": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with intoxication delirium",
            "CommunityRAF": 0.420,
        },
        "F19222": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F19229": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F19230": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with withdrawal, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F19239": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with withdrawal, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1924": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with psychoactive substance-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F19280": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with psychoactive substance-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F19281": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with psychoactive substance-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F19282": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with psychoactive substance-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F19288": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with other psychoactive substance-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance dependence with unspecified psychoactive substance-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F19920": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with intoxication, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F19921": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with intoxication with delirium",
            "CommunityRAF": 0.420,
        },
        "F19922": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with intoxication with perceptual disturbance",
            "CommunityRAF": 0.420,
        },
        "F19929": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with intoxication, unspecified",
            "CommunityRAF": 0.420,
        },
        "F19930": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with withdrawal, uncomplicated",
            "CommunityRAF": 0.420,
        },
        "F19939": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with withdrawal, unspecified",
            "CommunityRAF": 0.420,
        },
        "F1994": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with psychoactive substance-induced mood disorder",
            "CommunityRAF": 0.420,
        },
        "F19980": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with psychoactive substance-induced anxiety disorder",
            "CommunityRAF": 0.420,
        },
        "F19981": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with psychoactive substance-induced sexual dysfunction",
            "CommunityRAF": 0.420,
        },
        "F19982": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with psychoactive substance-induced sleep disorder",
            "CommunityRAF": 0.420,
        },
        "F19988": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with other psychoactive substance-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F1999": {
            "HCC": "Drug/Alcohol Dependence",
            "ICD10": "Other psychoactive substance use, unspecified with unspecified psychoactive substance-induced disorder",
            "CommunityRAF": 0.420,
        },
        "F200": {
            "HCC": "Schizophrenia",
            "ICD10": "Paranoid schizophrenia",
            "CommunityRAF": 0.503,
        },
        "F201": {
            "HCC": "Schizophrenia",
            "ICD10": "Disorganized schizophrenia",
            "CommunityRAF": 0.503,
        },
        "F202": {
            "HCC": "Schizophrenia",
            "ICD10": "Catatonic schizophrenia",
            "CommunityRAF": 0.503,
        },
        "F203": {
            "HCC": "Schizophrenia",
            "ICD10": "Undifferentiated schizophrenia",
            "CommunityRAF": 0.503,
        },
        "F205": {
            "HCC": "Schizophrenia",
            "ICD10": "Residual schizophrenia",
            "CommunityRAF": 0.503,
        },
        "F2081": {
            "HCC": "Schizophrenia",
            "ICD10": "Schizophreniform disorder",
            "CommunityRAF": 0.503,
        },
        "F2089": {
            "HCC": "Schizophrenia",
            "ICD10": "Other schizophrenia",
            "CommunityRAF": 0.503,
        },
        "F209": {
            "HCC": "Schizophrenia",
            "ICD10": "Schizophrenia, unspecified",
            "CommunityRAF": 0.503,
        },
        "F250": {
            "HCC": "Schizophrenia",
            "ICD10": "Schizoaffective disorder, bipolar type",
            "CommunityRAF": 0.503,
        },
        "F251": {
            "HCC": "Schizophrenia",
            "ICD10": "Schizoaffective disorder, depressive type",
            "CommunityRAF": 0.503,
        },
        "F258": {
            "HCC": "Schizophrenia",
            "ICD10": "Other schizoaffective disorders",
            "CommunityRAF": 0.503,
        },
        "F259": {
            "HCC": "Schizophrenia",
            "ICD10": "Schizoaffective disorder, unspecified",
            "CommunityRAF": 0.503,
        },
        "F22": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Delusional disorders",
            "CommunityRAF": 0.330,
        },
        "F24": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Shared psychotic disorder",
            "CommunityRAF": 0.330,
        },
        "F3010": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Manic episode without psychotic symptoms, unspecified",
            "CommunityRAF": 0.330,
        },
        "F3011": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Manic episode without psychotic symptoms, mild",
            "CommunityRAF": 0.330,
        },
        "F3012": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Manic episode without psychotic symptoms, moderate",
            "CommunityRAF": 0.330,
        },
        "F3013": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Manic episode, severe, without psychotic symptoms",
            "CommunityRAF": 0.330,
        },
        "F302": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Manic episode, severe with psychotic symptoms",
            "CommunityRAF": 0.330,
        },
        "F303": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Manic episode in partial remission",
            "CommunityRAF": 0.330,
        },
        "F304": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Manic episode in full remission",
            "CommunityRAF": 0.330,
        },
        "F308": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Other manic episodes",
            "CommunityRAF": 0.330,
        },
        "F309": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Manic episode, unspecified",
            "CommunityRAF": 0.330,
        },
        "F310": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode hypomanic",
            "CommunityRAF": 0.330,
        },
        "F3110": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode manic without psychotic features, unspecified",
            "CommunityRAF": 0.330,
        },
        "F3111": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode manic without psychotic features, mild",
            "CommunityRAF": 0.330,
        },
        "F3112": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode manic without psychotic features, moderate",
            "CommunityRAF": 0.330,
        },
        "F3113": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode manic without psychotic features, severe",
            "CommunityRAF": 0.330,
        },
        "F312": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode manic severe with psychotic features",
            "CommunityRAF": 0.330,
        },
        "F3130": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode depressed, mild or moderate severity, unspecified",
            "CommunityRAF": 0.330,
        },
        "F3131": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode depressed, mild",
            "CommunityRAF": 0.330,
        },
        "F3132": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode depressed, moderate",
            "CommunityRAF": 0.330,
        },
        "F314": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode depressed, severe, without psychotic features",
            "CommunityRAF": 0.330,
        },
        "F315": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode depressed, severe, with psychotic features",
            "CommunityRAF": 0.330,
        },
        "F3160": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode mixed, unspecified",
            "CommunityRAF": 0.330,
        },
        "F3161": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode mixed, mild",
            "CommunityRAF": 0.330,
        },
        "F3162": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode mixed, moderate",
            "CommunityRAF": 0.330,
        },
        "F3163": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode mixed, severe, without psychotic features",
            "CommunityRAF": 0.330,
        },
        "F3164": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, current episode mixed, severe, with psychotic features",
            "CommunityRAF": 0.330,
        },
        "F3170": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, currently in remission, most recent episode unspecified",
            "CommunityRAF": 0.330,
        },
        "F3171": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, in partial remission, most recent episode hypomanic",
            "CommunityRAF": 0.330,
        },
        "F3172": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, in full remission, most recent episode hypomanic",
            "CommunityRAF": 0.330,
        },
        "F3173": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, in partial remission, most recent episode manic",
            "CommunityRAF": 0.330,
        },
        "F3174": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, in full remission, most recent episode manic",
            "CommunityRAF": 0.330,
        },
        "F3175": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, in partial remission, most recent episode depressed",
            "CommunityRAF": 0.330,
        },
        "F3176": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, in full remission, most recent episode depressed",
            "CommunityRAF": 0.330,
        },
        "F3177": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, in partial remission, most recent episode mixed",
            "CommunityRAF": 0.330,
        },
        "F3178": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, in full remission, most recent episode mixed",
            "CommunityRAF": 0.330,
        },
        "F3181": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar II disorder",
            "CommunityRAF": 0.330,
        },
        "F3189": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Other bipolar disorder",
            "CommunityRAF": 0.330,
        },
        "F319": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Bipolar disorder, unspecified",
            "CommunityRAF": 0.330,
        },
        "F320": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, single episode, mild",
            "CommunityRAF": 0.330,
        },
        "F321": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, single episode, moderate",
            "CommunityRAF": 0.330,
        },
        "F322": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, single episode, severe without psychotic features",
            "CommunityRAF": 0.330,
        },
        "F323": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, single episode, severe with psychotic features",
            "CommunityRAF": 0.330,
        },
        "F324": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, single episode, in partial remission",
            "CommunityRAF": 0.330,
        },
        "F325": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, single episode, in full remission",
            "CommunityRAF": 0.330,
        },
        "F330": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, recurrent, mild",
            "CommunityRAF": 0.330,
        },
        "F331": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, recurrent, moderate",
            "CommunityRAF": 0.330,
        },
        "F332": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, recurrent severe without psychotic features",
            "CommunityRAF": 0.330,
        },
        "F333": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, recurrent, severe with psychotic symptoms",
            "CommunityRAF": 0.330,
        },
        "F3340": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, recurrent, in remission, unspecified",
            "CommunityRAF": 0.330,
        },
        "F3341": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, recurrent, in partial remission",
            "CommunityRAF": 0.330,
        },
        "F3342": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, recurrent, in full remission",
            "CommunityRAF": 0.330,
        },
        "F338": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Other recurrent depressive disorders",
            "CommunityRAF": 0.330,
        },
        "F339": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Major depressive disorder, recurrent, unspecified",
            "CommunityRAF": 0.330,
        },
        "F348": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Other persistent mood [affective] disorders",
            "CommunityRAF": 0.330,
        },
        "F3481": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Disruptive mood dysregulation disorder",
            "CommunityRAF": 0.330,
        },
        "F3489": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Other specified persistent mood disorders",
            "CommunityRAF": 0.330,
        },
        "F349": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Persistent mood [affective] disorder, unspecified",
            "CommunityRAF": 0.330,
        },
        "F39": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Unspecified mood [affective] disorder",
            "CommunityRAF": 0.330,
        },
        "T1491": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Suicide attempt",
            "CommunityRAF": 0.330,
        },
        "T360X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by penicillins, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T360X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by penicillins, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T361X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by cephalosporins and other beta-lactam antibiotics, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T361X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by cephalosporins and other beta-lactam antibiotics, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T362X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by chloramphenicol group, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T362X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by chloramphenicol group, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T363X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by macrolides, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T363X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by macrolides, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T364X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by tetracyclines, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T364X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by tetracyclines, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T365X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by aminoglycosides, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T365X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by aminoglycosides, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T366X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by rifampicins, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T366X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by rifampicins, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T367X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by antifungal antibiotics, systemically used, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T367X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by antifungal antibiotics, systemically used, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T368X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by other systemic antibiotics, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T368X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by other systemic antibiotics, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T3692XA": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by unspecified systemic antibiotic, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T3692XS": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by unspecified systemic antibiotic, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T370X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by sulfonamides, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T370X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by sulfonamides, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T371X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by antimycobacterial drugs, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T371X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by antimycobacterial drugs, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T372X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by antimalarials and drugs acting on other blood protozoa, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T372X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by antimalarials and drugs acting on other blood protozoa, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T373X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by other antiprotozoal drugs, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T373X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by other antiprotozoal drugs, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T374X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by anthelminthics, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T374X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by anthelminthics, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T375X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by antiviral drugs, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T375X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by antiviral drugs, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T378X2A": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by other specified systemic anti-infectives and antiparasitics, intentional self-harm, initial encounter",
            "CommunityRAF": 0.330,
        },
        "T378X2S": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
            "ICD10": "Poisoning by other specified systemic anti-infectives and antiparasitics, intentional self-harm, sequela",
            "CommunityRAF": 0.330,
        },
        "T3792XA": {
            "HCC": "Major Depressive, Bipolar, and Paranoid Disorders",
        