"use strict";
var _a, _b, _c, _d, _e;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuppressionIgnoreErrors = exports.SuppressionIgnoreNever = exports.SuppressionIgnoreAlways = exports.SuppressionIgnoreOr = exports.SuppressionIgnoreAnd = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const nag_rules_1 = require("./nag-rules");
/**
 * Ignore the suppression if all of the given INagSuppressionIgnore return a non-empty message
 */
class SuppressionIgnoreAnd {
    constructor(...SuppressionIgnoreAnds) {
        if (SuppressionIgnoreAnds.length === 0) {
            throw new Error('SuppressionIgnoreAnd needs at least one INagSuppressionIgnore');
        }
        this.andSuppressionIgnores = SuppressionIgnoreAnds;
    }
    createMessage(input) {
        let messages = [];
        for (const i of this.andSuppressionIgnores) {
            const m = i.createMessage(input);
            messages.push(m);
            if (!m) {
                return '';
            }
        }
        return messages.join('\n\t');
    }
}
exports.SuppressionIgnoreAnd = SuppressionIgnoreAnd;
_a = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreAnd[_a] = { fqn: "cdk-nag.SuppressionIgnoreAnd", version: "2.27.91" };
/**
 * Ignore the suppression if any of the given INagSuppressionIgnore return a non-empty message
 */
class SuppressionIgnoreOr {
    constructor(...orSuppressionIgnores) {
        if (orSuppressionIgnores.length === 0) {
            throw new Error('SuppressionIgnoreOr needs at least one INagSuppressionIgnore');
        }
        this.SuppressionIgnoreOrs = orSuppressionIgnores;
    }
    createMessage(input) {
        let messages = [];
        for (const i of this.SuppressionIgnoreOrs) {
            const m = i.createMessage(input);
            if (m) {
                messages.push(m);
            }
        }
        return messages ? messages.join('\n\t') : '';
    }
}
exports.SuppressionIgnoreOr = SuppressionIgnoreOr;
_b = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreOr[_b] = { fqn: "cdk-nag.SuppressionIgnoreOr", version: "2.27.91" };
/**
 * Always ignore the suppression
 */
class SuppressionIgnoreAlways {
    constructor(triggerMessage) {
        if (triggerMessage.length === 0) {
            throw new Error('provide a triggerMessage for the SuppressionIgnoreAlways');
        }
        this.triggerMessage = triggerMessage;
    }
    createMessage(_input) {
        return this.triggerMessage;
    }
}
exports.SuppressionIgnoreAlways = SuppressionIgnoreAlways;
_c = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreAlways[_c] = { fqn: "cdk-nag.SuppressionIgnoreAlways", version: "2.27.91" };
/**
 * Don't ignore the suppression
 */
class SuppressionIgnoreNever {
    createMessage(_input) {
        return '';
    }
}
exports.SuppressionIgnoreNever = SuppressionIgnoreNever;
_d = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreNever[_d] = { fqn: "cdk-nag.SuppressionIgnoreNever", version: "2.27.91" };
/**
 * Ignore Suppressions for Rules with a NagMessageLevel.ERROR
 */
class SuppressionIgnoreErrors {
    createMessage(input) {
        return input.ruleLevel == nag_rules_1.NagMessageLevel.ERROR
            ? `${input.ruleId} is categorized as an ERROR and may not be suppressed`
            : '';
    }
}
exports.SuppressionIgnoreErrors = SuppressionIgnoreErrors;
_e = JSII_RTTI_SYMBOL_1;
SuppressionIgnoreErrors[_e] = { fqn: "cdk-nag.SuppressionIgnoreErrors", version: "2.27.91" };
//# sourceMappingURL=data:application/json;base64,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