# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-20T11:57:09+00:00

from collections import defaultdict

from pydantic import model_serializer, model_validator


class GcSerializer:
    _serializers = defaultdict(list)
    _validators = defaultdict(list)

    @classmethod
    def add_serializer(cls, serializer_func):
        serializer_funcs = (
            serializer_func if isinstance(serializer_func, list) else [serializer_func]
        )
        cls._serializers[cls.__qualname__].extend(serializer_funcs)

    @classmethod
    def add_validator(cls, validator_func):
        validator_funcs = (
            validator_func if isinstance(validator_func, list) else [validator_func]
        )
        cls._validators[cls.__qualname__].extend(validator_funcs)

    @model_serializer(mode='wrap')
    def serialize_model(self, handler):
        model = handler(self)
        for serialize_func in self._serializers.get(self.__class__.__qualname__, []):
            # TO-DO : make sure serialize func returns proper model back
            # serialize func must be of proper structure
            model = serialize_func(model)
        return model

    @model_validator(mode='wrap')
    @classmethod
    def validate_model(cls, model, handler, info):
        for validate_func in cls._validators.get(cls.__qualname__, []):
            validate_func(model, handler, info)
        return handler(model)
