# generated by fastapi-codegen:
#   filename:  /home/circleci/project/guardicore/connector
#   timestamp: 2025-08-20T11:57:09+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from centra_sdk.gc_serializer import GcSerializer
from pydantic import AwareDatetime, BaseModel, ConfigDict, Field

from ..k8s.k8s_inventory import K8SData


class ItemType(Enum):
    ASSET = 'asset'


class Label(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    key: str
    value: str


class Type(Enum):
    VM = 'VM'


class AzureNetworkTopology(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    subscription: Optional[str] = None
    resource_group: Optional[str] = Field(None, alias='resource-group')
    region: Optional[str] = None
    resource_id: Optional[str] = Field(
        None,
        alias='resource-id',
        examples=[
            '/subscriptions/6974b4cf-6bf8-4454-8d22-a8f33084d699/resourceGroups/DEMO_SETUP/providers/Microsoft.Compute/virtualMachines/spoke1-vm'
        ],
    )
    instance_count: Optional[int] = Field(None, alias='instance-count')


class AWSNetworkTopology(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    account_id: Optional[str] = Field(None, alias='account-id')
    resource_group: Optional[str] = Field(None, alias='resource-group')
    region: Optional[str] = None
    availability_zones: Optional[List[str]] = Field(
        None, alias='availability-zones', examples=[['us-east-1a', 'us-east-1b']]
    )
    resource_arn: Optional[str] = Field(
        None,
        alias='resource-arn',
        examples=[
            'arn:aws:lambda:ap-south-1:905418309376:function:GcappOnboardingServicevnjto4fk7zaw'
        ],
    )


class AzureNetworkAccess(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    public_access_enabled: Optional[bool] = Field(None, alias='public-access-enabled')
    private_access_enabled: Optional[bool] = Field(None, alias='private-access-enabled')
    service_endpoint_enabled: Optional[bool] = Field(
        None, alias='service-endpoint-enabled'
    )


class AWSNetworkAccess(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    public_access_enabled: Optional[bool] = Field(None, alias='public-access-enabled')
    private_access_enabled: Optional[bool] = Field(None, alias='private-access-enabled')


class NetworkInterfaceData(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    id: Optional[str] = Field(
        None, description='nic id, managed as resource id in Azure'
    )
    mac_address: str = Field(..., alias='mac-address')
    network: str
    subnet_id: str = Field(..., alias='subnet-id')
    private_ip_addresses: Optional[List[str]] = Field(
        None, alias='private-ip-addresses'
    )
    public_ip_addresses: Optional[List[str]] = Field(None, alias='public-ip-addresses')
    vlan: Optional[int] = None
    vrf: Optional[str] = None


class OnlineStatus(Enum):
    ONLINE = 'online'
    OFFLINE = 'offline'


class PowerState(Enum):
    RUNNING = 'running'
    STOPPED = 'stopped'
    RESTARTING = 'restarting'


class RegistrationStatus(Enum):
    REGISTERED = 'registered'
    UNREGISTERED = 'unregistered'


class Type1(Enum):
    MS = 'MS'


class ManagedServiceData(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Type1
    nics: Optional[List[NetworkInterfaceData]] = None
    network_topology: Optional[
        Union[AzureNetworkTopology, AWSNetworkTopology, Dict[str, Any]]
    ] = Field(None, alias='network-topology')
    network_access: Optional[
        Union[AzureNetworkAccess, AWSNetworkAccess, Dict[str, Any]]
    ] = Field(None, alias='network-access')


class APISec(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    datatypes_tags: Optional[List[str]] = Field([], alias='datatypes-tags')
    hosts: Optional[List[str]] = []
    internet_facing: Optional[List[str]] = Field([], alias='internet-facing')
    authentication: Optional[List[str]] = []
    max_risk_score: Optional[float] = Field(0.0, alias='max-risk-score')
    infrastructure_tags: Optional[Dict[str, Any]] = Field(
        {}, alias='infrastructure-tags'
    )
    api_tags: Optional[List[str]] = Field([], alias='api-tags')
    api_groups: Optional[List[str]] = Field([], alias='api-groups')
    nn_url: Optional[str] = Field('', alias='nn-url')


class Type2(Enum):
    IOT = 'IOT'


class IOTRegistrationStatus(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    reg_status: Optional[RegistrationStatus] = Field(None, alias='reg-status')
    reg_date: Optional[AwareDatetime] = Field(None, alias='reg-date')
    unreg_date: Optional[AwareDatetime] = Field(None, alias='unreg-date')


class HardwareInfo(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    hw_class: Optional[str] = Field('unknown', alias='hw-class')
    hw_manufacturer: Optional[str] = Field('unknown', alias='hw-manufacturer')
    hw_type: Optional[str] = Field('unknown', alias='hw-type')
    bios_uuid: Optional[str] = Field('unknown', alias='bios-uuid')


class VMData(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Type
    os_details: Optional[Dict[str, Any]] = Field(None, alias='os-details')
    hw_details: Optional[HardwareInfo] = Field(None, alias='hw-details')
    nics: Optional[List[NetworkInterfaceData]] = None
    network_topology: Optional[
        Union[AzureNetworkTopology, AWSNetworkTopology, Dict[str, Any]]
    ] = Field(None, alias='network-topology')
    power_state: Optional[PowerState] = Field(None, alias='power-state')
    api_sec: Optional[APISec] = Field(None, alias='api-sec')


class IOT(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    type: Type2
    os_details: Optional[Dict[str, Any]] = Field(None, alias='os-details')
    hw_details: HardwareInfo = Field(..., alias='hw-details')
    nics: Optional[List[NetworkInterfaceData]] = None
    power_state: Optional[PowerState] = Field(None, alias='power-state')
    online_status: Optional[OnlineStatus] = Field(None, alias='online-status')
    registration_status: Optional[IOTRegistrationStatus] = Field(
        None, alias='registration-status'
    )
    device_score: Optional[str] = Field(None, alias='device-score')


class InventoryItem(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    item_type: Optional[ItemType] = Field(
        'asset',
        alias='item-type',
        description='inventory item type - currently asset only',
    )
    item_id: Optional[str] = Field(
        None, alias='item-id', description='inventory item id assigned by Centra'
    )
    external_ids: Optional[List[str]] = Field(
        None,
        alias='external-ids',
        description='list of external IDs that are managed by external asset management systems such as Azure resource management',
    )
    entity_type: Optional[str] = Field(
        None,
        alias='entity-type',
        description='asset type such as Virtual Machine or Azure SQL Server',
    )
    entity_category: Optional[str] = Field(
        None,
        alias='entity-category',
        description='asset category such as Compute or Database',
    )
    entity_name: Optional[str] = Field(
        None, alias='entity-name', description='asset name'
    )
    entity_data: Optional[
        Union[VMData, IOT, ManagedServiceData, K8SData, Dict[str, Any]]
    ] = Field(
        None,
        alias='entity-data',
        description='additional entity data depending on its type',
        union_mode='left_to_right',
    )
    labels: Optional[List[Label]] = None
    metadata_attributes: Optional[Dict[str, Any]] = Field(
        None, alias='metadata-attributes'
    )
