# generated by fastapi-codegen:
#   filename:  /home/circleci/project/guardicore/connector
#   timestamp: 2025-08-20T11:57:09+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from centra_sdk.gc_serializer import GcSerializer
from pydantic import BaseModel, ConfigDict, Field, RootModel

from ..common.inventory import InventoryItem, Label


class NetworkConnections(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    network: str
    reachable_networks: List[str] = Field(..., alias='reachable-networks')


class Labels(RootModel[List[Label]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[Label]

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item


class InventoryAssetType(Enum):
    VMS = 'vms'
    K8S_SERVICES = 'k8s_services'
    K8S_CONTROLLERS = 'k8s_controllers'
    K8S_CLUSTER = 'k8s_cluster'
    K8S_NODES = 'k8s_nodes'
    K8S_NAMESPACES = 'k8s_namespaces'


class InventoryReporterType(Enum):
    KUBERNETES = 'Kubernetes'


class V1ProviderInventoryIdAssetsAssetTypePostResponse(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    revision: Optional[int] = Field(None, description='the revision posted')
    type: Optional[str] = Field(None, description='the asset type')
    info: Optional[str] = None


class V1ProviderInventoryIdAssetsAssetTypePostResponse1(BaseModel, GcSerializer):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    error: Optional[str] = None


class NetworkTopology(RootModel[List[NetworkConnections]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[NetworkConnections]

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item


class Inventory(RootModel[List[InventoryItem]]):
    model_config = ConfigDict(
        populate_by_name=True,
    )
    root: List[InventoryItem]

    def __getattr__(self, attr: str):
        return getattr(self.root, attr)

    def __iter__(self):
        for item in self.root:
            yield item
