# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-20T11:57:09+00:00

from __future__ import annotations

from typing import Annotated

from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Control'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class ControlHandler:
    def __init__(self):
        pass

    def version_handshake(self, body: VersionHandshakeData) -> VersionHandshakeData:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"version_handshake not implemented"
        )


@router.post(
    '/version-handshake',
    response_model=VersionHandshakeData,
    responses={'401': {'model': UnauthorizedError}},
    tags=['Control'],
)
def version_handshake(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
    body: VersionHandshakeData,
) -> Union[VersionHandshakeData, UnauthorizedError]:
    """
    Perform version handshake
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(version_handshake.__name__, token, body)
