# generated by fastapi-codegen:
#   filename:  connector
#   timestamp: 2025-08-20T11:57:09+00:00

from __future__ import annotations

from typing import Annotated

from fastapi import APIRouter, Depends, HTTPException
from fastapi.security import HTTPAuthorizationCredentials, HTTPBearer

from ..dependencies import *
from ..handler_registry import HandlerRegistry

router = APIRouter(tags=['Health'])
security = HTTPBearer(auto_error=False)
registry = HandlerRegistry()


@registry.register()
class HealthHandler:
    def __init__(self):
        pass

    def get_integration_flags(
        self,
    ) -> V1OperationsFlagsGetResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_flags not implemented"
        )

    def get_integration_status(
        self,
    ) -> V1OperationsHealthGetResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_status not implemented"
        )

    def get_integration_metrics(
        self,
    ) -> V1OperationsMetricsGetResponse:
        """This method should be implemented by the subclass."""
        raise HTTPException(
            status_code=404, detail=f"get_integration_metrics not implemented"
        )


@router.get(
    '/v1/operations/flags', response_model=V1OperationsFlagsGetResponse, tags=['Health']
)
def get_integration_flags(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
) -> V1OperationsFlagsGetResponse:
    """
    Endpoint to retrieve components flags
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(
        get_integration_flags.__name__,
        token,
    )


@router.get(
    '/v1/operations/health',
    response_model=V1OperationsHealthGetResponse,
    tags=['Health'],
)
def get_integration_status(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
) -> V1OperationsHealthGetResponse:
    """
    Endpoint to retrieve components status
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(
        get_integration_status.__name__,
        token,
    )


@router.get(
    '/v1/operations/metrics',
    response_model=V1OperationsMetricsGetResponse,
    tags=['Health'],
)
def get_integration_metrics(
    credentials: Annotated[HTTPAuthorizationCredentials, Depends(security)],
) -> V1OperationsMetricsGetResponse:
    """
    Endpoint to retrieve components metrics
    """

    token = credentials.credentials if credentials else None
    return registry.call_handler(
        get_integration_metrics.__name__,
        token,
    )
