# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AclAclEntryArgs',
    'AlbEipBillingConfigArgs',
    'AlbIpv6EipBillingConfigArgs',
    'AlbTagArgs',
    'AlbZoneMappingArgs',
    'AlbZoneMappingLoadBalancerAddressArgs',
    'AlbsTagArgs',
    'RuleRedirectConfigArgs',
    'RuleRewriteConfigArgs',
    'ServerGroupHealthCheckArgs',
    'ServerGroupStickySessionConfigArgs',
]

@pulumi.input_type
class AclAclEntryArgs:
    def __init__(__self__, *,
                 entry: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] entry: The content of the AclEntry.
        :param pulumi.Input[str] description: The description of the AclEntry.
        """
        pulumi.set(__self__, "entry", entry)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter
    def entry(self) -> pulumi.Input[str]:
        """
        The content of the AclEntry.
        """
        return pulumi.get(self, "entry")

    @entry.setter
    def entry(self, value: pulumi.Input[str]):
        pulumi.set(self, "entry", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the AclEntry.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class AlbEipBillingConfigArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[int],
                 eip_billing_type: pulumi.Input[str],
                 isp: pulumi.Input[str]):
        """
        :param pulumi.Input[int] bandwidth: The peek bandwidth of the Ipv6 EIP which automatically assigned to the Alb. Unit: Mbps.
        :param pulumi.Input[str] eip_billing_type: The billing type of the EIP which automatically assigned to the Alb. Valid values: `PostPaidByBandwidth`, `PostPaidByTraffic`.
        :param pulumi.Input[str] isp: The ISP of the Ipv6 EIP which automatically associated to the Alb, the value can be `BGP`.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "eip_billing_type", eip_billing_type)
        pulumi.set(__self__, "isp", isp)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[int]:
        """
        The peek bandwidth of the Ipv6 EIP which automatically assigned to the Alb. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[int]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="eipBillingType")
    def eip_billing_type(self) -> pulumi.Input[str]:
        """
        The billing type of the EIP which automatically assigned to the Alb. Valid values: `PostPaidByBandwidth`, `PostPaidByTraffic`.
        """
        return pulumi.get(self, "eip_billing_type")

    @eip_billing_type.setter
    def eip_billing_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "eip_billing_type", value)

    @property
    @pulumi.getter
    def isp(self) -> pulumi.Input[str]:
        """
        The ISP of the Ipv6 EIP which automatically associated to the Alb, the value can be `BGP`.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: pulumi.Input[str]):
        pulumi.set(self, "isp", value)


@pulumi.input_type
class AlbIpv6EipBillingConfigArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input[int],
                 billing_type: pulumi.Input[str],
                 isp: pulumi.Input[str]):
        """
        :param pulumi.Input[int] bandwidth: The peek bandwidth of the EIP which automatically assigned to the Alb. Unit: Mbps.
        :param pulumi.Input[str] billing_type: The billing type of the Tpv6 EIP which automatically assigned to the Alb. Valid values: `PostPaidByBandwidth`, `PostPaidByTraffic`.
        :param pulumi.Input[str] isp: The ISP of the EIP which automatically associated to the Alb, the value can be `BGP`.
               
               The `ipv6_eip_billing_config` object supports the following:
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "billing_type", billing_type)
        pulumi.set(__self__, "isp", isp)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input[int]:
        """
        The peek bandwidth of the EIP which automatically assigned to the Alb. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input[int]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Input[str]:
        """
        The billing type of the Tpv6 EIP which automatically assigned to the Alb. Valid values: `PostPaidByBandwidth`, `PostPaidByTraffic`.
        """
        return pulumi.get(self, "billing_type")

    @billing_type.setter
    def billing_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "billing_type", value)

    @property
    @pulumi.getter
    def isp(self) -> pulumi.Input[str]:
        """
        The ISP of the EIP which automatically associated to the Alb, the value can be `BGP`.

        The `ipv6_eip_billing_config` object supports the following:
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: pulumi.Input[str]):
        pulumi.set(self, "isp", value)


@pulumi.input_type
class AlbTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The Key of Tags.
        :param pulumi.Input[str] value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class AlbZoneMappingArgs:
    def __init__(__self__, *,
                 load_balancer_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['AlbZoneMappingLoadBalancerAddressArgs']]]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['AlbZoneMappingLoadBalancerAddressArgs']]] load_balancer_addresses: The IP address information of the Alb in this availability zone.
        :param pulumi.Input[str] subnet_id: The subnet id of the Alb in this availability zone.
        :param pulumi.Input[str] zone_id: The availability zone id of the Alb.
        """
        if load_balancer_addresses is not None:
            pulumi.set(__self__, "load_balancer_addresses", load_balancer_addresses)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="loadBalancerAddresses")
    def load_balancer_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbZoneMappingLoadBalancerAddressArgs']]]]:
        """
        The IP address information of the Alb in this availability zone.
        """
        return pulumi.get(self, "load_balancer_addresses")

    @load_balancer_addresses.setter
    def load_balancer_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbZoneMappingLoadBalancerAddressArgs']]]]):
        pulumi.set(self, "load_balancer_addresses", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet id of the Alb in this availability zone.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The availability zone id of the Alb.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


@pulumi.input_type
class AlbZoneMappingLoadBalancerAddressArgs:
    def __init__(__self__, *,
                 eip_address: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 eni_address: Optional[pulumi.Input[str]] = None,
                 eni_id: Optional[pulumi.Input[str]] = None,
                 eni_ipv6_address: Optional[pulumi.Input[str]] = None,
                 ipv6_eip_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] eip_address: The Eip address of the Alb in this availability zone.
        :param pulumi.Input[str] eip_id: The Eip id of alb instance in this availability zone.
        :param pulumi.Input[str] eni_address: The Eni address of the Alb in this availability zone.
        :param pulumi.Input[str] eni_id: The Eni id of the Alb in this availability zone.
        :param pulumi.Input[str] eni_ipv6_address: The Eni Ipv6 address of the Alb in this availability zone.
        :param pulumi.Input[str] ipv6_eip_id: The Ipv6 Eip id of alb instance in this availability zone.
        """
        if eip_address is not None:
            pulumi.set(__self__, "eip_address", eip_address)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if eni_address is not None:
            pulumi.set(__self__, "eni_address", eni_address)
        if eni_id is not None:
            pulumi.set(__self__, "eni_id", eni_id)
        if eni_ipv6_address is not None:
            pulumi.set(__self__, "eni_ipv6_address", eni_ipv6_address)
        if ipv6_eip_id is not None:
            pulumi.set(__self__, "ipv6_eip_id", ipv6_eip_id)

    @property
    @pulumi.getter(name="eipAddress")
    def eip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The Eip address of the Alb in this availability zone.
        """
        return pulumi.get(self, "eip_address")

    @eip_address.setter
    def eip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_address", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Eip id of alb instance in this availability zone.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="eniAddress")
    def eni_address(self) -> Optional[pulumi.Input[str]]:
        """
        The Eni address of the Alb in this availability zone.
        """
        return pulumi.get(self, "eni_address")

    @eni_address.setter
    def eni_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_address", value)

    @property
    @pulumi.getter(name="eniId")
    def eni_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Eni id of the Alb in this availability zone.
        """
        return pulumi.get(self, "eni_id")

    @eni_id.setter
    def eni_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_id", value)

    @property
    @pulumi.getter(name="eniIpv6Address")
    def eni_ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The Eni Ipv6 address of the Alb in this availability zone.
        """
        return pulumi.get(self, "eni_ipv6_address")

    @eni_ipv6_address.setter
    def eni_ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eni_ipv6_address", value)

    @property
    @pulumi.getter(name="ipv6EipId")
    def ipv6_eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Ipv6 Eip id of alb instance in this availability zone.
        """
        return pulumi.get(self, "ipv6_eip_id")

    @ipv6_eip_id.setter
    def ipv6_eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_eip_id", value)


@pulumi.input_type
class AlbsTagArgs:
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: str):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RuleRedirectConfigArgs:
    def __init__(__self__, *,
                 redirect_domain: Optional[pulumi.Input[str]] = None,
                 redirect_http_code: Optional[pulumi.Input[str]] = None,
                 redirect_port: Optional[pulumi.Input[str]] = None,
                 redirect_protocol: Optional[pulumi.Input[str]] = None,
                 redirect_uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] redirect_domain: The redirect domain, only support exact domain name.
        :param pulumi.Input[str] redirect_http_code: The redirect http code, support 301(default), 302, 307, 308.
        :param pulumi.Input[str] redirect_port: The redirect port.
        :param pulumi.Input[str] redirect_protocol: The redirect protocol, support HTTP, HTTPS(default).
        :param pulumi.Input[str] redirect_uri: The redirect URI.
        """
        if redirect_domain is not None:
            pulumi.set(__self__, "redirect_domain", redirect_domain)
        if redirect_http_code is not None:
            pulumi.set(__self__, "redirect_http_code", redirect_http_code)
        if redirect_port is not None:
            pulumi.set(__self__, "redirect_port", redirect_port)
        if redirect_protocol is not None:
            pulumi.set(__self__, "redirect_protocol", redirect_protocol)
        if redirect_uri is not None:
            pulumi.set(__self__, "redirect_uri", redirect_uri)

    @property
    @pulumi.getter(name="redirectDomain")
    def redirect_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The redirect domain, only support exact domain name.
        """
        return pulumi.get(self, "redirect_domain")

    @redirect_domain.setter
    def redirect_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_domain", value)

    @property
    @pulumi.getter(name="redirectHttpCode")
    def redirect_http_code(self) -> Optional[pulumi.Input[str]]:
        """
        The redirect http code, support 301(default), 302, 307, 308.
        """
        return pulumi.get(self, "redirect_http_code")

    @redirect_http_code.setter
    def redirect_http_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_http_code", value)

    @property
    @pulumi.getter(name="redirectPort")
    def redirect_port(self) -> Optional[pulumi.Input[str]]:
        """
        The redirect port.
        """
        return pulumi.get(self, "redirect_port")

    @redirect_port.setter
    def redirect_port(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_port", value)

    @property
    @pulumi.getter(name="redirectProtocol")
    def redirect_protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The redirect protocol, support HTTP, HTTPS(default).
        """
        return pulumi.get(self, "redirect_protocol")

    @redirect_protocol.setter
    def redirect_protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_protocol", value)

    @property
    @pulumi.getter(name="redirectUri")
    def redirect_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The redirect URI.
        """
        return pulumi.get(self, "redirect_uri")

    @redirect_uri.setter
    def redirect_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "redirect_uri", value)


@pulumi.input_type
class RuleRewriteConfigArgs:
    def __init__(__self__, *,
                 rewrite_path: pulumi.Input[str]):
        """
        :param pulumi.Input[str] rewrite_path: Rewrite path.
        """
        pulumi.set(__self__, "rewrite_path", rewrite_path)

    @property
    @pulumi.getter(name="rewritePath")
    def rewrite_path(self) -> pulumi.Input[str]:
        """
        Rewrite path.
        """
        return pulumi.get(self, "rewrite_path")

    @rewrite_path.setter
    def rewrite_path(self, value: pulumi.Input[str]):
        pulumi.set(self, "rewrite_path", value)


@pulumi.input_type
class ServerGroupHealthCheckArgs:
    def __init__(__self__, *,
                 domain: Optional[pulumi.Input[str]] = None,
                 enabled: Optional[pulumi.Input[str]] = None,
                 healthy_threshold: Optional[pulumi.Input[int]] = None,
                 http_code: Optional[pulumi.Input[str]] = None,
                 http_version: Optional[pulumi.Input[str]] = None,
                 interval: Optional[pulumi.Input[int]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 timeout: Optional[pulumi.Input[int]] = None,
                 unhealthy_threshold: Optional[pulumi.Input[int]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] domain: The domain of health check.
        :param pulumi.Input[str] enabled: The enable status of health check function. Valid values: `on`, `off`. Default is `on`.
        :param pulumi.Input[int] healthy_threshold: The healthy threshold of health check. Valid value range in 2~10. Default is 3.
        :param pulumi.Input[str] http_code: The normal http status code of health check, the value can be `http_2xx` or `http_3xx` or `http_4xx` or `http_5xx`.
        :param pulumi.Input[str] http_version: The http version of health check. Valid values: `HTTP1.0`, `HTTP1.1`. Default is `HTTP1.0`.
        :param pulumi.Input[int] interval: The interval executing health check. Unit: second. Valid value range in 1~300. Default is 2.
        :param pulumi.Input[str] method: The method of health check. Valid values: `GET` or `HEAD`. Default is `HEAD`.
        :param pulumi.Input[int] timeout: The response timeout of health check. Unit: second. Valid value range in 1~60. Default is 2.
        :param pulumi.Input[int] unhealthy_threshold: The unhealthy threshold of health check. Valid value range in 2~10. Default is 3.
        :param pulumi.Input[str] uri: The uri of health check.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if http_code is not None:
            pulumi.set(__self__, "http_code", http_code)
        if http_version is not None:
            pulumi.set(__self__, "http_version", http_version)
        if interval is not None:
            pulumi.set(__self__, "interval", interval)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain of health check.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of health check function. Valid values: `on`, `off`. Default is `on`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The healthy threshold of health check. Valid value range in 2~10. Default is 3.
        """
        return pulumi.get(self, "healthy_threshold")

    @healthy_threshold.setter
    def healthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "healthy_threshold", value)

    @property
    @pulumi.getter(name="httpCode")
    def http_code(self) -> Optional[pulumi.Input[str]]:
        """
        The normal http status code of health check, the value can be `http_2xx` or `http_3xx` or `http_4xx` or `http_5xx`.
        """
        return pulumi.get(self, "http_code")

    @http_code.setter
    def http_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_code", value)

    @property
    @pulumi.getter(name="httpVersion")
    def http_version(self) -> Optional[pulumi.Input[str]]:
        """
        The http version of health check. Valid values: `HTTP1.0`, `HTTP1.1`. Default is `HTTP1.0`.
        """
        return pulumi.get(self, "http_version")

    @http_version.setter
    def http_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_version", value)

    @property
    @pulumi.getter
    def interval(self) -> Optional[pulumi.Input[int]]:
        """
        The interval executing health check. Unit: second. Valid value range in 1~300. Default is 2.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        The method of health check. Valid values: `GET` or `HEAD`. Default is `HEAD`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The response timeout of health check. Unit: second. Valid value range in 1~60. Default is 2.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "timeout", value)

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        The unhealthy threshold of health check. Valid value range in 2~10. Default is 3.
        """
        return pulumi.get(self, "unhealthy_threshold")

    @unhealthy_threshold.setter
    def unhealthy_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "unhealthy_threshold", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        """
        The uri of health check.
        """
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class ServerGroupStickySessionConfigArgs:
    def __init__(__self__, *,
                 cookie: Optional[pulumi.Input[str]] = None,
                 cookie_timeout: Optional[pulumi.Input[int]] = None,
                 sticky_session_enabled: Optional[pulumi.Input[str]] = None,
                 sticky_session_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cookie: The cookie name of the sticky session. This field is required when the value of the `sticky_session_type` is `server`.
        :param pulumi.Input[int] cookie_timeout: The cookie timeout of the sticky session. Unit: second. Valid value range in 1~86400. Default is 1000. This field is required when the value of the `sticky_session_type` is `insert`.
        :param pulumi.Input[str] sticky_session_enabled: The enable status of sticky session. Valid values: `on`, `off`. Default is `off`.
        :param pulumi.Input[str] sticky_session_type: The cookie handle type of the sticky session. Valid values: `insert`, `server`. Default is `insert`. This field is required when the value of the `sticky_session_enabled` is `on`.
        """
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if cookie_timeout is not None:
            pulumi.set(__self__, "cookie_timeout", cookie_timeout)
        if sticky_session_enabled is not None:
            pulumi.set(__self__, "sticky_session_enabled", sticky_session_enabled)
        if sticky_session_type is not None:
            pulumi.set(__self__, "sticky_session_type", sticky_session_type)

    @property
    @pulumi.getter
    def cookie(self) -> Optional[pulumi.Input[str]]:
        """
        The cookie name of the sticky session. This field is required when the value of the `sticky_session_type` is `server`.
        """
        return pulumi.get(self, "cookie")

    @cookie.setter
    def cookie(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie", value)

    @property
    @pulumi.getter(name="cookieTimeout")
    def cookie_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The cookie timeout of the sticky session. Unit: second. Valid value range in 1~86400. Default is 1000. This field is required when the value of the `sticky_session_type` is `insert`.
        """
        return pulumi.get(self, "cookie_timeout")

    @cookie_timeout.setter
    def cookie_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cookie_timeout", value)

    @property
    @pulumi.getter(name="stickySessionEnabled")
    def sticky_session_enabled(self) -> Optional[pulumi.Input[str]]:
        """
        The enable status of sticky session. Valid values: `on`, `off`. Default is `off`.
        """
        return pulumi.get(self, "sticky_session_enabled")

    @sticky_session_enabled.setter
    def sticky_session_enabled(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sticky_session_enabled", value)

    @property
    @pulumi.getter(name="stickySessionType")
    def sticky_session_type(self) -> Optional[pulumi.Input[str]]:
        """
        The cookie handle type of the sticky session. Valid values: `insert`, `server`. Default is `insert`. This field is required when the value of the `sticky_session_enabled` is `on`.
        """
        return pulumi.get(self, "sticky_session_type")

    @sticky_session_type.setter
    def sticky_session_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sticky_session_type", value)


