# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlbArgs', 'Alb']

@pulumi.input_type
class AlbArgs:
    def __init__(__self__, *,
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 type: pulumi.Input[str],
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 delete_protection: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_billing_config: Optional[pulumi.Input['AlbEipBillingConfigArgs']] = None,
                 ipv6_eip_billing_config: Optional[pulumi.Input['AlbIpv6EipBillingConfigArgs']] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AlbTagArgs']]]] = None):
        """
        The set of arguments for constructing a Alb resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The id of the Subnet.
        :param pulumi.Input[str] type: The type of the Alb. Valid values: `public`, `private`.
        :param pulumi.Input[str] address_ip_version: The address ip version of the Alb. Valid values: `IPv4`, `DualStack`. Default is `ipv4`.
        :param pulumi.Input[str] delete_protection: Whether to enable the delete protection function of the Alb. Valid values: `on`, `off`. Default is `off`.
        :param pulumi.Input[str] description: The description of the Alb.
        :param pulumi.Input['AlbEipBillingConfigArgs'] eip_billing_config: The billing configuration of the EIP which automatically associated to the Alb. This field is valid when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        :param pulumi.Input['AlbIpv6EipBillingConfigArgs'] ipv6_eip_billing_config: The billing configuration of the Ipv6 EIP which automatically associated to the Alb. This field is required when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        :param pulumi.Input[str] load_balancer_name: The name of the Alb.
        :param pulumi.Input[str] project_name: The ProjectName of the Alb.
        :param pulumi.Input[Sequence[pulumi.Input['AlbTagArgs']]] tags: Tags.
        """
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        pulumi.set(__self__, "type", type)
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_billing_config is not None:
            pulumi.set(__self__, "eip_billing_config", eip_billing_config)
        if ipv6_eip_billing_config is not None:
            pulumi.set(__self__, "ipv6_eip_billing_config", ipv6_eip_billing_config)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The id of the Subnet.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the Alb. Valid values: `public`, `private`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The address ip version of the Alb. Valid values: `IPv4`, `DualStack`. Default is `ipv4`.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_ip_version", value)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable the delete protection function of the Alb. Valid values: `on`, `off`. Default is `off`.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Alb.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipBillingConfig")
    def eip_billing_config(self) -> Optional[pulumi.Input['AlbEipBillingConfigArgs']]:
        """
        The billing configuration of the EIP which automatically associated to the Alb. This field is valid when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        """
        return pulumi.get(self, "eip_billing_config")

    @eip_billing_config.setter
    def eip_billing_config(self, value: Optional[pulumi.Input['AlbEipBillingConfigArgs']]):
        pulumi.set(self, "eip_billing_config", value)

    @property
    @pulumi.getter(name="ipv6EipBillingConfig")
    def ipv6_eip_billing_config(self) -> Optional[pulumi.Input['AlbIpv6EipBillingConfigArgs']]:
        """
        The billing configuration of the Ipv6 EIP which automatically associated to the Alb. This field is required when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        """
        return pulumi.get(self, "ipv6_eip_billing_config")

    @ipv6_eip_billing_config.setter
    def ipv6_eip_billing_config(self, value: Optional[pulumi.Input['AlbIpv6EipBillingConfigArgs']]):
        pulumi.set(self, "ipv6_eip_billing_config", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Alb.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the Alb.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AlbState:
    def __init__(__self__, *,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 delete_protection: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 eip_billing_config: Optional[pulumi.Input['AlbEipBillingConfigArgs']] = None,
                 ipv6_eip_billing_config: Optional[pulumi.Input['AlbIpv6EipBillingConfigArgs']] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 local_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['AlbTagArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['AlbZoneMappingArgs']]]] = None):
        """
        Input properties used for looking up and filtering Alb resources.
        :param pulumi.Input[str] address_ip_version: The address ip version of the Alb. Valid values: `IPv4`, `DualStack`. Default is `ipv4`.
        :param pulumi.Input[str] delete_protection: Whether to enable the delete protection function of the Alb. Valid values: `on`, `off`. Default is `off`.
        :param pulumi.Input[str] description: The description of the Alb.
        :param pulumi.Input[str] dns_name: The DNS name.
        :param pulumi.Input['AlbEipBillingConfigArgs'] eip_billing_config: The billing configuration of the EIP which automatically associated to the Alb. This field is valid when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        :param pulumi.Input['AlbIpv6EipBillingConfigArgs'] ipv6_eip_billing_config: The billing configuration of the Ipv6 EIP which automatically associated to the Alb. This field is required when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        :param pulumi.Input[str] load_balancer_name: The name of the Alb.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_addresses: The local addresses of the Alb.
        :param pulumi.Input[str] project_name: The ProjectName of the Alb.
        :param pulumi.Input[str] status: The status of the Alb.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The id of the Subnet.
        :param pulumi.Input[Sequence[pulumi.Input['AlbTagArgs']]] tags: Tags.
        :param pulumi.Input[str] type: The type of the Alb. Valid values: `public`, `private`.
        :param pulumi.Input[str] vpc_id: The vpc id of the Alb.
        :param pulumi.Input[Sequence[pulumi.Input['AlbZoneMappingArgs']]] zone_mappings: Configuration information of the Alb instance in different Availability Zones.
        """
        if address_ip_version is not None:
            pulumi.set(__self__, "address_ip_version", address_ip_version)
        if delete_protection is not None:
            pulumi.set(__self__, "delete_protection", delete_protection)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if eip_billing_config is not None:
            pulumi.set(__self__, "eip_billing_config", eip_billing_config)
        if ipv6_eip_billing_config is not None:
            pulumi.set(__self__, "ipv6_eip_billing_config", ipv6_eip_billing_config)
        if load_balancer_name is not None:
            pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if local_addresses is not None:
            pulumi.set(__self__, "local_addresses", local_addresses)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_mappings is not None:
            pulumi.set(__self__, "zone_mappings", zone_mappings)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> Optional[pulumi.Input[str]]:
        """
        The address ip version of the Alb. Valid values: `IPv4`, `DualStack`. Default is `ipv4`.
        """
        return pulumi.get(self, "address_ip_version")

    @address_ip_version.setter
    def address_ip_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address_ip_version", value)

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable the delete protection function of the Alb. Valid values: `on`, `off`. Default is `off`.
        """
        return pulumi.get(self, "delete_protection")

    @delete_protection.setter
    def delete_protection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_protection", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Alb.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The DNS name.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="eipBillingConfig")
    def eip_billing_config(self) -> Optional[pulumi.Input['AlbEipBillingConfigArgs']]:
        """
        The billing configuration of the EIP which automatically associated to the Alb. This field is valid when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        """
        return pulumi.get(self, "eip_billing_config")

    @eip_billing_config.setter
    def eip_billing_config(self, value: Optional[pulumi.Input['AlbEipBillingConfigArgs']]):
        pulumi.set(self, "eip_billing_config", value)

    @property
    @pulumi.getter(name="ipv6EipBillingConfig")
    def ipv6_eip_billing_config(self) -> Optional[pulumi.Input['AlbIpv6EipBillingConfigArgs']]:
        """
        The billing configuration of the Ipv6 EIP which automatically associated to the Alb. This field is required when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        """
        return pulumi.get(self, "ipv6_eip_billing_config")

    @ipv6_eip_billing_config.setter
    def ipv6_eip_billing_config(self, value: Optional[pulumi.Input['AlbIpv6EipBillingConfigArgs']]):
        pulumi.set(self, "ipv6_eip_billing_config", value)

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Alb.
        """
        return pulumi.get(self, "load_balancer_name")

    @load_balancer_name.setter
    def load_balancer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_name", value)

    @property
    @pulumi.getter(name="localAddresses")
    def local_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The local addresses of the Alb.
        """
        return pulumi.get(self, "local_addresses")

    @local_addresses.setter
    def local_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "local_addresses", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The ProjectName of the Alb.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Alb.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The id of the Subnet.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Alb. Valid values: `public`, `private`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc id of the Alb.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlbZoneMappingArgs']]]]:
        """
        Configuration information of the Alb instance in different Availability Zones.
        """
        return pulumi.get(self, "zone_mappings")

    @zone_mappings.setter
    def zone_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlbZoneMappingArgs']]]]):
        pulumi.set(self, "zone_mappings", value)


class Alb(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 delete_protection: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_billing_config: Optional[pulumi.Input[pulumi.InputType['AlbEipBillingConfigArgs']]] = None,
                 ipv6_eip_billing_config: Optional[pulumi.Input[pulumi.InputType['AlbIpv6EipBillingConfigArgs']]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlbTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage alb
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.zones()
        vpc_ipv6 = volcengine.vpc.Vpc("vpcIpv6",
            vpc_name="acc-test-vpc-ipv6",
            cidr_block="172.16.0.0/16",
            enable_ipv6=True)
        subnet_ipv61 = volcengine.vpc.Subnet("subnetIpv61",
            subnet_name="acc-test-subnet-ipv6-1",
            cidr_block="172.16.1.0/24",
            zone_id=foo.zones[0].id,
            vpc_id=vpc_ipv6.id,
            ipv6_cidr_block=1)
        subnet_ipv62 = volcengine.vpc.Subnet("subnetIpv62",
            subnet_name="acc-test-subnet-ipv6-2",
            cidr_block="172.16.2.0/24",
            zone_id=foo.zones[1].id,
            vpc_id=vpc_ipv6.id,
            ipv6_cidr_block=2)
        ipv6_gateway = volcengine.vpc.Ipv6Gateway("ipv6Gateway", vpc_id=vpc_ipv6.id)
        alb_private = volcengine.alb.Alb("alb-private",
            address_ip_version="IPv4",
            type="private",
            load_balancer_name="acc-test-alb-private",
            description="acc-test",
            subnet_ids=[
                subnet_ipv61.id,
                subnet_ipv62.id,
            ],
            project_name="default",
            delete_protection="off",
            tags=[volcengine.alb.AlbTagArgs(
                key="k1",
                value="v1",
            )])
        alb_public = volcengine.alb.Alb("alb-public",
            address_ip_version="DualStack",
            type="public",
            load_balancer_name="acc-test-alb-public",
            description="acc-test",
            subnet_ids=[
                subnet_ipv61.id,
                subnet_ipv62.id,
            ],
            project_name="default",
            delete_protection="off",
            eip_billing_config=volcengine.alb.AlbEipBillingConfigArgs(
                isp="BGP",
                eip_billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ),
            ipv6_eip_billing_config=volcengine.alb.AlbIpv6EipBillingConfigArgs(
                isp="BGP",
                billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ),
            tags=[volcengine.alb.AlbTagArgs(
                key="k1",
                value="v1",
            )],
            opts=pulumi.ResourceOptions(depends_on=[ipv6_gateway]))
        ```

        ## Import

        Alb can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/alb:Alb default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_ip_version: The address ip version of the Alb. Valid values: `IPv4`, `DualStack`. Default is `ipv4`.
        :param pulumi.Input[str] delete_protection: Whether to enable the delete protection function of the Alb. Valid values: `on`, `off`. Default is `off`.
        :param pulumi.Input[str] description: The description of the Alb.
        :param pulumi.Input[pulumi.InputType['AlbEipBillingConfigArgs']] eip_billing_config: The billing configuration of the EIP which automatically associated to the Alb. This field is valid when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        :param pulumi.Input[pulumi.InputType['AlbIpv6EipBillingConfigArgs']] ipv6_eip_billing_config: The billing configuration of the Ipv6 EIP which automatically associated to the Alb. This field is required when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        :param pulumi.Input[str] load_balancer_name: The name of the Alb.
        :param pulumi.Input[str] project_name: The ProjectName of the Alb.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The id of the Subnet.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlbTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] type: The type of the Alb. Valid values: `public`, `private`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlbArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage alb
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.zones()
        vpc_ipv6 = volcengine.vpc.Vpc("vpcIpv6",
            vpc_name="acc-test-vpc-ipv6",
            cidr_block="172.16.0.0/16",
            enable_ipv6=True)
        subnet_ipv61 = volcengine.vpc.Subnet("subnetIpv61",
            subnet_name="acc-test-subnet-ipv6-1",
            cidr_block="172.16.1.0/24",
            zone_id=foo.zones[0].id,
            vpc_id=vpc_ipv6.id,
            ipv6_cidr_block=1)
        subnet_ipv62 = volcengine.vpc.Subnet("subnetIpv62",
            subnet_name="acc-test-subnet-ipv6-2",
            cidr_block="172.16.2.0/24",
            zone_id=foo.zones[1].id,
            vpc_id=vpc_ipv6.id,
            ipv6_cidr_block=2)
        ipv6_gateway = volcengine.vpc.Ipv6Gateway("ipv6Gateway", vpc_id=vpc_ipv6.id)
        alb_private = volcengine.alb.Alb("alb-private",
            address_ip_version="IPv4",
            type="private",
            load_balancer_name="acc-test-alb-private",
            description="acc-test",
            subnet_ids=[
                subnet_ipv61.id,
                subnet_ipv62.id,
            ],
            project_name="default",
            delete_protection="off",
            tags=[volcengine.alb.AlbTagArgs(
                key="k1",
                value="v1",
            )])
        alb_public = volcengine.alb.Alb("alb-public",
            address_ip_version="DualStack",
            type="public",
            load_balancer_name="acc-test-alb-public",
            description="acc-test",
            subnet_ids=[
                subnet_ipv61.id,
                subnet_ipv62.id,
            ],
            project_name="default",
            delete_protection="off",
            eip_billing_config=volcengine.alb.AlbEipBillingConfigArgs(
                isp="BGP",
                eip_billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ),
            ipv6_eip_billing_config=volcengine.alb.AlbIpv6EipBillingConfigArgs(
                isp="BGP",
                billing_type="PostPaidByBandwidth",
                bandwidth=1,
            ),
            tags=[volcengine.alb.AlbTagArgs(
                key="k1",
                value="v1",
            )],
            opts=pulumi.ResourceOptions(depends_on=[ipv6_gateway]))
        ```

        ## Import

        Alb can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/alb:Alb default resource_id
        ```

        :param str resource_name: The name of the resource.
        :param AlbArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlbArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address_ip_version: Optional[pulumi.Input[str]] = None,
                 delete_protection: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_billing_config: Optional[pulumi.Input[pulumi.InputType['AlbEipBillingConfigArgs']]] = None,
                 ipv6_eip_billing_config: Optional[pulumi.Input[pulumi.InputType['AlbIpv6EipBillingConfigArgs']]] = None,
                 load_balancer_name: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlbTagArgs']]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlbArgs.__new__(AlbArgs)

            __props__.__dict__["address_ip_version"] = address_ip_version
            __props__.__dict__["delete_protection"] = delete_protection
            __props__.__dict__["description"] = description
            __props__.__dict__["eip_billing_config"] = eip_billing_config
            __props__.__dict__["ipv6_eip_billing_config"] = ipv6_eip_billing_config
            __props__.__dict__["load_balancer_name"] = load_balancer_name
            __props__.__dict__["project_name"] = project_name
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["dns_name"] = None
            __props__.__dict__["local_addresses"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["zone_mappings"] = None
        super(Alb, __self__).__init__(
            'volcengine:alb/alb:Alb',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address_ip_version: Optional[pulumi.Input[str]] = None,
            delete_protection: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            eip_billing_config: Optional[pulumi.Input[pulumi.InputType['AlbEipBillingConfigArgs']]] = None,
            ipv6_eip_billing_config: Optional[pulumi.Input[pulumi.InputType['AlbIpv6EipBillingConfigArgs']]] = None,
            load_balancer_name: Optional[pulumi.Input[str]] = None,
            local_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlbTagArgs']]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zone_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlbZoneMappingArgs']]]]] = None) -> 'Alb':
        """
        Get an existing Alb resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address_ip_version: The address ip version of the Alb. Valid values: `IPv4`, `DualStack`. Default is `ipv4`.
        :param pulumi.Input[str] delete_protection: Whether to enable the delete protection function of the Alb. Valid values: `on`, `off`. Default is `off`.
        :param pulumi.Input[str] description: The description of the Alb.
        :param pulumi.Input[str] dns_name: The DNS name.
        :param pulumi.Input[pulumi.InputType['AlbEipBillingConfigArgs']] eip_billing_config: The billing configuration of the EIP which automatically associated to the Alb. This field is valid when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        :param pulumi.Input[pulumi.InputType['AlbIpv6EipBillingConfigArgs']] ipv6_eip_billing_config: The billing configuration of the Ipv6 EIP which automatically associated to the Alb. This field is required when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        :param pulumi.Input[str] load_balancer_name: The name of the Alb.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_addresses: The local addresses of the Alb.
        :param pulumi.Input[str] project_name: The ProjectName of the Alb.
        :param pulumi.Input[str] status: The status of the Alb.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] subnet_ids: The id of the Subnet.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlbTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] type: The type of the Alb. Valid values: `public`, `private`.
        :param pulumi.Input[str] vpc_id: The vpc id of the Alb.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlbZoneMappingArgs']]]] zone_mappings: Configuration information of the Alb instance in different Availability Zones.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlbState.__new__(_AlbState)

        __props__.__dict__["address_ip_version"] = address_ip_version
        __props__.__dict__["delete_protection"] = delete_protection
        __props__.__dict__["description"] = description
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["eip_billing_config"] = eip_billing_config
        __props__.__dict__["ipv6_eip_billing_config"] = ipv6_eip_billing_config
        __props__.__dict__["load_balancer_name"] = load_balancer_name
        __props__.__dict__["local_addresses"] = local_addresses
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_mappings"] = zone_mappings
        return Alb(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="addressIpVersion")
    def address_ip_version(self) -> pulumi.Output[Optional[str]]:
        """
        The address ip version of the Alb. Valid values: `IPv4`, `DualStack`. Default is `ipv4`.
        """
        return pulumi.get(self, "address_ip_version")

    @property
    @pulumi.getter(name="deleteProtection")
    def delete_protection(self) -> pulumi.Output[Optional[str]]:
        """
        Whether to enable the delete protection function of the Alb. Valid values: `on`, `off`. Default is `off`.
        """
        return pulumi.get(self, "delete_protection")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the Alb.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The DNS name.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="eipBillingConfig")
    def eip_billing_config(self) -> pulumi.Output['outputs.AlbEipBillingConfig']:
        """
        The billing configuration of the EIP which automatically associated to the Alb. This field is valid when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `eip.Address` and `eip.Associate` to achieve public network access function.
        """
        return pulumi.get(self, "eip_billing_config")

    @property
    @pulumi.getter(name="ipv6EipBillingConfig")
    def ipv6_eip_billing_config(self) -> pulumi.Output['outputs.AlbIpv6EipBillingConfig']:
        """
        The billing configuration of the Ipv6 EIP which automatically associated to the Alb. This field is required when the type of the Alb is `public`.When the type of the Alb is `private`, suggest using a combination of resource `vpc.Ipv6Gateway` and `vpc.Ipv6AddressBandwidth` to achieve ipv6 public network access function.
        """
        return pulumi.get(self, "ipv6_eip_billing_config")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> pulumi.Output[str]:
        """
        The name of the Alb.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="localAddresses")
    def local_addresses(self) -> pulumi.Output[Sequence[str]]:
        """
        The local addresses of the Alb.
        """
        return pulumi.get(self, "local_addresses")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The ProjectName of the Alb.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Alb.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The id of the Subnet.
        """
        return pulumi.get(self, "subnet_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.AlbTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the Alb. Valid values: `public`, `private`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc id of the Alb.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneMappings")
    def zone_mappings(self) -> pulumi.Output[Sequence['outputs.AlbZoneMapping']]:
        """
        Configuration information of the Alb instance in different Availability Zones.
        """
        return pulumi.get(self, "zone_mappings")

