# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'AlbsResult',
    'AwaitableAlbsResult',
    'albs',
    'albs_output',
]

@pulumi.output_type
class AlbsResult:
    """
    A collection of values returned by Albs.
    """
    def __init__(__self__, albs=None, eni_address=None, id=None, ids=None, load_balancer_name=None, name_regex=None, output_file=None, project=None, tags=None, total_count=None, vpc_id=None):
        if albs and not isinstance(albs, list):
            raise TypeError("Expected argument 'albs' to be a list")
        pulumi.set(__self__, "albs", albs)
        if eni_address and not isinstance(eni_address, str):
            raise TypeError("Expected argument 'eni_address' to be a str")
        pulumi.set(__self__, "eni_address", eni_address)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if load_balancer_name and not isinstance(load_balancer_name, str):
            raise TypeError("Expected argument 'load_balancer_name' to be a str")
        pulumi.set(__self__, "load_balancer_name", load_balancer_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter
    def albs(self) -> Sequence['outputs.AlbsAlbResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "albs")

    @property
    @pulumi.getter(name="eniAddress")
    def eni_address(self) -> Optional[str]:
        """
        The Eni address of the Alb in this availability zone.
        """
        return pulumi.get(self, "eni_address")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="loadBalancerName")
    def load_balancer_name(self) -> Optional[str]:
        """
        The name of the Alb.
        """
        return pulumi.get(self, "load_balancer_name")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.AlbsTagResult']]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The vpc id of the Alb.
        """
        return pulumi.get(self, "vpc_id")


class AwaitableAlbsResult(AlbsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return AlbsResult(
            albs=self.albs,
            eni_address=self.eni_address,
            id=self.id,
            ids=self.ids,
            load_balancer_name=self.load_balancer_name,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project=self.project,
            tags=self.tags,
            total_count=self.total_count,
            vpc_id=self.vpc_id)


def albs(eni_address: Optional[str] = None,
         ids: Optional[Sequence[str]] = None,
         load_balancer_name: Optional[str] = None,
         name_regex: Optional[str] = None,
         output_file: Optional[str] = None,
         project: Optional[str] = None,
         tags: Optional[Sequence[pulumi.InputType['AlbsTagArgs']]] = None,
         vpc_id: Optional[str] = None,
         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableAlbsResult:
    """
    Use this data source to query detailed information of albs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.alb.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    subnet1 = volcengine.vpc.Subnet("subnet1",
        subnet_name="acc-test-subnet-1",
        cidr_block="172.16.1.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    subnet2 = volcengine.vpc.Subnet("subnet2",
        subnet_name="acc-test-subnet-2",
        cidr_block="172.16.2.0/24",
        zone_id=foo_zones.zones[1].id,
        vpc_id=foo_vpc.id)
    foo_alb = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_alb.append(volcengine.alb.Alb(f"fooAlb-{range['value']}",
            address_ip_version="IPv4",
            type="private",
            load_balancer_name=f"acc-test-alb-private-{range['value']}",
            description="acc-test",
            subnet_ids=[
                subnet1.id,
                subnet2.id,
            ],
            project_name="default",
            delete_protection="off",
            tags=[volcengine.alb.AlbTagArgs(
                key="k1",
                value="v1",
            )]))
    foo_albs = volcengine.alb.albs_output(ids=[__item.id for __item in foo_alb])
    ```


    :param str eni_address: The private ip address of the Alb.
    :param Sequence[str] ids: A list of Alb IDs.
    :param str load_balancer_name: The name of the Alb.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project: The project of the Alb.
    :param Sequence[pulumi.InputType['AlbsTagArgs']] tags: Tags.
    :param str vpc_id: The vpc id which Alb belongs to.
    """
    __args__ = dict()
    __args__['eniAddress'] = eni_address
    __args__['ids'] = ids
    __args__['loadBalancerName'] = load_balancer_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['project'] = project
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:alb/albs:Albs', __args__, opts=opts, typ=AlbsResult).value

    return AwaitableAlbsResult(
        albs=pulumi.get(__ret__, 'albs'),
        eni_address=pulumi.get(__ret__, 'eni_address'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        load_balancer_name=pulumi.get(__ret__, 'load_balancer_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project=pulumi.get(__ret__, 'project'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'))


@_utilities.lift_output_func(albs)
def albs_output(eni_address: Optional[pulumi.Input[Optional[str]]] = None,
                ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                load_balancer_name: Optional[pulumi.Input[Optional[str]]] = None,
                name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                output_file: Optional[pulumi.Input[Optional[str]]] = None,
                project: Optional[pulumi.Input[Optional[str]]] = None,
                tags: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['AlbsTagArgs']]]]] = None,
                vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[AlbsResult]:
    """
    Use this data source to query detailed information of albs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.alb.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    subnet1 = volcengine.vpc.Subnet("subnet1",
        subnet_name="acc-test-subnet-1",
        cidr_block="172.16.1.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    subnet2 = volcengine.vpc.Subnet("subnet2",
        subnet_name="acc-test-subnet-2",
        cidr_block="172.16.2.0/24",
        zone_id=foo_zones.zones[1].id,
        vpc_id=foo_vpc.id)
    foo_alb = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_alb.append(volcengine.alb.Alb(f"fooAlb-{range['value']}",
            address_ip_version="IPv4",
            type="private",
            load_balancer_name=f"acc-test-alb-private-{range['value']}",
            description="acc-test",
            subnet_ids=[
                subnet1.id,
                subnet2.id,
            ],
            project_name="default",
            delete_protection="off",
            tags=[volcengine.alb.AlbTagArgs(
                key="k1",
                value="v1",
            )]))
    foo_albs = volcengine.alb.albs_output(ids=[__item.id for __item in foo_alb])
    ```


    :param str eni_address: The private ip address of the Alb.
    :param Sequence[str] ids: A list of Alb IDs.
    :param str load_balancer_name: The name of the Alb.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project: The project of the Alb.
    :param Sequence[pulumi.InputType['AlbsTagArgs']] tags: Tags.
    :param str vpc_id: The vpc id which Alb belongs to.
    """
    ...
