# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CaCertificatesResult',
    'AwaitableCaCertificatesResult',
    'ca_certificates',
    'ca_certificates_output',
]

@pulumi.output_type
class CaCertificatesResult:
    """
    A collection of values returned by CaCertificates.
    """
    def __init__(__self__, ca_certificate_name=None, certificates=None, id=None, ids=None, name_regex=None, output_file=None, project_name=None, total_count=None):
        if ca_certificate_name and not isinstance(ca_certificate_name, str):
            raise TypeError("Expected argument 'ca_certificate_name' to be a str")
        pulumi.set(__self__, "ca_certificate_name", ca_certificate_name)
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="caCertificateName")
    def ca_certificate_name(self) -> Optional[str]:
        """
        The name of the CA certificate.
        """
        return pulumi.get(self, "ca_certificate_name")

    @property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.CaCertificatesCertificateResult']:
        """
        The collection of CA certificates query.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The ProjectName of the CA Certificate.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableCaCertificatesResult(CaCertificatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return CaCertificatesResult(
            ca_certificate_name=self.ca_certificate_name,
            certificates=self.certificates,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project_name=self.project_name,
            total_count=self.total_count)


def ca_certificates(ca_certificate_name: Optional[str] = None,
                    ids: Optional[Sequence[str]] = None,
                    name_regex: Optional[str] = None,
                    output_file: Optional[str] = None,
                    project_name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableCaCertificatesResult:
    """
    Use this data source to query detailed information of alb ca certificates
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.ca_certificates(ids=["cert-1iidd2r9ii0hs74adhfeodxo1"])
    ```


    :param str ca_certificate_name: The name of the CA certificate.
    :param Sequence[str] ids: A list of CA certificate IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the CA certificate.
    """
    __args__ = dict()
    __args__['caCertificateName'] = ca_certificate_name
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:alb/caCertificates:CaCertificates', __args__, opts=opts, typ=CaCertificatesResult).value

    return AwaitableCaCertificatesResult(
        ca_certificate_name=pulumi.get(__ret__, 'ca_certificate_name'),
        certificates=pulumi.get(__ret__, 'certificates'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(ca_certificates)
def ca_certificates_output(ca_certificate_name: Optional[pulumi.Input[Optional[str]]] = None,
                           ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                           output_file: Optional[pulumi.Input[Optional[str]]] = None,
                           project_name: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[CaCertificatesResult]:
    """
    Use this data source to query detailed information of alb ca certificates
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.alb.ca_certificates(ids=["cert-1iidd2r9ii0hs74adhfeodxo1"])
    ```


    :param str ca_certificate_name: The name of the CA certificate.
    :param Sequence[str] ids: A list of CA certificate IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of the CA certificate.
    """
    ...
