# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CertificateArgs', 'Certificate']

@pulumi.input_type
class CertificateArgs:
    def __init__(__self__, *,
                 private_key: pulumi.Input[str],
                 public_key: pulumi.Input[str],
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Certificate resource.
        :param pulumi.Input[str] private_key: The private key of the Certificate.
        :param pulumi.Input[str] public_key: The public key of the Certificate.
        :param pulumi.Input[str] certificate_name: The name of the Certificate.
        :param pulumi.Input[str] description: The description of the Certificate.
        :param pulumi.Input[str] project_name: The project name of the Certificate.
        """
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "public_key", public_key)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Input[str]:
        """
        The private key of the Certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Input[str]:
        """
        The public key of the Certificate.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Certificate.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Certificate.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the Certificate.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)


@pulumi.input_type
class _CertificateState:
    def __init__(__self__, *,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 certificate_type: Optional[pulumi.Input[str]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 domain_name: Optional[pulumi.Input[str]] = None,
                 expired_at: Optional[pulumi.Input[str]] = None,
                 listeners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Certificate resources.
        :param pulumi.Input[str] certificate_name: The name of the Certificate.
        :param pulumi.Input[str] certificate_type: The type of the Certificate.
        :param pulumi.Input[str] create_time: The create time of the Certificate.
        :param pulumi.Input[str] description: The description of the Certificate.
        :param pulumi.Input[str] domain_name: The domain name of the Certificate.
        :param pulumi.Input[str] expired_at: The expire time of the Certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] listeners: The ID list of the Listener.
        :param pulumi.Input[str] private_key: The private key of the Certificate.
        :param pulumi.Input[str] project_name: The project name of the Certificate.
        :param pulumi.Input[str] public_key: The public key of the Certificate.
        :param pulumi.Input[str] status: The status of the Certificate.
        """
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if certificate_type is not None:
            pulumi.set(__self__, "certificate_type", certificate_type)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if domain_name is not None:
            pulumi.set(__self__, "domain_name", domain_name)
        if expired_at is not None:
            pulumi.set(__self__, "expired_at", expired_at)
        if listeners is not None:
            pulumi.set(__self__, "listeners", listeners)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Certificate.
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_name", value)

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Certificate.
        """
        return pulumi.get(self, "certificate_type")

    @certificate_type.setter
    def certificate_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_type", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the Certificate.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Certificate.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name of the Certificate.
        """
        return pulumi.get(self, "domain_name")

    @domain_name.setter
    def domain_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_name", value)

    @property
    @pulumi.getter(name="expiredAt")
    def expired_at(self) -> Optional[pulumi.Input[str]]:
        """
        The expire time of the Certificate.
        """
        return pulumi.get(self, "expired_at")

    @expired_at.setter
    def expired_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expired_at", value)

    @property
    @pulumi.getter
    def listeners(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID list of the Listener.
        """
        return pulumi.get(self, "listeners")

    @listeners.setter
    def listeners(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "listeners", value)

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[str]]:
        """
        The private key of the Certificate.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_key", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the Certificate.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The public key of the Certificate.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Certificate.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Certificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage alb certificate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.Certificate("foo",
            description="test123",
            private_key="private key",
            public_key="public key")
        ```

        ## Import

        Certificate can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/certificate:Certificate default cert-2fe5k****c16o5oxruvtk3qf5
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_name: The name of the Certificate.
        :param pulumi.Input[str] description: The description of the Certificate.
        :param pulumi.Input[str] private_key: The private key of the Certificate.
        :param pulumi.Input[str] project_name: The project name of the Certificate.
        :param pulumi.Input[str] public_key: The public key of the Certificate.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage alb certificate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.alb.Certificate("foo",
            description="test123",
            private_key="private key",
            public_key="public key")
        ```

        ## Import

        Certificate can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:alb/certificate:Certificate default cert-2fe5k****c16o5oxruvtk3qf5
        ```

        :param str resource_name: The name of the resource.
        :param CertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 private_key: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateArgs.__new__(CertificateArgs)

            __props__.__dict__["certificate_name"] = certificate_name
            __props__.__dict__["description"] = description
            if private_key is None and not opts.urn:
                raise TypeError("Missing required property 'private_key'")
            __props__.__dict__["private_key"] = private_key
            __props__.__dict__["project_name"] = project_name
            if public_key is None and not opts.urn:
                raise TypeError("Missing required property 'public_key'")
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["certificate_type"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["domain_name"] = None
            __props__.__dict__["expired_at"] = None
            __props__.__dict__["listeners"] = None
            __props__.__dict__["status"] = None
        super(Certificate, __self__).__init__(
            'volcengine:alb/certificate:Certificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_name: Optional[pulumi.Input[str]] = None,
            certificate_type: Optional[pulumi.Input[str]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            domain_name: Optional[pulumi.Input[str]] = None,
            expired_at: Optional[pulumi.Input[str]] = None,
            listeners: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            private_key: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Certificate':
        """
        Get an existing Certificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_name: The name of the Certificate.
        :param pulumi.Input[str] certificate_type: The type of the Certificate.
        :param pulumi.Input[str] create_time: The create time of the Certificate.
        :param pulumi.Input[str] description: The description of the Certificate.
        :param pulumi.Input[str] domain_name: The domain name of the Certificate.
        :param pulumi.Input[str] expired_at: The expire time of the Certificate.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] listeners: The ID list of the Listener.
        :param pulumi.Input[str] private_key: The private key of the Certificate.
        :param pulumi.Input[str] project_name: The project name of the Certificate.
        :param pulumi.Input[str] public_key: The public key of the Certificate.
        :param pulumi.Input[str] status: The status of the Certificate.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateState.__new__(_CertificateState)

        __props__.__dict__["certificate_name"] = certificate_name
        __props__.__dict__["certificate_type"] = certificate_type
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["domain_name"] = domain_name
        __props__.__dict__["expired_at"] = expired_at
        __props__.__dict__["listeners"] = listeners
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["status"] = status
        return Certificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[str]:
        """
        The name of the Certificate.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="certificateType")
    def certificate_type(self) -> pulumi.Output[str]:
        """
        The type of the Certificate.
        """
        return pulumi.get(self, "certificate_type")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The create time of the Certificate.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Certificate.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="domainName")
    def domain_name(self) -> pulumi.Output[str]:
        """
        The domain name of the Certificate.
        """
        return pulumi.get(self, "domain_name")

    @property
    @pulumi.getter(name="expiredAt")
    def expired_at(self) -> pulumi.Output[str]:
        """
        The expire time of the Certificate.
        """
        return pulumi.get(self, "expired_at")

    @property
    @pulumi.getter
    def listeners(self) -> pulumi.Output[Sequence[str]]:
        """
        The ID list of the Listener.
        """
        return pulumi.get(self, "listeners")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[str]:
        """
        The private key of the Certificate.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name of the Certificate.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[str]:
        """
        The public key of the Certificate.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Certificate.
        """
        return pulumi.get(self, "status")

